/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    private static byte[] defaultMessage = new byte[]{-112, -1, 0};

    public ShortMessage() {
        this(defaultMessage);
    }

    protected ShortMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(int n2) throws InvalidMidiDataException {
        int n3 = this.getDataLength(n2);
        if (n3 != 0) {
            throw new InvalidMidiDataException("Status byte; " + n2 + " requires " + n3 + " data bytes");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(n2);
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMessage(int n2, int n3, int n4) throws InvalidMidiDataException {
        int n5 = this.getDataLength(n2);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(n2);
            if (n5 >= 1) {
                dataOutputStream.writeByte(n3);
            }
            if (n5 >= 2) {
                dataOutputStream.writeByte(n4);
            }
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setMessage(int n2, int n3, int n4, int n5) throws InvalidMidiDataException {
        int n6 = n2 & 0xF0 | n3 & 0xF;
        int n7 = this.getDataLength(n6);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(n6);
            if (n7 >= 1) {
                dataOutputStream.writeByte(n4);
            }
            if (n7 >= 2) {
                dataOutputStream.writeByte(n5);
            }
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getChannel() {
        int n2 = this.getStatus();
        return n2 & 0xF;
    }

    public int getCommand() {
        int n2 = this.getStatus();
        return n2 & 0xF0;
    }

    public int getData1() {
        int n2 = 0;
        try {
            int n3 = this.getStatus();
            int n4 = this.getDataLength(n3);
            if (n4 < 1) {
                // empty if block
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.skip(1L);
            n2 = dataInputStream.readUnsignedByte();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n2;
    }

    public int getData2() {
        int n2 = 0;
        try {
            int n3 = this.getStatus();
            int n4 = this.getDataLength(n3);
            if (n4 < 2) {
                // empty if block
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data, 0, this.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.skip(2L);
            n2 = dataInputStream.readUnsignedByte();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n2;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        ShortMessage shortMessage = new ShortMessage(byArray);
        return shortMessage;
    }

    protected final int getDataLength(int n2) throws InvalidMidiDataException {
        switch (n2) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return 0;
            }
            case 241: 
            case 243: {
                return 1;
            }
            case 242: {
                return 2;
            }
        }
        switch (n2 & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + n2);
    }
}

