/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private PlainSocketImpl impl = null;
    private byte[] temp;
    private Socket socket = null;
    private boolean closing = false;

    SocketInputStream(PlainSocketImpl plainSocketImpl) throws IOException {
        super(plainSocketImpl.getFileDescriptor());
        this.impl = plainSocketImpl;
        this.socket = plainSocketImpl.getSocket();
    }

    public final FileChannel getChannel() {
        return null;
    }

    private native int socketRead0(FileDescriptor var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.eof) {
            return -1;
        }
        if (n3 <= 0 || n2 < 0 || n2 + n3 > byArray.length) {
            if (n3 == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        FileDescriptor fileDescriptor = this.impl.acquireFD();
        try {
            n4 = this.socketRead0(fileDescriptor, byArray, n2, n3, this.impl.getTimeout());
            Object var7_6 = null;
            this.impl.releaseFD();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.impl.releaseFD();
            throw throwable;
        }
        if (n4 <= 0) {
            if (this.impl.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            this.eof = true;
            return -1;
        }
        return n4;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n2 = this.read(this.temp, 0, 1);
        if (n2 <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public long skip(long l2) throws IOException {
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = l2;
        int n2 = (int)Math.min(1024L, l3);
        byte[] byArray = new byte[n2];
        while (l3 > 0L) {
            int n3 = this.read(byArray, 0, (int)Math.min((long)n2, l3));
            if (n3 < 0) break;
            l3 -= (long)n3;
        }
        return l2 - l3;
    }

    public int available() throws IOException {
        return this.impl.available();
    }

    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    void setEOF(boolean bl2) {
        this.eof = bl2;
    }

    protected void finalize() {
    }

    private static native void init();

    static {
        SocketInputStream.init();
    }
}

