/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.BindingEnumeration;
import com.sun.jndi.dns.CT;
import com.sun.jndi.dns.DnsNameParser;
import com.sun.jndi.dns.NameClassPairEnumeration;
import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.Resolver;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.ZoneNode;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.DirectoryManager;

public class DnsContext
extends ComponentDirContext {
    String domain;
    Hashtable environment;
    private boolean envShared;
    private String[] servers;
    private Resolver resolver;
    private boolean authoritative;
    private boolean recursion;
    static final NameParser nameParser = new DnsNameParser();
    private CT lookupCT;
    private static final String LOOKUP_ATTR = "com.sun.jndi.dns.lookup.attr";
    private static final String RECURSION_ATTR = "com.sun.jndi.dns.recursion";
    private static final int ANY = 255;
    private static final ZoneNode zoneTree = new ZoneNode(null);
    public static boolean debug = false;

    public DnsContext(String string, String[] stringArray, Hashtable hashtable) throws NamingException {
        if (string.endsWith(".") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        } else if (string.equals("")) {
            string = ".";
        }
        this.domain = string;
        this.servers = stringArray;
        this.environment = (Hashtable)hashtable.clone();
        this.envShared = false;
        this.resolver = new Resolver(stringArray);
        this.lookupCT = this.getLookupCT((String)hashtable.get(LOOKUP_ATTR));
        this.authoritative = "true".equalsIgnoreCase((String)hashtable.get("java.naming.authoritative"));
        String string2 = (String)hashtable.get(RECURSION_ATTR);
        this.recursion = string2 == null || "true".equalsIgnoreCase(string2);
    }

    DnsContext(DnsContext dnsContext, String string) {
        this(dnsContext);
        this.domain = string;
    }

    private DnsContext(DnsContext dnsContext) {
        this.environment = dnsContext.environment;
        dnsContext.envShared = true;
        this.envShared = true;
        this.domain = dnsContext.domain;
        this.servers = dnsContext.servers;
        this.resolver = dnsContext.resolver;
        this.lookupCT = dnsContext.lookupCT;
        this.authoritative = dnsContext.authoritative;
        this.recursion = dnsContext.recursion;
    }

    public void close() {
    }

    protected Hashtable p_getEnvironment() {
        return this.environment;
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string.equals(LOOKUP_ATTR)) {
            this.lookupCT = this.getLookupCT((String)object);
        } else if (string.equals("java.naming.authoritative")) {
            this.authoritative = "true".equalsIgnoreCase((String)object);
        } else if (string.equals(RECURSION_ATTR)) {
            this.recursion = "true".equalsIgnoreCase((String)object);
        }
        if (!this.envShared) {
            return this.environment.put(string, object);
        }
        if (this.environment.get(string) != object) {
            this.environment = (Hashtable)this.environment.clone();
            this.envShared = false;
            return this.environment.put(string, object);
        }
        return object;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (string.equals(LOOKUP_ATTR)) {
            this.lookupCT = this.getLookupCT(null);
        } else if (string.equals("java.naming.authoritative")) {
            this.authoritative = false;
        } else if (string.equals(RECURSION_ATTR)) {
            this.recursion = true;
        }
        if (!this.envShared) {
            return this.environment.remove(string);
        }
        if (this.environment.get(string) != null) {
            this.environment = (Hashtable)this.environment.clone();
            this.envShared = false;
            return this.environment.remove(string);
        }
        return null;
    }

    private CT getLookupCT(String string) throws InvalidAttributeIdentifierException {
        return string == null ? new CT(1, 16) : DnsContext.fromAttrId(string);
    }

    public Object c_lookup(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        if (name.isEmpty()) {
            DnsContext dnsContext = new DnsContext(this);
            dnsContext.resolver = new Resolver(this.servers);
            return dnsContext;
        }
        try {
            String string = this.fullyQualify(name);
            ResourceRecords resourceRecords = this.resolver.query(string, this.lookupCT.rrclass, this.lookupCT.rrtype, this.recursion, this.authoritative);
            Attributes attributes = DnsContext.rrsToAttrs(resourceRecords, null);
            DnsContext dnsContext = new DnsContext(this, string);
            return DirectoryManager.getObjectInstance(dnsContext, name, this, this.environment, attributes);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            continuation.setError((Object)this, name);
            NamingException namingException = new NamingException("Problem generating object using object factory");
            namingException.setRootCause(exception);
            throw continuation.fillInException(namingException);
        }
    }

    public Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    public NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        try {
            String string = this.fullyQualify(name);
            NameNode nameNode = this.getNameNode(string);
            return new NameClassPairEnumeration(nameNode.getChildren());
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    public NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        try {
            String string = this.fullyQualify(name);
            NameNode nameNode = this.getNameNode(string);
            DnsContext dnsContext = new DnsContext(this, string);
            return new BindingEnumeration(dnsContext, nameNode.getChildren());
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    public void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_unbind(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return nameParser;
    }

    public void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        try {
            String string = this.fullyQualify(name);
            CT[] cTArray = DnsContext.attrIdsToClassesAndTypes(stringArray);
            CT cT = DnsContext.getClassAndTypeToQuery(cTArray);
            ResourceRecords resourceRecords = this.resolver.query(string, cT.rrclass, cT.rrtype, this.recursion, this.authoritative);
            return DnsContext.rrsToAttrs(resourceRecords, cTArray);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    public void c_modifyAttributes(Name name, int n2, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public String getNameInNamespace() {
        return this.domain;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return super.composeName(name, name2);
    }

    private String fullyQualify(Name name) throws NamingException {
        String string;
        if (name.isEmpty()) {
            return this.domain;
        }
        String string2 = string = name instanceof CompositeName ? name.get(0) : name.toString();
        if (string.endsWith(".")) {
            if (this.domain.equals(".")) {
                return string.equals(".") ? "." : string.substring(0, string.length() - 1);
            }
            throw new InvalidNameException("DNS name '" + string + "' not relative to " + this.domain);
        }
        if (this.domain.equals(".")) {
            return string;
        }
        return string + "." + this.domain;
    }

    private static Attributes rrsToAttrs(ResourceRecords resourceRecords, CT[] cTArray) {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        int n2 = 0;
        while (n2 < resourceRecords.answer.size()) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(n2);
            int n3 = resourceRecord.getType();
            int n4 = resourceRecord.getRrclass();
            if (DnsContext.classAndTypeMatch(n4, n3, cTArray)) {
                String string = DnsContext.toAttrId(n4, n3);
                Attribute attribute = basicAttributes.get(string);
                if (attribute == null) {
                    attribute = new BasicAttribute(string);
                    basicAttributes.put(attribute);
                }
                attribute.add(resourceRecord.getRdata());
            }
            ++n2;
        }
        return basicAttributes;
    }

    private static boolean classAndTypeMatch(int n2, int n3, CT[] cTArray) {
        if (cTArray == null) {
            return true;
        }
        int n4 = 0;
        while (n4 < cTArray.length) {
            boolean bl2;
            CT cT = cTArray[n4];
            boolean bl3 = cT.rrclass == 255 || cT.rrclass == n2;
            boolean bl4 = bl2 = cT.rrtype == 255 || cT.rrtype == n3;
            if (bl3 && bl2) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private static String toAttrId(int n2, int n3) {
        String string = ResourceRecord.getTypeName(n3);
        if (n2 != 1) {
            string = ResourceRecord.getRrclassName(n2) + " " + string;
        }
        return string;
    }

    private static CT fromAttrId(String string) throws InvalidAttributeIdentifierException {
        String string2;
        int n2;
        if (string.equals("")) {
            throw new InvalidAttributeIdentifierException("Attribute ID cannot be empty");
        }
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n2 = 1;
        } else {
            string2 = string.substring(0, n3);
            n2 = ResourceRecord.getRrclass(string2);
            if (n2 < 0) {
                throw new InvalidAttributeIdentifierException("Unknown resource record class '" + string2 + '\'');
            }
        }
        string2 = string.substring(n3 + 1);
        int n4 = ResourceRecord.getType(string2);
        if (n4 < 0) {
            throw new InvalidAttributeIdentifierException("Unknown resource record type '" + string2 + '\'');
        }
        return new CT(n2, n4);
    }

    private static CT[] attrIdsToClassesAndTypes(String[] stringArray) throws InvalidAttributeIdentifierException {
        if (stringArray == null) {
            return null;
        }
        CT[] cTArray = new CT[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            cTArray[n2] = DnsContext.fromAttrId(stringArray[n2]);
            ++n2;
        }
        return cTArray;
    }

    private static CT getClassAndTypeToQuery(CT[] cTArray) {
        int n2;
        int n3;
        if (cTArray == null) {
            n3 = 255;
            n2 = 255;
        } else if (cTArray.length == 0) {
            n3 = 1;
            n2 = 255;
        } else {
            n3 = cTArray[0].rrclass;
            n2 = cTArray[0].rrtype;
            int n4 = 1;
            while (n4 < cTArray.length) {
                if (n3 != cTArray[n4].rrclass) {
                    n3 = 255;
                }
                if (n2 != cTArray[n4].rrtype) {
                    n2 = 255;
                }
                ++n4;
            }
        }
        return new CT(n3, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameNode getNameNode(String string) throws NamingException {
        NameNode nameNode;
        NameNode nameNode2;
        Object object;
        ZoneNode zoneNode;
        DnsContext.dprint("getNameNode(" + string + ")");
        String[] stringArray = DnsContext.nameToLabels(string);
        ZoneNode zoneNode2 = zoneTree;
        synchronized (zoneNode2) {
            zoneNode = zoneTree.getDeepestPopulated(stringArray);
        }
        DnsContext.dprint("Deepest related zone in zone tree: " + (zoneNode != null ? zoneNode.getLabel() : "[none]"));
        if (zoneNode != null) {
            object = zoneNode;
            synchronized (object) {
                nameNode2 = this.isZoneCurrent(zoneNode) ? zoneNode.getContents() : null;
            }
            if (nameNode2 != null && (nameNode = nameNode2.get(stringArray, zoneNode.depth())) != null && !nameNode.isZoneCut()) {
                DnsContext.dprint("Found node " + nameNode.getLabel() + " in zone tree");
                return nameNode;
            }
        }
        object = this.resolver.findZoneName(string, 1, this.recursion);
        DnsContext.dprint("Node's zone is " + (String)object);
        String[] stringArray2 = DnsContext.nameToLabels((String)object);
        ZoneNode zoneNode3 = zoneTree;
        synchronized (zoneNode3) {
            zoneNode = (ZoneNode)zoneTree.add(stringArray2, 0);
        }
        ZoneNode zoneNode4 = zoneNode;
        synchronized (zoneNode4) {
            nameNode2 = zoneNode.getContents();
            if (nameNode2 == null || !this.isZoneCurrent(zoneNode)) {
                nameNode2 = this.populateZone(zoneNode, (String)object, stringArray2);
            }
        }
        nameNode = nameNode2.get(stringArray, zoneNode.depth());
        if (nameNode == null) {
            throw new ConfigurationException("DNS error: node not found in its own zone");
        }
        DnsContext.dprint("Found node in newly-populated zone");
        return nameNode;
    }

    private NameNode populateZone(ZoneNode zoneNode, String string, String[] stringArray) throws NamingException {
        DnsContext.dprint("Populating zone " + string);
        ResourceRecords resourceRecords = this.resolver.queryZone(string, 1, this.recursion);
        DnsContext.dprint("zone xfer complete: " + resourceRecords.answer.size() + " records");
        return zoneNode.populate(stringArray, resourceRecords);
    }

    private boolean isZoneCurrent(ZoneNode zoneNode) {
        return !zoneNode.isExpired();
    }

    private static String[] nameToLabels(String string) throws NamingException {
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        Name name = nameParser.parse(string);
        String[] stringArray = new String[name.size()];
        int n2 = 0;
        while (n2 < name.size()) {
            stringArray[n2] = name.get(n2);
            ++n2;
        }
        return stringArray;
    }

    private static final void dprint(String string) {
        if (debug) {
            System.err.println("** " + string);
        }
    }
}

