Name: brltty
Version: 4.0
Release: 1

Group: System Environment/Daemons
License: GPL
Vendor: The BRLTTY Team
Packager: Dave Mielke <dave@mielke.cc>
URL: http://mielke.cc/brltty/
Source: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz

BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: /bin/sh
BuildRequires: /bin/ln
BuildRequires: /usr/bin/ld
BuildRequires: /sbin/ldconfig
BuildRequires: /usr/bin/ranlib
BuildRequires: /usr/bin/ar
BuildRequires: /usr/bin/awk
BuildRequires: /usr/bin/bison
BuildRequires: /usr/bin/install
BuildRequires: glibc-devel
BuildRequires: Pyrex
BuildRequires: tcl
BuildRequires: gcc-java

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc

AutoProv: 1

AutoReq: 1
Requires: /bin/sh

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.

%package -n brlapi
Version: 0.5.3
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.

%package -n brlapi-caml
Version: 0.5.3
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Caml bindings for BrlAPI.
%description -n brlapi-caml
This package provides the Caml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Caml application
which directly accesses a refreshable braille display.

%package -n brlapi-java
Version: 0.5.3
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.

%package -n brlapi-python
Version: 0.5.3
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.

%package -n brlapi-tcl
Version: 0.5.3
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.

%package -n brlapi-devel
Version: 0.5.3
Group: Development/System
License: LGPL

AutoProv: 1

AutoReq: 1
Requires: brlapi = 0.5.3

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.

%prep
# %setup -n %{name}-%{version}
%setup -n brltty-4.0

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-flite --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --without-curses --without-x --with-braille-driver=-tt
make

directory="doc"
mkdir -p "${directory}"
for file in `find . \( -path "./${directory}" -o -path ./Documents \) -prune -o \( -name 'README*' -o -name '*.patch' -o -name '*.txt' -o -name '*.html' -o -name '*.sgml' -o \( -path "./Bootdisks/*" -type f -perm +ugo=x \) \) -print`
do
   mkdir -p "${directory}/${file%/*}"
   cp -rp "${file}" "${directory}/${file}"
done

%install
make install
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"

%clean
rm -fr "${RPM_BUILD_ROOT}"

%files
%defattr(-,root,root)
%{_bindir}/brltty
%{_bindir}/brltty-*
%{_bindir}/vstp
%{_libdir}/brltty
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/*
%doc Documents/Manual-BRLTTY/English/*.{sgml,txt,html}
%doc LICENSE-GPL
%doc Documents/ChangeLog Documents/TODO
%doc doc/*
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%{_bindir}/xbrlapi
%doc Documents/Manual-BrlAPI/English/*.{sgml,txt,html}

%files -n brlapi-caml
/usr/lib/ocaml/brlapi
/usr/lib/ocaml/stublibs/dllbrlapi_stubs.*

%files -n brlapi-java
/usr/share/java/*
/usr/lib/java/*

%files -n brlapi-python
/usr/lib/python2.4/site-packages/[bB]rlapi[-.]*

%files -n brlapi-tcl
/usr/lib/brlapi-0.5.3/libbrlapi_tcl.so
/usr/lib/brlapi-0.5.3/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%{_includedir}/brltty
%doc %{_mandir}/man3/*
%doc Documents/BrlAPIref

%changelog
* Fri May 15 2009 Dave Mielke <dave@mielke.cc> 4.0
+  General Changes:
      All screen reading, character handling, and tables are now Unicode-based.
      The "<n> startup problems" message has been removed.
      Boot operands may contain multiple items separated by plus signs.
      USB enhancements and fixes.
      Windows serial I/O fixes.
      A UDEV rules file for brltty is provided.
      An upstart job for brltty is provided.
+  Status Cells:
      Hard-coded styles have been replaced by user-configurable fields.
      If there are no status cells then a text region may be reserved for them.
      The INFO command toggles text maximization if a text region is being used.
+  Braille Drivers:
      The Pegasus and Seika braille drivers have been added.
      The BrailleSense braille driver has been renamed to HIMS.
+  Alva Braille Driver:
      The BC6nn series are supported.
+  Baum Braille Driver:
      The VarioConnect, EcoVario, VarioPro, and Refreshabraille are supported.
+  BrailleNote Braille Driver:
      The statuscells= parameter has been removed.
+  EuroBraille Braille Driver:
      USB support has been added.
      Robustness has been improved.
      Bindings for the Esys have been added.
+  FreedomScientific Braille Driver:
      The statuscells= parameter has been removed.
+  HandyTech Braille Driver:
      The Evolution models have been redefined to only have text cells.
+  HIMS Braille Driver:
      The Braille Sense key bindings have been reworked.
      SyncBraille support has been added.
      Bluetooth support has been fixed.
+  TSI Braille Driver:
      The way Seika devices implement PowerBraille emulation is supported.
      The core's flow control mechanism is used (rather than hard-coded delays).
+  Voyager Braille Driver:
      The statuscells= parameter has been removed.
      Key binding changes:
         CUTAPPEND/CUTLINE moved to CRt# + B/C
         PRINDENT/NXINDENT moved to CRt# + A+B/C+D
+  XWindow Braille Driver:
      The font= parameter has been added.
+  SpeechDispatcher Speech Driver:
      Single characters are now spoken correctly.
+  BrlAPI Server:
      The version has been changed from 0.5.2 to 0.5.3.
      enterTtyMode() now works correctly on Windows.
      Problems when no braille display is connected at startup have been resolved.
      The core's output is automatically restored when the last client disconnects.
      Writes to the driver are no longer buffered.
      Braille keyboard input is now converted to characters.
      Output to the braille display is now drained the same way the core does.
+  Lisp Bindings:
      Now compatible with CFFI 0.10.0.
+  Text Tables:
      The license has been changed from GPL to LGPL.
      File names have been changed from "text.*.tbl" to "*.ttb".
      The file extension ".tti" is used for text subtables.
      Tables must be encoded in UTF-8 (rather than in a local character set).
      The "byte" keyword is no longer optional.
      The "dot" directive is no longer supported.
      The "char" and "include" directives have been added.
      Language-based tables include common representations for box characters.
      Tables for several languages have been added.
      The default is now to select the table based on the locale's name.
      The tbltest utility has been renamed to ttbtest.
      The compress, fi2, identity, and simple tables have been removed.
      The following tables have been renamed (mostly for ISO 639 compliance):
         cz     -> cs
         fi1    -> fi
         nabcc  -> en-nabcc
         se     -> sv
         se-old -> sv-1989
         visiob -> fr-vs
         vni    -> vi
+  Attributes Tables:
      The license has been changed from GPL to LGPL.
      File names have been changed from "attr*.tbl" to "*.atb".
      The file extension ".ati" is used for attributes subtables.
      Tables must be encoded in UTF-8 (rather than in Latin1).
      The "byte" directive is no longer supported.
      The "include" directive has been added.
+  Contraction Tables:
      The license has been changed from GPL to LGPL.
      Tables for several languages have been added.
      The following tables have been renamed:
         en-uebc-g2 -> en-ueb-g2
      The en-ueb-g2, en-us-g2, and zh-tw tables have been updated.
+  Key tables (for binding keyboard keys to brltty commands) have been added:
      The file extension ".ktb" is used for key tables.
      The file extension ".kti" is used for key subtables.
      The desktop, keypad, and laptop key tables are provided.
      the -k [--key-table=] option has been added.
      The -K [--keyboard-properties=] option has been added.
+  Source Tree Changes:
      The text tables have been moved from BrailleTables/ to Tables/.
      The attributes tables have been moved from BrailleTables/ to Tables/.
      The contraction tables have been moved from ContractionTables/ to Tables/.
      The braille drivers have been moved from BrailleDrivers/ to Drivers/Braille/.
      The speech drivers have been moved from SpeechDrivers/ to Drivers/Speech/.
      The screen drivers have been moved from ScreenDrivers/ to Drivers/Screen/.
      Source for the Windows installer is provided.

