/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;

public class CertPathValidator {
    private static final String CERT_PATH_VALIDATOR = "CertPathValidator";
    private final CertPathValidatorSpi validatorSpi;
    private final Provider provider;
    private final String algorithm;

    protected CertPathValidator(CertPathValidatorSpi certPathValidatorSpi, Provider provider, String string) {
        this.validatorSpi = certPathValidatorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static synchronized String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(null){
            private /* synthetic */ CertPathValidator this$0;
            {
                this.this$0 = certPathValidator;
            }

            public Object run() {
                return Security.getProperty("certpathvalidator.type");
            }
        });
        if (string == null) {
            string = "PKIX";
        }
        return string;
    }

    public static CertPathValidator getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return CertPathValidator.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static CertPathValidator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return CertPathValidator.getInstance(string, provider);
    }

    public static CertPathValidator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        try {
            return new CertPathValidator((CertPathValidatorSpi)Engine.getInstance(CERT_PATH_VALIDATOR, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathValidatorResult validate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        return this.validatorSpi.engineValidate(certPath, certPathParameters);
    }
}

