/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParameters {
    private static final String ALGORITHM_PARAMETERS = "AlgorithmParameters";
    private AlgorithmParametersSpi paramSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameters(AlgorithmParametersSpi algorithmParametersSpi, Provider provider, String string) {
        this.paramSpi = algorithmParametersSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameters getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return AlgorithmParameters.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static AlgorithmParameters getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return AlgorithmParameters.getInstance(string, provider);
    }

    public static AlgorithmParameters getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new AlgorithmParameters((AlgorithmParametersSpi)Engine.getInstance(ALGORITHM_PARAMETERS, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(algorithmParameterSpec);
    }

    public final void init(byte[] byArray) throws IOException {
        this.paramSpi.engineInit(byArray);
    }

    public final void init(byte[] byArray, String string) throws IOException {
        this.paramSpi.engineInit(byArray, string);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class clazz) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(clazz);
    }

    public final byte[] getEncoded() throws IOException {
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String string) throws IOException {
        return this.paramSpi.engineGetEncoded(string);
    }

    public final String toString() {
        return this.paramSpi.engineToString();
    }
}

