/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.MathContext;

public class BigDecimal
extends Number
implements Comparable {
    private BigInteger intVal;
    private int scale;
    private int precision;
    private static final long serialVersionUID = 6108874887143696463L;
    public static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO, 0);
    public static final BigDecimal ONE = new BigDecimal(BigInteger.ONE, 0);
    public static final BigDecimal TEN = new BigDecimal(BigInteger.TEN, 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    private /* synthetic */ void finit$() {
        this.precision = 0;
    }

    public BigDecimal(int n) {
        this.finit$();
        this.intVal = BigInteger.valueOf(n);
        this.scale = 0;
    }

    public BigDecimal(int n, MathContext mathContext) {
        this(n);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(long l) {
        this.finit$();
        this.intVal = BigInteger.valueOf(l);
        this.scale = 0;
    }

    public BigDecimal(long l, MathContext mathContext) {
        this(l);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this(bigInteger, 0);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(string);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(BigInteger bigInteger) {
        this(bigInteger, 0);
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        this.finit$();
        this.intVal = bigInteger;
        this.scale = n;
    }

    public BigDecimal(BigInteger bigInteger, int n, MathContext mathContext) {
        this(bigInteger, n);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(double d, MathContext mathContext) {
        this(d);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(double d) throws NumberFormatException {
        this.finit$();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException("invalid argument: " + d);
        }
        int n = 52;
        int n2 = 11;
        long l = (1L << (n & 0x3F)) - 1L;
        long l2 = (1L << (n2 & 0x3F)) - 1L;
        long l3 = Double.doubleToLongBits(d);
        long l4 = l3 & l;
        long l5 = l3 >>> (n & 0x3F) & l2;
        boolean bl = l5 == 0L;
        l5 -= bl ? (long)1022 : (long)1023;
        l5 -= (long)n;
        if (!bl) {
            l4 |= 1L << (n & 0x3F);
        }
        while (l5 < 0L && (l4 & 1L) == 0L) {
            ++l5;
            l4 >>= 1;
        }
        this.intVal = BigInteger.valueOf(l3 < 0L ? -l4 : l4);
        if (l5 < 0L) {
            this.scale = -((int)l5);
            BigInteger bigInteger = BigInteger.valueOf(5).pow(this.scale);
            this.intVal = this.intVal.multiply(bigInteger);
        } else {
            this.intVal = this.intVal.shiftLeft((int)l5);
            this.scale = 0;
        }
    }

    public BigDecimal(char[] cArray, int n, int n2, MathContext mathContext) {
        this(cArray, n, n2);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length);
        if (mathContext.getPrecision() != 0) {
            BigDecimal bigDecimal = this.round(mathContext);
            this.intVal = bigDecimal.intVal;
            this.scale = bigDecimal.scale;
            this.precision = bigDecimal.precision;
        }
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public BigDecimal(char[] cArray, int n, int n2) {
        this.finit$();
        int n3 = n;
        int n4 = n + n2;
        int n5 = n;
        int n6 = -1;
        boolean bl = false;
        if (cArray[n] == '+') {
            ++n3;
            ++n5;
        } else if (cArray[n] == '-') {
            ++n3;
            ++n5;
            bl = true;
        }
        while (n5 < n4) {
            char c = cArray[n5];
            if (c == '.') {
                if (n6 != -1) {
                    throw new NumberFormatException("multiple `.'s in number");
                }
                n6 = n5;
            } else {
                if (c == 'e' || c == 'E') break;
                if (!Character.isDigit(c)) {
                    throw new NumberFormatException("unrecognized character at " + n5 + ": " + c);
                }
            }
            ++n5;
        }
        StringBuilder stringBuilder = new StringBuilder(n5 - n3 - 1);
        if (n6 != -1) {
            stringBuilder.append(cArray, n3, n6 - n3);
            stringBuilder.append(cArray, n6 + 1, n5 - n6 - 1);
            this.scale = n5 - 1 - n6;
        } else {
            stringBuilder.append(cArray, n3, n5 - n3);
            this.scale = 0;
        }
        if (stringBuilder.length() == 0) {
            throw new NumberFormatException("no digits seen");
        }
        if (bl) {
            stringBuilder.insert(0, '-');
        }
        this.intVal = new BigInteger(stringBuilder.toString());
        if (n5 < n4) {
            if (cArray[++n5] == '+') {
                ++n5;
            }
            if (n5 >= n4) {
                throw new NumberFormatException("no exponent following e or E");
            }
            try {
                this.scale -= Integer.parseInt(new String(cArray, n5, n4 - n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("malformed exponent");
            }
        }
    }

    public BigDecimal(String string) throws NumberFormatException {
        String string2;
        this.finit$();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        if (string.charAt(0) == '+') {
            ++n2;
            ++n3;
        } else if (string.charAt(0) == '-') {
            ++n2;
            ++n3;
            bl = true;
        }
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '.') {
                if (n4 >= 0) {
                    throw new NumberFormatException("multiple `.'s in number");
                }
                n4 = n3;
            } else {
                if (c == 'e' || c == 'E') break;
                if (Character.digit(c, 10) < 0) {
                    throw new NumberFormatException("unrecognized character: " + c);
                }
            }
            ++n3;
        }
        if (n4 >= 0) {
            string2 = string.substring(n2, n4) + string.substring(n4 + 1, n3);
            this.scale = n3 - 1 - n4;
        } else {
            string2 = string.substring(n2, n3);
            this.scale = 0;
        }
        if (string2.length() == 0) {
            throw new NumberFormatException("no digits seen");
        }
        if (bl) {
            string2 = "-" + string2;
        }
        this.intVal = new BigInteger(string2);
        if (n3 < n) {
            if (string.charAt(++n3) == '+') {
                ++n3;
            }
            if (n3 >= n) {
                throw new NumberFormatException("no exponent following e or E");
            }
            try {
                this.scale -= Integer.parseInt(string.substring(n3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("malformed exponent");
            }
        }
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l, 0);
    }

    public static BigDecimal valueOf(long l, int n) throws NumberFormatException {
        if (n == 0 && (long)((int)l) == l) {
            switch ((int)l) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
        }
        return new BigDecimal(BigInteger.valueOf(l), n);
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigInteger bigInteger = this.intVal;
        BigInteger bigInteger2 = bigDecimal.intVal;
        if (this.scale < bigDecimal.scale) {
            bigInteger = bigInteger.multiply(BigInteger.TEN.pow(bigDecimal.scale - this.scale));
        } else if (this.scale > bigDecimal.scale) {
            bigInteger2 = bigInteger2.multiply(BigInteger.TEN.pow(this.scale - bigDecimal.scale));
        }
        return new BigDecimal(bigInteger.add(bigInteger2), Math.max(this.scale, bigDecimal.scale));
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        return this.add(bigDecimal).round(mathContext);
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        return this.add(bigDecimal.negate());
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        return this.subtract(bigDecimal).round(mathContext);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        return new BigDecimal(this.intVal.multiply(bigDecimal.intVal), this.scale + bigDecimal.scale);
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        return this.multiply(bigDecimal).round(mathContext);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) throws ArithmeticException, IllegalArgumentException {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) throws ArithmeticException, IllegalArgumentException {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("illegal rounding mode: " + n2);
        }
        if (this.intVal.signum() == 0) {
            if (n == 0) {
                return ZERO;
            }
            return new BigDecimal(BigDecimal.ZERO.intVal, n);
        }
        BigInteger bigInteger = bigDecimal.intVal;
        int n3 = n - (this.scale - bigDecimal.scale);
        if (n3 < 0) {
            bigInteger = bigInteger.multiply(BigInteger.TEN.pow(-n3));
            n3 = 0;
        }
        BigInteger bigInteger2 = this.intVal.multiply(BigInteger.TEN.pow(n3));
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger);
        BigInteger bigInteger3 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() == 0) {
            return new BigDecimal(bigInteger3, n);
        }
        if (n2 == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int n4 = this.intVal.signum() * bigInteger.signum();
        if (n2 == 2) {
            n2 = n4 > 0 ? 0 : 1;
        } else if (n2 == 3) {
            n2 = n4 < 0 ? 0 : 1;
        } else {
            BigInteger bigInteger4 = bigIntegerArray[1].signum() < 0 ? bigIntegerArray[1].negate() : bigIntegerArray[1];
            bigInteger = bigInteger.signum() < 0 ? bigInteger.negate() : bigInteger;
            int n5 = bigInteger4.shiftLeft(1).compareTo(bigInteger);
            switch (n2) {
                case 4: {
                    n2 = n5 < 0 ? 1 : 0;
                    break;
                }
                case 5: {
                    n2 = n5 > 0 ? 0 : 1;
                    break;
                }
                case 6: {
                    n2 = n5 < 0 ? 1 : (n5 > 0 ? 0 : (bigInteger3.testBit(0) ? 0 : 1));
                }
            }
        }
        if (n2 == 0) {
            bigInteger3 = bigInteger3.add(BigInteger.valueOf(n4 > 0 ? 1L : (long)-1));
        }
        return new BigDecimal(bigInteger3, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal) throws ArithmeticException, IllegalArgumentException {
        return this.divide(bigDecimal, this.scale, 7);
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        return this.subtract(this.divideToIntegralValue(bigDecimal).multiply(bigDecimal));
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        return this.divide(bigDecimal, 1).floor().setScale(this.scale - bigDecimal.scale, 1);
    }

    private BigDecimal floor() {
        if (this.scale <= 0) {
            return this;
        }
        String string = this.intVal.toString();
        string = string.substring(0, string.length() - this.scale);
        this.intVal = new BigInteger(string).multiply(BigInteger.TEN.pow(this.scale));
        return this;
    }

    public int compareTo(Object object) {
        return this.compareTo((BigDecimal)object);
    }

    public int compareTo(BigDecimal bigDecimal) {
        BigInteger[] bigIntegerArray;
        if (this.scale == bigDecimal.scale) {
            return this.intVal.compareTo(bigDecimal.intVal);
        }
        BigInteger[] bigIntegerArray2 = this.intVal.divideAndRemainder(BigInteger.TEN.pow(this.scale));
        int n = bigIntegerArray2[0].compareTo((bigIntegerArray = bigDecimal.intVal.divideAndRemainder(BigInteger.TEN.pow(bigDecimal.scale)))[0]);
        if (n != 0) {
            return n;
        }
        if (this.scale < bigDecimal.scale) {
            bigIntegerArray2[1] = bigIntegerArray2[1].multiply(BigInteger.valueOf(10).pow(bigDecimal.scale - this.scale));
        } else if (this.scale > bigDecimal.scale) {
            bigIntegerArray[1] = bigIntegerArray[1].multiply(BigInteger.valueOf(10).pow(this.scale - bigDecimal.scale));
        }
        return bigIntegerArray2[1].compareTo(bigIntegerArray[1]);
    }

    public boolean equals(Object object) {
        return object instanceof BigDecimal && this.scale == ((BigDecimal)object).scale && this.compareTo((BigDecimal)object) == 0;
    }

    public int hashCode() {
        return this.intValue() ^ this.scale;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        if (this.compareTo(bigDecimal) == 1) {
            return this;
        }
        return bigDecimal;
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        if (this.compareTo(bigDecimal) == -1) {
            return this;
        }
        return bigDecimal;
    }

    public BigDecimal movePointLeft(int n) {
        if (n < 0) {
            return this.movePointRight(-n);
        }
        return new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale >= n) {
            return new BigDecimal(this.intVal, this.scale - n);
        }
        return new BigDecimal(this.intVal.multiply(BigInteger.TEN.pow(n - this.scale)), 0);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public BigDecimal abs() {
        return new BigDecimal(this.intVal.abs(), this.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public BigDecimal negate(MathContext mathContext) {
        BigDecimal bigDecimal = this.negate();
        if (mathContext.getPrecision() != 0) {
            bigDecimal = bigDecimal.round(mathContext);
        }
        return bigDecimal;
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mathContext) {
        return this.round(mathContext);
    }

    public BigDecimal round(MathContext mathContext) {
        int n = mathContext.getPrecision();
        int n2 = this.precision() - n;
        if (n == 0 || n2 <= 0) {
            return this;
        }
        BigDecimal bigDecimal = new BigDecimal(BigInteger.TEN.pow(n2));
        BigDecimal bigDecimal2 = this.divide(bigDecimal, this.scale, 4);
        bigDecimal2.scale -= n2;
        bigDecimal2.precision = n;
        return bigDecimal2;
    }

    public int precision() {
        if (this.precision == 0) {
            String string = this.intVal.toString();
            this.precision = string.length() - (string.charAt(0) == '-' ? 1 : 0);
        }
        return this.precision;
    }

    public String toString() {
        String string = this.intVal.toString();
        if (this.scale == 0) {
            return string;
        }
        boolean bl = string.charAt(0) == '-';
        int n = string.length() - this.scale - (bl ? 1 : 0);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scale >= 0 && n - 1 >= -6) {
            if (n <= 0) {
                if (bl) {
                    stringBuilder.append('-');
                }
                stringBuilder.append('0').append('.');
                while (n < 0) {
                    stringBuilder.append('0');
                    ++n;
                }
                stringBuilder.append(string.substring(bl ? 1 : 0));
            } else {
                stringBuilder.append(string);
                stringBuilder.insert(n + (bl ? 1 : 0), '.');
            }
        } else {
            stringBuilder.append(string);
            if (string.length() > 1) {
                stringBuilder.insert(bl ? 2 : 1, '.');
            }
            stringBuilder.append('E');
            if (n - 1 >= 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n - 1);
        }
        return stringBuilder.toString();
    }

    public String toEngineeringString() {
        String string = this.intVal.toString();
        if (this.scale == 0) {
            return string;
        }
        boolean bl = string.charAt(0) == '-';
        int n = string.length() - this.scale - (bl ? 1 : 0);
        int n2 = n - 1;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scale >= 0 && n2 >= -6) {
            if (n <= 0) {
                if (bl) {
                    stringBuilder.append('-');
                }
                stringBuilder.append('0').append('.');
                while (n < 0) {
                    stringBuilder.append('0');
                    ++n;
                }
                stringBuilder.append(string.substring(bl ? 1 : 0));
            } else {
                stringBuilder.append(string);
                stringBuilder.insert(n + (bl ? 1 : 0), '.');
            }
        } else {
            stringBuilder.append(string);
            int n3 = n2 % 3;
            int n4 = 1;
            if (n2 > 0) {
                n4 += n3;
                n2 -= n3;
            } else if (n3 == -2) {
                ++n4;
                --n2;
            } else if (n3 == -1) {
                n4 += 2;
                n2 -= 2;
            }
            if (n4 > stringBuilder.length()) {
                while (n4 > stringBuilder.length()) {
                    stringBuilder.append('0');
                }
            } else if (string.length() > n4) {
                stringBuilder.insert(n4 + (bl ? 1 : 0), '.');
            }
            stringBuilder.append('E');
            if (n2 >= 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public String toPlainString() {
        String string = this.intVal.toString();
        if (this.scale == 0) {
            return string;
        }
        boolean bl = string.charAt(0) == '-';
        int n = string.length() - this.scale - (bl ? 1 : 0);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2 + (n <= 0 ? -n + 1 : 0));
        if (n <= 0) {
            if (bl) {
                stringBuffer.append('-');
            }
            stringBuffer.append('0').append('.');
            while (n < 0) {
                stringBuffer.append('0');
                ++n;
            }
            stringBuffer.append(string.substring(bl ? 1 : 0));
        } else if (n < string.length()) {
            stringBuffer.append(string);
            stringBuffer.insert(n + (bl ? 1 : 0), '.');
        } else {
            stringBuffer.append(string);
            for (int i = string.length(); i < n; ++i) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale > 0) {
            return this.intVal.divide(BigInteger.TEN.pow(this.scale));
        }
        if (this.scale < 0) {
            return this.intVal.multiply(BigInteger.TEN.pow(-this.scale));
        }
        return this.intVal;
    }

    public BigInteger toBigIntegerExact() {
        if (this.scale > 0) {
            BigInteger[] bigIntegerArray = this.intVal.divideAndRemainder(BigInteger.TEN.pow(this.scale));
            if (bigIntegerArray[1].equals(BigInteger.ZERO)) {
                return bigIntegerArray[0];
            }
            throw new ArithmeticException("No exact BigInteger representation");
        }
        if (this.scale < 0) {
            return this.intVal.multiply(BigInteger.TEN.pow(-this.scale));
        }
        return this.intVal;
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public BigDecimal stripTrailingZeros() {
        String string = this.intVal.toString();
        int n = this.scale;
        int n2 = string.length() - 1;
        while (string.charAt(n2) == '0') {
            --n2;
            --n;
        }
        BigDecimal bigDecimal = new BigDecimal(string.substring(0, n2 + 1));
        bigDecimal.scale = n;
        return bigDecimal;
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal setScale(int n) throws ArithmeticException {
        return this.setScale(n, 7);
    }

    public BigDecimal setScale(int n, int n2) throws ArithmeticException, IllegalArgumentException {
        if (n < 0) {
            throw new ArithmeticException("Scale parameter < 0.");
        }
        return this.divide(ONE, n, n2);
    }

    public static BigDecimal valueOf(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException("argument cannot be NaN or infinite.");
        }
        return new BigDecimal(Double.toString(d));
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.scale - n);
        bigDecimal.precision = this.precision;
        return bigDecimal;
    }

    public BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("n must be between 0 and 999999999");
        }
        BigDecimal bigDecimal = new BigDecimal(this.intVal.pow(n), this.scale * n);
        return bigDecimal;
    }

    public BigDecimal pow(int n, MathContext mathContext) {
        return this.pow(n).round(mathContext);
    }

    public BigDecimal abs(MathContext mathContext) {
        BigDecimal bigDecimal = this.abs();
        bigDecimal = bigDecimal.round(mathContext);
        return bigDecimal;
    }

    public BigDecimal ulp() {
        return new BigDecimal(BigInteger.ONE, this.scale);
    }

    public long longValueExact() {
        BigDecimal bigDecimal = this.setScale(0, 7);
        BigInteger bigInteger = bigDecimal.intVal;
        long l = this.intVal.longValue();
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 1 || l < 0L && this.signum() == 1 || l > 0L && this.signum() == -1) {
            throw new ArithmeticException("this BigDecimal is too large to fit into the return type");
        }
        return this.intVal.longValue();
    }

    public int intValueExact() {
        long l = this.longValueExact();
        int n = (int)l;
        if ((long)n != l) {
            throw new ArithmeticException("this BigDecimal cannot fit into an int");
        }
        return n;
    }

    public byte byteValueExact() {
        long l = this.longValueExact();
        byte by = (byte)l;
        if ((long)by != l) {
            throw new ArithmeticException("this BigDecimal cannot fit into a byte");
        }
        return by;
    }

    public short shortValueExact() {
        long l = this.longValueExact();
        short s = (short)l;
        if ((long)s != l) {
            throw new ArithmeticException("this BigDecimal cannot fit into a short");
        }
        return s;
    }
}

