/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.ls.ReaderInputStream;
import gnu.xml.transform.ErrorListenerErrorHandler;
import gnu.xml.transform.URIResolverEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XSLURIResolver
implements URIResolver {
    Map lastModifiedCache;
    Map nodeCache;
    DocumentBuilder builder;
    URIResolver userResolver;
    ErrorListener userListener;

    private /* synthetic */ void finit$() {
        this.lastModifiedCache = new HashMap();
        this.nodeCache = new HashMap();
    }

    void setUserResolver(URIResolver uRIResolver) {
        this.userResolver = uRIResolver;
    }

    void setUserListener(ErrorListener errorListener) {
        this.userListener = errorListener;
    }

    void flush() {
        this.lastModifiedCache.clear();
        this.nodeCache.clear();
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Source source = null;
        if (this.userResolver != null) {
            source = this.userResolver.resolve(string2, string);
        }
        return this.resolveDOM(source, string, string2);
    }

    DOMSource resolveDOM(Source source, String string, String string2) throws TransformerException {
        if (source != null && source instanceof DOMSource) {
            return (DOMSource)source;
        }
        String string3 = source == null ? null : source.getSystemId();
        long l = 0L;
        long l2 = 0L;
        try {
            Object object;
            Object object2;
            URL uRL = this.resolveURL(string3, string, string2);
            Node node2 = null;
            InputStream inputStream = null;
            if (source instanceof StreamSource && (inputStream = ((StreamSource)(object2 = (StreamSource)source)).getInputStream()) == null && (object = ((StreamSource)object2).getReader()) != null) {
                inputStream = new ReaderInputStream((Reader)object);
            }
            if (inputStream == null) {
                if (uRL != null) {
                    string3 = uRL.toString();
                    node2 = (Node)this.nodeCache.get(string3);
                    object2 = uRL.openConnection();
                    object = (Long)this.lastModifiedCache.get(string3);
                    if (object != null) {
                        l2 = (Long)object;
                        ((URLConnection)object2).setIfModifiedSince(l2);
                    }
                    ((URLConnection)object2).connect();
                    l = ((URLConnection)object2).getLastModified();
                    if (node2 != null && l > 0L && l <= l2) {
                        return new DOMSource(node2, string3);
                    }
                    inputStream = ((URLConnection)object2).getInputStream();
                    this.nodeCache.put(string3, node2);
                    this.lastModifiedCache.put(string3, new Long(l));
                } else {
                    throw new TransformerException("can't resolve URL: " + string3);
                }
            }
            object2 = new InputSource(inputStream);
            ((InputSource)object2).setSystemId(string3);
            object = this.getDocumentBuilder();
            node2 = ((DocumentBuilder)object).parse((InputSource)object2);
            return new DOMSource(node2, string3);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    URL resolveURL(String string, String string2, String string3) throws IOException {
        URL uRL = null;
        try {
            if (string != null) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                if (string2 != null) {
                    URL uRL2 = new URL(string2);
                    uRL = new URL(uRL2, string3);
                } else if (string3 != null) {
                    uRL = new URL(string3);
                } else {
                    throw new MalformedURLException(string);
                }
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            File file = null;
            if (string3 == null) {
                string3 = string;
            }
            if (string2 != null) {
                int n = string2.lastIndexOf(File.separatorChar);
                if (n != -1 && n < string2.length() - 1) {
                    string2 = string2.substring(0, n);
                }
                File file2 = new File(string2);
                file = new File(file2, string3);
            } else if (string3 != null) {
                file = new File(string3);
            }
            if (file == null) {
                return null;
            }
            return file.toURL();
        }
    }

    DocumentBuilder getDocumentBuilder() throws TransformerException {
        try {
            if (this.builder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setExpandEntityReferences(true);
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            if (this.userResolver != null) {
                this.builder.setEntityResolver(new URIResolverEntityResolver(this.userResolver));
            }
            if (this.userListener != null) {
                this.builder.setErrorHandler(new ErrorListenerErrorHandler(this.userListener));
            }
            return this.builder;
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    XSLURIResolver() {
        this.finit$();
    }
}

