/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.Registry;
import gnu.java.security.util.Util;
import gnu.javax.crypto.key.srp6.SRPAlgorithm;
import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.UserAlreadyExistsException;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PasswordFile {
    private static final String USER_FIELD = "user";
    private static final String VERIFIERS_FIELD = "verifier";
    private static final String SALT_FIELD = "salt";
    private static final String CONFIG_FIELD = "config";
    private static String DEFAULT_FILE;
    private static final HashMap srps;
    private String confName;
    private String pwName;
    private String pw2Name;
    private File configFile;
    private File passwdFile;
    private File passwd2File;
    private long lastmodPasswdFile;
    private long lastmodPasswd2File;
    private HashMap entries;
    private HashMap configurations;
    private static final BigInteger[] Nsrp;

    private /* synthetic */ void finit$() {
        this.entries = new HashMap();
        this.configurations = new HashMap();
    }

    public PasswordFile() throws IOException {
        this(DEFAULT_FILE);
    }

    public PasswordFile(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public PasswordFile(String string) throws IOException {
        this(string, string + "2", string + ".conf");
    }

    public PasswordFile(String string, String string2) throws IOException {
        this(string, string + "2", string2);
    }

    public PasswordFile(String string, String string2, String string3) throws IOException {
        this.finit$();
        this.pwName = string;
        this.pw2Name = string2;
        this.confName = string3;
        this.readOrCreateConf();
        this.update();
    }

    private static final String nameToID(String string) {
        if (Registry.SHA_HASH.equalsIgnoreCase(string) || Registry.SHA1_HASH.equalsIgnoreCase(string) || Registry.SHA160_HASH.equalsIgnoreCase(string)) {
            return "0";
        }
        if (Registry.MD5_HASH.equalsIgnoreCase(string)) {
            return "1";
        }
        if (Registry.RIPEMD128_HASH.equalsIgnoreCase(string)) {
            return "2";
        }
        if (Registry.RIPEMD160_HASH.equalsIgnoreCase(string)) {
            return "3";
        }
        if (Registry.SHA256_HASH.equalsIgnoreCase(string)) {
            return "4";
        }
        if (Registry.SHA384_HASH.equalsIgnoreCase(string)) {
            return "5";
        }
        if (Registry.SHA512_HASH.equalsIgnoreCase(string)) {
            return "6";
        }
        return "0";
    }

    public synchronized boolean containsConfig(String string) throws IOException {
        this.checkCurrent();
        return this.configurations.containsKey(string);
    }

    public synchronized String[] lookupConfig(String string) throws IOException {
        this.checkCurrent();
        String[] stringArray = null;
        if (this.configurations.containsKey(string)) {
            stringArray = (String[])this.configurations.get(string);
        }
        return stringArray;
    }

    public synchronized boolean contains(String string) throws IOException {
        this.checkCurrent();
        return this.entries.containsKey(string);
    }

    public synchronized void add(String string, String string2, byte[] byArray, String string3) throws IOException {
        this.checkCurrent();
        if (this.entries.containsKey(string)) {
            throw new UserAlreadyExistsException(string);
        }
        HashMap hashMap = new HashMap(4);
        hashMap.put(USER_FIELD, string);
        hashMap.put(VERIFIERS_FIELD, this.newVerifiers(string, byArray, string2, string3));
        hashMap.put(SALT_FIELD, Util.toBase64(byArray));
        hashMap.put(CONFIG_FIELD, string3);
        this.entries.put(string, hashMap);
        this.savePasswd();
    }

    public synchronized void changePasswd(String string, String string2) throws IOException {
        byte[] byArray;
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        HashMap hashMap = (HashMap)this.entries.get(string);
        try {
            byArray = Util.fromBase64((String)hashMap.get(SALT_FIELD));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Password file corrupt");
        }
        String string3 = (String)hashMap.get(CONFIG_FIELD);
        hashMap.put(VERIFIERS_FIELD, this.newVerifiers(string, byArray, string2, string3));
        this.entries.put(string, hashMap);
        this.savePasswd();
    }

    public synchronized void savePasswd() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.passwdFile);
        FileOutputStream fileOutputStream2 = new FileOutputStream(this.passwd2File);
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            printWriter = new PrintWriter(fileOutputStream, true);
            printWriter2 = new PrintWriter(fileOutputStream2, true);
            this.writePasswd(printWriter, printWriter2);
        }
        finally {
            IOException iOException2;
            Object var5_5 = null;
            if (printWriter != null) {
                try {
                    printWriter.flush();
                }
                finally {
                    iOException2 = null;
                    printWriter.close();
                }
            }
            if (printWriter2 != null) {
                try {
                    printWriter2.flush();
                }
                finally {
                    iOException2 = null;
                    printWriter2.close();
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException2) {}
            try {
                fileOutputStream2.close();
            }
            catch (IOException iOException2) {}
        }
        this.lastmodPasswdFile = this.passwdFile.lastModified();
        this.lastmodPasswd2File = this.passwd2File.lastModified();
    }

    public synchronized String[] lookup(String string, String string2) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        HashMap hashMap = (HashMap)this.entries.get(string);
        HashMap hashMap2 = (HashMap)hashMap.get(VERIFIERS_FIELD);
        String string3 = (String)hashMap.get(SALT_FIELD);
        String string4 = (String)hashMap.get(CONFIG_FIELD);
        String string5 = (String)hashMap2.get(PasswordFile.nameToID(string2));
        return new String[]{string5, string3, string4};
    }

    private synchronized void readOrCreateConf() throws IOException {
        this.configurations.clear();
        this.configFile = new File(this.confName);
        try {
            FileInputStream fileInputStream = new FileInputStream(this.configFile);
            this.readConf(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = Util.toBase64(Util.trim(new BigInteger("2")));
            for (int i = 0; i < Nsrp.length; ++i) {
                String string2 = String.valueOf(i + 1);
                String string3 = Util.toBase64(Util.trim(Nsrp[i]));
                this.configurations.put(string2, new String[]{string3, string});
            }
            FileOutputStream fileOutputStream = null;
            PrintWriter printWriter = null;
            try {
                fileOutputStream = new FileOutputStream(this.configFile);
                printWriter = new PrintWriter(fileOutputStream, true);
                this.writeConf(printWriter);
            }
            finally {
                Object var8_9 = null;
                if (printWriter != null) {
                    printWriter.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
    }

    private void readConf(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            try {
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SRP password configuration file corrupt");
            }
            this.configurations.put(string4, new String[]{string3, string2});
        }
    }

    private void writeConf(PrintWriter printWriter) {
        Iterator iterator = this.configurations.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = (String[])this.configurations.get(string);
            StringBuffer stringBuffer = new StringBuffer(string).append(":").append(stringArray[0]).append(":").append(stringArray[1]);
            printWriter.println(stringBuffer.toString());
        }
    }

    private HashMap newVerifiers(String string, byte[] byArray, String string2, String string3) throws UnsupportedEncodingException {
        String[] stringArray = (String[])this.configurations.get(string3);
        BigInteger bigInteger = new BigInteger(1, Util.fromBase64(stringArray[0]));
        BigInteger bigInteger2 = new BigInteger(1, Util.fromBase64(stringArray[1]));
        HashMap hashMap = new HashMap(srps.size());
        for (int i = 0; i < srps.size(); ++i) {
            String string4 = String.valueOf(i);
            SRP sRP = (SRP)srps.get(string4);
            BigInteger bigInteger3 = new BigInteger(1, sRP.computeX(byArray, string, string2));
            BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
            String string5 = Util.toBase64(bigInteger4.toByteArray());
            hashMap.put(string4, string5);
        }
        return hashMap;
    }

    private synchronized void update() throws IOException {
        FileInputStream fileInputStream;
        this.entries.clear();
        this.passwdFile = new File(this.pwName);
        this.lastmodPasswdFile = this.passwdFile.lastModified();
        try {
            fileInputStream = new FileInputStream(this.passwdFile);
            this.readPasswd(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.passwd2File = new File(this.pw2Name);
        this.lastmodPasswd2File = this.passwd2File.lastModified();
        try {
            fileInputStream = new FileInputStream(this.passwd2File);
            this.readPasswd2(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void checkCurrent() throws IOException {
        if (this.passwdFile.lastModified() > this.lastmodPasswdFile || this.passwd2File.lastModified() > this.lastmodPasswd2File) {
            this.update();
        }
    }

    private void readPasswd(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            try {
                string5 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SRP base password file corrupt");
            }
            HashMap hashMap = new HashMap(6);
            hashMap.put("0", string4);
            HashMap hashMap2 = new HashMap(4);
            hashMap2.put(USER_FIELD, string5);
            hashMap2.put(VERIFIERS_FIELD, hashMap);
            hashMap2.put(SALT_FIELD, string3);
            hashMap2.put(CONFIG_FIELD, string2);
            this.entries.put(string5, hashMap2);
        }
    }

    private void readPasswd2(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            try {
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SRP extended password file corrupt");
            }
            HashMap hashMap = (HashMap)this.entries.get(string3);
            if (hashMap == null) continue;
            HashMap hashMap2 = (HashMap)hashMap.get(VERIFIERS_FIELD);
            hashMap2.put(string4, string2);
        }
    }

    private void writePasswd(PrintWriter printWriter, PrintWriter printWriter2) throws IOException {
        Iterator iterator = this.entries.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            String string = (String)iterator.next();
            if (!string.equals((hashMap = (HashMap)this.entries.get(string)).get(USER_FIELD))) {
                throw new IOException("Inconsistent SRP password data");
            }
            HashMap hashMap2 = (HashMap)hashMap.get(VERIFIERS_FIELD);
            StringBuffer stringBuffer = new StringBuffer(string).append(":").append((String)hashMap2.get("0")).append(":").append((String)hashMap.get(SALT_FIELD)).append(":").append((String)hashMap.get(CONFIG_FIELD));
            printWriter.println(stringBuffer.toString());
            Iterator iterator2 = hashMap2.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if ("0".equals(string2)) continue;
                StringBuffer stringBuffer2 = new StringBuffer(string2).append(":").append(string).append(":").append((String)hashMap2.get(string2));
                printWriter2.println(stringBuffer2.toString());
            }
        }
    }

    static {
        USER_FIELD = USER_FIELD;
        VERIFIERS_FIELD = VERIFIERS_FIELD;
        SALT_FIELD = SALT_FIELD;
        CONFIG_FIELD = CONFIG_FIELD;
        DEFAULT_FILE = System.getProperty("gnu.crypto.sasl.srp.password.file", "/etc/tpasswd");
        HashMap hashMap = new HashMap(SRPRegistry.SRP_ALGORITHMS.length);
        hashMap.put("0", SRP.instance(SRPRegistry.SRP_ALGORITHMS[0]));
        for (int i = 1; i < SRPRegistry.SRP_ALGORITHMS.length; ++i) {
            try {
                hashMap.put(String.valueOf(i), SRP.instance(SRPRegistry.SRP_ALGORITHMS[i]));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Ignored: " + exception);
                exception.printStackTrace(System.err);
            }
        }
        srps = hashMap;
        Nsrp = new BigInteger[]{SRPAlgorithm.N_2048, SRPAlgorithm.N_1536, SRPAlgorithm.N_1280, SRPAlgorithm.N_1024, SRPAlgorithm.N_768, SRPAlgorithm.N_640, SRPAlgorithm.N_512};
    }
}

