/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.BrlAPI;

import org.a11y.BrlAPI.ConnectionSettings;
import org.a11y.BrlAPI.Constants;
import org.a11y.BrlAPI.DisplaySize;
import org.a11y.BrlAPI.Error;
import org.a11y.BrlAPI.Native;

public class Brlapi
extends Native
implements Constants {
    protected final ConnectionSettings settings = new ConnectionSettings();
    protected final int fileDescriptor;

    public Brlapi(ConnectionSettings connectionSettings) throws Error {
        this.fileDescriptor = this.openConnection(connectionSettings, this.settings);
    }

    protected void finalize() {
        this.closeConnection();
    }

    public String getHost() {
        return this.settings.host;
    }

    public String getAuth() {
        return this.settings.auth;
    }

    public int getFileDescriptor() {
        return this.fileDescriptor;
    }

    public int enterTtyMode(int n) throws Error {
        return this.enterTtyMode(n, null);
    }

    public int enterTtyMode(String string) throws Error {
        return this.enterTtyMode(-1, string);
    }

    public int enterTtyMode() throws Error {
        return this.enterTtyMode(null);
    }

    public void enterTtyModeWithPath(int[] nArray) throws Error {
        this.enterTtyModeWithPath(nArray, null);
    }

    public void writeText(int n) throws Error {
        this.writeText(n, null);
    }

    public void writeText(String string) throws Error {
        this.writeText(0, string);
    }

    public void writeText(String string, int n) throws Error {
        this.writeText(n, string);
    }

    public void writeText(int n, String string) throws Error {
        if (string != null) {
            DisplaySize displaySize = this.getDisplaySize();
            int n2 = displaySize.getWidth() * displaySize.getHeight();
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.length() < n2) {
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
            string = string.substring(0, n2);
        }
        this.writeTextNative(n, string);
    }
}

