#!/bin/sh
if [ ! -e var/log/httpd ]; then
  mkdir -p var/log/httpd
  chmod 755 var/log/httpd
fi

# Don't wipe out an existing document root:
if [ ! -L srv/www -a -d srv/www ]; then
  mv srv/www srv/www.bak.$$
fi
if [ ! -L srv/httpd -a -d srv/httpd ]; then
  mv srv/httpd srv/httpd.bak.$$
fi

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
# Keep same perms on rc.httpd.new:
if [ -e etc/rc.d/rc.httpd ]; then
  cp -a etc/rc.d/rc.httpd etc/rc.d/rc.httpd.new.incoming
  cat etc/rc.d/rc.httpd.new > etc/rc.d/rc.httpd.new.incoming
  mv etc/rc.d/rc.httpd.new.incoming etc/rc.d/rc.httpd.new
fi
config etc/rc.d/rc.httpd.new
config etc/httpd/httpd.conf.new
config etc/logrotate.d/httpd.new
for conf_file in etc/httpd/extra/*.new; do
  config $conf_file
done
( cd srv ; rm -rf www )
( cd srv ; ln -sf /var/www www )
( cd srv ; rm -rf httpd )
( cd srv ; ln -sf /var/www httpd )
