/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import sun.security.validator.EndEntityChecker;
import sun.security.validator.KeyStores;
import sun.security.validator.PKIXValidator;
import sun.security.validator.SimpleValidator;

public abstract class Validator {
    static final X509Certificate[] CHAIN0 = new X509Certificate[0];
    public static final String TYPE_SIMPLE = "Simple";
    public static final String TYPE_PKIX = "PKIX";
    public static final String VAR_GENERIC = "generic";
    public static final String VAR_CODE_SIGNING = "code signing";
    public static final String VAR_JCE_SIGNING = "jce signing";
    public static final String VAR_TLS_CLIENT = "tls client";
    public static final String VAR_TLS_SERVER = "tls server";
    final EndEntityChecker endEntityChecker;
    final String variant;
    @Deprecated
    volatile Date validationDate;

    Validator(String string, String string2) {
        this.variant = string2;
        this.endEntityChecker = EndEntityChecker.getInstance(string, string2);
    }

    public static Validator getInstance(String string, String string2, KeyStore keyStore) {
        return Validator.getInstance(string, string2, KeyStores.getTrustedCerts(keyStore));
    }

    public static Validator getInstance(String string, String string2, Collection collection) {
        if (string.equals(TYPE_SIMPLE)) {
            return new SimpleValidator(string2, collection);
        }
        if (string.equals(TYPE_PKIX)) {
            return new PKIXValidator(string2, collection);
        }
        throw new IllegalArgumentException("Unknown validator type: " + string);
    }

    public static Validator getInstance(String string, String string2, PKIXBuilderParameters pKIXBuilderParameters) {
        if (!string.equals(TYPE_PKIX)) {
            throw new IllegalArgumentException("getInstance(PKIXBuilderParameters) can only be used with PKIX validator");
        }
        return new PKIXValidator(string2, pKIXBuilderParameters);
    }

    public final X509Certificate[] validate(X509Certificate[] x509CertificateArray) throws CertificateException {
        return this.validate(x509CertificateArray, null, null);
    }

    public final X509Certificate[] validate(X509Certificate[] x509CertificateArray, Collection collection) throws CertificateException {
        return this.validate(x509CertificateArray, collection, null);
    }

    public final X509Certificate[] validate(X509Certificate[] x509CertificateArray, Collection collection, Object object) throws CertificateException {
        if ((x509CertificateArray = this.engineValidate(x509CertificateArray, collection, object)).length > 1) {
            this.endEntityChecker.check(x509CertificateArray[0], object);
        }
        return x509CertificateArray;
    }

    abstract X509Certificate[] engineValidate(X509Certificate[] var1, Collection var2, Object var3) throws CertificateException;

    public abstract Collection getTrustedCertificates();

    @Deprecated
    public void setValidationDate(Date date) {
        this.validationDate = date;
    }
}

