/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.ETypeInfo;
import sun.security.krb5.internal.ETypeInfo2;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBError {
    private int pvno;
    private int msgType;
    private KerberosTime cTime;
    private Integer cuSec;
    private KerberosTime sTime;
    private Integer suSec;
    private int errorCode;
    private Realm crealm;
    private PrincipalName cname;
    private Realm realm;
    private PrincipalName sname;
    private String eText;
    private byte[] eData;
    private Checksum eCksum;
    private int etype = 0;
    private byte[] salt = null;
    private byte[] s2kparams = null;
    private boolean DEBUG = Krb5.DEBUG;

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n, KerberosTime kerberosTime2, Integer n2, int n3, Realm realm, PrincipalName principalName, Realm realm2, PrincipalName principalName2, String string, byte[] byArray) {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n;
        this.sTime = kerberosTime2;
        this.suSec = n2;
        this.errorCode = n3;
        this.crealm = realm;
        this.cname = principalName;
        this.realm = realm2;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
    }

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n, KerberosTime kerberosTime2, Integer n2, int n3, Realm realm, PrincipalName principalName, Realm realm2, PrincipalName principalName2, String string, byte[] byArray, Checksum checksum) {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n;
        this.sTime = kerberosTime2;
        this.suSec = n2;
        this.errorCode = n3;
        this.crealm = realm;
        this.cname = principalName;
        this.realm = realm2;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
        this.eCksum = checksum;
    }

    public KRBError(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(byArray));
    }

    public KRBError(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(derValue);
        if (this.DEBUG) {
            System.out.println(">>>KRBError:");
            if (this.cTime != null) {
                System.out.println("\t cTime is " + this.cTime.toDate().toString() + " " + this.cTime.toDate().getTime());
            }
            if (this.cuSec != null) {
                System.out.println("\t cuSec is " + this.cuSec);
            }
            System.out.println("\t sTime is " + this.sTime.toDate().toString() + " " + this.sTime.toDate().getTime());
            System.out.println("\t suSec is " + this.suSec);
            System.out.println("\t error code is " + this.errorCode);
            System.out.println("\t error Message is " + (String)Krb5.errMsgList.get(new Integer(this.errorCode)));
            if (this.crealm != null) {
                System.out.println("\t crealm is " + this.crealm.toString());
            }
            if (this.cname != null) {
                System.out.println("\t cname is " + this.cname.toString());
            }
            if (this.realm != null) {
                System.out.println("\t realm is " + this.realm.toString());
            }
            if (this.sname != null) {
                System.out.println("\t sname is " + this.sname.toString());
            }
            if (this.eData != null) {
                System.out.println("\t eData provided.");
            }
            if (this.eCksum != null) {
                System.out.println("\t checksum provided.");
            }
            System.out.println("\t msgType is " + this.msgType);
        }
        if (this.eData != null) {
            DerValue derValue2 = new DerValue(this.eData);
            while (derValue2.data.available() > 0) {
                DerValue derValue3 = derValue2.data.getDerValue();
                PAData pAData = new PAData(derValue3);
                this.parsePAData(pAData.getType(), pAData.getValue());
            }
        }
    }

    private void parsePAData(int n, byte[] byArray) throws IOException, Asn1Exception {
        if (this.DEBUG) {
            System.out.println(">>>Pre-Authentication Data:");
            System.out.println("\t PA-DATA type = " + n);
        }
        switch (n) {
            case 2: {
                if (!this.DEBUG) break;
                System.out.println("\t PA-ENC-TIMESTAMP");
                break;
            }
            case 11: {
                if (byArray == null) break;
                DerValue derValue = new DerValue(byArray);
                DerValue derValue2 = derValue.data.getDerValue();
                ETypeInfo eTypeInfo = new ETypeInfo(derValue2);
                this.etype = eTypeInfo.getEType();
                this.salt = eTypeInfo.getSalt();
                if (!this.DEBUG) break;
                System.out.println("\t PA-ETYPE-INFO etype = " + this.etype);
                break;
            }
            case 19: {
                if (byArray == null) break;
                DerValue derValue = new DerValue(byArray);
                DerValue derValue3 = derValue.data.getDerValue();
                ETypeInfo2 eTypeInfo2 = new ETypeInfo2(derValue3);
                this.etype = eTypeInfo2.getEType();
                this.salt = eTypeInfo2.getSalt();
                this.s2kparams = eTypeInfo2.getParams();
                if (!this.DEBUG) break;
                System.out.println("\t PA-ETYPE-INFO2 etype = " + this.etype);
                break;
            }
        }
    }

    public final KerberosTime getServerTime() {
        return this.sTime;
    }

    public final KerberosTime getClientTime() {
        return this.cTime;
    }

    public final Integer getServerMicroSeconds() {
        return this.suSec;
    }

    public final Integer getClientMicroSeconds() {
        return this.cuSec;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final int getEType() {
        return this.etype;
    }

    public final byte[] getSalt() {
        return this.salt == null ? null : (byte[])this.salt.clone();
    }

    public final byte[] getParams() {
        return this.s2kparams == null ? null : (byte[])this.s2kparams.clone();
    }

    public final String getErrorString() {
        return this.eText;
    }

    private void init(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 30 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != 30) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.cTime = KerberosTime.parse(derValue2.getData(), (byte)2, true);
        if ((derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.cuSec = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.cuSec = null;
        }
        this.sTime = KerberosTime.parse(derValue2.getData(), (byte)4, false);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 5) {
            throw new Asn1Exception(906);
        }
        this.suSec = new Integer(derValue3.getData().getBigInteger().intValue());
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 6) {
            throw new Asn1Exception(906);
        }
        this.errorCode = derValue3.getData().getBigInteger().intValue();
        this.crealm = Realm.parse(derValue2.getData(), (byte)7, true);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)8, true);
        this.realm = Realm.parse(derValue2.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)10, false);
        this.eText = null;
        this.eData = null;
        this.eCksum = null;
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 11) {
            derValue3 = derValue2.getData().getDerValue();
            this.eText = derValue3.getData().getGeneralString();
        }
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 12) {
            derValue3 = derValue2.getData().getDerValue();
            this.eData = derValue3.getData().getOctetString();
        }
        if (derValue2.getData().available() > 0) {
            this.eCksum = Checksum.parse(derValue2.getData(), (byte)13, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        if (this.cTime != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), this.cTime.asn1Encode());
        }
        if (this.cuSec != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.cuSec.intValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)4), this.sTime.asn1Encode());
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.suSec.intValue()));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)5), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.errorCode));
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)6), derOutputStream);
        if (this.crealm != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)7), this.crealm.asn1Encode());
        }
        if (this.cname != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)8), this.cname.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)9), this.realm.asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)10), this.sname.asn1Encode());
        if (this.eText != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralString(this.eText);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)11), derOutputStream);
        }
        if (this.eData != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.eData);
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)12), derOutputStream);
        }
        if (this.eCksum != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)13), this.eCksum.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)30), derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

