/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.PrintStream;

public class ChunkedOutputStream
extends PrintStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private byte[] buf;
    private int count;
    private PrintStream out;
    private int preferredChunkSize;

    private int headerSize(int n) {
        return 2 + Integer.toHexString(n).length();
    }

    public ChunkedOutputStream(PrintStream printStream) {
        this(printStream, 4096);
    }

    public ChunkedOutputStream(PrintStream printStream, int n) {
        super(printStream);
        this.out = printStream;
        if (n <= 0) {
            n = 4096;
        }
        if (n > 0) {
            int n2 = n - this.headerSize(n);
            if (n2 + this.headerSize(n2) < n) {
                ++n2;
            }
            n = n2;
        }
        this.preferredChunkSize = n > 0 ? n : 4096 - this.headerSize(4096);
        this.buf = new byte[this.preferredChunkSize + 32];
    }

    private void flush(boolean bl) {
        int n = 0;
        do {
            int n2;
            if (this.count < this.preferredChunkSize) {
                if (!bl) break;
                n2 = this.count;
            } else {
                n2 = this.preferredChunkSize;
            }
            byte[] byArray = Integer.toHexString(n2).getBytes();
            this.out.write(byArray, 0, byArray.length);
            this.out.write(13);
            this.out.write(10);
            if (n2 > 0) {
                this.out.write(this.buf, n, n2);
                this.out.write(13);
                this.out.write(10);
            }
            this.out.flush();
            if (this.checkError()) break;
            if (n2 <= 0) continue;
            this.count -= n2;
            n += n2;
        } while (this.count > 0);
        if (!this.checkError()) {
            System.arraycopy(this.buf, n, this.buf, 0, this.count);
        }
    }

    public boolean checkError() {
        return this.out.checkError();
    }

    private void checkFlush() {
        if (this.count >= this.preferredChunkSize) {
            this.flush(false);
        }
    }

    private void ensureOpen() {
        if (this.out == null) {
            this.setError();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
        this.checkFlush();
    }

    public synchronized void write(int n) {
        this.ensureOpen();
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
        this.checkFlush();
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized void close() {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(true);
        }
        this.flush(true);
        this.out = null;
    }

    public synchronized void flush() {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(true);
        }
    }
}

