/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Window;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MEmbeddedFrame;
import sun.awt.motif.MFramePeer;

public class MEmbeddedFramePeer
extends MFramePeer {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.motif.xembed.MEmbeddedFramePeer");

    public MEmbeddedFramePeer(EmbeddedFrame embeddedFrame) {
        super(embeddedFrame);
        xembedLog.fine("Creating XEmbed-enabled motif embedded frame, frame supports XEmbed:" + this.supportsXEmbed());
    }

    void create(MComponentPeer mComponentPeer) {
        this.NEFcreate(mComponentPeer, ((MEmbeddedFrame)this.target).handle);
    }

    native void NEFcreate(MComponentPeer var1, long var2);

    native void pShowImpl();

    void pShow() {
        this.pShowImpl();
        if (this.supportsXEmbed() && this.target != null && ((EmbeddedFrame)this.target).isFocusableWindow()) {
            this.requestXEmbedFocus();
        }
    }

    boolean supportsXEmbed() {
        EmbeddedFrame embeddedFrame = (EmbeddedFrame)this.target;
        if (embeddedFrame != null) {
            return embeddedFrame.supportsXEmbed();
        }
        return false;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        xembedLog.fine("Peer made visible");
        if (bl && !this.supportsXEmbed()) {
            xembedLog.fine("Synthesizing FocusIn");
            this.synthesizeFocusInOut(true);
        }
    }

    public native void synthesizeFocusInOut(boolean var1);

    native boolean isXEmbedActive();

    native boolean isXEmbedApplicationActive();

    native void requestXEmbedFocus();

    public boolean requestWindowFocus() {
        xembedLog.fine("In requestWindowFocus");
        if (this.isXEmbedActive()) {
            if (this.isXEmbedApplicationActive()) {
                xembedLog.fine("Requesting focus from embedding host");
                this.requestXEmbedFocus();
                return true;
            }
            xembedLog.fine("Host application is not active");
            return false;
        }
        xembedLog.fine("Requesting focus from X");
        return super.requestWindowFocus();
    }

    public void handleWindowFocusIn() {
        super.handleWindowFocusIn();
        xembedLog.fine("windowFocusIn");
    }

    public void handleWindowFocusOut(Window window) {
        super.handleWindowFocusOut(window);
        xembedLog.fine("windowFocusOut, opposite is null?:" + (window == null));
    }
}

