/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgVolatileSurfaceManager;
import sun.awt.image.BufferedImageGraphicsConfig;
import sun.awt.image.Manageable;
import sun.awt.image.SurfaceManager;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceManagerFactory;

public class SunVolatileImage
extends VolatileImage
implements Manageable {
    protected VolatileSurfaceManager surfaceManager;
    protected Component comp;
    private GraphicsConfiguration graphicsConfig;
    private Font defaultFont;
    private int width;
    private int height;

    private SunVolatileImage(Component component, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object object, int n3) {
        this.comp = component;
        this.graphicsConfig = graphicsConfiguration;
        this.width = n;
        this.height = n2;
        this.transparency = n3;
        this.surfaceManager = this.createSurfaceManager(object);
        this.surfaceManager.initialize();
        this.surfaceManager.initContents();
    }

    private SunVolatileImage(Component component, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object object) {
        this(component, graphicsConfiguration, n, n2, object, 1);
    }

    public SunVolatileImage(Component component, int n, int n2) {
        this(component, n, n2, null);
    }

    public SunVolatileImage(Component component, int n, int n2, Object object) {
        this(component, component.getGraphicsConfiguration(), n, n2, object);
    }

    public SunVolatileImage(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        this(null, graphicsConfiguration, n, n2, null);
    }

    public SunVolatileImage(GraphicsConfiguration graphicsConfiguration, int n, int n2, int n3) {
        this(null, graphicsConfiguration, n, n2, null, n3);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public GraphicsConfiguration getGraphicsConfig() {
        return this.graphicsConfig;
    }

    public void updateGraphicsConfig() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.comp != null && (graphicsConfiguration = this.comp.getGraphicsConfiguration()) != null) {
            this.graphicsConfig = graphicsConfiguration;
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public SurfaceManager getSurfaceManager() {
        return this.surfaceManager;
    }

    protected VolatileSurfaceManager createSurfaceManager(Object object) {
        if (this.graphicsConfig instanceof BufferedImageGraphicsConfig) {
            return new BufImgVolatileSurfaceManager(this, object);
        }
        return SurfaceManagerFactory.createVolatileManager(this, object);
    }

    private Color getForeground() {
        if (this.comp != null) {
            return this.comp.getForeground();
        }
        return Color.black;
    }

    private Color getBackground() {
        if (this.comp != null) {
            return this.comp.getBackground();
        }
        return Color.white;
    }

    private Font getFont() {
        if (this.comp != null) {
            return this.comp.getFont();
        }
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        return this.defaultFont;
    }

    public Graphics2D createGraphics() {
        return new SunGraphics2D(this.surfaceManager.getDestSurfaceData(), this.getForeground(), this.getBackground(), this.getFont());
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if (string == null) {
            throw new NullPointerException("null property name is not allowed");
        }
        return Image.UndefinedProperty;
    }

    public int getWidth(ImageObserver imageObserver) {
        return this.getWidth();
    }

    public int getHeight(ImageObserver imageObserver) {
        return this.getHeight();
    }

    public BufferedImage getBackupImage() {
        ColorModel colorModel = this.graphicsConfig.getColorModel(this.getTransparency());
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(this.getWidth(), this.getHeight());
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage getSnapshot() {
        BufferedImage bufferedImage = this.getBackupImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(this, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public int validate(GraphicsConfiguration graphicsConfiguration) {
        return this.surfaceManager.validate(graphicsConfiguration);
    }

    public boolean contentsLost() {
        return this.surfaceManager.contentsLost();
    }

    public ImageCapabilities getCapabilities() {
        return this.surfaceManager.getCapabilities();
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        if (this.surfaceManager.isConfigValid(graphicsConfiguration)) {
            return this.getCapabilities();
        }
        return super.getCapabilities(graphicsConfiguration);
    }

    public void flush() {
        this.surfaceManager.flush();
    }
}

