/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.awt.X11.MWMConstants;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XMWMModality;
import sun.awt.X11.XModalityProtocol;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUtilConstants;
import sun.awt.X11.XWINProtocol;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XWM
implements MWMConstants,
XUtilConstants {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XWM");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWM");
    private static final Logger stateLog = Logger.getLogger("sun.awt.X11.states.XWM");
    static final XAtom XA_MWM_HINTS = new XAtom();
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static XAtom XA_WM_STATE = new XAtom();
    XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
    static final int AWT_NET_N_KNOWN_STATES = 2;
    static XAtom XA_E_FRAME_SIZE = new XAtom();
    static XAtom XA_KDE_NET_WM_FRAME_STRUT = new XAtom();
    static XAtom XA_KWM_WIN_ICONIFIED = new XAtom();
    static XAtom XA_KWM_WIN_MAXIMIZED = new XAtom();
    static XAtom XA_OL_DECOR_DEL = new XAtom();
    static XAtom XA_OL_DECOR_HEADER = new XAtom();
    static XAtom XA_OL_DECOR_RESIZE = new XAtom();
    static XAtom XA_OL_DECOR_PIN = new XAtom();
    static XAtom XA_OL_DECOR_CLOSE = new XAtom();
    static final int UNDETERMINED_WM = 1;
    static final int NO_WM = 2;
    static final int OTHER_WM = 3;
    static final int OPENLOOK_WM = 4;
    static final int MOTIF_WM = 5;
    static final int CDE_WM = 6;
    static final int ENLIGHTEN_WM = 7;
    static final int KDE2_WM = 8;
    static final int SAWFISH_WM = 9;
    static final int ICE_WM = 10;
    static final int METACITY_WM = 11;
    int WMID;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    static final Insets defaultInsets = new Insets(25, 5, 5, 5);
    static XNETProtocol net_protocol = null;
    static XAtom XA_ENLIGHTENMENT_COMMS = new XAtom("ENLIGHTENMENT_COMMS", false);
    static final XAtom XA_DT_SM_WINDOW_INFO = new XAtom("_DT_SM_WINDOW_INFO", false);
    static final XAtom XA_DT_SM_STATE_INFO = new XAtom("_DT_SM_STATE_INFO", false);
    static final XAtom XA_MOTIF_WM_INFO = new XAtom("_MOTIF_WM_INFO", false);
    static final XAtom XA_DT_WORKSPACE_CURRENT = new XAtom("_DT_WORKSPACE_CURRENT", false);
    static XToolkit.XErrorHandler VerifyChangePropertyHandler = new XToolkit.XErrorHandler(){

        public int handleError(long l, XErrorEvent xErrorEvent) {
            XToolkit.XERROR_SAVE(xErrorEvent);
            if (xErrorEvent.get_request_code() == 18) {
                return 0;
            }
            return XToolkit.SAVED_ERROR_HANDLER(l, xErrorEvent);
        }
    };
    static final XAtom XA_ICEWM_WINOPTHINT = new XAtom("_ICEWM_WINOPTHINT", false);
    static final char[] opt = new char[]{'A', 'W', 'T', '_', 'I', 'C', 'E', 'W', 'M', '_', 'T', 'E', 'S', 'T', '\u0000', 'a', 'l', 'l', 'W', 'o', 'r', 'k', 's', 'p', 'a', 'c', 'e', 's', '\u0000', '0', '\u0000'};
    static final XAtom XA_SUN_WM_PROTOCOLS = new XAtom("_SUN_WM_PROTOCOLS", false);
    static boolean winmgr_running = false;
    static XToolkit.XErrorHandler DetectWMHandler = new XToolkit.XErrorHandler(){

        public int handleError(long l, XErrorEvent xErrorEvent) {
            XToolkit.XERROR_SAVE(xErrorEvent);
            if (xErrorEvent.get_request_code() == 2 && xErrorEvent.get_error_code() == 10) {
                winmgr_running = true;
                return 0;
            }
            return XToolkit.SAVED_ERROR_HANDLER(l, xErrorEvent);
        }
    };
    static int awt_wmgr = 1;
    static XWM wm;
    HashMap protocolsMap = new HashMap();
    static boolean inited;
    HashMap storedInsets = new HashMap();
    static int awtWMStaticGravity;

    public String toString() {
        switch (this.WMID) {
            case 2: {
                return "NO WM";
            }
            case 3: {
                return "Other WM";
            }
            case 4: {
                return "OPENLOOK";
            }
            case 5: {
                return "MWM";
            }
            case 6: {
                return "DTWM";
            }
            case 7: {
                return "Enlightenment";
            }
            case 8: {
                return "KWM2";
            }
            case 9: {
                return "Sawfish";
            }
            case 10: {
                return "IceWM";
            }
            case 11: {
                return "Metacity";
            }
        }
        return "Undetermined WM";
    }

    XWM(int n) {
        this.WMID = n;
        this.initializeProtocols();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Window manager: " + this.toString());
        }
    }

    int getID() {
        return this.WMID;
    }

    static Insets normalize(Insets insets) {
        if (insets.top > 64 || insets.top < 0) {
            insets.top = 28;
        }
        if (insets.left > 32 || insets.left < 0) {
            insets.left = 6;
        }
        if (insets.right > 32 || insets.right < 0) {
            insets.right = 6;
        }
        if (insets.bottom > 32 || insets.bottom < 0) {
            insets.bottom = 6;
        }
        return insets;
    }

    static boolean isNetWMName(String string) {
        if (net_protocol != null) {
            return net_protocol.isWMName(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initAtoms() {
        int n;
        Object[][] objectArrayArray = new Object[][]{{XA_WM_STATE, "WM_STATE"}, {XA_KDE_NET_WM_FRAME_STRUT, "_KDE_NET_WM_FRAME_STRUT"}, {XA_E_FRAME_SIZE, "_E_FRAME_SIZE"}, {XA_KWM_WIN_ICONIFIED, "KWM_WIN_ICONIFIED"}, {XA_KWM_WIN_MAXIMIZED, "KWM_WIN_MAXIMIZED"}, {XA_OL_DECOR_DEL, "_OL_DECOR_DEL"}, {XA_OL_DECOR_HEADER, "_OL_DECOR_HEADER"}, {XA_OL_DECOR_RESIZE, "_OL_DECOR_RESIZE"}, {XA_OL_DECOR_PIN, "_OL_DECOR_PIN"}, {XA_OL_DECOR_CLOSE, "_OL_DECOR_CLOSE"}, {XA_MWM_HINTS, "_MOTIF_WM_HINTS"}};
        String[] stringArray = new String[objectArrayArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArrayArray[n][1];
        }
        n = XAtom.getAtomSize();
        long l = unsafe.allocateMemory(stringArray.length * n);
        try {
            XToolkit.awtLock();
            int n2 = XlibWrapper.XInternAtoms(XToolkit.getDisplay(), stringArray, false, l);
            if (n2 == 0) {
                return;
            }
            int n3 = 0;
            int n4 = 0;
            while (n3 < stringArray.length) {
                ((XAtom)objectArrayArray[n3][0]).setValues(XToolkit.getDisplay(), stringArray[n3], XAtom.getAtom(l + (long)n4));
                ++n3;
                n4 += n;
            }
        }
        finally {
            XToolkit.awtUnlock();
            unsafe.freeMemory(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getECommsWindowIDProperty(long l) {
        if (!XA_ENLIGHTENMENT_COMMS.isInterned()) {
            return 0L;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XA_ENLIGHTENMENT_COMMS, 0L, 14L, false, 31L);
        try {
            int n = windowPropertyGetter.execute(XToolkit.IgnoreBadWindowHandler);
            if (n != 0 || windowPropertyGetter.getData() == 0L) {
                long l2 = 0L;
                return l2;
            }
            if (windowPropertyGetter.getActualType() != 31L || windowPropertyGetter.getActualFormat() != 8 || windowPropertyGetter.getNumberOfItems() != 14 || windowPropertyGetter.getBytesAfter() != 0L) {
                long l3 = 0L;
                return l3;
            }
            byte[] byArray = XlibWrapper.getStringBytes(windowPropertyGetter.getData());
            String string = new String(byArray);
            log.finer("ENLIGHTENMENT_COMMS is " + string);
            Pattern pattern = Pattern.compile("WINID\\s+(\\p{XDigit}{0,8})");
            try {
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    log.finest("Match group count: " + matcher.groupCount());
                    String string2 = matcher.group(1);
                    log.finest("Match group 1 " + string2);
                    long l4 = Long.parseLong(string2, 16);
                    log.finer("Enlightenment communication window " + l4);
                    long l5 = l4;
                    return l5;
                }
                log.finer("ENLIGHTENMENT_COMMS has wrong format");
                long l6 = 0L;
                return l6;
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.FINER)) {
                    exception.printStackTrace();
                }
                long l7 = 0L;
                return l7;
            }
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    static boolean isEnlightenment() {
        long l = XWM.getECommsWindowIDProperty(XToolkit.getDefaultRootWindow());
        if (l == 0L) {
            return false;
        }
        long l2 = XWM.getECommsWindowIDProperty(l);
        return l2 == l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCDE() {
        if (!XA_DT_SM_WINDOW_INFO.isInterned()) {
            log.log(Level.FINER, "{0} is not interned", new Object[]{XA_DT_SM_WINDOW_INFO});
            return false;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_DT_SM_WINDOW_INFO, 0L, 2L, false, XA_DT_SM_WINDOW_INFO);
        try {
            WindowPropertyGetter windowPropertyGetter2;
            block20: {
                block19: {
                    int n = windowPropertyGetter.execute();
                    if (n != 0 || windowPropertyGetter.getData() == 0L) {
                        log.finer("Getting of _DT_SM_WINDOW_INFO is not successfull");
                        boolean bl = false;
                        return bl;
                    }
                    if (windowPropertyGetter.getActualType() != XA_DT_SM_WINDOW_INFO.getAtom() || windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() != 2 || windowPropertyGetter.getBytesAfter() != 0L) {
                        log.finer("Wrong format of _DT_SM_WINDOW_INFO");
                        boolean bl = false;
                        return bl;
                    }
                    long l = Native.getWindow(windowPropertyGetter.getData(), 1);
                    if (l == 0L) {
                        log.fine("WARNING: DT_SM_WINDOW_INFO exists but returns zero windows");
                        boolean bl = false;
                        return bl;
                    }
                    if (!XA_DT_SM_STATE_INFO.isInterned()) {
                        log.log(Level.FINER, "{0} is not interned", new Object[]{XA_DT_SM_STATE_INFO});
                        boolean bl = false;
                        return bl;
                    }
                    windowPropertyGetter2 = new WindowPropertyGetter(l, XA_DT_SM_STATE_INFO, 0L, 1L, false, XA_DT_SM_STATE_INFO);
                    try {
                        n = windowPropertyGetter2.execute(XToolkit.IgnoreBadWindowHandler);
                        if (n == 0 && windowPropertyGetter2.getData() != 0L) break block19;
                        log.finer("Getting of _DT_SM_STATE_INFO is not successfull");
                        boolean bl = false;
                        windowPropertyGetter2.dispose();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        windowPropertyGetter2.dispose();
                        throw throwable;
                    }
                }
                if (windowPropertyGetter2.getActualType() == XA_DT_SM_STATE_INFO.getAtom() && windowPropertyGetter2.getActualFormat() == 32) break block20;
                log.finer("Wrong format of _DT_SM_STATE_INFO");
                boolean bl = false;
                windowPropertyGetter2.dispose();
                return bl;
            }
            boolean bl = true;
            windowPropertyGetter2.dispose();
            return bl;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isMotif() {
        if (!XA_MOTIF_WM_INFO.isInterned() || !XA_DT_WORKSPACE_CURRENT.isInterned()) {
            return false;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_MOTIF_WM_INFO, 0L, 2L, false, XA_MOTIF_WM_INFO);
        try {
            int n = windowPropertyGetter.execute();
            if (n != 0 || windowPropertyGetter.getData() == 0L) {
                boolean bl = false;
                return bl;
            }
            if (windowPropertyGetter.getActualType() != XA_MOTIF_WM_INFO.getAtom() || windowPropertyGetter.getActualFormat() != 32 || windowPropertyGetter.getNumberOfItems() != 2 || windowPropertyGetter.getBytesAfter() != 0L) {
                boolean bl = false;
                return bl;
            }
            long l = Native.getLong(windowPropertyGetter.getData(), 1);
            XAtom[] xAtomArray = XA_DT_WORKSPACE_CURRENT.getAtomListProperty(l);
            if (xAtomArray.length == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    static boolean isSawfish() {
        return XWM.isNetWMName("Sawfish");
    }

    static boolean isKDE2() {
        return XWM.isNetWMName("KWin");
    }

    static boolean isMetacity() {
        return XWM.isNetWMName("Metacity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean prepareIsIceWM() {
        if (!XA_ICEWM_WINOPTHINT.isInterned()) {
            log.log(Level.FINER, "{0} is not interned", new Object[]{XA_ICEWM_WINOPTHINT});
            return false;
        }
        try {
            XToolkit.awtLock();
            XToolkit.WITH_XERROR_HANDLER(VerifyChangePropertyHandler);
            XlibWrapper.XChangePropertyS(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), XA_ICEWM_WINOPTHINT.getAtom(), XA_ICEWM_WINOPTHINT.getAtom(), 8, 0, new String(opt));
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                log.finer("Erorr getting XA_ICEWM_WINOPTHINT property");
                boolean bl = false;
                return bl;
            }
            log.finer("Prepared for IceWM detection");
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isIceWM() {
        if (!XA_ICEWM_WINOPTHINT.isInterned()) {
            log.log(Level.FINER, "{0} is not interned", new Object[]{XA_ICEWM_WINOPTHINT});
            return false;
        }
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_ICEWM_WINOPTHINT, 0L, 65535L, true, XA_ICEWM_WINOPTHINT);
        try {
            int n = windowPropertyGetter.execute();
            boolean bl = n == 0 && windowPropertyGetter.getActualType() != 0L;
            log.finer("Status getting XA_ICEWM_WINOPTHINT: " + !bl);
            boolean bl2 = !bl || XWM.isNetWMName("IceWM");
            return bl2;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    static boolean isOpenLook() {
        if (!XA_SUN_WM_PROTOCOLS.isInterned()) {
            return false;
        }
        XAtom[] xAtomArray = XA_SUN_WM_PROTOCOLS.getAtomListProperty(XToolkit.getDefaultRootWindow());
        return xAtomArray.length != 0;
    }

    static XWM getWM() {
        if (wm == null) {
            awt_wmgr = XWM.getWMID();
            wm = new XWM(awt_wmgr);
        }
        return wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getWMID() {
        if (awt_wmgr != 1) {
            return awt_wmgr;
        }
        XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
        XToolkit.awtLock();
        try {
            String string = XlibWrapper.ServerVendor(XToolkit.getDisplay());
            if (string.indexOf("eXcursion") != -1) {
                int n = awt_wmgr = 2;
                return n;
            }
            winmgr_running = false;
            xSetWindowAttributes.set_event_mask(0x100000L);
            XToolkit.WITH_XERROR_HANDLER(DetectWMHandler);
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 2048L, xSetWindowAttributes.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (!winmgr_running) {
                awt_wmgr = 2;
                xSetWindowAttributes.set_event_mask(0L);
                XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 2048L, xSetWindowAttributes.pData);
                int n = 2;
                return n;
            }
            net_protocol = new XNETProtocol();
            net_protocol.detect();
            if (log.isLoggable(Level.FINE) && net_protocol.active()) {
                log.fine("_NET_WM_NAME is " + net_protocol.getWMName());
            }
            XWINProtocol xWINProtocol = new XWINProtocol();
            xWINProtocol.detect();
            boolean bl = XWM.prepareIsIceWM();
            awt_wmgr = XWM.isEnlightenment() ? 7 : (XWM.isMetacity() ? 11 : (XWM.isSawfish() ? 9 : (XWM.isKDE2() ? 8 : (bl && XWM.isIceWM() ? 10 : (net_protocol.active() ? 3 : (xWINProtocol.active() ? 3 : (XWM.isCDE() ? 6 : (XWM.isMotif() ? 5 : (XWM.isOpenLook() ? 4 : 3)))))))));
            if (!net_protocol.active()) {
                net_protocol = null;
            }
            int n = awt_wmgr;
            return n;
        }
        finally {
            XToolkit.awtUnlock();
            xSetWindowAttributes.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeSizeHints(XDecoratedPeer xDecoratedPeer, long l) {
        XToolkit.awtLock();
        l &= 0x30L;
        try {
            XSizeHints xSizeHints = xDecoratedPeer.getHints();
            if ((xSizeHints.get_flags() & l) == 0L) {
                return;
            }
            xSizeHints.set_flags(xSizeHints.get_flags() & (l ^ 0xFFFFFFFFFFFFFFFFL));
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(xSizeHints.get_flags()));
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), xDecoratedPeer.getWindow(), xSizeHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static int normalizeMotifDecor(int n) {
        if ((n & 1) == 0) {
            return n;
        }
        int n2 = 126;
        return n2 &= ~n;
    }

    static void setOLDecor(XWindow xWindow, boolean bl, int n) {
        if (xWindow == null) {
            return;
        }
        XAtomList xAtomList = new XAtomList();
        n = XWM.normalizeMotifDecor(n);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.finer("Setting OL_DECOR to " + Integer.toBinaryString(n));
        }
        if ((n & 8) == 0) {
            xAtomList.add(XA_OL_DECOR_HEADER);
        }
        if ((n & 0x44) == 0) {
            xAtomList.add(XA_OL_DECOR_RESIZE);
        }
        if ((n & 0x70) == 0) {
            xAtomList.add(XA_OL_DECOR_CLOSE);
        }
        if (xAtomList.size() == 0) {
            insLog.finer("Deleting OL_DECOR");
            XA_OL_DECOR_DEL.DeleteProperty(xWindow);
        } else {
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting OL_DECOR to " + xAtomList);
            }
            XA_OL_DECOR_DEL.setAtomListProperty((XBaseWindow)xWindow, xAtomList);
        }
    }

    static void setMotifDecor(XWindow xWindow, boolean bl, int n) {
        if ((n & 1) != 0 && n != 1) {
            n = XWM.normalizeMotifDecor(n);
        }
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        } else {
            n2 |= 0x2C;
            if (bl) {
                n2 |= 0x12;
            }
        }
        PropMwmHints propMwmHints = new PropMwmHints();
        if (XA_MWM_HINTS.getAtomData(xWindow.getWindow(), propMwmHints.pData, 5)) {
            propMwmHints.set_flags(propMwmHints.get_flags() | 1L | 2L);
        } else {
            propMwmHints.set_flags(3L);
        }
        propMwmHints.set_functions(n2);
        propMwmHints.set_decorations(n);
        if (stateLog.isLoggable(Level.FINER)) {
            stateLog.finer("Setting MWM_HINTS to " + propMwmHints);
        }
        XA_MWM_HINTS.setAtomData(xWindow.getWindow(), propMwmHints.pData, 5);
        propMwmHints.dispose();
    }

    static boolean needRemap() {
        return true;
    }

    static void setShellDecor(XDecoratedPeer xDecoratedPeer) {
        int n = xDecoratedPeer.getDecorations();
        boolean bl = xDecoratedPeer.isResizable();
        if (!bl) {
            n = (n & 1) != 0 ? (n |= 0x44) : (n &= 0xFFFFFFBB);
        }
        XWM.setMotifDecor(xDecoratedPeer, bl, n);
        XWM.setOLDecor(xDecoratedPeer, bl, n);
        if (xDecoratedPeer.isShowing() && XWM.needRemap()) {
            xDecoratedPeer.xSetVisible(false);
            XToolkit.XSync();
            xDecoratedPeer.xSetVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setShellResizable(XDecoratedPeer xDecoratedPeer) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell resizable " + xDecoratedPeer);
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Rectangle rectangle = xDecoratedPeer.getShellBounds();
            rectangle.translate(-xDecoratedPeer.currentInsets.left, -xDecoratedPeer.currentInsets.top);
            xDecoratedPeer.updateSizeHints(xDecoratedPeer.getDimensions());
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), xDecoratedPeer.getShell(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XWM.removeSizeHints(xDecoratedPeer, 48L);
            XWM.setShellDecor(xDecoratedPeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setShellNotResizable(XDecoratedPeer xDecoratedPeer, WindowDimensions windowDimensions, Rectangle rectangle, boolean bl) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting non-resizable shell " + xDecoratedPeer + ", dimensions " + windowDimensions + ", shellBounds " + rectangle + ", just change size: " + bl);
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            if (!rectangle.isEmpty()) {
                xDecoratedPeer.updateSizeHints(windowDimensions);
                XToolkit.XSync();
                XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), xDecoratedPeer.getShell(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!bl) {
                XWM.setShellDecor(xDecoratedPeer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean readInsetsArray(long l, XAtom xAtom, int[] nArray) {
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, xAtom, 0L, 4L, false, 6L);
        try {
            int n;
            int n2 = windowPropertyGetter.execute();
            if (n2 != 0 || windowPropertyGetter.getData() == 0L) {
                boolean bl = false;
                return bl;
            }
            if (windowPropertyGetter.getActualType() != 6L || windowPropertyGetter.getActualFormat() != 32) {
                boolean bl = false;
                return bl;
            }
            for (n = 0; n < 4; ++n) {
                nArray[n] = (int)Native.getCard32(windowPropertyGetter.getData(), n);
            }
            n = 1;
            return n != 0;
        }
        finally {
            windowPropertyGetter.dispose();
        }
    }

    Collection getProtocols(Class clazz) {
        Object v = this.protocolsMap.get(clazz);
        if (v != null) {
            return (Collection)v;
        }
        return new LinkedList();
    }

    void addProtocol(Class clazz, XProtocol xProtocol) {
        Collection collection = this.getProtocols(clazz);
        collection.add(xProtocol);
        this.protocolsMap.put(clazz, collection);
    }

    boolean supportsDynamicLayout() {
        int n = XWM.getWMID();
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return false;
    }

    boolean supportsExtendedState(int n) {
        switch (n) {
            case 2: 
            case 4: {
                if (XWM.getWMID() == 11) {
                    return false;
                }
            }
            case 6: {
                for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
                    if (!xStateProtocol.supportsState(n)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    int getExtendedState(XWindowPeer xWindowPeer) {
        Iterator iterator = this.getProtocols(XStateProtocol.class).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            XStateProtocol xStateProtocol = (XStateProtocol)iterator.next();
            n |= xStateProtocol.getState(xWindowPeer);
        }
        if (n != 0) {
            return n;
        }
        return 0;
    }

    Integer isStateChange(XDecoratedPeer xDecoratedPeer, XPropertyEvent xPropertyEvent) {
        if (!xDecoratedPeer.isShowing()) {
            stateLog.finer("Window is not showing");
            return null;
        }
        int n = xDecoratedPeer.getWMState();
        if (n == 0) {
            stateLog.finer("WithdrawnState");
            return null;
        }
        stateLog.finer("Window WM_STATE is " + n);
        boolean bl = false;
        if (xPropertyEvent.get_atom() == XA_WM_STATE.getAtom()) {
            bl = true;
        }
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            bl |= xStateProtocol.isStateChange(xPropertyEvent);
        }
        int n2 = 0;
        if (bl) {
            n2 = n == 3 ? 1 : 0;
            n2 |= this.getExtendedState(xDecoratedPeer);
        }
        if (bl) {
            return new Integer(n2);
        }
        return null;
    }

    void setLayer(XWindowPeer xWindowPeer, int n) {
        for (XLayerProtocol xLayerProtocol : this.getProtocols(XLayerProtocol.class)) {
            if (!xLayerProtocol.supportsLayer(n)) continue;
            xLayerProtocol.setLayer(xWindowPeer, n);
        }
        XToolkit.XSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExtendedState(XWindowPeer xWindowPeer, int n) {
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            if (!xStateProtocol.supportsState(n)) continue;
            xStateProtocol.setState(xWindowPeer, n);
            break;
        }
        if (!xWindowPeer.isShowing()) {
            try {
                XToolkit.awtLock();
                XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), xWindowPeer.getWindow(), XA_KWM_WIN_ICONIFIED.getAtom());
                XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), xWindowPeer.getWindow(), XA_KWM_WIN_MAXIMIZED.getAtom());
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        XToolkit.XSync();
    }

    void unshadeKludge(XDecoratedPeer xDecoratedPeer) {
        assert (xDecoratedPeer.isShowing());
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            xStateProtocol.unshadeKludge(xDecoratedPeer);
        }
        XToolkit.XSync();
    }

    static void init() {
        if (inited) {
            return;
        }
        XWM.initAtoms();
        XWM.getWM();
        inited = true;
    }

    void initializeProtocols() {
        net_protocol = new XNETProtocol();
        if (!net_protocol.active()) {
            net_protocol = null;
        } else {
            if (net_protocol.doStateProtocol()) {
                this.addProtocol(XStateProtocol.class, net_protocol);
            }
            if (net_protocol.doLayerProtocol()) {
                this.addProtocol(XLayerProtocol.class, net_protocol);
            }
            if (net_protocol.doModalityProtocol()) {
                this.addProtocol(XModalityProtocol.class, net_protocol);
            }
        }
        XWINProtocol xWINProtocol = new XWINProtocol();
        if (xWINProtocol.active()) {
            if (xWINProtocol.doStateProtocol()) {
                this.addProtocol(XStateProtocol.class, xWINProtocol);
            }
            if (xWINProtocol.doLayerProtocol()) {
                this.addProtocol(XLayerProtocol.class, xWINProtocol);
            }
        }
        XMWMModality xMWMModality = new XMWMModality();
        this.addProtocol(XModalityProtocol.class, xMWMModality);
    }

    Insets guessInsets(XDecoratedPeer xDecoratedPeer) {
        Insets insets = (Insets)this.storedInsets.get(xDecoratedPeer.getClass());
        if (insets == null) {
            switch (this.WMID) {
                case 7: {
                    insets = new Insets(19, 4, 4, 4);
                    break;
                }
                case 6: {
                    insets = new Insets(28, 6, 6, 6);
                    break;
                }
                case 2: {
                    insets = zeroInsets;
                    break;
                }
                default: {
                    insets = defaultInsets;
                }
            }
        }
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.finest("WM guessed insets: " + insets);
        }
        return insets;
    }

    static boolean configureGravityBuggy() {
        if (awtWMStaticGravity == -1) {
            int n = awtWMStaticGravity = XToolkit.getEnv("_JAVA_AWT_WM_STATIC_GRAVITY") != null ? 1 : 0;
        }
        if (awtWMStaticGravity == 1) {
            return true;
        }
        switch (XWM.getWMID()) {
            case 10: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    static boolean getInsetsFromProp(long l, int[] nArray) {
        switch (XWM.getWMID()) {
            case 7: {
                return XWM.readInsetsArray(l, XA_E_FRAME_SIZE, nArray);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncTopLevelPos(long l, XWindowAttributes xWindowAttributes) {
        int n = 0;
        try {
            XToolkit.awtLock();
            do {
                XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                if (xWindowAttributes.get_x() != 0) break;
                if (xWindowAttributes.get_y() != 0) {
                    break;
                }
                XToolkit.XSync();
            } while (++n < 50);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Insets getInsets(XDecoratedPeer xDecoratedPeer, XReparentEvent xReparentEvent) {
        Insets insets;
        block14: {
            XWindowAttributes xWindowAttributes;
            XWindowAttributes xWindowAttributes2;
            block13: {
                xWindowAttributes2 = new XWindowAttributes();
                xWindowAttributes = new XWindowAttributes();
                insets = new Insets(0, 0, 0, 0);
                insets.top = -1;
                insets.left = -1;
                int[] nArray = new int[4];
                if (!XWM.getInsetsFromProp(xReparentEvent.get_window(), nArray)) break block13;
                insets = new Insets(nArray[2], nArray[0], nArray[3], nArray[1]);
                insLog.log(Level.FINER, "Got insets from property: {0}", new Object[]{nArray});
                break block14;
            }
            switch (XWM.getWMID()) {
                case 7: {
                    this.syncTopLevelPos(xReparentEvent.get_parent(), xWindowAttributes2);
                    XQueryTree xQueryTree = new XQueryTree(xReparentEvent.get_parent());
                    try {
                        xQueryTree.execute();
                        insets.left = xWindowAttributes2.get_x();
                        insets.top = xWindowAttributes2.get_y();
                        XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), xQueryTree.get_parent(), xWindowAttributes.pData);
                        insets.right = xWindowAttributes.get_width() - (xWindowAttributes2.get_width() + insets.left);
                        insets.bottom = xWindowAttributes.get_height() - (xWindowAttributes2.get_height() + insets.top);
                        break;
                    }
                    finally {
                        xQueryTree.dispose();
                    }
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    this.syncTopLevelPos(xReparentEvent.get_parent(), xWindowAttributes2);
                    insets.top = xWindowAttributes2.get_y();
                    insets.right = insets.left = xWindowAttributes2.get_x();
                    insets.bottom = insets.left;
                    break;
                }
                case 4: 
                case 9: {
                    this.syncTopLevelPos(xReparentEvent.get_window(), xWindowAttributes2);
                    insets.top = xWindowAttributes2.get_y();
                    insets.right = insets.left = xWindowAttributes2.get_x();
                    insets.bottom = insets.left;
                    break;
                }
                default: {
                    this.syncTopLevelPos(xReparentEvent.get_parent(), xWindowAttributes2);
                    long l = xReparentEvent.get_window();
                    long l2 = xReparentEvent.get_parent();
                    XWindowAttributes xWindowAttributes3 = new XWindowAttributes();
                    int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes2.pData);
                    n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes3.pData);
                    if (xWindowAttributes2.get_x() == 0 && xWindowAttributes2.get_y() == 0 && xWindowAttributes2.get_width() + 2 * xWindowAttributes2.get_border_width() == xWindowAttributes3.get_width() && xWindowAttributes2.get_height() + 2 * xWindowAttributes2.get_border_width() == xWindowAttributes3.get_height()) {
                        XQueryTree xQueryTree = new XQueryTree(l2);
                        try {
                            xQueryTree.execute();
                            xWindowAttributes2.set_x(xWindowAttributes3.get_x());
                            xWindowAttributes2.set_y(xWindowAttributes3.get_y());
                            xWindowAttributes2.set_border_width(xWindowAttributes2.get_border_width() + xWindowAttributes3.get_border_width());
                            l2 = xQueryTree.get_parent();
                            XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l2, xWindowAttributes3.pData);
                        }
                        finally {
                            xQueryTree.dispose();
                        }
                    }
                    insets = new Insets(xWindowAttributes2.get_y() + xWindowAttributes2.get_border_width(), xWindowAttributes2.get_x() + xWindowAttributes2.get_border_width(), xWindowAttributes3.get_height() - (xWindowAttributes2.get_y() + xWindowAttributes2.get_height() + 2 * xWindowAttributes2.get_border_width()), xWindowAttributes3.get_width() - (xWindowAttributes2.get_x() + xWindowAttributes2.get_width() + 2 * xWindowAttributes2.get_border_width()));
                    break;
                }
            }
        }
        if (this.storedInsets.get(xDecoratedPeer.getClass()) == null) {
            this.storedInsets.put(xDecoratedPeer.getClass(), insets);
        }
        return insets;
    }

    boolean isDesktopWindow(long l) {
        if (net_protocol != null) {
            XAtomList xAtomList = XAtom.get("_NET_WM_WINDOW_TYPE").getAtomListPropertyList(l);
            return xAtomList.contains(XAtom.get("_NET_WM_WINDOW_TYPE_DESKTOP"));
        }
        return false;
    }

    static {
        inited = false;
        awtWMStaticGravity = -1;
    }
}

