/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class ArrayType
extends OpenType
implements Serializable {
    static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType elementType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public ArrayType(int n, OpenType openType) throws OpenDataException {
        super(ArrayType.buildArrayClassName(n, openType.getClassName()), ArrayType.buildArrayClassName(n, openType.getClassName()), String.valueOf(n) + "-dimension array of " + openType.getClassName());
        this.dimension = n;
        this.elementType = openType;
    }

    private static String buildArrayClassName(int n, String string) throws OpenDataException {
        if (n < 1) {
            throw new IllegalArgumentException("Value of argument dimension must be greater than 0");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < n; ++i) {
            stringBuffer.append('[');
        }
        stringBuffer.append("[L");
        stringBuffer.append(string);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    public boolean isValue(Object object) {
        if (object == null) {
            return false;
        }
        Class<? extends Object> clazz = object.getClass();
        String string = clazz.getName();
        if (!clazz.isArray()) {
            return false;
        }
        if (this.getClassName().equals(string)) {
            return true;
        }
        if (this.elementType.getClassName().equals(TabularData.class.getName()) || this.elementType.getClassName().equals(CompositeData.class.getName())) {
            Class<? extends Object> clazz2;
            try {
                clazz2 = Class.forName(this.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                return false;
            }
            return this.checkElementsType((Object[])object, this.dimension);
        }
        return false;
    }

    private boolean checkElementsType(Object[] objectArray, int n) {
        if (n > 1) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.checkElementsType((Object[])objectArray[i], n - 1)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || this.getElementOpenType().isValue(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        ArrayType arrayType;
        if (object == null) {
            return false;
        }
        try {
            arrayType = (ArrayType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (arrayType.dimension != this.dimension) {
            return false;
        }
        return this.elementType.equals(arrayType.elementType);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.dimension;
            this.myHashCode = new Integer(n += this.elementType.hashCode());
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("(name=");
            stringBuffer.append(this.getTypeName());
            stringBuffer.append(",dimension=");
            stringBuffer.append(String.valueOf(this.dimension));
            stringBuffer.append(",elementType=");
            stringBuffer.append(this.elementType.toString());
            stringBuffer.append(")");
            this.myToString = stringBuffer.toString();
        }
        return this.myToString;
    }
}

