/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.dtm.ref.dom2dtm.DOM2DTM;
import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.serializer.AttributesImplSerializer;
import com.sun.org.apache.xml.internal.serializer.DOMSerializer;
import com.sun.org.apache.xml.internal.serializer.ElemContext;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import com.sun.org.apache.xml.internal.serializer.SerializerConstants;
import com.sun.org.apache.xml.internal.serializer.SerializerTrace;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SerializerBase
implements SerializationHandler,
SerializerConstants,
DOM2DTM.CharacterNodeHandler {
    protected boolean m_needToCallStartDocument = true;
    protected boolean m_cdataTagOpen = false;
    protected AttributesImplSerializer m_attributes = new AttributesImplSerializer();
    protected boolean m_inEntityRef = false;
    protected boolean m_inExternalDTD = false;
    private String m_doctypeSystem;
    private String m_doctypePublic;
    boolean m_needToOutputDocTypeDecl = true;
    private String m_encoding = null;
    private boolean m_shouldNotWriteXMLHeader = false;
    private String m_standalone;
    protected boolean m_standaloneWasSpecified = false;
    protected boolean m_doIndent = false;
    protected int m_indentAmount = 0;
    private String m_version = null;
    private String m_mediatype;
    private Transformer m_transformer;
    protected Vector m_cdataSectionElements = null;
    protected NamespaceMappings m_prefixMap;
    protected SerializerTrace m_tracer;
    protected SourceLocator m_sourceLocator;
    protected Writer m_writer = null;
    protected ElemContext m_elemContext = new ElemContext();
    protected char[] m_charsBuff = new char[60];
    protected char[] m_attrBuff = new char[30];

    protected void fireEndElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(4, string, (Attributes)null);
        }
    }

    protected void fireCharEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(5, cArray, n, n2);
        }
    }

    public void comment(String string) throws SAXException {
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n);
    }

    protected String patchName(String string) {
        int n = string.lastIndexOf(58);
        if (n > 0) {
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n + 1);
            String string4 = this.m_prefixMap.lookupNamespace(string2);
            if (string4 != null && string4.length() == 0) {
                return string3;
            }
            if (n2 != n) {
                return string2 + ':' + string3;
            }
        }
        return string;
    }

    protected static String getLocalName(String string) {
        int n = string.lastIndexOf(58);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.addAttributeAlways(string, string2, string3, string4, string5);
        }
    }

    public void addAttributeAlways(String string, String string2, String string3, String string4, String string5) {
        int n = this.m_attributes.getIndex(string3);
        if (n >= 0) {
            this.m_attributes.setValue(n, string5);
        } else {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
        }
    }

    public void addAttribute(String string, String string2) {
        if (this.m_elemContext.m_startTagOpen) {
            String string3 = this.patchName(string);
            String string4 = SerializerBase.getLocalName(string3);
            String string5 = this.getNamespaceURI(string3, false);
            this.addAttributeAlways(string5, string4, string3, "CDATA", string2);
        }
    }

    public void addAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getURI(i);
            if (null == string) {
                string = "";
            }
            this.addAttributeAlways(string, attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public void endEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = false;
        }
        this.m_inEntityRef = false;
        if (this.m_tracer != null) {
            this.fireEndEntity(string);
        }
    }

    public void close() {
    }

    protected void initCDATA() {
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public void setOmitXMLDeclaration(boolean bl) {
        this.m_shouldNotWriteXMLHeader = bl;
    }

    public boolean getOmitXMLDeclaration() {
        return this.m_shouldNotWriteXMLHeader;
    }

    public String getDoctypePublic() {
        return this.m_doctypePublic;
    }

    public void setDoctypePublic(String string) {
        this.m_doctypePublic = string;
    }

    public String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    public void setDoctypeSystem(String string) {
        this.m_doctypeSystem = string;
    }

    public void setDoctype(String string, String string2) {
        this.m_doctypeSystem = string;
        this.m_doctypePublic = string2;
    }

    public void setStandalone(String string) {
        if (string != null) {
            this.m_standaloneWasSpecified = true;
            this.setStandaloneInternal(string);
        }
    }

    protected void setStandaloneInternal(String string) {
        this.m_standalone = "yes".equals(string) ? "yes" : "no";
    }

    public String getStandalone() {
        return this.m_standalone;
    }

    public boolean getIndent() {
        return this.m_doIndent;
    }

    public String getMediaType() {
        return this.m_mediatype;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public void setMediaType(String string) {
        this.m_mediatype = string;
    }

    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    public void setIndentAmount(int n) {
        this.m_indentAmount = n;
    }

    public void setIndent(boolean bl) {
        this.m_doIndent = bl;
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    protected boolean isCdataSection() {
        boolean bl = false;
        if (null != this.m_cdataSectionElements) {
            String string;
            if (this.m_elemContext.m_elementLocalName == null) {
                this.m_elemContext.m_elementLocalName = SerializerBase.getLocalName(this.m_elemContext.m_elementName);
            }
            if (this.m_elemContext.m_elementURI == null && (string = SerializerBase.getPrefixPart(this.m_elemContext.m_elementName)) != null) {
                this.m_elemContext.m_elementURI = this.m_prefixMap.lookupNamespace(string);
            }
            if (null != this.m_elemContext.m_elementURI && this.m_elemContext.m_elementURI.length() == 0) {
                this.m_elemContext.m_elementURI = null;
            }
            int n = this.m_cdataSectionElements.size();
            for (int i = 0; i < n; i += 2) {
                String string2 = (String)this.m_cdataSectionElements.elementAt(i);
                String string3 = (String)this.m_cdataSectionElements.elementAt(i + 1);
                if (!string3.equals(this.m_elemContext.m_elementLocalName) || !SerializerBase.subPartMatch(this.m_elemContext.m_elementURI, string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static final boolean subPartMatch(String string, String string2) {
        return string == string2 || null != string && string.equals(string2);
    }

    protected static final String getPrefixPart(String string) {
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.m_prefixMap;
    }

    public String getPrefix(String string) {
        String string2 = this.m_prefixMap.lookupPrefix(string);
        return string2;
    }

    public String getNamespaceURI(String string, boolean bl) {
        String string2;
        String string3 = "";
        int n = string.lastIndexOf(58);
        String string4 = string2 = n > 0 ? string.substring(0, n) : "";
        if (!("".equals(string2) && !bl || this.m_prefixMap == null || (string3 = this.m_prefixMap.lookupNamespace(string2)) != null || string2.equals("xmlns"))) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_NAMESPACE_PREFIX", new Object[]{string.substring(0, n)}));
        }
        return string3;
    }

    public String getNamespaceURIFromPrefix(String string) {
        String string2 = null;
        if (this.m_prefixMap != null) {
            string2 = this.m_prefixMap.lookupNamespace(string);
        }
        return string2;
    }

    public void entityReference(String string) throws SAXException {
        this.flushPending();
        this.startEntity(string);
        this.endEntity(string);
        if (this.m_tracer != null) {
            this.fireEntityReference(string);
        }
    }

    public void setTransformer(Transformer transformer) {
        this.m_transformer = transformer;
        this.m_tracer = this.m_transformer instanceof SerializerTrace && ((SerializerTrace)((Object)this.m_transformer)).hasTraceListeners() ? (SerializerTrace)((Object)this.m_transformer) : null;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public void characters(Node node) throws SAXException {
        this.flushPending();
        String string = node.getNodeValue();
        if (string != null) {
            int n = string.length();
            if (n > this.m_charsBuff.length) {
                this.m_charsBuff = new char[n * 2 + 1];
            }
            string.getChars(0, n, this.m_charsBuff, 0);
            this.characters(this.m_charsBuff, 0, n);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_elemContext.m_startTagOpen = false;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    protected void fireStartEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string);
        }
    }

    private void flushMyWriter() {
        if (this.m_writer != null) {
            try {
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void fireCDATAEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(10, cArray, n, n2);
        }
    }

    protected void fireCommentEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(8, new String(cArray, n, n2));
        }
    }

    public void fireEndEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
        }
    }

    protected void fireStartDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(1);
        }
    }

    protected void fireEndDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(2);
        }
    }

    protected void fireStartElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(3, string, this.m_attributes);
        }
    }

    protected void fireEscapingEvent(String string, String string2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(7, string, string2);
        }
    }

    protected void fireEntityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string, (Attributes)null);
        }
    }

    public void startDocument() throws SAXException {
        this.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    protected void startDocumentInternal() throws SAXException {
        if (this.m_tracer != null) {
            this.fireStartDoc();
        }
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_sourceLocator = sourceLocator;
    }

    public void setNamespaceMappings(NamespaceMappings namespaceMappings) {
        this.m_prefixMap = namespaceMappings;
    }

    public boolean reset() {
        this.resetSerializerBase();
        return true;
    }

    private void resetSerializerBase() {
        this.m_attributes.clear();
        this.m_cdataSectionElements = null;
        this.m_elemContext = new ElemContext();
        this.m_doctypePublic = null;
        this.m_doctypeSystem = null;
        this.m_doIndent = false;
        this.m_encoding = null;
        this.m_indentAmount = 0;
        this.m_inEntityRef = false;
        this.m_inExternalDTD = false;
        this.m_mediatype = null;
        this.m_needToCallStartDocument = true;
        this.m_needToOutputDocTypeDecl = false;
        if (this.m_prefixMap != null) {
            this.m_prefixMap.reset();
        }
        this.m_shouldNotWriteXMLHeader = false;
        this.m_sourceLocator = null;
        this.m_standalone = null;
        this.m_standaloneWasSpecified = false;
        this.m_tracer = null;
        this.m_transformer = null;
        this.m_version = null;
    }
}

