/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import sun.security.jca.GetInstance;

public class SSLContext {
    private Provider provider;
    private SSLContextSpi contextSpi;
    private String protocol;

    protected SSLContext(SSLContextSpi sSLContextSpi, Provider provider, String string) {
        this.contextSpi = sSLContextSpi;
        this.provider = provider;
        this.protocol = string;
    }

    public static SSLContext getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SSLContext", SSLContextSpi.class, string);
        return new SSLContext((SSLContextSpi)instance.impl, instance.provider, string);
    }

    public static SSLContext getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("SSLContext", SSLContextSpi.class, string, string2);
        return new SSLContext((SSLContextSpi)instance.impl, instance.provider, string);
    }

    public static SSLContext getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SSLContext", SSLContextSpi.class, string, provider);
        return new SSLContext((SSLContextSpi)instance.impl, instance.provider, string);
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.contextSpi.engineInit(keyManagerArray, trustManagerArray, secureRandom);
    }

    public final SSLSocketFactory getSocketFactory() {
        return this.contextSpi.engineGetSocketFactory();
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        return this.contextSpi.engineGetServerSocketFactory();
    }

    public final SSLEngine createSSLEngine() {
        try {
            return this.contextSpi.engineCreateSSLEngine();
        }
        catch (AbstractMethodError abstractMethodError) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Provider: " + this.getProvider() + " doesn't support this operation");
            unsupportedOperationException.initCause(abstractMethodError);
            throw unsupportedOperationException;
        }
    }

    public final SSLEngine createSSLEngine(String string, int n) {
        try {
            return this.contextSpi.engineCreateSSLEngine(string, n);
        }
        catch (AbstractMethodError abstractMethodError) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Provider: " + this.getProvider() + " does not support this operation");
            unsupportedOperationException.initCause(abstractMethodError);
            throw unsupportedOperationException;
        }
    }

    public final SSLSessionContext getServerSessionContext() {
        return this.contextSpi.engineGetServerSessionContext();
    }

    public final SSLSessionContext getClientSessionContext() {
        return this.contextSpi.engineGetClientSessionContext();
    }
}

