/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.SunJCE_b;
import sun.security.jca.GetInstance;

public class SecretKeyFactory {
    private Provider a;
    private final String b;
    private volatile SecretKeyFactorySpi c;
    private final Object d = new Object();
    private Iterator e;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String string) {
        this.c = secretKeyFactorySpi;
        this.a = provider;
        this.b = string;
    }

    private SecretKeyFactory(String string) throws NoSuchAlgorithmException {
        this.b = string;
        List<Provider.Service> list = GetInstance.getServices("SecretKeyFactory", string);
        this.e = list.iterator();
        if (this.a(null) == null) {
            throw new NoSuchAlgorithmException(string + " SecretKeyFactory not available");
        }
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = SunJCE_b.a("SecretKeyFactory", SecretKeyFactorySpi.class, string);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, string);
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = SunJCE_b.a("SecretKeyFactory", SecretKeyFactorySpi.class, string, string2);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, string);
    }

    public static final SecretKeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = SunJCE_b.a("SecretKeyFactory", SecretKeyFactorySpi.class, string, provider);
        return new SecretKeyFactory((SecretKeyFactorySpi)instance.impl, instance.provider, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Provider getProvider() {
        Object object = this.d;
        synchronized (object) {
            this.e = null;
            return this.a;
        }
    }

    public final String getAlgorithm() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKeyFactorySpi a(SecretKeyFactorySpi secretKeyFactorySpi) {
        Object object = this.d;
        synchronized (object) {
            if (secretKeyFactorySpi != null && secretKeyFactorySpi != this.c) {
                return this.c;
            }
            if (this.e == null) {
                return null;
            }
            while (this.e.hasNext()) {
                Provider.Service service = (Provider.Service)this.e.next();
                if (!SunJCE_b.b(service.getProvider())) continue;
                try {
                    Object object2 = service.newInstance(null);
                    if (!(object2 instanceof SecretKeyFactory)) continue;
                    SecretKeyFactorySpi secretKeyFactorySpi2 = (SecretKeyFactorySpi)object2;
                    this.a = service.getProvider();
                    this.c = secretKeyFactorySpi2;
                    return secretKeyFactorySpi2;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
            }
            this.e = null;
            return null;
        }
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.e == null) {
            return this.c.engineGenerateSecret(keySpec);
        }
        Exception exception = null;
        SecretKeyFactorySpi secretKeyFactorySpi = this.c;
        while (true) {
            try {
                return secretKeyFactorySpi.engineGenerateSecret(keySpec);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((secretKeyFactorySpi = this.a(secretKeyFactorySpi)) != null) continue;
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not generate secret key", exception);
            }
            break;
        }
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (this.e == null) {
            return this.c.engineGetKeySpec(secretKey, clazz);
        }
        Exception exception = null;
        SecretKeyFactorySpi secretKeyFactorySpi = this.c;
        while (true) {
            try {
                return secretKeyFactorySpi.engineGetKeySpec(secretKey, clazz);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((secretKeyFactorySpi = this.a(secretKeyFactorySpi)) != null) continue;
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not get key spec", exception);
            }
            break;
        }
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        if (this.e == null) {
            return this.c.engineTranslateKey(secretKey);
        }
        Exception exception = null;
        SecretKeyFactorySpi secretKeyFactorySpi = this.c;
        while (true) {
            try {
                return secretKeyFactorySpi.engineTranslateKey(secretKey);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((secretKeyFactorySpi = this.a(secretKeyFactorySpi)) != null) continue;
                if (exception instanceof InvalidKeyException) {
                    throw (InvalidKeyException)exception;
                }
                throw new InvalidKeyException("Could not translate key", exception);
            }
            break;
        }
    }
}

