/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;

public final class Locale
implements Serializable,
Cloneable {
    public static final Locale ENGLISH = new Locale("en");
    public static final Locale FRENCH = new Locale("fr");
    public static final Locale GERMAN = new Locale("de");
    public static final Locale ITALIAN = new Locale("it");
    public static final Locale JAPANESE = new Locale("ja");
    public static final Locale KOREAN = new Locale("ko");
    public static final Locale CHINESE = new Locale("zh");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW");
    public static final Locale FRANCE = new Locale("fr", "FR");
    public static final Locale GERMANY = new Locale("de", "DE");
    public static final Locale ITALY = new Locale("it", "IT");
    public static final Locale JAPAN = new Locale("ja", "JP");
    public static final Locale KOREA = new Locale("ko", "KR");
    public static final Locale CHINA;
    public static final Locale PRC;
    public static final Locale TAIWAN;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    private static final long serialVersionUID = 9149081749638150636L;
    private String language;
    private String country;
    private String variant;
    private int hashcode;
    private static Locale defaultLocale;

    private String convertLanguage(String language) {
        if (language.equals("")) {
            return language;
        }
        int index = "he,id,yi".indexOf(language = language.toLowerCase());
        if (index != -1) {
            return "iw,in,ji".substring(index, index + 2);
        }
        return language;
    }

    public Locale(String language, String country, String variant) {
        if (defaultLocale != null) {
            language = this.convertLanguage(language).intern();
            country = country.toUpperCase().intern();
            variant = variant.toUpperCase().intern();
        }
        this.language = language;
        this.country = country;
        this.variant = variant;
        this.hashcode = language.hashCode() ^ country.hashCode() ^ variant.hashCode();
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language) {
        this(language, "", "");
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public static void setDefault(Locale newLocale) {
        if (newLocale == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = newLocale;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{ENGLISH, FRENCH, GERMAN, new Locale("ga", "")};
    }

    public static String[] getISOCountries() {
        return new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZR", "ZW"};
    }

    public static String[] getISOLanguages() {
        return new String[]{"aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "he", "hi", "hr", "hu", "hy", "ia", "id", "ie", "ik", "in", "is", "it", "iu", "iw", "ja", "ji", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "ky", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ug", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        if (this.language.length() == 0 && this.country.length() == 0) {
            return "";
        }
        if (this.country.length() == 0 && this.variant.length() == 0) {
            return this.language;
        }
        StringBuffer result = new StringBuffer(this.language);
        result.append('_').append(this.country);
        if (this.variant.length() != 0) {
            result.append('_').append(this.variant);
        }
        return result.toString();
    }

    public String getISO3Language() {
        if (this.language == "") {
            return "";
        }
        int index = "aa,ab,af,am,ar,as,ay,az,ba,be,bg,bh,bi,bn,bo,br,ca,co,cs,cy,da,de,dz,el,en,eo,es,et,eu,fa,fi,fj,fo,fr,fy,ga,gd,gl,gn,gu,ha,iw,hi,hr,hu,hy,ia,in,ie,ik,in,is,it,iu,iw,ja,ji,jw,ka,kk,kl,km,kn,ko,ks,ku,ky,la,ln,lo,lt,lv,mg,mi,mk,ml,mn,mo,mr,ms,mt,my,na,ne,nl,no,oc,om,or,pa,pl,ps,pt,qu,rm,rn,ro,ru,rw,sa,sd,sg,sh,si,sk,sl,sm,sn,so,sq,sr,ss,st,su,sv,sw,ta,te,tg,th,ti,tk,tl,tn,to,tr,ts,tt,tw,ug,uk,ur,uz,vi,vo,wo,xh,ji,yo,za,zh,zu".indexOf(this.language);
        if (index % 3 != 0 || this.language.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 language for " + this.language, "java.util.Locale", this.language);
        }
        return "aarabkaframharaasmaymazebakbelbulbihbisbenbodbrecatcoscescymdandeudzoellengepospaesteusfasfinfijfaofrafrygaigdhglggrngujhauhebhinhrvhunhyeinaindileipkindislitaikuhebjpnyidjawkatkazkalkhmkankorkaskurkirlatlinlaolitlavmlgmrimkdmalmonmolmarmsamltmyanaunepnldnorociormoripanpolpusporquerohrunronruskinsansndsagsrpsinslkslvsmosnasomsqisrpsswsotsunsweswatamteltgkthatirtuktgltsntonturtsotattwiuigukrurduzbvievolwolxhoyidyorzhazhozul".substring(index, index + 3);
    }

    public String getISO3Country() {
        if (this.country == "") {
            return "";
        }
        int index = "AD,AE,AF,AG,AI,AL,AM,AN,AO,AQ,AR,AS,AT,AU,AW,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BV,BW,BY,BZ,CA,CC,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CU,CV,CX,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,EH,ER,ES,ET,FI,FJ,FK,FM,FO,FR,FX,GA,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,GY,HK,HM,HN,HR,HT,HU,ID,IE,IL,IN,IO,IQ,IR,IS,IT,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MC,MD,MG,MH,MK,ML,MM,MN,MO,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NC,NE,NF,NG,NI,NL,NO,NP,NR,NU,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PN,PR,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SH,SI,SJ,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TF,TG,TH,TJ,TK,TM,TN,TO,TP,TR,TT,TV,TW,TZ,UA,UG,UM,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,YU,ZA,ZM,ZR,ZW".indexOf(this.country);
        if (index % 3 != 0 || this.country.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 country for " + this.country, "java.util.Locale", this.country);
        }
        return "ANDAREAFGATGAIAALBARMANTAGOATAARGASMAUTAUSABWAZEBIHBRBBGDBELBFABGRBHRBDIBENBMUBRNBOLBRABHSBTNBVTBWABLRBLZCANCCKCAFCOGCHECIVCOKCHLCMRCHNCOLCRICUBCPVCXRCYPCZEDEUDJIDNKDMADOMDZAECUESTEGYESHERIESPETHFINFJIFLKFSMFROFRAFXXGABGBRGRDGEOGUFGHAGIBGRLGMBGINGLPGNQGRCSGSGTMGUMGNBGUYHKGHMDHNDHRVHTIHUNIDNIRLISRINDIOTIRQIRNISLITAJAMJORJPNKENKGZKHMKIRCOMKNAPRKKORKWTCYMKAZLAOLBNLCALIELKALBRLSOLTULUXLVALBYMARMCOMDAMDGMHLMKDMLIMMRMNGMACMNPMTQMRTMSRMLTMUSMDVMWIMEXMYSMOZNAMNCLNERNFKNGANICNLDNORNPLNRUNIUNZLOMNPANPERPYFPNGPHLPAKPOLSPMPCNPRIPRTPLWPRYQATREUROMRUSRWASAUSLBSYCSDNSWESGPSHNSVNSJMSVKSLESMRSENSOMSURSTPSLVSYRSWZTCATCDATFTGOTHATJKTKLTKMTUNTONTMPTURTTOTUVTWNTZAUKRUGAUMIUSAURYUZBVATVCTVENVGBVIRVNMVUTWLFWSMYEMMYTYUGZAFZMBZARZWE".substring(index, index + 3);
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(defaultLocale);
    }

    public String getDisplayLanguage(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("gnu.java.locale.iso639", locale);
            return bundle.getString(this.language);
        }
        catch (MissingResourceException ex) {
            return this.language;
        }
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(defaultLocale);
    }

    public String getDisplayCountry(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("gnu.java.locale.iso3166", locale);
            return bundle.getString(this.country);
        }
        catch (MissingResourceException ex) {
            return this.country;
        }
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(defaultLocale);
    }

    public String getDisplayVariant(Locale locale) {
        return this.variant;
    }

    public final String getDisplayName() {
        return this.getDisplayName(defaultLocale);
    }

    public String getDisplayName(Locale locale) {
        StringBuffer result = new StringBuffer();
        int count = 0;
        String[] delimiters = new String[]{"", " (", ","};
        if (this.language.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayLanguage(locale));
        }
        if (this.country.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayCountry(locale));
        }
        if (this.variant.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayVariant(locale));
        }
        if (count > 1) {
            result.append(")");
        }
        return result.toString();
    }

    public Object clone() {
        return new Locale(this.language, this.country, this.variant);
    }

    public synchronized int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale l = (Locale)obj;
        return this.language == l.language && this.country == l.country && this.variant == l.variant;
    }

    private synchronized void writeObject(ObjectOutputStream output) throws IOException {
        int tmpHashcode = this.hashcode;
        this.hashcode = -1;
        output.defaultWriteObject();
        this.hashcode = tmpHashcode;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    static {
        PRC = CHINA = SIMPLIFIED_CHINESE;
        TAIWAN = TRADITIONAL_CHINESE;
        UK = new Locale("en", "GB");
        US = new Locale("en", "US");
        CANADA = new Locale("en", "CA");
        CANADA_FRENCH = new Locale("fr", "CA");
        defaultLocale = new Locale(System.getProperty("user.language", "en"), System.getProperty("user.region", ""), System.getProperty("user.variant", ""));
    }
}

