/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.io.Base64InputStream;
import gnu.java.security.x509.X509CRL;
import gnu.java.security.x509.X509Certificate;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.LinkedList;

public class X509CertificateFactory
extends CertificateFactorySpi {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_X509_CRL = "-----BEGIN X509 CRL-----";
    public static final String END_X509_CRL = "-----END X509 CRL-----";

    public Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException {
        try {
            return this.generateCert(inStream);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        LinkedList certs = new LinkedList();
        while (true) {
            try {
                certs.add(this.generateCert(inStream));
            }
            catch (EOFException eof) {
                break;
            }
            catch (IOException ioe) {
                throw new CertificateException(ioe.toString());
            }
        }
        return certs;
    }

    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        try {
            return this.generateCRL(inStream);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        LinkedList crls = new LinkedList();
        while (true) {
            try {
                crls.add(this.generateCRL(inStream));
            }
            catch (EOFException eof) {
                break;
            }
            catch (IOException ioe) {
                throw new CRLException(ioe.toString());
            }
        }
        return crls;
    }

    private X509Certificate generateCert(InputStream inStream) throws IOException, CertificateException {
        if (!inStream.markSupported()) {
            inStream = new BufferedInputStream(inStream, 8192);
        }
        inStream.mark(20);
        int i = inStream.read();
        if (i == -1) {
            throw new EOFException();
        }
        if (i != 48) {
            inStream.reset();
            StringBuffer line = new StringBuffer(80);
            do {
                line.setLength(0);
                do {
                    if ((i = inStream.read()) == -1) {
                        throw new EOFException();
                    }
                    if (i == 10 || i == 13) continue;
                    line.append((char)i);
                } while (i != 10 && i != 13);
            } while (!line.toString().equals(BEGIN_CERTIFICATE));
            X509Certificate ret = new X509Certificate(new BufferedInputStream(new Base64InputStream(inStream), 8192));
            line.setLength(0);
            line.append('-');
            do {
                if ((i = inStream.read()) == -1) {
                    throw new EOFException();
                }
                if (i == 10 || i == 13) continue;
                line.append((char)i);
            } while (i != 10 && i != 13);
            if (!line.toString().equals(END_CERTIFICATE)) {
                throw new CertificateException("no end-of-certificate marker");
            }
            return ret;
        }
        inStream.reset();
        return new X509Certificate(inStream);
    }

    private X509CRL generateCRL(InputStream inStream) throws IOException, CRLException {
        if (!inStream.markSupported()) {
            inStream = new BufferedInputStream(inStream, 8192);
        }
        inStream.mark(20);
        int i = inStream.read();
        if (i == -1) {
            throw new EOFException();
        }
        if (i != 48) {
            inStream.reset();
            StringBuffer line = new StringBuffer(80);
            do {
                line.setLength(0);
                do {
                    if ((i = inStream.read()) == -1) {
                        throw new EOFException();
                    }
                    if (i == 10 || i == 13) continue;
                    line.append((char)i);
                } while (i != 10 && i != 13);
            } while (!line.toString().startsWith(BEGIN_X509_CRL));
            X509CRL ret = new X509CRL(new BufferedInputStream(new Base64InputStream(inStream), 8192));
            line.setLength(0);
            line.append('-');
            do {
                if ((i = inStream.read()) == -1) {
                    throw new EOFException();
                }
                if (i == 10 || i == 13) continue;
                line.append((char)i);
            } while (i != 10 && i != 13);
            if (!line.toString().startsWith(END_X509_CRL)) {
                throw new CRLException("no end-of-CRL marker");
            }
            return ret;
        }
        inStream.reset();
        return new X509CRL(inStream);
    }
}

