/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstatd;

import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import sun.jvmstat.monitor.remote.RemoteHost;
import sun.tools.jstatd.RemoteHostImpl;

public class Jstatd {
    private static Registry registry;
    private static int port;
    private static boolean startRegistry;

    private static void printUsage() {
        System.err.println("usage: jstatd [-nr] [-p port] [-n rminame]");
    }

    static void bind(String string, RemoteHostImpl remoteHostImpl) throws RemoteException, MalformedURLException, Exception {
        try {
            Naming.rebind(string, remoteHostImpl);
        }
        catch (ConnectException connectException) {
            if (startRegistry && registry == null) {
                int n = port < 0 ? 1099 : port;
                registry = LocateRegistry.createRegistry(n);
                Jstatd.bind(string, remoteHostImpl);
            } else {
                System.out.println("Could not contact registry\n" + connectException.getMessage());
                connectException.printStackTrace();
            }
        }
        catch (RemoteException remoteException) {
            System.err.println("Could not bind " + string + " to RMI Registry");
            remoteException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        CharSequence charSequence;
        int n;
        String string = null;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            charSequence = stringArray[n];
            if (((String)charSequence).compareTo("-nr") == 0) {
                startRegistry = false;
                continue;
            }
            if (((String)charSequence).startsWith("-p")) {
                if (((String)charSequence).compareTo("-p") != 0) {
                    port = Integer.parseInt(((String)charSequence).substring(2));
                    continue;
                }
                if (++n >= stringArray.length) {
                    Jstatd.printUsage();
                    System.exit(1);
                }
                port = Integer.parseInt(stringArray[n]);
                continue;
            }
            if (((String)charSequence).startsWith("-n")) {
                if (((String)charSequence).compareTo("-n") != 0) {
                    string = ((String)charSequence).substring(2);
                    continue;
                }
                if (++n >= stringArray.length) {
                    Jstatd.printUsage();
                    System.exit(1);
                }
                string = stringArray[n];
                continue;
            }
            Jstatd.printUsage();
            System.exit(1);
        }
        if (n < stringArray.length) {
            Jstatd.printUsage();
            System.exit(1);
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        charSequence = new StringBuilder();
        if (port >= 0) {
            ((StringBuilder)charSequence).append("//:").append(port);
        }
        if (string == null) {
            string = "JStatRemoteHost";
        }
        ((StringBuilder)charSequence).append("/").append(string);
        try {
            System.setProperty("java.rmi.server.ignoreSubClasses", "true");
            RemoteHostImpl remoteHostImpl = new RemoteHostImpl();
            RemoteHost remoteHost = (RemoteHost)UnicastRemoteObject.exportObject((Remote)remoteHostImpl, 0);
            Jstatd.bind(((StringBuilder)charSequence).toString(), remoteHostImpl);
        }
        catch (MalformedURLException malformedURLException) {
            if (string != null) {
                System.out.println("Bad RMI server name: " + string);
            } else {
                System.out.println("Bad RMI URL: " + charSequence + " : " + malformedURLException.getMessage());
            }
            System.exit(1);
        }
        catch (ConnectException connectException) {
            System.out.println("Could not contact RMI registry\n" + connectException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.out.println("Could not create remote object\n" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static {
        port = -1;
        startRegistry = true;
    }
}

