/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.jvm.hotspot.c1.Runtime1;
import sun.jvm.hotspot.code.CodeCache;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.interpreter.Interpreter;
import sun.jvm.hotspot.interpreter.SharedInfo;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.runtime.Bytes;
import sun.jvm.hotspot.runtime.JNIHandles;
import sun.jvm.hotspot.runtime.ObjectSynchronizer;
import sun.jvm.hotspot.runtime.StubRoutines;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VMVersionMismatchException;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.CStringUtilities;
import sun.jvm.hotspot.utilities.ObjectReader;
import sun.jvm.hotspot.utilities.PlatformInfo;
import sun.jvm.hotspot.utilities.ReversePtrs;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;

public class VM {
    private static VM soleInstance;
    private static List vmInitializedObservers;
    private List vmResumedObservers = new ArrayList();
    private List vmSuspendedObservers = new ArrayList();
    private TypeDataBase db;
    private boolean isBigEndian;
    private JVMDebugger debugger;
    private long stackBias;
    private long logAddressSize;
    private Universe universe;
    private ObjectHeap heap;
    private SymbolTable symbols;
    private SystemDictionary dict;
    private Threads threads;
    private ObjectSynchronizer synchronizer;
    private JNIHandles handles;
    private Interpreter interpreter;
    private StubRoutines stubRoutines;
    private SharedInfo sharedInfo;
    private Bytes bytes;
    private boolean usingClientCompiler;
    private boolean usingServerCompiler;
    private boolean useTLAB;
    private CodeCache codeCache;
    private Runtime1 runtime1;
    private int invocationEntryBCI;
    private int invalidOSREntryBCI;
    private ReversePtrs revPtrs;
    private Properties sysProps;
    private String vmRelease;
    private String vmInternalInfo;
    private Flag[] commandLineFlags;
    private static Type intxType;
    private static Type uintxType;
    private static final boolean versionCheckEnabled;
    private static final boolean disableDerivedPrinterTableCheck;

    private static void checkVMVersion(String version) {
        Pattern p;
        Matcher m;
        if (versionCheckEnabled && !(m = (p = Pattern.compile("\\d{14}\\.[a-zA-Z]\\w*\\.[a-zA-Z]\\w*")).matcher(version)).matches() && !version.startsWith("1.5.0")) {
            throw new VMVersionMismatchException("1.5.0, 1.5.0_xx", version);
        }
    }

    private VM(TypeDataBase db, JVMDebugger debugger, boolean isBigEndian) {
        this.db = db;
        this.debugger = debugger;
        this.isBigEndian = isBigEndian;
        if (db.getAddressSize() == 4L) {
            this.logAddressSize = 2L;
        } else if (db.getAddressSize() == 8L) {
            this.logAddressSize = 3L;
        } else {
            throw new RuntimeException("Address size " + db.getAddressSize() + " not yet supported");
        }
        try {
            Type vmVersion = db.lookupType("Abstract_VM_Version");
            Address releaseAddr = vmVersion.getAddressField("_s_vm_release").getValue();
            this.vmRelease = CStringUtilities.getString(releaseAddr);
            Address vmInternalInfoAddr = vmVersion.getAddressField("_s_internal_vm_info_string").getValue();
            this.vmInternalInfo = CStringUtilities.getString(vmInternalInfoAddr);
        }
        catch (Exception exp) {
            throw new RuntimeException("can't determine target's VM version : " + exp.getMessage());
        }
        VM.checkVMVersion(this.vmRelease);
        this.stackBias = db.lookupIntConstant("STACK_BIAS").intValue();
        this.invocationEntryBCI = db.lookupIntConstant("InvocationEntryBci");
        this.invalidOSREntryBCI = db.lookupIntConstant("InvalidOSREntryBci");
        Type type = db.lookupType("methodOopDesc");
        if (type.getField("_from_compiled_code_entry_point", false, false) == null) {
            this.usingClientCompiler = false;
            this.usingServerCompiler = false;
        } else if (type.getField("_interpreter_invocation_count", false, false) != null) {
            this.usingServerCompiler = true;
        } else {
            this.usingClientCompiler = true;
        }
        this.useTLAB = db.lookupIntConstant("UseTLAB") != 0;
        intxType = db.lookupType("intx");
        uintxType = db.lookupType("uintx");
    }

    public static void initialize(TypeDataBase db, boolean isBigEndian) {
        if (soleInstance != null) {
            throw new RuntimeException("Attempt to initialize VM twice");
        }
        soleInstance = new VM(db, null, isBigEndian);
        Iterator iter = vmInitializedObservers.iterator();
        while (iter.hasNext()) {
            ((Observer)iter.next()).update(null, null);
        }
    }

    public static void initialize(TypeDataBase db, JVMDebugger debugger) {
        if (soleInstance != null) {
            throw new RuntimeException("Attempt to initialize VM twice");
        }
        soleInstance = new VM(db, debugger, debugger.getMachineDescription().isBigEndian());
        Iterator iter = vmInitializedObservers.iterator();
        while (iter.hasNext()) {
            ((Observer)iter.next()).update(null, null);
        }
    }

    public static void shutdown() {
        soleInstance = null;
    }

    public static void registerVMInitializedObserver(Observer o) {
        vmInitializedObservers.add(o);
        o.update(null, null);
    }

    public static VM getVM() {
        if (soleInstance == null) {
            throw new RuntimeException("VM.initialize() was not yet called");
        }
        return soleInstance;
    }

    public void registerVMResumedObserver(Observer o) {
        this.vmResumedObservers.add(o);
    }

    public void registerVMSuspendedObserver(Observer o) {
        this.vmSuspendedObservers.add(o);
    }

    public void fireVMResumed() {
        Iterator iter = this.vmResumedObservers.iterator();
        while (iter.hasNext()) {
            ((Observer)iter.next()).update(null, null);
        }
    }

    public void fireVMSuspended() {
        Iterator iter = this.vmSuspendedObservers.iterator();
        while (iter.hasNext()) {
            ((Observer)iter.next()).update(null, null);
        }
    }

    public String getOS() {
        if (this.debugger != null) {
            return this.debugger.getOS();
        }
        return PlatformInfo.getOS();
    }

    public String getCPU() {
        if (this.debugger != null) {
            return this.debugger.getCPU();
        }
        return PlatformInfo.getCPU();
    }

    public Type lookupType(String cTypeName) {
        return this.db.lookupType(cTypeName);
    }

    public Integer lookupIntConstant(String name) {
        return this.db.lookupIntConstant(name);
    }

    public long getAddressSize() {
        return this.db.getAddressSize();
    }

    public long getOopSize() {
        return this.db.getOopSize();
    }

    public long getLogAddressSize() {
        return this.logAddressSize;
    }

    public long getStackBias() {
        return this.stackBias;
    }

    public boolean isLP64() {
        Assert.that(this.isDebugging(), "Debugging system only for now");
        return this.debugger.getMachineDescription().isLP64();
    }

    public int getBytesPerLong() {
        return this.lookupIntConstant("BytesPerLong");
    }

    public int getMinObjAlignmentInBytes() {
        return this.lookupIntConstant("MinObjAlignmentInBytes");
    }

    public long alignUp(long size, long alignment) {
        return size + alignment - 1L & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long alignDown(long size, long alignment) {
        return size & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int buildIntFromShorts(short low, short high) {
        return high << 16 | low & 0xFFFF;
    }

    public long buildLongFromIntsPD(int oneHalf, int otherHalf) {
        if (this.isBigEndian) {
            return (long)otherHalf << 32 | (long)oneHalf & 0xFFFFFFFFL;
        }
        return (long)oneHalf << 32 | (long)otherHalf & 0xFFFFFFFFL;
    }

    public boolean getUseTLAB() {
        return this.useTLAB;
    }

    public TypeDataBase getTypeDataBase() {
        return this.db;
    }

    public Universe getUniverse() {
        if (this.universe == null) {
            this.universe = new Universe();
        }
        return this.universe;
    }

    public ObjectHeap getObjectHeap() {
        if (this.heap == null) {
            this.heap = new ObjectHeap(this.db);
        }
        return this.heap;
    }

    public SymbolTable getSymbolTable() {
        if (this.symbols == null) {
            this.symbols = SymbolTable.getTheTable();
        }
        return this.symbols;
    }

    public SystemDictionary getSystemDictionary() {
        if (this.dict == null) {
            this.dict = new SystemDictionary();
        }
        return this.dict;
    }

    public Threads getThreads() {
        if (this.threads == null) {
            this.threads = new Threads();
        }
        return this.threads;
    }

    public ObjectSynchronizer getObjectSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new ObjectSynchronizer();
        }
        return this.synchronizer;
    }

    public JNIHandles getJNIHandles() {
        if (this.handles == null) {
            this.handles = new JNIHandles();
        }
        return this.handles;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new Interpreter();
        }
        return this.interpreter;
    }

    public StubRoutines getStubRoutines() {
        if (this.stubRoutines == null) {
            this.stubRoutines = new StubRoutines();
        }
        return this.stubRoutines;
    }

    public SharedInfo getSharedInfo() {
        if (this.sharedInfo == null) {
            this.sharedInfo = new SharedInfo();
        }
        return this.sharedInfo;
    }

    public Bytes getBytes() {
        if (this.bytes == null) {
            this.bytes = new Bytes(this.debugger.getMachineDescription());
        }
        return this.bytes;
    }

    public boolean isCore() {
        return !this.usingClientCompiler && !this.usingServerCompiler;
    }

    public boolean isClientCompiler() {
        return this.usingClientCompiler;
    }

    public boolean isServerCompiler() {
        return this.usingServerCompiler;
    }

    public boolean useDerivedPointerTable() {
        return !disableDerivedPrinterTableCheck;
    }

    public CodeCache getCodeCache() {
        Assert.that(!this.isCore(), "noncore builds only");
        if (this.codeCache == null) {
            this.codeCache = new CodeCache();
        }
        return this.codeCache;
    }

    public Runtime1 getRuntime1() {
        Assert.that(this.isClientCompiler(), "C1 builds only");
        if (this.runtime1 == null) {
            this.runtime1 = new Runtime1();
        }
        return this.runtime1;
    }

    public boolean isDebugging() {
        return this.debugger != null;
    }

    public JVMDebugger getDebugger() {
        if (this.debugger == null) {
            throw new RuntimeException("Attempt to use debugger in runtime system");
        }
        return this.debugger;
    }

    public boolean isJavaPCDbg(Address addr) {
        return this.getInterpreter().contains(addr) || this.getCodeCache().contains(addr);
    }

    public int getInvocationEntryBCI() {
        return this.invocationEntryBCI;
    }

    public int getInvalidOSREntryBCI() {
        return this.invalidOSREntryBCI;
    }

    public boolean wizardMode() {
        return true;
    }

    public ReversePtrs getRevPtrs() {
        return this.revPtrs;
    }

    public void setRevPtrs(ReversePtrs rp) {
        this.revPtrs = rp;
    }

    public String getVMRelease() {
        return this.vmRelease;
    }

    public String getVMInternalInfo() {
        return this.vmInternalInfo;
    }

    public Flag[] getCommandLineFlags() {
        if (this.commandLineFlags == null) {
            this.readCommandLineFlags();
        }
        return this.commandLineFlags;
    }

    private void readCommandLineFlags() {
        TypeDataBase db = this.getTypeDataBase();
        try {
            Type flagType = db.lookupType("Flag");
            int numFlags = (int)flagType.getCIntegerField("numFlags").getValue();
            this.commandLineFlags = new Flag[numFlags - 1];
            Address flagAddr = flagType.getAddressField("flags").getValue();
            AddressField typeFld = flagType.getAddressField("type");
            AddressField nameFld = flagType.getAddressField("name");
            AddressField addrFld = flagType.getAddressField("addr");
            AddressField kindFld = flagType.getAddressField("kind");
            long flagSize = flagType.getSize();
            for (int f = 0; f < numFlags - 1; ++f) {
                String type = CStringUtilities.getString(typeFld.getValue(flagAddr));
                String name = CStringUtilities.getString(nameFld.getValue(flagAddr));
                Address addr = addrFld.getValue(flagAddr);
                String kind = CStringUtilities.getString(kindFld.getValue(flagAddr));
                this.commandLineFlags[f] = new Flag(type, name, addr, kind);
                flagAddr = flagAddr.addOffsetTo(flagSize);
            }
            Arrays.sort(this.commandLineFlags, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Flag f1 = (Flag)o1;
                    Flag f2 = (Flag)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSystemProperty(String key) {
        Properties props = this.getSystemProperties();
        return props != null ? props.getProperty(key) : null;
    }

    public Properties getSystemProperties() {
        if (this.sysProps == null) {
            this.readSystemProperties();
        }
        return this.sysProps;
    }

    private void readSystemProperties() {
        InstanceKlass systemKls = SystemDictionaryHelper.findInstanceKlass("java.lang.System");
        systemKls.iterate(new DefaultOopVisitor(){
            ObjectReader objReader = new ObjectReader();

            public void doOop(OopField field, boolean isVMField) {
                if (field.getID().getName().equals("props")) {
                    try {
                        VM.this.sysProps = (Properties)this.objReader.readObject(field.getValue(this.getObj()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, false);
    }

    static {
        vmInitializedObservers = new ArrayList();
        versionCheckEnabled = System.getProperty("sun.jvm.hotspot.runtime.VM.disableVersionCheck") == null;
        disableDerivedPrinterTableCheck = System.getProperty("sun.jvm.hotspot.runtime.VM.disableDerivedPointerTableCheck") != null;
    }

    public static final class Flag {
        private String type;
        private String name;
        private Address addr;
        private String kind;

        private Flag(String type, String name, Address addr, String kind) {
            this.type = type;
            this.name = name;
            this.addr = addr;
            this.kind = kind;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Address getAddress() {
            return this.addr;
        }

        public String getKind() {
            return this.kind;
        }

        public boolean isBool() {
            return this.type.equals("bool");
        }

        public boolean getBool() {
            Assert.that(this.isBool(), "not a bool flag!");
            return this.addr.getJIntAt(0L) != 0;
        }

        public boolean isIntx() {
            return this.type.equals("intx");
        }

        public long getIntx() {
            Assert.that(this.isIntx(), "not a intx flag!");
            return this.addr.getCIntegerAt(0L, intxType.getSize(), false);
        }

        public boolean isUIntx() {
            return this.type.equals("uintx");
        }

        public long getUIntx() {
            Assert.that(this.isUIntx(), "not a uintx flag!");
            return this.addr.getCIntegerAt(0L, uintxType.getSize(), true);
        }

        public String getValue() {
            if (this.isBool()) {
                return new Boolean(this.getBool()).toString();
            }
            if (this.isIntx()) {
                return new Long(this.getIntx()).toString();
            }
            if (this.isUIntx()) {
                return new Long(this.getUIntx()).toString();
            }
            return null;
        }
    }
}

