/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class WindowsToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsToolBarSeparatorUI();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = ((JToolBar.Separator)jComponent).getSeparatorSize();
        if (dimension != null) {
            dimension = dimension.getSize();
        } else {
            dimension = new Dimension(6, 6);
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                boolean bl = ((JSeparator)jComponent).getOrientation() == 1;
                String string = bl ? "toolbar.separator" : "toolbar.separatorvert";
                XPStyle.Skin skin = xPStyle.getSkin(jComponent, string);
                dimension.width = skin.getWidth();
                dimension.height = skin.getHeight();
            }
            if (((JSeparator)jComponent).getOrientation() == 1) {
                dimension.height = 0;
            } else {
                dimension.width = 0;
            }
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl = ((JSeparator)jComponent).getOrientation() == 1;
        Dimension dimension = jComponent.getSize();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            String string = bl ? "toolbar.separator" : "toolbar.separatorvert";
            XPStyle.Skin skin = xPStyle.getSkin(jComponent, string);
            int n = bl ? (dimension.width - skin.getWidth()) / 2 : 0;
            int n2 = bl ? 0 : (dimension.height - skin.getHeight()) / 2;
            int n3 = bl ? skin.getWidth() : dimension.width;
            int n4 = bl ? dimension.height : skin.getHeight();
            skin.paintSkin(graphics, n, n2, n3, n4, 0);
        } else {
            Color color = graphics.getColor();
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            Color color2 = uIDefaults.getColor("ToolBar.shadow");
            Color color3 = uIDefaults.getColor("ToolBar.highlight");
            if (bl) {
                int n = dimension.width / 2 - 1;
                graphics.setColor(color2);
                graphics.drawLine(n, 2, n, dimension.height - 2);
                graphics.setColor(color3);
                graphics.drawLine(n + 1, 2, n + 1, dimension.height - 2);
            } else {
                int n = dimension.height / 2 - 1;
                graphics.setColor(color2);
                graphics.drawLine(2, n, dimension.width - 2, n);
                graphics.setColor(color3);
                graphics.drawLine(2, n + 1, dimension.width - 2, n + 1);
            }
            graphics.setColor(color);
        }
    }
}

