/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.xml.BadTokenException;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.XMLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class VFolderEditor {
    private static final String ALL_VFOLDER_INFO = File.separator + "etc" + File.separator + "gnome" + File.separator + "gnome-vfs-2.0" + File.separator + "vfolders" + File.separator + "applications-all-users.vfolder-info";
    private static final String USER_VFOLDER_INFO = System.getProperty("user.home") + File.separator + ".gnome2" + File.separator + "vfolders" + File.separator + "applications.vfolder-info";
    private static final String RH8_VFOLDER_INFO = File.separator + "etc" + File.separator + "X11" + File.separator + "desktop-menus" + File.separator + "applications.menu";
    private static final String appAlluserFolderinfo = "<Name>Applications</Name>\n<Parent>applications-all-users:///</Parent>\n";

    private VFolderEditor() {
    }

    private String extractXMLDeclaration(String string) {
        String string2 = "";
        int n = string.indexOf("<?");
        int n2 = string.indexOf("?>");
        if (n == -1 || n2 == -1) {
            return "";
        }
        string2 = string.substring(n, n2 + 2) + "\n";
        Trace.println((String)("extract xmlDecl: " + string2), (TraceLevel)TraceLevel.BASIC);
        return string2;
    }

    private File getVfolderInfoFile(boolean bl) {
        File file = null;
        file = bl ? new File(ALL_VFOLDER_INFO) : new File(USER_VFOLDER_INFO);
        if (!file.exists()) {
            File file2;
            File file3 = file.getParentFile();
            if (!file3.exists()) {
                try {
                    file3.mkdirs();
                }
                catch (SecurityException securityException) {
                    file = null;
                }
            } else if (!file3.canWrite()) {
                file = null;
            }
            if (Config.getOSName().equals("Linux") && (file2 = new File(RH8_VFOLDER_INFO)).exists() && file2.canRead()) {
                file = file2;
            }
        }
        if (file != null) {
            Trace.println((String)("getVfolderInfoFile(" + bl + ") -> " + file.getAbsolutePath()), (TraceLevel)TraceLevel.BASIC);
        }
        return file;
    }

    public static void updateVFolderInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        new VFolderEditor().updateVFolderInfoInternal(string, string2, string3, bl, bl2);
    }

    private void updateVFolderInfoInternal(String string, String string2, String string3, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = this.getVfolderInfoFile(bl);
        if (file == null) {
            Trace.println((String)"VFolderFile update failed!", (TraceLevel)TraceLevel.BASIC);
        } else {
            int n = (int)file.length();
            XMLNode xMLNode = null;
            try {
                FileReader fileReader = new FileReader(file);
                char[] cArray = new char[n];
                fileReader.read(cArray, 0, n);
                fileReader.close();
                String string4 = new String(cArray);
                Trace.println((String)("CURRENT VFolderFile: " + string4), (TraceLevel)TraceLevel.BASIC);
                stringBuffer.append(this.extractXMLDeclaration(string4));
                try {
                    xMLNode = new XMLParser(string4).parse();
                    if (!xMLNode.getName().equals("VFolderInfo")) {
                        Trace.println((String)"root node not found", (TraceLevel)TraceLevel.BASIC);
                        return;
                    }
                    this.updateVFolderInfoFile(xMLNode, string, string2, string3, bl, bl2, stringBuffer);
                }
                catch (BadTokenException badTokenException) {
                    Trace.ignoredException((Exception)((Object)badTokenException));
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.ignoredException((Exception)fileNotFoundException);
                this.createNewVFolderContents(string, string2, string3, bl, stringBuffer);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
                return;
            }
            Trace.println((String)("UPDATED VFolderFile: " + stringBuffer), (TraceLevel)TraceLevel.BASIC);
            this.writeVFolderFile(new File(USER_VFOLDER_INFO), stringBuffer);
        }
    }

    private void createNewVFolderContents(String string, String string2, String string3, boolean bl, StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        stringBuffer.append("<VFolderInfo>\n");
        this.addNewFolderInfo(string, string2, string3, !bl, true, true, stringBuffer);
        stringBuffer.append("</VFolderInfo>\n");
    }

    private void writeVFolderFile(File file, StringBuffer stringBuffer) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
    }

    private void addNewFolderInfo(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append("<Folder>\n");
            stringBuffer.append(appAlluserFolderinfo);
        }
        if (bl2) {
            stringBuffer.append("<Folder>\n");
            stringBuffer.append("<Name>" + string + "</Name>\n");
        }
        if (string2 != null) {
            String string4 = string2.replaceAll("//", "/");
            stringBuffer.append("<Desktop>" + string4 + "</Desktop>\n");
        }
        if (bl3) {
            stringBuffer.append("<Query>\n<And>\n<Keyword>Application</Keyword>\n<Keyword>" + string + "</Keyword>\n</And>\n</Query>\n");
        }
        if (string3 != null) {
            stringBuffer.append("<Include>" + string3 + "</Include>\n");
        }
        if (bl2) {
            stringBuffer.append("</Folder>\n");
        }
        if (bl) {
            stringBuffer.append("</Folder>\n");
        }
    }

    private void searchForFolder(XMLNode xMLNode, final String string, final String string2, final String string3, final boolean bl, final Boolean[] booleanArray, final StringBuffer stringBuffer) {
        final Boolean[] booleanArray2 = new Boolean[]{Boolean.FALSE};
        final Boolean[] booleanArray3 = new Boolean[]{Boolean.TRUE};
        while (xMLNode != null) {
            Trace.println((String)("searchForFolder: XMLNode: " + xMLNode), (TraceLevel)TraceLevel.BASIC);
            stringBuffer.append("<" + xMLNode.getName() + ">\n");
            try {
                XMLUtils.visitChildrenElements(xMLNode, new XMLUtils.ElementVisitor(){

                    public void visitElement(XMLNode xMLNode) {
                        boolean bl2 = true;
                        String string4 = "";
                        if (xMLNode.getName().equals("Name") && xMLNode.getNested().toString().equals(string)) {
                            booleanArray2[0] = Boolean.TRUE;
                        }
                        if (booleanArray2[0].booleanValue() && xMLNode.getName().equals("Include") && xMLNode.getNested().toString().indexOf(string3 + ".desktop") != -1 && bl) {
                            booleanArray[0] = Boolean.TRUE;
                            return;
                        }
                        string4 = xMLNode.getNested() == null ? string4 + "<" + xMLNode.getName() + "/>\n" : string4 + "<" + xMLNode.getName() + ">" + xMLNode.getNested().toString() + "</" + xMLNode.getName() + ">\n";
                        if (booleanArray2[0].booleanValue() && xMLNode.getName().equals("Query") && xMLNode.getNested().toString().indexOf(string) != -1) {
                            booleanArray3[0] = Boolean.FALSE;
                        }
                        if (booleanArray2[0].booleanValue() && string2 != null && xMLNode.getName().equals("Desktop") && !bl) {
                            bl2 = false;
                        }
                        if (booleanArray2[0].booleanValue() && string3 != null && xMLNode.getName().equals("Include") && xMLNode.getNested().toString().equals(string3)) {
                            bl2 = false;
                        }
                        if (bl2) {
                            stringBuffer.append(string4);
                        }
                    }
                });
            }
            catch (BadFieldException badFieldException) {
                Trace.ignoredException((Exception)badFieldException);
            }
            catch (MissingFieldException missingFieldException) {
                Trace.ignoredException((Exception)missingFieldException);
            }
            if (booleanArray2[0].booleanValue() && !booleanArray[0].booleanValue()) {
                this.addNewFolderInfo(string, string2, string3, false, false, booleanArray3[0], stringBuffer);
                booleanArray[0] = Boolean.TRUE;
                booleanArray2[0] = Boolean.FALSE;
            }
            stringBuffer.append("</" + xMLNode.getName() + ">\n");
            this.removeEmptyFolder(stringBuffer, string2);
            xMLNode = xMLNode.getNext();
        }
        if (!booleanArray[0].booleanValue() && !bl) {
            this.addNewFolderInfo(string, string2, string3, false, true, booleanArray3[0], stringBuffer);
            booleanArray[0] = Boolean.TRUE;
        }
    }

    private void removeEmptyFolder(StringBuffer stringBuffer, String string) {
        String string2;
        int n;
        String string3 = "<Folder>";
        int n2 = stringBuffer.lastIndexOf("<Folder>");
        if (stringBuffer.substring(n2, n = stringBuffer.lastIndexOf("</Folder>")).indexOf("<Include>") == -1 && stringBuffer.substring(n2, n).indexOf(string) != -1 && stringBuffer.substring(n2, n).indexOf("application-all-users:///") == -1) {
            stringBuffer.delete(n2, stringBuffer.length());
            if (string != null) {
                new File(string).delete();
                Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
            }
        } else if (stringBuffer.lastIndexOf("</Folder>") - stringBuffer.lastIndexOf("<Folder>") == string3.length() + 1 && (string2 = stringBuffer.substring(stringBuffer.lastIndexOf("<Folder>"), stringBuffer.length()).trim()).equals("<Folder>\n</Folder>")) {
            stringBuffer.delete(stringBuffer.lastIndexOf("<Folder>"), stringBuffer.length());
        }
    }

    private void updateVFolderInfoFile(XMLNode xMLNode, String string, String string2, String string3, boolean bl, boolean bl2, StringBuffer stringBuffer) {
        Boolean[] booleanArray = new Boolean[1];
        Boolean[] booleanArray2 = new Boolean[1];
        Boolean[] booleanArray3 = new Boolean[1];
        booleanArray[0] = Boolean.FALSE;
        booleanArray2[0] = Boolean.FALSE;
        booleanArray3[0] = Boolean.FALSE;
        this.updateVFolderInfoFileInternal(xMLNode, string, string2, string3, bl2, booleanArray, booleanArray2, booleanArray3, stringBuffer);
        if (!booleanArray2[0].booleanValue() && !bl2) {
            boolean bl3 = !bl && booleanArray[0] == false;
            this.addNewFolderInfo(string, string2, string3, bl3, true, true, stringBuffer);
            if (booleanArray[0].booleanValue()) {
                stringBuffer.append("</Folder>\n");
            }
        }
        stringBuffer.append("</" + xMLNode.getName() + ">\n");
        if (!booleanArray3[0].booleanValue()) {
            stringBuffer.append("</" + xMLNode.getName() + ">\n");
        }
    }

    private void updateVFolderInfoFileInternal(XMLNode xMLNode, final String string, final String string2, final String string3, final boolean bl, final Boolean[] booleanArray, final Boolean[] booleanArray2, final Boolean[] booleanArray3, final StringBuffer stringBuffer) {
        stringBuffer.append("<" + xMLNode.getName() + ">\n");
        Trace.println((String)("updateVFolderInfoFile: XMLNode: " + xMLNode), (TraceLevel)TraceLevel.BASIC);
        try {
            XMLUtils.visitChildrenElements(xMLNode, new XMLUtils.ElementVisitor(){
                private boolean ignoreFolder = false;

                public void visitElement(XMLNode xMLNode) {
                    if (!xMLNode.getName().equals("Folder")) {
                        if (xMLNode.getNested() == null) {
                            stringBuffer.append("<" + xMLNode.getName() + "/>\n");
                        } else {
                            stringBuffer.append("<" + xMLNode.getName() + ">" + xMLNode.getNested().toString() + "</" + xMLNode.getName() + ">\n");
                        }
                        if (xMLNode.getName().equals("Parent") && xMLNode.getNested().toString().equals("applications-all-users:///")) {
                            this.ignoreFolder = true;
                            booleanArray[0] = Boolean.TRUE;
                            booleanArray3[0] = Boolean.TRUE;
                        }
                        if (xMLNode.getName().equals("Desktop") && xMLNode.getNested().toString().equals("Applications.directory")) {
                            this.ignoreFolder = true;
                            booleanArray[0] = Boolean.TRUE;
                            booleanArray3[0] = Boolean.TRUE;
                        }
                    } else {
                        stringBuffer.append("\n");
                        if (booleanArray[0].booleanValue()) {
                            VFolderEditor.this.searchForFolder(xMLNode, string, string2, string3, bl, booleanArray2, stringBuffer);
                            booleanArray[0] = Boolean.FALSE;
                            stringBuffer.append("</" + xMLNode.getName() + ">\n");
                        } else if (!this.ignoreFolder) {
                            VFolderEditor.this.updateVFolderInfoFileInternal(xMLNode, string, string2, string3, bl, booleanArray, booleanArray2, booleanArray3, stringBuffer);
                        }
                    }
                }
            });
        }
        catch (BadFieldException badFieldException) {
            Trace.ignoredException((Exception)badFieldException);
        }
        catch (MissingFieldException missingFieldException) {
            Trace.ignoredException((Exception)missingFieldException);
        }
    }
}

