#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.samba.new
# This won't be needed.  The point here is to preserve the permissions of the existing
# file, if there is one.  I don't see major new development happening in rc.samba...  ;-)
rm -f etc/rc.d/rc.samba.new
( cd lib ; rm -rf libnss_winbind.so )
( cd lib ; ln -sf libnss_winbind.so.2 libnss_winbind.so )
( cd lib ; rm -rf libnss_wins.so )
( cd lib ; ln -sf libnss_wins.so.2 libnss_wins.so )
( cd usr/doc/samba-3.0.20/docs ; rm -rf htmldocs )
( cd usr/doc/samba-3.0.20/docs ; ln -sf /usr/share/swat/help htmldocs )
( cd usr/doc/samba-3.0.20/docs ; rm -rf using_samba )
( cd usr/doc/samba-3.0.20/docs ; ln -sf /usr/share/swat/help/using_samba using_samba )
( cd usr/lib/samba ; rm -rf libsmbclient.so )
( cd usr/lib/samba ; ln -sf ../libsmbclient.so.0.0 libsmbclient.so )
( cd usr/lib ; rm -rf libsmbclient.so.0 )
( cd usr/lib ; ln -sf libsmbclient.so.0.0 libsmbclient.so.0 )
( cd usr/lib ; rm -rf libsmbclient.so )
( cd usr/lib ; ln -sf libsmbclient.so.0.0 libsmbclient.so )
( cd sbin ; rm -rf mount.smbfs )
( cd sbin ; ln -sf /usr/bin/smbmount mount.smbfs )
