/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static byte[] defaultMessage = new byte[]{-1, 0};
    private int dataLength = 0;
    private static final long mask = 127L;

    public MetaMessage() {
        this(defaultMessage);
    }

    protected MetaMessage(byte[] byArray) {
        super(byArray);
        if (byArray.length >= 3) {
            this.dataLength = byArray.length - 3;
            for (int i2 = 2; i2 < byArray.length && (byArray[i2] & 0x80) != 0; ++i2) {
                --this.dataLength;
            }
        }
    }

    public void setMessage(int n2, byte[] byArray, int n3) throws InvalidMidiDataException {
        if (n2 >= 128 || n2 < 0) {
            throw new InvalidMidiDataException("Invalid meta event with type " + n2);
        }
        if (n3 > 0 && n3 > byArray.length || n3 < 0) {
            throw new InvalidMidiDataException("length out of bounds: " + n3);
        }
        this.length = 2 + this.getVarIntLength(n3) + n3;
        this.dataLength = n3;
        this.data = new byte[this.length];
        this.data[0] = -1;
        this.data[1] = (byte)n2;
        this.writeVarInt(this.data, 2, n3);
        if (n3 > 0) {
            System.arraycopy(byArray, 0, this.data, this.length - this.dataLength, this.dataLength);
        }
    }

    public int getType() {
        if (this.length >= 2) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.dataLength];
        System.arraycopy(this.data, this.length - this.dataLength, byArray, 0, this.dataLength);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        MetaMessage metaMessage = new MetaMessage(byArray);
        return metaMessage;
    }

    private int getVarIntLength(long l2) {
        int n2 = 0;
        do {
            ++n2;
        } while ((l2 >>= 7) > 0L);
        return n2;
    }

    private void writeVarInt(byte[] byArray, int n2, long l2) {
        int n3;
        for (n3 = 63; n3 > 0 && (l2 & 127L << n3) == 0L; n3 -= 7) {
        }
        while (n3 > 0) {
            byArray[n2++] = (byte)((l2 & 127L << n3) >> n3 | 0x80L);
            n3 -= 7;
        }
        byArray[n2] = (byte)(l2 & 0x7FL);
    }
}

