/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private byte[] bytearr = null;
    private byte[] writeBuffer = new byte[8];

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void incCount(int n2) {
        int n3 = this.written + n2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        this.written = n3;
    }

    public synchronized void write(int n2) throws IOException {
        this.out.write(n2);
        this.incCount(1);
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        this.incCount(n3);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean bl2) throws IOException {
        this.out.write(bl2 ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int n2) throws IOException {
        this.out.write(n2);
        this.incCount(1);
    }

    public final void writeShort(int n2) throws IOException {
        this.out.write(n2 >>> 8 & 0xFF);
        this.out.write(n2 >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeChar(int n2) throws IOException {
        this.out.write(n2 >>> 8 & 0xFF);
        this.out.write(n2 >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeInt(int n2) throws IOException {
        this.out.write(n2 >>> 24 & 0xFF);
        this.out.write(n2 >>> 16 & 0xFF);
        this.out.write(n2 >>> 8 & 0xFF);
        this.out.write(n2 >>> 0 & 0xFF);
        this.incCount(4);
    }

    public final void writeLong(long l2) throws IOException {
        this.writeBuffer[0] = (byte)(l2 >>> 56);
        this.writeBuffer[1] = (byte)(l2 >>> 48);
        this.writeBuffer[2] = (byte)(l2 >>> 40);
        this.writeBuffer[3] = (byte)(l2 >>> 32);
        this.writeBuffer[4] = (byte)(l2 >>> 24);
        this.writeBuffer[5] = (byte)(l2 >>> 16);
        this.writeBuffer[6] = (byte)(l2 >>> 8);
        this.writeBuffer[7] = (byte)(l2 >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
        this.incCount(8);
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.out.write((byte)string.charAt(i2));
        }
        this.incCount(n2);
    }

    public final void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            this.out.write(c2 >>> 8 & 0xFF);
            this.out.write(c2 >>> 0 & 0xFF);
        }
        this.incCount(n2 * 2);
    }

    public final void writeUTF(String string) throws IOException {
        DataOutputStream.writeUTF(string, this);
    }

    static int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c2;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n3 + " bytes");
        }
        byte[] byArray = null;
        if (dataOutput instanceof DataOutputStream) {
            DataOutputStream dataOutputStream = (DataOutputStream)dataOutput;
            if (dataOutputStream.bytearr == null || dataOutputStream.bytearr.length < n3 + 2) {
                dataOutputStream.bytearr = new byte[n3 * 2 + 2];
            }
            byArray = dataOutputStream.bytearr;
        } else {
            byArray = new byte[n3 + 2];
        }
        byArray[n4++] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n4++] = (byte)(n3 >>> 0 & 0xFF);
        int n5 = 0;
        for (n5 = 0; n5 < n2 && (c2 = string.charAt(n5)) >= '\u0001' && c2 <= '\u007f'; ++n5) {
            byArray[n4++] = (byte)c2;
        }
        while (n5 < n2) {
            c2 = string.charAt(n5);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n4++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            ++n5;
        }
        dataOutput.write(byArray, 0, n3 + 2);
        return n3 + 2;
    }

    public final int size() {
        return this.written;
    }
}

