#!/bin/bash

###############################################################################
# Program: compile.php
# Purpose: Compile & install php for Apache & the standalone PHP interpreter
# Author : Stuart Winter <stuart@polplex.co.uk> 
# Date...: 20/12/02
###############################################################################

# Work out where we were called from
export CWD=$PWD

# The temporary build path
export BUILDPATH=/tmp/compiling-slackpacks/php
rm -rf $BUILDPATH  #clean up any existing compilation
mkdir -pm700 $BUILDPATH

# Paths where the compile.gd & compile.imap have compiled their warez
IMAP_COMPILEDIR=/tmp/compiling-slackpacks/imapclient/imapd
#GD_COMPILEDIR=/tmp/compiling-slackpacks/gd-for-php/gd

# Extract source:
cd $BUILDPATH
tar jxvvf $CWD/source/php*bz2
chown -R root:root php*
chmod -R og-w php*

# Work out what version of PHP we're using.  We need this to work out
# what directory name to give /usr/doc/php-???
# This leaves us with '4.2.2' or whatever the version number is.
PHPVERSION="$( /bin/ls -d ${BUILDPATH}/php* | rev | cut -d/ -f1 | rev | cut -d- -f2 )"

echo Compiling PHP version $PHPVERSION
sleep 5

# Enter into the temp build path -- remember that we unarchived the apache source INSIDE
# buildpath/apache, hence the additional 'php' on the end. 
cd $BUILDPATH/php*

#rm -f config.cache # not required now cos each build deletes the original build source tree
#make clean # ignore errors from this

# For some reason PHP 4.3.0 requires --with-jpeg-dir 
# even though I've already specified --with-gd.
# Be careful of this in the future -- it may need to be removed if it breaks.
./configure \
    --mandir=/usr/man \
    --infodir=/usr/info \
    --prefix=/usr \
    --with-apxs=/www/bin/apxs \
    --with-config-file-path=/etc \
    --with-gd \
    --with-jpeg-dir \
    --enable-gd-native-ttf \
    --enable-gd-imgstrttf \
    --with-gmp \
    --with-openssl \
    --enable-track-vars \
    --enable-versioning \
    --with-xml \
    --with-mysql=/usr \
    --enable-ftp \
    --with-gzip \
    --with-zlib=/usr \
    --enable-memory-limit=yes \
    --enable-trans-sid \
    --with-expat \
    --enable-mbstring \
    --enable-mbstr-enc-trans \
    --with-gettext \
    --with-imap=$IMAP_COMPILEDIR \
    --enable-bcmath \
    --enable-pic \
    --enable-calendar \
    --enable-sockets \
    --enable-shared \
    --enable-wddx

# No longer required because as of PHP 4.3.0, GD version 2 is bundled with the source
# and we just use --with-gd to include support
#    --with-gd=${GD_COMPILEDIR}              \
#    --with-jpeg-dir=${GD_COMPILEDIR}        \
#    --with-png-dir=${GD_COMPILEDIR}         \


# Compile
make 
#make install ## we don't want to install cos it uses apxs to install libphp4.so
#                which doesn't work when we run it through slacktrack

# Make the dir where we'll put the libphp4.so library
mkdir -p /www/libexec
# Strip & copy libphp4.so lib into /www/libexec
strip .libs/libphp4.so # we may NOT want to do this if php starts going wrong
install -m755 .libs/libphp4.so /www/libexec/

# Now compile the stand alone shell version of PHP
cd $BUILDPATH/php*
grep -v -- '--with-apxs' config.nice > config.cgi  # remove the 'compile for apache' flag
chmod 700 config.cgi 
./config.cgi --enable-force-cgi-redirect --enable-fastcgi
make 

# Since PHP v4.3.0 they've changed the make install so that it (appears to) verify
# the installation.  Obviously through slacktrack it fails because it doesn't
# end up in /usr.  Aggr! So what we do is to a 'clean' type install into a temp 
# dir where it can verify it, then copy all the data across into our slacktrack
# pseudo root file system.
# * Obviously now this version of PHP lends itself to a normal non-slacktrack
# SlackBuild script, but who knows what they'll do in the next release.
mkdir -p $BUILDPATH/tempphp
make install INSTALL_ROOT=$BUILDPATH/tempphp
# Copy the whole lot over into our pseudo slacktrack root file system
chmod -R og-w $BUILDPATH/tempphp # *sigh* make install installs some files g+w 
cp -a $BUILDPATH/tempphp/* /

# Create doc dir to install the docs that come with the php source ball
# The *man pages* are installed into /usr/man
# Currently there *aren't* any man pages
mkdir -p /usr/doc/php-$PHPVERSION
cd $BUILDPATH/php*
cp -a CODING* CREDITS EXTENSIONS INSTALL LICENSE NEWS README* TODO* php.ini-* \
      /usr/doc/php-$PHPVERSION

# Copy the default UKShells php.ini into /etc
mkdir /etc 2>/dev/null
install -m 644 $CWD/configfiles/php.ini /etc

# Install doinst.sh:
install -m 644 $CWD/doinst.sh /install
