/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GALEON_WRAPPER_H
#define GALEON_WRAPPER_H

#include "nsIDocShell.h"
#include "nsIWebNavigation.h"
#include "nsIWebPageDescriptor.h"
#include "nsISHistory.h"
#include "nsIWebBrowser.h"
#include "nsIWebProgressListener.h"
#include "nsCOMPtr.h"
#include "nsIDOMEventReceiver.h"
#include "nsIDOMDocument.h"
#include "nsPIDOMWindow.h"
#include "nsIDOMEventListener.h"
#include "nsIChannel.h"
#include "nsICacheEntryDescriptor.h"
#include "nsIStyleSheet.h"
#include "nsString.h"
#include <gtkmozembed.h>

#include "nsIPrintSettings.h"

#ifdef HAVE_MOZILLA_PSM
class nsISSLStatus;
#endif

class GDOMEventListener : public nsIDOMEventListener
{
  public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSIDOMEVENTLISTENER

	GDOMEventListener();
	virtual ~GDOMEventListener();

	nsresult Init(GaleonEmbed* aEmbed);

  protected:
	GaleonEmbed	*mEmbed;
};

class GDOMPopupEventListener : public GDOMEventListener
{
  public:
  	NS_DECL_ISUPPORTS
  	NS_DECL_NSIDOMEVENTLISTENER
  	GDOMPopupEventListener() : GDOMEventListener() {}
  	virtual ~GDOMPopupEventListener() {}
};

class GaleonWrapper
{
  public:
	GaleonWrapper();
	~GaleonWrapper();

	nsresult Init (GtkMozEmbed *mozembed);
	nsresult Destroy (void);

	nsresult SetZoom (float aTextZoom, PRBool reflow);
	nsresult GetZoom (float *aTextZoom);

	nsresult Print (nsIPrintSettings *options, PRBool preview);
	nsresult GetPrintSettings (nsIPrintSettings * *options);
	nsresult PrintPreviewClose (void);
	nsresult PrintPreviewNumPages (int *numPages);
	nsresult PrintPreviewNavigate(PRInt16 navType, PRInt32 pageNum);

	nsresult FindSetProperties (const PRUnichar *search_string,
				    PRBool case_sensitive,
				    PRBool wrap_around);

	nsresult Find (PRBool backwards, PRBool *didFind);

	nsresult GetMainDocumentUrl (nsCString &url);
	nsresult GetDocumentUrl (nsCString &url);

	nsresult ReloadDocument ();
	nsresult LoadDocument(nsISupports *aPageDescriptor, PRUint32 aDisplayType);
	nsresult GetPageDescriptor(nsISupports **aPageDescriptor);

	nsresult GetSHInfo (PRInt32 *count, PRInt32 *index);
	nsresult GetSHTitleAtIndex (PRInt32 index, PRUnichar **title);
	nsresult GetSHUrlAtIndex (PRInt32 index, nsCString &url);

	nsresult CopyHistoryTo (GaleonWrapper *embed, PRBool back_history,
				PRBool forward_history, PRBool set_current);

	nsresult GoToHistoryIndex (PRInt16 index);

	nsresult ClearHistory();

	nsresult ForceEncoding (const char *encoding);
	
	nsresult GetEncodingInfo (GaleonEncodingPageInfo **info);
	
	nsresult GetHasModifiedForms (PRBool *modified);

	nsresult CanCutSelection(PRBool *result);

	nsresult CanCopySelection(PRBool *result);

	nsresult CanPaste(PRBool *result);

	nsresult CutSelection(void);

	nsresult CopySelection(void);

	nsresult Paste(void);

	nsresult GetStyleSheets (nsIDOMStyleSheetList **list);

	nsresult GetMainDOMDocument (nsIDOMDocument **aDOMDocument);

	nsresult LoadOverrideStyleSheet (char *css,
					 nsIStyleSheet **return_sheet);
	nsresult RemoveOverrideStyleSheet (nsIStyleSheet *remove);

	nsresult GetLinkInterfaceItems (GList **list);

	nsresult GetRealURL (nsCString &ret);

	nsresult SelectAll (void);

	nsresult ScrollUp (void);
	nsresult ScrollDown (void);
	nsresult ScrollLeft (void);
	nsresult ScrollRight (void);

	nsresult FineScroll (int horiz, int vert);

	nsresult GetPageProperties (EmbedPageProperties *props);
	nsresult ShowPageCertificate ();

	nsresult GetSecurityTooltip (char **tooltip);

	nsresult EvaluateJS (char *script);

	nsresult PushTargetDocument (nsIDOMDocument *domDoc);
	nsresult PopTargetDocument ();

	nsresult GetDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult GetDOMWindow (nsIDOMWindow **aDOMWindow);

	nsresult SetChannel (nsIChannel *channel);

	nsCOMPtr<nsIWebBrowser>           mWebBrowser;
  private:

	nsCOMPtr<nsIDOMDocument> mTargetDocument;
	nsCOMPtr<nsIChannel> mChannel;

	nsCOMPtr<nsIDOMEventTarget> mEventTarget;
	nsCOMPtr<GDOMEventListener> mFaviconEventListener;
	nsCOMPtr<GDOMEventListener> mPopupEventListener;

	nsresult SetZoomOnDocshell (float aZoom, nsIDocShell *DocShell);
	nsresult GetDocShell (nsIDocShell **aDocShell);
	nsresult GetFocusedDOMWindow (nsIDOMWindow **aDOMWindow);
	nsresult GetSHistory (nsISHistory **aSHistory);
	nsresult GetWebNavigation(nsIWebNavigation **aWebNavigation);

#ifdef HAVE_MOZILLA_PSM
	nsresult GetSSLStatus (nsISSLStatus **aSSLStatus);
#endif

	nsresult GetCacheEntryDescriptor(const nsAString &aKey,
					 nsICacheEntryDescriptor **aCacheEntryDescriptor);
	nsresult GetDocumentHasModifiedForms (nsIDOMDocument *aDomDoc, 
					      PRUint32 *aNumTextFields, PRBool *aIsModified);

	nsresult GetPageSecurityInfo (EmbedPageProperties *props);
	nsresult GetMetaTags(GList **ret);
	nsresult GetImages (GList **ret);
	nsresult GetForms (GList **ret);
	nsresult GetLinks (GList **ret);
};

#endif
