// globals

var invitedScreenNames = window.arguments[0].invitedScreenNames;
var chatRoomName= window.arguments[0].chatRoomName;
var chatLanguage= window.arguments[0].chatLanguage;
var chatMsg = window.arguments[0].chatMsg;
var chatPanelLoaded = false;

var chatFromURL = window.arguments[0].fromurl;                          
var chatExchange = window.arguments[0].exchange;                        
var chatInstance = window.arguments[0].instance; 
// globals for invite

var incomingChat = window.arguments[0].incomingChat;
var inviteProposalScreenName = window.arguments[0].incomingChatInviteProposalScreenName;
var inviteProposalObj= window.arguments[0].incomingChatInviteProposalObj;

var isChatContent = true;
var showTimestampVal;

// timestamp	
var IDateTime = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].createInstance();
var aDateTime = IDateTime.QueryInterface(Components.interfaces.nsIScriptableDateFormat);

//ChatRoomManager setup 
//         ***start***
function chatRoomMemberObj(screenName,status,ignored,blocked)
{
  this.screenName=screenName;
  this.status=status;
  this.ignored=ignored;
  this.blocked=blocked;
  return this;
}

function chatRoomManagerObj()
{
  this.members = new Array();
  this.roomname = "";
  return this;
}

function chatRoomManagerAddMember(managerObj,membername,status,ignored,blocked)
{
  managerObj.members[managerObj.members.length] = new chatRoomMemberObj(membername,status,ignored,blocked);
}

function chatRoomManagerDelMember(managerObj,membername)
{
  var tempMembersArray = new Array();
  for(k=0;k<managerObj.members.length;k++) {
    if(managerObj.members[k].screenName.toLowerCase() == membername.toLowerCase()) {
      //copy members to new Array, except for deleted one.
      for(m=0;m<managerObj.members.length;m++) {
        if(m!=k) {
          tempMembersArray[tempMembersArray.length] = managerObj.members[m];	
        }
      }
      //swap old array with new one.
      managerObj.members = tempMembersArray;
    }
  }
}

function chatRoomManagerUpdateMember(managerObj,membername,status)
{
  var changedFlag = false;
  for(i=0;i<managerObj.members.length;i++) {
    if(managerObj.members[i].screenName.toLowerCase()==membername.toLowerCase()) {
      managerObj.members[i].status = status
      changedFlag=true;
    }
  }

  if(!changedFlag) {
    //didnt change anyone - must not be here yet!
    chatRoomManagerAddMember(managerObj,membername,status,false,false)
  }
}

var myManager = new chatRoomManagerObj();
//ChatRoomManager setup ***end***

// Setup Callbacks
//Setup Room Callbacks (basically event capturing)

var RoomCallback= new Object();

RoomCallback.OnMessageReceived = function(screenName, rcvdMsg, language) {
  chatContentRecieveMsg(screenName,rcvdMsg)
}

RoomCallback.OnWhisperReceived = function(screenName,  rcvdWhispMsg, language) {
  chatContentRecieveMsg(screenName,rcvdWhispMsg)
}

RoomCallback.OnUserJoined = function(screenName){
  updateStatus(aimString("chat.OnUserJoined").replace(/%ScreenName%/, screenName));
  //update their status in the list
  top.frames['chatpanel'].chatPanelUpdateScreenName(screenName,"joined")
  //update their status in the global obj
  chatRoomManagerUpdateMember(myManager,screenName,"joined")
  try {
    chatAnnounce_pref=aimPrefsManager().GetBoolPref("aim.chat.AnnounceChatRoom", null, false);
  }
  catch (ex) {
    chatAnnounce_pref = true;
  }

  var currentScreenName = aimSessionCurrentScreenName();      
  if ((chatAnnounce_pref && (currentScreenName != screenName))) {
    chatContentReceiveStatus(screenName, aimString("chat.OnUserJoined").replace(/%ScreenName%/,""));
  }
  chatRoomManagerUpdateMember(myManager,screenName,"joined")

}

RoomCallback.OnUserLeft = function(screenName) {
  updateStatus(aimString("chat.OnUserLeft").replace(/%ScreenName%/, screenName));
  top.frames['chatpanel'].chatPanelRemoveScreenName(screenName)
  //update global obj
  chatRoomManagerDelMember(myManager,screenName)

  var chatAnnounce_pref;
  try {
    chatAnnounce_pref=aimPrefsManager().GetBoolPref("aim.chat.AnnounceChatRoom", null, false);
  }
  catch (ex) {
    chatAnnounce_pref = true;
  }
  if (chatAnnounce_pref) {
    chatContentReceiveStatus(screenName, aimString("chat.OnUserLeft").replace(/%ScreenName%/, ""));
  }
}

RoomCallback.OnPaused = function() {
  updateStatus(aimString("chat.RoomPaused"));
}

RoomCallback.OnResumed = function() {
  updateStatus(aimString("chat.RoomResumed"));
}

RoomCallback.OnInfoUpdate = function() {}

RoomCallback.OnClientError = function(screenName,errMsg) {
  updateStatus(aimString("chat.ClientError").replace(/%ScreenName%/, screenName));
}

// end Setup Room Callback

// Setup ChatManager Callback 
var CallBack = new Object();
var RoomCreationTimeStamp = null;
CallBack.title = aimString("chat.WindowTitle");

CallBack.OnRequestRoomComplete =  function(roomName,chatRoomObj) {
  RoomCreationTimeStamp= new Date();
  chatRoomObj.SetChatRoomCallback( RoomCallback )
  top.chatRoomObj = chatRoomObj;
  if (roomName)
    window.title= aimString("chat.WindowTitle").replace(/%ChatRoom%/, roomName);
  else if (chatRoomName)
    window.title= aimString("chat.WindowTitle").replace(/%ChatRoom%/, chatRoomName);
  else if (chatRoomObj.GetName())
    window.title= aimString("chat.WindowTitle").replace(/%ChatRoom%/, chatRoomObj.GetName());

  window.setTimeout('top.chatRoomObj.Join()', 1000);
  if(invitedScreenNames)
    window.setTimeout('chatContentInviteMany(invitedScreenNames,chatMsg)',1500);	
}

CallBack.OnRequestRoomError =  function(roomName,errMsg) {
  window.close();
}

CallBack.OnProposalReceived = function(screenName,proposalObj) { }


//Chat Sound handling
function chatSound(msg)
{
  aimSoundManager().ChatEvent(msg);
}

// first thing to do on startup
function chatContentStartup() {
  pChatManager = aimChatManager();
  if (!pChatManager) {
    return;
  }

  var rooms = new Object();
  try {
    pChatManager.GetMaxConcurrentRooms(rooms);
  }
  catch (e) {
    dump("!!!!! catching js error during pChatManager.GetMacConcurrentRooms !!!!! \n");
  }

  // got chatroom name from arguments passed to the opendialog
  if(incomingChat) {
    CallBack.OnRequestRoomComplete(window.arguments[0].chatRoomName, window.arguments[0].incomingChatRoom);
  }
  else {	
    try {
      if(chatFromURL && (chatExchange != 0)) {                                               
        pChatManager.RequestRoom(CallBack, chatRoomName, chatLanguage, chatExchange, chatInstance)
      }
      else {
        pChatManager.RequestPrivateRoom(CallBack,chatRoomName, chatLanguage)
      }
    }
    catch (e) {
			dump("chatContentStartup: E = " + e + "\n");
    }
  }
  showTimestampVal = aimPrefsManager().GetBoolPref("aim.general.im.timeStamp", null, false);
  SetTimestampMenuItem();
}

// One more level of callback in order that chat manager can be ready
myExecutionCallback = new Object();
myExecutionCallback.ExecuteIfReady = function()
{
  // get chatroom and callbacks
  chatContentStartup();

  // startup the ender widget
  startUpEditor(document.getElementById("ComposeWnd"));

  updateMemberCount();
  try {
    if(!chatFromURL)
      window.opener.close();
  }
  catch (e) {
    dump("chat: where's my invite window?? \n")
  }
}

// after the window has loaded:
function chatContentOnWinLoad()
{
  var bbox = document.getElementById("ComposeWnd");
  if (bbox)
    bbox.addEventListener("keypress", composeKeyPress, true);

  aimChatManager().OnWindowLoad(top);
  aimChatManager().ExecuteIfReady(myExecutionCallback);

  //hide some insert menuitems
  document.getElementById("insertImage").setAttribute("hidden", true);
  document.getElementById("insertTable").setAttribute("hidden", true);
  document.getElementById("insertAnchor").setAttribute("hidden", true);
  document.getElementById("insertHline").setAttribute("hidden", true);
  document.getElementById("insertHTMLSource").setAttribute("hidden", true);
  document.getElementById("insertChars").setAttribute("hidden", true);
  document.getElementById("insertTOC").setAttribute("hidden", true);
  document.getElementById("insertMenuSeparator").setAttribute("hidden", true);
  document.getElementById("insertBreakAll").setAttribute("hidden", true);
}

function composeKeyPress(event)
{
  if (event.keyCode == 13) {
    if (SendOnEnter()) {
      event.preventBubble();
      event.preventDefault(); 
      window.setTimeout('chatContentSendMsg()', 1, true); 
      return false; 
    }
    return true;
  }

  if (event.keyCode == 9) {
    if (OnTab()) {
      document.getElementById('btnSend').focus();
      event.preventDefault();
      return false;
    }
    return true;
  }
}

// window is closing
function chatContentOnWinUnLoad()
{
  aimChatManager().OnWindowUnload(top);
  try {
    top.chatRoomObj.Leave()
  }
  catch (e) {
    dump("chat: there was an error trying to call chatRoomObj.leave() \n");
  }
}

function startUpEditor(editorElement)
{
  if (!editorElement)
    return;

  EditorSharedStartup();

  // Add an observer to be called when document is done loading,
  // which creates the editor
  try {
    GetCurrentCommandManager().addCommandObserver(gChatEditorCreationObserver, "obs_documentCreated");

    // Load empty page to create the editor
    editorElement.webNavigation.loadURI("about:blank", // uri string
                         0,                            // load flags
                         null,                         // referrer
                         null,                         // post-data stream
                         null);
  }
  catch (e) {
    dump(" Failed to startup editor: "+e+"\n");
  }
}

// The new, nice, simple way of getting notified when a new editor has been created
var gChatEditorCreationObserver =
{ 
  observe: function(aSubject, aTopic, aData) {
    if (aTopic == "obs_documentCreated") {
      var editor = GetCurrentEditor();
      if (editor && GetCurrentCommandManager() == aSubject) {
        //gMsgCompose.initEditor(editor, window.content);
        var nsIPlaintextEditor = Components.interfaces.nsIPlaintextEditor;
        editor.flags |= nsIPlaintextEditor.eEditorNoCSSMask;

        //see bugzilla bug 112960 for why we have a timeout call
        setTimeout("setStyles()", 100);
      }
    }
  }
}



// updates the number of chat members (use after an add or delete member)
function updateMemberCount()
{
  var theTreeChildren = top.frames["chatpanel"].document.getElementsByTagName("listitem")
  var activeMembers=0;
  for(i=0 ; i<theTreeChildren.length;i++) {
    if(theTreeChildren.item(i).getAttribute("class") == "joined") {
      activeMembers++;
    }
  }

  theMemberCountNode=document.getElementById("numberchatting")
  if(activeMembers != 1)
    theMemberCountNode.setAttribute("label", aimString("chat.PeopleHere").replace(/%NumPeople%/, activeMembers));
  else
    theMemberCountNode.setAttribute("label", aimString("chat.PersonHere"));
}

//send your message out
function SendOnEnter()
{
  // if enterCR_pref_value is true, the pref was set so that enter was a CR
  // if enterCR_pref_value is false, the user wants enter to send the IM message
  try {
    enterCR_pref_value = aimPrefsManager().GetBoolPref("aim.general.im.enterCR", null, false);
  }
  catch (ex) {
    // default to be "send on enter key"
    enterCR_pref_value = true;
  }

  return (!enterCR_pref_value);
}

function OnTab()
{
  var Tab_pref_value = false;
  try {
    Tab_pref_value = aimPrefsManager().GetBoolPref("aim.general.im.tabKey", null, false);
  }
  catch (ex) {
    // default
    Tab_pref_value = true;
  }

  return (!Tab_pref_value);
}

/* Name: getMaxIndividualMessage
 *
 * Arguments: 
 *      none.
 * Return Value:
 *      maxIndividualMessageLength -- maximum length of an individual chat message.
 *
 * Description:
 *      This function caches maxIndividuaMessageLength, and calls
 *      nsIAimChatRoom::GetMaxIndividualMessageLength if the cache is empty.
 *
 * Author:
 *      Joseph Elwell 07/04/2001
 * 
*/
var maxIndividualMessageLength = -1;
function getMaxIndividualMessage()
{
  if (maxIndividualMessageLength == -1)
    maxIndividualMessageLength = top.chatRoomObj.GetMaxIndividualMessageLength();

  return maxIndividualMessageLength;
}
        
function chatContentSendMsg(strip) {
  var editor = GetCurrentEditor();
  if (!editor)
    return;
  if (editor.textLength > getMaxIndividualMessage()) {
    var bigChatError = aimString("msg.BigChat").replace(/%BigBy%/, ""+(editor.textLength-getMaxIndividualMessage()));
    bigChatError = bigChatError.replace(/471/, ""+(getMaxIndividualMessage()));
    aimErrorBox(bigChatError);
    return;
  }

  var bodyText = editor.outputToString("text/html", 8 + 4);

  /* smiley conversion */
  bodyText = bodyText.replace(/<\/span><\/span>/g,  " ");
  bodyText = bodyText.replace(/<span class="moz-smiley-s[0-9][0-9]?"><span>/g, " ");

  // *** placeholder for getting strip pref.
  //var strip=true

  if (strip) {
    bodyText = bodyText.replace(/<br>/gi, "");
    bodyText = bodyText.replace(/\n/g, "");
    bodyText = bodyText.replace(/\r/g, "");
  }

  bodyText = bodyText.replace(/\n/g, "");
  bodyText = bodyText.replace(/\r/g, "");
  bodyText = bodyText.replace(/<big>/gi, "<font size=\"+1\">");
  bodyText = bodyText.replace(/<\/big>/gi, "<\/font>");
  bodyText = bodyText.replace(/<small>/gi, "<font size=\"-1\">");
  bodyText = bodyText.replace(/<\/small>/gi, "<\/font>");
  bodyText = bodyText.replace(/<br><br>/gi, "<br>");
  bodyText = bodyText.replace(/<br><\/body>/i, "<\/body>");
  bodyText = bodyText.replace(/\u00a0/gi, " ");

  try {
    top.chatRoomObj.SendMessage(bodyText);
  }
  catch(ex) {
    aimErrorBox(aimString("chat.SendError"));
    return;
  }

  editor.selectAll();
  getStyles();
  editor.deleteSelection(null);
  //*** return focus to editor after clicking send ***
  setStyles();
  top._content.focus();

  //Chat Send Sound to hook
  chatSound(Components.interfaces.nsAimChatSoundEvent.ChatSoundEvent_OutgoingMsg);
}

// handle incoming messages
function chatContentRecieveMsg(screenName,msg)
{
  var chatflash=false;         
  try {
    chatflash=aimPrefsManager().GetBoolPref("aim.chat.FlashChatWin", null, false); 
  }
  catch (ex) {
    chatflash = true;
  }
  if (chatflash)
    top.window.getAttention();

  msg = msg.replace(/<pre>/gi, "");
  msg = msg.replace(/<\/pre>/gi, "");
  chatContentAddMsgToLog(screenName,msg,true)

  //Chat Receive Sound to Hook
  if (screenName != aimSessionCurrentScreenName())
    chatSound(Components.interfaces.nsAimChatSoundEvent.ChatSoundEvent_IncomingMsg);
}

function chatContentReceiveStatus(screenName, msg)
{
  chatContentAddMsgToLog(screenName,msg,false);
}

// sub timestamp generation
function getTimeStampStr()
{
  var strTimestamp;
  var curTime = new Date();
  var curHours   = curTime.getHours();
  var curMinutes = curTime.getMinutes();
  var curSeconds = curTime.getSeconds();

  strTimestamp = aDateTime.FormatTime("", aDateTime.timeFormatSeconds, curHours, curMinutes, curSeconds);

  if (showTimestampVal)
    strTimestamp = "<SPAN class=\"logtimestamp\"style=\"visibility:visible\">" + "(" + strTimestamp + ")" + "</SPAN>";
  else  
    strTimestamp = "<SPAN class=\"logtimestamp\"style=\"display:none\">" + "(" + strTimestamp + ")" + "</SPAN>";

  return strTimestamp;
}

// sub function of chatContentRecieveMsg
function chatContentAddMsgToLog(screenName,msg,isMsg)
{
  // There is no contract id for this interface now. mscott/myself will add one later and change this.
  var moz = Components.classesByID["{77c0e42a-1dd2-11b2-8ebf-edc6606f2f4b}"];
  var moztxt = moz.createInstance(Components.interfaces.mozITXTToHTMLConv);
  var iface = Components.interfaces.mozITXTToHTMLConv;
  var mozURL = iface.kURLs;
  var mozSmiley = iface.kGlyphSubstitution;
  var smileyFeatureEnabled = aimPrefsManager().GetBoolPref("aim.general.im.smilies", null, false);

  if (smileyFeatureEnabled)
    msg = moztxt.scanHTML(msg, mozSmiley);

  var timeStampStr = getTimeStampStr();

  var theLogNode = top.document.getElementById("LogWnd").contentWindow;

  var myRange = theLogNode.document.createRange();
  var theLogBody =theLogNode.document.body;
  myRange.setStartAfter(theLogBody);
  var docFrag;
  // XXXVISHY - this handles info messages also
  if (screenName) {
    var colorpre = " ";
    var colorpost = " </b> ";
    if(msg)
      msg = moztxt.scanHTML(msg, mozURL);

    if (isMsg) {
      // otherwise it is a status
      if (screenName.toLowerCase() == aimSessionCurrentScreenName()) 
        colorpre = '<font color=\"#ff0000\">';
      else
        colorpre = '<font color=\"#0000ff\">';

      colorpost = '</b>: </font>';
      docFrag = myRange.createContextualFragment("<html>" + colorpre + "<b>"+ screenName + timeStampStr + colorpost+ msg+"</html><br>");
    }
    else
      docFrag = myRange.createContextualFragment("<html>" + colorpre + "<b>"+ timeStampStr + screenName + colorpost+ msg+"</html><br>");
  }
  else
    docFrag = myRange.createContextualFragment("<html><b>"+ timeStampStr + "</b>" + msg+"</html><br>");

  var prevdocHeight = theLogNode.document.height;
  var isLocked=((theLogNode.scrollY + theLogNode.innerHeight) >= theLogNode.document.height) 
                  || (( theLogNode.document.height - theLogNode.scrollY ) <= 5)
  theLogBody.appendChild(docFrag)

  if (isLocked) {
    if ((theLogNode.innerHeight - (prevdocHeight-theLogNode.scrollY)) <= 5)
      return;
    if ((theLogNode.innerHeight < theLogNode.document.height) && (theLogNode.scrollY == prevdocHeight))
      return;
    theLogNode.scrollTo(theLogNode.scrollX, theLogNode.document.height)
  }

}


//send info to the status area
function updateStatus(statusMsg)
{
  var statusTextNode= document.getElementById("statustext");
  statusTextNode.setAttribute("value",statusMsg);
}

// handle status changes
function chatContentStatusChange(screenName,statusItem)
{
  //updateStatus(screenName+": "+statusItem)
}

/*** Handle Proposal and ProposalOwner for Chat Invitations ***/
var proposals = new Array(); // of all the open proposals;
var aproposal = new Object();

function AimProposalOwner()
{
  this.OnProposalAcked = function(pProposal) { }

  this.OnProposalError = function(pProposal, pErr) {
    var screenName=pProposal.GetProposee();
    var deletePanel=false;
    switch(pErr) {
      case 9:
        aimErrorBox(aimString("chat.UnsupportedSoftware").replace(/%S/, screenName));
        deleteFromPanel=true;
        break;
      case 19:
        aimErrorBox(aimString("chat.NotAvailable").replace(/%ScreenName%/, screenName));
        break;
      case 4:
        aimErrorBox(aimString("chat.NotAvailable").replace(/%ScreenName%/, screenName));
        break;
      case 16:  
        aimErrorBox(aimString("chat.Blocked").replace(/%S%/, screenName));
        deleteFromPanel=true;   
        break;
      case 0:
        aimErrorBox(aimString("chat.NotAvailable").replace(/%ScreenName%/, screenName));
        deleteFromPanel=true;
    }
    
    if (deleteFromPanel) {
      top.frames['chatpanel'].chatPanelRemoveScreenName(screenName);
      chatRoomManagerDelMember(myManager,screenName);
    }
  }

  this.OnProposalAccepted = function(pProposal) { }

  this.OnProposalRejected = function(pErrMsg, pScreenName, deleteFromChatPanel) {
    aimErrorBox(pErrMsg);
    if (deleteFromChatPanel) {
      top.frames['chatpanel'].chatPanelRemoveScreenName(pScreenName);
      chatRoomManagerDelMember(myManager,pScreenName);
    }
  }

  this.OnProposalCountered = function(pProposal, pCounterProposal) { }

  this.OnProposalTimeout = function(pProposal) {
    aimErrorBox(aimString("chat.TimedOut"));
    top.frames['chatpanel'].chatPanelRemoveScreenName(pProposal.GetProposee());
    chatRoomManagerDelMember(myManager,pProposal.GetProposee());
  }

  this.OnProposalCancelled = function(pProposal) {
    top.frames['chatpanel'].chatPanelRemoveScreenName(pProposal.GetProposee());
    chatRoomManagerDelMember(myManager,pProposal.GetProposee());
  }

  return this;
}

// handle many invitations
function chatContentInviteMany(inviteList,chatMsg)
{
  // convert carriage returns and newlines to commas 
  inviteList = inviteList.replace(/\n/gi, ",");
  inviteList = inviteList.replace(/\r/gi, ",");

  inviteArray=inviteList.split(",")
  for(inviteItem = 0; inviteItem<inviteArray.length; inviteItem++) {
    //test to make sure the name isnt empty
    if(itemTest(inviteArray[inviteItem])) {
      aproposal = top.chatRoomObj.Invite(inviteArray[inviteItem], chatMsg);
      proposals[proposals.length] = aproposal;
      proposals[proposals.length-1].SetOwner(new AimProposalOwner());
      top.frames['chatpanel'].chatPanelUpdateScreenName(inviteArray[inviteItem],"invited")
      chatRoomManagerAddMember(myManager,inviteArray[inviteItem],"invited",false,false)
    }
  }
}

function itemTest(inviteItem)
{
  var passed = true;
  switch(inviteItem) {
    case "":
		case " ":
      passed = false;
    break;
  }
  return passed;
}

// pop up invitation window:
function cmdPopUpInvite(screenNames)
{
  var isOnline = aimSession().IsOnline();
  if (!isOnline) {
    window.close();
    aimErrorBox(aimString("chat.NotOnline"));
  }
  else {
    var language = aimString("aim.LanguageCode");
    inviteArgsObj = {
      inviteProposalScreenName: '', 
      inviteProposalObj: null,
      invitedScreenNames: screenNames,
      inviteToExistingWindow: true,
      inviteMode: 'outgoingchat',
      inviteToExistingRoom: chatRoomName,
      inviteLanguage: language
    }

    window.openDialog('chrome://aim/content/chatInviteBuddy.xul','inviteBuddy','chrome,all,dialog=no',inviteArgsObj);
  }
}

// display room info
function cmdRoomInfo()
{
  var dateformat = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].createInstance();
  var dateFormatter = dateformat.QueryInterface(Components.interfaces.nsIScriptableDateFormat);
  var curYear = RoomCreationTimeStamp.getYear() + 1900;
  var curMonth = RoomCreationTimeStamp.getMonth() + 1;
  var curDay = RoomCreationTimeStamp.getDate();
  var curHours = RoomCreationTimeStamp.getHours();
  var curMinutes = RoomCreationTimeStamp.getMinutes();
  var curSeconds = RoomCreationTimeStamp.getSeconds();

  var dateTimeStr = dateFormatter.FormatDateTime("", Components.interfaces.nsIScriptableDateFormat.dateFormatLong,
                  Components.interfaces.nsIScriptableDateFormat.timeFormatSeconds,
                  curYear, curMonth, curDay, curHours, curMinutes, curSeconds);

  window.openDialog('chrome://aim/content/chatRoomInfo.xul','charRoomInfo','chrome,all,dialog=no,resizable=no,titlebar',chatRoomName, top.chatRoomObj.GetLanguage(), top.chatRoomObj.GetMaxIndividualMessageLength(), dateTimeStr); 
}

function createInstance( contractid, iidName )
{
  var iid = eval( "Components.interfaces." + iidName );
  return Components.classes[ contractid ].createInstance( iid );
}

function fixScrolling()
{
  var LogWindow = top.document.getElementById("LogWnd").contentWindow;
  var pageY = LogWindow.pageYOffset
  var docHeight = LogWindow.innerHeight
}

// ignore user from chat - called this time from top level people menu
// simply accesses the cmdIgnoreFromChat() method present inside the chatpanel iframe

function cmdIgnoreFromChat_PeopleMenu()
{
  top.frames['chatpanel'].cmdIgnoreFromChat();
}

// add buddy - get's the currently selected chat room
// buddy and prepopulates the add buddy dialog.
function cmdChatContentAddBuddy()
{
  var targetValue = top.frames['chatpanel'].cmdGetSelectedScreenName()
  if (targetValue)
    openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", "modal=yes,titlebar,chrome", null, null, targetValue);
}

// get member info - accesses the currently selected chatroom buddy and 
// sends that info to the getmemeberinfo xul file
function cmdChatContentGetMemberInfo()
{
  var targetValue = top.frames['chatpanel'].cmdGetSelectedScreenName()
  if(targetValue && targetValue != null)
    window.openDialog('chrome://aim/content/GetMemberInfo.xul','_blank','chrome,all,dialog=no', targetValue);
}

function cmdChatContentSendIM()
{
  top.frames['chatpanel'].cmdSendIMFromChat();
}

