var localeCallbackDefault = new Object();
var localeCallbackAway = new Object();
var localeCallbackProfile = new Object();
var screenName;
var locateManager;
var gotawaymsg=0;
var gotprofile=0;
var profileMsg;
var awayMsg;
var isAway;
var offlinemsg;


/*
 * Function: getMemberInfoOnWinLoad()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: This function is called when Get Member Info(GMI) window is loaded. If it has a screenname call
 *  getMemberInfo to get all the values.
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

function getMemberInfoOnWinLoad() {
  if (isIcq()) {
    document.getElementById("btnbuddyorgsendim").setAttribute("sessionMode", "Icq");
    document.getElementById("btnsetuporgbuddy").setAttribute("sessionMode", "Icq");
  }
  else {
    document.getElementById("btnbuddyorgsendim").setAttribute("sessionMode", "Aim");
    document.getElementById("btnsetuporgbuddy").setAttribute("sessionMode", "Aim");
  }
  window.title= aimString("gmi.windowtitle").replace(/%ScreenName%/, "");
  doSetOKCancel(getMemberInfo, onCancel);

  window.gmiContentListener =
    new gmiContentListener(window, document.getElementById('profilefield'));

  screenName = window.arguments[0];
  if (screenName && screenName != "") {
    document.getElementById("screenname").setAttribute("value",screenName);
    getMemberInfo();
  }
  else {
    document.getElementById("screenname").focus();
    document.getElementById("ok").setAttribute("disabled", "true");
  }
}

function gmiContentListener(toplevelWindow, contentWindow)
{
  this.init(toplevelWindow, contentWindow);
}

gmiContentListener.prototype =
{
  init: function(toplevelWindow, contentWindow) {
    this.toplevelWindow = toplevelWindow;
    this.contentWindow = contentWindow;
    var windowDocShell = contentWindow.docShell;
    if (windowDocShell)
      windowDocShell.parentURIContentListener = this;
  },
  QueryInterface: function(iid) {
    if (iid.equals(Components.interfaces.nsIURIContentListener) ||
        iid.equals(Components.interfaces.nsISupportsWeakReference) ||
        iid.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },
  onStartURIOpen: function(uri) {
    return false;
  },

  doContent: function(contenttype, isContentPreferred, request, contentHandler) {
    return false;
  },

  isPreferred: function(contentType, desiredContentType) {
    return false;
  },

  canHandleContent: function(contentType, contentPreferred, desiredContentType) {
    return true;
  },
  loadCookie: null,
  parentContentListener: null
}

/*
 * Function: snKeyPress()
 *
 * Arguments: event
 * 
 * Return: None
 *
 * Description: This is called on every keypress in the screenname field. The OK button is enabled if length is 
 *  more than one and on enter getMemberInfo fn is called.
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

function snKeyPress(event) {
  if (event.keyCode != 9)
    clearAllValues();
  screenName = document.getElementById("screenname").value;
  if (screenName && screenName.length > 0)
    document.getElementById("ok").setAttribute("disabled", "false");
  else
    document.getElementById("ok").setAttribute("disabled", "true");

  if(screenName && screenName.length > 0 && event.keyCode == 13) {
    //the user has pressed Enter key.
    getMemberInfo();
  }
}

/*
 * Function: onCancel()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Just closes the GMI window. 
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/
function onCancel() {
  window.close();
}

/*
 * Function: clearAllValues()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Clears all the fields in GMI window.
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/
function clearAllValues() {
  document.getElementById("userWarningPercent").value = "";
  document.getElementById("userOnlineTime").value = "";
  document.getElementById("awayidlelabel").value = "";
  document.getElementById("awayidletime").value = "";
  document.getElementById("profilefield").contentWindow.location = "about:blank";         
  window.title= aimString("gmi.windowtitle").replace(/%ScreenName%/, "");
  gotprofile = 0;
  gotawaymsg = 0;
}


/*
 * Function: getMemberInfo()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: This fn calls RequestUserInfoDefault in LocateManager to get default info (away, idle, online etc). and 
 *   RequestUserInfoSignature to get Profile/Signature info. 
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/
function getMemberInfo() {
  clearAllValues();
  window.title= aimString("gmi.windowtitle").replace(/%ScreenName%/, screenName);
  var aimBuddy = aimBuddyManager();
  if (!aimBuddy) {
    dump("Unable to create aimBuddy...\n");
    return;
  }
  

  locateManager = aimLocateManager();
  if (!locateManager) {
    dump("Unable to create locateManager...\n");
    return;
  }
  locateManager.RequestUserInfoDefault(localeCallbackDefault, screenName);
  

  // this is to update the GMI window for every 5 minutes!
  setTimeout('getMemberInfo()', 5 * 60000);

}


/*
 * Function: OnRequestUserInfoDefaultComplete()
 *
 * Arguments: screenname, userObject
 * 
 * Return: None
 *
 * Description: Based on the userObject, user info like Online time, Idle time, warning percent, Away are obtained.
 *   If the user is Away, RequestUserInfoAwayMessage in LocateManager is called to get the Away msg.
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/


localeCallbackDefault.OnRequestUserInfoDefaultComplete = function (screenname, userObject) {
  
  locateManager.RequestUserInfoSignature(localeCallbackProfile, screenName);


  var warningPercent = userObject.GetWarningPercent();
  if (warningPercent >= 0 ) {
    document.getElementById("userWarningPercent").setAttribute("value", warningPercent + "%");
  }
  else {
    document.getElementById("userWarningPercent").setAttribute("value", "");
  }

  var onlineTime = userObject.GetOnlineSinceTime();
  var now = new Date().getTime()/1000;
  if (onlineTime >= 0 ) {
    document.getElementById("userOnlineTime").setAttribute("value", getPrettyDateDiff(now, onlineTime));
  }
  else {
    document.getElementById("userOnlineTime").setAttribute("value", "");
  }

  var isIdle = userObject.IsIdle();
  var idletime;
  if (isIdle) {
    var idlesincetime = userObject.GetIdleSinceTime();
    idletime = getPrettyDateDiff(now, idlesincetime);
  }

  isAway = userObject.IsAway();
  
  if (isIdle) {
    if (isAway) {
      //user is away and idle
      document.getElementById("awayidlelabel").setAttribute("value", aimString("gmi.idleandaway"));
      document.getElementById("awayidletime").setAttribute("value", idletime);
    } else {
      // user is just idle
      document.getElementById("awayidlelabel").setAttribute("value", aimString("gmi.idle"));
      document.getElementById("awayidletime").setAttribute("value", idletime);
    }
  }
  else {
    if (isAway)
      //user is just away.
      document.getElementById("awayidlelabel").setAttribute("value", aimString("gmi.away"));
  }

  if (isAway) {
    locateManager.RequestUserInfoAwayMessage(localeCallbackAway, screenName);
  }


}

localeCallbackDefault.OnRequestUserInfoDefaultError = function (screenname, errmsg) {
  //if the user is offline we fall here.
  offlinemsg =  aimString("gmi.infonotavailable").replace(/%ScreenName%/, screenName);
  displayInfo(offlinemsg);
  //dump("In OnRequestUserInfoDefaultError...Nothing for now...\n");
}


/*
 * Function: OnRequestUserInfoAwayMessageComplete()
 *
 * Arguments: screenname, awaymsg
 * 
 * Return: None
 *
 * Description: This calls another fn displayProfileandAwayMsg to display the information.
 *   processAwayMsg is another utility fn that converts %n, to SN etc.
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

localeCallbackAway.OnRequestUserInfoAwayMessageComplete = function (screenname, awaymsg) {
  gotawaymsg = 1;
  awaymsg = processAwayMsg(awaymsg);
  awayMsg = awaymsg;
  displayProfileandAwayMsg();
}

localeCallbackAway.OnRequestUserInfoAwayMessageError = function (screenname, errmsg) {
  dump("In OnRequestUserInfoAwayMessageError...Nothing for now...\n");
  gotawaymsg = 2;
}


/*
 * Function: OnRequestUserInfoSignatureComplete()
 *
 * Arguments: screenname, profilemsg
 * 
 * Return: None
 *
 * Description: This is called if the RequestUserInfoSignature is sucessful. displayProfileandAwayMsg fn
 * is called to display the profile/signature msg.
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

localeCallbackProfile.OnRequestUserInfoSignatureComplete = function (screenname, profilemsg ) {
  gotprofile = 1;
  profileMsg = processAwayMsg(profilemsg);
  displayProfileandAwayMsg();
}


localeCallbackProfile.OnRequestUserInfoSignatureError = function (screenname, errmsg ) {
  dump("In OnRequestUserInfoSignatureError...Nothing for now...\n");
  gotprofile = 2;
}

/*
 * Function: gmiNewIM()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Creates a new IM conversation window.
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

function gmiNewIM() {
  screenName = document.getElementById("screenname").value;
  if ( AimOnlineAway() )
		ComeBack();
  var aimBuddy = aimBuddyManager();
  if (!aimBuddy) {
    dump("Unable to create aimBuddy...\n");
    return;
  }
  //Check whether the buddy is online first.
  if (!aimBuddy.IsBuddyOnline(screenName)) {
    screenName = null;
  }
	
	if (screenName != null)
	{
		var pIAimIM = aimIMObject();
		
		if (pIAimIM)
			var pWindow = pIAimIM.GetExistingIM(screenName);
		if (pWindow)
		{
			pWindow.focus();
			return;
		}
	}
  aimIMInvokeIMForm(screenName);
}


/*
 * Function: gmiAddBuddy()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Open up the Add Buddy window.
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

function gmiAddBuddy() {
  screenName = document.getElementById("screenname").value;
  openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", 
		"modal=yes,titlebar,chrome", null, null, screenName);
}


/*
 * Function: displayProfileandAwayMsg()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: There are two async callbacks involved in GMI feature: localeCallbackAway and localeCallbackProfile.
 *  If both the callbacks are complete then we display the info the user in displayInfo fn.
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

function displayProfileandAwayMsg() {
  var newMsg;
  // As we have two callbacks we check for both the callback before we display the info. 
  if (gotprofile == 1 && isAway && gotawaymsg == 1) {
    // Most of the users doesn't have profile/signature info. Just display the default in that case.
    if (!profileMsg || profileMsg == "") {
      profileMsg = aimString("gmi.noprofileavailable");
      newMsg = awayMsg + "<hr>" + profileMsg;
    }
    else {
      newMsg = awayMsg + "<hr>" + profileMsg;
    }
    displayInfo(newMsg);
  }
  else {
    if (gotprofile == 1 && !isAway) {
      if (!profileMsg || profileMsg == "") {
        profileMsg = aimString("gmi.noprofileavailable");
      }
      newMsg = profileMsg;
      displayInfo(newMsg);
    }
  }

}


/*
 * Function: displayInfo()
 *
 * Arguments: Msg.
 * 
 * Return: None
 *
 * Description: Just displays the Msg in the GMI window. Converts smilies, html info etc. Mostly inherited from Chat code.
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/


function displayInfo(newMsg) {
 

  var moz = Components.classesByID["{77c0e42a-1dd2-11b2-8ebf-edc6606f2f4b}"];
  var moztxt = moz.createInstance(Components.interfaces.mozITXTToHTMLConv);
  var iface = Components.interfaces.mozITXTToHTMLConv;
  var mozURL = iface.kURLs;
  var mozSmiley = iface.kGlyphSubstitution;
  var smileyFeatureEnabled = aimPrefsManager().GetBoolPref("aim.general.im.smilies", null, false);
 	  
  if (smileyFeatureEnabled)
    newMsg = moztxt.scanHTML(newMsg, mozSmiley);

  var theLogNode = document.getElementById("profilefield").contentWindow;
  var myRange = theLogNode.document.createRange();
  var theLogBody =theLogNode.document.getElementsByTagName("body").item(0)
  myRange.setStartAfter(theLogBody);
  var docFrag;
	  
  if(newMsg) {
    newMsg = moztxt.scanHTML(newMsg, mozURL);
  }

  docFrag = myRange.createContextualFragment("<html>"+  newMsg +"</html><br>");
  var prevdocHeight = theLogNode.document.height;
  var isLocked=((theLogNode.scrollY + theLogNode.innerHeight) >= theLogNode.document.height) 
                    || (( theLogNode.document.height - theLogNode.scrollY ) <= 5)
	  theLogBody.appendChild(docFrag)
			  
	  
  if (isLocked){
    if ((theLogNode.innerHeight - (prevdocHeight-theLogNode.scrollY)) <= 5)
      return;
    if ((theLogNode.innerHeight < theLogNode.document.height) && (theLogNode.scrollY == prevdocHeight))
      return;

    theLogNode.scrollTo(theLogNode.scrollX, theLogNode.document.height)
  }

  //once we are done displaying the info disable the ok button. 
  document.getElementById("ok").setAttribute("disabled", "true");

}



