/*
 * Copyright (C) 2004 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: skin.h,v 1.2.2.1 2005/03/17 01:11:30 dsalt Exp $
 *
 * xml/javascript skin stuff 
 */

#ifndef HAVE_SKIN_H
#define HAVE_SKIN_H

#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include "xmlparser.h"
#include "script_engine.h"

typedef struct theme_s theme_t;
typedef struct view_s view_t;
typedef struct skin_widget_s skin_widget_t;

struct skin_widget_s {

  skin_widget_t *parent;

  view_t        *view;

  char          *id;

  char          *xscript, *yscript;
  char          *wscript, *hscript;
  int            x, y, w, h;
  int            zIndex;
  int            type;

  se_o_t        *se_obj;

  void (*layout)                  (skin_widget_t *w);
  void (*paint)                   (skin_widget_t *w, int xo, int yo);
  void (*handle_motion)           (skin_widget_t *w, int px, int py);
  gboolean (*handle_button_press) (skin_widget_t *w, int px, int py);
  void (*handle_button_release)   (skin_widget_t *w, int px, int py);
};

struct view_s {

  skin_widget_t widget;

  char         *basename;

  gboolean      is_moving;
  gboolean      repaint_needed;

  GList        *widgets;

  GtkWidget    *window, *fixed;
  GdkPixmap    *bg;
  GdkBitmap    *mask;
};

typedef struct subview_s subview_t;

struct subview_s {

  skin_widget_t widget;

  gboolean      tiled;
  char         *halign, *valign;

  GdkPixbuf    *pix;

  GList        *widgets;
};

struct theme_s {

  GList        *views;

  se_o_t       *se_obj;
  GList        *jobs;
};

#endif
