# Generated by hand against bat 0.12.0.
# bat is at <https://github.com/sharkdp/bat>.

# TODO: Have --map-syntax properly suggest from- and to-languages.
# NOTE: The completion for --style won’t help the user write anything in the comma-separated-list form.

function __bat_complete_languages_and_extensions -d 'All languages and their filenames/extensions, one per line'
    command bat --list-languages | string split : | string split ,
end

function __bat_complete_language_extensions -d 'All language extensions/names, one per line'
    command bat --list-languages | cut -d : -f 2 | string split ,
end

function __bat_complete_themes -d 'All themes, one per line'
    command bat --list-themes
end

set -l style_opts '
    auto\tdefault
    full\t
    plain\t
    changes\t
    header\t
    grid\t
    numbers\t
'

set -l color_opts '
    auto\tdefault
    never\t
    always\t
'

set -l italic_text_opts '
    always\t
    never\tdefault
'

set -l decorations_opts "$color_opts"
set -l paging_opts "$color_opts"

set -l wrap_opts '
    auto\tdefault
    never\t
    character\t
'

# While --tabs theoretically takes any number, most people should be OK with these. Specifying a list lets me explain what 0 does.
set -l tabs_opts '
    0\tpasses tabs through directly
    1\t
    2\t
    4\t
    8\t
'

complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -s l -l language -a '(__bat_complete_languages_and_extensions)' -d 'Set language for syntax highlighting'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -f -s L -l list-language -d 'List supported languages for syntax highlighting'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -s m -l map-syntax -d 'Map file name/extension to existing syntax'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l theme -a '(__bat_complete_themes)' -d 'Set theme for syntax highlighting'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -f -l list-themes -d 'List syntax-highlighting themes'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l style -a "$style_opts" -d 'Choose what to add to the file contents'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -s p -l plain -d 'Show no decorations; -pp disables paging too'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -s n -l number -d 'Only show line numbers and no other decorations'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -s A -l show-all -d 'Show non-printable characters'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -s r -l line-range -d 'Only print lines from [M]:[N] (either optional)'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -s H -l highlight-line -d 'Highlight the given line'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l color -ka "$color_opts" -d 'Specify when to use colors'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l italic-text -ka "$italic_text_opts" -d 'Specify when to use ANSI italic-text sequences'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l decorations -ka "$decorations_opts" -d 'Specify when to use --style decorations'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l paging -ka "$paging_opts" -d 'Specify when to use a pager'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l pager -d 'Specify what pager to use'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l wrap -ka "$wrap_opts" -d 'Specify text-wrapping mode'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l tabs -a "$tabs_opts" -d 'Sets tab width to N spaces'
# Don’t suggest the always-ignored added-only-for-POSIX-compliance -u/--unbuffered. Output is always unbuffered.
complete -c bat -n 'not __fish_seen_subcommand_from cache' -x -l terminal-width -d 'Explicitly set terminal width, optionally prefixed with +/-'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -s h -l help -d 'Print help'
complete -c bat -n 'not __fish_seen_subcommand_from cache' -s V -l version -d 'Show version information'

# cache things
complete -c bat -n '__fish_use_subcommand' -a cache -d 'Manage syntax-definition and theme cache'
complete -c bat -n '__fish_seen_subcommand_from cache' -f -s b -l build -d 'Initialize/update cache from the source directory'
complete -c bat -n '__fish_seen_subcommand_from cache' -f -s c -l clear -d 'Remove cached definitions and themes'
complete -c bat -n '__fish_seen_subcommand_from cache' -r -l source -d 'Specify directory to load syntaxes/themes from'
complete -c bat -n '__fish_seen_subcommand_from cache' -r -l target -d 'Specify directory to store cached syntaxes/themes'
complete -c bat -n '__fish_seen_subcommand_from cache' -f -l blank -d 'Create completely new syntax/theme sets instead of appending to the defaults'
complete -c bat -n '__fish_seen_subcommand_from cache' -f -s h -l help -d 'Print help about cache management'
