/*
 * Copyright 2005 - 2016 Zarafa and its licensors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <kopano/platform.h>
#include <kopano/ECDebug.h>

#include <mapidefs.h>
#include <mapispi.h>
#include <edkmdb.h>
#include <kopano/mapiext.h>
#include "freebusytags.h"
#include <kopano/stringutil.h>
#include <kopano/charset/convert.h>
#include <kopano/ECTags.h>
#include <kopano/EMSAbTag.h>
#include <kopano/ECABEntryID.h>

#include <mapiguid.h>
#include <kopano/mapiguidext.h>
#include <edkguid.h>
#include <kopano/ECGuid.h>

#include "freebusyguid.h"

#include <kopano/stringutil.h>

#include <iostream>
#include <sstream>
#include <kopano/mapi_ptr.h>

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define RETURN_ERROR_CASE(x) \
	case x: \
		return (HR_FAILED(x) ? "FAILED: " #x : ((x == hrSuccess) ? #x : "WARNING: " #x));

#define RETURN_CASE(x) \
	case x: \
		return #x;


#define RETURN_PROP_CASE(pt) case PROP_ID(pt): return((#pt))

/**
 * Guid debug list
 */
static const INFOGUID sGuidList[] = {
//Mapi
	{0, (GUID*)&IID_IUnknown, "IID_IUnknown"},
	{0, (GUID*)&IID_IMAPISession, "IID_IMAPISession"},
	{0, (GUID*)&IID_IMAPITable, "IID_IMAPITable"},
	{0, (GUID*)&IID_IMAPIAdviseSink, "IID_IMAPIAdviseSink"},
	{0, (GUID*)&IID_IMAPIProp, "IID_IMAPIProp"},
	{0, (GUID*)&IID_IProfSect, "IID_IProfSect"},
	{0, (GUID*)&IID_IMAPIStatus, "IID_IMAPIStatus"},
	{0, (GUID*)&IID_IMsgStore, "IID_IMsgStore"},
	{0, (GUID*)&IID_IMessage, "IID_IMessage"},
	{0, (GUID*)&IID_IAttachment, "IID_IAttachment"},
	{0, (GUID*)&IID_IAddrBook, "IID_IAddrBook"},
	{0, (GUID*)&IID_IMailUser, "IID_IMailUser"},
	{0, (GUID*)&IID_IMAPIContainer, "IID_IMAPIContainer"},
	{0, (GUID*)&IID_IMAPIFolder, "IID_IMAPIFolder"},
	{0, (GUID*)&IID_IABContainer, "IID_IABContainer"},
	{0, (GUID*)&IID_IDistList, "IID_IDistList"},
	{0, (GUID*)&IID_IMAPISup, "IID_IMAPISup"},
	{0, (GUID*)&IID_IMSProvider, "IID_IMSProvider"},
	{0, (GUID*)&IID_IABProvider, "IID_IABProvider"},
	{0, (GUID*)&IID_IXPProvider, "IID_IXPProvider"},
	{0, (GUID*)&IID_IMSLogon, "IID_IMSLogon"},
	{0, (GUID*)&IID_IABLogon, "IID_IABLogon"},
	{0, (GUID*)&IID_IXPLogon, "IID_IXPLogon"},
	{0, (GUID*)&IID_IMAPITableData, "IID_IMAPITableData"},
	{0, (GUID*)&IID_IMAPISpoolerInit, "IID_IMAPISpoolerInit"},
	{0, (GUID*)&IID_IMAPISpoolerSession, "IID_IMAPISpoolerSession"},
	{0, (GUID*)&IID_ITNEF, "IID_ITNEF"},
	{0, (GUID*)&IID_IMAPIPropData, "IID_IMAPIPropData"},
	{0, (GUID*)&IID_IMAPIControl, "IID_IMAPIControl"},
	{0, (GUID*)&IID_IProfAdmin, "IID_IProfAdmin"},
	{0, (GUID*)&IID_IMsgServiceAdmin, "IID_IMsgServiceAdmin"},
	{0, (GUID*)&IID_IMAPISpoolerService, "IID_IMAPISpoolerService"},
	{0, (GUID*)&IID_IMAPIProgress, "IID_IMAPIProgress"},
	{0, (GUID*)&IID_ISpoolerHook, "IID_ISpoolerHook"},
	{0, (GUID*)&IID_IMAPIViewContext, "IID_IMAPIViewContext"},
	{0, (GUID*)&IID_IMAPIFormMgr, "IID_IMAPIFormMgr"},
	{0, (GUID*)&IID_IEnumMAPIFormProp, "IID_IEnumMAPIFormProp"},
	{0, (GUID*)&IID_IMAPIFormInfo, "IID_IMAPIFormInfo"},
	{0, (GUID*)&IID_IProviderAdmin, "IID_IProviderAdmin"},
	{0, (GUID*)&IID_IMAPIForm, "IID_IMAPIForm"},
	{0, (GUID*)&IID_IPersistMessage, "IID_IPersistMessage"},
	{0, (GUID*)&IID_IMAPIViewAdviseSink, "IID_IMAPIViewAdviseSink"},
	{0, (GUID*)&IID_IStreamDocfile, "IID_IStreamDocfile"},
	{0, (GUID*)&IID_IMAPIFormProp, "IID_IMAPIFormProp"},
	{0, (GUID*)&IID_IMAPIFormContainer, "IID_IMAPIFormContainer"},
	{0, (GUID*)&IID_IMAPIFormAdviseSink, "IID_IMAPIFormAdviseSink"},
	{0, (GUID*)&IID_IStreamTnef, "IID_IStreamTnef"},
	{0, (GUID*)&IID_IMAPIFormFactory, "IID_IMAPIFormFactory"},
	{0, (GUID*)&IID_IMAPIMessageSite, "IID_IMAPIMessageSite"},
	{0, (GUID*)&PS_ROUTING_EMAIL_ADDRESSES, "PS_ROUTING_EMAIL_ADDRESSES"},
	{0, (GUID*)&PS_ROUTING_ADDRTYPE, "PS_ROUTING_ADDRTYPE"},
	{0, (GUID*)&PS_ROUTING_DISPLAY_NAME, "PS_ROUTING_DISPLAY_NAME"},
	{0, (GUID*)&PS_ROUTING_ENTRYID, "PS_ROUTING_ENTRYID"},
	{0, (GUID*)&PS_ROUTING_SEARCH_KEY, "PS_ROUTING_SEARCH_KEY"},
	{0, (GUID*)&MUID_PROFILE_INSTANCE, "MUID_PROFILE_INSTANCE"},
//Exchange
	{1, (GUID*)&GUID_ExchangeFormExts, "GUID_ExchangeFormExts"},
	{1, (GUID*)&LIBID_aclcls, "LIBID_aclcls"},
	{1, (GUID*)&IID_IExchangeFolderACLs, "IID_IExchangeFolderACLs"},
	{1, (GUID*)&IID_IExchangeRuleExtCallback, "IID_IExchangeRuleExtCallback"},
	{1, (GUID*)&IID_IExchangeRuleExt, "IID_IExchangeRuleExt"},
	{1, (GUID*)&LIBID_rulecls, "LIBID_rulecls"},
	{1, (GUID*)&IID_IExchangeFolderRules, "IID_IExchangeFolderRules"},
	{1, (GUID*)&IID_IExchangeManageStore, "IID_IExchangeManageStore"},
	{1, (GUID*)&IID_IExchangeManageStore2, "IID_IExchangeManageStore2"},
	{1, (GUID*)&IID_IExchangeManageStore3, "IID_IExchangeManageStore3"},
	{1, (GUID*)&IID_IExchangeManageStore4, "IID_IExchangeManageStore4"},
	{1, (GUID*)&IID_IExchangeManageStore5, "IID_IExchangeManageStore5"},
	{1, (GUID*)&IID_IExchangeModifyTable, "IID_IExchangeModifyTable"},
	{1, (GUID*)&IID_IExchangeRuleAction, "IID_IExchangeRuleAction"},
	{1, (GUID*)&IID_IExchangeFastTransfer, "IID_IExchangeFastTransfer"},
	{1, (GUID*)&IID_IExchangeExportChanges, "IID_IExchangeExportChanges"},
	{1, (GUID*)&IID_IExchangeExportChanges2, "IID_IExchangeExportChanges2"},
	{1, (GUID*)&IID_IExchangeExportChanges3, "IID_IExchangeExportChanges3"},
	{1, (GUID*)&IID_IExchangeImportHierarchyChanges, "IID_IExchangeImportHierarchyChanges"},
	{1, (GUID*)&IID_IExchangeImportContentsChanges, "IID_IExchangeImportContentsChanges"},
	{1, (GUID*)&IID_IExchangeChangeAdvisor, "IID_IExchangeChangeAdvisor"},
	{1, (GUID*)&IID_IExchangeMessageConversion, "IID_IExchangeMessageConversion"},
	{1, (GUID*)&IID_IExchangeFavorites, "IID_IExchangeFavorites"},
	{1, (GUID*)&IID_IExchangeNntpNewsfeed, "IID_IExchangeNntpNewsfeed"},
	{1, (GUID*)&IID_IExchangeBadItemCallback, "IID_IExchangeBadItemCallback"},
	{1, (GUID*)&IID_IExchangeMoveUserProgress, "IID_IExchangeMoveUserProgress"},
	{1, (GUID*)&IID_IExchangeMessageCpid0, "IID_IExchangeMessageCpid0"},
	{1, (GUID*)&IID_IExchangeServer, "IID_IExchangeServer"},
	{1, (GUID*)&IID_IStorageGroup, "IID_IStorageGroup"},
	{1, (GUID*)&IID_IPublicStoreDB, "IID_IPublicStoreDB"},
	{1, (GUID*)&IID_IPublicStoreDB2, "IID_IPublicStoreDB2"},
	{1, (GUID*)&IID_IMailboxStoreDB, "IID_IMailboxStoreDB"},
	{1, (GUID*)&IID_IMailboxStoreDB2, "IID_IMailboxStoreDB2"},
	{1, (GUID*)&IID_IFolderTree, "IID_IFolderTree"},
	{1, (GUID*)&IID_IDataSource2, "IID_IDataSource2"},
	{1, (GUID*)&IID_IExchExtCallback, "IID_IExchExtCallback"},
	{1, (GUID*)&IID_IExchExt, "IID_IExchExt"},
	{1, (GUID*)&IID_IExchExtCommands, "IID_IExchExtCommands"},
	{1, (GUID*)&IID_IExchExtUserEvents, "IID_IExchExtUserEvents"},
	{1, (GUID*)&IID_IExchExtSessionEvents, "IID_IExchExtSessionEvents"},
	{1, (GUID*)&IID_IExchExtMessageEvents, "IID_IExchExtMessageEvents"},
	{1, (GUID*)&IID_IExchExtAttachedFileEvents, "IID_IExchExtAttachedFileEvents"},
	{1, (GUID*)&IID_IExchExtPropertySheets, "IID_IExchExtPropertySheets"},
	{1, (GUID*)&IID_IExchExtAdvancedCriteria, "IID_IExchExtAdvancedCriteria"},
	{1, (GUID*)&IID_IExchExtModeless, "IID_IExchExtModeless"},
	{1, (GUID*)&IID_IExchExtModelessCallback, "IID_IExchExtModelessCallback"},
	{1, (GUID*)&IID_IConverterSession, "IID_IConverterSession"},
	{1, (GUID*)&IID_IMAPIOffline, "IID_IMAPIOffline"},
	{1, (GUID*)&IID_IMAPIOfflineNotify, "IID_IMAPIOfflineNotify"},
	{1, (GUID*)&IID_IMAPIOfflineMgr, "IID_IMAPIOfflineMgr"},
	{1, (GUID*)&IID_IPSTX, "IID_IPSTX"},
	{1, (GUID*)&IID_IPSTX2, "IID_IPSTX2"},
	{1, (GUID*)&IID_IPSTX3, "IID_IPSTX3"},
	{1, (GUID*)&IID_IPSTX4, "IID_IPSTX4"},
	{1, (GUID*)&IID_IPSTX5, "IID_IPSTX5"},
	{1, (GUID*)&IID_IPSTX6, "IID_IPSTX6"},
	{1, (GUID*)&IID_IOSTX, "IID_IOSTX"},
	{1, (GUID*)&IID_IMAPIFolderNoProvChk, "IID_IMAPIFolderNoProvChk"},
	{1, (GUID*)&IID_IMessageNoProvChk, "IID_IMessageNoProvChk"},
	{1, (GUID*)&IID_IEnumFBBlock, "IID_IEnumFBBlock"},
	{1, (GUID*)&IID_IFreeBusyData, "IID_IFreeBusyData"},
	{1, (GUID*)&IID_IFreeBusySupport, "IID_IFreeBusySupport"},
	{1, (GUID*)&IID_IFreeBusyUpdate, "IID_IFreeBusyUpdate"},
	{1, (GUID*)&IID_IOlkErrorUnknown, "IID_IOlkErrorUnknown"},
	{1, (GUID*)&IID_IOlkEnum, "IID_IOlkEnum"},
	{1, (GUID*)&IID_IOlkAccountNotify, "IID_IOlkAccountNotify"},
	{1, (GUID*)&IID_IOlkAccountHelper, "IID_IOlkAccountHelper"},
	{1, (GUID*)&IID_IOlkAccountManager, "IID_IOlkAccountManager"},
	{1, (GUID*)&IID_IOlkAccount, "IID_IOlkAccount"},
	{1, (GUID*)&IID_IAttachmentSecurity, "IID_IAttachmentSecurity"}, //Outlook 2007
	{1, (GUID*)&IID_ISelectUnicode, "IID_ISelectUnicode"},
	{1, (GUID*)&IID_IMAPIClientShutdown, "IID_IMAPIClientShutdown"},
	{1, (GUID*)&IID_IMAPIProviderShutdown, "IID_IMAPIProviderShutdown"},
	{1, (GUID*)&GUID_Dilkie, "GUID_Dilkie"},
	{1, (GUID*)&IID_IMAPIWrappedObject, "IID_IMAPIWrappedObject"},
	{1, (GUID*)&IID_IMAPISessionUnknown, "IID_IMAPISessionUnknown"},
	{1, (GUID*)&IID_IMAPISupportUnknown, "IID_IMAPISupportUnknown"},
	{1, (GUID*)&IID_IMsgServiceAdmin2, "IID_IMsgServiceAdmin2"},
	{1, (GUID*)&IID_IAddrBookSession, "IID_IAddrBookSession"},
	{1, (GUID*)&IID_CAPONE_PROF, "IID_CAPONE_PROF"},
	{1, (GUID*)&IID_IMAPISync, "IID_IMAPISync"},
	{1, (GUID*)&IID_IMAPISyncProgressCallback, "IID_IMAPISyncProgressCallback"},
	{1, (GUID*)&IID_IMAPISecureMessage, "IID_IMAPISecureMessage"},
	{1, (GUID*)&IID_IMAPIGetSession, "IID_IMAPIGetSession"},

	// Kopano
	{3, (GUID*)&IID_IECSpooler, "IID_IECSpooler"},
	{3, (GUID*)&IID_IECServiceAdmin , "IID_IECServiceAdmin"},
	{3, (GUID*)&IID_ECMSProvider , "IID_ECMSProvider"},
	{3, (GUID*)&IID_ECXPProvider , "IID_ECXPProvider"},
	{3, (GUID*)&IID_ECABProvider , "IID_ECABProvider"},
	{3, (GUID*)&IID_ECMsgStore , "IID_ECMsgStore"},
	{3, (GUID*)&IID_ECMSLogon , "IID_ECMSLogon"},
	{3, (GUID*)&IID_ECXPLogon , "IID_ECXPLogon"},
	{3, (GUID*)&IID_ECABLogon , "IID_ECABLogon"},
	{3, (GUID*)&IID_ECMAPIFolder , "IID_ECMAPIFolder"},
	{3, (GUID*)&IID_ECMessage , "IID_ECMessage"},
	{3, (GUID*)&IID_ECMAPIProp , "IID_ECMAPIProp"},
	{3, (GUID*)&IID_ECMAPITable , "IID_ECMAPITable"},
	{3, (GUID*)&IID_ECRecipTable , "IID_ECRecipTable"},
	{3, (GUID*)&IID_ECUnknown , "IID_ECUnknown"},
	{3, (GUID*)&IID_ECTableOutGoingQueue , "IID_ECTableOutGoingQueue"},
	{3, (GUID*)&IID_ECNotifyClient , "IID_ECNotifyClient"},
	{3, (GUID*)&IID_IECPropStorage , "IID_IECPropStorage"},
	{3, (GUID*)&IID_ECTransport , "IID_ECTransport"},
	{3, (GUID*)&IID_ECMAPIFolderOps , "IID_ECMAPIFolderOps"},
	{3, (GUID*)&IID_ECTableView , "IID_ECTableView"},
	{3, (GUID*)&IID_ECExchangeModifyTable , "IID_ECExchangeModifyTable"},
	{3, (GUID*)&IID_ECMemBlock , "IID_ECMemBlock"},
	{3, (GUID*)&IID_ECMemTable , "IID_ECMemTable"},
	{3, (GUID*)&IID_ECMemTableView , "IID_ECMemTableView"},
	{3, (GUID*)&IID_ECMemStream , "IID_ECMemStream"},
	{3, (GUID*)&IDD_ECUserGroupArray , "IDD_ECUserGroupArray"},
	{3, (GUID*)&IDD_ECRightsArray , "IDD_ECRightsArray"},
	{3, (GUID*)&IID_ECTransportNotify , "IID_ECTransportNotify"},
	{3, (GUID*)&IID_ECAttach , "IID_ECAttach"},
	{3, (GUID*)&IID_ECMemPropStorage , "IID_ECMemPropStorage"},
	{3, (GUID*)&IID_ECExchangeImportHierarchyChanges , "IID_ECExchangeImportHierarchyChanges"},
	{3, (GUID*)&IID_ECExchangeImportContentsChanges , "IID_ECExchangeImportContentsChanges"},
	{3, (GUID*)&IID_ECExchangeExportChanges , "IID_ECExchangeExportChanges"},
	{3, (GUID*)&IID_WSABPropStorage , "IID_WSABPropStorage"},
	{3, (GUID*)&IID_ECABProp , "IID_ECABProp"},
	{3, (GUID*)&IID_ECMailUser , "IID_ECMailUser"},
	{3, (GUID*)&IID_ECDistList , "IID_ECDistList"},
	{3, (GUID*)&IID_ECMsgStoreOffline , "IID_ECMsgStoreOffline"},
	{3, (GUID*)&IID_ECMsgStoreOnline , "IID_ECMsgStoreOnline"},
	{3, (GUID*)&IID_IECExportAddressbookChanges , "IID_IECExportAddressbookChanges"},
	{3, (GUID*)&IID_ECFreeBusyUpdate , "IID_ECFreeBusyUpdate"},
	{3, (GUID*)&IID_IECExportChanges , "IID_IECExportChanges"},
	{3, (GUID*)&IID_ECEnumFBBlock , "IID_ECEnumFBBlock"},
	{3, (GUID*)&IID_ECFreeBusyData , "IID_ECFreeBusyData"},
	{3, (GUID*)&IID_ECFreeBusySupport , "IID_ECFreeBusySupport"},
	{3, (GUID*)&IID_IECImportContentsChanges, "IID_IECImportContentsChanges"},

	// kopano ms/ab/xp/ guids
	{3, (GUID*)&KOPANO_SERVICE_GUID , "Kopano Private store"},
	{3, (GUID*)&KOPANO_STORE_PUBLIC_GUID , "Kopano Public Store"},
	{3, (GUID*)&MUIDECSAB, "Kopano Address Book"},
	{3, (GUID*)&KOPANO_STORE_DELEGATE_GUID, "Kopano Delegate Store"},
	{3, (GUID*)&GUID_NULL , "GUID_NULL"},

#ifndef LINUX
	{4, (GUID*)&IID_IExternalConnection, "IID_IExternalConnection"},
	{4, (GUID*)&IID_IMarshal, "IID_IMarshal"},
//	{4, (GUID*)&IID_IMarshal2, "IID_IMarshal2"},
	{4, (GUID*)&IID_IMalloc, "IID_IMalloc"},
	{4, (GUID*)&IID_IStdMarshalInfo, "IID_IStdMarshalInfo"},
	{4, (GUID*)&IID_IStorage, "IID_IStorage"},
	{4, (GUID*)&IID_IClassFactory, "IID_IClassFactory"},
	
#endif
	{4, (GUID*)&IID_IMSCapabilities, "IID_IMSCapabilities"},
	{4, (GUID*)&IID_IFolderSupport, "IID_IFolderSupport"},
	{4, (GUID*)&IID_IMessageRaw , "IID_IMessageRaw"},
	{4, (GUID*)&IID_IProxyStoreObject , "IID_IProxyStoreObject"},
	{4, (GUID*)&IID_IOutlookExtCallback , "IID_IOutlookExtCallback"},
	{4, (GUID*)&IID_IStream, "IID_IStream"},

	// Profile guids
	{4, (GUID*)&pbGlobalProfileSectionGuid , "pbGlobalProfileSectionGuid"},

	//Named property guid
	{5, (GUID*)&PS_PUBLIC_STRINGS, "PS_PUBLIC_STRINGS"},
	{5, (GUID*)&PS_MAPI, "PS_MAPI"},
	{5, (GUID*)&PS_INTERNET_HEADERS, "PS_INTERNET_HEADERS"},
	{5, (GUID*)&PSETID_Appointment, "PSETID_Appointment"},
	{5, (GUID*)&PSETID_Task, "PSETID_Task"},
	{5, (GUID*)&PSETID_Address, "PSETID_Address"},
	{5, (GUID*)&PSETID_Common, "PSETID_Common"},
	{5, (GUID*)&PSETID_Log, "PSETID_Log"},
	{5, (GUID*)&PSETID_Meeting, "PSETID_Meeting"},

	{5, (GUID*)&PSETID_Note, "PSETID_Note"},
	{5, (GUID*)&PSETID_Sharing, "PSETID_Sharing"},
	{5, (GUID*)&PSETID_PostRss, "PSETID_PostRss"},
	{5, (GUID*)&PSETID_UnifiedMessaging, "PSETID_UnifiedMessaging"},
	{5, (GUID*)&PSETID_AirSync, "PSETID_AirSync"},
	{5, (GUID*)&PSETID_CalendarAssistant, "PSETID_CalendarAssistant"},
	{5, (GUID*)&PSETID_CONTACT_FOLDER_RECIPIENT, "PSETID_CONTACT_FOLDER_RECIPIENT"},
		
	{5, (GUID*)&PSETID_Kopano_CalDav, "PSETID_Kopano_CalDav"},
	{5, (GUID*)&PS_EC_IMAP, "PS_EC_IMAP"},

//End of list
	{0, NULL}
};


std::string GetMAPIErrorDescription(HRESULT hResult)
{
	#define SUCCESS 0

	switch(hResult) {
		// Succes ( 6 )
		RETURN_ERROR_CASE(SUCCESS)
		RETURN_ERROR_CASE(MAPI_W_NO_SERVICE)
		RETURN_ERROR_CASE(MAPI_W_ERRORS_RETURNED)
		RETURN_ERROR_CASE(MAPI_W_POSITION_CHANGED)
		RETURN_ERROR_CASE(MAPI_W_APPROX_COUNT)
		RETURN_ERROR_CASE(MAPI_W_CANCEL_MESSAGE)
		RETURN_ERROR_CASE(MAPI_W_PARTIAL_COMPLETION)

	// Errors ( 69 )
		RETURN_ERROR_CASE(MAPI_E_INTERFACE_NOT_SUPPORTED)
		RETURN_ERROR_CASE(MAPI_E_CALL_FAILED)
		RETURN_ERROR_CASE(MAPI_E_NO_SUPPORT)
		RETURN_ERROR_CASE(MAPI_E_BAD_CHARWIDTH)
		RETURN_ERROR_CASE(MAPI_E_STRING_TOO_LONG)
		RETURN_ERROR_CASE(MAPI_E_UNKNOWN_FLAGS)
		RETURN_ERROR_CASE(MAPI_E_INVALID_ENTRYID)
		RETURN_ERROR_CASE(MAPI_E_INVALID_OBJECT)
		RETURN_ERROR_CASE(MAPI_E_OBJECT_CHANGED)
		RETURN_ERROR_CASE(MAPI_E_OBJECT_DELETED)
		
		RETURN_ERROR_CASE(MAPI_E_BUSY)
		RETURN_ERROR_CASE(MAPI_E_NOT_ENOUGH_DISK)
		RETURN_ERROR_CASE(MAPI_E_NOT_ENOUGH_RESOURCES)
		RETURN_ERROR_CASE(MAPI_E_NOT_FOUND)
		RETURN_ERROR_CASE(MAPI_E_VERSION)
		RETURN_ERROR_CASE(MAPI_E_LOGON_FAILED)
		RETURN_ERROR_CASE(MAPI_E_SESSION_LIMIT)
		RETURN_ERROR_CASE(MAPI_E_USER_CANCEL)
		RETURN_ERROR_CASE(MAPI_E_UNABLE_TO_ABORT)
		RETURN_ERROR_CASE(MAPI_E_NETWORK_ERROR)
		
		RETURN_ERROR_CASE(MAPI_E_DISK_ERROR)
		RETURN_ERROR_CASE(MAPI_E_TOO_COMPLEX)
		RETURN_ERROR_CASE(MAPI_E_BAD_COLUMN)
		RETURN_ERROR_CASE(MAPI_E_EXTENDED_ERROR)
		RETURN_ERROR_CASE(MAPI_E_COMPUTED)
		RETURN_ERROR_CASE(MAPI_E_CORRUPT_DATA)
		RETURN_ERROR_CASE(MAPI_E_UNCONFIGURED)
		RETURN_ERROR_CASE(MAPI_E_FAILONEPROVIDER)
		RETURN_ERROR_CASE(MAPI_E_UNKNOWN_CPID)
		RETURN_ERROR_CASE(MAPI_E_UNKNOWN_LCID)
		
		RETURN_ERROR_CASE(MAPI_E_PASSWORD_CHANGE_REQUIRED)
		RETURN_ERROR_CASE(MAPI_E_PASSWORD_EXPIRED)
		RETURN_ERROR_CASE(MAPI_E_INVALID_WORKSTATION_ACCOUNT)
		RETURN_ERROR_CASE(MAPI_E_INVALID_ACCESS_TIME)
		RETURN_ERROR_CASE(MAPI_E_ACCOUNT_DISABLED)
		RETURN_ERROR_CASE(MAPI_E_END_OF_SESSION)
		RETURN_ERROR_CASE(MAPI_E_UNKNOWN_ENTRYID)
		RETURN_ERROR_CASE(MAPI_E_MISSING_REQUIRED_COLUMN)
		RETURN_ERROR_CASE(MAPI_E_BAD_VALUE)
		RETURN_ERROR_CASE(MAPI_E_INVALID_TYPE)
		
		RETURN_ERROR_CASE(MAPI_E_TYPE_NO_SUPPORT)
		RETURN_ERROR_CASE(MAPI_E_UNEXPECTED_TYPE)
		RETURN_ERROR_CASE(MAPI_E_TOO_BIG)
		RETURN_ERROR_CASE(MAPI_E_DECLINE_COPY)
		RETURN_ERROR_CASE(MAPI_E_UNEXPECTED_ID)
		RETURN_ERROR_CASE(MAPI_E_UNABLE_TO_COMPLETE)
		RETURN_ERROR_CASE(MAPI_E_TIMEOUT)
		RETURN_ERROR_CASE(MAPI_E_TABLE_EMPTY)
		RETURN_ERROR_CASE(MAPI_E_TABLE_TOO_BIG)
		RETURN_ERROR_CASE(MAPI_E_INVALID_BOOKMARK)

		RETURN_ERROR_CASE(MAPI_E_WAIT)
		RETURN_ERROR_CASE(MAPI_E_CANCEL)
		RETURN_ERROR_CASE(MAPI_E_NOT_ME)
		RETURN_ERROR_CASE(MAPI_E_CORRUPT_STORE)
		RETURN_ERROR_CASE(MAPI_E_NOT_IN_QUEUE)
		RETURN_ERROR_CASE(MAPI_E_NO_SUPPRESS)
		RETURN_ERROR_CASE(MAPI_E_COLLISION)
		RETURN_ERROR_CASE(MAPI_E_NOT_INITIALIZED)
		RETURN_ERROR_CASE(MAPI_E_NON_STANDARD)
		RETURN_ERROR_CASE(MAPI_E_NO_RECIPIENTS)

		RETURN_ERROR_CASE(MAPI_E_SUBMITTED)
		RETURN_ERROR_CASE(MAPI_E_HAS_FOLDERS)
		RETURN_ERROR_CASE(MAPI_E_HAS_MESSAGES)
		RETURN_ERROR_CASE(MAPI_E_FOLDER_CYCLE)
		RETURN_ERROR_CASE(MAPI_E_STORE_FULL)
		RETURN_ERROR_CASE(MAPI_E_AMBIGUOUS_RECIP)
		RETURN_ERROR_CASE(MAPI_E_INVALID_PARAMETER)
		RETURN_ERROR_CASE(MAPI_E_NOT_ENOUGH_MEMORY)
		RETURN_ERROR_CASE(MAPI_E_NO_ACCESS)
		default:
			break;
	}

	char szResult[DEBUGBUFSIZE+1];

	_snprintf(szResult, DEBUGBUFSIZE, "0x%08X", hResult);

	return szResult;
}

std::string PropNameFromPropArray(ULONG cValues, const SPropValue *lpPropArray)
{
	std::string data;
	
	if(lpPropArray == NULL)
		return "NULL";
	else if(cValues == 0)
		return "EMPTY";

	for (unsigned int i = 0; i < cValues; ++i) {
		if(i>0)
			data+=", ";

		data += PropNameFromPropTag(lpPropArray[i].ulPropTag);
		data += ": ";
		data += PropValueToString(&lpPropArray[i]);
		data += "\n";
		
	}

	return data;
}

std::string PropNameFromPropTagArray(const SPropTagArray *lpPropTagArray)
{
	std::string data;
	
	if(lpPropTagArray == NULL)
		return "NULL";
	else if(lpPropTagArray->cValues == 0)
		return "EMPTY";

	for (unsigned int i = 0; i < lpPropTagArray->cValues; ++i) {
		if(i>0)
			data+=", ";

		data += PropNameFromPropTag(lpPropTagArray->aulPropTag[i]);
		if (PROP_TYPE(lpPropTagArray->aulPropTag[i]) == PT_UNICODE)
			data += "_W";
		else if (PROP_TYPE(lpPropTagArray->aulPropTag[i]) == PT_STRING8)
			data += "_A";
	}

	return data;
}

std::string	PropNameFromPropTag(ULONG ulPropTag)
{

	switch (PROP_ID(ulPropTag)) 
	{
		// Begin <MAPItags.h>
		RETURN_PROP_CASE(PR_ACKNOWLEDGEMENT_MODE);
		RETURN_PROP_CASE(PR_ALTERNATE_RECIPIENT_ALLOWED);
		RETURN_PROP_CASE(PR_AUTHORIZING_USERS);
		RETURN_PROP_CASE(PR_AUTO_FORWARD_COMMENT);
		RETURN_PROP_CASE(PR_AUTO_FORWARDED);
		RETURN_PROP_CASE(PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID);
		RETURN_PROP_CASE(PR_CONTENT_CORRELATOR);
		RETURN_PROP_CASE(PR_CONTENT_IDENTIFIER);
		RETURN_PROP_CASE(PR_CONTENT_LENGTH);
		RETURN_PROP_CASE(PR_CONTENT_RETURN_REQUESTED);
		RETURN_PROP_CASE(PR_CONVERSATION_KEY);
		RETURN_PROP_CASE(PR_CONVERSION_EITS);
		RETURN_PROP_CASE(PR_CONVERSION_WITH_LOSS_PROHIBITED);
		RETURN_PROP_CASE(PR_CONVERTED_EITS);
		RETURN_PROP_CASE(PR_DEFERRED_DELIVERY_TIME);
		RETURN_PROP_CASE(PR_DELIVER_TIME);
		RETURN_PROP_CASE(PR_DISCARD_REASON);
		RETURN_PROP_CASE(PR_DISCLOSURE_OF_RECIPIENTS);
		RETURN_PROP_CASE(PR_DL_EXPANSION_HISTORY);
		RETURN_PROP_CASE(PR_DL_EXPANSION_PROHIBITED);
		RETURN_PROP_CASE(PR_EXPIRY_TIME);
		RETURN_PROP_CASE(PR_IMPLICIT_CONVERSION_PROHIBITED);
		RETURN_PROP_CASE(PR_IMPORTANCE);
		RETURN_PROP_CASE(PR_IPM_ID);
		RETURN_PROP_CASE(PR_LATEST_DELIVERY_TIME);
		RETURN_PROP_CASE(PR_MESSAGE_CLASS);
		RETURN_PROP_CASE(PR_MESSAGE_DELIVERY_ID);
		RETURN_PROP_CASE(PR_MESSAGE_SECURITY_LABEL);
		RETURN_PROP_CASE(PR_OBSOLETED_IPMS);
		RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIPIENT_NAME);
		RETURN_PROP_CASE(PR_ORIGINAL_EITS);
		RETURN_PROP_CASE(PR_ORIGINATOR_CERTIFICATE);
		RETURN_PROP_CASE(PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED);
		RETURN_PROP_CASE(PR_ORIGINATOR_RETURN_ADDRESS);
		RETURN_PROP_CASE(PR_PARENT_KEY);
		RETURN_PROP_CASE(PR_PRIORITY);
		RETURN_PROP_CASE(PR_ORIGIN_CHECK);
		RETURN_PROP_CASE(PR_PROOF_OF_SUBMISSION_REQUESTED);
		RETURN_PROP_CASE(PR_READ_RECEIPT_REQUESTED);
		RETURN_PROP_CASE(PR_RECEIPT_TIME);
		RETURN_PROP_CASE(PR_RECIPIENT_REASSIGNMENT_PROHIBITED);
		RETURN_PROP_CASE(PR_REDIRECTION_HISTORY);
		RETURN_PROP_CASE(PR_RELATED_IPMS);
		RETURN_PROP_CASE(PR_ORIGINAL_SENSITIVITY);
		RETURN_PROP_CASE(PR_LANGUAGES);
		RETURN_PROP_CASE(PR_REPLY_TIME);
		RETURN_PROP_CASE(PR_REPORT_TAG);
		RETURN_PROP_CASE(PR_REPORT_TIME);
		RETURN_PROP_CASE(PR_RETURNED_IPM);
		RETURN_PROP_CASE(PR_SECURITY);
		RETURN_PROP_CASE(PR_INCOMPLETE_COPY);
		RETURN_PROP_CASE(PR_SENSITIVITY);
		RETURN_PROP_CASE(PR_SUBJECT);
		RETURN_PROP_CASE(PR_SUBJECT_IPM);
		RETURN_PROP_CASE(PR_CLIENT_SUBMIT_TIME);
		RETURN_PROP_CASE(PR_REPORT_NAME);
		RETURN_PROP_CASE(PR_SENT_REPRESENTING_SEARCH_KEY);
		RETURN_PROP_CASE(PR_X400_CONTENT_TYPE);
		RETURN_PROP_CASE(PR_SUBJECT_PREFIX);
		RETURN_PROP_CASE(PR_NON_RECEIPT_REASON);
		RETURN_PROP_CASE(PR_RECEIVED_BY_ENTRYID);
		RETURN_PROP_CASE(PR_RECEIVED_BY_NAME);
		RETURN_PROP_CASE(PR_SENT_REPRESENTING_ENTRYID);
		RETURN_PROP_CASE(PR_SENT_REPRESENTING_NAME);
		RETURN_PROP_CASE(PR_RCVD_REPRESENTING_ENTRYID);
		RETURN_PROP_CASE(PR_RCVD_REPRESENTING_NAME);
		RETURN_PROP_CASE(PR_REPORT_ENTRYID);
		RETURN_PROP_CASE(PR_READ_RECEIPT_ENTRYID);
		RETURN_PROP_CASE(PR_MESSAGE_SUBMISSION_ID);
		RETURN_PROP_CASE(PR_PROVIDER_SUBMIT_TIME);
		RETURN_PROP_CASE(PR_ORIGINAL_SUBJECT);
		RETURN_PROP_CASE(PR_DISC_VAL);
		RETURN_PROP_CASE(PR_ORIG_MESSAGE_CLASS);
		RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_ENTRYID);
		RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_NAME);
		RETURN_PROP_CASE(PR_ORIGINAL_SUBMIT_TIME);
		RETURN_PROP_CASE(PR_REPLY_RECIPIENT_ENTRIES);
		RETURN_PROP_CASE(PR_REPLY_RECIPIENT_NAMES);
		RETURN_PROP_CASE(PR_RECEIVED_BY_SEARCH_KEY);
		RETURN_PROP_CASE(PR_RCVD_REPRESENTING_SEARCH_KEY);
		RETURN_PROP_CASE(PR_READ_RECEIPT_SEARCH_KEY);
		RETURN_PROP_CASE(PR_REPORT_SEARCH_KEY);
		RETURN_PROP_CASE(PR_ORIGINAL_DELIVERY_TIME);
		RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_SEARCH_KEY);
		RETURN_PROP_CASE(PR_MESSAGE_TO_ME);
		RETURN_PROP_CASE(PR_MESSAGE_CC_ME);
		RETURN_PROP_CASE(PR_MESSAGE_RECIP_ME);
		RETURN_PROP_CASE(PR_ORIGINAL_SENDER_NAME);
		RETURN_PROP_CASE(PR_ORIGINAL_SENDER_ENTRYID);
		RETURN_PROP_CASE(PR_ORIGINAL_SENDER_SEARCH_KEY);
		RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_NAME);
		RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_ENTRYID);
		RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY);
		RETURN_PROP_CASE(PR_START_DATE);
		RETURN_PROP_CASE(PR_END_DATE);
		RETURN_PROP_CASE(PR_OWNER_APPT_ID);
		RETURN_PROP_CASE(PR_RESPONSE_REQUESTED);
		RETURN_PROP_CASE(PR_SENT_REPRESENTING_ADDRTYPE);
		RETURN_PROP_CASE(PR_SENT_REPRESENTING_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_ORIGINAL_SENDER_ADDRTYPE);
		RETURN_PROP_CASE(PR_ORIGINAL_SENDER_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE);
		RETURN_PROP_CASE(PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_CONVERSATION_TOPIC);
		RETURN_PROP_CASE(PR_CONVERSATION_INDEX);
		RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_BCC);
		RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_CC);
		RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_TO);
		RETURN_PROP_CASE(PR_RECEIVED_BY_ADDRTYPE);
		RETURN_PROP_CASE(PR_RECEIVED_BY_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_RCVD_REPRESENTING_ADDRTYPE);
		RETURN_PROP_CASE(PR_RCVD_REPRESENTING_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_ADDRTYPE);
		RETURN_PROP_CASE(PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE);
		RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_TRANSPORT_MESSAGE_HEADERS);
		RETURN_PROP_CASE(PR_DELEGATION);
		RETURN_PROP_CASE(PR_TNEF_CORRELATION_KEY);
		RETURN_PROP_CASE(PR_BODY);
		RETURN_PROP_CASE(PR_REPORT_TEXT);
		RETURN_PROP_CASE(PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY);
		RETURN_PROP_CASE(PR_REPORTING_DL_NAME);
		RETURN_PROP_CASE(PR_REPORTING_MTA_CERTIFICATE);
		RETURN_PROP_CASE(PR_RTF_SYNC_BODY_CRC);
		RETURN_PROP_CASE(PR_RTF_SYNC_BODY_COUNT);
		RETURN_PROP_CASE(PR_RTF_SYNC_BODY_TAG);
		RETURN_PROP_CASE(PR_RTF_COMPRESSED);
		RETURN_PROP_CASE(PR_RTF_SYNC_PREFIX_COUNT);
		RETURN_PROP_CASE(PR_RTF_SYNC_TRAILING_COUNT);
		RETURN_PROP_CASE(PR_ORIGINALLY_INTENDED_RECIP_ENTRYID);
		RETURN_PROP_CASE(PR_CONTENT_INTEGRITY_CHECK);
		RETURN_PROP_CASE(PR_EXPLICIT_CONVERSION);
		RETURN_PROP_CASE(PR_IPM_RETURN_REQUESTED);
		RETURN_PROP_CASE(PR_MESSAGE_TOKEN);
		RETURN_PROP_CASE(PR_NDR_REASON_CODE);
		RETURN_PROP_CASE(PR_NDR_DIAG_CODE);
		RETURN_PROP_CASE(PR_NON_RECEIPT_NOTIFICATION_REQUESTED);
		RETURN_PROP_CASE(PR_DELIVERY_POINT);
		RETURN_PROP_CASE(PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED);
		RETURN_PROP_CASE(PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT);
		RETURN_PROP_CASE(PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY);
		RETURN_PROP_CASE(PR_PHYSICAL_DELIVERY_MODE);
		RETURN_PROP_CASE(PR_PHYSICAL_DELIVERY_REPORT_REQUEST);
		RETURN_PROP_CASE(PR_PHYSICAL_FORWARDING_ADDRESS);
		RETURN_PROP_CASE(PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED);
		RETURN_PROP_CASE(PR_PHYSICAL_FORWARDING_PROHIBITED);
		RETURN_PROP_CASE(PR_PHYSICAL_RENDITION_ATTRIBUTES);
		RETURN_PROP_CASE(PR_PROOF_OF_DELIVERY);
		RETURN_PROP_CASE(PR_PROOF_OF_DELIVERY_REQUESTED);
		RETURN_PROP_CASE(PR_RECIPIENT_CERTIFICATE);
		RETURN_PROP_CASE(PR_RECIPIENT_NUMBER_FOR_ADVICE);
		RETURN_PROP_CASE(PR_RECIPIENT_TYPE);
		RETURN_PROP_CASE(PR_REGISTERED_MAIL_TYPE);
		RETURN_PROP_CASE(PR_REPLY_REQUESTED);
		RETURN_PROP_CASE(PR_REQUESTED_DELIVERY_METHOD);
		RETURN_PROP_CASE(PR_SENDER_ENTRYID);
		RETURN_PROP_CASE(PR_SENDER_NAME);
		RETURN_PROP_CASE(PR_SUPPLEMENTARY_INFO);
		RETURN_PROP_CASE(PR_TYPE_OF_MTS_USER);
		RETURN_PROP_CASE(PR_SENDER_SEARCH_KEY);
		RETURN_PROP_CASE(PR_SENDER_ADDRTYPE);
		RETURN_PROP_CASE(PR_SENDER_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_CURRENT_VERSION);
		RETURN_PROP_CASE(PR_DELETE_AFTER_SUBMIT);
		RETURN_PROP_CASE(PR_DISPLAY_BCC);
		RETURN_PROP_CASE(PR_DISPLAY_CC);
		RETURN_PROP_CASE(PR_DISPLAY_TO);
		RETURN_PROP_CASE(PR_PARENT_DISPLAY);
		RETURN_PROP_CASE(PR_MESSAGE_DELIVERY_TIME);
		RETURN_PROP_CASE(PR_MESSAGE_FLAGS);
		RETURN_PROP_CASE(PR_MESSAGE_SIZE);
		RETURN_PROP_CASE(PR_PARENT_ENTRYID);
		RETURN_PROP_CASE(PR_SENTMAIL_ENTRYID);
		RETURN_PROP_CASE(PR_CORRELATE);
		RETURN_PROP_CASE(PR_CORRELATE_MTSID);
		RETURN_PROP_CASE(PR_DISCRETE_VALUES);
		RETURN_PROP_CASE(PR_RESPONSIBILITY);
		RETURN_PROP_CASE(PR_SPOOLER_STATUS);
		RETURN_PROP_CASE(PR_TRANSPORT_STATUS);
		RETURN_PROP_CASE(PR_MESSAGE_RECIPIENTS);
		RETURN_PROP_CASE(PR_MESSAGE_ATTACHMENTS);
		RETURN_PROP_CASE(PR_SUBMIT_FLAGS);
		RETURN_PROP_CASE(PR_RECIPIENT_STATUS);
		RETURN_PROP_CASE(PR_TRANSPORT_KEY);
		RETURN_PROP_CASE(PR_MSG_STATUS);
		RETURN_PROP_CASE(PR_MESSAGE_DOWNLOAD_TIME);
		RETURN_PROP_CASE(PR_CREATION_VERSION);
		RETURN_PROP_CASE(PR_MODIFY_VERSION);
		RETURN_PROP_CASE(PR_HASATTACH);
		RETURN_PROP_CASE(PR_BODY_CRC);
		RETURN_PROP_CASE(PR_NORMALIZED_SUBJECT);
		RETURN_PROP_CASE(PR_RTF_IN_SYNC);
		RETURN_PROP_CASE(PR_ATTACH_SIZE);
		RETURN_PROP_CASE(PR_ATTACH_NUM);
		RETURN_PROP_CASE(PR_PREPROCESS);
		RETURN_PROP_CASE(PR_ORIGINATING_MTA_CERTIFICATE);
		RETURN_PROP_CASE(PR_PROOF_OF_SUBMISSION);
		RETURN_PROP_CASE(PR_ENTRYID);
		RETURN_PROP_CASE(PR_OBJECT_TYPE);
		RETURN_PROP_CASE(PR_ICON);
		RETURN_PROP_CASE(PR_MINI_ICON);
		RETURN_PROP_CASE(PR_STORE_ENTRYID);
		RETURN_PROP_CASE(PR_STORE_RECORD_KEY);
		RETURN_PROP_CASE(PR_RECORD_KEY);
		RETURN_PROP_CASE(PR_MAPPING_SIGNATURE);
		RETURN_PROP_CASE(PR_ACCESS_LEVEL);
		RETURN_PROP_CASE(PR_INSTANCE_KEY);
		RETURN_PROP_CASE(PR_ROW_TYPE);
		RETURN_PROP_CASE(PR_ACCESS);
		RETURN_PROP_CASE(PR_ROWID);
		RETURN_PROP_CASE(PR_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_ADDRTYPE);
		RETURN_PROP_CASE(PR_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_COMMENT);
		RETURN_PROP_CASE(PR_DEPTH);
		RETURN_PROP_CASE(PR_PROVIDER_DISPLAY);
		RETURN_PROP_CASE(PR_CREATION_TIME);
		RETURN_PROP_CASE(PR_LAST_MODIFICATION_TIME);
		RETURN_PROP_CASE(PR_RESOURCE_FLAGS);
		RETURN_PROP_CASE(PR_PROVIDER_DLL_NAME);
		RETURN_PROP_CASE(PR_SEARCH_KEY);
		RETURN_PROP_CASE(PR_PROVIDER_UID);
		RETURN_PROP_CASE(PR_PROVIDER_ORDINAL);
		RETURN_PROP_CASE(PR_FORM_VERSION);
		RETURN_PROP_CASE(PR_FORM_CLSID);
		RETURN_PROP_CASE(PR_FORM_CONTACT_NAME);
		RETURN_PROP_CASE(PR_FORM_CATEGORY);
		RETURN_PROP_CASE(PR_FORM_CATEGORY_SUB);
		RETURN_PROP_CASE(PR_FORM_HOST_MAP);
		RETURN_PROP_CASE(PR_FORM_HIDDEN);
		RETURN_PROP_CASE(PR_FORM_DESIGNER_NAME);
		RETURN_PROP_CASE(PR_FORM_DESIGNER_GUID);
		RETURN_PROP_CASE(PR_FORM_MESSAGE_BEHAVIOR);
		RETURN_PROP_CASE(PR_DEFAULT_STORE);
		RETURN_PROP_CASE(PR_STORE_SUPPORT_MASK);
		RETURN_PROP_CASE(PR_STORE_STATE);
		RETURN_PROP_CASE(PR_IPM_SUBTREE_SEARCH_KEY);
		RETURN_PROP_CASE(PR_IPM_OUTBOX_SEARCH_KEY);
		RETURN_PROP_CASE(PR_IPM_WASTEBASKET_SEARCH_KEY);
		RETURN_PROP_CASE(PR_IPM_SENTMAIL_SEARCH_KEY);
		RETURN_PROP_CASE(PR_MDB_PROVIDER);
		RETURN_PROP_CASE(PR_RECEIVE_FOLDER_SETTINGS);
		RETURN_PROP_CASE(PR_VALID_FOLDER_MASK);
		RETURN_PROP_CASE(PR_IPM_SUBTREE_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_OUTBOX_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_WASTEBASKET_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_SENTMAIL_ENTRYID);
		RETURN_PROP_CASE(PR_VIEWS_ENTRYID);
		RETURN_PROP_CASE(PR_COMMON_VIEWS_ENTRYID);
		RETURN_PROP_CASE(PR_FINDER_ENTRYID);
		RETURN_PROP_CASE(PR_CONTAINER_FLAGS);
		RETURN_PROP_CASE(PR_FOLDER_TYPE);
		RETURN_PROP_CASE(PR_CONTENT_COUNT);
		RETURN_PROP_CASE(PR_CONTENT_UNREAD);
		RETURN_PROP_CASE(PR_CREATE_TEMPLATES);
		RETURN_PROP_CASE(PR_DETAILS_TABLE);
		RETURN_PROP_CASE(PR_SEARCH);
		RETURN_PROP_CASE(PR_SELECTABLE);
		RETURN_PROP_CASE(PR_SUBFOLDERS);
		RETURN_PROP_CASE(PR_STATUS);
		RETURN_PROP_CASE(PR_ANR);
		RETURN_PROP_CASE(PR_CONTENTS_SORT_ORDER);
		RETURN_PROP_CASE(PR_CONTAINER_HIERARCHY);
		RETURN_PROP_CASE(PR_CONTAINER_CONTENTS);
		RETURN_PROP_CASE(PR_FOLDER_ASSOCIATED_CONTENTS);
		RETURN_PROP_CASE(PR_DEF_CREATE_DL);
		RETURN_PROP_CASE(PR_DEF_CREATE_MAILUSER);
		RETURN_PROP_CASE(PR_CONTAINER_CLASS);
		RETURN_PROP_CASE(PR_CONTAINER_MODIFY_VERSION);
		RETURN_PROP_CASE(PR_AB_PROVIDER_ID);
		RETURN_PROP_CASE(PR_DEFAULT_VIEW_ENTRYID);
		RETURN_PROP_CASE(PR_ASSOC_CONTENT_COUNT);
		RETURN_PROP_CASE(PR_ATTACHMENT_X400_PARAMETERS);
		RETURN_PROP_CASE(PR_ATTACH_DATA_OBJ);
		RETURN_PROP_CASE(PR_ATTACH_ENCODING);
		RETURN_PROP_CASE(PR_ATTACH_EXTENSION);
		RETURN_PROP_CASE(PR_ATTACH_FILENAME);
		RETURN_PROP_CASE(PR_ATTACH_METHOD);
		RETURN_PROP_CASE(PR_ATTACH_LONG_FILENAME);
		RETURN_PROP_CASE(PR_ATTACH_PATHNAME);
		RETURN_PROP_CASE(PR_ATTACH_RENDERING);
		RETURN_PROP_CASE(PR_ATTACH_TAG);
		RETURN_PROP_CASE(PR_RENDERING_POSITION);
		RETURN_PROP_CASE(PR_ATTACH_TRANSPORT_NAME);
		RETURN_PROP_CASE(PR_ATTACH_LONG_PATHNAME);
		RETURN_PROP_CASE(PR_ATTACH_MIME_TAG);
		RETURN_PROP_CASE(PR_ATTACH_ADDITIONAL_INFO);
		RETURN_PROP_CASE(PR_DISPLAY_TYPE);
		RETURN_PROP_CASE(PR_DISPLAY_TYPE_EX);
		RETURN_PROP_CASE(PR_TEMPLATEID);
		RETURN_PROP_CASE(PR_PRIMARY_CAPABILITY);
		RETURN_PROP_CASE(PR_7BIT_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_ACCOUNT);
		RETURN_PROP_CASE(PR_ALTERNATE_RECIPIENT);
		RETURN_PROP_CASE(PR_CALLBACK_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_CONVERSION_PROHIBITED);
		RETURN_PROP_CASE(PR_DISCLOSE_RECIPIENTS);
		RETURN_PROP_CASE(PR_GENERATION);
		RETURN_PROP_CASE(PR_GIVEN_NAME);
		RETURN_PROP_CASE(PR_GOVERNMENT_ID_NUMBER);
		RETURN_PROP_CASE(PR_BUSINESS_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_HOME_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_INITIALS);
		RETURN_PROP_CASE(PR_KEYWORD);
		RETURN_PROP_CASE(PR_LANGUAGE);
		RETURN_PROP_CASE(PR_LOCATION);
		RETURN_PROP_CASE(PR_MAIL_PERMISSION);
		RETURN_PROP_CASE(PR_MHS_COMMON_NAME);
		RETURN_PROP_CASE(PR_ORGANIZATIONAL_ID_NUMBER);
		RETURN_PROP_CASE(PR_SURNAME);
		RETURN_PROP_CASE(PR_ORIGINAL_ENTRYID);
		RETURN_PROP_CASE(PR_ORIGINAL_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_ORIGINAL_SEARCH_KEY);
		RETURN_PROP_CASE(PR_POSTAL_ADDRESS);
		RETURN_PROP_CASE(PR_COMPANY_NAME);
		RETURN_PROP_CASE(PR_TITLE);
		RETURN_PROP_CASE(PR_DEPARTMENT_NAME);
		RETURN_PROP_CASE(PR_OFFICE_LOCATION);
		RETURN_PROP_CASE(PR_PRIMARY_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_BUSINESS2_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_MOBILE_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_RADIO_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_CAR_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_OTHER_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_TRANSMITABLE_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_PAGER_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_USER_CERTIFICATE);
		RETURN_PROP_CASE(PR_PRIMARY_FAX_NUMBER);
		RETURN_PROP_CASE(PR_BUSINESS_FAX_NUMBER);
		RETURN_PROP_CASE(PR_HOME_FAX_NUMBER);
		RETURN_PROP_CASE(PR_COUNTRY);
		RETURN_PROP_CASE(PR_LOCALITY);
		RETURN_PROP_CASE(PR_STATE_OR_PROVINCE);
		RETURN_PROP_CASE(PR_STREET_ADDRESS);
		RETURN_PROP_CASE(PR_POSTAL_CODE);
		RETURN_PROP_CASE(PR_POST_OFFICE_BOX);
		RETURN_PROP_CASE(PR_TELEX_NUMBER);
		RETURN_PROP_CASE(PR_ISDN_NUMBER);
		RETURN_PROP_CASE(PR_ASSISTANT_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_HOME2_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_ASSISTANT);
		RETURN_PROP_CASE(PR_SEND_RICH_INFO);
		RETURN_PROP_CASE(PR_WEDDING_ANNIVERSARY);
		RETURN_PROP_CASE(PR_BIRTHDAY);
		RETURN_PROP_CASE(PR_HOBBIES);
		RETURN_PROP_CASE(PR_MIDDLE_NAME);
		RETURN_PROP_CASE(PR_DISPLAY_NAME_PREFIX);
		RETURN_PROP_CASE(PR_PROFESSION);
		RETURN_PROP_CASE(PR_PREFERRED_BY_NAME);
		RETURN_PROP_CASE(PR_SPOUSE_NAME);
		RETURN_PROP_CASE(PR_COMPUTER_NETWORK_NAME);
		RETURN_PROP_CASE(PR_CUSTOMER_ID);
		RETURN_PROP_CASE(PR_TTYTDD_PHONE_NUMBER);
		RETURN_PROP_CASE(PR_FTP_SITE);
		RETURN_PROP_CASE(PR_GENDER);
		RETURN_PROP_CASE(PR_MANAGER_NAME);
		RETURN_PROP_CASE(PR_NICKNAME);
		RETURN_PROP_CASE(PR_PERSONAL_HOME_PAGE);
		RETURN_PROP_CASE(PR_BUSINESS_HOME_PAGE);
		RETURN_PROP_CASE(PR_CONTACT_VERSION);
		RETURN_PROP_CASE(PR_CONTACT_ENTRYIDS);
		RETURN_PROP_CASE(PR_CONTACT_ADDRTYPES);
		RETURN_PROP_CASE(PR_CONTACT_DEFAULT_ADDRESS_INDEX);
		RETURN_PROP_CASE(PR_CONTACT_EMAIL_ADDRESSES);
		RETURN_PROP_CASE(PR_COMPANY_MAIN_PHONE_NUMBER);
		RETURN_PROP_CASE(PR_CHILDRENS_NAMES);
		RETURN_PROP_CASE(PR_HOME_ADDRESS_CITY);
		RETURN_PROP_CASE(PR_HOME_ADDRESS_COUNTRY);
		RETURN_PROP_CASE(PR_HOME_ADDRESS_POSTAL_CODE);
		RETURN_PROP_CASE(PR_HOME_ADDRESS_STATE_OR_PROVINCE);
		RETURN_PROP_CASE(PR_HOME_ADDRESS_STREET);
		RETURN_PROP_CASE(PR_HOME_ADDRESS_POST_OFFICE_BOX);
		RETURN_PROP_CASE(PR_OTHER_ADDRESS_CITY);
		RETURN_PROP_CASE(PR_OTHER_ADDRESS_COUNTRY);
		RETURN_PROP_CASE(PR_OTHER_ADDRESS_POSTAL_CODE);
		RETURN_PROP_CASE(PR_OTHER_ADDRESS_STATE_OR_PROVINCE);
		RETURN_PROP_CASE(PR_OTHER_ADDRESS_STREET);
		RETURN_PROP_CASE(PR_OTHER_ADDRESS_POST_OFFICE_BOX);
		RETURN_PROP_CASE(PR_STORE_PROVIDERS);
		RETURN_PROP_CASE(PR_AB_PROVIDERS);
		RETURN_PROP_CASE(PR_TRANSPORT_PROVIDERS);
		RETURN_PROP_CASE(PR_DEFAULT_PROFILE);
		RETURN_PROP_CASE(PR_AB_SEARCH_PATH);
		RETURN_PROP_CASE(PR_AB_DEFAULT_DIR);
		RETURN_PROP_CASE(PR_AB_DEFAULT_PAB);
		RETURN_PROP_CASE(PR_FILTERING_HOOKS);
		RETURN_PROP_CASE(PR_SERVICE_NAME);
		RETURN_PROP_CASE(PR_SERVICE_DLL_NAME);
		RETURN_PROP_CASE(PR_SERVICE_ENTRY_NAME);
		RETURN_PROP_CASE(PR_SERVICE_UID);
		RETURN_PROP_CASE(PR_SERVICE_EXTRA_UIDS);
		RETURN_PROP_CASE(PR_SERVICES);
		RETURN_PROP_CASE(PR_SERVICE_SUPPORT_FILES);
		RETURN_PROP_CASE(PR_SERVICE_DELETE_FILES);
		RETURN_PROP_CASE(PR_AB_SEARCH_PATH_UPDATE);
		RETURN_PROP_CASE(PR_PROFILE_NAME);
		RETURN_PROP_CASE(PR_IDENTITY_DISPLAY);
		RETURN_PROP_CASE(PR_IDENTITY_ENTRYID);
		RETURN_PROP_CASE(PR_RESOURCE_METHODS);
		RETURN_PROP_CASE(PR_RESOURCE_TYPE);
		RETURN_PROP_CASE(PR_STATUS_CODE);
		RETURN_PROP_CASE(PR_IDENTITY_SEARCH_KEY);
		RETURN_PROP_CASE(PR_OWN_STORE_ENTRYID);
		RETURN_PROP_CASE(PR_RESOURCE_PATH);
		RETURN_PROP_CASE(PR_STATUS_STRING);
		RETURN_PROP_CASE(PR_X400_DEFERRED_DELIVERY_CANCEL);
		RETURN_PROP_CASE(PR_HEADER_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_REMOTE_PROGRESS);
		RETURN_PROP_CASE(PR_REMOTE_PROGRESS_TEXT);
		RETURN_PROP_CASE(PR_REMOTE_VALIDATE_OK);
		RETURN_PROP_CASE(PR_CONTROL_FLAGS);
		RETURN_PROP_CASE(PR_CONTROL_STRUCTURE);
		RETURN_PROP_CASE(PR_CONTROL_TYPE);
		RETURN_PROP_CASE(PR_DELTAX);
		RETURN_PROP_CASE(PR_DELTAY);
		RETURN_PROP_CASE(PR_XPOS);
		RETURN_PROP_CASE(PR_YPOS);
		RETURN_PROP_CASE(PR_CONTROL_ID);
		RETURN_PROP_CASE(PR_INITIAL_DETAILS_PANE);
		// End <MAPItags.h>

		// Begin <edkmdb.h>
		RETURN_PROP_CASE(PR_PROFILE_VERSION);
		RETURN_PROP_CASE(PR_PROFILE_CONFIG_FLAGS);
		RETURN_PROP_CASE(PR_PROFILE_HOME_SERVER);
		RETURN_PROP_CASE(PR_PROFILE_HOME_SERVER_DN);
		RETURN_PROP_CASE(PR_PROFILE_HOME_SERVER_ADDRS);
		RETURN_PROP_CASE(PR_PROFILE_USER);
		RETURN_PROP_CASE(PR_PROFILE_CONNECT_FLAGS);
		RETURN_PROP_CASE(PR_PROFILE_TRANSPORT_FLAGS);
		RETURN_PROP_CASE(PR_PROFILE_UI_STATE);
		RETURN_PROP_CASE(PR_PROFILE_UNRESOLVED_NAME);
		RETURN_PROP_CASE(PR_PROFILE_UNRESOLVED_SERVER);
		RETURN_PROP_CASE(PR_PROFILE_BINDING_ORDER);
		RETURN_PROP_CASE(PR_PROFILE_MAX_RESTRICT);
		RETURN_PROP_CASE(PR_PROFILE_AB_FILES_PATH);
		RETURN_PROP_CASE(PR_PROFILE_OFFLINE_STORE_PATH);
		RETURN_PROP_CASE(PR_PROFILE_OFFLINE_INFO);
		RETURN_PROP_CASE(PR_PROFILE_ADDR_INFO);
		RETURN_PROP_CASE(PR_PROFILE_OPTIONS_DATA);
		RETURN_PROP_CASE(PR_PROFILE_SECURE_MAILBOX);
		RETURN_PROP_CASE(PR_DISABLE_WINSOCK);
		RETURN_PROP_CASE(PR_PROFILE_AUTH_PACKAGE);
		RETURN_PROP_CASE(PR_PROFILE_RECONNECT_INTERVAL);

		RETURN_PROP_CASE(PR_OST_ENCRYPTION);
		//RETURN_PROP_CASE(PR_PROFILE_OPEN_FLAGS);
		RETURN_PROP_CASE(PR_PROFILE_TYPE);
		RETURN_PROP_CASE(PR_PROFILE_MAILBOX);
		RETURN_PROP_CASE(PR_PROFILE_SERVER);
		RETURN_PROP_CASE(PR_PROFILE_SERVER_DN);
		RETURN_PROP_CASE(PR_PROFILE_FAVFLD_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_PROFILE_FAVFLD_COMMENT);
		RETURN_PROP_CASE(PR_PROFILE_ALLPUB_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_PROFILE_ALLPUB_COMMENT);
		RETURN_PROP_CASE(PR_PROFILE_MOAB);
		RETURN_PROP_CASE(PR_PROFILE_MOAB_GUID);
		RETURN_PROP_CASE(PR_PROFILE_MOAB_SEQ);
		RETURN_PROP_CASE(PR_GET_PROPS_EXCLUDE_PROP_ID_LIST);

		//RETURN_PROP_CASE(PR_USER_ENTRYID);
		//RETURN_PROP_CASE(PR_USER_NAME);
		RETURN_PROP_CASE(PR_MAILBOX_OWNER_ENTRYID);
		RETURN_PROP_CASE(PR_MAILBOX_OWNER_NAME);
		RETURN_PROP_CASE(PR_OOF_STATE);
		RETURN_PROP_CASE(PR_HIERARCHY_SERVER);
		RETURN_PROP_CASE(PR_SCHEDULE_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_DAF_ENTRYID);
		RETURN_PROP_CASE(PR_NON_IPM_SUBTREE_ENTRYID);
		RETURN_PROP_CASE(PR_EFORMS_REGISTRY_ENTRYID);
		RETURN_PROP_CASE(PR_SPLUS_FREE_BUSY_ENTRYID);
		RETURN_PROP_CASE(PR_OFFLINE_ADDRBOOK_ENTRYID);
		RETURN_PROP_CASE(PR_EFORMS_FOR_LOCALE_ENTRYID);
		RETURN_PROP_CASE(PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID);
		RETURN_PROP_CASE(PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID);
		RETURN_PROP_CASE(PR_NEWSGROUP_ROOT_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_OFFLINE_MESSAGE_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_FAVORITES_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_PUBLIC_FOLDERS_ENTRYID);
		RETURN_PROP_CASE(PR_FAVORITES_DEFAULT_NAME);
		RETURN_PROP_CASE(PR_SYS_CONFIG_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_NNTP_ARTICLE_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_EVENTS_ROOT_FOLDER_ENTRYID);

		RETURN_PROP_CASE(PR_GW_MTSIN_ENTRYID);
		RETURN_PROP_CASE(PR_GW_MTSOUT_ENTRYID);
		RETURN_PROP_CASE(PR_TRANSFER_ENABLED);
		RETURN_PROP_CASE(PR_TEST_LINE_SPEED);
		RETURN_PROP_CASE(PR_HIERARCHY_SYNCHRONIZER);
		RETURN_PROP_CASE(PR_CONTENTS_SYNCHRONIZER);
		RETURN_PROP_CASE(PR_COLLECTOR);
		RETURN_PROP_CASE(PR_FAST_TRANSFER);
		RETURN_PROP_CASE(PR_CHANGE_ADVISOR);
		RETURN_PROP_CASE(PR_CHANGE_NOTIFICATION_GUID);
		RETURN_PROP_CASE(PR_STORE_OFFLINE);
		//RETURN_PROP_CASE(PR_IN_TRANSIT);
		RETURN_PROP_CASE(PR_REPLICATION_STYLE);
		RETURN_PROP_CASE(PR_REPLICATION_SCHEDULE);
		RETURN_PROP_CASE(PR_REPLICATION_MESSAGE_PRIORITY);
		RETURN_PROP_CASE(PR_OVERALL_MSG_AGE_LIMIT);
		RETURN_PROP_CASE(PR_REPLICATION_ALWAYS_INTERVAL);
		RETURN_PROP_CASE(PR_REPLICATION_MSG_SIZE);
		RETURN_PROP_CASE(PR_SOURCE_KEY);
		RETURN_PROP_CASE(PR_PARENT_SOURCE_KEY);
		RETURN_PROP_CASE(PR_CHANGE_KEY);
		RETURN_PROP_CASE(PR_PREDECESSOR_CHANGE_LIST);
		RETURN_PROP_CASE(PR_FOLDER_CHILD_COUNT);
		RETURN_PROP_CASE(PR_RIGHTS);
		RETURN_PROP_CASE(PR_ACL_TABLE);
		RETURN_PROP_CASE(PR_RULES_TABLE);
		RETURN_PROP_CASE(PR_HAS_RULES);
		RETURN_PROP_CASE(PR_HAS_MODERATOR_RULES);
		RETURN_PROP_CASE(PR_ADDRESS_BOOK_ENTRYID);
		RETURN_PROP_CASE(PR_EXTENDED_ACL_DATA);

		RETURN_PROP_CASE(PR_FOLDER_DESIGN_FLAGS);
		RETURN_PROP_CASE(PR_DESIGN_IN_PROGRESS);
		RETURN_PROP_CASE(PR_SECURE_ORIGINATION);
		RETURN_PROP_CASE(PR_PUBLISH_IN_ADDRESS_BOOK);
		RETURN_PROP_CASE(PR_RESOLVE_METHOD);
		RETURN_PROP_CASE(PR_ADDRESS_BOOK_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_EFORMS_LOCALE_ID);
		RETURN_PROP_CASE(PR_REPLICA_LIST);
		RETURN_PROP_CASE(PR_OVERALL_AGE_LIMIT);
		RETURN_PROP_CASE(PR_IS_NEWSGROUP_ANCHOR);
		RETURN_PROP_CASE(PR_IS_NEWSGROUP);
		RETURN_PROP_CASE(PR_NEWSGROUP_COMPONENT);
		RETURN_PROP_CASE(PR_INTERNET_NEWSGROUP_NAME);
		RETURN_PROP_CASE(PR_NEWSFEED_INFO);
		RETURN_PROP_CASE(PR_PREVENT_MSG_CREATE);
		RETURN_PROP_CASE(PR_IMAP_INTERNAL_DATE);
		RETURN_PROP_CASE(PR_INBOUND_NEWSFEED_DN);
		RETURN_PROP_CASE(PR_OUTBOUND_NEWSFEED_DN);
		RETURN_PROP_CASE(PR_INTERNET_CHARSET);

		RETURN_PROP_CASE(PR_PUBLIC_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_HIERARCHY_CHANGE_NUM);
		RETURN_PROP_CASE(PR_HAS_NAMED_PROPERTIES);
		RETURN_PROP_CASE(PR_CREATOR_NAME);
		RETURN_PROP_CASE(PR_CREATOR_ENTRYID);
		RETURN_PROP_CASE(PR_LAST_MODIFIER_NAME);
		RETURN_PROP_CASE(PR_LAST_MODIFIER_ENTRYID);
		RETURN_PROP_CASE(PR_REPLY_RECIPIENT_SMTP_PROXIES);
		RETURN_PROP_CASE(PR_HAS_DAMS);
		RETURN_PROP_CASE(PR_RULE_TRIGGER_HISTORY);
		RETURN_PROP_CASE(PR_MOVE_TO_STORE_ENTRYID);
		RETURN_PROP_CASE(PR_MOVE_TO_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_REPLICA_SERVER);
		RETURN_PROP_CASE(PR_REPLICA_VERSION);
		RETURN_PROP_CASE(PR_DEFERRED_SEND_NUMBER);
		RETURN_PROP_CASE(PR_DEFERRED_SEND_UNITS);
		RETURN_PROP_CASE(PR_EXPIRY_NUMBER);
		RETURN_PROP_CASE(PR_EXPIRY_UNITS);
		RETURN_PROP_CASE(PR_DEFERRED_SEND_TIME);
		RETURN_PROP_CASE(PR_GW_ADMIN_OPERATIONS);
		RETURN_PROP_CASE(PR_P1_CONTENT);
		RETURN_PROP_CASE(PR_P1_CONTENT_TYPE);
		RETURN_PROP_CASE(PR_CLIENT_ACTIONS);
		RETURN_PROP_CASE(PR_DAM_ORIGINAL_ENTRYID);
		RETURN_PROP_CASE(PR_DAM_BACK_PATCHED);
		RETURN_PROP_CASE(PR_RULE_ERROR);
		RETURN_PROP_CASE(PR_RULE_ACTION_TYPE);
		RETURN_PROP_CASE(PR_RULE_ACTION_NUMBER);
		RETURN_PROP_CASE(PR_RULE_FOLDER_ENTRYID);
		RETURN_PROP_CASE(PR_ACTIVE_USER_ENTRYID);
		RETURN_PROP_CASE(PR_CONFLICT_ENTRYID);
		RETURN_PROP_CASE(PR_MESSAGE_LOCALE_ID);
		RETURN_PROP_CASE(PR_MESSAGE_CODEPAGE);
		RETURN_PROP_CASE(PR_STORAGE_QUOTA_LIMIT);
		RETURN_PROP_CASE(PR_EXCESS_STORAGE_USED);
		RETURN_PROP_CASE(PR_SVR_GENERATING_QUOTA_MSG);
		RETURN_PROP_CASE(PR_DELEGATED_BY_RULE);
		RETURN_PROP_CASE(PR_X400_ENVELOPE_TYPE);
		RETURN_PROP_CASE(PR_AUTO_RESPONSE_SUPPRESS);
		RETURN_PROP_CASE(PR_INTERNET_CPID);

		RETURN_PROP_CASE(PR_IN_CONFLICT);
		RETURN_PROP_CASE(PR_DELETED_ON);
		RETURN_PROP_CASE(PR_DELETED_MSG_COUNT);
		RETURN_PROP_CASE(PR_DELETED_ASSOC_MSG_COUNT);
		RETURN_PROP_CASE(PR_DELETED_FOLDER_COUNT);
		RETURN_PROP_CASE(PR_OLDEST_DELETED_ON);
		RETURN_PROP_CASE(PR_DELETED_MESSAGE_SIZE_EXTENDED);
		RETURN_PROP_CASE(PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED);
		RETURN_PROP_CASE(PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED);
		RETURN_PROP_CASE(PR_RETENTION_AGE_LIMIT);
		RETURN_PROP_CASE(PR_LAST_FULL_BACKUP);
		RETURN_PROP_CASE(PR_SECURE_IN_SITE);

		RETURN_PROP_CASE(PR_LONGTERM_ENTRYID_FROM_TABLE);
		RETURN_PROP_CASE(PR_ORIGINATOR_NAME);
		RETURN_PROP_CASE(PR_ORIGINATOR_ADDR);
		RETURN_PROP_CASE(PR_ORIGINATOR_ADDRTYPE);
		RETURN_PROP_CASE(PR_ORIGINATOR_ENTRYID);
		RETURN_PROP_CASE(PR_ARRIVAL_TIME);
		RETURN_PROP_CASE(PR_TRACE_INFO);
		RETURN_PROP_CASE(PR_INTERNAL_TRACE_INFO);
		RETURN_PROP_CASE(PR_SUBJECT_TRACE_INFO);
		RETURN_PROP_CASE(PR_RECIPIENT_NUMBER);
		RETURN_PROP_CASE(PR_MTS_SUBJECT_ID);
		RETURN_PROP_CASE(PR_REPORT_DESTINATION_NAME);
		RETURN_PROP_CASE(PR_REPORT_DESTINATION_ENTRYID);
		RETURN_PROP_CASE(PR_CONTENT_SEARCH_KEY);
		RETURN_PROP_CASE(PR_FOREIGN_ID);
		RETURN_PROP_CASE(PR_FOREIGN_REPORT_ID);
		RETURN_PROP_CASE(PR_FOREIGN_SUBJECT_ID);
		RETURN_PROP_CASE(PR_PROMOTE_PROP_ID_LIST);
		//RETURN_PROP_CASE(PR_MTS_ID);
		//RETURN_PROP_CASE(PR_MTS_REPORT_ID);
		RETURN_PROP_CASE(PR_MEMBER_ID);
		RETURN_PROP_CASE(PR_MEMBER_NAME);
		//RETURN_PROP_CASE(PR_MEMBER_ENTRYID);
		RETURN_PROP_CASE(PR_MEMBER_RIGHTS);
		RETURN_PROP_CASE(PR_RULE_ID);
		RETURN_PROP_CASE(PR_RULE_IDS);
		RETURN_PROP_CASE(PR_RULE_SEQUENCE);
		RETURN_PROP_CASE(PR_RULE_STATE);
		RETURN_PROP_CASE(PR_RULE_USER_FLAGS);
		RETURN_PROP_CASE(PR_RULE_CONDITION);
		RETURN_PROP_CASE(PR_RULE_ACTIONS);
		RETURN_PROP_CASE(PR_RULE_PROVIDER);
		RETURN_PROP_CASE(PR_RULE_NAME);
		RETURN_PROP_CASE(PR_RULE_LEVEL);
		RETURN_PROP_CASE(PR_RULE_PROVIDER_DATA);
		//RETURN_PROP_CASE(PR_RULE_VERSION);

		RETURN_PROP_CASE(PR_NT_USER_NAME);
		RETURN_PROP_CASE(PR_LOCALE_ID);
		RETURN_PROP_CASE(PR_LAST_LOGON_TIME);
		RETURN_PROP_CASE(PR_LAST_LOGOFF_TIME);
		RETURN_PROP_CASE(PR_STORAGE_LIMIT_INFORMATION);
		RETURN_PROP_CASE(PR_FOLDER_FLAGS);
		RETURN_PROP_CASE(PR_LAST_ACCESS_TIME);
		RETURN_PROP_CASE(PR_RESTRICTION_COUNT);
		RETURN_PROP_CASE(PR_CATEG_COUNT);
		RETURN_PROP_CASE(PR_CACHED_COLUMN_COUNT);
		RETURN_PROP_CASE(PR_NORMAL_MSG_W_ATTACH_COUNT);
		RETURN_PROP_CASE(PR_ASSOC_MSG_W_ATTACH_COUNT);
		RETURN_PROP_CASE(PR_RECIPIENT_ON_NORMAL_MSG_COUNT);
		RETURN_PROP_CASE(PR_RECIPIENT_ON_ASSOC_MSG_COUNT);
		RETURN_PROP_CASE(PR_ATTACH_ON_NORMAL_MSG_COUNT);
		RETURN_PROP_CASE(PR_ATTACH_ON_ASSOC_MSG_COUNT);
		RETURN_PROP_CASE(PR_NORMAL_MESSAGE_SIZE);
		//RETURN_PROP_CASE(PR_NORMAL_MESSAGE_SIZE_EXTENDED);
		RETURN_PROP_CASE(PR_ASSOC_MESSAGE_SIZE);
		//RETURN_PROP_CASE(PR_ASSOC_MESSAGE_SIZE_EXTENDED);
		RETURN_PROP_CASE(PR_FOLDER_PATHNAME);
		RETURN_PROP_CASE(PR_OWNER_COUNT);
		RETURN_PROP_CASE(PR_CONTACT_COUNT);
		//RETURN_PROP_CASE(PR_LOCALE_ID);
		RETURN_PROP_CASE(PR_CODE_PAGE_ID);
		RETURN_PROP_CASE(PR_SORT_LOCALE_ID);
		//RETURN_PROP_CASE(PR_MESSAGE_SIZE_EXTENDED);

		RETURN_PROP_CASE(PR_AUTO_ADD_NEW_SUBS);
		RETURN_PROP_CASE(PR_NEW_SUBS_GET_AUTO_ADD);


		RETURN_PROP_CASE(PR_OFFLINE_FLAGS);
		RETURN_PROP_CASE(PR_SYNCHRONIZE_FLAGS);
		RETURN_PROP_CASE(PR_MESSAGE_SITE_NAME);
		RETURN_PROP_CASE(PR_MESSAGE_PROCESSED);
		RETURN_PROP_CASE(PR_MSG_BODY_ID);
		RETURN_PROP_CASE(PR_BILATERAL_INFO);
		RETURN_PROP_CASE(PR_DL_REPORT_FLAGS);
		RETURN_PROP_CASE(PR_ABSTRACT);
		RETURN_PROP_CASE(PR_PREVIEW);
		RETURN_PROP_CASE(PR_PREVIEW_UNREAD);
		RETURN_PROP_CASE(PR_DISABLE_FULL_FIDELITY);
		RETURN_PROP_CASE(PR_OWA_URL);
		//End <edkmdb.h>

//		RETURN_PROP_CASE(PR_STORE_SLOWLINK);
		//<EMSAbTag.h>
		RETURN_PROP_CASE(PR_EMS_AB_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_CONTAINERID);
		RETURN_PROP_CASE(PR_EMS_AB_PARENT_ENTRYID);
		RETURN_PROP_CASE(PR_EMS_AB_IS_MASTER);
		RETURN_PROP_CASE(PR_EMS_AB_OBJECT_OID);
		RETURN_PROP_CASE(PR_EMS_AB_HIERARCHY_PATH);
		RETURN_PROP_CASE(PR_EMS_AB_CHILD_RDNS);
		RETURN_PROP_CASE(PR_EMS_AB_OTHER_RECIPS);
		//RETURN_PROP_CASE(PR_EMS_AB_DISPLAY_NAME_PRINTABLE);
		RETURN_PROP_CASE(PR_EMS_AB_ACCESS_CATEGORY);
		RETURN_PROP_CASE(PR_EMS_AB_ACTIVATION_SCHEDULE);
		RETURN_PROP_CASE(PR_EMS_AB_ACTIVATION_STYLE);
//		RETURN_PROP_CASE(PR_EMS_AB_ADC_GLOBAL_NAMES);
		RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_ENTRY_DISPLAY_TABLE);
		RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_ENTRY_DISPLAY_TABLE_MSDOS);
		RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_SYNTAX);
		RETURN_PROP_CASE(PR_EMS_AB_ADDRESS_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_ADMD);
		RETURN_PROP_CASE(PR_EMS_AB_ADMIN_DESCRIPTION);
		RETURN_PROP_CASE(PR_EMS_AB_ADMIN_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_ADMIN_EXTENSION_DLL);
		RETURN_PROP_CASE(PR_EMS_AB_ALIASED_OBJECT_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_ALT_RECIPIENT);
		RETURN_PROP_CASE(PR_EMS_AB_ALT_RECIPIENT_BL);
		RETURN_PROP_CASE(PR_EMS_AB_ANCESTOR_ID);
		//RETURN_PROP_CASE(PR_EMS_AB_ANONYMOUS_ACCESS);
		//RETURN_PROP_CASE(PR_EMS_AB_ANONYMOUS_ACCOUNT);
		RETURN_PROP_CASE(PR_EMS_AB_ASSOCIATION_LIFETIME);
		RETURN_PROP_CASE(PR_EMS_AB_ASSOC_NT_ACCOUNT);
		//RETURN_PROP_CASE(PR_EMS_AB_ASSOC_PROTOCOL_CFG_NNTP);
		RETURN_PROP_CASE(PR_EMS_AB_ASSOC_REMOTE_DXA);
//		RETURN_PROP_CASE(PR_EMS_AB_ATTRIBUTE_CERTIFICATE);
//		RETURN_PROP_CASE(PR_EMS_AB_AUTHENTICATION_TO_USE);
		RETURN_PROP_CASE(PR_EMS_AB_AUTH_ORIG_BL);
		RETURN_PROP_CASE(PR_EMS_AB_AUTHORITY_REVOCATION_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_DOMAIN);
		RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_PASSWORD);
//		RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_PASSWORD_CONFIRM);
		RETURN_PROP_CASE(PR_EMS_AB_AUTHORIZED_USER);
		RETURN_PROP_CASE(PR_EMS_AB_AUTOREPLY);
		RETURN_PROP_CASE(PR_EMS_AB_AUTOREPLY_MESSAGE);
		RETURN_PROP_CASE(PR_EMS_AB_AUTOREPLY_SUBJECT);
//		RETURN_PROP_CASE(PR_EMS_AB_AVAILABLE_AUTHORIZATION_PACKAGES);
//		RETURN_PROP_CASE(PR_EMS_AB_AVAILABLE_DISTRIBUTIONS);
		RETURN_PROP_CASE(PR_EMS_AB_BRIDGEHEAD_SERVERS);
		RETURN_PROP_CASE(PR_EMS_AB_BUSINESS_CATEGORY);
		RETURN_PROP_CASE(PR_EMS_AB_BUSINESS_ROLES);
		RETURN_PROP_CASE(PR_EMS_AB_CA_CERTIFICATE);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF_BL);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF_DL);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_CREATE_PF_DL_BL);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF_BL);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF_DL);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_NOT_CREATE_PF_DL_BL);
		RETURN_PROP_CASE(PR_EMS_AB_CAN_PRESERVE_DNS);
/*		RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_CHAIN_V3);
		RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_REVOCATION_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_REVOCATION_LIST_V1);
		RETURN_PROP_CASE(PR_EMS_AB_CERTIFICATE_REVOCATION_LIST_V3);
		RETURN_PROP_CASE(PR_EMS_AB_CHARACTER_SET);
		RETURN_PROP_CASE(PR_EMS_AB_CHARACTER_SET_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_CLIENT_ACCESS_ENABLED);
		RETURN_PROP_CASE(PR_EMS_AB_CLOCK_ALERT_OFFSET);
		RETURN_PROP_CASE(PR_EMS_AB_CLOCK_ALERT_REPAIR);
		RETURN_PROP_CASE(PR_EMS_AB_CLOCK_WARNING_OFFSET);
		RETURN_PROP_CASE(PR_EMS_AB_CLOCK_WARNING_REPAIR);
		RETURN_PROP_CASE(PR_EMS_AB_COMPROMISED_KEY_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_COMPUTER_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_CONNECTED_DOMAINS);
		RETURN_PROP_CASE(PR_EMS_AB_CONNECTION_LIST_FILTER);
		RETURN_PROP_CASE(PR_EMS_AB_CONNECTION_LIST_FILTER_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_CONNECTION_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_CONTAINER_INFO);
		RETURN_PROP_CASE(PR_EMS_AB_CONTENT_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_CONTROL_MSG_FOLDER_ID);
		RETURN_PROP_CASE(PR_EMS_AB_CONTROL_MSG_RULES);
		RETURN_PROP_CASE(PR_EMS_AB_COST);
		RETURN_PROP_CASE(PR_EMS_AB_COUNTRY_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_CROSS_CERTIFICATE_CRL);
		RETURN_PROP_CASE(PR_EMS_AB_CROSS_CERTIFICATE_PAIR);
		RETURN_PROP_CASE(PR_EMS_AB_DEFAULT_MESSAGE_FORMAT);
		RETURN_PROP_CASE(PR_EMS_AB_DELEGATE_USER);
		RETURN_PROP_CASE(PR_EMS_AB_DELIV_CONT_LENGTH);
		RETURN_PROP_CASE(PR_EMS_AB_DELIV_EITS);
		RETURN_PROP_CASE(PR_EMS_AB_DELIVER_AND_REDIRECT);
		RETURN_PROP_CASE(PR_EMS_AB_DELIVERY_MECHANISM);
		RETURN_PROP_CASE(PR_EMS_AB_DELIV_EXT_CONT_TYPES);
		RETURN_PROP_CASE(PR_EMS_AB_DELTA_REVOCATION_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_DESCRIPTION);
		RETURN_PROP_CASE(PR_EMS_AB_DESTINATION_INDICATOR);
		RETURN_PROP_CASE(PR_EMS_AB_DIAGNOSTIC_REG_KEY);
		RETURN_PROP_CASE(PR_EMS_AB_DISABLE_DEFERRED_COMMIT);
		RETURN_PROP_CASE(PR_EMS_AB_DISABLED_GATEWAY_PROXY);
		RETURN_PROP_CASE(PR_EMS_AB_DISPLAY_NAME_OVERRIDE);
		RETURN_PROP_CASE(PR_EMS_AB_DISPLAY_NAME_SUFFIX);
		RETURN_PROP_CASE(PR_EMS_AB_DL_MEMBER_RULE);
		RETURN_PROP_CASE(PR_EMS_AB_DL_MEM_REJECT_PERMS_BL);
		RETURN_PROP_CASE(PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL);
		RETURN_PROP_CASE(PR_EMS_AB_DMD_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_DOMAIN_DEF_ALT_RECIP);
		RETURN_PROP_CASE(PR_EMS_AB_DOMAIN_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_DO_OAB_VERSION);
		RETURN_PROP_CASE(PR_EMS_AB_DSA_SIGNATURE);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_ADMIN_COPY);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_ADMIN_FORWARD);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_ADMIN_UPDATE);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_APPEND_REQCN);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_CONTAINER_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_CONTAINER_LIST_BL);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_CONTAINER_LIST_LINKED);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_REQ_TIME);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_SEQ);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_CONF_SEQ_USN);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_EXCHANGE_OPTIONS);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_EXPORT_NOW);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_FLAGS);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_IMPORT_NOW);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_IMP_SEQ);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_IMP_SEQ_TIME);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_IMP_SEQ_USN);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_IN_TEMPLATE_MAP);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_LOCAL_ADMIN);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_LOGGING_LEVEL);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_NATIVE_ADDRESS_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_OUT_TEMPLATE_MAP);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PASSWORD);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_EXCHANGE_OPTIONS);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_EXPORT_NATIVE_ONLY);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_IN_EXCHANGE_SENSITIVITY);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_REMOTE_ENTRIES);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_REPLICATION_SENSITIVITY);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_TEMPLATE_OPTIONS);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_PREV_TYPES);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_RECIPIENT_CP);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_REMOTE_CLIENT);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_REQNAME);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_REQ_SEQ);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_REQ_SEQ_TIME);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_REQ_SEQ_USN);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_SVR_SEQ);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_SVR_SEQ_TIME);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_SVR_SEQ_USN);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_TASK);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_TEMPLATE_OPTIONS);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_TEMPLATE_TIMESTAMP);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_TYPES);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_BL);
		RETURN_PROP_CASE(PR_EMS_AB_DXA_UNCONF_CONTAINER_LIST_LINKED);
		RETURN_PROP_CASE(PR_EMS_AB_EMPLOYEE_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_EMPLOYEE_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_ENABLE_COMPATIBILITY);
		RETURN_PROP_CASE(PR_EMS_AB_ENABLED);
		RETURN_PROP_CASE(PR_EMS_AB_ENABLED_AUTHORIZATION_PACKAGES);
		RETURN_PROP_CASE(PR_EMS_AB_ENABLED_PROTOCOL_CFG);
		RETURN_PROP_CASE(PR_EMS_AB_ENABLED_PROTOCOLS);
		RETURN_PROP_CASE(PR_EMS_AB_ENCAPSULATION_METHOD);
		RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT);
		RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_LIST_NA);
		RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_LIST_OTHER);
		RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_SELECTED_NA);
		RETURN_PROP_CASE(PR_EMS_AB_ENCRYPT_ALG_SELECTED_OTHER);
		RETURN_PROP_CASE(PR_EMS_AB_EXPAND_DLS_LOCALLY);
		RETURN_PROP_CASE(PR_EMS_AB_EXPIRATION_TIME);
		RETURN_PROP_CASE(PR_EMS_AB_EXPORT_CONTAINERS);
		RETURN_PROP_CASE(PR_EMS_AB_EXPORT_CUSTOM_RECIPIENTS);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENDED_CHARS_ALLOWED);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_1);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_10);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_11);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_12);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_13);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_14);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_15);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_2);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_3);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_4);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_5);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_6);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_7);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_8);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_ATTRIBUTE_9);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_DATA);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_EXTENSION_NAME_INHERITED);
		RETURN_PROP_CASE(PR_EMS_AB_FACSIMILE_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_FILE_VERSION);
		RETURN_PROP_CASE(PR_EMS_AB_FILTER_LOCAL_ADDRESSES);
		RETURN_PROP_CASE(PR_EMS_AB_FOLDER_PATHNAME);
		RETURN_PROP_CASE(PR_EMS_AB_FOLDERS_CONTAINER);
		RETURN_PROP_CASE(PR_EMS_AB_FORM_DATA);
//		RETURN_PROP_CASE(PR_EMS_AB_FORWARDING_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_GARBAGE_COLL_PERIOD);
		RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_LOCAL_CRED);
		RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_LOCAL_DESIG);
		RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_PROXY);
		RETURN_PROP_CASE(PR_EMS_AB_GATEWAY_ROUTING_TREE);
//		RETURN_PROP_CASE(PR_EMS_AB_GENERATION_QUALIFIER);
//		RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_1);
//		RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_2);
//		RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_3);
//		RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_4);
//		RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_VALUE_DN);
///		RETURN_PROP_CASE(PR_EMS_AB_GROUP_BY_ATTR_VALUE_STR);
		RETURN_PROP_CASE(PR_EMS_AB_GWART_LAST_MODIFIED);
		RETURN_PROP_CASE(PR_EMS_AB_HAS_FULL_REPLICA_NCS);
		RETURN_PROP_CASE(PR_EMS_AB_HAS_MASTER_NCS);
		RETURN_PROP_CASE(PR_EMS_AB_HELP_DATA16);
		RETURN_PROP_CASE(PR_EMS_AB_HELP_DATA32);
		RETURN_PROP_CASE(PR_EMS_AB_HELP_FILE_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_HEURISTICS);
		RETURN_PROP_CASE(PR_EMS_AB_HIDE_DL_MEMBERSHIP);
		RETURN_PROP_CASE(PR_EMS_AB_HIDE_FROM_ADDRESS_BOOK);
		RETURN_PROP_CASE(PR_EMS_AB_HOME_MDB);
		RETURN_PROP_CASE(PR_EMS_AB_HOME_MDB_BL);
		RETURN_PROP_CASE(PR_EMS_AB_HOME_MTA);
		RETURN_PROP_CASE(PR_EMS_AB_HOME_PUBLIC_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_HOUSE_IDENTIFIER);
		RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_AB_ATTRIBUTES);
		RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_GAL);
		RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_GAL_LIMIT);
		RETURN_PROP_CASE(PR_EMS_AB_HTTP_PUB_PF);
		RETURN_PROP_CASE(PR_EMS_AB_HTTP_SERVERS);
		RETURN_PROP_CASE(PR_EMS_AB_IMPORT_CONTAINER);
		RETURN_PROP_CASE(PR_EMS_AB_IMPORTED_FROM);
		RETURN_PROP_CASE(PR_EMS_AB_IMPORT_SENSITIVITY);
		RETURN_PROP_CASE(PR_EMS_AB_INBOUND_ACCEPT_ALL);
		RETURN_PROP_CASE(PR_EMS_AB_INBOUND_DN);
		RETURN_PROP_CASE(PR_EMS_AB_INBOUND_HOST);
		RETURN_PROP_CASE(PR_EMS_AB_INBOUND_NEWSFEED);
		RETURN_PROP_CASE(PR_EMS_AB_INBOUND_NEWSFEED_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_INBOUND_SITES);
		RETURN_PROP_CASE(PR_EMS_AB_INCOMING_MSG_SIZE_LIMIT);
		RETURN_PROP_CASE(PR_EMS_AB_INCOMING_PASSWORD);
		RETURN_PROP_CASE(PR_EMS_AB_INSADMIN);
		RETURN_PROP_CASE(PR_EMS_AB_INSTANCE_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_INTERNATIONAL_ISDN_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_INVOCATION_ID);
		RETURN_PROP_CASE(PR_EMS_AB_IS_DELETED);
		RETURN_PROP_CASE(PR_EMS_AB_IS_MEMBER_OF_DL);
		RETURN_PROP_CASE(PR_EMS_AB_IS_SINGLE_VALUED);
		RETURN_PROP_CASE(PR_EMS_AB_KCC_STATUS);
		RETURN_PROP_CASE(PR_EMS_AB_KM_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_KNOWLEDGE_INFORMATION);
		RETURN_PROP_CASE(PR_EMS_AB_LABELEDURI);
		RETURN_PROP_CASE(PR_EMS_AB_LANGUAGE);
		RETURN_PROP_CASE(PR_EMS_AB_LANGUAGE_ISO639);
		RETURN_PROP_CASE(PR_EMS_AB_LDAP_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_LDAP_SEARCH_CFG);
		RETURN_PROP_CASE(PR_EMS_AB_LINE_WRAP);
		RETURN_PROP_CASE(PR_EMS_AB_LINK_ID);
		RETURN_PROP_CASE(PR_EMS_AB_LIST_PUBLIC_FOLDERS);
		RETURN_PROP_CASE(PR_EMS_AB_LOCAL_BRIDGE_HEAD);
		RETURN_PROP_CASE(PR_EMS_AB_LOCAL_BRIDGE_HEAD_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_LOCAL_INITIAL_TURN);
		RETURN_PROP_CASE(PR_EMS_AB_LOCAL_SCOPE);
		RETURN_PROP_CASE(PR_EMS_AB_LOG_FILENAME);
		RETURN_PROP_CASE(PR_EMS_AB_LOG_ROLLOVER_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_MAIL_DROP);
		RETURN_PROP_CASE(PR_EMS_AB_MAINTAIN_AUTOREPLY_HISTORY);
		RETURN_PROP_CASE(PR_EMS_AB_MANAGER);
		RETURN_PROP_CASE(PR_EMS_AB_MAPI_DISPLAY_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_MAPI_ID);
		RETURN_PROP_CASE(PR_EMS_AB_MAXIMUM_OBJECT_ID);
		RETURN_PROP_CASE(PR_EMS_AB_MDB_BACKOFF_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_MDB_MSG_TIME_OUT_PERIOD);
		RETURN_PROP_CASE(PR_EMS_AB_MDB_OVER_QUOTA_LIMIT);
		RETURN_PROP_CASE(PR_EMS_AB_MDB_STORAGE_QUOTA);
		RETURN_PROP_CASE(PR_EMS_AB_MDB_UNREAD_LIMIT);
		RETURN_PROP_CASE(PR_EMS_AB_MDB_USE_DEFAULTS);
		RETURN_PROP_CASE(PR_EMS_AB_MEMBER);
		RETURN_PROP_CASE(PR_EMS_AB_MESSAGE_TRACKING_ENABLED);
		RETURN_PROP_CASE(PR_EMS_AB_MIME_TYPES);
		RETURN_PROP_CASE(PR_EMS_AB_MODERATED);
		RETURN_PROP_CASE(PR_EMS_AB_MODERATOR);
		RETURN_PROP_CASE(PR_EMS_AB_MONITOR_CLOCK);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORED_CONFIGURATIONS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORED_SERVERS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORED_SERVICES);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_ALERT_DELAY);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_ALERT_UNITS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_AVAILABILITY_STYLE);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_AVAILABILITY_WINDOW);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_CACHED_VIA_MAIL);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_CACHED_VIA_RPC);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_ESCALATION_PROCEDURE);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_HOTSITE_POLL_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_HOTSITE_POLL_UNITS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_MAIL_UPDATE_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_MAIL_UPDATE_UNITS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_NORMAL_POLL_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_NORMAL_POLL_UNITS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RECIPIENTS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RECIPIENTS_NDR);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RPC_UPDATE_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_RPC_UPDATE_UNITS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_WARNING_DELAY);
		RETURN_PROP_CASE(PR_EMS_AB_MONITORING_WARNING_UNITS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITOR_SERVERS);
		RETURN_PROP_CASE(PR_EMS_AB_MONITOR_SERVICES);
		RETURN_PROP_CASE(PR_EMS_AB_MTA_LOCAL_CRED);
		RETURN_PROP_CASE(PR_EMS_AB_MTA_LOCAL_DESIG);
		RETURN_PROP_CASE(PR_EMS_AB_N_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_N_ADDRESS_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_NETWORK_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_NEWSFEED_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_NEWSGROUP);
		RETURN_PROP_CASE(PR_EMS_AB_NEWSGROUP_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_NNTP_CHARACTER_SET);
		RETURN_PROP_CASE(PR_EMS_AB_NNTP_CONTENT_FORMAT);
		RETURN_PROP_CASE(PR_EMS_AB_NNTP_DISTRIBUTIONS);
		RETURN_PROP_CASE(PR_EMS_AB_NNTP_DISTRIBUTIONS_FLAG);
		RETURN_PROP_CASE(PR_EMS_AB_NNTP_NEWSFEEDS);
		RETURN_PROP_CASE(PR_EMS_AB_NT_MACHINE_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_NT_SECURITY_DESCRIPTOR);
		RETURN_PROP_CASE(PR_EMS_AB_NUM_OF_OPEN_RETRIES);
		RETURN_PROP_CASE(PR_EMS_AB_NUM_OF_TRANSFER_RETRIES);
		RETURN_PROP_CASE(PR_EMS_AB_OBJ_DIST_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_OBJECT_CLASS_CATEGORY);
		RETURN_PROP_CASE(PR_EMS_AB_OBJECT_GUID);
		RETURN_PROP_CASE(PR_EMS_AB_OBJECT_VERSION);
		RETURN_PROP_CASE(PR_EMS_AB_OBJ_VIEW_CONTAINERS);
		RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_CONTAINERS);
		RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_SCHEDULE);
		RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_OFF_LINE_AB_STYLE);
		RETURN_PROP_CASE(PR_EMS_AB_OID_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_OM_OBJECT_CLASS);
		RETURN_PROP_CASE(PR_EMS_AB_OM_SYNTAX);
		RETURN_PROP_CASE(PR_EMS_AB_OOF_REPLY_TO_ORIGINATOR);
		RETURN_PROP_CASE(PR_EMS_AB_OPEN_RETRY_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_ORGANIZATIONAL_UNIT_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_ORGANIZATION_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_ORIGINAL_DISPLAY_TABLE);
		RETURN_PROP_CASE(PR_EMS_AB_ORIGINAL_DISPLAY_TABLE_MSDOS);
		RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_HOST);
		RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_HOST_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_NEWSFEED);
		RETURN_PROP_CASE(PR_EMS_AB_OUTBOUND_SITES);
		RETURN_PROP_CASE(PR_EMS_AB_OUTGOING_MSG_SIZE_LIMIT);
		RETURN_PROP_CASE(PR_EMS_AB_OVERRIDE_NNTP_CONTENT_FORMAT);
		RETURN_PROP_CASE(PR_EMS_AB_OWA_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_OWNER);
		RETURN_PROP_CASE(PR_EMS_AB_OWNER_BL);
		RETURN_PROP_CASE(PR_EMS_AB_PERIOD_REPL_STAGGER);
		RETURN_PROP_CASE(PR_EMS_AB_PERIOD_REP_SYNC_TIMES);
		RETURN_PROP_CASE(PR_EMS_AB_PER_MSG_DIALOG_DISPLAY_TABLE);
		RETURN_PROP_CASE(PR_EMS_AB_PER_RECIP_DIALOG_DISPLAY_TABLE);
		RETURN_PROP_CASE(PR_EMS_AB_PERSONAL_TITLE);
		RETURN_PROP_CASE(PR_EMS_AB_PF_CONTACTS);
		RETURN_PROP_CASE(PR_EMS_AB_POP_CHARACTER_SET);
		RETURN_PROP_CASE(PR_EMS_AB_POP_CONTENT_FORMAT);
		RETURN_PROP_CASE(PR_EMS_AB_PORT_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_POSTAL_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_PREFERRED_DELIVERY_METHOD);
		RETURN_PROP_CASE(PR_EMS_AB_PRESERVE_INTERNET_CONTENT);
		RETURN_PROP_CASE(PR_EMS_AB_PRMD);
		RETURN_PROP_CASE(PR_EMS_AB_PROMO_EXPIRATION);
		RETURN_PROP_CASE(PR_EMS_AB_PROTOCOL_SETTINGS);
		RETURN_PROP_CASE(PR_EMS_AB_PROXY_ADDRESSES);
		RETURN_PROP_CASE(PR_EMS_AB_PROXY_GENERATION_ENABLED);
		RETURN_PROP_CASE(PR_EMS_AB_PROXY_GENERATOR_DLL);
		RETURN_PROP_CASE(PR_EMS_AB_P_SELECTOR);
		RETURN_PROP_CASE(PR_EMS_AB_P_SELECTOR_INBOUND);
		RETURN_PROP_CASE(PR_EMS_AB_PUBLIC_DELEGATES);
		RETURN_PROP_CASE(PR_EMS_AB_PUBLIC_DELEGATES_BL);
		RETURN_PROP_CASE(PR_EMS_AB_QUOTA_NOTIFICATION_SCHEDULE);
		RETURN_PROP_CASE(PR_EMS_AB_QUOTA_NOTIFICATION_STYLE);
		RETURN_PROP_CASE(PR_EMS_AB_RANGE_LOWER);
		RETURN_PROP_CASE(PR_EMS_AB_RANGE_UPPER);
		RETURN_PROP_CASE(PR_EMS_AB_RAS_ACCOUNT);
		RETURN_PROP_CASE(PR_EMS_AB_RAS_CALLBACK_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_RAS_PASSWORD);
		RETURN_PROP_CASE(PR_EMS_AB_RAS_PHONEBOOK_ENTRY_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_RAS_PHONE_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_RAS_REMOTE_SRVR_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_REFERRAL_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_REGISTERED_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_REMOTE_BRIDGE_HEAD);
		RETURN_PROP_CASE(PR_EMS_AB_REMOTE_BRIDGE_HEAD_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_REMOTE_OUT_BH_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_REMOTE_SITE);
		RETURN_PROP_CASE(PR_EMS_AB_REPLICATED_OBJECT_VERSION);
		RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_MAIL_MSG_SIZE);
		RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_SENSITIVITY);
		RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_SIGNATURE);
		RETURN_PROP_CASE(PR_EMS_AB_REPLICATION_STAGGER);
		RETURN_PROP_CASE(PR_EMS_AB_REPORTS);
		RETURN_PROP_CASE(PR_EMS_AB_REPORT_TO_ORIGINATOR);
		RETURN_PROP_CASE(PR_EMS_AB_REPORT_TO_OWNER);
		RETURN_PROP_CASE(PR_EMS_AB_REQ_SEQ);
		RETURN_PROP_CASE(PR_EMS_AB_REQUIRE_SSL);
		RETURN_PROP_CASE(PR_EMS_AB_RESPONSIBLE_LOCAL_DXA);
		RETURN_PROP_CASE(PR_EMS_AB_RETURN_EXACT_MSG_SIZE);
		RETURN_PROP_CASE(PR_EMS_AB_RID_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_ROLE_OCCUPANT);
		RETURN_PROP_CASE(PR_EMS_AB_ROOT_NEWSGROUPS_FOLDER_ID);
		RETURN_PROP_CASE(PR_EMS_AB_ROUTING_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_RTS_CHECKPOINT_SIZE);
		RETURN_PROP_CASE(PR_EMS_AB_RTS_RECOVERY_TIMEOUT);
		RETURN_PROP_CASE(PR_EMS_AB_RTS_WINDOW_SIZE);
		RETURN_PROP_CASE(PR_EMS_AB_RUNS_ON);
		RETURN_PROP_CASE(PR_EMS_AB_SCHEMA_FLAGS);
		RETURN_PROP_CASE(PR_EMS_AB_SCHEMA_VERSION);
		RETURN_PROP_CASE(PR_EMS_AB_SEARCH_FLAGS);
		RETURN_PROP_CASE(PR_EMS_AB_SEARCH_GUIDE);
		RETURN_PROP_CASE(PR_EMS_AB_SECURITY_POLICY);
		RETURN_PROP_CASE(PR_EMS_AB_SECURITY_PROTOCOL);
		RETURN_PROP_CASE(PR_EMS_AB_SEE_ALSO);
		RETURN_PROP_CASE(PR_EMS_AB_SEND_EMAIL_MESSAGE);
		RETURN_PROP_CASE(PR_EMS_AB_SEND_TNEF);
		RETURN_PROP_CASE(PR_EMS_AB_SERIAL_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_SERVICE_ACTION_FIRST);
		RETURN_PROP_CASE(PR_EMS_AB_SERVICE_ACTION_OTHER);
		RETURN_PROP_CASE(PR_EMS_AB_SERVICE_ACTION_SECOND);
		RETURN_PROP_CASE(PR_EMS_AB_SERVICE_RESTART_DELAY);
		RETURN_PROP_CASE(PR_EMS_AB_SERVICE_RESTART_MESSAGE);
		RETURN_PROP_CASE(PR_EMS_AB_SESSION_DISCONNECT_TIMER);
		RETURN_PROP_CASE(PR_EMS_AB_SITE_AFFINITY);
		RETURN_PROP_CASE(PR_EMS_AB_SITE_FOLDER_GUID);
		RETURN_PROP_CASE(PR_EMS_AB_SITE_FOLDER_SERVER);
		RETURN_PROP_CASE(PR_EMS_AB_SITE_PROXY_SPACE);
		RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_LIST_NA);
		RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_LIST_OTHER);
		RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_SELECTED_NA);
		RETURN_PROP_CASE(PR_EMS_AB_SMIME_ALG_SELECTED_OTHER);
		RETURN_PROP_CASE(PR_EMS_AB_SPACE_LAST_COMPUTED);
		RETURN_PROP_CASE(PR_EMS_AB_S_SELECTOR);
		RETURN_PROP_CASE(PR_EMS_AB_S_SELECTOR_INBOUND);
		RETURN_PROP_CASE(PR_EMS_AB_STREET_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_SUBMISSION_CONT_LENGTH);
		RETURN_PROP_CASE(PR_EMS_AB_SUB_REFS);
		RETURN_PROP_CASE(PR_EMS_AB_SUB_SITE);
		RETURN_PROP_CASE(PR_EMS_AB_SUPPORTED_ALGORITHMS);
		RETURN_PROP_CASE(PR_EMS_AB_SUPPORTED_APPLICATION_CONTEXT);
		RETURN_PROP_CASE(PR_EMS_AB_SUPPORTING_STACK);
		RETURN_PROP_CASE(PR_EMS_AB_SUPPORTING_STACK_BL);
		RETURN_PROP_CASE(PR_EMS_AB_SUPPORT_SMIME_SIGNATURES);
		RETURN_PROP_CASE(PR_EMS_AB_TARGET_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_TARGET_MTAS);
		RETURN_PROP_CASE(PR_EMS_AB_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_EMS_AB_TELEPHONE_PERSONAL_PAGER);
		RETURN_PROP_CASE(PR_EMS_AB_TELETEX_TERMINAL_IDENTIFIER);
		RETURN_PROP_CASE(PR_EMS_AB_TEMP_ASSOC_THRESHOLD);
		RETURN_PROP_CASE(PR_EMS_AB_TOMBSTONE_LIFETIME);
		RETURN_PROP_CASE(PR_EMS_AB_TRACKING_LOG_PATH_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_RETRY_INTERVAL);
		RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_TIMEOUT_NON_URGENT);
		RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_TIMEOUT_NORMAL);
		RETURN_PROP_CASE(PR_EMS_AB_TRANSFER_TIMEOUT_URGENT);
		RETURN_PROP_CASE(PR_EMS_AB_TRANSLATION_TABLE_USED);
		RETURN_PROP_CASE(PR_EMS_AB_TRANSPORT_EXPEDITED_DATA);
		RETURN_PROP_CASE(PR_EMS_AB_TRANS_RETRY_MINS);
		RETURN_PROP_CASE(PR_EMS_AB_TRANS_TIMEOUT_MINS);
		RETURN_PROP_CASE(PR_EMS_AB_TRUST_LEVEL);
		RETURN_PROP_CASE(PR_EMS_AB_T_SELECTOR);
		RETURN_PROP_CASE(PR_EMS_AB_T_SELECTOR_INBOUND);
		RETURN_PROP_CASE(PR_EMS_AB_TURN_REQUEST_THRESHOLD);
		RETURN_PROP_CASE(PR_EMS_AB_TWO_WAY_ALTERNATE_FACILITY);
		RETURN_PROP_CASE(PR_EMS_AB_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_UNAUTH_ORIG_BL);
		RETURN_PROP_CASE(PR_EMS_AB_UNMERGED_ATTRIBUTES);
		RETURN_PROP_CASE(PR_EMS_AB_USENET_SITE_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_USER_PASSWORD);
		RETURN_PROP_CASE(PR_EMS_AB_USE_SERVER_VALUES);
		RETURN_PROP_CASE(PR_EMS_AB_USE_SITE_VALUES);
		RETURN_PROP_CASE(PR_EMS_AB_USN_CHANGED);
		RETURN_PROP_CASE(PR_EMS_AB_USN_CREATED);
		RETURN_PROP_CASE(PR_EMS_AB_USN_DSA_LAST_OBJ_REMOVED);
		RETURN_PROP_CASE(PR_EMS_AB_USN_INTERSITE);
		RETURN_PROP_CASE(PR_EMS_AB_USN_LAST_OBJ_REM);
		RETURN_PROP_CASE(PR_EMS_AB_USN_SOURCE);
		RETURN_PROP_CASE(PR_EMS_AB_VIEW_CONTAINER_1);
		RETURN_PROP_CASE(PR_EMS_AB_VIEW_CONTAINER_2);
		RETURN_PROP_CASE(PR_EMS_AB_VIEW_CONTAINER_3);
		RETURN_PROP_CASE(PR_EMS_AB_VIEW_DEFINITION);
		RETURN_PROP_CASE(PR_EMS_AB_VIEW_FLAGS);
		RETURN_PROP_CASE(PR_EMS_AB_VIEW_SITE);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_FLAGS);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_GREETINGS);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_PASSWORD);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_RECORDED_NAME);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_RECORDING_LENGTH);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_SPEED);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_SYSTEM_GUID);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_USER_ID);
		RETURN_PROP_CASE(PR_EMS_AB_VOICE_MAIL_VOLUME);
		RETURN_PROP_CASE(PR_EMS_AB_WWW_HOME_PAGE);
		RETURN_PROP_CASE(PR_EMS_AB_X121_ADDRESS);
		RETURN_PROP_CASE(PR_EMS_AB_X25_CALL_USER_DATA_INCOMING);
		RETURN_PROP_CASE(PR_EMS_AB_X25_CALL_USER_DATA_OUTGOING);
		RETURN_PROP_CASE(PR_EMS_AB_X25_FACILITIES_DATA_INCOMING);
		RETURN_PROP_CASE(PR_EMS_AB_X25_FACILITIES_DATA_OUTGOING);
		RETURN_PROP_CASE(PR_EMS_AB_X25_LEASED_LINE_PORT);
		RETURN_PROP_CASE(PR_EMS_AB_X25_LEASED_OR_SWITCHED);
		RETURN_PROP_CASE(PR_EMS_AB_X25_REMOTE_MTA_PHONE);
		RETURN_PROP_CASE(PR_EMS_AB_X400_ATTACHMENT_TYPE);
		RETURN_PROP_CASE(PR_EMS_AB_X400_SELECTOR_SYNTAX);
		RETURN_PROP_CASE(PR_EMS_AB_X500_ACCESS_CONTROL_LIST);
		RETURN_PROP_CASE(PR_EMS_AB_X500_NC);
		RETURN_PROP_CASE(PR_EMS_AB_X500_RDN);
		RETURN_PROP_CASE(PR_EMS_AB_X509_CERT);
		RETURN_PROP_CASE(PR_EMS_AB_XMIT_TIMEOUT_NON_URGENT);
		RETURN_PROP_CASE(PR_EMS_AB_XMIT_TIMEOUT_NORMAL);
		RETURN_PROP_CASE(PR_EMS_AB_XMIT_TIMEOUT_URGENT);
		//End <EMSAbTag.h>
*/
		RETURN_PROP_CASE(PR_EMS_AB_ROOM_CAPACITY);
		RETURN_PROP_CASE(PR_EMS_AB_ROOM_DESCRIPTION);
/*		
		//<MSPST.h>
		RETURN_PROP_CASE(PR_PST_PATH);
		RETURN_PROP_CASE(PR_PST_REMEMBER_PW);
		//RETURN_PROP_CASE(PR_PST_ENCRYPTION);
		RETURN_PROP_CASE(PR_PST_PW_SZ_OLD);
		RETURN_PROP_CASE(PR_PST_PW_SZ_NEW);
		
		//End <MSPST.h>

		//CDO props (listed as constants in CDO, but not in MAPI headers
		//Note: commented out props are in MAPI headers under other names
//		RETURN_PROP_CASE(PR_ATTACH_DATA_BIN);
//		RETURN_PROP_CASE(PR_BEEPER_TELEPHONE_NUMBER);
//		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_CITY);
//		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_COUNTRY);
//		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_POST_OFFICE_BOX);
//		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_POSTAL_CODE);
//		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE);
//		RETURN_PROP_CASE(PR_BUSINESS_ADDRESS_STREET);
//		RETURN_PROP_CASE(PR_CELLULAR_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_INTERNET_APPROVED);
		RETURN_PROP_CASE(PR_INTERNET_CONTROL);
		RETURN_PROP_CASE(PR_INTERNET_DISTRIBUTION);
		RETURN_PROP_CASE(PR_INTERNET_FOLLOWUP_TO);
		RETURN_PROP_CASE(PR_INTERNET_LINES);
//		RETURN_PROP_CASE(PR_INTERNET_NEWSGROUPS);
		RETURN_PROP_CASE(PR_INTERNET_NNTP_PATH);
		RETURN_PROP_CASE(PR_INTERNET_ORGANIZATION);
		RETURN_PROP_CASE(PR_INTERNET_PRECEDENCE);
		RETURN_PROP_CASE(PR_INTERNET_REFERENCES);
		RETURN_PROP_CASE(PR_NEWSGROUP_NAME);
		RETURN_PROP_CASE(PR_NNTP_XREF);
//		RETURN_PROP_CASE(PR_OFFICE_TELEPHONE_NUMBER);
//		RETURN_PROP_CASE(PR_OFFICE2_TELEPHONE_NUMBER);
		RETURN_PROP_CASE(PR_POST_FOLDER_ENTRIES);
		RETURN_PROP_CASE(PR_POST_FOLDER_NAMES);
		RETURN_PROP_CASE(PR_POST_REPLY_DENIED);
		RETURN_PROP_CASE(PR_POST_REPLY_FOLDER_ENTRIES);
		RETURN_PROP_CASE(PR_POST_REPLY_FOLDER_NAMES);
//		RETURN_PROP_CASE(PR_REFERRED_BY_NAME);//this is PR_PREFERRED_BY_NAME - typo in CDO?
		RETURN_PROP_CASE(PR_SUPERSEDES);
*/
		//End CDO props

		//Properties I've defined because they're missing from the headers.
		// Begin <mapiext.h>
		RETURN_PROP_CASE(PR_USER_X509_CERTIFICATE);
		RETURN_PROP_CASE(PR_ADMIN_SECURITY_DESCRIPTOR);
		RETURN_PROP_CASE(PR_NT_SECURITY_DESCRIPTOR);
		RETURN_PROP_CASE(PR_BODY_HTML);
		RETURN_PROP_CASE(PR_MSG_EDITOR_FORMAT);
		RETURN_PROP_CASE(PR_INTERNET_MESSAGE_ID);
		RETURN_PROP_CASE(PR_SMTP_ADDRESS);
		RETURN_PROP_CASE(PR_DEF_POST_MSGCLASS);
		RETURN_PROP_CASE(PR_DEF_POST_DISPLAYNAME);
		RETURN_PROP_CASE(PR_INTERNET_ARTICLE_NUMBER);
		RETURN_PROP_CASE(PR_FREEBUSY_ENTRYIDS);
		RETURN_PROP_CASE(PR_INTERNET_CONTENT);

		RETURN_PROP_CASE(PR_PACKED_NAME_PROPS);

		RETURN_PROP_CASE(PR_ADDITIONAL_REN_ENTRYIDS);
		RETURN_PROP_CASE(PR_IPM_APPOINTMENT_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_CONTACT_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_JOURNAL_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_NOTE_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_TASK_ENTRYID);
		RETURN_PROP_CASE(PR_REM_ONLINE_ENTRYID);
		RETURN_PROP_CASE(PR_REM_OFFLINE_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_DRAFTS_ENTRYID);
		RETURN_PROP_CASE(PR_IPM_OL2007_ENTRYIDS);
//Freebusytags.h
		RETURN_PROP_CASE(PR_FREEBUSY_ALL_EVENTS);
		RETURN_PROP_CASE(PR_FREEBUSY_ALL_MONTHS);
		RETURN_PROP_CASE(PR_FREEBUSY_BUSY_EVENTS);
		RETURN_PROP_CASE(PR_FREEBUSY_BUSY_MONTHS);
		RETURN_PROP_CASE(PR_FREEBUSY_EMAIL_ADDRESS);
		RETURN_PROP_CASE(PR_FREEBUSY_END_RANGE);
		RETURN_PROP_CASE(PR_FREEBUSY_LAST_MODIFIED);
		RETURN_PROP_CASE(PR_FREEBUSY_NUM_MONTHS);
		RETURN_PROP_CASE(PR_FREEBUSY_OOF_EVENTS);
		RETURN_PROP_CASE(PR_FREEBUSY_OOF_MONTHS);
		RETURN_PROP_CASE(PR_FREEBUSY_START_RANGE);
		RETURN_PROP_CASE(PR_FREEBUSY_TENTATIVE_EVENTS);
		RETURN_PROP_CASE(PR_FREEBUSY_TENTATIVE_MONTHS);

		RETURN_PROP_CASE(PR_PERSONAL_FREEBUSY);
		RETURN_PROP_CASE(PR_PROCESS_MEETING_REQUESTS);
		RETURN_PROP_CASE(PR_DECLINE_CONFLICTING_MEETING_REQUESTS);
		RETURN_PROP_CASE(PR_DECLINE_RECURRING_MEETING_REQUESTS);

		RETURN_PROP_CASE(PR_SEND_INTERNET_ENCODING);
		RETURN_PROP_CASE(PR_RECIPIENT_TRACKSTATUS);
		RETURN_PROP_CASE(PR_RECIPIENT_FLAGS);
		RETURN_PROP_CASE(PR_RECIPIENT_ENTRYID);
		RETURN_PROP_CASE(PR_RECIPIENT_DISPLAY_NAME);
		RETURN_PROP_CASE(PR_ICON_INDEX);
		RETURN_PROP_CASE(PR_ATTR_HIDDEN);
		RETURN_PROP_CASE(PR_ATTR_SYSTEM);
		RETURN_PROP_CASE(PR_ATTR_READONLY);
		RETURN_PROP_CASE(PR_URL_NAME);
		RETURN_PROP_CASE(PR_LOCAL_COMMIT_TIME);
		RETURN_PROP_CASE(PR_LOCAL_COMMIT_TIME_MAX);
		RETURN_PROP_CASE(PR_DELETED_COUNT_TOTAL);
		RETURN_PROP_CASE(PR_ICS_CHANGE_KEY);
		RETURN_PROP_CASE(PR_CREATOR_SID);
		RETURN_PROP_CASE(PR_LAST_MODIFIER_SID);
		RETURN_PROP_CASE(PR_OST_OSTID);
		RETURN_PROP_CASE(PR_OFFLINE_FOLDER);
		RETURN_PROP_CASE(PR_FAV_PARENT_SOURCE_KEY);
		RETURN_PROP_CASE(PR_TRUST_SENDER);
		RETURN_PROP_CASE(PR_URL_COMP_NAME);
//		RETURN_PROP_CASE(PR_DOTSTUFF_STATE);
		RETURN_PROP_CASE(PR_IN_REPLY_TO_ID);
		RETURN_PROP_CASE(PR_MAX_CACHED_VIEWS);

		RETURN_PROP_CASE(PR_ATTACH_FLAGS);

		RETURN_PROP_CASE(PR_MDN_DISPOSITION_TYPE);
		RETURN_PROP_CASE(PR_MDN_DISPOSITION_SENDINGMODE);
		RETURN_PROP_CASE(PR_LAST_VERB_EXECUTED);
		RETURN_PROP_CASE(PR_LAST_VERB_EXECUTION_TIME);

		
		RETURN_PROP_CASE(PR_FOLDER_DISPLAY_FLAGS);
		RETURN_PROP_CASE(PR_NET_FOLDER_FLAGS);
		RETURN_PROP_CASE(PR_FOLDER_VIEWS_ONLY);
		RETURN_PROP_CASE(PR_FOLDER_XVIEWINFO_E);
		RETURN_PROP_CASE(PR_FOLDER_WEBVIEWINFO);
		RETURN_PROP_CASE(PR_TODO_ITEM_FLAGS);
		RETURN_PROP_CASE(PR_FOLLOWUP_ICON);
		RETURN_PROP_CASE(PR_FLAG_STATUS);
		RETURN_PROP_CASE(PR_FLAG_COMPLETE_TIME);
		RETURN_PROP_CASE(PR_INETMAIL_OVERRIDE_FORMAT);

		RETURN_PROP_CASE(PR_MANAGED_FOLDER_INFORMATION);
		RETURN_PROP_CASE(PR_MANAGED_FOLDER_STORAGE_QUOTA);
		RETURN_PROP_CASE(PR_ASSOCIATED_SHARING_PROVIDER);
		RETURN_PROP_CASE(PR_EMSMDB_SECTION_UID);
		RETURN_PROP_CASE(PR_EMSABP_USER_UID);
		RETURN_PROP_CASE(PR_EMSMDB_LEGACY);
		RETURN_PROP_CASE(PR_ARCHIVE_TAG);
		RETURN_PROP_CASE(PR_ARCHIVE_PERIOD);
		RETURN_PROP_CASE(PR_ARCHIVE_DATE);
		RETURN_PROP_CASE(PR_RETENTION_FLAGS);
		RETURN_PROP_CASE(PR_RETENTION_DATE);
		RETURN_PROP_CASE(PR_POLICY_TAG);
		RETURN_PROP_CASE(PR_CI_SEARCH_ENABLED);
		RETURN_PROP_CASE(PR_CI_NOTIFICATION_ENABLED);
		RETURN_PROP_CASE(PR_ROAMING_DATATYPES);
		RETURN_PROP_CASE(PR_ITEM_TMPFLAGS);
		RETURN_PROP_CASE(PR_SECURE_SUBMIT_FLAGS);
		RETURN_PROP_CASE(PR_SECURITY_FLAGS);
		RETURN_PROP_CASE(PR_CONVERSATION_ID);
		RETURN_PROP_CASE(PR_STORE_UNICODE_MASK);
		// end <mapiext.h>

		// begin <ECTags.h>
		RETURN_PROP_CASE(PR_EC_PATH);
		// RETURN_PROP_CASE(PR_EC_USERNAME_A);
		// RETURN_PROP_CASE(PR_EC_USERNAME_W);
		// RETURN_PROP_CASE(PR_EC_USERPASSWORD_A);
		// RETURN_PROP_CASE(PR_EC_USERPASSWORD_W);
		RETURN_PROP_CASE(PR_EC_PORT);
		RETURN_PROP_CASE(PR_EC_FLAGS);
		// RETURN_PROP_CASE(PR_EC_SSLKEY_FILE);
		RETURN_PROP_CASE(PR_EC_SSLKEY_PASS);
		// RETURN_PROP_CASE(PR_EC_LAST_CONNECTIONTYPE);
		// RETURN_PROP_CASE(PR_EC_CONNECTION_TIMEOUT);
		// RETURN_PROP_CASE(PR_EC_OFFLINE_PATH_A);
		// RETURN_PROP_CASE(PR_EC_OFFLINE_PATH_W);

		// RETURN_PROP_CASE(PR_EC_PROXY_HOST);
		RETURN_PROP_CASE(PR_EC_PROXY_PORT);
		RETURN_PROP_CASE(PR_EC_PROXY_USERNAME);
		RETURN_PROP_CASE(PR_EC_PROXY_PASSWORD);
		RETURN_PROP_CASE(PR_EC_PROXY_FLAGS);

		// RETURN_PROP_CASE(PR_EC_CONTACT_ENTRYID);
		RETURN_PROP_CASE(PR_EC_HIERARCHYID);
		RETURN_PROP_CASE(PR_EC_STOREGUID);
		RETURN_PROP_CASE(PR_EC_COMPANYID);

		RETURN_PROP_CASE(PR_EC_QUOTA_MAIL_TIME);

		RETURN_PROP_CASE(PR_EC_STATSTABLE_SYSTEM);
		// RETURN_PROP_CASE(PR_EC_STATSTABLE_SESSIONS);
		RETURN_PROP_CASE(PR_EC_STATSTABLE_USERS);
		RETURN_PROP_CASE(PR_EC_STATSTABLE_COMPANY);
		RETURN_PROP_CASE(PR_EC_STATS_SYSTEM_DESCRIPTION);
		RETURN_PROP_CASE(PR_EC_STATS_SYSTEM_VALUE);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_ID);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_IPADDRESS);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_IDLETIME);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CAPABILITY);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_LOCKED);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_BUSYSTATES);

		// RETURN_PROP_CASE(PR_EC_COMPANY_NAME);
		// RETURN_PROP_CASE(PR_EC_COMPANY_NAME_A);
		// RETURN_PROP_CASE(PR_EC_COMPANY_NAME_W);
		// RETURN_PROP_CASE(PR_EC_COMPANY_ADMIN);
		// RETURN_PROP_CASE(PR_EC_COMPANY_ADMIN_A);
		// RETURN_PROP_CASE(PR_EC_COMPANY_ADMIN_W);

		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CPU_USER);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CPU_SYSTEM);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CPU_REAL);

		RETURN_PROP_CASE(PR_EC_STATS_SESSION_GROUP_ID);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_PEER_PID);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CLIENT_VERSION);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CLIENT_APPLICATION);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_REQUESTS);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CLIENT_APPLICATION_VERSION);
		RETURN_PROP_CASE(PR_EC_STATS_SESSION_CLIENT_APPLICATION_MISC);

		RETURN_PROP_CASE(PR_EC_OUTOFOFFICE);
		RETURN_PROP_CASE(PR_EC_OUTOFOFFICE_MSG);
		RETURN_PROP_CASE(PR_EC_OUTOFOFFICE_SUBJECT);
		RETURN_PROP_CASE(PR_EC_OUTOFOFFICE_FROM);
		RETURN_PROP_CASE(PR_EC_OUTOFOFFICE_UNTIL);

		RETURN_PROP_CASE(PR_EC_WEBACCESS_SETTINGS);
		RETURN_PROP_CASE(PR_EC_RECIPIENT_HISTORY);

		RETURN_PROP_CASE(PR_EC_OBJECT);
		RETURN_PROP_CASE(PR_EC_OUTGOING_FLAGS);
		// RETURN_PROP_CASE(PR_EC_MAILBOX_OWNER_ACCOUNT_A);
		// RETURN_PROP_CASE(PR_EC_MAILBOX_OWNER_ACCOUNT_W);
		RETURN_PROP_CASE(PR_EC_IMAP_ID);
		RETURN_PROP_CASE(PR_EC_IMAP_SUBSCRIBED);
		RETURN_PROP_CASE(PR_EC_IMAP_MAX_ID);
		RETURN_PROP_CASE(PR_EC_CLIENT_SUBMIT_DATE);
		RETURN_PROP_CASE(PR_EC_MESSAGE_DELIVERY_DATE);
		RETURN_PROP_CASE(PR_EC_SENDAS_USER_ENTRYIDS);
		// RETURN_PROP_CASE(PR_EC_EXCHANGE_DN_A);
		// RETURN_PROP_CASE(PR_EC_EXCHANGE_DN_W);
		RETURN_PROP_CASE(PR_EC_CHANGE_ADVISOR);
		RETURN_PROP_CASE(PR_EC_CHANGE_ONL_STATE);
		RETURN_PROP_CASE(PR_EC_CHANGE_OFFL_STATE);

		RETURN_PROP_CASE(PR_EC_SERVERPATH);
		// RETURN_PROP_CASE(PR_EC_HOMESERVER_NAME_A);
		// RETURN_PROP_CASE(PR_EC_HOMESERVER_NAME_W);
		RETURN_PROP_CASE(PR_EC_SERVER_UID);
		RETURN_PROP_CASE(PR_EC_SEARCHFOLDER_STATUS);
		RETURN_PROP_CASE(PR_EC_OFFLINE_SYNC_STATUS);
		RETURN_PROP_CASE(PR_EC_ONLINE_SYNC_STATUS);
		RETURN_PROP_CASE(PR_EC_AB_SYNC_STATUS);
		RETURN_PROP_CASE(PR_EC_SYNC_WAIT_TIME);
		RETURN_PROP_CASE(PR_EC_SYNC_ON_NOTIFY);

		RETURN_PROP_CASE(PR_EC_NONACTIVE);
		RETURN_PROP_CASE(PR_EC_ADMINISTRATOR);
		RETURN_PROP_CASE(PR_EC_MGR_ORG_ENTRYID);

		RETURN_PROP_CASE(PR_AB_CHOOSE_DIRECTORY_AUTOMATICALLY);
		// end <ECTags.h>
default:
	{
		static char szPropTag[39];
		
		sprintf(szPropTag, "0x%08X", (unsigned int)ulPropTag);

		return(szPropTag);
	}
	}
}//PropNameFromPropTag


const char *RelationalOperatorToString(ULONG relop)
{
	switch(relop) {
		RETURN_CASE(RELOP_GE)
		RETURN_CASE(RELOP_GT)
		RETURN_CASE(RELOP_LE)
		RETURN_CASE(RELOP_LT)
		RETURN_CASE(RELOP_NE)
		RETURN_CASE(RELOP_RE)
		RETURN_CASE(RELOP_EQ)
	}
	return "UNKNOWN";
}

std::string FuzzyLevelToString(ULONG ulFuzzyLevel)
{
	int i=0;
	std::string strResult;

	if((ulFuzzyLevel&0xFFFF) == FL_FULLSTRING){
		if(i>0) strResult += ", ";
		strResult += "FL_FULLSTRING";
		ulFuzzyLevel&=~FL_FULLSTRING;
		++i;
	}
	if((ulFuzzyLevel&0xFFFF) == FL_PREFIX) {
		if(i>0) strResult += ", ";
		strResult += "FL_PREFIX";
		ulFuzzyLevel&=~FL_PREFIX;
		++i;
	}
	if((ulFuzzyLevel&0xFFFF) == FL_SUBSTRING) {
		if(i>0) strResult += ", ";
		strResult += "FL_SUBSTRING";
		ulFuzzyLevel&=~FL_SUBSTRING;
		++i;
	}
	if((ulFuzzyLevel&0xFFFF0000) == FL_IGNORECASE) {
		if(i>0) strResult += ", ";
		strResult += "FL_IGNORECASE";
		ulFuzzyLevel&=~FL_IGNORECASE;
		++i;
	}
	if((ulFuzzyLevel&0xFFFF0000) == FL_IGNORENONSPACE) {
		if(i>0) strResult += ", ";
		strResult += "FL_IGNORENONSPACE";
		ulFuzzyLevel&=~FL_IGNORENONSPACE;
		++i;
	}
	if((ulFuzzyLevel&0xFFFF0000) == FL_LOOSE) {
		if(i>0) strResult += ", ";
		strResult += "FL_LOOSE";
		ulFuzzyLevel&=~FL_LOOSE;
		++i;
	}

	if(ulFuzzyLevel > 0) {
		if(i>0) strResult += ", ";
		strResult += "Not specified("+stringify(ulFuzzyLevel)+")";
	}

	return strResult;
}

std::string RestrictionToString(const SRestriction *lpRestriction,
    unsigned int indent)
{
	std::string strResult;
	unsigned int i = 0;
	unsigned int j = 0;

	if(lpRestriction == NULL)
		return "NULL";

	for (j = 0; j < indent; ++j)
		strResult += "  ";

	switch(lpRestriction->rt)
	{
		case RES_OR:
			strResult = "RES_OR: ("+stringify(lpRestriction->res.resOr.cRes)+")\n";
			for (i = 0; i < lpRestriction->res.resOr.cRes; ++i) {
				for (j = 0; j < indent + 1; ++j)
					strResult += "  ";
				strResult += "Restriction: "+ RestrictionToString(&lpRestriction->res.resOr.lpRes[i], indent+1)+"\n";
			}
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "---or---\n";
			break;
		case RES_AND:
			strResult = "RES_AND: ("+stringify(lpRestriction->res.resAnd.cRes)+")\n";
			for (i = 0; i < lpRestriction->res.resAnd.cRes; ++i) {
				for (j = 0; j < indent + 1; ++j)
					strResult += "  ";
				strResult += "Restriction: " + RestrictionToString(&lpRestriction->res.resAnd.lpRes[i], indent+1);
			}
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "---and---\n";
			break;

		case RES_BITMASK:
			strResult = "RES_BITMASK:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			switch(lpRestriction->res.resBitMask.relBMR){
				case BMR_EQZ:
					strResult+= "BMR: R_EQZ\n";
					break;
				case BMR_NEZ:
					strResult+= "BMR: R_NEZ\n";
					break;
				default:
					strResult+= "BMR: Not specified("+stringify(lpRestriction->res.resBitMask.relBMR)+")\n";
					break;
			}
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag: "+PropNameFromPropTag(lpRestriction->res.resBitMask.ulPropTag)+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "mask: "+stringify(lpRestriction->res.resBitMask.ulMask)+"\n";
			break;
		case RES_COMMENT:
			strResult = "RES_COMMENT:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "props: " + PropNameFromPropArray(lpRestriction->res.resComment.cValues, lpRestriction->res.resComment.lpProp)+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "restriction: "+ RestrictionToString(lpRestriction->res.resComment.lpRes, indent+1)+"\n";
			break;
		case RES_COMPAREPROPS:
			strResult = "RES_COMPAREPROPS:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "relop: ";
			strResult += RelationalOperatorToString(lpRestriction->res.resCompareProps.relop);
			strResult += "\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag1: "+PropNameFromPropTag(lpRestriction->res.resCompareProps.ulPropTag1)+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag2: "+PropNameFromPropTag(lpRestriction->res.resCompareProps.ulPropTag2)+"\n";
			break;
		case RES_CONTENT:
			strResult = "RES_CONTENT:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "FuzzyLevel: "+FuzzyLevelToString(lpRestriction->res.resContent.ulFuzzyLevel)+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag: "+PropNameFromPropTag(lpRestriction->res.resContent.ulPropTag)+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "props: " + PropNameFromPropArray(1, lpRestriction->res.resContent.lpProp)+"\n";
			break;
		case RES_EXIST:
			strResult = "RES_EXIST:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag: "+PropNameFromPropTag(lpRestriction->res.resExist.ulPropTag)+"\n";
			break;
		case RES_NOT:
			strResult = "RES_NOT:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "restriction: "+ RestrictionToString(lpRestriction->res.resNot.lpRes, indent+1)+"\n";
			break;
		case RES_PROPERTY:
			strResult = "RES_PROPERTY:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "relop: ";
			strResult += RelationalOperatorToString(lpRestriction->res.resProperty.relop);
			strResult += "\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag: "+PropNameFromPropTag(lpRestriction->res.resProperty.ulPropTag)+((lpRestriction->res.resProperty.ulPropTag&MV_FLAG)?" (MV_PROP)":"")+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "props: " + PropNameFromPropArray(1, lpRestriction->res.resProperty.lpProp)+((lpRestriction->res.resProperty.lpProp->ulPropTag&MV_FLAG)?" (MV_PROP)":"")+"\n";
			break;
		case RES_SIZE:
			strResult = "RES_SIZE:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "relop: ";
			strResult += RelationalOperatorToString(lpRestriction->res.resSize.relop);
			strResult += "\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "proptag: "+PropNameFromPropTag(lpRestriction->res.resSize.ulPropTag)+"\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "sizeofprop: "+ stringify(lpRestriction->res.resSize.cb) + "\n";
			break;
		case RES_SUBRESTRICTION:
			strResult = "RES_SUBRESTRICTION:\n";
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			switch(lpRestriction->res.resSub.ulSubObject) {
				case PR_MESSAGE_RECIPIENTS:
					strResult+= "subobject: PR_MESSAGE_RECIPIENTS\n";
					break;
				case PR_MESSAGE_ATTACHMENTS:
					strResult+= "subobject: PR_MESSAGE_ATTACHMENTS\n";
					break;
				default:
					strResult += "subobject: Not specified("+stringify(lpRestriction->res.resSub.ulSubObject)+")\n";
					break;
			}
			for (j = 0; j < indent; ++j)
				strResult += "  ";
			strResult += "Restriction: "+ RestrictionToString(lpRestriction->res.resSub.lpRes, indent+1)+"\n";
			break;
		default:
			strResult = "UNKNOWN TYPE:\n";
			break;
	}

	return strResult;
}

std::string unicodetostr(const wchar_t *lpszW)
{
	return convert_to<std::string>(lpszW);
}

std::string PropValueToString(const SPropValue *lpPropValue)
{
	std::string strResult;

//return "DEBUG OFF";
	if(lpPropValue == NULL)
		return "NULL";

	switch(PROP_TYPE(lpPropValue->ulPropTag)) {	
		case PT_I2:
			strResult = "PT_I2: "+stringify(lpPropValue->Value.i)+", "+stringify(lpPropValue->Value.i,true);
			break;
		case PT_LONG:
			strResult = "PT_LONG: "+stringify(lpPropValue->Value.ul)+", "+stringify(lpPropValue->Value.ul,true);
			break;
		case PT_BOOLEAN:
			strResult = "PT_BOOLEAN: "+stringify(lpPropValue->Value.b);
			break;
		case PT_R4:
			strResult = "PT_R4: "+stringify_float(lpPropValue->Value.flt);
			break;
		case PT_DOUBLE:
			strResult = "PT_DOUBLE: "+stringify_double(lpPropValue->Value.dbl);
			break;
		case PT_APPTIME:
			strResult = "PT_APPTIME: "+stringify_double(lpPropValue->Value.at);
			break;
		case PT_CURRENCY:
			strResult = "PT_CURRENCY: lo="+stringify(lpPropValue->Value.cur.Lo)+" hi="+stringify(lpPropValue->Value.cur.Hi);
			break;
		case PT_SYSTIME:
			strResult = "PT_SYSTIME: fth="+stringify(lpPropValue->Value.ft.dwHighDateTime)+" ftl="+stringify(lpPropValue->Value.ft.dwLowDateTime);
			break;
		case PT_I8:
			strResult = "PT_I8: "+stringify(lpPropValue->Value.li.HighPart) + "," + stringify(lpPropValue->Value.li.LowPart);
			break;
		case PT_UNICODE:
			strResult = "PT_UNICODE: " + convert_to<std::string>("UTF-8", lpPropValue->Value.lpszW, rawsize(lpPropValue->Value.lpszW), CHARSET_WCHAR);
			break;
		case PT_STRING8:
			strResult = "PT_STRING8: "+ ((lpPropValue->Value.lpszA)?(std::string)lpPropValue->Value.lpszA:std::string("NULL"));
			break;
		case PT_BINARY:
			strResult = "PT_BINARY: cb="+stringify(lpPropValue->Value.bin.cb);
			strResult+= " Data="+((lpPropValue->Value.bin.lpb)?bin2hex(lpPropValue->Value.bin.cb, lpPropValue->Value.bin.lpb) : std::string("NULL"));
			break;
		case PT_CLSID:
			strResult = "PT_CLSID: (Skip)";
			break;
		case PT_NULL:
			strResult = "PT_NULL: ";
			break;
		case PT_UNSPECIFIED:
			strResult = "PT_UNSPECIFIED: ";
			break;
		case PT_ERROR:
			strResult = "PT_ERROR: "+GetMAPIErrorDescription(lpPropValue->Value.err);
			break;
		case PT_SRESTRICTION:
			strResult = "PT_SRESTRICTION: structure...";
			break;
		case PT_ACTIONS:
			strResult = "PT_ACTIONS: structure...";
			break;
		case PT_OBJECT:
			strResult = "<OBJECT>";
			break;
		case PT_MV_I2:
			strResult = "PT_MV_I2[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_LONG:
			strResult = "PT_MV_LONG[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_R4:
			strResult = "PT_MV_R4[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_DOUBLE:
			strResult = "PT_MV_DOUBLE[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_APPTIME:
			strResult = "PT_MV_APPTIME[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_CURRENCY:
			strResult = "PT_MV_CURRENCY[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_SYSTIME:
			strResult = "PT_MV_SYSTIME[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_I8:
			strResult = "PT_MV_I8[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_UNICODE:
			strResult = "PT_MV_UNICODE[" + stringify(lpPropValue->Value.MVi.cValues) + "]" + "\n";
			for (unsigned int i = 0; i < lpPropValue->Value.MVi.cValues; ++i)
				strResult += std::string("\t") + convert_to<std::string>(lpPropValue->Value.MVszW.lppszW[i]) + "\n";
			break;
		case PT_MV_STRING8:
			strResult = "PT_MV_STRING8[" + stringify(lpPropValue->Value.MVi.cValues) + "]" + "\n";
			for (unsigned int i = 0; i < lpPropValue->Value.MVi.cValues; ++i)
				strResult += std::string("\t") + lpPropValue->Value.MVszA.lppszA[i] + "\n";
			break;
		case PT_MV_BINARY:
			strResult = "PT_MV_BINARY[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		case PT_MV_CLSID:
			strResult = "PT_MV_CLSID[" + stringify(lpPropValue->Value.MVi.cValues) + "]";
			break;
		default:
			strResult = "<UNKNOWN>";
			break;
	}

return strResult;
}

std::string RowToString(const SRow *lpRow)
{
	std::string strResult;

	if(lpRow == NULL)
		return "NULL";

	for (unsigned int i = 0; i < lpRow->cValues; ++i)
		strResult += PropNameFromPropTag(lpRow->lpProps[i].ulPropTag)+" : "+PropValueToString(&lpRow->lpProps[i]) + "\n";

	return strResult;
}

static const char *ABFlags(ULONG ulFlag)
{
	switch(ulFlag) {
		case MAPI_UNRESOLVED:
			return "MAPI_UNRESOLVED";
		case MAPI_AMBIGUOUS:
			return "MAPI_AMBIGUOUS";
		case MAPI_RESOLVED:
			return "MAPI_RESOLVED";
		default:
			return "UNKNOWN";
	}
	return NULL;
}

std::string AdrRowSetToString(const ADRLIST *lpAdrList,
    const FlagList *lpFlagList)
{
	std::string strResult;

	if(lpAdrList == NULL)
		return "NULL";

	for (unsigned int i = 0; i < lpAdrList->cEntries; ++i) {
		strResult += "row " + stringify(i) + " : " +
			 RowToString((LPSRow)&lpAdrList->aEntries[i]) + "\n";
		if (lpFlagList != NULL) {
			strResult += " flag=";
			strResult += ABFlags(lpFlagList->ulFlag[i]);
			strResult += "\n";
		}
	}

	return strResult;
}

std::string RowSetToString(const SRowSet *lpRows)
{
// 	return "DEBUG OFF";

	std::string strResult;

	if(lpRows == NULL)
		return "NULL";

	for (unsigned int i = 0; i < lpRows->cRows; ++i)
		strResult+= "row "+stringify(i) + " : " + RowToString(&lpRows->aRow[i]) + "\n";

	return strResult;
}

std::string RowEntryToString(const ROWENTRY *lpRowEntry)
{
	std::string strResult;
	if(lpRowEntry == NULL)
		return "NULL";

	strResult = "rowflags: "+ stringify(lpRowEntry->ulRowFlags, true) + "\n";
	for (unsigned int i = 0; i < lpRowEntry->cValues; ++i)
		strResult += PropNameFromPropTag(lpRowEntry->rgPropVals[i].ulPropTag)+" : "+PropValueToString(&lpRowEntry->rgPropVals[i]) + "\n";

	return strResult;
}

std::string RowListToString(const ROWLIST *lpRowList)
{
	std::string strResult;

	if(lpRowList == NULL)
		return "NULL";

	for (unsigned int i = 0; i < lpRowList->cEntries; ++i)
		strResult+= "row "+stringify(i) + " : " + RowEntryToString(&lpRowList->aEntries[i]) + "\n";

	return strResult;
}

const char *ActionToString(const ACTION *lpAction)
{
	return "Action struct: NOT IMPLEMENTED";
}

std::string SortOrderToString(const SSortOrder *lpSort)
{
	std::string strResult;

	if(lpSort == NULL)
		return "NULL";

	strResult = PropNameFromPropTag(lpSort->ulPropTag);
	strResult += ", Order: ";
	switch(lpSort->ulOrder)
	{
		case TABLE_SORT_ASCEND:
			strResult += "TABLE_SORT_ASCEND";
			break;
		case TABLE_SORT_COMBINE:
			strResult += "TABLE_SORT_COMBINE";
			break;
		case TABLE_SORT_DESCEND:
			strResult += "TABLE_SORT_DESCEND";
			break;
		default:
			strResult += "<UNKNOWN> "+stringify(lpSort->ulOrder);
			break;
	}

	return strResult;
}

std::string SortOrderSetToString(const SSortOrderSet *lpSortCriteria)
{

	std::string strResult;

	if(lpSortCriteria == NULL)
		return "NULL";

	strResult = "cCategories="+stringify(lpSortCriteria->cCategories)+" cExpanded="+stringify(lpSortCriteria->cExpanded)+"\n";

	for (unsigned int i = 0; i < lpSortCriteria->cSorts; ++i)
		strResult+= "row "+stringify(i) + " : " + SortOrderToString(&lpSortCriteria->aSort[i]) + "\n";

	return strResult;
}

std::string EntryListToString(const ENTRYLIST *lpMsgList)
{
	std::string str;

	if(lpMsgList == NULL)
		return "NULL";

	str = "values: "+stringify(lpMsgList->cValues);
	str+= "\n";

	for (ULONG i = 0; i < lpMsgList->cValues; ++i) {
		str+= "cb="+stringify(lpMsgList->lpbin[i].cb)+" lpb="+((lpMsgList->lpbin[i].lpb)?bin2hex(lpMsgList->lpbin[i].cb, lpMsgList->lpbin[i].lpb) : std::string("NULL"));
		str+= "\n";
	}

	return str;
}

static const std::string
Notification_ErrorToString(const ERROR_NOTIFICATION *lpErr)
{
	std::string str;

	str = "( \n";
	str += "\tDebug not implement\n";
	str += ")\n";

	return str;
}

/**
 * Convert NEWMAIL_NOTIFICATION struct to a string
 *
 * @param[in]	lpNewmail	newmail struct of a notification to convert to string
 * @return		std::string	string with hex representations of binary data
 */
static std::string
Notification_NewMailToString(const NEWMAIL_NOTIFICATION *lpNewmail)
{
	std::string str;

	str = "( \n";

	if(lpNewmail == NULL) {
		str += "NULL";
		goto exit;
	}
	str = "Entryid: cb="+stringify(lpNewmail->cbEntryID);
	str+= " "+((lpNewmail->lpEntryID) ? bin2hex(lpNewmail->cbEntryID, (LPBYTE)lpNewmail->lpEntryID) : std::string("NULL")) + "\n";
	str+= "Parentid: cb="+stringify(lpNewmail->cbParentID);
	str+= " "+((lpNewmail->lpParentID) ? bin2hex(lpNewmail->cbParentID, (LPBYTE)lpNewmail->lpParentID) : std::string("NULL")) + "\n";
	str+= "MessageClass:" + ((lpNewmail->lpszMessageClass) ? (std::string((char*)lpNewmail->lpszMessageClass)) : std::string("NULL")) + "\n";
	str+= "MessageFlags:" + stringify(lpNewmail->ulMessageFlags, true) + "\n";
	str+= "Flags:" + stringify(lpNewmail->ulFlags, true) + "\n";
	
exit:
	str += ")\n";

	return str;
}

static std::string
Notification_ObjectToString(const OBJECT_NOTIFICATION *lpObj)
{
	std::string str;

	str = "( \n";

	if(lpObj == NULL) {
		str += "NULL";
		goto exit;
	}

	str+= "ObjType:" + stringify(lpObj->ulObjType, true) + "\n";
	str+= "Entryid: cb="+stringify(lpObj->cbEntryID);
	str+= " "+((lpObj->lpEntryID)?bin2hex(lpObj->cbEntryID, (LPBYTE)lpObj->lpEntryID) : std::string("NULL")) + "\n";
	str+= "Parentid: cb="+stringify(lpObj->cbParentID);
	str+= " "+((lpObj->lpParentID)?bin2hex(lpObj->cbParentID, (LPBYTE)lpObj->lpParentID) : std::string("NULL")) + "\n";

	if(lpObj->cbOldID) {
		str+= "Oldentryid: cb="+stringify(lpObj->cbOldID);
		str+= " "+((lpObj->lpOldID)?bin2hex(lpObj->cbOldID, (LPBYTE)lpObj->lpOldID) : std::string("NULL")) + "\n";
	}
	if(lpObj->cbOldParentID) {
		str+= "Oldparentid: cb="+stringify(lpObj->cbOldParentID);
		str+= " "+((lpObj->lpOldParentID)?bin2hex(lpObj->cbOldParentID, (LPBYTE)lpObj->lpOldParentID) : std::string("NULL")) + "\n";
	}

	if(lpObj->lpPropTagArray)
		str+= "PropTagArray="+PropNameFromPropTagArray(lpObj->lpPropTagArray)+"\n";

exit:
	str += ")\n";

	return str;
}

static const char *TableEventToString(ULONG ulTableEvent)
{
	switch(ulTableEvent) 
	{
		case TABLE_CHANGED:
			return "TABLE_CHANGED";
		case TABLE_ERROR:
			return "TABLE_ERROR";
		case TABLE_ROW_ADDED:
			return "TABLE_ROW_ADDED";
		case TABLE_ROW_DELETED:
			return "TABLE_ROW_DELETED";
		case TABLE_ROW_MODIFIED:
			return "TABLE_ROW_MODIFIED";
		case TABLE_SORT_DONE:
			return "TABLE_SORT_DONE";
		case TABLE_RESTRICT_DONE:
			return "TABLE_RESTRICT_DONE";
		case TABLE_SETCOL_DONE:
			return "TABLE_SETCOL_DONE";
		case TABLE_RELOAD:
			return "TABLE_RELOAD";
		default:
			return "<invalidate TYPE>";
	}
	return NULL;
}

static std::string Notification_TableToString(const TABLE_NOTIFICATION *lpTab)
{
	std::string str;

	str = "( \n";

	if(lpTab == NULL) {
		str += "NULL";
		goto exit;
	}

	str += "\tTableEvent: (";
	str += TableEventToString(lpTab->ulTableEvent);
	str += " )\n";
	
	str += "\tPropIndex: (";
	str += PropValueToString(&lpTab->propIndex);
	str += " )\n";;
	str += "\tPropPrior: (";
	str += PropValueToString(&lpTab->propPrior);
	str += " )\n";
	str += "\tRow: (" + RowToString(&lpTab->row) + " )\n";
	
exit:
	str += ")\n";

	return str;
}

static std::string
Notification_StatusObjToString(const STATUS_OBJECT_NOTIFICATION *lpStatobj)
{
	std::string str;

	str = "( \n";
	str += "\tDebug not implement\n";
	str += ")\n";

	return str;
}

static std::string
Notification_ExtendedToString(const EXTENDED_NOTIFICATION *lpExt)
{
	std::string str;

	str = "( \n";

	if(lpExt == NULL) {
		str += "NULL";
		return str;
	}

	str += "\tEvent: (0x" + stringify(lpExt->ulEvent, true) + " )\n";
	str += "\tcb: (0x" + stringify(lpExt->cb, true) + " )\n";
	str += "\tdata: (0x" + bin2hex(lpExt->cb, lpExt->pbEventParameters) + " )\n";

	str += ")\n";
	return str;
}

static const char *EventTypeToString(ULONG ulEventType)
{
	switch(ulEventType)
	{
		case fnevCriticalError: // ERROR_NOTIFICATION err;
			return "CriticalError";
		case fnevNewMail:
			return "NewMail";
		case fnevObjectCreated:
			return "ObjectCreated";
		case fnevObjectDeleted:
			return "ObjectDeleted";
		case fnevObjectModified:
			return "ObjectModified";
		case fnevObjectMoved:
			return "ObjectMoved";
		case fnevObjectCopied:
			return "ObjectCopied";
		case fnevSearchComplete:
			return "SearchComplete";
		case fnevTableModified:
			return "TableModified";
		case fnevStatusObjectModified:// STATUS_OBJECT_NOTIFICATION statobj;
			return "StatusObjectModified";
		case fnevExtended:// EXTENDED_NOTIFICATION ext;
			return "Extended";
		case fnevReservedForMapi:
		default:
			return "Unknown";
	}
	return NULL;
}

std::string NotificationToString(ULONG cNotification,
    const NOTIFICATION *lpNotification)
{
	std::string str;

	if(lpNotification == NULL)
		return "NULL";
	
	for (ULONG i = 0; i < cNotification; ++i) {
		if (cNotification > 1)
			str += "item " + stringify(i) + " (\n";

		str += "Eventtype: ( ";
		str += EventTypeToString(lpNotification[i].ulEventType);
		str += " )\n";
		switch(lpNotification[i].ulEventType)
		{
			case fnevCriticalError: // ERROR_NOTIFICATION err;
				str += Notification_ErrorToString(&lpNotification[i].info.err);
				break;
			case fnevNewMail: // NEWMAIL_NOTIFICATION newmail;
				str += Notification_NewMailToString(&lpNotification[i].info.newmail);
				break;
			case fnevObjectCreated: //OBJECT_NOTIFICATION obj;
			case fnevObjectDeleted:
			case fnevObjectModified:
			case fnevObjectMoved:
			case fnevObjectCopied:
			case fnevSearchComplete:
				str += Notification_ObjectToString(&lpNotification[i].info.obj);
				break;
			case fnevTableModified:// TABLE_NOTIFICATION tab;
				str += Notification_TableToString(&lpNotification[i].info.tab);
				break;
			case fnevStatusObjectModified:// STATUS_OBJECT_NOTIFICATION statobj;
				str += Notification_StatusObjToString(&lpNotification[i].info.statobj);
				break;
			case fnevExtended:// EXTENDED_NOTIFICATION ext;
				str += Notification_ExtendedToString(&lpNotification[i].info.ext);
				break;
			case fnevReservedForMapi:
			default:
				str += "Unknown";
				break;
		}

		if (cNotification > 1)
			str += ")\n";

	}

	return str;
}

std::string PermissionRulesToString(ULONG cPermissions,
    const ECPERMISSION *lpECPermissions)
{
	std::string		str;
	unsigned int	ulUserId = 0;

	if(lpECPermissions == NULL)
		return "NULL";

	str = "( \n";
	for (ULONG ci = 0; ci<cPermissions; ++ci) {
		if (GetNonPortableObjectId(lpECPermissions[ci].sUserId.cb, (LPENTRYID)lpECPermissions[ci].sUserId.lpb, &ulUserId) == hrSuccess)
			str += "{ Userid=" + stringify(ulUserId) + "\n";
		else
			str += "{ Userid=unknown\n";
		str += "  Type=" + stringify(lpECPermissions[ci].ulType) + "\n";
		str += "  Rights=" + stringify(lpECPermissions[ci].ulRights) + "\n";
		str += "  State=" + stringify(lpECPermissions[ci].ulState) + " }\n";

	}
	str += "}\n";

	return str;
}

std::string ProblemArrayToString(const SPropProblemArray *lpProblemArray)
{
	std::string str;
	ULONG i;

	if (lpProblemArray == NULL)
		return "NULL";

	str = "Problems: ( " + stringify(lpProblemArray->cProblem) + "\n";

	for (i = 0; i < lpProblemArray->cProblem; ++i) {
		const SPropProblem *p = &lpProblemArray->aProblem[i];
		str += "  ( ulIndex: " + stringify(p->ulIndex, true) + " ulPropTag: " + stringify(p->ulPropTag, true) + " scode: " + stringify(p->scode, true) + "),\n";
	}

	str += ")\n";

	return str;
}

std::string DBGGUIDToString(REFIID iid)
{
	std::string guidIDD;
	char szGuidId[DEBUGBUFSIZE+1];

	int i = 0;
	while(sGuidList[i].guid != NULL)
	{
		if(memcmp(&iid, sGuidList[i].guid, sizeof(GUID)) == 0){
			guidIDD = sGuidList[i].szguidname;
			break;
		}
		++i;
	}

	if (guidIDD.empty()) {
		_snprintf(szGuidId, DEBUGBUFSIZE, "{%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}", iid.Data1, iid.Data2, iid.Data3, iid.Data4[0], iid.Data4[1], iid.Data4[2], iid.Data4[3], iid.Data4[4], iid.Data4[5], iid.Data4[6], iid.Data4[7]);
		guidIDD = "Unknown ";
		guidIDD+=szGuidId;
	}


	return guidIDD;
}

std::string MapiNameIdToString(const MAPINAMEID *pNameId)
{
	std::string str;

	if(pNameId == NULL)
		return "NULL";

	str = DBGGUIDToString(*pNameId->lpguid) + " -> ";

	if(pNameId->ulKind == MNID_ID) {
		str += "ID    = "+stringify(pNameId->Kind.lID);
	} else if(pNameId->ulKind == MNID_STRING) {
		str += "String= " + bin2hex(wcslen(pNameId->Kind.lpwstrName)*sizeof(WCHAR), (BYTE *)pNameId->Kind.lpwstrName);
	} else {
		str += "Unknown kind";
	}

	return str;
}

std::string MapiNameIdListToString(ULONG cNames,
    const MAPINAMEID *const *ppNames, const SPropTagArray *pptaga)
{
	std::string str;
	ULONG i;


	if(ppNames == NULL)
		return "NULL";

	str = "NameIds: (" + stringify(cNames) + ")\n";

	for (i = 0; i < cNames; ++i) {
		str += MapiNameIdToString(ppNames[i]);
		if(pptaga && pptaga->cValues == cNames) {
			str += " -> ";
			str += stringify(pptaga->aulPropTag[i], true);
		}
		str += "\n";
	}

	return str;
}

const char *ResourceTypeToString(ULONG ulResourceType)
{
	switch (ulResourceType) {
		RETURN_CASE(MAPI_STORE_PROVIDER);
		RETURN_CASE(MAPI_AB);
		RETURN_CASE(MAPI_AB_PROVIDER);
		RETURN_CASE(MAPI_TRANSPORT_PROVIDER);
		RETURN_CASE(MAPI_SPOOLER);
		RETURN_CASE(MAPI_PROFILE_PROVIDER);
		RETURN_CASE(MAPI_SUBSYSTEM);
		RETURN_CASE(MAPI_HOOK_PROVIDER);
	}

	return "<Unknown type>";
}

const char *MsgServiceContextToString(ULONG ulContext)
{
	switch(ulContext) {
		RETURN_CASE(MSG_SERVICE_INSTALL);
		RETURN_CASE(MSG_SERVICE_UNINSTALL);
		RETURN_CASE(MSG_SERVICE_DELETE);
		RETURN_CASE(MSG_SERVICE_PROVIDER_CREATE);
		RETURN_CASE(MSG_SERVICE_PROVIDER_DELETE);
		RETURN_CASE(MSG_SERVICE_CONFIGURE);
		RETURN_CASE(MSG_SERVICE_CREATE);
	}

	return "<UNKNOWN>";
}
