/* soapC.cpp
   Generated by gSOAP 2.8.17r from calculator.h

Copyright(C) 2000-2014, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
GPL or Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.17r 2014-05-19 00:13:45 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->version && soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->version && soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (soap->header == NULL)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (soap->fault == NULL)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (soap->fault == NULL)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode == NULL)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Detail == NULL)
		{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
			soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
		}
		return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
	}
	if (soap->fault->detail == NULL)
	{	soap->fault->detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
	}
	return (const char**)&soap->fault->detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
#ifndef WITH_NOIDREF
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_wsc__FaultCodeType:
		return soap_in_wsc__FaultCodeType(soap, NULL, NULL, "wsc:FaultCodeType");
	case SOAP_TYPE_wsse__FaultcodeEnum:
		return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, "wsse:FaultcodeEnum");
	case SOAP_TYPE_wsu__tTimestampFault:
		return soap_in_wsu__tTimestampFault(soap, NULL, NULL, "wsu:tTimestampFault");
	case SOAP_TYPE_wsc__PropertiesType:
		return soap_in_wsc__PropertiesType(soap, NULL, NULL, "wsc:PropertiesType");
	case SOAP_TYPE_wsc__DerivedKeyTokenType:
		return soap_in_wsc__DerivedKeyTokenType(soap, NULL, NULL, "wsc:DerivedKeyTokenType");
	case SOAP_TYPE_wsc__SecurityContextTokenType:
		return soap_in_wsc__SecurityContextTokenType(soap, NULL, NULL, "wsc:SecurityContextTokenType");
	case SOAP_TYPE_xenc__EncryptionPropertyType:
		return soap_in_xenc__EncryptionPropertyType(soap, NULL, NULL, "xenc:EncryptionPropertyType");
	case SOAP_TYPE_xenc__EncryptionPropertiesType:
		return soap_in_xenc__EncryptionPropertiesType(soap, NULL, NULL, "xenc:EncryptionPropertiesType");
	case SOAP_TYPE_xenc__ReferenceType:
		return soap_in_xenc__ReferenceType(soap, NULL, NULL, "xenc:ReferenceType");
	case SOAP_TYPE_xenc__AgreementMethodType:
		return soap_in_xenc__AgreementMethodType(soap, NULL, NULL, "xenc:AgreementMethodType");
	case SOAP_TYPE_xenc__EncryptedKeyType:
		return soap_in_xenc__EncryptedKeyType(soap, NULL, NULL, "xenc:EncryptedKeyType");
	case SOAP_TYPE_xenc__EncryptedDataType:
		return soap_in_xenc__EncryptedDataType(soap, NULL, NULL, "xenc:EncryptedDataType");
	case SOAP_TYPE_xenc__TransformsType:
		return soap_in_xenc__TransformsType(soap, NULL, NULL, "xenc:TransformsType");
	case SOAP_TYPE_xenc__CipherReferenceType:
		return soap_in_xenc__CipherReferenceType(soap, NULL, NULL, "xenc:CipherReferenceType");
	case SOAP_TYPE_xenc__CipherDataType:
		return soap_in_xenc__CipherDataType(soap, NULL, NULL, "xenc:CipherDataType");
	case SOAP_TYPE_xenc__EncryptionMethodType:
		return soap_in_xenc__EncryptionMethodType(soap, NULL, NULL, "xenc:EncryptionMethodType");
	case SOAP_TYPE_xenc__EncryptedType:
		return soap_in_xenc__EncryptedType(soap, NULL, NULL, "xenc:EncryptedType");
	case SOAP_TYPE_ds__RSAKeyValueType:
		return soap_in_ds__RSAKeyValueType(soap, NULL, NULL, "ds:RSAKeyValueType");
	case SOAP_TYPE_ds__DSAKeyValueType:
		return soap_in_ds__DSAKeyValueType(soap, NULL, NULL, "ds:DSAKeyValueType");
	case SOAP_TYPE_ds__X509IssuerSerialType:
		return soap_in_ds__X509IssuerSerialType(soap, NULL, NULL, "ds:X509IssuerSerialType");
	case SOAP_TYPE_ds__RetrievalMethodType:
		return soap_in_ds__RetrievalMethodType(soap, NULL, NULL, "ds:RetrievalMethodType");
	case SOAP_TYPE_ds__KeyValueType:
		return soap_in_ds__KeyValueType(soap, NULL, NULL, "ds:KeyValueType");
	case SOAP_TYPE_ds__DigestMethodType:
		return soap_in_ds__DigestMethodType(soap, NULL, NULL, "ds:DigestMethodType");
	case SOAP_TYPE_ds__TransformType:
		return soap_in_ds__TransformType(soap, NULL, NULL, "ds:TransformType");
	case SOAP_TYPE_ds__TransformsType:
		return soap_in_ds__TransformsType(soap, NULL, NULL, "ds:TransformsType");
	case SOAP_TYPE_ds__ReferenceType:
		return soap_in_ds__ReferenceType(soap, NULL, NULL, "ds:ReferenceType");
	case SOAP_TYPE_ds__SignatureMethodType:
		return soap_in_ds__SignatureMethodType(soap, NULL, NULL, "ds:SignatureMethodType");
	case SOAP_TYPE_ds__CanonicalizationMethodType:
		return soap_in_ds__CanonicalizationMethodType(soap, NULL, NULL, "ds:CanonicalizationMethodType");
	case SOAP_TYPE_ds__KeyInfoType:
		return soap_in_ds__KeyInfoType(soap, NULL, NULL, "ds:KeyInfoType");
	case SOAP_TYPE_ds__SignedInfoType:
		return soap_in_ds__SignedInfoType(soap, NULL, NULL, "ds:SignedInfoType");
	case SOAP_TYPE_ds__SignatureType:
		return soap_in_ds__SignatureType(soap, NULL, NULL, "ds:SignatureType");
	case SOAP_TYPE_ds__X509DataType:
		return soap_in_ds__X509DataType(soap, NULL, NULL, "ds:X509DataType");
	case SOAP_TYPE_PointerTo_wsse__Security:
		return soap_in_PointerTo_wsse__Security(soap, NULL, NULL, "wsse:Security");
	case SOAP_TYPE_PointerTods__SignatureType:
		return soap_in_PointerTods__SignatureType(soap, NULL, NULL, "ds:SignatureType");
	case SOAP_TYPE_PointerTowsc__SecurityContextTokenType:
		return soap_in_PointerTowsc__SecurityContextTokenType(soap, NULL, NULL, "wsc:SecurityContextTokenType");
	case SOAP_TYPE_PointerToxenc__EncryptedKeyType:
		return soap_in_PointerToxenc__EncryptedKeyType(soap, NULL, NULL, "xenc:EncryptedKeyType");
	case SOAP_TYPE_PointerTo_wsse__BinarySecurityToken:
		return soap_in_PointerTo_wsse__BinarySecurityToken(soap, NULL, NULL, "wsse:BinarySecurityToken");
	case SOAP_TYPE_PointerTo_wsse__UsernameToken:
		return soap_in_PointerTo_wsse__UsernameToken(soap, NULL, NULL, "wsse:UsernameToken");
	case SOAP_TYPE_PointerTo_wsu__Timestamp:
		return soap_in_PointerTo_wsu__Timestamp(soap, NULL, NULL, "wsu:Timestamp");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_in_PointerTounsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_PointerTowsc__PropertiesType:
		return soap_in_PointerTowsc__PropertiesType(soap, NULL, NULL, "wsc:PropertiesType");
	case SOAP_TYPE_wsc__FaultCodeOpenEnumType:
	{	char **s;
		s = soap_in_wsc__FaultCodeOpenEnumType(soap, NULL, NULL, "wsc:FaultCodeOpenEnumType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTo_xenc__ReferenceList:
		return soap_in_PointerTo_xenc__ReferenceList(soap, NULL, NULL, "xenc:ReferenceList");
	case SOAP_TYPE_PointerToxenc__ReferenceType:
		return soap_in_PointerToxenc__ReferenceType(soap, NULL, NULL, "xenc:ReferenceType");
	case SOAP_TYPE_PointerToxenc__EncryptionPropertyType:
		return soap_in_PointerToxenc__EncryptionPropertyType(soap, NULL, NULL, "xenc:EncryptionPropertyType");
	case SOAP_TYPE_PointerToxenc__TransformsType:
		return soap_in_PointerToxenc__TransformsType(soap, NULL, NULL, "xenc:TransformsType");
	case SOAP_TYPE_PointerToxenc__CipherReferenceType:
		return soap_in_PointerToxenc__CipherReferenceType(soap, NULL, NULL, "xenc:CipherReferenceType");
	case SOAP_TYPE_PointerToxenc__EncryptionPropertiesType:
		return soap_in_PointerToxenc__EncryptionPropertiesType(soap, NULL, NULL, "xenc:EncryptionPropertiesType");
	case SOAP_TYPE_PointerToxenc__CipherDataType:
		return soap_in_PointerToxenc__CipherDataType(soap, NULL, NULL, "xenc:CipherDataType");
	case SOAP_TYPE_PointerTo_ds__KeyInfo:
		return soap_in_PointerTo_ds__KeyInfo(soap, NULL, NULL, "ds:KeyInfo");
	case SOAP_TYPE_PointerToxenc__EncryptionMethodType:
		return soap_in_PointerToxenc__EncryptionMethodType(soap, NULL, NULL, "xenc:EncryptionMethodType");
	case SOAP_TYPE_PointerTods__X509IssuerSerialType:
		return soap_in_PointerTods__X509IssuerSerialType(soap, NULL, NULL, "ds:X509IssuerSerialType");
	case SOAP_TYPE_PointerTods__RSAKeyValueType:
		return soap_in_PointerTods__RSAKeyValueType(soap, NULL, NULL, "ds:RSAKeyValueType");
	case SOAP_TYPE_PointerTods__DSAKeyValueType:
		return soap_in_PointerTods__DSAKeyValueType(soap, NULL, NULL, "ds:DSAKeyValueType");
	case SOAP_TYPE_PointerTods__TransformType:
		return soap_in_PointerTods__TransformType(soap, NULL, NULL, "ds:TransformType");
	case SOAP_TYPE_PointerTods__DigestMethodType:
		return soap_in_PointerTods__DigestMethodType(soap, NULL, NULL, "ds:DigestMethodType");
	case SOAP_TYPE_PointerTods__TransformsType:
		return soap_in_PointerTods__TransformsType(soap, NULL, NULL, "ds:TransformsType");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToPointerTods__ReferenceType:
		return soap_in_PointerToPointerTods__ReferenceType(soap, NULL, NULL, "ds:ReferenceType");
	case SOAP_TYPE_PointerTods__ReferenceType:
		return soap_in_PointerTods__ReferenceType(soap, NULL, NULL, "ds:ReferenceType");
	case SOAP_TYPE_PointerTods__SignatureMethodType:
		return soap_in_PointerTods__SignatureMethodType(soap, NULL, NULL, "ds:SignatureMethodType");
	case SOAP_TYPE_PointerTods__CanonicalizationMethodType:
		return soap_in_PointerTods__CanonicalizationMethodType(soap, NULL, NULL, "ds:CanonicalizationMethodType");
	case SOAP_TYPE_PointerTo_wsse__SecurityTokenReference:
		return soap_in_PointerTo_wsse__SecurityTokenReference(soap, NULL, NULL, "wsse:SecurityTokenReference");
	case SOAP_TYPE_PointerTods__RetrievalMethodType:
		return soap_in_PointerTods__RetrievalMethodType(soap, NULL, NULL, "ds:RetrievalMethodType");
	case SOAP_TYPE_PointerTods__KeyValueType:
		return soap_in_PointerTods__KeyValueType(soap, NULL, NULL, "ds:KeyValueType");
	case SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces:
		return soap_in_PointerTo_c14n__InclusiveNamespaces(soap, NULL, NULL, "c14n:InclusiveNamespaces");
	case SOAP_TYPE_PointerTods__KeyInfoType:
		return soap_in_PointerTods__KeyInfoType(soap, NULL, NULL, "ds:KeyInfoType");
	case SOAP_TYPE_PointerTods__SignedInfoType:
		return soap_in_PointerTods__SignedInfoType(soap, NULL, NULL, "ds:SignedInfoType");
	case SOAP_TYPE_PointerTods__X509DataType:
		return soap_in_PointerTods__X509DataType(soap, NULL, NULL, "ds:X509DataType");
	case SOAP_TYPE_PointerTo_wsse__Embedded:
		return soap_in_PointerTo_wsse__Embedded(soap, NULL, NULL, "wsse:Embedded");
	case SOAP_TYPE_PointerTo_wsse__KeyIdentifier:
		return soap_in_PointerTo_wsse__KeyIdentifier(soap, NULL, NULL, "wsse:KeyIdentifier");
	case SOAP_TYPE_PointerTo_wsse__Reference:
		return soap_in_PointerTo_wsse__Reference(soap, NULL, NULL, "wsse:Reference");
	case SOAP_TYPE_PointerTo_wsse__Password:
		return soap_in_PointerTo_wsse__Password(soap, NULL, NULL, "wsse:Password");
	case SOAP_TYPE_PointerTo_mssamm__DivideResponse:
		return soap_in_PointerTo_mssamm__DivideResponse(soap, NULL, NULL, "mssamm:DivideResponse");
	case SOAP_TYPE_PointerTo_mssamm__Divide:
		return soap_in_PointerTo_mssamm__Divide(soap, NULL, NULL, "mssamm:Divide");
	case SOAP_TYPE_PointerTo_mssamm__MultiplyResponse:
		return soap_in_PointerTo_mssamm__MultiplyResponse(soap, NULL, NULL, "mssamm:MultiplyResponse");
	case SOAP_TYPE_PointerTo_mssamm__Multiply:
		return soap_in_PointerTo_mssamm__Multiply(soap, NULL, NULL, "mssamm:Multiply");
	case SOAP_TYPE_PointerTo_mssamm__SubtractResponse:
		return soap_in_PointerTo_mssamm__SubtractResponse(soap, NULL, NULL, "mssamm:SubtractResponse");
	case SOAP_TYPE_PointerTo_mssamm__Subtract:
		return soap_in_PointerTo_mssamm__Subtract(soap, NULL, NULL, "mssamm:Subtract");
	case SOAP_TYPE_PointerTo_mssamm__AddResponse:
		return soap_in_PointerTo_mssamm__AddResponse(soap, NULL, NULL, "mssamm:AddResponse");
	case SOAP_TYPE_PointerTo_mssamm__Add:
		return soap_in_PointerTo_mssamm__Add(soap, NULL, NULL, "mssamm:Add");
	case SOAP_TYPE_PointerTodouble:
		return soap_in_PointerTodouble(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
#else
	*type = 0;
#endif
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsc:FaultCodeType"))
		{	*type = SOAP_TYPE_wsc__FaultCodeType;
			return soap_in_wsc__FaultCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:FaultcodeEnum"))
		{	*type = SOAP_TYPE_wsse__FaultcodeEnum;
			return soap_in_wsse__FaultcodeEnum(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:tTimestampFault"))
		{	*type = SOAP_TYPE_wsu__tTimestampFault;
			return soap_in_wsu__tTimestampFault(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsc:PropertiesType"))
		{	*type = SOAP_TYPE_wsc__PropertiesType;
			return soap_in_wsc__PropertiesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsc:DerivedKeyTokenType"))
		{	*type = SOAP_TYPE_wsc__DerivedKeyTokenType;
			return soap_in_wsc__DerivedKeyTokenType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsc:SecurityContextTokenType"))
		{	*type = SOAP_TYPE_wsc__SecurityContextTokenType;
			return soap_in_wsc__SecurityContextTokenType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:EncryptionPropertyType"))
		{	*type = SOAP_TYPE_xenc__EncryptionPropertyType;
			return soap_in_xenc__EncryptionPropertyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:EncryptionPropertiesType"))
		{	*type = SOAP_TYPE_xenc__EncryptionPropertiesType;
			return soap_in_xenc__EncryptionPropertiesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:ReferenceType"))
		{	*type = SOAP_TYPE_xenc__ReferenceType;
			return soap_in_xenc__ReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:AgreementMethodType"))
		{	*type = SOAP_TYPE_xenc__AgreementMethodType;
			return soap_in_xenc__AgreementMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:EncryptedKeyType"))
		{	*type = SOAP_TYPE_xenc__EncryptedKeyType;
			return soap_in_xenc__EncryptedKeyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:EncryptedDataType"))
		{	*type = SOAP_TYPE_xenc__EncryptedDataType;
			return soap_in_xenc__EncryptedDataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:TransformsType"))
		{	*type = SOAP_TYPE_xenc__TransformsType;
			return soap_in_xenc__TransformsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:CipherReferenceType"))
		{	*type = SOAP_TYPE_xenc__CipherReferenceType;
			return soap_in_xenc__CipherReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:CipherDataType"))
		{	*type = SOAP_TYPE_xenc__CipherDataType;
			return soap_in_xenc__CipherDataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:EncryptionMethodType"))
		{	*type = SOAP_TYPE_xenc__EncryptionMethodType;
			return soap_in_xenc__EncryptionMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:EncryptedType"))
		{	*type = SOAP_TYPE_xenc__EncryptedType;
			return soap_in_xenc__EncryptedType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:RSAKeyValueType"))
		{	*type = SOAP_TYPE_ds__RSAKeyValueType;
			return soap_in_ds__RSAKeyValueType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:DSAKeyValueType"))
		{	*type = SOAP_TYPE_ds__DSAKeyValueType;
			return soap_in_ds__DSAKeyValueType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:X509IssuerSerialType"))
		{	*type = SOAP_TYPE_ds__X509IssuerSerialType;
			return soap_in_ds__X509IssuerSerialType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:RetrievalMethodType"))
		{	*type = SOAP_TYPE_ds__RetrievalMethodType;
			return soap_in_ds__RetrievalMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:KeyValueType"))
		{	*type = SOAP_TYPE_ds__KeyValueType;
			return soap_in_ds__KeyValueType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:DigestMethodType"))
		{	*type = SOAP_TYPE_ds__DigestMethodType;
			return soap_in_ds__DigestMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:TransformType"))
		{	*type = SOAP_TYPE_ds__TransformType;
			return soap_in_ds__TransformType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:TransformsType"))
		{	*type = SOAP_TYPE_ds__TransformsType;
			return soap_in_ds__TransformsType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:ReferenceType"))
		{	*type = SOAP_TYPE_ds__ReferenceType;
			return soap_in_ds__ReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:SignatureMethodType"))
		{	*type = SOAP_TYPE_ds__SignatureMethodType;
			return soap_in_ds__SignatureMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:CanonicalizationMethodType"))
		{	*type = SOAP_TYPE_ds__CanonicalizationMethodType;
			return soap_in_ds__CanonicalizationMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:KeyInfoType"))
		{	*type = SOAP_TYPE_ds__KeyInfoType;
			return soap_in_ds__KeyInfoType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:SignedInfoType"))
		{	*type = SOAP_TYPE_ds__SignedInfoType;
			return soap_in_ds__SignedInfoType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:SignatureType"))
		{	*type = SOAP_TYPE_ds__SignatureType;
			return soap_in_ds__SignatureType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:X509DataType"))
		{	*type = SOAP_TYPE_ds__X509DataType;
			return soap_in_ds__X509DataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsc:FaultCodeOpenEnumType"))
		{	char **s;
			*type = SOAP_TYPE_wsc__FaultCodeOpenEnumType;
			s = soap_in_wsc__FaultCodeOpenEnumType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "mssamm:DivideResponse"))
		{	*type = SOAP_TYPE__mssamm__DivideResponse;
			return soap_in__mssamm__DivideResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:Divide"))
		{	*type = SOAP_TYPE__mssamm__Divide;
			return soap_in__mssamm__Divide(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:MultiplyResponse"))
		{	*type = SOAP_TYPE__mssamm__MultiplyResponse;
			return soap_in__mssamm__MultiplyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:Multiply"))
		{	*type = SOAP_TYPE__mssamm__Multiply;
			return soap_in__mssamm__Multiply(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:SubtractResponse"))
		{	*type = SOAP_TYPE__mssamm__SubtractResponse;
			return soap_in__mssamm__SubtractResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:Subtract"))
		{	*type = SOAP_TYPE__mssamm__Subtract;
			return soap_in__mssamm__Subtract(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:AddResponse"))
		{	*type = SOAP_TYPE__mssamm__AddResponse;
			return soap_in__mssamm__AddResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamm:Add"))
		{	*type = SOAP_TYPE__mssamm__Add;
			return soap_in__mssamm__Add(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Security"))
		{	*type = SOAP_TYPE__wsse__Security;
			return soap_in__wsse__Security(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xenc:ReferenceList"))
		{	*type = SOAP_TYPE__xenc__ReferenceList;
			return soap_in__xenc__ReferenceList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:KeyInfo"))
		{	*type = SOAP_TYPE__ds__KeyInfo;
			return soap_in__ds__KeyInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:Transform"))
		{	*type = SOAP_TYPE__ds__Transform;
			return soap_in__ds__Transform(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "c14n:InclusiveNamespaces"))
		{	*type = SOAP_TYPE__c14n__InclusiveNamespaces;
			return soap_in__c14n__InclusiveNamespaces(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ds:Signature"))
		{	*type = SOAP_TYPE__ds__Signature;
			return soap_in__ds__Signature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:SecurityTokenReference"))
		{	*type = SOAP_TYPE__wsse__SecurityTokenReference;
			return soap_in__wsse__SecurityTokenReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:KeyIdentifier"))
		{	*type = SOAP_TYPE__wsse__KeyIdentifier;
			return soap_in__wsse__KeyIdentifier(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Embedded"))
		{	*type = SOAP_TYPE__wsse__Embedded;
			return soap_in__wsse__Embedded(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Reference"))
		{	*type = SOAP_TYPE__wsse__Reference;
			return soap_in__wsse__Reference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:BinarySecurityToken"))
		{	*type = SOAP_TYPE__wsse__BinarySecurityToken;
			return soap_in__wsse__BinarySecurityToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:Password"))
		{	*type = SOAP_TYPE__wsse__Password;
			return soap_in__wsse__Password(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsse:UsernameToken"))
		{	*type = SOAP_TYPE__wsse__UsernameToken;
			return soap_in__wsse__UsernameToken(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsu:Timestamp"))
		{	*type = SOAP_TYPE__wsu__Timestamp;
			return soap_in__wsu__Timestamp(soap, NULL, NULL, NULL);
		}
#ifndef WITH_NOIDREF
	}
#endif
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_wsc__FaultCodeType:
		return soap_out_wsc__FaultCodeType(soap, tag, id, (const enum wsc__FaultCodeType *)ptr, "wsc:FaultCodeType");
	case SOAP_TYPE_wsse__FaultcodeEnum:
		return soap_out_wsse__FaultcodeEnum(soap, tag, id, (const enum wsse__FaultcodeEnum *)ptr, "wsse:FaultcodeEnum");
	case SOAP_TYPE_wsu__tTimestampFault:
		return soap_out_wsu__tTimestampFault(soap, tag, id, (const enum wsu__tTimestampFault *)ptr, "wsu:tTimestampFault");
	case SOAP_TYPE__mssamm__DivideResponse:
		return ((_mssamm__DivideResponse *)ptr)->soap_out(soap, "mssamm:DivideResponse", id, NULL);
	case SOAP_TYPE__mssamm__Divide:
		return ((_mssamm__Divide *)ptr)->soap_out(soap, "mssamm:Divide", id, NULL);
	case SOAP_TYPE__mssamm__MultiplyResponse:
		return ((_mssamm__MultiplyResponse *)ptr)->soap_out(soap, "mssamm:MultiplyResponse", id, NULL);
	case SOAP_TYPE__mssamm__Multiply:
		return ((_mssamm__Multiply *)ptr)->soap_out(soap, "mssamm:Multiply", id, NULL);
	case SOAP_TYPE__mssamm__SubtractResponse:
		return ((_mssamm__SubtractResponse *)ptr)->soap_out(soap, "mssamm:SubtractResponse", id, NULL);
	case SOAP_TYPE__mssamm__Subtract:
		return ((_mssamm__Subtract *)ptr)->soap_out(soap, "mssamm:Subtract", id, NULL);
	case SOAP_TYPE__mssamm__AddResponse:
		return ((_mssamm__AddResponse *)ptr)->soap_out(soap, "mssamm:AddResponse", id, NULL);
	case SOAP_TYPE__mssamm__Add:
		return ((_mssamm__Add *)ptr)->soap_out(soap, "mssamm:Add", id, NULL);
	case SOAP_TYPE__wsse__Security:
		return soap_out__wsse__Security(soap, "wsse:Security", id, (const struct _wsse__Security *)ptr, NULL);
	case SOAP_TYPE_wsc__PropertiesType:
		return soap_out_wsc__PropertiesType(soap, tag, id, (const struct wsc__PropertiesType *)ptr, "wsc:PropertiesType");
	case SOAP_TYPE_wsc__DerivedKeyTokenType:
		return soap_out_wsc__DerivedKeyTokenType(soap, tag, id, (const struct wsc__DerivedKeyTokenType *)ptr, "wsc:DerivedKeyTokenType");
	case SOAP_TYPE_wsc__SecurityContextTokenType:
		return soap_out_wsc__SecurityContextTokenType(soap, tag, id, (const struct wsc__SecurityContextTokenType *)ptr, "wsc:SecurityContextTokenType");
	case SOAP_TYPE__xenc__ReferenceList:
		return soap_out__xenc__ReferenceList(soap, "xenc:ReferenceList", id, (const struct _xenc__ReferenceList *)ptr, NULL);
	case SOAP_TYPE_xenc__EncryptionPropertyType:
		return soap_out_xenc__EncryptionPropertyType(soap, tag, id, (const struct xenc__EncryptionPropertyType *)ptr, "xenc:EncryptionPropertyType");
	case SOAP_TYPE_xenc__EncryptionPropertiesType:
		return soap_out_xenc__EncryptionPropertiesType(soap, tag, id, (const struct xenc__EncryptionPropertiesType *)ptr, "xenc:EncryptionPropertiesType");
	case SOAP_TYPE_xenc__ReferenceType:
		return soap_out_xenc__ReferenceType(soap, tag, id, (const struct xenc__ReferenceType *)ptr, "xenc:ReferenceType");
	case SOAP_TYPE_xenc__AgreementMethodType:
		return soap_out_xenc__AgreementMethodType(soap, tag, id, (const struct xenc__AgreementMethodType *)ptr, "xenc:AgreementMethodType");
	case SOAP_TYPE_xenc__EncryptedKeyType:
		return soap_out_xenc__EncryptedKeyType(soap, tag, id, (const struct xenc__EncryptedKeyType *)ptr, "xenc:EncryptedKeyType");
	case SOAP_TYPE_xenc__EncryptedDataType:
		return soap_out_xenc__EncryptedDataType(soap, tag, id, (const struct xenc__EncryptedDataType *)ptr, "xenc:EncryptedDataType");
	case SOAP_TYPE_xenc__TransformsType:
		return soap_out_xenc__TransformsType(soap, tag, id, (const struct xenc__TransformsType *)ptr, "xenc:TransformsType");
	case SOAP_TYPE_xenc__CipherReferenceType:
		return soap_out_xenc__CipherReferenceType(soap, tag, id, (const struct xenc__CipherReferenceType *)ptr, "xenc:CipherReferenceType");
	case SOAP_TYPE_xenc__CipherDataType:
		return soap_out_xenc__CipherDataType(soap, tag, id, (const struct xenc__CipherDataType *)ptr, "xenc:CipherDataType");
	case SOAP_TYPE_xenc__EncryptionMethodType:
		return soap_out_xenc__EncryptionMethodType(soap, tag, id, (const struct xenc__EncryptionMethodType *)ptr, "xenc:EncryptionMethodType");
	case SOAP_TYPE_xenc__EncryptedType:
		return soap_out_xenc__EncryptedType(soap, tag, id, (const struct xenc__EncryptedType *)ptr, "xenc:EncryptedType");
	case SOAP_TYPE_ds__RSAKeyValueType:
		return soap_out_ds__RSAKeyValueType(soap, tag, id, (const struct ds__RSAKeyValueType *)ptr, "ds:RSAKeyValueType");
	case SOAP_TYPE_ds__DSAKeyValueType:
		return soap_out_ds__DSAKeyValueType(soap, tag, id, (const struct ds__DSAKeyValueType *)ptr, "ds:DSAKeyValueType");
	case SOAP_TYPE_ds__X509IssuerSerialType:
		return soap_out_ds__X509IssuerSerialType(soap, tag, id, (const struct ds__X509IssuerSerialType *)ptr, "ds:X509IssuerSerialType");
	case SOAP_TYPE__ds__KeyInfo:
		return soap_out__ds__KeyInfo(soap, "ds:KeyInfo", id, (const struct ds__KeyInfoType *)ptr, NULL);
	case SOAP_TYPE_ds__RetrievalMethodType:
		return soap_out_ds__RetrievalMethodType(soap, tag, id, (const struct ds__RetrievalMethodType *)ptr, "ds:RetrievalMethodType");
	case SOAP_TYPE_ds__KeyValueType:
		return soap_out_ds__KeyValueType(soap, tag, id, (const struct ds__KeyValueType *)ptr, "ds:KeyValueType");
	case SOAP_TYPE_ds__DigestMethodType:
		return soap_out_ds__DigestMethodType(soap, tag, id, (const struct ds__DigestMethodType *)ptr, "ds:DigestMethodType");
	case SOAP_TYPE__ds__Transform:
		return soap_out__ds__Transform(soap, "ds:Transform", id, (const struct ds__TransformType *)ptr, NULL);
	case SOAP_TYPE_ds__TransformType:
		return soap_out_ds__TransformType(soap, tag, id, (const struct ds__TransformType *)ptr, "ds:TransformType");
	case SOAP_TYPE__c14n__InclusiveNamespaces:
		return soap_out__c14n__InclusiveNamespaces(soap, "c14n:InclusiveNamespaces", id, (const struct _c14n__InclusiveNamespaces *)ptr, NULL);
	case SOAP_TYPE_ds__TransformsType:
		return soap_out_ds__TransformsType(soap, tag, id, (const struct ds__TransformsType *)ptr, "ds:TransformsType");
	case SOAP_TYPE_ds__ReferenceType:
		return soap_out_ds__ReferenceType(soap, tag, id, (const struct ds__ReferenceType *)ptr, "ds:ReferenceType");
	case SOAP_TYPE_ds__SignatureMethodType:
		return soap_out_ds__SignatureMethodType(soap, tag, id, (const struct ds__SignatureMethodType *)ptr, "ds:SignatureMethodType");
	case SOAP_TYPE_ds__CanonicalizationMethodType:
		return soap_out_ds__CanonicalizationMethodType(soap, tag, id, (const struct ds__CanonicalizationMethodType *)ptr, "ds:CanonicalizationMethodType");
	case SOAP_TYPE__ds__Signature:
		return soap_out__ds__Signature(soap, "ds:Signature", id, (const struct ds__SignatureType *)ptr, NULL);
	case SOAP_TYPE_ds__KeyInfoType:
		return soap_out_ds__KeyInfoType(soap, tag, id, (const struct ds__KeyInfoType *)ptr, "ds:KeyInfoType");
	case SOAP_TYPE_ds__SignedInfoType:
		return soap_out_ds__SignedInfoType(soap, tag, id, (const struct ds__SignedInfoType *)ptr, "ds:SignedInfoType");
	case SOAP_TYPE_ds__SignatureType:
		return soap_out_ds__SignatureType(soap, tag, id, (const struct ds__SignatureType *)ptr, "ds:SignatureType");
	case SOAP_TYPE_ds__X509DataType:
		return soap_out_ds__X509DataType(soap, tag, id, (const struct ds__X509DataType *)ptr, "ds:X509DataType");
	case SOAP_TYPE__wsse__SecurityTokenReference:
		return soap_out__wsse__SecurityTokenReference(soap, "wsse:SecurityTokenReference", id, (const struct _wsse__SecurityTokenReference *)ptr, NULL);
	case SOAP_TYPE__wsse__KeyIdentifier:
		return soap_out__wsse__KeyIdentifier(soap, "wsse:KeyIdentifier", id, (const struct _wsse__KeyIdentifier *)ptr, NULL);
	case SOAP_TYPE__wsse__Embedded:
		return soap_out__wsse__Embedded(soap, "wsse:Embedded", id, (const struct _wsse__Embedded *)ptr, NULL);
	case SOAP_TYPE__wsse__Reference:
		return soap_out__wsse__Reference(soap, "wsse:Reference", id, (const struct _wsse__Reference *)ptr, NULL);
	case SOAP_TYPE__wsse__BinarySecurityToken:
		return soap_out__wsse__BinarySecurityToken(soap, "wsse:BinarySecurityToken", id, (const struct _wsse__BinarySecurityToken *)ptr, NULL);
	case SOAP_TYPE__wsse__Password:
		return soap_out__wsse__Password(soap, "wsse:Password", id, (const struct _wsse__Password *)ptr, NULL);
	case SOAP_TYPE__wsse__UsernameToken:
		return soap_out__wsse__UsernameToken(soap, "wsse:UsernameToken", id, (const struct _wsse__UsernameToken *)ptr, NULL);
	case SOAP_TYPE__wsu__Timestamp:
		return soap_out__wsu__Timestamp(soap, "wsu:Timestamp", id, (const struct _wsu__Timestamp *)ptr, NULL);
	case SOAP_TYPE_PointerTo_wsse__Security:
		return soap_out_PointerTo_wsse__Security(soap, tag, id, (struct _wsse__Security *const*)ptr, "wsse:Security");
	case SOAP_TYPE_PointerTods__SignatureType:
		return soap_out_PointerTods__SignatureType(soap, tag, id, (struct ds__SignatureType *const*)ptr, "ds:SignatureType");
	case SOAP_TYPE_PointerTowsc__SecurityContextTokenType:
		return soap_out_PointerTowsc__SecurityContextTokenType(soap, tag, id, (struct wsc__SecurityContextTokenType *const*)ptr, "wsc:SecurityContextTokenType");
	case SOAP_TYPE_PointerToxenc__EncryptedKeyType:
		return soap_out_PointerToxenc__EncryptedKeyType(soap, tag, id, (struct xenc__EncryptedKeyType *const*)ptr, "xenc:EncryptedKeyType");
	case SOAP_TYPE_PointerTo_wsse__BinarySecurityToken:
		return soap_out_PointerTo_wsse__BinarySecurityToken(soap, tag, id, (struct _wsse__BinarySecurityToken *const*)ptr, "wsse:BinarySecurityToken");
	case SOAP_TYPE_PointerTo_wsse__UsernameToken:
		return soap_out_PointerTo_wsse__UsernameToken(soap, tag, id, (struct _wsse__UsernameToken *const*)ptr, "wsse:UsernameToken");
	case SOAP_TYPE_PointerTo_wsu__Timestamp:
		return soap_out_PointerTo_wsu__Timestamp(soap, tag, id, (struct _wsu__Timestamp *const*)ptr, "wsu:Timestamp");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_out_PointerTounsignedLONG64(soap, tag, id, (ULONG64 *const*)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_PointerTowsc__PropertiesType:
		return soap_out_PointerTowsc__PropertiesType(soap, tag, id, (struct wsc__PropertiesType *const*)ptr, "wsc:PropertiesType");
	case SOAP_TYPE_wsc__FaultCodeOpenEnumType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsc:FaultCodeOpenEnumType");
	case SOAP_TYPE_PointerTo_xenc__ReferenceList:
		return soap_out_PointerTo_xenc__ReferenceList(soap, tag, id, (struct _xenc__ReferenceList *const*)ptr, "xenc:ReferenceList");
	case SOAP_TYPE_PointerToxenc__ReferenceType:
		return soap_out_PointerToxenc__ReferenceType(soap, tag, id, (struct xenc__ReferenceType *const*)ptr, "xenc:ReferenceType");
	case SOAP_TYPE_PointerToxenc__EncryptionPropertyType:
		return soap_out_PointerToxenc__EncryptionPropertyType(soap, tag, id, (struct xenc__EncryptionPropertyType *const*)ptr, "xenc:EncryptionPropertyType");
	case SOAP_TYPE_PointerToxenc__TransformsType:
		return soap_out_PointerToxenc__TransformsType(soap, tag, id, (struct xenc__TransformsType *const*)ptr, "xenc:TransformsType");
	case SOAP_TYPE_PointerToxenc__CipherReferenceType:
		return soap_out_PointerToxenc__CipherReferenceType(soap, tag, id, (struct xenc__CipherReferenceType *const*)ptr, "xenc:CipherReferenceType");
	case SOAP_TYPE_PointerToxenc__EncryptionPropertiesType:
		return soap_out_PointerToxenc__EncryptionPropertiesType(soap, tag, id, (struct xenc__EncryptionPropertiesType *const*)ptr, "xenc:EncryptionPropertiesType");
	case SOAP_TYPE_PointerToxenc__CipherDataType:
		return soap_out_PointerToxenc__CipherDataType(soap, tag, id, (struct xenc__CipherDataType *const*)ptr, "xenc:CipherDataType");
	case SOAP_TYPE_PointerTo_ds__KeyInfo:
		return soap_out_PointerTo_ds__KeyInfo(soap, tag, id, (struct ds__KeyInfoType *const*)ptr, "ds:KeyInfo");
	case SOAP_TYPE_PointerToxenc__EncryptionMethodType:
		return soap_out_PointerToxenc__EncryptionMethodType(soap, tag, id, (struct xenc__EncryptionMethodType *const*)ptr, "xenc:EncryptionMethodType");
	case SOAP_TYPE_PointerTods__X509IssuerSerialType:
		return soap_out_PointerTods__X509IssuerSerialType(soap, tag, id, (struct ds__X509IssuerSerialType *const*)ptr, "ds:X509IssuerSerialType");
	case SOAP_TYPE_PointerTods__RSAKeyValueType:
		return soap_out_PointerTods__RSAKeyValueType(soap, tag, id, (struct ds__RSAKeyValueType *const*)ptr, "ds:RSAKeyValueType");
	case SOAP_TYPE_PointerTods__DSAKeyValueType:
		return soap_out_PointerTods__DSAKeyValueType(soap, tag, id, (struct ds__DSAKeyValueType *const*)ptr, "ds:DSAKeyValueType");
	case SOAP_TYPE_PointerTods__TransformType:
		return soap_out_PointerTods__TransformType(soap, tag, id, (struct ds__TransformType *const*)ptr, "ds:TransformType");
	case SOAP_TYPE_PointerTods__DigestMethodType:
		return soap_out_PointerTods__DigestMethodType(soap, tag, id, (struct ds__DigestMethodType *const*)ptr, "ds:DigestMethodType");
	case SOAP_TYPE_PointerTods__TransformsType:
		return soap_out_PointerTods__TransformsType(soap, tag, id, (struct ds__TransformsType *const*)ptr, "ds:TransformsType");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToPointerTods__ReferenceType:
		return soap_out_PointerToPointerTods__ReferenceType(soap, tag, id, (struct ds__ReferenceType **const*)ptr, "ds:ReferenceType");
	case SOAP_TYPE_PointerTods__ReferenceType:
		return soap_out_PointerTods__ReferenceType(soap, tag, id, (struct ds__ReferenceType *const*)ptr, "ds:ReferenceType");
	case SOAP_TYPE_PointerTods__SignatureMethodType:
		return soap_out_PointerTods__SignatureMethodType(soap, tag, id, (struct ds__SignatureMethodType *const*)ptr, "ds:SignatureMethodType");
	case SOAP_TYPE_PointerTods__CanonicalizationMethodType:
		return soap_out_PointerTods__CanonicalizationMethodType(soap, tag, id, (struct ds__CanonicalizationMethodType *const*)ptr, "ds:CanonicalizationMethodType");
	case SOAP_TYPE_PointerTo_wsse__SecurityTokenReference:
		return soap_out_PointerTo_wsse__SecurityTokenReference(soap, tag, id, (struct _wsse__SecurityTokenReference *const*)ptr, "wsse:SecurityTokenReference");
	case SOAP_TYPE_PointerTods__RetrievalMethodType:
		return soap_out_PointerTods__RetrievalMethodType(soap, tag, id, (struct ds__RetrievalMethodType *const*)ptr, "ds:RetrievalMethodType");
	case SOAP_TYPE_PointerTods__KeyValueType:
		return soap_out_PointerTods__KeyValueType(soap, tag, id, (struct ds__KeyValueType *const*)ptr, "ds:KeyValueType");
	case SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces:
		return soap_out_PointerTo_c14n__InclusiveNamespaces(soap, tag, id, (struct _c14n__InclusiveNamespaces *const*)ptr, "c14n:InclusiveNamespaces");
	case SOAP_TYPE_PointerTods__KeyInfoType:
		return soap_out_PointerTods__KeyInfoType(soap, tag, id, (struct ds__KeyInfoType *const*)ptr, "ds:KeyInfoType");
	case SOAP_TYPE_PointerTods__SignedInfoType:
		return soap_out_PointerTods__SignedInfoType(soap, tag, id, (struct ds__SignedInfoType *const*)ptr, "ds:SignedInfoType");
	case SOAP_TYPE_PointerTods__X509DataType:
		return soap_out_PointerTods__X509DataType(soap, tag, id, (struct ds__X509DataType *const*)ptr, "ds:X509DataType");
	case SOAP_TYPE_PointerTo_wsse__Embedded:
		return soap_out_PointerTo_wsse__Embedded(soap, tag, id, (struct _wsse__Embedded *const*)ptr, "wsse:Embedded");
	case SOAP_TYPE_PointerTo_wsse__KeyIdentifier:
		return soap_out_PointerTo_wsse__KeyIdentifier(soap, tag, id, (struct _wsse__KeyIdentifier *const*)ptr, "wsse:KeyIdentifier");
	case SOAP_TYPE_PointerTo_wsse__Reference:
		return soap_out_PointerTo_wsse__Reference(soap, tag, id, (struct _wsse__Reference *const*)ptr, "wsse:Reference");
	case SOAP_TYPE_PointerTo_wsse__Password:
		return soap_out_PointerTo_wsse__Password(soap, tag, id, (struct _wsse__Password *const*)ptr, "wsse:Password");
	case SOAP_TYPE_PointerTo_mssamm__DivideResponse:
		return soap_out_PointerTo_mssamm__DivideResponse(soap, tag, id, (_mssamm__DivideResponse *const*)ptr, "mssamm:DivideResponse");
	case SOAP_TYPE_PointerTo_mssamm__Divide:
		return soap_out_PointerTo_mssamm__Divide(soap, tag, id, (_mssamm__Divide *const*)ptr, "mssamm:Divide");
	case SOAP_TYPE_PointerTo_mssamm__MultiplyResponse:
		return soap_out_PointerTo_mssamm__MultiplyResponse(soap, tag, id, (_mssamm__MultiplyResponse *const*)ptr, "mssamm:MultiplyResponse");
	case SOAP_TYPE_PointerTo_mssamm__Multiply:
		return soap_out_PointerTo_mssamm__Multiply(soap, tag, id, (_mssamm__Multiply *const*)ptr, "mssamm:Multiply");
	case SOAP_TYPE_PointerTo_mssamm__SubtractResponse:
		return soap_out_PointerTo_mssamm__SubtractResponse(soap, tag, id, (_mssamm__SubtractResponse *const*)ptr, "mssamm:SubtractResponse");
	case SOAP_TYPE_PointerTo_mssamm__Subtract:
		return soap_out_PointerTo_mssamm__Subtract(soap, tag, id, (_mssamm__Subtract *const*)ptr, "mssamm:Subtract");
	case SOAP_TYPE_PointerTo_mssamm__AddResponse:
		return soap_out_PointerTo_mssamm__AddResponse(soap, tag, id, (_mssamm__AddResponse *const*)ptr, "mssamm:AddResponse");
	case SOAP_TYPE_PointerTo_mssamm__Add:
		return soap_out_PointerTo_mssamm__Add(soap, tag, id, (_mssamm__Add *const*)ptr, "mssamm:Add");
	case SOAP_TYPE_PointerTodouble:
		return soap_out_PointerTodouble(soap, tag, id, (double *const*)ptr, "xsd:double");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE__mssamm__DivideResponse:
		((_mssamm__DivideResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__Divide:
		((_mssamm__Divide *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__MultiplyResponse:
		((_mssamm__MultiplyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__Multiply:
		((_mssamm__Multiply *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__SubtractResponse:
		((_mssamm__SubtractResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__Subtract:
		((_mssamm__Subtract *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__AddResponse:
		((_mssamm__AddResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamm__Add:
		((_mssamm__Add *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__wsse__Security:
		soap_serialize__wsse__Security(soap, (const struct _wsse__Security *)ptr);
		break;
	case SOAP_TYPE___wsc__DerivedKeyTokenType_sequence:
		soap_serialize___wsc__DerivedKeyTokenType_sequence(soap, (const struct __wsc__DerivedKeyTokenType_sequence *)ptr);
		break;
	case SOAP_TYPE_wsc__PropertiesType:
		soap_serialize_wsc__PropertiesType(soap, (const struct wsc__PropertiesType *)ptr);
		break;
	case SOAP_TYPE_wsc__DerivedKeyTokenType:
		soap_serialize_wsc__DerivedKeyTokenType(soap, (const struct wsc__DerivedKeyTokenType *)ptr);
		break;
	case SOAP_TYPE_wsc__SecurityContextTokenType:
		soap_serialize_wsc__SecurityContextTokenType(soap, (const struct wsc__SecurityContextTokenType *)ptr);
		break;
	case SOAP_TYPE___xenc__union_ReferenceList:
		soap_serialize___xenc__union_ReferenceList(soap, (const struct __xenc__union_ReferenceList *)ptr);
		break;
	case SOAP_TYPE__xenc__ReferenceList:
		soap_serialize__xenc__ReferenceList(soap, (const struct _xenc__ReferenceList *)ptr);
		break;
	case SOAP_TYPE_xenc__EncryptionPropertyType:
		soap_serialize_xenc__EncryptionPropertyType(soap, (const struct xenc__EncryptionPropertyType *)ptr);
		break;
	case SOAP_TYPE_xenc__EncryptionPropertiesType:
		soap_serialize_xenc__EncryptionPropertiesType(soap, (const struct xenc__EncryptionPropertiesType *)ptr);
		break;
	case SOAP_TYPE_xenc__ReferenceType:
		soap_serialize_xenc__ReferenceType(soap, (const struct xenc__ReferenceType *)ptr);
		break;
	case SOAP_TYPE_xenc__AgreementMethodType:
		soap_serialize_xenc__AgreementMethodType(soap, (const struct xenc__AgreementMethodType *)ptr);
		break;
	case SOAP_TYPE_xenc__EncryptedKeyType:
		soap_serialize_xenc__EncryptedKeyType(soap, (const struct xenc__EncryptedKeyType *)ptr);
		break;
	case SOAP_TYPE_xenc__EncryptedDataType:
		soap_serialize_xenc__EncryptedDataType(soap, (const struct xenc__EncryptedDataType *)ptr);
		break;
	case SOAP_TYPE_xenc__TransformsType:
		soap_serialize_xenc__TransformsType(soap, (const struct xenc__TransformsType *)ptr);
		break;
	case SOAP_TYPE_xenc__CipherReferenceType:
		soap_serialize_xenc__CipherReferenceType(soap, (const struct xenc__CipherReferenceType *)ptr);
		break;
	case SOAP_TYPE_xenc__CipherDataType:
		soap_serialize_xenc__CipherDataType(soap, (const struct xenc__CipherDataType *)ptr);
		break;
	case SOAP_TYPE_xenc__EncryptionMethodType:
		soap_serialize_xenc__EncryptionMethodType(soap, (const struct xenc__EncryptionMethodType *)ptr);
		break;
	case SOAP_TYPE_xenc__EncryptedType:
		soap_serialize_xenc__EncryptedType(soap, (const struct xenc__EncryptedType *)ptr);
		break;
	case SOAP_TYPE_ds__RSAKeyValueType:
		soap_serialize_ds__RSAKeyValueType(soap, (const struct ds__RSAKeyValueType *)ptr);
		break;
	case SOAP_TYPE_ds__DSAKeyValueType:
		soap_serialize_ds__DSAKeyValueType(soap, (const struct ds__DSAKeyValueType *)ptr);
		break;
	case SOAP_TYPE_ds__X509IssuerSerialType:
		soap_serialize_ds__X509IssuerSerialType(soap, (const struct ds__X509IssuerSerialType *)ptr);
		break;
	case SOAP_TYPE__ds__KeyInfo:
		soap_serialize__ds__KeyInfo(soap, (const struct ds__KeyInfoType *)ptr);
		break;
	case SOAP_TYPE_ds__RetrievalMethodType:
		soap_serialize_ds__RetrievalMethodType(soap, (const struct ds__RetrievalMethodType *)ptr);
		break;
	case SOAP_TYPE_ds__KeyValueType:
		soap_serialize_ds__KeyValueType(soap, (const struct ds__KeyValueType *)ptr);
		break;
	case SOAP_TYPE_ds__DigestMethodType:
		soap_serialize_ds__DigestMethodType(soap, (const struct ds__DigestMethodType *)ptr);
		break;
	case SOAP_TYPE__ds__Transform:
		soap_serialize__ds__Transform(soap, (const struct ds__TransformType *)ptr);
		break;
	case SOAP_TYPE_ds__TransformType:
		soap_serialize_ds__TransformType(soap, (const struct ds__TransformType *)ptr);
		break;
	case SOAP_TYPE__c14n__InclusiveNamespaces:
		soap_serialize__c14n__InclusiveNamespaces(soap, (const struct _c14n__InclusiveNamespaces *)ptr);
		break;
	case SOAP_TYPE_ds__TransformsType:
		soap_serialize_ds__TransformsType(soap, (const struct ds__TransformsType *)ptr);
		break;
	case SOAP_TYPE_ds__ReferenceType:
		soap_serialize_ds__ReferenceType(soap, (const struct ds__ReferenceType *)ptr);
		break;
	case SOAP_TYPE_ds__SignatureMethodType:
		soap_serialize_ds__SignatureMethodType(soap, (const struct ds__SignatureMethodType *)ptr);
		break;
	case SOAP_TYPE_ds__CanonicalizationMethodType:
		soap_serialize_ds__CanonicalizationMethodType(soap, (const struct ds__CanonicalizationMethodType *)ptr);
		break;
	case SOAP_TYPE__ds__Signature:
		soap_serialize__ds__Signature(soap, (const struct ds__SignatureType *)ptr);
		break;
	case SOAP_TYPE_ds__KeyInfoType:
		soap_serialize_ds__KeyInfoType(soap, (const struct ds__KeyInfoType *)ptr);
		break;
	case SOAP_TYPE_ds__SignedInfoType:
		soap_serialize_ds__SignedInfoType(soap, (const struct ds__SignedInfoType *)ptr);
		break;
	case SOAP_TYPE_ds__SignatureType:
		soap_serialize_ds__SignatureType(soap, (const struct ds__SignatureType *)ptr);
		break;
	case SOAP_TYPE_ds__X509DataType:
		soap_serialize_ds__X509DataType(soap, (const struct ds__X509DataType *)ptr);
		break;
	case SOAP_TYPE__wsse__SecurityTokenReference:
		soap_serialize__wsse__SecurityTokenReference(soap, (const struct _wsse__SecurityTokenReference *)ptr);
		break;
	case SOAP_TYPE__wsse__KeyIdentifier:
		soap_serialize__wsse__KeyIdentifier(soap, (const struct _wsse__KeyIdentifier *)ptr);
		break;
	case SOAP_TYPE__wsse__Embedded:
		soap_serialize__wsse__Embedded(soap, (const struct _wsse__Embedded *)ptr);
		break;
	case SOAP_TYPE__wsse__Reference:
		soap_serialize__wsse__Reference(soap, (const struct _wsse__Reference *)ptr);
		break;
	case SOAP_TYPE__wsse__BinarySecurityToken:
		soap_serialize__wsse__BinarySecurityToken(soap, (const struct _wsse__BinarySecurityToken *)ptr);
		break;
	case SOAP_TYPE__wsse__Password:
		soap_serialize__wsse__Password(soap, (const struct _wsse__Password *)ptr);
		break;
	case SOAP_TYPE__wsse__UsernameToken:
		soap_serialize__wsse__UsernameToken(soap, (const struct _wsse__UsernameToken *)ptr);
		break;
	case SOAP_TYPE__wsu__Timestamp:
		soap_serialize__wsu__Timestamp(soap, (const struct _wsu__Timestamp *)ptr);
		break;
	case SOAP_TYPE___tempuri__Divide:
		soap_serialize___tempuri__Divide(soap, (const struct __tempuri__Divide *)ptr);
		break;
	case SOAP_TYPE___tempuri__Multiply:
		soap_serialize___tempuri__Multiply(soap, (const struct __tempuri__Multiply *)ptr);
		break;
	case SOAP_TYPE___tempuri__Subtract:
		soap_serialize___tempuri__Subtract(soap, (const struct __tempuri__Subtract *)ptr);
		break;
	case SOAP_TYPE___tempuri__Add:
		soap_serialize___tempuri__Add(soap, (const struct __tempuri__Add *)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__Security:
		soap_serialize_PointerTo_wsse__Security(soap, (struct _wsse__Security *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__SignatureType:
		soap_serialize_PointerTods__SignatureType(soap, (struct ds__SignatureType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsc__SecurityContextTokenType:
		soap_serialize_PointerTowsc__SecurityContextTokenType(soap, (struct wsc__SecurityContextTokenType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__EncryptedKeyType:
		soap_serialize_PointerToxenc__EncryptedKeyType(soap, (struct xenc__EncryptedKeyType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__BinarySecurityToken:
		soap_serialize_PointerTo_wsse__BinarySecurityToken(soap, (struct _wsse__BinarySecurityToken *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__UsernameToken:
		soap_serialize_PointerTo_wsse__UsernameToken(soap, (struct _wsse__UsernameToken *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsu__Timestamp:
		soap_serialize_PointerTo_wsu__Timestamp(soap, (struct _wsu__Timestamp *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo__wsc__DerivedKeyTokenType_sequence:
		soap_serialize_PointerTo__wsc__DerivedKeyTokenType_sequence(soap, (struct __wsc__DerivedKeyTokenType_sequence *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedLONG64:
		soap_serialize_PointerTounsignedLONG64(soap, (ULONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsc__PropertiesType:
		soap_serialize_PointerTowsc__PropertiesType(soap, (struct wsc__PropertiesType *const*)ptr);
		break;
	case SOAP_TYPE_wsc__FaultCodeOpenEnumType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTo_xenc__ReferenceList:
		soap_serialize_PointerTo_xenc__ReferenceList(soap, (struct _xenc__ReferenceList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo__xenc__union_ReferenceList:
		soap_serialize_PointerTo__xenc__union_ReferenceList(soap, (struct __xenc__union_ReferenceList *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__ReferenceType:
		soap_serialize_PointerToxenc__ReferenceType(soap, (struct xenc__ReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__EncryptionPropertyType:
		soap_serialize_PointerToxenc__EncryptionPropertyType(soap, (struct xenc__EncryptionPropertyType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__TransformsType:
		soap_serialize_PointerToxenc__TransformsType(soap, (struct xenc__TransformsType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__CipherReferenceType:
		soap_serialize_PointerToxenc__CipherReferenceType(soap, (struct xenc__CipherReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__EncryptionPropertiesType:
		soap_serialize_PointerToxenc__EncryptionPropertiesType(soap, (struct xenc__EncryptionPropertiesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__CipherDataType:
		soap_serialize_PointerToxenc__CipherDataType(soap, (struct xenc__CipherDataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ds__KeyInfo:
		soap_serialize_PointerTo_ds__KeyInfo(soap, (struct ds__KeyInfoType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxenc__EncryptionMethodType:
		soap_serialize_PointerToxenc__EncryptionMethodType(soap, (struct xenc__EncryptionMethodType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__X509IssuerSerialType:
		soap_serialize_PointerTods__X509IssuerSerialType(soap, (struct ds__X509IssuerSerialType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__RSAKeyValueType:
		soap_serialize_PointerTods__RSAKeyValueType(soap, (struct ds__RSAKeyValueType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__DSAKeyValueType:
		soap_serialize_PointerTods__DSAKeyValueType(soap, (struct ds__DSAKeyValueType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__TransformType:
		soap_serialize_PointerTods__TransformType(soap, (struct ds__TransformType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__DigestMethodType:
		soap_serialize_PointerTods__DigestMethodType(soap, (struct ds__DigestMethodType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__TransformsType:
		soap_serialize_PointerTods__TransformsType(soap, (struct ds__TransformsType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTods__ReferenceType:
		soap_serialize_PointerToPointerTods__ReferenceType(soap, (struct ds__ReferenceType **const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__ReferenceType:
		soap_serialize_PointerTods__ReferenceType(soap, (struct ds__ReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__SignatureMethodType:
		soap_serialize_PointerTods__SignatureMethodType(soap, (struct ds__SignatureMethodType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__CanonicalizationMethodType:
		soap_serialize_PointerTods__CanonicalizationMethodType(soap, (struct ds__CanonicalizationMethodType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__SecurityTokenReference:
		soap_serialize_PointerTo_wsse__SecurityTokenReference(soap, (struct _wsse__SecurityTokenReference *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__RetrievalMethodType:
		soap_serialize_PointerTods__RetrievalMethodType(soap, (struct ds__RetrievalMethodType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__KeyValueType:
		soap_serialize_PointerTods__KeyValueType(soap, (struct ds__KeyValueType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces:
		soap_serialize_PointerTo_c14n__InclusiveNamespaces(soap, (struct _c14n__InclusiveNamespaces *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__KeyInfoType:
		soap_serialize_PointerTods__KeyInfoType(soap, (struct ds__KeyInfoType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__SignedInfoType:
		soap_serialize_PointerTods__SignedInfoType(soap, (struct ds__SignedInfoType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTods__X509DataType:
		soap_serialize_PointerTods__X509DataType(soap, (struct ds__X509DataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__Embedded:
		soap_serialize_PointerTo_wsse__Embedded(soap, (struct _wsse__Embedded *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__KeyIdentifier:
		soap_serialize_PointerTo_wsse__KeyIdentifier(soap, (struct _wsse__KeyIdentifier *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__Reference:
		soap_serialize_PointerTo_wsse__Reference(soap, (struct _wsse__Reference *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsse__Password:
		soap_serialize_PointerTo_wsse__Password(soap, (struct _wsse__Password *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__DivideResponse:
		soap_serialize_PointerTo_mssamm__DivideResponse(soap, (_mssamm__DivideResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__Divide:
		soap_serialize_PointerTo_mssamm__Divide(soap, (_mssamm__Divide *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__MultiplyResponse:
		soap_serialize_PointerTo_mssamm__MultiplyResponse(soap, (_mssamm__MultiplyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__Multiply:
		soap_serialize_PointerTo_mssamm__Multiply(soap, (_mssamm__Multiply *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__SubtractResponse:
		soap_serialize_PointerTo_mssamm__SubtractResponse(soap, (_mssamm__SubtractResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__Subtract:
		soap_serialize_PointerTo_mssamm__Subtract(soap, (_mssamm__Subtract *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__AddResponse:
		soap_serialize_PointerTo_mssamm__AddResponse(soap, (_mssamm__AddResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamm__Add:
		soap_serialize_PointerTo_mssamm__Add(soap, (_mssamm__Add *const*)ptr);
		break;
	case SOAP_TYPE_PointerTodouble:
		soap_serialize_PointerTodouble(soap, (double *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE__mssamm__Add:
		return (void*)soap_instantiate__mssamm__Add(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__AddResponse:
		return (void*)soap_instantiate__mssamm__AddResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__Subtract:
		return (void*)soap_instantiate__mssamm__Subtract(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__SubtractResponse:
		return (void*)soap_instantiate__mssamm__SubtractResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__Multiply:
		return (void*)soap_instantiate__mssamm__Multiply(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__MultiplyResponse:
		return (void*)soap_instantiate__mssamm__MultiplyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__Divide:
		return (void*)soap_instantiate__mssamm__Divide(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamm__DivideResponse:
		return (void*)soap_instantiate__mssamm__DivideResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Add:
		return (void*)soap_instantiate___tempuri__Add(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Subtract:
		return (void*)soap_instantiate___tempuri__Subtract(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Multiply:
		return (void*)soap_instantiate___tempuri__Multiply(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Divide:
		return (void*)soap_instantiate___tempuri__Divide(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsu__Timestamp:
		return (void*)soap_instantiate__wsu__Timestamp(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__UsernameToken:
		return (void*)soap_instantiate__wsse__UsernameToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__BinarySecurityToken:
		return (void*)soap_instantiate__wsse__BinarySecurityToken(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__Reference:
		return (void*)soap_instantiate__wsse__Reference(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__Embedded:
		return (void*)soap_instantiate__wsse__Embedded(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__KeyIdentifier:
		return (void*)soap_instantiate__wsse__KeyIdentifier(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__SecurityTokenReference:
		return (void*)soap_instantiate__wsse__SecurityTokenReference(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__SignatureType:
		return (void*)soap_instantiate_ds__SignatureType(soap, -1, type, arrayType, n);
	case SOAP_TYPE__c14n__InclusiveNamespaces:
		return (void*)soap_instantiate__c14n__InclusiveNamespaces(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__TransformType:
		return (void*)soap_instantiate_ds__TransformType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__KeyInfoType:
		return (void*)soap_instantiate_ds__KeyInfoType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__SignedInfoType:
		return (void*)soap_instantiate_ds__SignedInfoType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__CanonicalizationMethodType:
		return (void*)soap_instantiate_ds__CanonicalizationMethodType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__SignatureMethodType:
		return (void*)soap_instantiate_ds__SignatureMethodType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__ReferenceType:
		return (void*)soap_instantiate_ds__ReferenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__TransformsType:
		return (void*)soap_instantiate_ds__TransformsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__DigestMethodType:
		return (void*)soap_instantiate_ds__DigestMethodType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__KeyValueType:
		return (void*)soap_instantiate_ds__KeyValueType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__RetrievalMethodType:
		return (void*)soap_instantiate_ds__RetrievalMethodType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__X509DataType:
		return (void*)soap_instantiate_ds__X509DataType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__X509IssuerSerialType:
		return (void*)soap_instantiate_ds__X509IssuerSerialType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__DSAKeyValueType:
		return (void*)soap_instantiate_ds__DSAKeyValueType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ds__RSAKeyValueType:
		return (void*)soap_instantiate_ds__RSAKeyValueType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__EncryptionPropertyType:
		return (void*)soap_instantiate_xenc__EncryptionPropertyType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__EncryptedType:
		return (void*)soap_instantiate_xenc__EncryptedType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__EncryptionMethodType:
		return (void*)soap_instantiate_xenc__EncryptionMethodType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__CipherDataType:
		return (void*)soap_instantiate_xenc__CipherDataType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__CipherReferenceType:
		return (void*)soap_instantiate_xenc__CipherReferenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__TransformsType:
		return (void*)soap_instantiate_xenc__TransformsType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__AgreementMethodType:
		return (void*)soap_instantiate_xenc__AgreementMethodType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__ReferenceType:
		return (void*)soap_instantiate_xenc__ReferenceType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__EncryptionPropertiesType:
		return (void*)soap_instantiate_xenc__EncryptionPropertiesType(soap, -1, type, arrayType, n);
	case SOAP_TYPE___xenc__union_ReferenceList:
		return (void*)soap_instantiate___xenc__union_ReferenceList(soap, -1, type, arrayType, n);
	case SOAP_TYPE__xenc__ReferenceList:
		return (void*)soap_instantiate__xenc__ReferenceList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__EncryptedDataType:
		return (void*)soap_instantiate_xenc__EncryptedDataType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xenc__EncryptedKeyType:
		return (void*)soap_instantiate_xenc__EncryptedKeyType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsc__SecurityContextTokenType:
		return (void*)soap_instantiate_wsc__SecurityContextTokenType(soap, -1, type, arrayType, n);
	case SOAP_TYPE___wsc__DerivedKeyTokenType_sequence:
		return (void*)soap_instantiate___wsc__DerivedKeyTokenType_sequence(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsc__DerivedKeyTokenType:
		return (void*)soap_instantiate_wsc__DerivedKeyTokenType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_wsc__PropertiesType:
		return (void*)soap_instantiate_wsc__PropertiesType(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__Security:
		return (void*)soap_instantiate__wsse__Security(soap, -1, type, arrayType, n);
	case SOAP_TYPE__wsse__Password:
		return (void*)soap_instantiate__wsse__Password(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE__ds__Signature:
		return (void*)soap_instantiate__ds__Signature(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ds__Transform:
		return (void*)soap_instantiate__ds__Transform(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ds__KeyInfo:
		return (void*)soap_instantiate__ds__KeyInfo(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE__mssamm__Add:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__Add*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__Add*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__AddResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__AddResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__AddResponse*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__Subtract:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__Subtract*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__Subtract*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__SubtractResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__SubtractResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__SubtractResponse*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__Multiply:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__Multiply*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__Multiply*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__MultiplyResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__MultiplyResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__MultiplyResponse*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__Divide:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__Divide*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__Divide*)p->ptr);
		break;
	case SOAP_TYPE__mssamm__DivideResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamm__DivideResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamm__DivideResponse*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Add:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Add*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Add*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Subtract:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Subtract*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Subtract*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Multiply:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Multiply*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Multiply*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Divide:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Divide*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Divide*)p->ptr);
		break;
	case SOAP_TYPE__wsu__Timestamp:
		if (p->size < 0)
			SOAP_DELETE((struct _wsu__Timestamp*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsu__Timestamp*)p->ptr);
		break;
	case SOAP_TYPE__wsse__UsernameToken:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__UsernameToken*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__UsernameToken*)p->ptr);
		break;
	case SOAP_TYPE__wsse__BinarySecurityToken:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__BinarySecurityToken*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__BinarySecurityToken*)p->ptr);
		break;
	case SOAP_TYPE__wsse__Reference:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__Reference*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__Reference*)p->ptr);
		break;
	case SOAP_TYPE__wsse__Embedded:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__Embedded*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__Embedded*)p->ptr);
		break;
	case SOAP_TYPE__wsse__KeyIdentifier:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__KeyIdentifier*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__KeyIdentifier*)p->ptr);
		break;
	case SOAP_TYPE__wsse__SecurityTokenReference:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__SecurityTokenReference*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__SecurityTokenReference*)p->ptr);
		break;
	case SOAP_TYPE_ds__SignatureType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__SignatureType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__SignatureType*)p->ptr);
		break;
	case SOAP_TYPE__c14n__InclusiveNamespaces:
		if (p->size < 0)
			SOAP_DELETE((struct _c14n__InclusiveNamespaces*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _c14n__InclusiveNamespaces*)p->ptr);
		break;
	case SOAP_TYPE_ds__TransformType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__TransformType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__TransformType*)p->ptr);
		break;
	case SOAP_TYPE_ds__KeyInfoType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__KeyInfoType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__KeyInfoType*)p->ptr);
		break;
	case SOAP_TYPE_ds__SignedInfoType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__SignedInfoType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__SignedInfoType*)p->ptr);
		break;
	case SOAP_TYPE_ds__CanonicalizationMethodType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__CanonicalizationMethodType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__CanonicalizationMethodType*)p->ptr);
		break;
	case SOAP_TYPE_ds__SignatureMethodType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__SignatureMethodType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__SignatureMethodType*)p->ptr);
		break;
	case SOAP_TYPE_ds__ReferenceType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__ReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__ReferenceType*)p->ptr);
		break;
	case SOAP_TYPE_ds__TransformsType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__TransformsType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__TransformsType*)p->ptr);
		break;
	case SOAP_TYPE_ds__DigestMethodType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__DigestMethodType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__DigestMethodType*)p->ptr);
		break;
	case SOAP_TYPE_ds__KeyValueType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__KeyValueType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__KeyValueType*)p->ptr);
		break;
	case SOAP_TYPE_ds__RetrievalMethodType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__RetrievalMethodType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__RetrievalMethodType*)p->ptr);
		break;
	case SOAP_TYPE_ds__X509DataType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__X509DataType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__X509DataType*)p->ptr);
		break;
	case SOAP_TYPE_ds__X509IssuerSerialType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__X509IssuerSerialType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__X509IssuerSerialType*)p->ptr);
		break;
	case SOAP_TYPE_ds__DSAKeyValueType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__DSAKeyValueType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__DSAKeyValueType*)p->ptr);
		break;
	case SOAP_TYPE_ds__RSAKeyValueType:
		if (p->size < 0)
			SOAP_DELETE((struct ds__RSAKeyValueType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__RSAKeyValueType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__EncryptionPropertyType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__EncryptionPropertyType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__EncryptionPropertyType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__EncryptedType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__EncryptedType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__EncryptedType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__EncryptionMethodType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__EncryptionMethodType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__EncryptionMethodType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__CipherDataType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__CipherDataType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__CipherDataType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__CipherReferenceType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__CipherReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__CipherReferenceType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__TransformsType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__TransformsType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__TransformsType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__AgreementMethodType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__AgreementMethodType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__AgreementMethodType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__ReferenceType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__ReferenceType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__ReferenceType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__EncryptionPropertiesType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__EncryptionPropertiesType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__EncryptionPropertiesType*)p->ptr);
		break;
	case SOAP_TYPE___xenc__union_ReferenceList:
		if (p->size < 0)
			SOAP_DELETE((struct __xenc__union_ReferenceList*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __xenc__union_ReferenceList*)p->ptr);
		break;
	case SOAP_TYPE__xenc__ReferenceList:
		if (p->size < 0)
			SOAP_DELETE((struct _xenc__ReferenceList*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _xenc__ReferenceList*)p->ptr);
		break;
	case SOAP_TYPE_xenc__EncryptedDataType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__EncryptedDataType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__EncryptedDataType*)p->ptr);
		break;
	case SOAP_TYPE_xenc__EncryptedKeyType:
		if (p->size < 0)
			SOAP_DELETE((struct xenc__EncryptedKeyType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct xenc__EncryptedKeyType*)p->ptr);
		break;
	case SOAP_TYPE_wsc__SecurityContextTokenType:
		if (p->size < 0)
			SOAP_DELETE((struct wsc__SecurityContextTokenType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsc__SecurityContextTokenType*)p->ptr);
		break;
	case SOAP_TYPE___wsc__DerivedKeyTokenType_sequence:
		if (p->size < 0)
			SOAP_DELETE((struct __wsc__DerivedKeyTokenType_sequence*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __wsc__DerivedKeyTokenType_sequence*)p->ptr);
		break;
	case SOAP_TYPE_wsc__DerivedKeyTokenType:
		if (p->size < 0)
			SOAP_DELETE((struct wsc__DerivedKeyTokenType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsc__DerivedKeyTokenType*)p->ptr);
		break;
	case SOAP_TYPE_wsc__PropertiesType:
		if (p->size < 0)
			SOAP_DELETE((struct wsc__PropertiesType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct wsc__PropertiesType*)p->ptr);
		break;
	case SOAP_TYPE__wsse__Security:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__Security*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__Security*)p->ptr);
		break;
	case SOAP_TYPE__wsse__Password:
		if (p->size < 0)
			SOAP_DELETE((struct _wsse__Password*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct _wsse__Password*)p->ptr);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
		break;
#endif
	case SOAP_TYPE__ds__Signature:
		if (p->size < 0)
			SOAP_DELETE((struct ds__SignatureType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__SignatureType*)p->ptr);
		break;
	case SOAP_TYPE__ds__Transform:
		if (p->size < 0)
			SOAP_DELETE((struct ds__TransformType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__TransformType*)p->ptr);
		break;
	case SOAP_TYPE__ds__KeyInfo:
		if (p->size < 0)
			SOAP_DELETE((struct ds__KeyInfoType*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct ds__KeyInfoType*)p->ptr);
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
	(void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
	switch (tt)
	{
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{	double *p;
	p = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{	ULONG64 *p;
	p = soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsc__FaultCodeType(struct soap *soap, enum wsc__FaultCodeType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsc__FaultCodeType
	*a = SOAP_DEFAULT_wsc__FaultCodeType;
#else
	*a = (enum wsc__FaultCodeType)0;
#endif
}

static const struct soap_code_map soap_codes_wsc__FaultCodeType[] =
{	{ (long)wsc__BadContextToken, "wsc:BadContextToken" },
	{ (long)wsc__UnsupportedContextToken, "wsc:UnsupportedContextToken" },
	{ (long)wsc__UnknownDerivationSource, "wsc:UnknownDerivationSource" },
	{ (long)wsc__RenewNeeded, "wsc:RenewNeeded" },
	{ (long)wsc__UnableToRenew, "wsc:UnableToRenew" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsc__FaultCodeType2s(struct soap *soap, enum wsc__FaultCodeType n)
{	const char *s = soap_code_str(soap_codes_wsc__FaultCodeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsc__FaultCodeType(struct soap *soap, const char *tag, int id, const enum wsc__FaultCodeType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsc__FaultCodeType), type) || soap_send(soap, soap_wsc__FaultCodeType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsc__FaultCodeType(struct soap *soap, const char *s, enum wsc__FaultCodeType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, 0, -1);
	map = soap_code(soap_codes_wsc__FaultCodeType, t);
	if (map)
		*a = (enum wsc__FaultCodeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsc__FaultCodeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsc__FaultCodeType * SOAP_FMAC4 soap_in_wsc__FaultCodeType(struct soap *soap, const char *tag, enum wsc__FaultCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsc__FaultCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsc__FaultCodeType, sizeof(enum wsc__FaultCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsc__FaultCodeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsc__FaultCodeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsc__FaultCodeType, 0, sizeof(enum wsc__FaultCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsc__FaultCodeType(struct soap *soap, const enum wsc__FaultCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsc__FaultCodeType);
	if (soap_out_wsc__FaultCodeType(soap, tag?tag:"wsc:FaultCodeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsc__FaultCodeType * SOAP_FMAC4 soap_get_wsc__FaultCodeType(struct soap *soap, enum wsc__FaultCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsc__FaultCodeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsse__FaultcodeEnum
	*a = SOAP_DEFAULT_wsse__FaultcodeEnum;
#else
	*a = (enum wsse__FaultcodeEnum)0;
#endif
}

static const struct soap_code_map soap_codes_wsse__FaultcodeEnum[] =
{	{ (long)wsse__UnsupportedSecurityToken, "wsse:UnsupportedSecurityToken" },
	{ (long)wsse__UnsupportedAlgorithm, "wsse:UnsupportedAlgorithm" },
	{ (long)wsse__InvalidSecurity, "wsse:InvalidSecurity" },
	{ (long)wsse__InvalidSecurityToken, "wsse:InvalidSecurityToken" },
	{ (long)wsse__FailedAuthentication, "wsse:FailedAuthentication" },
	{ (long)wsse__FailedCheck, "wsse:FailedCheck" },
	{ (long)wsse__SecurityTokenUnavailable, "wsse:SecurityTokenUnavailable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsse__FaultcodeEnum2s(struct soap *soap, enum wsse__FaultcodeEnum n)
{	const char *s = soap_code_str(soap_codes_wsse__FaultcodeEnum, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__FaultcodeEnum(struct soap *soap, const char *tag, int id, const enum wsse__FaultcodeEnum *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__FaultcodeEnum), type) || soap_send(soap, soap_wsse__FaultcodeEnum2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsse__FaultcodeEnum(struct soap *soap, const char *s, enum wsse__FaultcodeEnum *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, 0, -1);
	map = soap_code(soap_codes_wsse__FaultcodeEnum, t);
	if (map)
		*a = (enum wsse__FaultcodeEnum)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsse__FaultcodeEnum)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_in_wsse__FaultcodeEnum(struct soap *soap, const char *tag, enum wsse__FaultcodeEnum *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsse__FaultcodeEnum *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__FaultcodeEnum, sizeof(enum wsse__FaultcodeEnum), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsse__FaultcodeEnum(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsse__FaultcodeEnum *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__FaultcodeEnum, 0, sizeof(enum wsse__FaultcodeEnum), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__FaultcodeEnum(struct soap *soap, const enum wsse__FaultcodeEnum *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__FaultcodeEnum);
	if (soap_out_wsse__FaultcodeEnum(soap, tag?tag:"wsse:FaultcodeEnum", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_get_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__FaultcodeEnum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsu__tTimestampFault
	*a = SOAP_DEFAULT_wsu__tTimestampFault;
#else
	*a = (enum wsu__tTimestampFault)0;
#endif
}

static const struct soap_code_map soap_codes_wsu__tTimestampFault[] =
{	{ (long)wsu__MessageExpired, "wsu:MessageExpired" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsu__tTimestampFault2s(struct soap *soap, enum wsu__tTimestampFault n)
{	const char *s = soap_code_str(soap_codes_wsu__tTimestampFault, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsu__tTimestampFault(struct soap *soap, const char *tag, int id, const enum wsu__tTimestampFault *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsu__tTimestampFault), type) || soap_send(soap, soap_wsu__tTimestampFault2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsu__tTimestampFault(struct soap *soap, const char *s, enum wsu__tTimestampFault *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, 0, -1);
	map = soap_code(soap_codes_wsu__tTimestampFault, t);
	if (map)
		*a = (enum wsu__tTimestampFault)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsu__tTimestampFault)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_in_wsu__tTimestampFault(struct soap *soap, const char *tag, enum wsu__tTimestampFault *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsu__tTimestampFault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsu__tTimestampFault, sizeof(enum wsu__tTimestampFault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsu__tTimestampFault(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsu__tTimestampFault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsu__tTimestampFault, 0, sizeof(enum wsu__tTimestampFault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsu__tTimestampFault(struct soap *soap, const enum wsu__tTimestampFault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsu__tTimestampFault);
	if (soap_out_wsu__tTimestampFault(soap, tag?tag:"wsu:tTimestampFault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_get_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsu__tTimestampFault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamm__DivideResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__DivideResponse::DivideResult = NULL;
	/* transient soap skipped */
}

void _mssamm__DivideResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__DivideResponse::DivideResult);
	/* transient soap skipped */
#endif
}

int _mssamm__DivideResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__DivideResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__DivideResponse(struct soap *soap, const char *tag, int id, const _mssamm__DivideResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__DivideResponse), type))
		return soap->error;
	if (a->DivideResult)
		soap_element_result(soap, "mssamm:DivideResult");
	if (soap_out_PointerTodouble(soap, "mssamm:DivideResult", -1, &(a->_mssamm__DivideResponse::DivideResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__DivideResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__DivideResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__DivideResponse * SOAP_FMAC4 soap_in__mssamm__DivideResponse(struct soap *soap, const char *tag, _mssamm__DivideResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__DivideResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__DivideResponse, sizeof(_mssamm__DivideResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__DivideResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__DivideResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_DivideResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_DivideResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:DivideResult", &(a->_mssamm__DivideResponse::DivideResult), "xsd:double"))
				{	soap_flag_DivideResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamm:DivideResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__DivideResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__DivideResponse, 0, sizeof(_mssamm__DivideResponse), 0, soap_copy__mssamm__DivideResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__DivideResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__DivideResponse);
	if (this->soap_out(soap, tag?tag:"mssamm:DivideResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__DivideResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__DivideResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__DivideResponse * SOAP_FMAC4 soap_get__mssamm__DivideResponse(struct soap *soap, _mssamm__DivideResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__DivideResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__DivideResponse * SOAP_FMAC2 soap_instantiate__mssamm__DivideResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__DivideResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__DivideResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__DivideResponse);
		if (size)
			*size = sizeof(_mssamm__DivideResponse);
		((_mssamm__DivideResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__DivideResponse, n);
		if (size)
			*size = n * sizeof(_mssamm__DivideResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__DivideResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__DivideResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__DivideResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__DivideResponse %p -> %p\n", q, p));
	*(_mssamm__DivideResponse*)p = *(_mssamm__DivideResponse*)q;
}

void _mssamm__Divide::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__Divide::n1 = NULL;
	this->_mssamm__Divide::n2 = NULL;
	/* transient soap skipped */
}

void _mssamm__Divide::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Divide::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Divide::n2);
	/* transient soap skipped */
#endif
}

int _mssamm__Divide::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__Divide(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__Divide(struct soap *soap, const char *tag, int id, const _mssamm__Divide *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__Divide), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n1", -1, &(a->_mssamm__Divide::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n2", -1, &(a->_mssamm__Divide::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__Divide::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__Divide(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__Divide * SOAP_FMAC4 soap_in__mssamm__Divide(struct soap *soap, const char *tag, _mssamm__Divide *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__Divide *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__Divide, sizeof(_mssamm__Divide), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__Divide)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__Divide *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n1", &(a->_mssamm__Divide::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n2", &(a->_mssamm__Divide::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__Divide *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__Divide, 0, sizeof(_mssamm__Divide), 0, soap_copy__mssamm__Divide);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__Divide::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__Divide);
	if (this->soap_out(soap, tag?tag:"mssamm:Divide", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__Divide::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__Divide(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__Divide * SOAP_FMAC4 soap_get__mssamm__Divide(struct soap *soap, _mssamm__Divide *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__Divide * SOAP_FMAC2 soap_instantiate__mssamm__Divide(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__Divide(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__Divide, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__Divide);
		if (size)
			*size = sizeof(_mssamm__Divide);
		((_mssamm__Divide*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__Divide, n);
		if (size)
			*size = n * sizeof(_mssamm__Divide);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__Divide*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__Divide*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__Divide(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__Divide %p -> %p\n", q, p));
	*(_mssamm__Divide*)p = *(_mssamm__Divide*)q;
}

void _mssamm__MultiplyResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__MultiplyResponse::MultiplyResult = NULL;
	/* transient soap skipped */
}

void _mssamm__MultiplyResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__MultiplyResponse::MultiplyResult);
	/* transient soap skipped */
#endif
}

int _mssamm__MultiplyResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__MultiplyResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__MultiplyResponse(struct soap *soap, const char *tag, int id, const _mssamm__MultiplyResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__MultiplyResponse), type))
		return soap->error;
	if (a->MultiplyResult)
		soap_element_result(soap, "mssamm:MultiplyResult");
	if (soap_out_PointerTodouble(soap, "mssamm:MultiplyResult", -1, &(a->_mssamm__MultiplyResponse::MultiplyResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__MultiplyResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__MultiplyResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__MultiplyResponse * SOAP_FMAC4 soap_in__mssamm__MultiplyResponse(struct soap *soap, const char *tag, _mssamm__MultiplyResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__MultiplyResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__MultiplyResponse, sizeof(_mssamm__MultiplyResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__MultiplyResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__MultiplyResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_MultiplyResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MultiplyResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:MultiplyResult", &(a->_mssamm__MultiplyResponse::MultiplyResult), "xsd:double"))
				{	soap_flag_MultiplyResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamm:MultiplyResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__MultiplyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__MultiplyResponse, 0, sizeof(_mssamm__MultiplyResponse), 0, soap_copy__mssamm__MultiplyResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__MultiplyResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__MultiplyResponse);
	if (this->soap_out(soap, tag?tag:"mssamm:MultiplyResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__MultiplyResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__MultiplyResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__MultiplyResponse * SOAP_FMAC4 soap_get__mssamm__MultiplyResponse(struct soap *soap, _mssamm__MultiplyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__MultiplyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__MultiplyResponse * SOAP_FMAC2 soap_instantiate__mssamm__MultiplyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__MultiplyResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__MultiplyResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__MultiplyResponse);
		if (size)
			*size = sizeof(_mssamm__MultiplyResponse);
		((_mssamm__MultiplyResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__MultiplyResponse, n);
		if (size)
			*size = n * sizeof(_mssamm__MultiplyResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__MultiplyResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__MultiplyResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__MultiplyResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__MultiplyResponse %p -> %p\n", q, p));
	*(_mssamm__MultiplyResponse*)p = *(_mssamm__MultiplyResponse*)q;
}

void _mssamm__Multiply::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__Multiply::n1 = NULL;
	this->_mssamm__Multiply::n2 = NULL;
	/* transient soap skipped */
}

void _mssamm__Multiply::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Multiply::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Multiply::n2);
	/* transient soap skipped */
#endif
}

int _mssamm__Multiply::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__Multiply(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__Multiply(struct soap *soap, const char *tag, int id, const _mssamm__Multiply *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__Multiply), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n1", -1, &(a->_mssamm__Multiply::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n2", -1, &(a->_mssamm__Multiply::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__Multiply::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__Multiply(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__Multiply * SOAP_FMAC4 soap_in__mssamm__Multiply(struct soap *soap, const char *tag, _mssamm__Multiply *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__Multiply *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__Multiply, sizeof(_mssamm__Multiply), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__Multiply)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__Multiply *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n1", &(a->_mssamm__Multiply::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n2", &(a->_mssamm__Multiply::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__Multiply *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__Multiply, 0, sizeof(_mssamm__Multiply), 0, soap_copy__mssamm__Multiply);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__Multiply::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__Multiply);
	if (this->soap_out(soap, tag?tag:"mssamm:Multiply", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__Multiply::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__Multiply(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__Multiply * SOAP_FMAC4 soap_get__mssamm__Multiply(struct soap *soap, _mssamm__Multiply *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__Multiply * SOAP_FMAC2 soap_instantiate__mssamm__Multiply(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__Multiply(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__Multiply, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__Multiply);
		if (size)
			*size = sizeof(_mssamm__Multiply);
		((_mssamm__Multiply*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__Multiply, n);
		if (size)
			*size = n * sizeof(_mssamm__Multiply);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__Multiply*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__Multiply*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__Multiply(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__Multiply %p -> %p\n", q, p));
	*(_mssamm__Multiply*)p = *(_mssamm__Multiply*)q;
}

void _mssamm__SubtractResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__SubtractResponse::SubtractResult = NULL;
	/* transient soap skipped */
}

void _mssamm__SubtractResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__SubtractResponse::SubtractResult);
	/* transient soap skipped */
#endif
}

int _mssamm__SubtractResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__SubtractResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__SubtractResponse(struct soap *soap, const char *tag, int id, const _mssamm__SubtractResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__SubtractResponse), type))
		return soap->error;
	if (a->SubtractResult)
		soap_element_result(soap, "mssamm:SubtractResult");
	if (soap_out_PointerTodouble(soap, "mssamm:SubtractResult", -1, &(a->_mssamm__SubtractResponse::SubtractResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__SubtractResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__SubtractResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__SubtractResponse * SOAP_FMAC4 soap_in__mssamm__SubtractResponse(struct soap *soap, const char *tag, _mssamm__SubtractResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__SubtractResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__SubtractResponse, sizeof(_mssamm__SubtractResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__SubtractResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__SubtractResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_SubtractResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SubtractResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:SubtractResult", &(a->_mssamm__SubtractResponse::SubtractResult), "xsd:double"))
				{	soap_flag_SubtractResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamm:SubtractResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__SubtractResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__SubtractResponse, 0, sizeof(_mssamm__SubtractResponse), 0, soap_copy__mssamm__SubtractResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__SubtractResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__SubtractResponse);
	if (this->soap_out(soap, tag?tag:"mssamm:SubtractResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__SubtractResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__SubtractResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__SubtractResponse * SOAP_FMAC4 soap_get__mssamm__SubtractResponse(struct soap *soap, _mssamm__SubtractResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__SubtractResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__SubtractResponse * SOAP_FMAC2 soap_instantiate__mssamm__SubtractResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__SubtractResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__SubtractResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__SubtractResponse);
		if (size)
			*size = sizeof(_mssamm__SubtractResponse);
		((_mssamm__SubtractResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__SubtractResponse, n);
		if (size)
			*size = n * sizeof(_mssamm__SubtractResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__SubtractResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__SubtractResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__SubtractResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__SubtractResponse %p -> %p\n", q, p));
	*(_mssamm__SubtractResponse*)p = *(_mssamm__SubtractResponse*)q;
}

void _mssamm__Subtract::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__Subtract::n1 = NULL;
	this->_mssamm__Subtract::n2 = NULL;
	/* transient soap skipped */
}

void _mssamm__Subtract::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Subtract::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Subtract::n2);
	/* transient soap skipped */
#endif
}

int _mssamm__Subtract::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__Subtract(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__Subtract(struct soap *soap, const char *tag, int id, const _mssamm__Subtract *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__Subtract), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n1", -1, &(a->_mssamm__Subtract::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n2", -1, &(a->_mssamm__Subtract::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__Subtract::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__Subtract(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__Subtract * SOAP_FMAC4 soap_in__mssamm__Subtract(struct soap *soap, const char *tag, _mssamm__Subtract *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__Subtract *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__Subtract, sizeof(_mssamm__Subtract), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__Subtract)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__Subtract *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n1", &(a->_mssamm__Subtract::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n2", &(a->_mssamm__Subtract::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__Subtract *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__Subtract, 0, sizeof(_mssamm__Subtract), 0, soap_copy__mssamm__Subtract);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__Subtract::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__Subtract);
	if (this->soap_out(soap, tag?tag:"mssamm:Subtract", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__Subtract::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__Subtract(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__Subtract * SOAP_FMAC4 soap_get__mssamm__Subtract(struct soap *soap, _mssamm__Subtract *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__Subtract * SOAP_FMAC2 soap_instantiate__mssamm__Subtract(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__Subtract(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__Subtract, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__Subtract);
		if (size)
			*size = sizeof(_mssamm__Subtract);
		((_mssamm__Subtract*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__Subtract, n);
		if (size)
			*size = n * sizeof(_mssamm__Subtract);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__Subtract*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__Subtract*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__Subtract(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__Subtract %p -> %p\n", q, p));
	*(_mssamm__Subtract*)p = *(_mssamm__Subtract*)q;
}

void _mssamm__AddResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__AddResponse::AddResult = NULL;
	/* transient soap skipped */
}

void _mssamm__AddResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__AddResponse::AddResult);
	/* transient soap skipped */
#endif
}

int _mssamm__AddResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__AddResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__AddResponse(struct soap *soap, const char *tag, int id, const _mssamm__AddResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__AddResponse), type))
		return soap->error;
	if (a->AddResult)
		soap_element_result(soap, "mssamm:AddResult");
	if (soap_out_PointerTodouble(soap, "mssamm:AddResult", -1, &(a->_mssamm__AddResponse::AddResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__AddResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__AddResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__AddResponse * SOAP_FMAC4 soap_in__mssamm__AddResponse(struct soap *soap, const char *tag, _mssamm__AddResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__AddResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__AddResponse, sizeof(_mssamm__AddResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__AddResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__AddResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_AddResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AddResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:AddResult", &(a->_mssamm__AddResponse::AddResult), "xsd:double"))
				{	soap_flag_AddResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamm:AddResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__AddResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__AddResponse, 0, sizeof(_mssamm__AddResponse), 0, soap_copy__mssamm__AddResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__AddResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__AddResponse);
	if (this->soap_out(soap, tag?tag:"mssamm:AddResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__AddResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__AddResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__AddResponse * SOAP_FMAC4 soap_get__mssamm__AddResponse(struct soap *soap, _mssamm__AddResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__AddResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__AddResponse * SOAP_FMAC2 soap_instantiate__mssamm__AddResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__AddResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__AddResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__AddResponse);
		if (size)
			*size = sizeof(_mssamm__AddResponse);
		((_mssamm__AddResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__AddResponse, n);
		if (size)
			*size = n * sizeof(_mssamm__AddResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__AddResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__AddResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__AddResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__AddResponse %p -> %p\n", q, p));
	*(_mssamm__AddResponse*)p = *(_mssamm__AddResponse*)q;
}

void _mssamm__Add::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamm__Add::n1 = NULL;
	this->_mssamm__Add::n2 = NULL;
	/* transient soap skipped */
}

void _mssamm__Add::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Add::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamm__Add::n2);
	/* transient soap skipped */
#endif
}

int _mssamm__Add::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamm__Add(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamm__Add(struct soap *soap, const char *tag, int id, const _mssamm__Add *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamm__Add), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n1", -1, &(a->_mssamm__Add::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamm:n2", -1, &(a->_mssamm__Add::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamm__Add::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamm__Add(soap, tag, this, type);
}

SOAP_FMAC3 _mssamm__Add * SOAP_FMAC4 soap_in__mssamm__Add(struct soap *soap, const char *tag, _mssamm__Add *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamm__Add *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamm__Add, sizeof(_mssamm__Add), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamm__Add)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamm__Add *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n1", &(a->_mssamm__Add::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamm:n2", &(a->_mssamm__Add::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamm__Add *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamm__Add, 0, sizeof(_mssamm__Add), 0, soap_copy__mssamm__Add);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamm__Add::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamm__Add);
	if (this->soap_out(soap, tag?tag:"mssamm:Add", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamm__Add::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamm__Add(soap, this, tag, type);
}

SOAP_FMAC3 _mssamm__Add * SOAP_FMAC4 soap_get__mssamm__Add(struct soap *soap, _mssamm__Add *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamm__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamm__Add * SOAP_FMAC2 soap_instantiate__mssamm__Add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamm__Add(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamm__Add, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamm__Add);
		if (size)
			*size = sizeof(_mssamm__Add);
		((_mssamm__Add*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamm__Add, n);
		if (size)
			*size = n * sizeof(_mssamm__Add);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamm__Add*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamm__Add*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamm__Add(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamm__Add %p -> %p\n", q, p));
	*(_mssamm__Add*)p = *(_mssamm__Add*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Fault, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Reason, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Detail, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Code, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsse__Security = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsse__Security(soap, &a->wsse__Security);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsse__Security(soap, "wsse:Security", -1, &a->wsse__Security, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	size_t soap_flag_wsse__Security = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsse__Security && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Security(soap, "wsse:Security", &a->wsse__Security, ""))
				{	soap_flag_wsse__Security--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Header, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__Security(struct soap *soap, struct _wsse__Security *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsu__Timestamp = NULL;
	a->UsernameToken = NULL;
	a->BinarySecurityToken = NULL;
	a->xenc__EncryptedKey = NULL;
	a->xenc__ReferenceList = NULL;
	a->wsc__SecurityContextToken = NULL;
	a->ds__Signature = NULL;
	soap_default_string(soap, &a->SOAP_ENV__actor);
	soap_default_string(soap, &a->SOAP_ENV__role);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__Security(struct soap *soap, const struct _wsse__Security *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsu__Timestamp(soap, &a->wsu__Timestamp);
	soap_serialize_PointerTo_wsse__UsernameToken(soap, &a->UsernameToken);
	soap_serialize_PointerTo_wsse__BinarySecurityToken(soap, &a->BinarySecurityToken);
	soap_serialize_PointerToxenc__EncryptedKeyType(soap, &a->xenc__EncryptedKey);
	soap_serialize_PointerTo_xenc__ReferenceList(soap, &a->xenc__ReferenceList);
	soap_serialize_PointerTowsc__SecurityContextTokenType(soap, &a->wsc__SecurityContextToken);
	soap_serialize_PointerTods__SignatureType(soap, &a->ds__Signature);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__Security(struct soap *soap, const char *tag, int id, const struct _wsse__Security *a, const char *type)
{
	if (a->SOAP_ENV__actor)
		soap_set_attr(soap, "SOAP-ENV:actor", a->SOAP_ENV__actor, 1);
	if (a->SOAP_ENV__role)
		soap_set_attr(soap, "SOAP-ENV:role", a->SOAP_ENV__role, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__Security), type))
		return soap->error;
	if (soap_out_PointerTo_wsu__Timestamp(soap, "wsu:Timestamp", -1, &a->wsu__Timestamp, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__UsernameToken(soap, "wsse:UsernameToken", -1, &a->UsernameToken, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__BinarySecurityToken(soap, "wsse:BinarySecurityToken", -1, &a->BinarySecurityToken, ""))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptedKeyType(soap, "xenc:EncryptedKey", -1, &a->xenc__EncryptedKey, ""))
		return soap->error;
	if (soap_out_PointerTo_xenc__ReferenceList(soap, "xenc:ReferenceList", -1, &a->xenc__ReferenceList, ""))
		return soap->error;
	if (soap_out_PointerTowsc__SecurityContextTokenType(soap, "wsc:SecurityContextToken", -1, &a->wsc__SecurityContextToken, ""))
		return soap->error;
	if (soap_out_PointerTods__SignatureType(soap, "ds:Signature", -1, &a->ds__Signature, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__Security * SOAP_FMAC4 soap_in__wsse__Security(struct soap *soap, const char *tag, struct _wsse__Security *a, const char *type)
{
	size_t soap_flag_wsu__Timestamp = 1;
	size_t soap_flag_UsernameToken = 1;
	size_t soap_flag_BinarySecurityToken = 1;
	size_t soap_flag_xenc__EncryptedKey = 1;
	size_t soap_flag_xenc__ReferenceList = 1;
	size_t soap_flag_wsc__SecurityContextToken = 1;
	size_t soap_flag_ds__Signature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__Security *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__Security, sizeof(struct _wsse__Security), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__Security(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "SOAP-ENV:actor", 0), &a->SOAP_ENV__actor, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "SOAP-ENV:role", 0), &a->SOAP_ENV__role, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsu__Timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsu__Timestamp(soap, "wsu:Timestamp", &a->wsu__Timestamp, ""))
				{	soap_flag_wsu__Timestamp--;
					continue;
				}
			if (soap_flag_UsernameToken && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__UsernameToken(soap, "wsse:UsernameToken", &a->UsernameToken, ""))
				{	soap_flag_UsernameToken--;
					continue;
				}
			if (soap_flag_BinarySecurityToken && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__BinarySecurityToken(soap, "wsse:BinarySecurityToken", &a->BinarySecurityToken, ""))
				{	soap_flag_BinarySecurityToken--;
					continue;
				}
			if (soap_flag_xenc__EncryptedKey && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptedKeyType(soap, "xenc:EncryptedKey", &a->xenc__EncryptedKey, "xenc:EncryptedKeyType"))
				{	soap_flag_xenc__EncryptedKey--;
					continue;
				}
			if (soap_flag_xenc__ReferenceList && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_xenc__ReferenceList(soap, "xenc:ReferenceList", &a->xenc__ReferenceList, ""))
				{	soap_flag_xenc__ReferenceList--;
					continue;
				}
			if (soap_flag_wsc__SecurityContextToken && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsc__SecurityContextTokenType(soap, "wsc:SecurityContextToken", &a->wsc__SecurityContextToken, "wsc:SecurityContextTokenType"))
				{	soap_flag_wsc__SecurityContextToken--;
					continue;
				}
			if (soap_flag_ds__Signature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__SignatureType(soap, "ds:Signature", &a->ds__Signature, "ds:SignatureType"))
				{	soap_flag_ds__Signature--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__Security *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__Security, 0, sizeof(struct _wsse__Security), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__Security(struct soap *soap, const struct _wsse__Security *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__Security);
	if (soap_out__wsse__Security(soap, tag?tag:"wsse:Security", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Security * SOAP_FMAC4 soap_get__wsse__Security(struct soap *soap, struct _wsse__Security *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__Security(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__Security * SOAP_FMAC2 soap_instantiate__wsse__Security(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__Security(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__Security, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__Security);
		if (size)
			*size = sizeof(struct _wsse__Security);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__Security, n);
		if (size)
			*size = n * sizeof(struct _wsse__Security);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__Security*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__Security(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__Security %p -> %p\n", q, p));
	*(struct _wsse__Security*)p = *(struct _wsse__Security*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsc__DerivedKeyTokenType_sequence(struct soap *soap, struct __wsc__DerivedKeyTokenType_sequence *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__union_DerivedKeyTokenType = 0;
	a->Length = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsc__DerivedKeyTokenType_sequence(struct soap *soap, const struct __wsc__DerivedKeyTokenType_sequence *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__wsc__union_DerivedKeyTokenType(soap, a->__union_DerivedKeyTokenType, &a->union_DerivedKeyTokenType);
	soap_serialize_PointerTounsignedLONG64(soap, &a->Length);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsc__DerivedKeyTokenType_sequence(struct soap *soap, const char *tag, int id, const struct __wsc__DerivedKeyTokenType_sequence *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out__wsc__union_DerivedKeyTokenType(soap, a->__union_DerivedKeyTokenType, &a->union_DerivedKeyTokenType))
		return soap->error;
	if (soap_out_PointerTounsignedLONG64(soap, "wsc:Length", -1, &a->Length, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsc__DerivedKeyTokenType_sequence * SOAP_FMAC4 soap_in___wsc__DerivedKeyTokenType_sequence(struct soap *soap, const char *tag, struct __wsc__DerivedKeyTokenType_sequence *a, const char *type)
{
	size_t soap_flag_union_DerivedKeyTokenType = 1;
	size_t soap_flag_Length = 1;
	short soap_flag;
	a = (struct __wsc__DerivedKeyTokenType_sequence *)soap_id_enter(soap, "", a, SOAP_TYPE___wsc__DerivedKeyTokenType_sequence, sizeof(struct __wsc__DerivedKeyTokenType_sequence), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsc__DerivedKeyTokenType_sequence(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_union_DerivedKeyTokenType && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsc__union_DerivedKeyTokenType(soap, &a->__union_DerivedKeyTokenType, &a->union_DerivedKeyTokenType))
				{	soap_flag_union_DerivedKeyTokenType = 0;
					continue;
				}
			if (soap_flag_Length && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "wsc:Length", &a->Length, "xsd:unsignedLong"))
				{	soap_flag_Length--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_union_DerivedKeyTokenType))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsc__DerivedKeyTokenType_sequence(struct soap *soap, const struct __wsc__DerivedKeyTokenType_sequence *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsc__DerivedKeyTokenType_sequence(soap, tag?tag:"-wsc:DerivedKeyTokenType-sequence", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsc__DerivedKeyTokenType_sequence * SOAP_FMAC4 soap_get___wsc__DerivedKeyTokenType_sequence(struct soap *soap, struct __wsc__DerivedKeyTokenType_sequence *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsc__DerivedKeyTokenType_sequence(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __wsc__DerivedKeyTokenType_sequence * SOAP_FMAC2 soap_instantiate___wsc__DerivedKeyTokenType_sequence(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___wsc__DerivedKeyTokenType_sequence(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___wsc__DerivedKeyTokenType_sequence, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __wsc__DerivedKeyTokenType_sequence);
		if (size)
			*size = sizeof(struct __wsc__DerivedKeyTokenType_sequence);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __wsc__DerivedKeyTokenType_sequence, n);
		if (size)
			*size = n * sizeof(struct __wsc__DerivedKeyTokenType_sequence);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __wsc__DerivedKeyTokenType_sequence*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___wsc__DerivedKeyTokenType_sequence(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __wsc__DerivedKeyTokenType_sequence %p -> %p\n", q, p));
	*(struct __wsc__DerivedKeyTokenType_sequence*)p = *(struct __wsc__DerivedKeyTokenType_sequence*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsc__PropertiesType(struct soap *soap, struct wsc__PropertiesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsc__PropertiesType(struct soap *soap, const struct wsc__PropertiesType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsc__PropertiesType(struct soap *soap, const char *tag, int id, const struct wsc__PropertiesType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsc__PropertiesType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsc__PropertiesType * SOAP_FMAC4 soap_in_wsc__PropertiesType(struct soap *soap, const char *tag, struct wsc__PropertiesType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsc__PropertiesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsc__PropertiesType, sizeof(struct wsc__PropertiesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsc__PropertiesType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsc__PropertiesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsc__PropertiesType, 0, sizeof(struct wsc__PropertiesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsc__PropertiesType(struct soap *soap, const struct wsc__PropertiesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsc__PropertiesType);
	if (soap_out_wsc__PropertiesType(soap, tag?tag:"wsc:PropertiesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsc__PropertiesType * SOAP_FMAC4 soap_get_wsc__PropertiesType(struct soap *soap, struct wsc__PropertiesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsc__PropertiesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsc__PropertiesType * SOAP_FMAC2 soap_instantiate_wsc__PropertiesType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsc__PropertiesType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsc__PropertiesType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsc__PropertiesType);
		if (size)
			*size = sizeof(struct wsc__PropertiesType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsc__PropertiesType, n);
		if (size)
			*size = n * sizeof(struct wsc__PropertiesType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct wsc__PropertiesType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsc__PropertiesType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsc__PropertiesType %p -> %p\n", q, p));
	*(struct wsc__PropertiesType*)p = *(struct wsc__PropertiesType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsc__DerivedKeyTokenType(struct soap *soap, struct wsc__DerivedKeyTokenType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsse__SecurityTokenReference = NULL;
	a->Properties = NULL;
	a->__size_DerivedKeyTokenType_sequence = 0;
	a->__DerivedKeyTokenType_sequence = NULL;
	soap_default_string(soap, &a->Label);
	soap_default_string(soap, &a->Nonce);
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->Algorithm);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsc__DerivedKeyTokenType(struct soap *soap, const struct wsc__DerivedKeyTokenType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsse__SecurityTokenReference(soap, &a->wsse__SecurityTokenReference);
	soap_serialize_PointerTowsc__PropertiesType(soap, &a->Properties);
	if (a->__DerivedKeyTokenType_sequence)
	{	int i;
		for (i = 0; i < a->__size_DerivedKeyTokenType_sequence; i++)
		{
			soap_serialize___wsc__DerivedKeyTokenType_sequence(soap, a->__DerivedKeyTokenType_sequence + i);
		}
	}
	soap_serialize_string(soap, &a->Label);
	soap_serialize_string(soap, &a->Nonce);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsc__DerivedKeyTokenType(struct soap *soap, const char *tag, int id, const struct wsc__DerivedKeyTokenType *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsc__DerivedKeyTokenType), type))
		return soap->error;
	if (soap_out_PointerTo_wsse__SecurityTokenReference(soap, "wsse:SecurityTokenReference", -1, &a->wsse__SecurityTokenReference, ""))
		return soap->error;
	if (soap_out_PointerTowsc__PropertiesType(soap, "wsc:Properties", -1, &a->Properties, ""))
		return soap->error;
	if (a->__DerivedKeyTokenType_sequence)
	{	int i;
		for (i = 0; i < a->__size_DerivedKeyTokenType_sequence; i++)
			if (soap_out___wsc__DerivedKeyTokenType_sequence(soap, "-DerivedKeyTokenType-sequence", -1, a->__DerivedKeyTokenType_sequence + i, ""))
				return soap->error;
	}
	if (soap_out_string(soap, "wsc:Label", -1, &a->Label, ""))
		return soap->error;
	if (soap_out_string(soap, "wsc:Nonce", -1, &a->Nonce, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsc__DerivedKeyTokenType * SOAP_FMAC4 soap_in_wsc__DerivedKeyTokenType(struct soap *soap, const char *tag, struct wsc__DerivedKeyTokenType *a, const char *type)
{
	size_t soap_flag_wsse__SecurityTokenReference = 1;
	size_t soap_flag_Properties = 1;
	struct soap_blist *soap_blist___DerivedKeyTokenType_sequence = NULL;
	size_t soap_flag_Label = 1;
	size_t soap_flag_Nonce = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsc__DerivedKeyTokenType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsc__DerivedKeyTokenType, sizeof(struct wsc__DerivedKeyTokenType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsc__DerivedKeyTokenType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 0), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsse__SecurityTokenReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__SecurityTokenReference(soap, "wsse:SecurityTokenReference", &a->wsse__SecurityTokenReference, ""))
				{	soap_flag_wsse__SecurityTokenReference--;
					continue;
				}
			if (soap_flag_Properties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsc__PropertiesType(soap, "wsc:Properties", &a->Properties, "wsc:PropertiesType"))
				{	soap_flag_Properties--;
					continue;
				}
			if (soap_flag_Label && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsc:Label", &a->Label, "xsd:string"))
				{	soap_flag_Label--;
					continue;
				}
			if (soap_flag_Nonce && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsc:Nonce", &a->Nonce, "xsd:string"))
				{	soap_flag_Nonce--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__DerivedKeyTokenType_sequence == NULL)
				{	if (soap_blist___DerivedKeyTokenType_sequence == NULL)
						soap_blist___DerivedKeyTokenType_sequence = soap_new_block(soap);
					a->__DerivedKeyTokenType_sequence = (struct __wsc__DerivedKeyTokenType_sequence *)soap_push_block(soap, soap_blist___DerivedKeyTokenType_sequence, sizeof(struct __wsc__DerivedKeyTokenType_sequence));
					if (a->__DerivedKeyTokenType_sequence == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->__DerivedKeyTokenType_sequence, struct __wsc__DerivedKeyTokenType_sequence);
					soap_default___wsc__DerivedKeyTokenType_sequence(soap, a->__DerivedKeyTokenType_sequence);
				}
				if (soap_in___wsc__DerivedKeyTokenType_sequence(soap, "-DerivedKeyTokenType-sequence", a->__DerivedKeyTokenType_sequence, "-wsc:DerivedKeyTokenType-sequence"))
				{	a->__size_DerivedKeyTokenType_sequence++;
					a->__DerivedKeyTokenType_sequence = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__DerivedKeyTokenType_sequence)
			soap_pop_block(soap, soap_blist___DerivedKeyTokenType_sequence);
		if (a->__size_DerivedKeyTokenType_sequence)
			a->__DerivedKeyTokenType_sequence = (struct __wsc__DerivedKeyTokenType_sequence *)soap_save_block(soap, soap_blist___DerivedKeyTokenType_sequence, NULL, 1);
		else
		{	a->__DerivedKeyTokenType_sequence = NULL;
			if (soap_blist___DerivedKeyTokenType_sequence)
				soap_end_block(soap, soap_blist___DerivedKeyTokenType_sequence);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsc__DerivedKeyTokenType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsc__DerivedKeyTokenType, 0, sizeof(struct wsc__DerivedKeyTokenType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsc__DerivedKeyTokenType(struct soap *soap, const struct wsc__DerivedKeyTokenType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsc__DerivedKeyTokenType);
	if (soap_out_wsc__DerivedKeyTokenType(soap, tag?tag:"wsc:DerivedKeyTokenType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsc__DerivedKeyTokenType * SOAP_FMAC4 soap_get_wsc__DerivedKeyTokenType(struct soap *soap, struct wsc__DerivedKeyTokenType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsc__DerivedKeyTokenType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsc__DerivedKeyTokenType * SOAP_FMAC2 soap_instantiate_wsc__DerivedKeyTokenType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsc__DerivedKeyTokenType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsc__DerivedKeyTokenType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsc__DerivedKeyTokenType);
		if (size)
			*size = sizeof(struct wsc__DerivedKeyTokenType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsc__DerivedKeyTokenType, n);
		if (size)
			*size = n * sizeof(struct wsc__DerivedKeyTokenType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct wsc__DerivedKeyTokenType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsc__DerivedKeyTokenType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsc__DerivedKeyTokenType %p -> %p\n", q, p));
	*(struct wsc__DerivedKeyTokenType*)p = *(struct wsc__DerivedKeyTokenType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsc__SecurityContextTokenType(struct soap *soap, struct wsc__SecurityContextTokenType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->Identifier);
	soap_default_string(soap, &a->Instance);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsc__SecurityContextTokenType(struct soap *soap, const struct wsc__SecurityContextTokenType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Identifier);
	soap_serialize_string(soap, &a->Instance);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsc__SecurityContextTokenType(struct soap *soap, const char *tag, int id, const struct wsc__SecurityContextTokenType *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsc__SecurityContextTokenType), type))
		return soap->error;
	if (soap_out_string(soap, "wsc:Identifier", -1, &a->Identifier, ""))
		return soap->error;
	if (soap_out_string(soap, "wsc:Instance", -1, &a->Instance, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsc__SecurityContextTokenType * SOAP_FMAC4 soap_in_wsc__SecurityContextTokenType(struct soap *soap, const char *tag, struct wsc__SecurityContextTokenType *a, const char *type)
{
	size_t soap_flag_Identifier = 1;
	size_t soap_flag_Instance = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsc__SecurityContextTokenType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsc__SecurityContextTokenType, sizeof(struct wsc__SecurityContextTokenType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsc__SecurityContextTokenType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsc:Identifier", &a->Identifier, "xsd:string"))
				{	soap_flag_Identifier--;
					continue;
				}
			if (soap_flag_Instance && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsc:Instance", &a->Instance, "xsd:string"))
				{	soap_flag_Instance--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsc__SecurityContextTokenType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsc__SecurityContextTokenType, 0, sizeof(struct wsc__SecurityContextTokenType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsc__SecurityContextTokenType(struct soap *soap, const struct wsc__SecurityContextTokenType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsc__SecurityContextTokenType);
	if (soap_out_wsc__SecurityContextTokenType(soap, tag?tag:"wsc:SecurityContextTokenType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsc__SecurityContextTokenType * SOAP_FMAC4 soap_get_wsc__SecurityContextTokenType(struct soap *soap, struct wsc__SecurityContextTokenType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsc__SecurityContextTokenType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct wsc__SecurityContextTokenType * SOAP_FMAC2 soap_instantiate_wsc__SecurityContextTokenType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_wsc__SecurityContextTokenType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_wsc__SecurityContextTokenType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct wsc__SecurityContextTokenType);
		if (size)
			*size = sizeof(struct wsc__SecurityContextTokenType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct wsc__SecurityContextTokenType, n);
		if (size)
			*size = n * sizeof(struct wsc__SecurityContextTokenType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct wsc__SecurityContextTokenType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_wsc__SecurityContextTokenType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct wsc__SecurityContextTokenType %p -> %p\n", q, p));
	*(struct wsc__SecurityContextTokenType*)p = *(struct wsc__SecurityContextTokenType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___xenc__union_ReferenceList(struct soap *soap, struct __xenc__union_ReferenceList *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->DataReference = NULL;
	a->KeyReference = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___xenc__union_ReferenceList(struct soap *soap, const struct __xenc__union_ReferenceList *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxenc__ReferenceType(soap, &a->DataReference);
	soap_serialize_PointerToxenc__ReferenceType(soap, &a->KeyReference);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___xenc__union_ReferenceList(struct soap *soap, const char *tag, int id, const struct __xenc__union_ReferenceList *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerToxenc__ReferenceType(soap, "xenc:DataReference", -1, &a->DataReference, ""))
		return soap->error;
	if (soap_out_PointerToxenc__ReferenceType(soap, "xenc:KeyReference", -1, &a->KeyReference, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __xenc__union_ReferenceList * SOAP_FMAC4 soap_in___xenc__union_ReferenceList(struct soap *soap, const char *tag, struct __xenc__union_ReferenceList *a, const char *type)
{
	size_t soap_flag_DataReference = 1;
	size_t soap_flag_KeyReference = 1;
	short soap_flag;
	a = (struct __xenc__union_ReferenceList *)soap_id_enter(soap, "", a, SOAP_TYPE___xenc__union_ReferenceList, sizeof(struct __xenc__union_ReferenceList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___xenc__union_ReferenceList(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_DataReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__ReferenceType(soap, "xenc:DataReference", &a->DataReference, "xenc:ReferenceType"))
				{	soap_flag_DataReference--;
					continue;
				}
			if (soap_flag_KeyReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__ReferenceType(soap, "xenc:KeyReference", &a->KeyReference, "xenc:ReferenceType"))
				{	soap_flag_KeyReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___xenc__union_ReferenceList(struct soap *soap, const struct __xenc__union_ReferenceList *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___xenc__union_ReferenceList(soap, tag?tag:"-xenc:union-ReferenceList", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __xenc__union_ReferenceList * SOAP_FMAC4 soap_get___xenc__union_ReferenceList(struct soap *soap, struct __xenc__union_ReferenceList *p, const char *tag, const char *type)
{
	if ((p = soap_in___xenc__union_ReferenceList(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __xenc__union_ReferenceList * SOAP_FMAC2 soap_instantiate___xenc__union_ReferenceList(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___xenc__union_ReferenceList(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___xenc__union_ReferenceList, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __xenc__union_ReferenceList);
		if (size)
			*size = sizeof(struct __xenc__union_ReferenceList);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __xenc__union_ReferenceList, n);
		if (size)
			*size = n * sizeof(struct __xenc__union_ReferenceList);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __xenc__union_ReferenceList*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___xenc__union_ReferenceList(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __xenc__union_ReferenceList %p -> %p\n", q, p));
	*(struct __xenc__union_ReferenceList*)p = *(struct __xenc__union_ReferenceList*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__xenc__ReferenceList(struct soap *soap, struct _xenc__ReferenceList *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size_ReferenceList = 0;
	a->__union_ReferenceList = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__xenc__ReferenceList(struct soap *soap, const struct _xenc__ReferenceList *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->__union_ReferenceList)
	{	int i;
		for (i = 0; i < a->__size_ReferenceList; i++)
		{
			soap_serialize___xenc__union_ReferenceList(soap, a->__union_ReferenceList + i);
		}
	}
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__xenc__ReferenceList(struct soap *soap, const char *tag, int id, const struct _xenc__ReferenceList *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__xenc__ReferenceList), type))
		return soap->error;
	if (a->__union_ReferenceList)
	{	int i;
		for (i = 0; i < a->__size_ReferenceList; i++)
			if (soap_out___xenc__union_ReferenceList(soap, "-union-ReferenceList", -1, a->__union_ReferenceList + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _xenc__ReferenceList * SOAP_FMAC4 soap_in__xenc__ReferenceList(struct soap *soap, const char *tag, struct _xenc__ReferenceList *a, const char *type)
{
	struct soap_blist *soap_blist___union_ReferenceList = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _xenc__ReferenceList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__xenc__ReferenceList, sizeof(struct _xenc__ReferenceList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__xenc__ReferenceList(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__union_ReferenceList == NULL)
				{	if (soap_blist___union_ReferenceList == NULL)
						soap_blist___union_ReferenceList = soap_new_block(soap);
					a->__union_ReferenceList = (struct __xenc__union_ReferenceList *)soap_push_block(soap, soap_blist___union_ReferenceList, sizeof(struct __xenc__union_ReferenceList));
					if (a->__union_ReferenceList == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->__union_ReferenceList, struct __xenc__union_ReferenceList);
					soap_default___xenc__union_ReferenceList(soap, a->__union_ReferenceList);
				}
				if (soap_in___xenc__union_ReferenceList(soap, "-union-ReferenceList", a->__union_ReferenceList, "-xenc:union-ReferenceList"))
				{	a->__size_ReferenceList++;
					a->__union_ReferenceList = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__union_ReferenceList)
			soap_pop_block(soap, soap_blist___union_ReferenceList);
		if (a->__size_ReferenceList)
			a->__union_ReferenceList = (struct __xenc__union_ReferenceList *)soap_save_block(soap, soap_blist___union_ReferenceList, NULL, 1);
		else
		{	a->__union_ReferenceList = NULL;
			if (soap_blist___union_ReferenceList)
				soap_end_block(soap, soap_blist___union_ReferenceList);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _xenc__ReferenceList *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__xenc__ReferenceList, 0, sizeof(struct _xenc__ReferenceList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->__size_ReferenceList < 1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__xenc__ReferenceList(struct soap *soap, const struct _xenc__ReferenceList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__xenc__ReferenceList);
	if (soap_out__xenc__ReferenceList(soap, tag?tag:"xenc:ReferenceList", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _xenc__ReferenceList * SOAP_FMAC4 soap_get__xenc__ReferenceList(struct soap *soap, struct _xenc__ReferenceList *p, const char *tag, const char *type)
{
	if ((p = soap_in__xenc__ReferenceList(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _xenc__ReferenceList * SOAP_FMAC2 soap_instantiate__xenc__ReferenceList(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__xenc__ReferenceList(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__xenc__ReferenceList, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _xenc__ReferenceList);
		if (size)
			*size = sizeof(struct _xenc__ReferenceList);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _xenc__ReferenceList, n);
		if (size)
			*size = n * sizeof(struct _xenc__ReferenceList);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _xenc__ReferenceList*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__xenc__ReferenceList(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _xenc__ReferenceList %p -> %p\n", q, p));
	*(struct _xenc__ReferenceList*)p = *(struct _xenc__ReferenceList*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__EncryptionPropertyType(struct soap *soap, struct xenc__EncryptionPropertyType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Target);
	soap_default_string(soap, &a->Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__EncryptionPropertyType(struct soap *soap, const struct xenc__EncryptionPropertyType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__EncryptionPropertyType(struct soap *soap, const char *tag, int id, const struct xenc__EncryptionPropertyType *a, const char *type)
{
	if (a->Target)
		soap_set_attr(soap, "Target", a->Target, 1);
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__EncryptionPropertyType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__EncryptionPropertyType * SOAP_FMAC4 soap_in_xenc__EncryptionPropertyType(struct soap *soap, const char *tag, struct xenc__EncryptionPropertyType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__EncryptionPropertyType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__EncryptionPropertyType, sizeof(struct xenc__EncryptionPropertyType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__EncryptionPropertyType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Target", 0), &a->Target, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptionPropertyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__EncryptionPropertyType, 0, sizeof(struct xenc__EncryptionPropertyType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__EncryptionPropertyType(struct soap *soap, const struct xenc__EncryptionPropertyType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__EncryptionPropertyType);
	if (soap_out_xenc__EncryptionPropertyType(soap, tag?tag:"xenc:EncryptionPropertyType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptionPropertyType * SOAP_FMAC4 soap_get_xenc__EncryptionPropertyType(struct soap *soap, struct xenc__EncryptionPropertyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__EncryptionPropertyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__EncryptionPropertyType * SOAP_FMAC2 soap_instantiate_xenc__EncryptionPropertyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__EncryptionPropertyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__EncryptionPropertyType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__EncryptionPropertyType);
		if (size)
			*size = sizeof(struct xenc__EncryptionPropertyType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__EncryptionPropertyType, n);
		if (size)
			*size = n * sizeof(struct xenc__EncryptionPropertyType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__EncryptionPropertyType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__EncryptionPropertyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__EncryptionPropertyType %p -> %p\n", q, p));
	*(struct xenc__EncryptionPropertyType*)p = *(struct xenc__EncryptionPropertyType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__EncryptionPropertiesType(struct soap *soap, struct xenc__EncryptionPropertiesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeEncryptionProperty = 0;
	a->EncryptionProperty = NULL;
	soap_default_string(soap, &a->Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__EncryptionPropertiesType(struct soap *soap, const struct xenc__EncryptionPropertiesType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->EncryptionProperty)
	{	int i;
		for (i = 0; i < a->__sizeEncryptionProperty; i++)
		{
			soap_embedded(soap, a->EncryptionProperty + i, SOAP_TYPE_xenc__EncryptionPropertyType);
			soap_serialize_xenc__EncryptionPropertyType(soap, a->EncryptionProperty + i);
		}
	}
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__EncryptionPropertiesType(struct soap *soap, const char *tag, int id, const struct xenc__EncryptionPropertiesType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__EncryptionPropertiesType), type))
		return soap->error;
	if (a->EncryptionProperty)
	{	int i;
		for (i = 0; i < a->__sizeEncryptionProperty; i++)
			if (soap_out_xenc__EncryptionPropertyType(soap, "xenc:EncryptionProperty", -1, a->EncryptionProperty + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__EncryptionPropertiesType * SOAP_FMAC4 soap_in_xenc__EncryptionPropertiesType(struct soap *soap, const char *tag, struct xenc__EncryptionPropertiesType *a, const char *type)
{
	struct soap_blist *soap_blist_EncryptionProperty = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__EncryptionPropertiesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__EncryptionPropertiesType, sizeof(struct xenc__EncryptionPropertiesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__EncryptionPropertiesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "xenc:EncryptionProperty", 1, NULL))
			{	if (a->EncryptionProperty == NULL)
				{	if (soap_blist_EncryptionProperty == NULL)
						soap_blist_EncryptionProperty = soap_new_block(soap);
					a->EncryptionProperty = (struct xenc__EncryptionPropertyType *)soap_push_block(soap, soap_blist_EncryptionProperty, sizeof(struct xenc__EncryptionPropertyType));
					if (a->EncryptionProperty == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->EncryptionProperty, struct xenc__EncryptionPropertyType);
					soap_default_xenc__EncryptionPropertyType(soap, a->EncryptionProperty);
				}
				soap_revert(soap);
				if (soap_in_xenc__EncryptionPropertyType(soap, "xenc:EncryptionProperty", a->EncryptionProperty, "xenc:EncryptionPropertyType"))
				{	a->__sizeEncryptionProperty++;
					a->EncryptionProperty = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->EncryptionProperty)
			soap_pop_block(soap, soap_blist_EncryptionProperty);
		if (a->__sizeEncryptionProperty)
			a->EncryptionProperty = (struct xenc__EncryptionPropertyType *)soap_save_block(soap, soap_blist_EncryptionProperty, NULL, 1);
		else
		{	a->EncryptionProperty = NULL;
			if (soap_blist_EncryptionProperty)
				soap_end_block(soap, soap_blist_EncryptionProperty);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptionPropertiesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__EncryptionPropertiesType, 0, sizeof(struct xenc__EncryptionPropertiesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (a->__sizeEncryptionProperty < 1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__EncryptionPropertiesType(struct soap *soap, const struct xenc__EncryptionPropertiesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__EncryptionPropertiesType);
	if (soap_out_xenc__EncryptionPropertiesType(soap, tag?tag:"xenc:EncryptionPropertiesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptionPropertiesType * SOAP_FMAC4 soap_get_xenc__EncryptionPropertiesType(struct soap *soap, struct xenc__EncryptionPropertiesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__EncryptionPropertiesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__EncryptionPropertiesType * SOAP_FMAC2 soap_instantiate_xenc__EncryptionPropertiesType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__EncryptionPropertiesType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__EncryptionPropertiesType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__EncryptionPropertiesType);
		if (size)
			*size = sizeof(struct xenc__EncryptionPropertiesType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__EncryptionPropertiesType, n);
		if (size)
			*size = n * sizeof(struct xenc__EncryptionPropertiesType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__EncryptionPropertiesType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__EncryptionPropertiesType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__EncryptionPropertiesType %p -> %p\n", q, p));
	*(struct xenc__EncryptionPropertiesType*)p = *(struct xenc__EncryptionPropertiesType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__ReferenceType(struct soap *soap, struct xenc__ReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->URI);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__ReferenceType(struct soap *soap, const struct xenc__ReferenceType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__ReferenceType(struct soap *soap, const char *tag, int id, const struct xenc__ReferenceType *a, const char *type)
{
	if (a->URI)
		soap_set_attr(soap, "URI", a->URI, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__ReferenceType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__ReferenceType * SOAP_FMAC4 soap_in_xenc__ReferenceType(struct soap *soap, const char *tag, struct xenc__ReferenceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__ReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__ReferenceType, sizeof(struct xenc__ReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__ReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "URI", 1), &a->URI, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__ReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__ReferenceType, 0, sizeof(struct xenc__ReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__ReferenceType(struct soap *soap, const struct xenc__ReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__ReferenceType);
	if (soap_out_xenc__ReferenceType(soap, tag?tag:"xenc:ReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__ReferenceType * SOAP_FMAC4 soap_get_xenc__ReferenceType(struct soap *soap, struct xenc__ReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__ReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__ReferenceType * SOAP_FMAC2 soap_instantiate_xenc__ReferenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__ReferenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__ReferenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__ReferenceType);
		if (size)
			*size = sizeof(struct xenc__ReferenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__ReferenceType, n);
		if (size)
			*size = n * sizeof(struct xenc__ReferenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__ReferenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__ReferenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__ReferenceType %p -> %p\n", q, p));
	*(struct xenc__ReferenceType*)p = *(struct xenc__ReferenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__AgreementMethodType(struct soap *soap, struct xenc__AgreementMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->KA_Nonce);
	a->OriginatorKeyInfo = NULL;
	a->RecipientKeyInfo = NULL;
	soap_default_string(soap, &a->Algorithm);
	a->__mixed = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__AgreementMethodType(struct soap *soap, const struct xenc__AgreementMethodType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->KA_Nonce);
	soap_serialize_PointerTods__KeyInfoType(soap, &a->OriginatorKeyInfo);
	soap_serialize_PointerTods__KeyInfoType(soap, &a->RecipientKeyInfo);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__AgreementMethodType(struct soap *soap, const char *tag, int id, const struct xenc__AgreementMethodType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__AgreementMethodType), type))
		return soap->error;
	if (soap_out_string(soap, "xenc:KA-Nonce", -1, &a->KA_Nonce, ""))
		return soap->error;
	if (soap_out_PointerTods__KeyInfoType(soap, "xenc:OriginatorKeyInfo", -1, &a->OriginatorKeyInfo, ""))
		return soap->error;
	if (soap_out_PointerTods__KeyInfoType(soap, "xenc:RecipientKeyInfo", -1, &a->RecipientKeyInfo, ""))
		return soap->error;
	soap_outliteral(soap, "-mixed", &a->__mixed, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__AgreementMethodType * SOAP_FMAC4 soap_in_xenc__AgreementMethodType(struct soap *soap, const char *tag, struct xenc__AgreementMethodType *a, const char *type)
{
	size_t soap_flag_KA_Nonce = 1;
	size_t soap_flag_OriginatorKeyInfo = 1;
	size_t soap_flag_RecipientKeyInfo = 1;
	size_t soap_flag___mixed = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__AgreementMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__AgreementMethodType, sizeof(struct xenc__AgreementMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__AgreementMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 1), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_KA_Nonce && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "xenc:KA-Nonce", &a->KA_Nonce, "xsd:string"))
				{	soap_flag_KA_Nonce--;
					continue;
				}
			if (soap_flag_OriginatorKeyInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__KeyInfoType(soap, "xenc:OriginatorKeyInfo", &a->OriginatorKeyInfo, "ds:KeyInfoType"))
				{	soap_flag_OriginatorKeyInfo--;
					continue;
				}
			if (soap_flag_RecipientKeyInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__KeyInfoType(soap, "xenc:RecipientKeyInfo", &a->RecipientKeyInfo, "ds:KeyInfoType"))
				{	soap_flag_RecipientKeyInfo--;
					continue;
				}
			if (soap_flag___mixed && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-mixed", &a->__mixed))
				{	soap_flag___mixed--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__AgreementMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__AgreementMethodType, 0, sizeof(struct xenc__AgreementMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__AgreementMethodType(struct soap *soap, const struct xenc__AgreementMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__AgreementMethodType);
	if (soap_out_xenc__AgreementMethodType(soap, tag?tag:"xenc:AgreementMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__AgreementMethodType * SOAP_FMAC4 soap_get_xenc__AgreementMethodType(struct soap *soap, struct xenc__AgreementMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__AgreementMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__AgreementMethodType * SOAP_FMAC2 soap_instantiate_xenc__AgreementMethodType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__AgreementMethodType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__AgreementMethodType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__AgreementMethodType);
		if (size)
			*size = sizeof(struct xenc__AgreementMethodType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__AgreementMethodType, n);
		if (size)
			*size = n * sizeof(struct xenc__AgreementMethodType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__AgreementMethodType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__AgreementMethodType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__AgreementMethodType %p -> %p\n", q, p));
	*(struct xenc__AgreementMethodType*)p = *(struct xenc__AgreementMethodType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__EncryptedKeyType(struct soap *soap, struct xenc__EncryptedKeyType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->EncryptionMethod = NULL;
	a->ds__KeyInfo = NULL;
	a->CipherData = NULL;
	a->EncryptionProperties = NULL;
	soap_default_string(soap, &a->Id);
	soap_default_string(soap, &a->Type);
	soap_default_string(soap, &a->MimeType);
	soap_default_string(soap, &a->Encoding);
	a->ReferenceList = NULL;
	soap_default_string(soap, &a->CarriedKeyName);
	soap_default_string(soap, &a->Recipient);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__EncryptedKeyType(struct soap *soap, const struct xenc__EncryptedKeyType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxenc__EncryptionMethodType(soap, &a->EncryptionMethod);
	soap_serialize_PointerTo_ds__KeyInfo(soap, &a->ds__KeyInfo);
	soap_serialize_PointerToxenc__CipherDataType(soap, &a->CipherData);
	soap_serialize_PointerToxenc__EncryptionPropertiesType(soap, &a->EncryptionProperties);
	soap_serialize_PointerTo_xenc__ReferenceList(soap, &a->ReferenceList);
	soap_serialize_string(soap, &a->CarriedKeyName);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__EncryptedKeyType(struct soap *soap, const char *tag, int id, const struct xenc__EncryptedKeyType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type, 1);
	if (a->MimeType)
		soap_set_attr(soap, "MimeType", a->MimeType, 1);
	if (a->Encoding)
		soap_set_attr(soap, "Encoding", a->Encoding, 1);
	if (a->Recipient)
		soap_set_attr(soap, "Recipient", a->Recipient, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__EncryptedKeyType), type))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptionMethodType(soap, "xenc:EncryptionMethod", -1, &a->EncryptionMethod, ""))
		return soap->error;
	if (soap_out_PointerTo_ds__KeyInfo(soap, "ds:KeyInfo", -1, &a->ds__KeyInfo, ""))
		return soap->error;
	if (a->CipherData)
	{	if (soap_out_PointerToxenc__CipherDataType(soap, "xenc:CipherData", -1, &a->CipherData, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "xenc:CipherData"))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptionPropertiesType(soap, "xenc:EncryptionProperties", -1, &a->EncryptionProperties, ""))
		return soap->error;
	if (soap_out_PointerTo_xenc__ReferenceList(soap, "xenc:ReferenceList", -1, &a->ReferenceList, ""))
		return soap->error;
	if (soap_out_string(soap, "xenc:CarriedKeyName", -1, &a->CarriedKeyName, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__EncryptedKeyType * SOAP_FMAC4 soap_in_xenc__EncryptedKeyType(struct soap *soap, const char *tag, struct xenc__EncryptedKeyType *a, const char *type)
{
	size_t soap_flag_EncryptionMethod = 1;
	size_t soap_flag_ds__KeyInfo = 1;
	size_t soap_flag_CipherData = 1;
	size_t soap_flag_EncryptionProperties = 1;
	size_t soap_flag_ReferenceList = 1;
	size_t soap_flag_CarriedKeyName = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__EncryptedKeyType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__EncryptedKeyType, sizeof(struct xenc__EncryptedKeyType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__EncryptedKeyType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "MimeType", 0), &a->MimeType, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Encoding", 0), &a->Encoding, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Recipient", 0), &a->Recipient, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_EncryptionMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptionMethodType(soap, "xenc:EncryptionMethod", &a->EncryptionMethod, "xenc:EncryptionMethodType"))
				{	soap_flag_EncryptionMethod--;
					continue;
				}
			if (soap_flag_ds__KeyInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ds__KeyInfo(soap, "ds:KeyInfo", &a->ds__KeyInfo, ""))
				{	soap_flag_ds__KeyInfo--;
					continue;
				}
			if (soap_flag_CipherData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__CipherDataType(soap, "xenc:CipherData", &a->CipherData, "xenc:CipherDataType"))
				{	soap_flag_CipherData--;
					continue;
				}
			if (soap_flag_EncryptionProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptionPropertiesType(soap, "xenc:EncryptionProperties", &a->EncryptionProperties, "xenc:EncryptionPropertiesType"))
				{	soap_flag_EncryptionProperties--;
					continue;
				}
			if (soap_flag_ReferenceList && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_xenc__ReferenceList(soap, "xenc:ReferenceList", &a->ReferenceList, ""))
				{	soap_flag_ReferenceList--;
					continue;
				}
			if (soap_flag_CarriedKeyName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "xenc:CarriedKeyName", &a->CarriedKeyName, "xsd:string"))
				{	soap_flag_CarriedKeyName--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptedKeyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__EncryptedKeyType, 0, sizeof(struct xenc__EncryptedKeyType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CipherData > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__EncryptedKeyType(struct soap *soap, const struct xenc__EncryptedKeyType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__EncryptedKeyType);
	if (soap_out_xenc__EncryptedKeyType(soap, tag?tag:"xenc:EncryptedKeyType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptedKeyType * SOAP_FMAC4 soap_get_xenc__EncryptedKeyType(struct soap *soap, struct xenc__EncryptedKeyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__EncryptedKeyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__EncryptedKeyType * SOAP_FMAC2 soap_instantiate_xenc__EncryptedKeyType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__EncryptedKeyType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__EncryptedKeyType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__EncryptedKeyType);
		if (size)
			*size = sizeof(struct xenc__EncryptedKeyType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__EncryptedKeyType, n);
		if (size)
			*size = n * sizeof(struct xenc__EncryptedKeyType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__EncryptedKeyType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__EncryptedKeyType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__EncryptedKeyType %p -> %p\n", q, p));
	*(struct xenc__EncryptedKeyType*)p = *(struct xenc__EncryptedKeyType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__EncryptedDataType(struct soap *soap, struct xenc__EncryptedDataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->EncryptionMethod = NULL;
	a->ds__KeyInfo = NULL;
	a->CipherData = NULL;
	a->EncryptionProperties = NULL;
	soap_default_string(soap, &a->Id);
	soap_default_string(soap, &a->Type);
	soap_default_string(soap, &a->MimeType);
	soap_default_string(soap, &a->Encoding);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__EncryptedDataType(struct soap *soap, const struct xenc__EncryptedDataType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxenc__EncryptionMethodType(soap, &a->EncryptionMethod);
	soap_serialize_PointerTo_ds__KeyInfo(soap, &a->ds__KeyInfo);
	soap_serialize_PointerToxenc__CipherDataType(soap, &a->CipherData);
	soap_serialize_PointerToxenc__EncryptionPropertiesType(soap, &a->EncryptionProperties);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__EncryptedDataType(struct soap *soap, const char *tag, int id, const struct xenc__EncryptedDataType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type, 1);
	if (a->MimeType)
		soap_set_attr(soap, "MimeType", a->MimeType, 1);
	if (a->Encoding)
		soap_set_attr(soap, "Encoding", a->Encoding, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__EncryptedDataType), type))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptionMethodType(soap, "xenc:EncryptionMethod", -1, &a->EncryptionMethod, ""))
		return soap->error;
	if (soap_out_PointerTo_ds__KeyInfo(soap, "ds:KeyInfo", -1, &a->ds__KeyInfo, ""))
		return soap->error;
	if (a->CipherData)
	{	if (soap_out_PointerToxenc__CipherDataType(soap, "xenc:CipherData", -1, &a->CipherData, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "xenc:CipherData"))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptionPropertiesType(soap, "xenc:EncryptionProperties", -1, &a->EncryptionProperties, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__EncryptedDataType * SOAP_FMAC4 soap_in_xenc__EncryptedDataType(struct soap *soap, const char *tag, struct xenc__EncryptedDataType *a, const char *type)
{
	size_t soap_flag_EncryptionMethod = 1;
	size_t soap_flag_ds__KeyInfo = 1;
	size_t soap_flag_CipherData = 1;
	size_t soap_flag_EncryptionProperties = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__EncryptedDataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__EncryptedDataType, sizeof(struct xenc__EncryptedDataType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__EncryptedDataType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "MimeType", 0), &a->MimeType, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Encoding", 0), &a->Encoding, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_EncryptionMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptionMethodType(soap, "xenc:EncryptionMethod", &a->EncryptionMethod, "xenc:EncryptionMethodType"))
				{	soap_flag_EncryptionMethod--;
					continue;
				}
			if (soap_flag_ds__KeyInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ds__KeyInfo(soap, "ds:KeyInfo", &a->ds__KeyInfo, ""))
				{	soap_flag_ds__KeyInfo--;
					continue;
				}
			if (soap_flag_CipherData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__CipherDataType(soap, "xenc:CipherData", &a->CipherData, "xenc:CipherDataType"))
				{	soap_flag_CipherData--;
					continue;
				}
			if (soap_flag_EncryptionProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptionPropertiesType(soap, "xenc:EncryptionProperties", &a->EncryptionProperties, "xenc:EncryptionPropertiesType"))
				{	soap_flag_EncryptionProperties--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptedDataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__EncryptedDataType, 0, sizeof(struct xenc__EncryptedDataType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CipherData > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__EncryptedDataType(struct soap *soap, const struct xenc__EncryptedDataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__EncryptedDataType);
	if (soap_out_xenc__EncryptedDataType(soap, tag?tag:"xenc:EncryptedDataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptedDataType * SOAP_FMAC4 soap_get_xenc__EncryptedDataType(struct soap *soap, struct xenc__EncryptedDataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__EncryptedDataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__EncryptedDataType * SOAP_FMAC2 soap_instantiate_xenc__EncryptedDataType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__EncryptedDataType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__EncryptedDataType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__EncryptedDataType);
		if (size)
			*size = sizeof(struct xenc__EncryptedDataType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__EncryptedDataType, n);
		if (size)
			*size = n * sizeof(struct xenc__EncryptedDataType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__EncryptedDataType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__EncryptedDataType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__EncryptedDataType %p -> %p\n", q, p));
	*(struct xenc__EncryptedDataType*)p = *(struct xenc__EncryptedDataType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__TransformsType(struct soap *soap, struct xenc__TransformsType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__ds__Transform(soap, &a->ds__Transform);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__TransformsType(struct soap *soap, const struct xenc__TransformsType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__ds__Transform(soap, &a->ds__Transform);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__TransformsType(struct soap *soap, const char *tag, int id, const struct xenc__TransformsType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__TransformsType), type))
		return soap->error;
	if (soap_out__ds__Transform(soap, "ds:Transform", -1, &a->ds__Transform, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__TransformsType * SOAP_FMAC4 soap_in_xenc__TransformsType(struct soap *soap, const char *tag, struct xenc__TransformsType *a, const char *type)
{
	size_t soap_flag_ds__Transform = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__TransformsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__TransformsType, sizeof(struct xenc__TransformsType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__TransformsType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ds__Transform && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__ds__Transform(soap, "ds:Transform", &a->ds__Transform, ""))
				{	soap_flag_ds__Transform--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__TransformsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__TransformsType, 0, sizeof(struct xenc__TransformsType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ds__Transform > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__TransformsType(struct soap *soap, const struct xenc__TransformsType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__TransformsType);
	if (soap_out_xenc__TransformsType(soap, tag?tag:"xenc:TransformsType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__TransformsType * SOAP_FMAC4 soap_get_xenc__TransformsType(struct soap *soap, struct xenc__TransformsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__TransformsType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__TransformsType * SOAP_FMAC2 soap_instantiate_xenc__TransformsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__TransformsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__TransformsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__TransformsType);
		if (size)
			*size = sizeof(struct xenc__TransformsType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__TransformsType, n);
		if (size)
			*size = n * sizeof(struct xenc__TransformsType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__TransformsType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__TransformsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__TransformsType %p -> %p\n", q, p));
	*(struct xenc__TransformsType*)p = *(struct xenc__TransformsType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__CipherReferenceType(struct soap *soap, struct xenc__CipherReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Transforms = NULL;
	soap_default_string(soap, &a->URI);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__CipherReferenceType(struct soap *soap, const struct xenc__CipherReferenceType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxenc__TransformsType(soap, &a->Transforms);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__CipherReferenceType(struct soap *soap, const char *tag, int id, const struct xenc__CipherReferenceType *a, const char *type)
{
	if (a->URI)
		soap_set_attr(soap, "URI", a->URI, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__CipherReferenceType), type))
		return soap->error;
	if (soap_out_PointerToxenc__TransformsType(soap, "xenc:Transforms", -1, &a->Transforms, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__CipherReferenceType * SOAP_FMAC4 soap_in_xenc__CipherReferenceType(struct soap *soap, const char *tag, struct xenc__CipherReferenceType *a, const char *type)
{
	size_t soap_flag_Transforms = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__CipherReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__CipherReferenceType, sizeof(struct xenc__CipherReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__CipherReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "URI", 1), &a->URI, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Transforms && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__TransformsType(soap, "xenc:Transforms", &a->Transforms, "xenc:TransformsType"))
				{	soap_flag_Transforms--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__CipherReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__CipherReferenceType, 0, sizeof(struct xenc__CipherReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__CipherReferenceType(struct soap *soap, const struct xenc__CipherReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__CipherReferenceType);
	if (soap_out_xenc__CipherReferenceType(soap, tag?tag:"xenc:CipherReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__CipherReferenceType * SOAP_FMAC4 soap_get_xenc__CipherReferenceType(struct soap *soap, struct xenc__CipherReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__CipherReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__CipherReferenceType * SOAP_FMAC2 soap_instantiate_xenc__CipherReferenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__CipherReferenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__CipherReferenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__CipherReferenceType);
		if (size)
			*size = sizeof(struct xenc__CipherReferenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__CipherReferenceType, n);
		if (size)
			*size = n * sizeof(struct xenc__CipherReferenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__CipherReferenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__CipherReferenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__CipherReferenceType %p -> %p\n", q, p));
	*(struct xenc__CipherReferenceType*)p = *(struct xenc__CipherReferenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__CipherDataType(struct soap *soap, struct xenc__CipherDataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->CipherValue);
	a->CipherReference = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__CipherDataType(struct soap *soap, const struct xenc__CipherDataType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->CipherValue);
	soap_serialize_PointerToxenc__CipherReferenceType(soap, &a->CipherReference);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__CipherDataType(struct soap *soap, const char *tag, int id, const struct xenc__CipherDataType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__CipherDataType), type))
		return soap->error;
	if (soap_out_string(soap, "xenc:CipherValue", -1, &a->CipherValue, ""))
		return soap->error;
	if (soap_out_PointerToxenc__CipherReferenceType(soap, "xenc:CipherReference", -1, &a->CipherReference, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__CipherDataType * SOAP_FMAC4 soap_in_xenc__CipherDataType(struct soap *soap, const char *tag, struct xenc__CipherDataType *a, const char *type)
{
	size_t soap_flag_CipherValue = 1;
	size_t soap_flag_CipherReference = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__CipherDataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__CipherDataType, sizeof(struct xenc__CipherDataType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__CipherDataType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CipherValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "xenc:CipherValue", &a->CipherValue, "xsd:string"))
				{	soap_flag_CipherValue--;
					continue;
				}
			if (soap_flag_CipherReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__CipherReferenceType(soap, "xenc:CipherReference", &a->CipherReference, "xenc:CipherReferenceType"))
				{	soap_flag_CipherReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__CipherDataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__CipherDataType, 0, sizeof(struct xenc__CipherDataType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__CipherDataType(struct soap *soap, const struct xenc__CipherDataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__CipherDataType);
	if (soap_out_xenc__CipherDataType(soap, tag?tag:"xenc:CipherDataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__CipherDataType * SOAP_FMAC4 soap_get_xenc__CipherDataType(struct soap *soap, struct xenc__CipherDataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__CipherDataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__CipherDataType * SOAP_FMAC2 soap_instantiate_xenc__CipherDataType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__CipherDataType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__CipherDataType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__CipherDataType);
		if (size)
			*size = sizeof(struct xenc__CipherDataType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__CipherDataType, n);
		if (size)
			*size = n * sizeof(struct xenc__CipherDataType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__CipherDataType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__CipherDataType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__CipherDataType %p -> %p\n", q, p));
	*(struct xenc__CipherDataType*)p = *(struct xenc__CipherDataType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__EncryptionMethodType(struct soap *soap, struct xenc__EncryptionMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->KeySize = NULL;
	soap_default_string(soap, &a->OAEPparams);
	soap_default_string(soap, &a->Algorithm);
	a->ds__DigestMethod = NULL;
	a->__mixed = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__EncryptionMethodType(struct soap *soap, const struct xenc__EncryptionMethodType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->KeySize);
	soap_serialize_string(soap, &a->OAEPparams);
	soap_serialize_PointerTods__DigestMethodType(soap, &a->ds__DigestMethod);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__EncryptionMethodType(struct soap *soap, const char *tag, int id, const struct xenc__EncryptionMethodType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__EncryptionMethodType), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "xenc:KeySize", -1, &a->KeySize, ""))
		return soap->error;
	if (soap_out_string(soap, "xenc:OAEPparams", -1, &a->OAEPparams, ""))
		return soap->error;
	if (soap_out_PointerTods__DigestMethodType(soap, "ds:DigestMethod", -1, &a->ds__DigestMethod, ""))
		return soap->error;
	soap_outliteral(soap, "-mixed", &a->__mixed, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__EncryptionMethodType * SOAP_FMAC4 soap_in_xenc__EncryptionMethodType(struct soap *soap, const char *tag, struct xenc__EncryptionMethodType *a, const char *type)
{
	size_t soap_flag_KeySize = 1;
	size_t soap_flag_OAEPparams = 1;
	size_t soap_flag_ds__DigestMethod = 1;
	size_t soap_flag___mixed = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__EncryptionMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__EncryptionMethodType, sizeof(struct xenc__EncryptionMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__EncryptionMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 1), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_KeySize && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "xenc:KeySize", &a->KeySize, "xsd:int"))
				{	soap_flag_KeySize--;
					continue;
				}
			if (soap_flag_OAEPparams && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "xenc:OAEPparams", &a->OAEPparams, "xsd:string"))
				{	soap_flag_OAEPparams--;
					continue;
				}
			if (soap_flag_ds__DigestMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__DigestMethodType(soap, "ds:DigestMethod", &a->ds__DigestMethod, "ds:DigestMethodType"))
				{	soap_flag_ds__DigestMethod--;
					continue;
				}
			if (soap_flag___mixed && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-mixed", &a->__mixed))
				{	soap_flag___mixed--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptionMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__EncryptionMethodType, 0, sizeof(struct xenc__EncryptionMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__EncryptionMethodType(struct soap *soap, const struct xenc__EncryptionMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__EncryptionMethodType);
	if (soap_out_xenc__EncryptionMethodType(soap, tag?tag:"xenc:EncryptionMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptionMethodType * SOAP_FMAC4 soap_get_xenc__EncryptionMethodType(struct soap *soap, struct xenc__EncryptionMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__EncryptionMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__EncryptionMethodType * SOAP_FMAC2 soap_instantiate_xenc__EncryptionMethodType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__EncryptionMethodType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__EncryptionMethodType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__EncryptionMethodType);
		if (size)
			*size = sizeof(struct xenc__EncryptionMethodType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__EncryptionMethodType, n);
		if (size)
			*size = n * sizeof(struct xenc__EncryptionMethodType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__EncryptionMethodType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__EncryptionMethodType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__EncryptionMethodType %p -> %p\n", q, p));
	*(struct xenc__EncryptionMethodType*)p = *(struct xenc__EncryptionMethodType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xenc__EncryptedType(struct soap *soap, struct xenc__EncryptedType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->EncryptionMethod = NULL;
	a->ds__KeyInfo = NULL;
	a->CipherData = NULL;
	a->EncryptionProperties = NULL;
	soap_default_string(soap, &a->Id);
	soap_default_string(soap, &a->Type);
	soap_default_string(soap, &a->MimeType);
	soap_default_string(soap, &a->Encoding);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xenc__EncryptedType(struct soap *soap, const struct xenc__EncryptedType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxenc__EncryptionMethodType(soap, &a->EncryptionMethod);
	soap_serialize_PointerTo_ds__KeyInfo(soap, &a->ds__KeyInfo);
	soap_serialize_PointerToxenc__CipherDataType(soap, &a->CipherData);
	soap_serialize_PointerToxenc__EncryptionPropertiesType(soap, &a->EncryptionProperties);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xenc__EncryptedType(struct soap *soap, const char *tag, int id, const struct xenc__EncryptedType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type, 1);
	if (a->MimeType)
		soap_set_attr(soap, "MimeType", a->MimeType, 1);
	if (a->Encoding)
		soap_set_attr(soap, "Encoding", a->Encoding, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xenc__EncryptedType), type))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptionMethodType(soap, "xenc:EncryptionMethod", -1, &a->EncryptionMethod, ""))
		return soap->error;
	if (soap_out_PointerTo_ds__KeyInfo(soap, "ds:KeyInfo", -1, &a->ds__KeyInfo, ""))
		return soap->error;
	if (a->CipherData)
	{	if (soap_out_PointerToxenc__CipherDataType(soap, "xenc:CipherData", -1, &a->CipherData, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "xenc:CipherData"))
		return soap->error;
	if (soap_out_PointerToxenc__EncryptionPropertiesType(soap, "xenc:EncryptionProperties", -1, &a->EncryptionProperties, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xenc__EncryptedType * SOAP_FMAC4 soap_in_xenc__EncryptedType(struct soap *soap, const char *tag, struct xenc__EncryptedType *a, const char *type)
{
	size_t soap_flag_EncryptionMethod = 1;
	size_t soap_flag_ds__KeyInfo = 1;
	size_t soap_flag_CipherData = 1;
	size_t soap_flag_EncryptionProperties = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct xenc__EncryptedType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xenc__EncryptedType, sizeof(struct xenc__EncryptedType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xenc__EncryptedType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "MimeType", 0), &a->MimeType, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Encoding", 0), &a->Encoding, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_EncryptionMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptionMethodType(soap, "xenc:EncryptionMethod", &a->EncryptionMethod, "xenc:EncryptionMethodType"))
				{	soap_flag_EncryptionMethod--;
					continue;
				}
			if (soap_flag_ds__KeyInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ds__KeyInfo(soap, "ds:KeyInfo", &a->ds__KeyInfo, ""))
				{	soap_flag_ds__KeyInfo--;
					continue;
				}
			if (soap_flag_CipherData && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__CipherDataType(soap, "xenc:CipherData", &a->CipherData, "xenc:CipherDataType"))
				{	soap_flag_CipherData--;
					continue;
				}
			if (soap_flag_EncryptionProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxenc__EncryptionPropertiesType(soap, "xenc:EncryptionProperties", &a->EncryptionProperties, "xenc:EncryptionPropertiesType"))
				{	soap_flag_EncryptionProperties--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptedType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xenc__EncryptedType, 0, sizeof(struct xenc__EncryptedType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CipherData > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xenc__EncryptedType(struct soap *soap, const struct xenc__EncryptedType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xenc__EncryptedType);
	if (soap_out_xenc__EncryptedType(soap, tag?tag:"xenc:EncryptedType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptedType * SOAP_FMAC4 soap_get_xenc__EncryptedType(struct soap *soap, struct xenc__EncryptedType *p, const char *tag, const char *type)
{
	if ((p = soap_in_xenc__EncryptedType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct xenc__EncryptedType * SOAP_FMAC2 soap_instantiate_xenc__EncryptedType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xenc__EncryptedType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xenc__EncryptedType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct xenc__EncryptedType);
		if (size)
			*size = sizeof(struct xenc__EncryptedType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct xenc__EncryptedType, n);
		if (size)
			*size = n * sizeof(struct xenc__EncryptedType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct xenc__EncryptedType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xenc__EncryptedType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xenc__EncryptedType %p -> %p\n", q, p));
	*(struct xenc__EncryptedType*)p = *(struct xenc__EncryptedType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__RSAKeyValueType(struct soap *soap, struct ds__RSAKeyValueType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Modulus);
	soap_default_string(soap, &a->Exponent);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__RSAKeyValueType(struct soap *soap, const struct ds__RSAKeyValueType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Modulus);
	soap_serialize_string(soap, &a->Exponent);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__RSAKeyValueType(struct soap *soap, const char *tag, int id, const struct ds__RSAKeyValueType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__RSAKeyValueType), type))
		return soap->error;
	if (a->Modulus)
	{	if (soap_out_string(soap, "ds:Modulus", -1, &a->Modulus, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:Modulus"))
		return soap->error;
	if (a->Exponent)
	{	if (soap_out_string(soap, "ds:Exponent", -1, &a->Exponent, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:Exponent"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__RSAKeyValueType * SOAP_FMAC4 soap_in_ds__RSAKeyValueType(struct soap *soap, const char *tag, struct ds__RSAKeyValueType *a, const char *type)
{
	size_t soap_flag_Modulus = 1;
	size_t soap_flag_Exponent = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__RSAKeyValueType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__RSAKeyValueType, sizeof(struct ds__RSAKeyValueType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__RSAKeyValueType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Modulus && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:Modulus", &a->Modulus, "xsd:string"))
				{	soap_flag_Modulus--;
					continue;
				}
			if (soap_flag_Exponent && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:Exponent", &a->Exponent, "xsd:string"))
				{	soap_flag_Exponent--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__RSAKeyValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__RSAKeyValueType, 0, sizeof(struct ds__RSAKeyValueType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Modulus > 0 || soap_flag_Exponent > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__RSAKeyValueType(struct soap *soap, const struct ds__RSAKeyValueType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__RSAKeyValueType);
	if (soap_out_ds__RSAKeyValueType(soap, tag?tag:"ds:RSAKeyValueType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__RSAKeyValueType * SOAP_FMAC4 soap_get_ds__RSAKeyValueType(struct soap *soap, struct ds__RSAKeyValueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__RSAKeyValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__RSAKeyValueType * SOAP_FMAC2 soap_instantiate_ds__RSAKeyValueType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__RSAKeyValueType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__RSAKeyValueType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__RSAKeyValueType);
		if (size)
			*size = sizeof(struct ds__RSAKeyValueType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__RSAKeyValueType, n);
		if (size)
			*size = n * sizeof(struct ds__RSAKeyValueType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__RSAKeyValueType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__RSAKeyValueType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__RSAKeyValueType %p -> %p\n", q, p));
	*(struct ds__RSAKeyValueType*)p = *(struct ds__RSAKeyValueType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__DSAKeyValueType(struct soap *soap, struct ds__DSAKeyValueType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->G);
	soap_default_string(soap, &a->Y);
	soap_default_string(soap, &a->J);
	soap_default_string(soap, &a->P);
	soap_default_string(soap, &a->Q);
	soap_default_string(soap, &a->Seed);
	soap_default_string(soap, &a->PgenCounter);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__DSAKeyValueType(struct soap *soap, const struct ds__DSAKeyValueType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->G);
	soap_serialize_string(soap, &a->Y);
	soap_serialize_string(soap, &a->J);
	soap_serialize_string(soap, &a->P);
	soap_serialize_string(soap, &a->Q);
	soap_serialize_string(soap, &a->Seed);
	soap_serialize_string(soap, &a->PgenCounter);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__DSAKeyValueType(struct soap *soap, const char *tag, int id, const struct ds__DSAKeyValueType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__DSAKeyValueType), type))
		return soap->error;
	if (soap_out_string(soap, "ds:G", -1, &a->G, ""))
		return soap->error;
	if (a->Y)
	{	if (soap_out_string(soap, "ds:Y", -1, &a->Y, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:Y"))
		return soap->error;
	if (soap_out_string(soap, "ds:J", -1, &a->J, ""))
		return soap->error;
	if (a->P)
	{	if (soap_out_string(soap, "ds:P", -1, &a->P, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:P"))
		return soap->error;
	if (a->Q)
	{	if (soap_out_string(soap, "ds:Q", -1, &a->Q, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:Q"))
		return soap->error;
	if (a->Seed)
	{	if (soap_out_string(soap, "ds:Seed", -1, &a->Seed, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:Seed"))
		return soap->error;
	if (a->PgenCounter)
	{	if (soap_out_string(soap, "ds:PgenCounter", -1, &a->PgenCounter, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:PgenCounter"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__DSAKeyValueType * SOAP_FMAC4 soap_in_ds__DSAKeyValueType(struct soap *soap, const char *tag, struct ds__DSAKeyValueType *a, const char *type)
{
	size_t soap_flag_G = 1;
	size_t soap_flag_Y = 1;
	size_t soap_flag_J = 1;
	size_t soap_flag_P = 1;
	size_t soap_flag_Q = 1;
	size_t soap_flag_Seed = 1;
	size_t soap_flag_PgenCounter = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__DSAKeyValueType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__DSAKeyValueType, sizeof(struct ds__DSAKeyValueType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__DSAKeyValueType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_G && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:G", &a->G, "xsd:string"))
				{	soap_flag_G--;
					continue;
				}
			if (soap_flag_Y && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:Y", &a->Y, "xsd:string"))
				{	soap_flag_Y--;
					continue;
				}
			if (soap_flag_J && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:J", &a->J, "xsd:string"))
				{	soap_flag_J--;
					continue;
				}
			if (soap_flag_P && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:P", &a->P, "xsd:string"))
				{	soap_flag_P--;
					continue;
				}
			if (soap_flag_Q && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:Q", &a->Q, "xsd:string"))
				{	soap_flag_Q--;
					continue;
				}
			if (soap_flag_Seed && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:Seed", &a->Seed, "xsd:string"))
				{	soap_flag_Seed--;
					continue;
				}
			if (soap_flag_PgenCounter && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:PgenCounter", &a->PgenCounter, "xsd:string"))
				{	soap_flag_PgenCounter--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__DSAKeyValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__DSAKeyValueType, 0, sizeof(struct ds__DSAKeyValueType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Y > 0 || soap_flag_P > 0 || soap_flag_Q > 0 || soap_flag_Seed > 0 || soap_flag_PgenCounter > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__DSAKeyValueType(struct soap *soap, const struct ds__DSAKeyValueType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__DSAKeyValueType);
	if (soap_out_ds__DSAKeyValueType(soap, tag?tag:"ds:DSAKeyValueType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__DSAKeyValueType * SOAP_FMAC4 soap_get_ds__DSAKeyValueType(struct soap *soap, struct ds__DSAKeyValueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__DSAKeyValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__DSAKeyValueType * SOAP_FMAC2 soap_instantiate_ds__DSAKeyValueType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__DSAKeyValueType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__DSAKeyValueType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__DSAKeyValueType);
		if (size)
			*size = sizeof(struct ds__DSAKeyValueType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__DSAKeyValueType, n);
		if (size)
			*size = n * sizeof(struct ds__DSAKeyValueType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__DSAKeyValueType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__DSAKeyValueType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__DSAKeyValueType %p -> %p\n", q, p));
	*(struct ds__DSAKeyValueType*)p = *(struct ds__DSAKeyValueType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__X509IssuerSerialType(struct soap *soap, struct ds__X509IssuerSerialType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->X509IssuerName);
	soap_default_string(soap, &a->X509SerialNumber);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__X509IssuerSerialType(struct soap *soap, const struct ds__X509IssuerSerialType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->X509IssuerName);
	soap_serialize_string(soap, &a->X509SerialNumber);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__X509IssuerSerialType(struct soap *soap, const char *tag, int id, const struct ds__X509IssuerSerialType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__X509IssuerSerialType), type))
		return soap->error;
	if (a->X509IssuerName)
	{	if (soap_out_string(soap, "ds:X509IssuerName", -1, &a->X509IssuerName, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:X509IssuerName"))
		return soap->error;
	if (a->X509SerialNumber)
	{	if (soap_out_string(soap, "ds:X509SerialNumber", -1, &a->X509SerialNumber, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:X509SerialNumber"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__X509IssuerSerialType * SOAP_FMAC4 soap_in_ds__X509IssuerSerialType(struct soap *soap, const char *tag, struct ds__X509IssuerSerialType *a, const char *type)
{
	size_t soap_flag_X509IssuerName = 1;
	size_t soap_flag_X509SerialNumber = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__X509IssuerSerialType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__X509IssuerSerialType, sizeof(struct ds__X509IssuerSerialType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__X509IssuerSerialType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_X509IssuerName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:X509IssuerName", &a->X509IssuerName, "xsd:string"))
				{	soap_flag_X509IssuerName--;
					continue;
				}
			if (soap_flag_X509SerialNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:X509SerialNumber", &a->X509SerialNumber, "xsd:string"))
				{	soap_flag_X509SerialNumber--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__X509IssuerSerialType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__X509IssuerSerialType, 0, sizeof(struct ds__X509IssuerSerialType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_X509IssuerName > 0 || soap_flag_X509SerialNumber > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__X509IssuerSerialType(struct soap *soap, const struct ds__X509IssuerSerialType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__X509IssuerSerialType);
	if (soap_out_ds__X509IssuerSerialType(soap, tag?tag:"ds:X509IssuerSerialType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__X509IssuerSerialType * SOAP_FMAC4 soap_get_ds__X509IssuerSerialType(struct soap *soap, struct ds__X509IssuerSerialType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__X509IssuerSerialType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__X509IssuerSerialType * SOAP_FMAC2 soap_instantiate_ds__X509IssuerSerialType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__X509IssuerSerialType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__X509IssuerSerialType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__X509IssuerSerialType);
		if (size)
			*size = sizeof(struct ds__X509IssuerSerialType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__X509IssuerSerialType, n);
		if (size)
			*size = n * sizeof(struct ds__X509IssuerSerialType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__X509IssuerSerialType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__X509IssuerSerialType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__X509IssuerSerialType %p -> %p\n", q, p));
	*(struct ds__X509IssuerSerialType*)p = *(struct ds__X509IssuerSerialType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__RetrievalMethodType(struct soap *soap, struct ds__RetrievalMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Transforms = NULL;
	soap_default_string(soap, &a->URI);
	soap_default_string(soap, &a->Type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__RetrievalMethodType(struct soap *soap, const struct ds__RetrievalMethodType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTods__TransformsType(soap, &a->Transforms);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__RetrievalMethodType(struct soap *soap, const char *tag, int id, const struct ds__RetrievalMethodType *a, const char *type)
{
	if (a->URI)
		soap_set_attr(soap, "URI", a->URI, 1);
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__RetrievalMethodType), type))
		return soap->error;
	if (soap_out_PointerTods__TransformsType(soap, "ds:Transforms", -1, &a->Transforms, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__RetrievalMethodType * SOAP_FMAC4 soap_in_ds__RetrievalMethodType(struct soap *soap, const char *tag, struct ds__RetrievalMethodType *a, const char *type)
{
	size_t soap_flag_Transforms = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__RetrievalMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__RetrievalMethodType, sizeof(struct ds__RetrievalMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__RetrievalMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "URI", 0), &a->URI, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Transforms && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__TransformsType(soap, "ds:Transforms", &a->Transforms, "ds:TransformsType"))
				{	soap_flag_Transforms--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__RetrievalMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__RetrievalMethodType, 0, sizeof(struct ds__RetrievalMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__RetrievalMethodType(struct soap *soap, const struct ds__RetrievalMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__RetrievalMethodType);
	if (soap_out_ds__RetrievalMethodType(soap, tag?tag:"ds:RetrievalMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__RetrievalMethodType * SOAP_FMAC4 soap_get_ds__RetrievalMethodType(struct soap *soap, struct ds__RetrievalMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__RetrievalMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__RetrievalMethodType * SOAP_FMAC2 soap_instantiate_ds__RetrievalMethodType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__RetrievalMethodType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__RetrievalMethodType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__RetrievalMethodType);
		if (size)
			*size = sizeof(struct ds__RetrievalMethodType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__RetrievalMethodType, n);
		if (size)
			*size = n * sizeof(struct ds__RetrievalMethodType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__RetrievalMethodType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__RetrievalMethodType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__RetrievalMethodType %p -> %p\n", q, p));
	*(struct ds__RetrievalMethodType*)p = *(struct ds__RetrievalMethodType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__KeyValueType(struct soap *soap, struct ds__KeyValueType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->DSAKeyValue = NULL;
	a->RSAKeyValue = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__KeyValueType(struct soap *soap, const struct ds__KeyValueType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTods__DSAKeyValueType(soap, &a->DSAKeyValue);
	soap_serialize_PointerTods__RSAKeyValueType(soap, &a->RSAKeyValue);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__KeyValueType(struct soap *soap, const char *tag, int id, const struct ds__KeyValueType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__KeyValueType), type))
		return soap->error;
	if (soap_out_PointerTods__DSAKeyValueType(soap, "ds:DSAKeyValue", -1, &a->DSAKeyValue, ""))
		return soap->error;
	if (soap_out_PointerTods__RSAKeyValueType(soap, "ds:RSAKeyValue", -1, &a->RSAKeyValue, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__KeyValueType * SOAP_FMAC4 soap_in_ds__KeyValueType(struct soap *soap, const char *tag, struct ds__KeyValueType *a, const char *type)
{
	size_t soap_flag_DSAKeyValue = 1;
	size_t soap_flag_RSAKeyValue = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__KeyValueType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__KeyValueType, sizeof(struct ds__KeyValueType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__KeyValueType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_DSAKeyValue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__DSAKeyValueType(soap, "ds:DSAKeyValue", &a->DSAKeyValue, "ds:DSAKeyValueType"))
				{	soap_flag_DSAKeyValue--;
					continue;
				}
			if (soap_flag_RSAKeyValue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__RSAKeyValueType(soap, "ds:RSAKeyValue", &a->RSAKeyValue, "ds:RSAKeyValueType"))
				{	soap_flag_RSAKeyValue--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__KeyValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__KeyValueType, 0, sizeof(struct ds__KeyValueType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__KeyValueType(struct soap *soap, const struct ds__KeyValueType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__KeyValueType);
	if (soap_out_ds__KeyValueType(soap, tag?tag:"ds:KeyValueType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__KeyValueType * SOAP_FMAC4 soap_get_ds__KeyValueType(struct soap *soap, struct ds__KeyValueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__KeyValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__KeyValueType * SOAP_FMAC2 soap_instantiate_ds__KeyValueType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__KeyValueType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__KeyValueType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__KeyValueType);
		if (size)
			*size = sizeof(struct ds__KeyValueType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__KeyValueType, n);
		if (size)
			*size = n * sizeof(struct ds__KeyValueType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__KeyValueType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__KeyValueType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__KeyValueType %p -> %p\n", q, p));
	*(struct ds__KeyValueType*)p = *(struct ds__KeyValueType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__DigestMethodType(struct soap *soap, struct ds__DigestMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Algorithm);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__DigestMethodType(struct soap *soap, const struct ds__DigestMethodType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__DigestMethodType(struct soap *soap, const char *tag, int id, const struct ds__DigestMethodType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__DigestMethodType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__DigestMethodType * SOAP_FMAC4 soap_in_ds__DigestMethodType(struct soap *soap, const char *tag, struct ds__DigestMethodType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__DigestMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__DigestMethodType, sizeof(struct ds__DigestMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__DigestMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 1), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__DigestMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__DigestMethodType, 0, sizeof(struct ds__DigestMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__DigestMethodType(struct soap *soap, const struct ds__DigestMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__DigestMethodType);
	if (soap_out_ds__DigestMethodType(soap, tag?tag:"ds:DigestMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__DigestMethodType * SOAP_FMAC4 soap_get_ds__DigestMethodType(struct soap *soap, struct ds__DigestMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__DigestMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__DigestMethodType * SOAP_FMAC2 soap_instantiate_ds__DigestMethodType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__DigestMethodType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__DigestMethodType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__DigestMethodType);
		if (size)
			*size = sizeof(struct ds__DigestMethodType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__DigestMethodType, n);
		if (size)
			*size = n * sizeof(struct ds__DigestMethodType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__DigestMethodType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__DigestMethodType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__DigestMethodType %p -> %p\n", q, p));
	*(struct ds__DigestMethodType*)p = *(struct ds__DigestMethodType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__TransformType(struct soap *soap, struct ds__TransformType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->c14n__InclusiveNamespaces = NULL;
	a->__any = NULL;
	soap_default_string(soap, &a->Algorithm);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__TransformType(struct soap *soap, const struct ds__TransformType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_c14n__InclusiveNamespaces(soap, &a->c14n__InclusiveNamespaces);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__TransformType(struct soap *soap, const char *tag, int id, const struct ds__TransformType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__TransformType), type))
		return soap->error;
	if (soap_out_PointerTo_c14n__InclusiveNamespaces(soap, "c14n:InclusiveNamespaces", -1, &a->c14n__InclusiveNamespaces, ""))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__TransformType * SOAP_FMAC4 soap_in_ds__TransformType(struct soap *soap, const char *tag, struct ds__TransformType *a, const char *type)
{
	size_t soap_flag_c14n__InclusiveNamespaces = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__TransformType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__TransformType, sizeof(struct ds__TransformType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__TransformType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 0), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_c14n__InclusiveNamespaces && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_c14n__InclusiveNamespaces(soap, "c14n:InclusiveNamespaces", &a->c14n__InclusiveNamespaces, ""))
				{	soap_flag_c14n__InclusiveNamespaces--;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__TransformType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__TransformType, 0, sizeof(struct ds__TransformType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__TransformType(struct soap *soap, const struct ds__TransformType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__TransformType);
	if (soap_out_ds__TransformType(soap, tag?tag:"ds:TransformType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__TransformType * SOAP_FMAC4 soap_get_ds__TransformType(struct soap *soap, struct ds__TransformType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__TransformType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__TransformType * SOAP_FMAC2 soap_instantiate_ds__TransformType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__TransformType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__TransformType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__TransformType);
		if (size)
			*size = sizeof(struct ds__TransformType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__TransformType, n);
		if (size)
			*size = n * sizeof(struct ds__TransformType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__TransformType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__TransformType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__TransformType %p -> %p\n", q, p));
	*(struct ds__TransformType*)p = *(struct ds__TransformType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__c14n__InclusiveNamespaces(struct soap *soap, struct _c14n__InclusiveNamespaces *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->PrefixList);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__c14n__InclusiveNamespaces(struct soap *soap, const struct _c14n__InclusiveNamespaces *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__c14n__InclusiveNamespaces(struct soap *soap, const char *tag, int id, const struct _c14n__InclusiveNamespaces *a, const char *type)
{
	if (a->PrefixList)
		soap_set_attr(soap, "PrefixList", a->PrefixList, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__c14n__InclusiveNamespaces), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _c14n__InclusiveNamespaces * SOAP_FMAC4 soap_in__c14n__InclusiveNamespaces(struct soap *soap, const char *tag, struct _c14n__InclusiveNamespaces *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _c14n__InclusiveNamespaces *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__c14n__InclusiveNamespaces, sizeof(struct _c14n__InclusiveNamespaces), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__c14n__InclusiveNamespaces(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "PrefixList", 0), &a->PrefixList, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _c14n__InclusiveNamespaces *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__c14n__InclusiveNamespaces, 0, sizeof(struct _c14n__InclusiveNamespaces), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__c14n__InclusiveNamespaces(struct soap *soap, const struct _c14n__InclusiveNamespaces *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__c14n__InclusiveNamespaces);
	if (soap_out__c14n__InclusiveNamespaces(soap, tag?tag:"c14n:InclusiveNamespaces", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _c14n__InclusiveNamespaces * SOAP_FMAC4 soap_get__c14n__InclusiveNamespaces(struct soap *soap, struct _c14n__InclusiveNamespaces *p, const char *tag, const char *type)
{
	if ((p = soap_in__c14n__InclusiveNamespaces(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _c14n__InclusiveNamespaces * SOAP_FMAC2 soap_instantiate__c14n__InclusiveNamespaces(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__c14n__InclusiveNamespaces(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__c14n__InclusiveNamespaces, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _c14n__InclusiveNamespaces);
		if (size)
			*size = sizeof(struct _c14n__InclusiveNamespaces);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _c14n__InclusiveNamespaces, n);
		if (size)
			*size = n * sizeof(struct _c14n__InclusiveNamespaces);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _c14n__InclusiveNamespaces*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__c14n__InclusiveNamespaces(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _c14n__InclusiveNamespaces %p -> %p\n", q, p));
	*(struct _c14n__InclusiveNamespaces*)p = *(struct _c14n__InclusiveNamespaces*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__TransformsType(struct soap *soap, struct ds__TransformsType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeTransform = 0;
	a->Transform = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__TransformsType(struct soap *soap, const struct ds__TransformsType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Transform)
	{	int i;
		for (i = 0; i < a->__sizeTransform; i++)
		{
			soap_embedded(soap, a->Transform + i, SOAP_TYPE_ds__TransformType);
			soap_serialize_ds__TransformType(soap, a->Transform + i);
		}
	}
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__TransformsType(struct soap *soap, const char *tag, int id, const struct ds__TransformsType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__TransformsType), type))
		return soap->error;
	if (a->Transform)
	{	int i;
		for (i = 0; i < a->__sizeTransform; i++)
			if (soap_out_ds__TransformType(soap, "ds:Transform", -1, a->Transform + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__TransformsType * SOAP_FMAC4 soap_in_ds__TransformsType(struct soap *soap, const char *tag, struct ds__TransformsType *a, const char *type)
{
	struct soap_blist *soap_blist_Transform = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__TransformsType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__TransformsType, sizeof(struct ds__TransformsType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__TransformsType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ds:Transform", 1, NULL))
			{	if (a->Transform == NULL)
				{	if (soap_blist_Transform == NULL)
						soap_blist_Transform = soap_new_block(soap);
					a->Transform = (struct ds__TransformType *)soap_push_block(soap, soap_blist_Transform, sizeof(struct ds__TransformType));
					if (a->Transform == NULL)
						return NULL;
					SOAP_PLACEMENT_NEW(a->Transform, struct ds__TransformType);
					soap_default_ds__TransformType(soap, a->Transform);
				}
				soap_revert(soap);
				if (soap_in_ds__TransformType(soap, "ds:Transform", a->Transform, "ds:TransformType"))
				{	a->__sizeTransform++;
					a->Transform = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Transform)
			soap_pop_block(soap, soap_blist_Transform);
		if (a->__sizeTransform)
			a->Transform = (struct ds__TransformType *)soap_save_block(soap, soap_blist_Transform, NULL, 1);
		else
		{	a->Transform = NULL;
			if (soap_blist_Transform)
				soap_end_block(soap, soap_blist_Transform);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__TransformsType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__TransformsType, 0, sizeof(struct ds__TransformsType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__TransformsType(struct soap *soap, const struct ds__TransformsType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__TransformsType);
	if (soap_out_ds__TransformsType(soap, tag?tag:"ds:TransformsType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__TransformsType * SOAP_FMAC4 soap_get_ds__TransformsType(struct soap *soap, struct ds__TransformsType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__TransformsType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__TransformsType * SOAP_FMAC2 soap_instantiate_ds__TransformsType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__TransformsType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__TransformsType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__TransformsType);
		if (size)
			*size = sizeof(struct ds__TransformsType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__TransformsType, n);
		if (size)
			*size = n * sizeof(struct ds__TransformsType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__TransformsType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__TransformsType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__TransformsType %p -> %p\n", q, p));
	*(struct ds__TransformsType*)p = *(struct ds__TransformsType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__ReferenceType(struct soap *soap, struct ds__ReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Transforms = NULL;
	a->DigestMethod = NULL;
	soap_default_string(soap, &a->DigestValue);
	soap_default_string(soap, &a->Id);
	soap_default_string(soap, &a->URI);
	soap_default_string(soap, &a->Type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__ReferenceType(struct soap *soap, const struct ds__ReferenceType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTods__TransformsType(soap, &a->Transforms);
	soap_serialize_PointerTods__DigestMethodType(soap, &a->DigestMethod);
	soap_serialize_string(soap, &a->DigestValue);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__ReferenceType(struct soap *soap, const char *tag, int id, const struct ds__ReferenceType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	if (a->URI)
		soap_set_attr(soap, "URI", a->URI, 1);
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__ReferenceType), type))
		return soap->error;
	if (soap_out_PointerTods__TransformsType(soap, "ds:Transforms", -1, &a->Transforms, ""))
		return soap->error;
	if (a->DigestMethod)
	{	if (soap_out_PointerTods__DigestMethodType(soap, "ds:DigestMethod", -1, &a->DigestMethod, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:DigestMethod"))
		return soap->error;
	if (a->DigestValue)
	{	if (soap_out_string(soap, "ds:DigestValue", -1, &a->DigestValue, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:DigestValue"))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__ReferenceType * SOAP_FMAC4 soap_in_ds__ReferenceType(struct soap *soap, const char *tag, struct ds__ReferenceType *a, const char *type)
{
	size_t soap_flag_Transforms = 1;
	size_t soap_flag_DigestMethod = 1;
	size_t soap_flag_DigestValue = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__ReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__ReferenceType, sizeof(struct ds__ReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__ReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "URI", 0), &a->URI, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Transforms && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__TransformsType(soap, "ds:Transforms", &a->Transforms, "ds:TransformsType"))
				{	soap_flag_Transforms--;
					continue;
				}
			if (soap_flag_DigestMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__DigestMethodType(soap, "ds:DigestMethod", &a->DigestMethod, "ds:DigestMethodType"))
				{	soap_flag_DigestMethod--;
					continue;
				}
			if (soap_flag_DigestValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:DigestValue", &a->DigestValue, "xsd:string"))
				{	soap_flag_DigestValue--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__ReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__ReferenceType, 0, sizeof(struct ds__ReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_DigestMethod > 0 || soap_flag_DigestValue > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__ReferenceType(struct soap *soap, const struct ds__ReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__ReferenceType);
	if (soap_out_ds__ReferenceType(soap, tag?tag:"ds:ReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__ReferenceType * SOAP_FMAC4 soap_get_ds__ReferenceType(struct soap *soap, struct ds__ReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__ReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__ReferenceType * SOAP_FMAC2 soap_instantiate_ds__ReferenceType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__ReferenceType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__ReferenceType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__ReferenceType);
		if (size)
			*size = sizeof(struct ds__ReferenceType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__ReferenceType, n);
		if (size)
			*size = n * sizeof(struct ds__ReferenceType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__ReferenceType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__ReferenceType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__ReferenceType %p -> %p\n", q, p));
	*(struct ds__ReferenceType*)p = *(struct ds__ReferenceType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__SignatureMethodType(struct soap *soap, struct ds__SignatureMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->HMACOutputLength = NULL;
	soap_default_string(soap, &a->Algorithm);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__SignatureMethodType(struct soap *soap, const struct ds__SignatureMethodType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->HMACOutputLength);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__SignatureMethodType(struct soap *soap, const char *tag, int id, const struct ds__SignatureMethodType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__SignatureMethodType), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "ds:HMACOutputLength", -1, &a->HMACOutputLength, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__SignatureMethodType * SOAP_FMAC4 soap_in_ds__SignatureMethodType(struct soap *soap, const char *tag, struct ds__SignatureMethodType *a, const char *type)
{
	size_t soap_flag_HMACOutputLength = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__SignatureMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__SignatureMethodType, sizeof(struct ds__SignatureMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__SignatureMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 1), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_HMACOutputLength && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "ds:HMACOutputLength", &a->HMACOutputLength, "xsd:int"))
				{	soap_flag_HMACOutputLength--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__SignatureMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__SignatureMethodType, 0, sizeof(struct ds__SignatureMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__SignatureMethodType(struct soap *soap, const struct ds__SignatureMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__SignatureMethodType);
	if (soap_out_ds__SignatureMethodType(soap, tag?tag:"ds:SignatureMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__SignatureMethodType * SOAP_FMAC4 soap_get_ds__SignatureMethodType(struct soap *soap, struct ds__SignatureMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__SignatureMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__SignatureMethodType * SOAP_FMAC2 soap_instantiate_ds__SignatureMethodType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__SignatureMethodType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__SignatureMethodType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__SignatureMethodType);
		if (size)
			*size = sizeof(struct ds__SignatureMethodType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__SignatureMethodType, n);
		if (size)
			*size = n * sizeof(struct ds__SignatureMethodType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__SignatureMethodType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__SignatureMethodType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__SignatureMethodType %p -> %p\n", q, p));
	*(struct ds__SignatureMethodType*)p = *(struct ds__SignatureMethodType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__CanonicalizationMethodType(struct soap *soap, struct ds__CanonicalizationMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Algorithm);
	a->c14n__InclusiveNamespaces = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__CanonicalizationMethodType(struct soap *soap, const struct ds__CanonicalizationMethodType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_c14n__InclusiveNamespaces(soap, &a->c14n__InclusiveNamespaces);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__CanonicalizationMethodType(struct soap *soap, const char *tag, int id, const struct ds__CanonicalizationMethodType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__CanonicalizationMethodType), type))
		return soap->error;
	if (soap_out_PointerTo_c14n__InclusiveNamespaces(soap, "c14n:InclusiveNamespaces", -1, &a->c14n__InclusiveNamespaces, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__CanonicalizationMethodType * SOAP_FMAC4 soap_in_ds__CanonicalizationMethodType(struct soap *soap, const char *tag, struct ds__CanonicalizationMethodType *a, const char *type)
{
	size_t soap_flag_c14n__InclusiveNamespaces = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__CanonicalizationMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__CanonicalizationMethodType, sizeof(struct ds__CanonicalizationMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__CanonicalizationMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 1), &a->Algorithm, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_c14n__InclusiveNamespaces && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_c14n__InclusiveNamespaces(soap, "c14n:InclusiveNamespaces", &a->c14n__InclusiveNamespaces, ""))
				{	soap_flag_c14n__InclusiveNamespaces--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__CanonicalizationMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__CanonicalizationMethodType, 0, sizeof(struct ds__CanonicalizationMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__CanonicalizationMethodType(struct soap *soap, const struct ds__CanonicalizationMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__CanonicalizationMethodType);
	if (soap_out_ds__CanonicalizationMethodType(soap, tag?tag:"ds:CanonicalizationMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__CanonicalizationMethodType * SOAP_FMAC4 soap_get_ds__CanonicalizationMethodType(struct soap *soap, struct ds__CanonicalizationMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__CanonicalizationMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__CanonicalizationMethodType * SOAP_FMAC2 soap_instantiate_ds__CanonicalizationMethodType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__CanonicalizationMethodType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__CanonicalizationMethodType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__CanonicalizationMethodType);
		if (size)
			*size = sizeof(struct ds__CanonicalizationMethodType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__CanonicalizationMethodType, n);
		if (size)
			*size = n * sizeof(struct ds__CanonicalizationMethodType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__CanonicalizationMethodType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__CanonicalizationMethodType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__CanonicalizationMethodType %p -> %p\n", q, p));
	*(struct ds__CanonicalizationMethodType*)p = *(struct ds__CanonicalizationMethodType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__KeyInfoType(struct soap *soap, struct ds__KeyInfoType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->KeyName);
	a->KeyValue = NULL;
	a->RetrievalMethod = NULL;
	a->X509Data = NULL;
	a->wsse__SecurityTokenReference = NULL;
	soap_default_string(soap, &a->Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__KeyInfoType(struct soap *soap, const struct ds__KeyInfoType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->KeyName);
	soap_serialize_PointerTods__KeyValueType(soap, &a->KeyValue);
	soap_serialize_PointerTods__RetrievalMethodType(soap, &a->RetrievalMethod);
	soap_serialize_PointerTods__X509DataType(soap, &a->X509Data);
	soap_serialize_PointerTo_wsse__SecurityTokenReference(soap, &a->wsse__SecurityTokenReference);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__KeyInfoType(struct soap *soap, const char *tag, int id, const struct ds__KeyInfoType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__KeyInfoType), type))
		return soap->error;
	if (soap_out_string(soap, "ds:KeyName", -1, &a->KeyName, ""))
		return soap->error;
	if (soap_out_PointerTods__KeyValueType(soap, "ds:KeyValue", -1, &a->KeyValue, ""))
		return soap->error;
	if (soap_out_PointerTods__RetrievalMethodType(soap, "ds:RetrievalMethod", -1, &a->RetrievalMethod, ""))
		return soap->error;
	if (soap_out_PointerTods__X509DataType(soap, "ds:X509Data", -1, &a->X509Data, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__SecurityTokenReference(soap, "wsse:SecurityTokenReference", -1, &a->wsse__SecurityTokenReference, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__KeyInfoType * SOAP_FMAC4 soap_in_ds__KeyInfoType(struct soap *soap, const char *tag, struct ds__KeyInfoType *a, const char *type)
{
	size_t soap_flag_KeyName = 1;
	size_t soap_flag_KeyValue = 1;
	size_t soap_flag_RetrievalMethod = 1;
	size_t soap_flag_X509Data = 1;
	size_t soap_flag_wsse__SecurityTokenReference = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__KeyInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__KeyInfoType, sizeof(struct ds__KeyInfoType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__KeyInfoType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_KeyName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:KeyName", &a->KeyName, "xsd:string"))
				{	soap_flag_KeyName--;
					continue;
				}
			if (soap_flag_KeyValue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__KeyValueType(soap, "ds:KeyValue", &a->KeyValue, "ds:KeyValueType"))
				{	soap_flag_KeyValue--;
					continue;
				}
			if (soap_flag_RetrievalMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__RetrievalMethodType(soap, "ds:RetrievalMethod", &a->RetrievalMethod, "ds:RetrievalMethodType"))
				{	soap_flag_RetrievalMethod--;
					continue;
				}
			if (soap_flag_X509Data && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__X509DataType(soap, "ds:X509Data", &a->X509Data, "ds:X509DataType"))
				{	soap_flag_X509Data--;
					continue;
				}
			if (soap_flag_wsse__SecurityTokenReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__SecurityTokenReference(soap, "wsse:SecurityTokenReference", &a->wsse__SecurityTokenReference, ""))
				{	soap_flag_wsse__SecurityTokenReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__KeyInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__KeyInfoType, 0, sizeof(struct ds__KeyInfoType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__KeyInfoType(struct soap *soap, const struct ds__KeyInfoType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__KeyInfoType);
	if (soap_out_ds__KeyInfoType(soap, tag?tag:"ds:KeyInfoType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__KeyInfoType * SOAP_FMAC4 soap_get_ds__KeyInfoType(struct soap *soap, struct ds__KeyInfoType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__KeyInfoType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__KeyInfoType * SOAP_FMAC2 soap_instantiate_ds__KeyInfoType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__KeyInfoType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__KeyInfoType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__KeyInfoType);
		if (size)
			*size = sizeof(struct ds__KeyInfoType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__KeyInfoType, n);
		if (size)
			*size = n * sizeof(struct ds__KeyInfoType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__KeyInfoType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__KeyInfoType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__KeyInfoType %p -> %p\n", q, p));
	*(struct ds__KeyInfoType*)p = *(struct ds__KeyInfoType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__SignedInfoType(struct soap *soap, struct ds__SignedInfoType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->CanonicalizationMethod = NULL;
	a->SignatureMethod = NULL;
	a->__sizeReference = 0;
	a->Reference = NULL;
	soap_default_string(soap, &a->Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__SignedInfoType(struct soap *soap, const struct ds__SignedInfoType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTods__CanonicalizationMethodType(soap, &a->CanonicalizationMethod);
	soap_serialize_PointerTods__SignatureMethodType(soap, &a->SignatureMethod);
	if (a->Reference)
	{	int i;
		for (i = 0; i < a->__sizeReference; i++)
		{
			soap_serialize_PointerTods__ReferenceType(soap, a->Reference + i);
		}
	}
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__SignedInfoType(struct soap *soap, const char *tag, int id, const struct ds__SignedInfoType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__SignedInfoType), type))
		return soap->error;
	if (a->CanonicalizationMethod)
	{	if (soap_out_PointerTods__CanonicalizationMethodType(soap, "ds:CanonicalizationMethod", -1, &a->CanonicalizationMethod, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:CanonicalizationMethod"))
		return soap->error;
	if (a->SignatureMethod)
	{	if (soap_out_PointerTods__SignatureMethodType(soap, "ds:SignatureMethod", -1, &a->SignatureMethod, ""))
			return soap->error;
	}
	else if (soap_element_nil(soap, "ds:SignatureMethod"))
		return soap->error;
	if (a->Reference)
	{	int i;
		for (i = 0; i < a->__sizeReference; i++)
			if (soap_out_PointerTods__ReferenceType(soap, "ds:Reference", -1, a->Reference + i, ""))
				return soap->error;
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__SignedInfoType * SOAP_FMAC4 soap_in_ds__SignedInfoType(struct soap *soap, const char *tag, struct ds__SignedInfoType *a, const char *type)
{
	size_t soap_flag_CanonicalizationMethod = 1;
	size_t soap_flag_SignatureMethod = 1;
	struct soap_blist *soap_blist_Reference = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__SignedInfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__SignedInfoType, sizeof(struct ds__SignedInfoType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__SignedInfoType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CanonicalizationMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__CanonicalizationMethodType(soap, "ds:CanonicalizationMethod", &a->CanonicalizationMethod, "ds:CanonicalizationMethodType"))
				{	soap_flag_CanonicalizationMethod--;
					continue;
				}
			if (soap_flag_SignatureMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__SignatureMethodType(soap, "ds:SignatureMethod", &a->SignatureMethod, "ds:SignatureMethodType"))
				{	soap_flag_SignatureMethod--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "ds:Reference", 1, NULL))
			{	if (a->Reference == NULL)
				{	if (soap_blist_Reference == NULL)
						soap_blist_Reference = soap_new_block(soap);
					a->Reference = (struct ds__ReferenceType **)soap_push_block(soap, soap_blist_Reference, sizeof(struct ds__ReferenceType *));
					if (a->Reference == NULL)
						return NULL;
					*a->Reference = NULL;
				}
				soap_revert(soap);
				if (soap_in_PointerTods__ReferenceType(soap, "ds:Reference", a->Reference, "ds:ReferenceType"))
				{	a->__sizeReference++;
					a->Reference = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->Reference)
			soap_pop_block(soap, soap_blist_Reference);
		if (a->__sizeReference)
			a->Reference = (struct ds__ReferenceType **)soap_save_block(soap, soap_blist_Reference, NULL, 1);
		else
		{	a->Reference = NULL;
			if (soap_blist_Reference)
				soap_end_block(soap, soap_blist_Reference);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__SignedInfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__SignedInfoType, 0, sizeof(struct ds__SignedInfoType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CanonicalizationMethod > 0 || soap_flag_SignatureMethod > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__SignedInfoType(struct soap *soap, const struct ds__SignedInfoType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__SignedInfoType);
	if (soap_out_ds__SignedInfoType(soap, tag?tag:"ds:SignedInfoType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__SignedInfoType * SOAP_FMAC4 soap_get_ds__SignedInfoType(struct soap *soap, struct ds__SignedInfoType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__SignedInfoType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__SignedInfoType * SOAP_FMAC2 soap_instantiate_ds__SignedInfoType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__SignedInfoType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__SignedInfoType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__SignedInfoType);
		if (size)
			*size = sizeof(struct ds__SignedInfoType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__SignedInfoType, n);
		if (size)
			*size = n * sizeof(struct ds__SignedInfoType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__SignedInfoType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__SignedInfoType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__SignedInfoType %p -> %p\n", q, p));
	*(struct ds__SignedInfoType*)p = *(struct ds__SignedInfoType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__SignatureType(struct soap *soap, struct ds__SignatureType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->SignedInfo = NULL;
	soap_default_string(soap, &a->SignatureValue);
	a->KeyInfo = NULL;
	soap_default_string(soap, &a->Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__SignatureType(struct soap *soap, const struct ds__SignatureType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTods__SignedInfoType(soap, &a->SignedInfo);
	soap_serialize_string(soap, &a->SignatureValue);
	soap_serialize_PointerTods__KeyInfoType(soap, &a->KeyInfo);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__SignatureType(struct soap *soap, const char *tag, int id, const struct ds__SignatureType *a, const char *type)
{
	if (a->Id)
		soap_set_attr(soap, "Id", a->Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__SignatureType), type))
		return soap->error;
	if (soap_out_PointerTods__SignedInfoType(soap, "ds:SignedInfo", -1, &a->SignedInfo, ""))
		return soap->error;
	if (soap_out_string(soap, "ds:SignatureValue", -1, &a->SignatureValue, ""))
		return soap->error;
	if (soap_out_PointerTods__KeyInfoType(soap, "ds:KeyInfo", -1, &a->KeyInfo, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__SignatureType * SOAP_FMAC4 soap_in_ds__SignatureType(struct soap *soap, const char *tag, struct ds__SignatureType *a, const char *type)
{
	size_t soap_flag_SignedInfo = 1;
	size_t soap_flag_SignatureValue = 1;
	size_t soap_flag_KeyInfo = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__SignatureType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__SignatureType, sizeof(struct ds__SignatureType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__SignatureType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Id", 0), &a->Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SignedInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__SignedInfoType(soap, "ds:SignedInfo", &a->SignedInfo, "ds:SignedInfoType"))
				{	soap_flag_SignedInfo--;
					continue;
				}
			if (soap_flag_SignatureValue && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:SignatureValue", &a->SignatureValue, "xsd:string"))
				{	soap_flag_SignatureValue--;
					continue;
				}
			if (soap_flag_KeyInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__KeyInfoType(soap, "ds:KeyInfo", &a->KeyInfo, "ds:KeyInfoType"))
				{	soap_flag_KeyInfo--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__SignatureType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__SignatureType, 0, sizeof(struct ds__SignatureType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__SignatureType(struct soap *soap, const struct ds__SignatureType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__SignatureType);
	if (soap_out_ds__SignatureType(soap, tag?tag:"ds:SignatureType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__SignatureType * SOAP_FMAC4 soap_get_ds__SignatureType(struct soap *soap, struct ds__SignatureType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__SignatureType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__SignatureType * SOAP_FMAC2 soap_instantiate_ds__SignatureType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__SignatureType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__SignatureType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__SignatureType);
		if (size)
			*size = sizeof(struct ds__SignatureType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__SignatureType, n);
		if (size)
			*size = n * sizeof(struct ds__SignatureType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__SignatureType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__SignatureType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__SignatureType %p -> %p\n", q, p));
	*(struct ds__SignatureType*)p = *(struct ds__SignatureType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ds__X509DataType(struct soap *soap, struct ds__X509DataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->X509IssuerSerial = NULL;
	soap_default_string(soap, &a->X509SKI);
	soap_default_string(soap, &a->X509SubjectName);
	soap_default_string(soap, &a->X509Certificate);
	soap_default_string(soap, &a->X509CRL);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ds__X509DataType(struct soap *soap, const struct ds__X509DataType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTods__X509IssuerSerialType(soap, &a->X509IssuerSerial);
	soap_serialize_string(soap, &a->X509SKI);
	soap_serialize_string(soap, &a->X509SubjectName);
	soap_serialize_string(soap, &a->X509Certificate);
	soap_serialize_string(soap, &a->X509CRL);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ds__X509DataType(struct soap *soap, const char *tag, int id, const struct ds__X509DataType *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ds__X509DataType), type))
		return soap->error;
	if (soap_out_PointerTods__X509IssuerSerialType(soap, "ds:X509IssuerSerial", -1, &a->X509IssuerSerial, ""))
		return soap->error;
	if (soap_out_string(soap, "ds:X509SKI", -1, &a->X509SKI, ""))
		return soap->error;
	if (soap_out_string(soap, "ds:X509SubjectName", -1, &a->X509SubjectName, ""))
		return soap->error;
	if (soap_out_string(soap, "ds:X509Certificate", -1, &a->X509Certificate, ""))
		return soap->error;
	if (soap_out_string(soap, "ds:X509CRL", -1, &a->X509CRL, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ds__X509DataType * SOAP_FMAC4 soap_in_ds__X509DataType(struct soap *soap, const char *tag, struct ds__X509DataType *a, const char *type)
{
	size_t soap_flag_X509IssuerSerial = 1;
	size_t soap_flag_X509SKI = 1;
	size_t soap_flag_X509SubjectName = 1;
	size_t soap_flag_X509Certificate = 1;
	size_t soap_flag_X509CRL = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ds__X509DataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ds__X509DataType, sizeof(struct ds__X509DataType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ds__X509DataType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_X509IssuerSerial && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__X509IssuerSerialType(soap, "ds:X509IssuerSerial", &a->X509IssuerSerial, "ds:X509IssuerSerialType"))
				{	soap_flag_X509IssuerSerial--;
					continue;
				}
			if (soap_flag_X509SKI && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:X509SKI", &a->X509SKI, "xsd:string"))
				{	soap_flag_X509SKI--;
					continue;
				}
			if (soap_flag_X509SubjectName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:X509SubjectName", &a->X509SubjectName, "xsd:string"))
				{	soap_flag_X509SubjectName--;
					continue;
				}
			if (soap_flag_X509Certificate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:X509Certificate", &a->X509Certificate, "xsd:string"))
				{	soap_flag_X509Certificate--;
					continue;
				}
			if (soap_flag_X509CRL && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ds:X509CRL", &a->X509CRL, "xsd:string"))
				{	soap_flag_X509CRL--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ds__X509DataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ds__X509DataType, 0, sizeof(struct ds__X509DataType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ds__X509DataType(struct soap *soap, const struct ds__X509DataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ds__X509DataType);
	if (soap_out_ds__X509DataType(soap, tag?tag:"ds:X509DataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__X509DataType * SOAP_FMAC4 soap_get_ds__X509DataType(struct soap *soap, struct ds__X509DataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ds__X509DataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ds__X509DataType * SOAP_FMAC2 soap_instantiate_ds__X509DataType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ds__X509DataType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ds__X509DataType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct ds__X509DataType);
		if (size)
			*size = sizeof(struct ds__X509DataType);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct ds__X509DataType, n);
		if (size)
			*size = n * sizeof(struct ds__X509DataType);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct ds__X509DataType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ds__X509DataType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ds__X509DataType %p -> %p\n", q, p));
	*(struct ds__X509DataType*)p = *(struct ds__X509DataType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__SecurityTokenReference(struct soap *soap, struct _wsse__SecurityTokenReference *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Reference = NULL;
	a->KeyIdentifier = NULL;
	a->Embedded = NULL;
	a->ds__X509Data = NULL;
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->wsc__Instance);
	soap_default_string(soap, &a->Usage);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__SecurityTokenReference(struct soap *soap, const struct _wsse__SecurityTokenReference *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsse__Reference(soap, &a->Reference);
	soap_serialize_PointerTo_wsse__KeyIdentifier(soap, &a->KeyIdentifier);
	soap_serialize_PointerTo_wsse__Embedded(soap, &a->Embedded);
	soap_serialize_PointerTods__X509DataType(soap, &a->ds__X509Data);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__SecurityTokenReference(struct soap *soap, const char *tag, int id, const struct _wsse__SecurityTokenReference *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	if (a->wsc__Instance)
		soap_set_attr(soap, "wsc:Instance", a->wsc__Instance, 1);
	if (a->Usage)
		soap_set_attr(soap, "Usage", a->Usage, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__SecurityTokenReference), type))
		return soap->error;
	if (soap_out_PointerTo_wsse__Reference(soap, "wsse:Reference", -1, &a->Reference, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__KeyIdentifier(soap, "wsse:KeyIdentifier", -1, &a->KeyIdentifier, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__Embedded(soap, "wsse:Embedded", -1, &a->Embedded, ""))
		return soap->error;
	if (soap_out_PointerTods__X509DataType(soap, "ds:X509Data", -1, &a->ds__X509Data, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__SecurityTokenReference * SOAP_FMAC4 soap_in__wsse__SecurityTokenReference(struct soap *soap, const char *tag, struct _wsse__SecurityTokenReference *a, const char *type)
{
	size_t soap_flag_Reference = 1;
	size_t soap_flag_KeyIdentifier = 1;
	size_t soap_flag_Embedded = 1;
	size_t soap_flag_ds__X509Data = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__SecurityTokenReference *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__SecurityTokenReference, sizeof(struct _wsse__SecurityTokenReference), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__SecurityTokenReference(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "wsc:Instance", 0), &a->wsc__Instance, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Usage", 0), &a->Usage, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Reference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Reference(soap, "wsse:Reference", &a->Reference, ""))
				{	soap_flag_Reference--;
					continue;
				}
			if (soap_flag_KeyIdentifier && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__KeyIdentifier(soap, "wsse:KeyIdentifier", &a->KeyIdentifier, ""))
				{	soap_flag_KeyIdentifier--;
					continue;
				}
			if (soap_flag_Embedded && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Embedded(soap, "wsse:Embedded", &a->Embedded, ""))
				{	soap_flag_Embedded--;
					continue;
				}
			if (soap_flag_ds__X509Data && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTods__X509DataType(soap, "ds:X509Data", &a->ds__X509Data, "ds:X509DataType"))
				{	soap_flag_ds__X509Data--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__SecurityTokenReference *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__SecurityTokenReference, 0, sizeof(struct _wsse__SecurityTokenReference), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__SecurityTokenReference(struct soap *soap, const struct _wsse__SecurityTokenReference *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__SecurityTokenReference);
	if (soap_out__wsse__SecurityTokenReference(soap, tag?tag:"wsse:SecurityTokenReference", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__SecurityTokenReference * SOAP_FMAC4 soap_get__wsse__SecurityTokenReference(struct soap *soap, struct _wsse__SecurityTokenReference *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__SecurityTokenReference(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__SecurityTokenReference * SOAP_FMAC2 soap_instantiate__wsse__SecurityTokenReference(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__SecurityTokenReference(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__SecurityTokenReference, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__SecurityTokenReference);
		if (size)
			*size = sizeof(struct _wsse__SecurityTokenReference);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__SecurityTokenReference, n);
		if (size)
			*size = n * sizeof(struct _wsse__SecurityTokenReference);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__SecurityTokenReference*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__SecurityTokenReference(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__SecurityTokenReference %p -> %p\n", q, p));
	*(struct _wsse__SecurityTokenReference*)p = *(struct _wsse__SecurityTokenReference*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__KeyIdentifier(struct soap *soap, struct _wsse__KeyIdentifier *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->ValueType);
	soap_default_string(soap, &a->EncodingType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__KeyIdentifier(struct soap *soap, const struct _wsse__KeyIdentifier *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__KeyIdentifier(struct soap *soap, const char *tag, int id, const struct _wsse__KeyIdentifier *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	if (a->ValueType)
		soap_set_attr(soap, "ValueType", a->ValueType, 1);
	if (a->EncodingType)
		soap_set_attr(soap, "EncodingType", a->EncodingType, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _wsse__KeyIdentifier * SOAP_FMAC4 soap_in__wsse__KeyIdentifier(struct soap *soap, const char *tag, struct _wsse__KeyIdentifier *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct _wsse__KeyIdentifier *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__KeyIdentifier, sizeof(struct _wsse__KeyIdentifier), soap->type, soap->arrayType)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default__wsse__KeyIdentifier(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "ValueType", 0), &a->ValueType, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "EncodingType", 0), &a->EncodingType, 0, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__KeyIdentifier(struct soap *soap, const struct _wsse__KeyIdentifier *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__KeyIdentifier);
	if (soap_out__wsse__KeyIdentifier(soap, tag?tag:"wsse:KeyIdentifier", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__KeyIdentifier * SOAP_FMAC4 soap_get__wsse__KeyIdentifier(struct soap *soap, struct _wsse__KeyIdentifier *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__KeyIdentifier(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__KeyIdentifier * SOAP_FMAC2 soap_instantiate__wsse__KeyIdentifier(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__KeyIdentifier(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__KeyIdentifier, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__KeyIdentifier);
		if (size)
			*size = sizeof(struct _wsse__KeyIdentifier);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__KeyIdentifier, n);
		if (size)
			*size = n * sizeof(struct _wsse__KeyIdentifier);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__KeyIdentifier*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__KeyIdentifier(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__KeyIdentifier %p -> %p\n", q, p));
	*(struct _wsse__KeyIdentifier*)p = *(struct _wsse__KeyIdentifier*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__Embedded(struct soap *soap, struct _wsse__Embedded *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->ValueType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__Embedded(struct soap *soap, const struct _wsse__Embedded *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__Embedded(struct soap *soap, const char *tag, int id, const struct _wsse__Embedded *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	if (a->ValueType)
		soap_set_attr(soap, "ValueType", a->ValueType, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__Embedded), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__Embedded * SOAP_FMAC4 soap_in__wsse__Embedded(struct soap *soap, const char *tag, struct _wsse__Embedded *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__Embedded *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__Embedded, sizeof(struct _wsse__Embedded), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__Embedded(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "ValueType", 0), &a->ValueType, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__Embedded *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__Embedded, 0, sizeof(struct _wsse__Embedded), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__Embedded(struct soap *soap, const struct _wsse__Embedded *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__Embedded);
	if (soap_out__wsse__Embedded(soap, tag?tag:"wsse:Embedded", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Embedded * SOAP_FMAC4 soap_get__wsse__Embedded(struct soap *soap, struct _wsse__Embedded *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__Embedded(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__Embedded * SOAP_FMAC2 soap_instantiate__wsse__Embedded(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__Embedded(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__Embedded, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__Embedded);
		if (size)
			*size = sizeof(struct _wsse__Embedded);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__Embedded, n);
		if (size)
			*size = n * sizeof(struct _wsse__Embedded);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__Embedded*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__Embedded(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__Embedded %p -> %p\n", q, p));
	*(struct _wsse__Embedded*)p = *(struct _wsse__Embedded*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__Reference(struct soap *soap, struct _wsse__Reference *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->URI);
	soap_default_string(soap, &a->ValueType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__Reference(struct soap *soap, const struct _wsse__Reference *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__Reference(struct soap *soap, const char *tag, int id, const struct _wsse__Reference *a, const char *type)
{
	if (a->URI)
		soap_set_attr(soap, "URI", a->URI, 1);
	if (a->ValueType)
		soap_set_attr(soap, "ValueType", a->ValueType, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__Reference), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__Reference * SOAP_FMAC4 soap_in__wsse__Reference(struct soap *soap, const char *tag, struct _wsse__Reference *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__Reference *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__Reference, sizeof(struct _wsse__Reference), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__Reference(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "URI", 0), &a->URI, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "ValueType", 0), &a->ValueType, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__Reference *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__Reference, 0, sizeof(struct _wsse__Reference), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__Reference(struct soap *soap, const struct _wsse__Reference *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__Reference);
	if (soap_out__wsse__Reference(soap, tag?tag:"wsse:Reference", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Reference * SOAP_FMAC4 soap_get__wsse__Reference(struct soap *soap, struct _wsse__Reference *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__Reference(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__Reference * SOAP_FMAC2 soap_instantiate__wsse__Reference(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__Reference(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__Reference, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__Reference);
		if (size)
			*size = sizeof(struct _wsse__Reference);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__Reference, n);
		if (size)
			*size = n * sizeof(struct _wsse__Reference);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__Reference*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__Reference(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__Reference %p -> %p\n", q, p));
	*(struct _wsse__Reference*)p = *(struct _wsse__Reference*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__BinarySecurityToken(struct soap *soap, struct _wsse__BinarySecurityToken *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->ValueType);
	soap_default_string(soap, &a->EncodingType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__BinarySecurityToken(struct soap *soap, const struct _wsse__BinarySecurityToken *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__BinarySecurityToken(struct soap *soap, const char *tag, int id, const struct _wsse__BinarySecurityToken *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	if (a->ValueType)
		soap_set_attr(soap, "ValueType", a->ValueType, 1);
	if (a->EncodingType)
		soap_set_attr(soap, "EncodingType", a->EncodingType, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _wsse__BinarySecurityToken * SOAP_FMAC4 soap_in__wsse__BinarySecurityToken(struct soap *soap, const char *tag, struct _wsse__BinarySecurityToken *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct _wsse__BinarySecurityToken *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__BinarySecurityToken, sizeof(struct _wsse__BinarySecurityToken), soap->type, soap->arrayType)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default__wsse__BinarySecurityToken(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "ValueType", 0), &a->ValueType, 0, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "EncodingType", 0), &a->EncodingType, 0, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__BinarySecurityToken(struct soap *soap, const struct _wsse__BinarySecurityToken *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__BinarySecurityToken);
	if (soap_out__wsse__BinarySecurityToken(soap, tag?tag:"wsse:BinarySecurityToken", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__BinarySecurityToken * SOAP_FMAC4 soap_get__wsse__BinarySecurityToken(struct soap *soap, struct _wsse__BinarySecurityToken *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__BinarySecurityToken(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__BinarySecurityToken * SOAP_FMAC2 soap_instantiate__wsse__BinarySecurityToken(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__BinarySecurityToken(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__BinarySecurityToken, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__BinarySecurityToken);
		if (size)
			*size = sizeof(struct _wsse__BinarySecurityToken);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__BinarySecurityToken, n);
		if (size)
			*size = n * sizeof(struct _wsse__BinarySecurityToken);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__BinarySecurityToken*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__BinarySecurityToken(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__BinarySecurityToken %p -> %p\n", q, p));
	*(struct _wsse__BinarySecurityToken*)p = *(struct _wsse__BinarySecurityToken*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__Password(struct soap *soap, struct _wsse__Password *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_string(soap, &a->Type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__Password(struct soap *soap, const struct _wsse__Password *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__Password(struct soap *soap, const char *tag, int id, const struct _wsse__Password *a, const char *type)
{
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _wsse__Password * SOAP_FMAC4 soap_in__wsse__Password(struct soap *soap, const char *tag, struct _wsse__Password *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct _wsse__Password *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__Password, sizeof(struct _wsse__Password), soap->type, soap->arrayType)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default__wsse__Password(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, 0, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__Password(struct soap *soap, const struct _wsse__Password *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__Password);
	if (soap_out__wsse__Password(soap, tag?tag:"wsse:Password", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Password * SOAP_FMAC4 soap_get__wsse__Password(struct soap *soap, struct _wsse__Password *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__Password(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__Password * SOAP_FMAC2 soap_instantiate__wsse__Password(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__Password(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__Password, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__Password);
		if (size)
			*size = sizeof(struct _wsse__Password);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__Password, n);
		if (size)
			*size = n * sizeof(struct _wsse__Password);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__Password*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__Password(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__Password %p -> %p\n", q, p));
	*(struct _wsse__Password*)p = *(struct _wsse__Password*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Username);
	a->Password = NULL;
	soap_default_string(soap, &a->Nonce);
	soap_default_string(soap, &a->wsu__Created);
	soap_default_string(soap, &a->wsu__Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__UsernameToken(struct soap *soap, const struct _wsse__UsernameToken *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Username);
	soap_serialize_PointerTo_wsse__Password(soap, &a->Password);
	soap_serialize_string(soap, &a->Nonce);
	soap_serialize_string(soap, &a->wsu__Created);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__UsernameToken(struct soap *soap, const char *tag, int id, const struct _wsse__UsernameToken *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__UsernameToken), type))
		return soap->error;
	if (soap_out_string(soap, "wsse:Username", -1, &a->Username, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__Password(soap, "wsse:Password", -1, &a->Password, ""))
		return soap->error;
	if (soap_out_string(soap, "wsse:Nonce", -1, &a->Nonce, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Created", -1, &a->wsu__Created, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__UsernameToken * SOAP_FMAC4 soap_in__wsse__UsernameToken(struct soap *soap, const char *tag, struct _wsse__UsernameToken *a, const char *type)
{
	size_t soap_flag_Username = 1;
	size_t soap_flag_Password = 1;
	size_t soap_flag_Nonce = 1;
	size_t soap_flag_wsu__Created = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__UsernameToken *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__UsernameToken, sizeof(struct _wsse__UsernameToken), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__UsernameToken(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsse:Username", &a->Username, "xsd:string"))
				{	soap_flag_Username--;
					continue;
				}
			if (soap_flag_Password && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Password(soap, "wsse:Password", &a->Password, ""))
				{	soap_flag_Password--;
					continue;
				}
			if (soap_flag_Nonce && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsse:Nonce", &a->Nonce, "xsd:string"))
				{	soap_flag_Nonce--;
					continue;
				}
			if (soap_flag_wsu__Created && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Created", &a->wsu__Created, "xsd:string"))
				{	soap_flag_wsu__Created--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__UsernameToken *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__UsernameToken, 0, sizeof(struct _wsse__UsernameToken), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__UsernameToken(struct soap *soap, const struct _wsse__UsernameToken *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__UsernameToken);
	if (soap_out__wsse__UsernameToken(soap, tag?tag:"wsse:UsernameToken", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__UsernameToken * SOAP_FMAC4 soap_get__wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__UsernameToken(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsse__UsernameToken * SOAP_FMAC2 soap_instantiate__wsse__UsernameToken(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsse__UsernameToken(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsse__UsernameToken, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsse__UsernameToken);
		if (size)
			*size = sizeof(struct _wsse__UsernameToken);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsse__UsernameToken, n);
		if (size)
			*size = n * sizeof(struct _wsse__UsernameToken);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsse__UsernameToken*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsse__UsernameToken(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsse__UsernameToken %p -> %p\n", q, p));
	*(struct _wsse__UsernameToken*)p = *(struct _wsse__UsernameToken*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->Created);
	soap_default_string(soap, &a->Expires);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsu__Timestamp(struct soap *soap, const struct _wsu__Timestamp *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Created);
	soap_serialize_string(soap, &a->Expires);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsu__Timestamp(struct soap *soap, const char *tag, int id, const struct _wsu__Timestamp *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id, 1);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsu__Timestamp), type))
		return soap->error;
	if (soap_out_string(soap, "wsu:Created", -1, &a->Created, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Expires", -1, &a->Expires, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsu__Timestamp * SOAP_FMAC4 soap_in__wsu__Timestamp(struct soap *soap, const char *tag, struct _wsu__Timestamp *a, const char *type)
{
	size_t soap_flag_Created = 1;
	size_t soap_flag_Expires = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsu__Timestamp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsu__Timestamp, sizeof(struct _wsu__Timestamp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsu__Timestamp(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, 0, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Created && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Created", &a->Created, "xsd:string"))
				{	soap_flag_Created--;
					continue;
				}
			if (soap_flag_Expires && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Expires", &a->Expires, "xsd:string"))
				{	soap_flag_Expires--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsu__Timestamp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsu__Timestamp, 0, sizeof(struct _wsu__Timestamp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsu__Timestamp(struct soap *soap, const struct _wsu__Timestamp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsu__Timestamp);
	if (soap_out__wsu__Timestamp(soap, tag?tag:"wsu:Timestamp", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsu__Timestamp * SOAP_FMAC4 soap_get__wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsu__Timestamp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct _wsu__Timestamp * SOAP_FMAC2 soap_instantiate__wsu__Timestamp(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__wsu__Timestamp(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__wsu__Timestamp, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct _wsu__Timestamp);
		if (size)
			*size = sizeof(struct _wsu__Timestamp);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct _wsu__Timestamp, n);
		if (size)
			*size = n * sizeof(struct _wsu__Timestamp);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct _wsu__Timestamp*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__wsu__Timestamp(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct _wsu__Timestamp %p -> %p\n", q, p));
	*(struct _wsu__Timestamp*)p = *(struct _wsu__Timestamp*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Divide(struct soap *soap, struct __tempuri__Divide *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamm__Divide = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Divide(struct soap *soap, const struct __tempuri__Divide *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamm__Divide(soap, &a->mssamm__Divide);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Divide(struct soap *soap, const char *tag, int id, const struct __tempuri__Divide *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamm__Divide(soap, "mssamm:Divide", -1, &a->mssamm__Divide, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Divide * SOAP_FMAC4 soap_in___tempuri__Divide(struct soap *soap, const char *tag, struct __tempuri__Divide *a, const char *type)
{
	size_t soap_flag_mssamm__Divide = 1;
	short soap_flag;
	a = (struct __tempuri__Divide *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Divide, sizeof(struct __tempuri__Divide), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Divide(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamm__Divide && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamm__Divide(soap, "mssamm:Divide", &a->mssamm__Divide, ""))
				{	soap_flag_mssamm__Divide--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Divide(struct soap *soap, const struct __tempuri__Divide *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Divide(soap, tag?tag:"-tempuri:Divide", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Divide * SOAP_FMAC4 soap_get___tempuri__Divide(struct soap *soap, struct __tempuri__Divide *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Divide * SOAP_FMAC2 soap_instantiate___tempuri__Divide(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Divide(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Divide, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Divide);
		if (size)
			*size = sizeof(struct __tempuri__Divide);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Divide, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Divide);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Divide*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Divide(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Divide %p -> %p\n", q, p));
	*(struct __tempuri__Divide*)p = *(struct __tempuri__Divide*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Multiply(struct soap *soap, struct __tempuri__Multiply *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamm__Multiply = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Multiply(struct soap *soap, const struct __tempuri__Multiply *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamm__Multiply(soap, &a->mssamm__Multiply);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Multiply(struct soap *soap, const char *tag, int id, const struct __tempuri__Multiply *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamm__Multiply(soap, "mssamm:Multiply", -1, &a->mssamm__Multiply, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Multiply * SOAP_FMAC4 soap_in___tempuri__Multiply(struct soap *soap, const char *tag, struct __tempuri__Multiply *a, const char *type)
{
	size_t soap_flag_mssamm__Multiply = 1;
	short soap_flag;
	a = (struct __tempuri__Multiply *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Multiply, sizeof(struct __tempuri__Multiply), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Multiply(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamm__Multiply && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamm__Multiply(soap, "mssamm:Multiply", &a->mssamm__Multiply, ""))
				{	soap_flag_mssamm__Multiply--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Multiply(struct soap *soap, const struct __tempuri__Multiply *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Multiply(soap, tag?tag:"-tempuri:Multiply", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Multiply * SOAP_FMAC4 soap_get___tempuri__Multiply(struct soap *soap, struct __tempuri__Multiply *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Multiply * SOAP_FMAC2 soap_instantiate___tempuri__Multiply(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Multiply(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Multiply, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Multiply);
		if (size)
			*size = sizeof(struct __tempuri__Multiply);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Multiply, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Multiply);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Multiply*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Multiply(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Multiply %p -> %p\n", q, p));
	*(struct __tempuri__Multiply*)p = *(struct __tempuri__Multiply*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Subtract(struct soap *soap, struct __tempuri__Subtract *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamm__Subtract = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Subtract(struct soap *soap, const struct __tempuri__Subtract *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamm__Subtract(soap, &a->mssamm__Subtract);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Subtract(struct soap *soap, const char *tag, int id, const struct __tempuri__Subtract *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamm__Subtract(soap, "mssamm:Subtract", -1, &a->mssamm__Subtract, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Subtract * SOAP_FMAC4 soap_in___tempuri__Subtract(struct soap *soap, const char *tag, struct __tempuri__Subtract *a, const char *type)
{
	size_t soap_flag_mssamm__Subtract = 1;
	short soap_flag;
	a = (struct __tempuri__Subtract *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Subtract, sizeof(struct __tempuri__Subtract), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Subtract(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamm__Subtract && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamm__Subtract(soap, "mssamm:Subtract", &a->mssamm__Subtract, ""))
				{	soap_flag_mssamm__Subtract--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Subtract(struct soap *soap, const struct __tempuri__Subtract *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Subtract(soap, tag?tag:"-tempuri:Subtract", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Subtract * SOAP_FMAC4 soap_get___tempuri__Subtract(struct soap *soap, struct __tempuri__Subtract *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Subtract * SOAP_FMAC2 soap_instantiate___tempuri__Subtract(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Subtract(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Subtract, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Subtract);
		if (size)
			*size = sizeof(struct __tempuri__Subtract);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Subtract, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Subtract);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Subtract*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Subtract(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Subtract %p -> %p\n", q, p));
	*(struct __tempuri__Subtract*)p = *(struct __tempuri__Subtract*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Add(struct soap *soap, struct __tempuri__Add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamm__Add = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Add(struct soap *soap, const struct __tempuri__Add *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamm__Add(soap, &a->mssamm__Add);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Add(struct soap *soap, const char *tag, int id, const struct __tempuri__Add *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamm__Add(soap, "mssamm:Add", -1, &a->mssamm__Add, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Add * SOAP_FMAC4 soap_in___tempuri__Add(struct soap *soap, const char *tag, struct __tempuri__Add *a, const char *type)
{
	size_t soap_flag_mssamm__Add = 1;
	short soap_flag;
	a = (struct __tempuri__Add *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Add, sizeof(struct __tempuri__Add), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Add(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamm__Add && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamm__Add(soap, "mssamm:Add", &a->mssamm__Add, ""))
				{	soap_flag_mssamm__Add--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Add(struct soap *soap, const struct __tempuri__Add *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Add(soap, tag?tag:"-tempuri:Add", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Add * SOAP_FMAC4 soap_get___tempuri__Add(struct soap *soap, struct __tempuri__Add *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Add * SOAP_FMAC2 soap_instantiate___tempuri__Add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Add(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Add, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Add);
		if (size)
			*size = sizeof(struct __tempuri__Add);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Add, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Add);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Add*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Add(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Add %p -> %p\n", q, p));
	*(struct __tempuri__Add*)p = *(struct __tempuri__Add*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsc__union_DerivedKeyTokenType(struct soap *soap, int choice, const union _wsc__union_DerivedKeyTokenType *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	switch (choice)
	{
	case SOAP_UNION__wsc__union_DerivedKeyTokenType_Generation:
		soap_embedded(soap, &a->Generation, SOAP_TYPE_unsignedLONG64);
		break;
	case SOAP_UNION__wsc__union_DerivedKeyTokenType_Offset:
		soap_embedded(soap, &a->Offset, SOAP_TYPE_unsignedLONG64);
		break;
	default:
		break;
	}
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsc__union_DerivedKeyTokenType(struct soap *soap, int choice, const union _wsc__union_DerivedKeyTokenType *a)
{
	switch (choice)
	{
	case SOAP_UNION__wsc__union_DerivedKeyTokenType_Generation:
		return soap_out_unsignedLONG64(soap, "wsc:Generation", -1, &a->Generation, "");
	case SOAP_UNION__wsc__union_DerivedKeyTokenType_Offset:
		return soap_out_unsignedLONG64(soap, "wsc:Offset", -1, &a->Offset, "");
	default:
		break;
	}
	return SOAP_OK;
}

SOAP_FMAC3 union _wsc__union_DerivedKeyTokenType * SOAP_FMAC4 soap_in__wsc__union_DerivedKeyTokenType(struct soap *soap, int *choice, union _wsc__union_DerivedKeyTokenType *a)
{	soap->error = SOAP_TAG_MISMATCH;
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_unsignedLONG64(soap, "wsc:Generation", &a->Generation, "xsd:unsignedLong"))
	{	*choice = SOAP_UNION__wsc__union_DerivedKeyTokenType_Generation;
		return a;
	}
	if (soap->error == SOAP_TAG_MISMATCH && soap_in_unsignedLONG64(soap, "wsc:Offset", &a->Offset, "xsd:unsignedLong"))
	{	*choice = SOAP_UNION__wsc__union_DerivedKeyTokenType_Offset;
		return a;
	}
	*choice = -1;
	if (!soap->error)
		soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__Security(struct soap *soap, struct _wsse__Security *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__Security))
		soap_serialize__wsse__Security(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__Security(struct soap *soap, const char *tag, int id, struct _wsse__Security *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__Security);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__Security(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__Security ** SOAP_FMAC4 soap_in_PointerTo_wsse__Security(struct soap *soap, const char *tag, struct _wsse__Security **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__Security **)soap_malloc(soap, sizeof(struct _wsse__Security *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__Security(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__Security **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__Security, sizeof(struct _wsse__Security), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__Security(struct soap *soap, struct _wsse__Security *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__Security);
	if (soap_out_PointerTo_wsse__Security(soap, tag?tag:"wsse:Security", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Security ** SOAP_FMAC4 soap_get_PointerTo_wsse__Security(struct soap *soap, struct _wsse__Security **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__Security(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__SignatureType(struct soap *soap, struct ds__SignatureType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__SignatureType))
		soap_serialize_ds__SignatureType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__SignatureType(struct soap *soap, const char *tag, int id, struct ds__SignatureType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__SignatureType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__SignatureType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__SignatureType ** SOAP_FMAC4 soap_in_PointerTods__SignatureType(struct soap *soap, const char *tag, struct ds__SignatureType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__SignatureType **)soap_malloc(soap, sizeof(struct ds__SignatureType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__SignatureType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__SignatureType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__SignatureType, sizeof(struct ds__SignatureType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__SignatureType(struct soap *soap, struct ds__SignatureType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__SignatureType);
	if (soap_out_PointerTods__SignatureType(soap, tag?tag:"ds:SignatureType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__SignatureType ** SOAP_FMAC4 soap_get_PointerTods__SignatureType(struct soap *soap, struct ds__SignatureType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__SignatureType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsc__SecurityContextTokenType(struct soap *soap, struct wsc__SecurityContextTokenType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_wsc__SecurityContextTokenType))
		soap_serialize_wsc__SecurityContextTokenType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsc__SecurityContextTokenType(struct soap *soap, const char *tag, int id, struct wsc__SecurityContextTokenType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsc__SecurityContextTokenType);
	if (id < 0)
		return soap->error;
	return soap_out_wsc__SecurityContextTokenType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsc__SecurityContextTokenType ** SOAP_FMAC4 soap_in_PointerTowsc__SecurityContextTokenType(struct soap *soap, const char *tag, struct wsc__SecurityContextTokenType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsc__SecurityContextTokenType **)soap_malloc(soap, sizeof(struct wsc__SecurityContextTokenType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsc__SecurityContextTokenType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsc__SecurityContextTokenType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsc__SecurityContextTokenType, sizeof(struct wsc__SecurityContextTokenType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsc__SecurityContextTokenType(struct soap *soap, struct wsc__SecurityContextTokenType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsc__SecurityContextTokenType);
	if (soap_out_PointerTowsc__SecurityContextTokenType(soap, tag?tag:"wsc:SecurityContextTokenType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsc__SecurityContextTokenType ** SOAP_FMAC4 soap_get_PointerTowsc__SecurityContextTokenType(struct soap *soap, struct wsc__SecurityContextTokenType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsc__SecurityContextTokenType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__EncryptedKeyType(struct soap *soap, struct xenc__EncryptedKeyType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__EncryptedKeyType))
		soap_serialize_xenc__EncryptedKeyType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__EncryptedKeyType(struct soap *soap, const char *tag, int id, struct xenc__EncryptedKeyType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__EncryptedKeyType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__EncryptedKeyType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__EncryptedKeyType ** SOAP_FMAC4 soap_in_PointerToxenc__EncryptedKeyType(struct soap *soap, const char *tag, struct xenc__EncryptedKeyType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__EncryptedKeyType **)soap_malloc(soap, sizeof(struct xenc__EncryptedKeyType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__EncryptedKeyType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptedKeyType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__EncryptedKeyType, sizeof(struct xenc__EncryptedKeyType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__EncryptedKeyType(struct soap *soap, struct xenc__EncryptedKeyType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__EncryptedKeyType);
	if (soap_out_PointerToxenc__EncryptedKeyType(soap, tag?tag:"xenc:EncryptedKeyType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptedKeyType ** SOAP_FMAC4 soap_get_PointerToxenc__EncryptedKeyType(struct soap *soap, struct xenc__EncryptedKeyType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__EncryptedKeyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__BinarySecurityToken(struct soap *soap, struct _wsse__BinarySecurityToken *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__BinarySecurityToken))
		soap_serialize__wsse__BinarySecurityToken(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__BinarySecurityToken(struct soap *soap, const char *tag, int id, struct _wsse__BinarySecurityToken *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__BinarySecurityToken);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__BinarySecurityToken(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__BinarySecurityToken ** SOAP_FMAC4 soap_in_PointerTo_wsse__BinarySecurityToken(struct soap *soap, const char *tag, struct _wsse__BinarySecurityToken **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__BinarySecurityToken **)soap_malloc(soap, sizeof(struct _wsse__BinarySecurityToken *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__BinarySecurityToken(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__BinarySecurityToken **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__BinarySecurityToken, sizeof(struct _wsse__BinarySecurityToken), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__BinarySecurityToken(struct soap *soap, struct _wsse__BinarySecurityToken *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__BinarySecurityToken);
	if (soap_out_PointerTo_wsse__BinarySecurityToken(soap, tag?tag:"wsse:BinarySecurityToken", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__BinarySecurityToken ** SOAP_FMAC4 soap_get_PointerTo_wsse__BinarySecurityToken(struct soap *soap, struct _wsse__BinarySecurityToken **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__BinarySecurityToken(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__UsernameToken))
		soap_serialize__wsse__UsernameToken(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__UsernameToken(struct soap *soap, const char *tag, int id, struct _wsse__UsernameToken *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__UsernameToken);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__UsernameToken(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__UsernameToken ** SOAP_FMAC4 soap_in_PointerTo_wsse__UsernameToken(struct soap *soap, const char *tag, struct _wsse__UsernameToken **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__UsernameToken **)soap_malloc(soap, sizeof(struct _wsse__UsernameToken *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__UsernameToken(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__UsernameToken **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__UsernameToken, sizeof(struct _wsse__UsernameToken), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__UsernameToken);
	if (soap_out_PointerTo_wsse__UsernameToken(soap, tag?tag:"wsse:UsernameToken", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__UsernameToken ** SOAP_FMAC4 soap_get_PointerTo_wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__UsernameToken(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsu__Timestamp))
		soap_serialize__wsu__Timestamp(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsu__Timestamp(struct soap *soap, const char *tag, int id, struct _wsu__Timestamp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsu__Timestamp);
	if (id < 0)
		return soap->error;
	return soap_out__wsu__Timestamp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsu__Timestamp ** SOAP_FMAC4 soap_in_PointerTo_wsu__Timestamp(struct soap *soap, const char *tag, struct _wsu__Timestamp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsu__Timestamp **)soap_malloc(soap, sizeof(struct _wsu__Timestamp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsu__Timestamp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsu__Timestamp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsu__Timestamp, sizeof(struct _wsu__Timestamp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsu__Timestamp);
	if (soap_out_PointerTo_wsu__Timestamp(soap, tag?tag:"wsu:Timestamp", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsu__Timestamp ** SOAP_FMAC4 soap_get_PointerTo_wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsu__Timestamp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo__wsc__DerivedKeyTokenType_sequence(struct soap *soap, struct __wsc__DerivedKeyTokenType_sequence *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE___wsc__DerivedKeyTokenType_sequence))
		soap_serialize___wsc__DerivedKeyTokenType_sequence(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo__wsc__DerivedKeyTokenType_sequence(struct soap *soap, const char *tag, int id, struct __wsc__DerivedKeyTokenType_sequence *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE___wsc__DerivedKeyTokenType_sequence);
	if (id < 0)
		return soap->error;
	return soap_out___wsc__DerivedKeyTokenType_sequence(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct __wsc__DerivedKeyTokenType_sequence ** SOAP_FMAC4 soap_in_PointerTo__wsc__DerivedKeyTokenType_sequence(struct soap *soap, const char *tag, struct __wsc__DerivedKeyTokenType_sequence **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct __wsc__DerivedKeyTokenType_sequence **)soap_malloc(soap, sizeof(struct __wsc__DerivedKeyTokenType_sequence *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in___wsc__DerivedKeyTokenType_sequence(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct __wsc__DerivedKeyTokenType_sequence **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE___wsc__DerivedKeyTokenType_sequence, sizeof(struct __wsc__DerivedKeyTokenType_sequence), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo__wsc__DerivedKeyTokenType_sequence(struct soap *soap, struct __wsc__DerivedKeyTokenType_sequence *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo__wsc__DerivedKeyTokenType_sequence);
	if (soap_out_PointerTo__wsc__DerivedKeyTokenType_sequence(soap, tag?tag:"-wsc:DerivedKeyTokenType-sequence", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct __wsc__DerivedKeyTokenType_sequence ** SOAP_FMAC4 soap_get_PointerTo__wsc__DerivedKeyTokenType_sequence(struct soap *soap, struct __wsc__DerivedKeyTokenType_sequence **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo__wsc__DerivedKeyTokenType_sequence(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedLONG64(struct soap *soap, ULONG64 *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_unsignedLONG64);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedLONG64(struct soap *soap, const char *tag, int id, ULONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedLONG64);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedLONG64(soap, tag, id, *a, type);
}

SOAP_FMAC3 ULONG64 ** SOAP_FMAC4 soap_in_PointerTounsignedLONG64(struct soap *soap, const char *tag, ULONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ULONG64 **)soap_malloc(soap, sizeof(ULONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedLONG64(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (ULONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedLONG64, sizeof(ULONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedLONG64(struct soap *soap, ULONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedLONG64);
	if (soap_out_PointerTounsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 ** SOAP_FMAC4 soap_get_PointerTounsignedLONG64(struct soap *soap, ULONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsc__PropertiesType(struct soap *soap, struct wsc__PropertiesType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_wsc__PropertiesType))
		soap_serialize_wsc__PropertiesType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsc__PropertiesType(struct soap *soap, const char *tag, int id, struct wsc__PropertiesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsc__PropertiesType);
	if (id < 0)
		return soap->error;
	return soap_out_wsc__PropertiesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsc__PropertiesType ** SOAP_FMAC4 soap_in_PointerTowsc__PropertiesType(struct soap *soap, const char *tag, struct wsc__PropertiesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsc__PropertiesType **)soap_malloc(soap, sizeof(struct wsc__PropertiesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsc__PropertiesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsc__PropertiesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsc__PropertiesType, sizeof(struct wsc__PropertiesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsc__PropertiesType(struct soap *soap, struct wsc__PropertiesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsc__PropertiesType);
	if (soap_out_PointerTowsc__PropertiesType(soap, tag?tag:"wsc:PropertiesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsc__PropertiesType ** SOAP_FMAC4 soap_get_PointerTowsc__PropertiesType(struct soap *soap, struct wsc__PropertiesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsc__PropertiesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsc__FaultCodeOpenEnumType(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_wsc__FaultCodeOpenEnumType);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsc__FaultCodeOpenEnumType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsc__FaultCodeOpenEnumType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsc__FaultCodeOpenEnumType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_wsc__FaultCodeOpenEnumType, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsc__FaultCodeOpenEnumType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsc__FaultCodeOpenEnumType);
	if (soap_out_wsc__FaultCodeOpenEnumType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsc__FaultCodeOpenEnumType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsc__FaultCodeOpenEnumType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_xenc__ReferenceList(struct soap *soap, struct _xenc__ReferenceList *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__xenc__ReferenceList))
		soap_serialize__xenc__ReferenceList(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_xenc__ReferenceList(struct soap *soap, const char *tag, int id, struct _xenc__ReferenceList *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__xenc__ReferenceList);
	if (id < 0)
		return soap->error;
	return soap_out__xenc__ReferenceList(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _xenc__ReferenceList ** SOAP_FMAC4 soap_in_PointerTo_xenc__ReferenceList(struct soap *soap, const char *tag, struct _xenc__ReferenceList **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _xenc__ReferenceList **)soap_malloc(soap, sizeof(struct _xenc__ReferenceList *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__xenc__ReferenceList(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _xenc__ReferenceList **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__xenc__ReferenceList, sizeof(struct _xenc__ReferenceList), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_xenc__ReferenceList(struct soap *soap, struct _xenc__ReferenceList *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_xenc__ReferenceList);
	if (soap_out_PointerTo_xenc__ReferenceList(soap, tag?tag:"xenc:ReferenceList", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _xenc__ReferenceList ** SOAP_FMAC4 soap_get_PointerTo_xenc__ReferenceList(struct soap *soap, struct _xenc__ReferenceList **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_xenc__ReferenceList(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo__xenc__union_ReferenceList(struct soap *soap, struct __xenc__union_ReferenceList *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE___xenc__union_ReferenceList))
		soap_serialize___xenc__union_ReferenceList(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo__xenc__union_ReferenceList(struct soap *soap, const char *tag, int id, struct __xenc__union_ReferenceList *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE___xenc__union_ReferenceList);
	if (id < 0)
		return soap->error;
	return soap_out___xenc__union_ReferenceList(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct __xenc__union_ReferenceList ** SOAP_FMAC4 soap_in_PointerTo__xenc__union_ReferenceList(struct soap *soap, const char *tag, struct __xenc__union_ReferenceList **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct __xenc__union_ReferenceList **)soap_malloc(soap, sizeof(struct __xenc__union_ReferenceList *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in___xenc__union_ReferenceList(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct __xenc__union_ReferenceList **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE___xenc__union_ReferenceList, sizeof(struct __xenc__union_ReferenceList), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo__xenc__union_ReferenceList(struct soap *soap, struct __xenc__union_ReferenceList *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo__xenc__union_ReferenceList);
	if (soap_out_PointerTo__xenc__union_ReferenceList(soap, tag?tag:"-xenc:union-ReferenceList", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct __xenc__union_ReferenceList ** SOAP_FMAC4 soap_get_PointerTo__xenc__union_ReferenceList(struct soap *soap, struct __xenc__union_ReferenceList **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo__xenc__union_ReferenceList(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__ReferenceType(struct soap *soap, struct xenc__ReferenceType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__ReferenceType))
		soap_serialize_xenc__ReferenceType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__ReferenceType(struct soap *soap, const char *tag, int id, struct xenc__ReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__ReferenceType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__ReferenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__ReferenceType ** SOAP_FMAC4 soap_in_PointerToxenc__ReferenceType(struct soap *soap, const char *tag, struct xenc__ReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__ReferenceType **)soap_malloc(soap, sizeof(struct xenc__ReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__ReferenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__ReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__ReferenceType, sizeof(struct xenc__ReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__ReferenceType(struct soap *soap, struct xenc__ReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__ReferenceType);
	if (soap_out_PointerToxenc__ReferenceType(soap, tag?tag:"xenc:ReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__ReferenceType ** SOAP_FMAC4 soap_get_PointerToxenc__ReferenceType(struct soap *soap, struct xenc__ReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__ReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__EncryptionPropertyType(struct soap *soap, struct xenc__EncryptionPropertyType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__EncryptionPropertyType))
		soap_serialize_xenc__EncryptionPropertyType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__EncryptionPropertyType(struct soap *soap, const char *tag, int id, struct xenc__EncryptionPropertyType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__EncryptionPropertyType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__EncryptionPropertyType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__EncryptionPropertyType ** SOAP_FMAC4 soap_in_PointerToxenc__EncryptionPropertyType(struct soap *soap, const char *tag, struct xenc__EncryptionPropertyType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__EncryptionPropertyType **)soap_malloc(soap, sizeof(struct xenc__EncryptionPropertyType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__EncryptionPropertyType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptionPropertyType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__EncryptionPropertyType, sizeof(struct xenc__EncryptionPropertyType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__EncryptionPropertyType(struct soap *soap, struct xenc__EncryptionPropertyType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__EncryptionPropertyType);
	if (soap_out_PointerToxenc__EncryptionPropertyType(soap, tag?tag:"xenc:EncryptionPropertyType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptionPropertyType ** SOAP_FMAC4 soap_get_PointerToxenc__EncryptionPropertyType(struct soap *soap, struct xenc__EncryptionPropertyType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__EncryptionPropertyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__TransformsType(struct soap *soap, struct xenc__TransformsType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__TransformsType))
		soap_serialize_xenc__TransformsType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__TransformsType(struct soap *soap, const char *tag, int id, struct xenc__TransformsType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__TransformsType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__TransformsType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__TransformsType ** SOAP_FMAC4 soap_in_PointerToxenc__TransformsType(struct soap *soap, const char *tag, struct xenc__TransformsType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__TransformsType **)soap_malloc(soap, sizeof(struct xenc__TransformsType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__TransformsType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__TransformsType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__TransformsType, sizeof(struct xenc__TransformsType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__TransformsType(struct soap *soap, struct xenc__TransformsType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__TransformsType);
	if (soap_out_PointerToxenc__TransformsType(soap, tag?tag:"xenc:TransformsType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__TransformsType ** SOAP_FMAC4 soap_get_PointerToxenc__TransformsType(struct soap *soap, struct xenc__TransformsType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__TransformsType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__CipherReferenceType(struct soap *soap, struct xenc__CipherReferenceType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__CipherReferenceType))
		soap_serialize_xenc__CipherReferenceType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__CipherReferenceType(struct soap *soap, const char *tag, int id, struct xenc__CipherReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__CipherReferenceType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__CipherReferenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__CipherReferenceType ** SOAP_FMAC4 soap_in_PointerToxenc__CipherReferenceType(struct soap *soap, const char *tag, struct xenc__CipherReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__CipherReferenceType **)soap_malloc(soap, sizeof(struct xenc__CipherReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__CipherReferenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__CipherReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__CipherReferenceType, sizeof(struct xenc__CipherReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__CipherReferenceType(struct soap *soap, struct xenc__CipherReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__CipherReferenceType);
	if (soap_out_PointerToxenc__CipherReferenceType(soap, tag?tag:"xenc:CipherReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__CipherReferenceType ** SOAP_FMAC4 soap_get_PointerToxenc__CipherReferenceType(struct soap *soap, struct xenc__CipherReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__CipherReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__EncryptionPropertiesType(struct soap *soap, struct xenc__EncryptionPropertiesType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__EncryptionPropertiesType))
		soap_serialize_xenc__EncryptionPropertiesType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__EncryptionPropertiesType(struct soap *soap, const char *tag, int id, struct xenc__EncryptionPropertiesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__EncryptionPropertiesType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__EncryptionPropertiesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__EncryptionPropertiesType ** SOAP_FMAC4 soap_in_PointerToxenc__EncryptionPropertiesType(struct soap *soap, const char *tag, struct xenc__EncryptionPropertiesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__EncryptionPropertiesType **)soap_malloc(soap, sizeof(struct xenc__EncryptionPropertiesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__EncryptionPropertiesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptionPropertiesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__EncryptionPropertiesType, sizeof(struct xenc__EncryptionPropertiesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__EncryptionPropertiesType(struct soap *soap, struct xenc__EncryptionPropertiesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__EncryptionPropertiesType);
	if (soap_out_PointerToxenc__EncryptionPropertiesType(soap, tag?tag:"xenc:EncryptionPropertiesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptionPropertiesType ** SOAP_FMAC4 soap_get_PointerToxenc__EncryptionPropertiesType(struct soap *soap, struct xenc__EncryptionPropertiesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__EncryptionPropertiesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__CipherDataType(struct soap *soap, struct xenc__CipherDataType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__CipherDataType))
		soap_serialize_xenc__CipherDataType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__CipherDataType(struct soap *soap, const char *tag, int id, struct xenc__CipherDataType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__CipherDataType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__CipherDataType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__CipherDataType ** SOAP_FMAC4 soap_in_PointerToxenc__CipherDataType(struct soap *soap, const char *tag, struct xenc__CipherDataType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__CipherDataType **)soap_malloc(soap, sizeof(struct xenc__CipherDataType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__CipherDataType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__CipherDataType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__CipherDataType, sizeof(struct xenc__CipherDataType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__CipherDataType(struct soap *soap, struct xenc__CipherDataType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__CipherDataType);
	if (soap_out_PointerToxenc__CipherDataType(soap, tag?tag:"xenc:CipherDataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__CipherDataType ** SOAP_FMAC4 soap_get_PointerToxenc__CipherDataType(struct soap *soap, struct xenc__CipherDataType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__CipherDataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ds__KeyInfo(struct soap *soap, struct ds__KeyInfoType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__ds__KeyInfo))
		soap_serialize__ds__KeyInfo(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ds__KeyInfo(struct soap *soap, const char *tag, int id, struct ds__KeyInfoType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ds__KeyInfo);
	if (id < 0)
		return soap->error;
	return soap_out__ds__KeyInfo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__KeyInfoType ** SOAP_FMAC4 soap_in_PointerTo_ds__KeyInfo(struct soap *soap, const char *tag, struct ds__KeyInfoType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__KeyInfoType **)soap_malloc(soap, sizeof(struct ds__KeyInfoType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ds__KeyInfo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__KeyInfoType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ds__KeyInfo, sizeof(struct ds__KeyInfoType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ds__KeyInfo(struct soap *soap, struct ds__KeyInfoType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ds__KeyInfo);
	if (soap_out_PointerTo_ds__KeyInfo(soap, tag?tag:"ds:KeyInfo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__KeyInfoType ** SOAP_FMAC4 soap_get_PointerTo_ds__KeyInfo(struct soap *soap, struct ds__KeyInfoType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ds__KeyInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxenc__EncryptionMethodType(struct soap *soap, struct xenc__EncryptionMethodType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_xenc__EncryptionMethodType))
		soap_serialize_xenc__EncryptionMethodType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxenc__EncryptionMethodType(struct soap *soap, const char *tag, int id, struct xenc__EncryptionMethodType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xenc__EncryptionMethodType);
	if (id < 0)
		return soap->error;
	return soap_out_xenc__EncryptionMethodType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xenc__EncryptionMethodType ** SOAP_FMAC4 soap_in_PointerToxenc__EncryptionMethodType(struct soap *soap, const char *tag, struct xenc__EncryptionMethodType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xenc__EncryptionMethodType **)soap_malloc(soap, sizeof(struct xenc__EncryptionMethodType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xenc__EncryptionMethodType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xenc__EncryptionMethodType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xenc__EncryptionMethodType, sizeof(struct xenc__EncryptionMethodType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxenc__EncryptionMethodType(struct soap *soap, struct xenc__EncryptionMethodType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxenc__EncryptionMethodType);
	if (soap_out_PointerToxenc__EncryptionMethodType(soap, tag?tag:"xenc:EncryptionMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xenc__EncryptionMethodType ** SOAP_FMAC4 soap_get_PointerToxenc__EncryptionMethodType(struct soap *soap, struct xenc__EncryptionMethodType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxenc__EncryptionMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__X509IssuerSerialType(struct soap *soap, struct ds__X509IssuerSerialType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__X509IssuerSerialType))
		soap_serialize_ds__X509IssuerSerialType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__X509IssuerSerialType(struct soap *soap, const char *tag, int id, struct ds__X509IssuerSerialType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__X509IssuerSerialType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__X509IssuerSerialType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__X509IssuerSerialType ** SOAP_FMAC4 soap_in_PointerTods__X509IssuerSerialType(struct soap *soap, const char *tag, struct ds__X509IssuerSerialType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__X509IssuerSerialType **)soap_malloc(soap, sizeof(struct ds__X509IssuerSerialType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__X509IssuerSerialType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__X509IssuerSerialType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__X509IssuerSerialType, sizeof(struct ds__X509IssuerSerialType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__X509IssuerSerialType(struct soap *soap, struct ds__X509IssuerSerialType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__X509IssuerSerialType);
	if (soap_out_PointerTods__X509IssuerSerialType(soap, tag?tag:"ds:X509IssuerSerialType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__X509IssuerSerialType ** SOAP_FMAC4 soap_get_PointerTods__X509IssuerSerialType(struct soap *soap, struct ds__X509IssuerSerialType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__X509IssuerSerialType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__RSAKeyValueType(struct soap *soap, struct ds__RSAKeyValueType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__RSAKeyValueType))
		soap_serialize_ds__RSAKeyValueType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__RSAKeyValueType(struct soap *soap, const char *tag, int id, struct ds__RSAKeyValueType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__RSAKeyValueType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__RSAKeyValueType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__RSAKeyValueType ** SOAP_FMAC4 soap_in_PointerTods__RSAKeyValueType(struct soap *soap, const char *tag, struct ds__RSAKeyValueType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__RSAKeyValueType **)soap_malloc(soap, sizeof(struct ds__RSAKeyValueType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__RSAKeyValueType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__RSAKeyValueType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__RSAKeyValueType, sizeof(struct ds__RSAKeyValueType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__RSAKeyValueType(struct soap *soap, struct ds__RSAKeyValueType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__RSAKeyValueType);
	if (soap_out_PointerTods__RSAKeyValueType(soap, tag?tag:"ds:RSAKeyValueType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__RSAKeyValueType ** SOAP_FMAC4 soap_get_PointerTods__RSAKeyValueType(struct soap *soap, struct ds__RSAKeyValueType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__RSAKeyValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__DSAKeyValueType(struct soap *soap, struct ds__DSAKeyValueType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__DSAKeyValueType))
		soap_serialize_ds__DSAKeyValueType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__DSAKeyValueType(struct soap *soap, const char *tag, int id, struct ds__DSAKeyValueType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__DSAKeyValueType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__DSAKeyValueType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__DSAKeyValueType ** SOAP_FMAC4 soap_in_PointerTods__DSAKeyValueType(struct soap *soap, const char *tag, struct ds__DSAKeyValueType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__DSAKeyValueType **)soap_malloc(soap, sizeof(struct ds__DSAKeyValueType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__DSAKeyValueType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__DSAKeyValueType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__DSAKeyValueType, sizeof(struct ds__DSAKeyValueType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__DSAKeyValueType(struct soap *soap, struct ds__DSAKeyValueType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__DSAKeyValueType);
	if (soap_out_PointerTods__DSAKeyValueType(soap, tag?tag:"ds:DSAKeyValueType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__DSAKeyValueType ** SOAP_FMAC4 soap_get_PointerTods__DSAKeyValueType(struct soap *soap, struct ds__DSAKeyValueType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__DSAKeyValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__TransformType(struct soap *soap, struct ds__TransformType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__TransformType))
		soap_serialize_ds__TransformType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__TransformType(struct soap *soap, const char *tag, int id, struct ds__TransformType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__TransformType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__TransformType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__TransformType ** SOAP_FMAC4 soap_in_PointerTods__TransformType(struct soap *soap, const char *tag, struct ds__TransformType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__TransformType **)soap_malloc(soap, sizeof(struct ds__TransformType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__TransformType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__TransformType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__TransformType, sizeof(struct ds__TransformType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__TransformType(struct soap *soap, struct ds__TransformType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__TransformType);
	if (soap_out_PointerTods__TransformType(soap, tag?tag:"ds:TransformType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__TransformType ** SOAP_FMAC4 soap_get_PointerTods__TransformType(struct soap *soap, struct ds__TransformType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__TransformType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__DigestMethodType(struct soap *soap, struct ds__DigestMethodType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__DigestMethodType))
		soap_serialize_ds__DigestMethodType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__DigestMethodType(struct soap *soap, const char *tag, int id, struct ds__DigestMethodType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__DigestMethodType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__DigestMethodType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__DigestMethodType ** SOAP_FMAC4 soap_in_PointerTods__DigestMethodType(struct soap *soap, const char *tag, struct ds__DigestMethodType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__DigestMethodType **)soap_malloc(soap, sizeof(struct ds__DigestMethodType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__DigestMethodType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__DigestMethodType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__DigestMethodType, sizeof(struct ds__DigestMethodType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__DigestMethodType(struct soap *soap, struct ds__DigestMethodType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__DigestMethodType);
	if (soap_out_PointerTods__DigestMethodType(soap, tag?tag:"ds:DigestMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__DigestMethodType ** SOAP_FMAC4 soap_get_PointerTods__DigestMethodType(struct soap *soap, struct ds__DigestMethodType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__DigestMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__TransformsType(struct soap *soap, struct ds__TransformsType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__TransformsType))
		soap_serialize_ds__TransformsType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__TransformsType(struct soap *soap, const char *tag, int id, struct ds__TransformsType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__TransformsType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__TransformsType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__TransformsType ** SOAP_FMAC4 soap_in_PointerTods__TransformsType(struct soap *soap, const char *tag, struct ds__TransformsType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__TransformsType **)soap_malloc(soap, sizeof(struct ds__TransformsType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__TransformsType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__TransformsType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__TransformsType, sizeof(struct ds__TransformsType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__TransformsType(struct soap *soap, struct ds__TransformsType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__TransformsType);
	if (soap_out_PointerTods__TransformsType(soap, tag?tag:"ds:TransformsType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__TransformsType ** SOAP_FMAC4 soap_get_PointerTods__TransformsType(struct soap *soap, struct ds__TransformsType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__TransformsType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_int);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
	if (id < 0)
		return soap->error;
	return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
	if (soap_out_PointerToint(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTods__ReferenceType(struct soap *soap, struct ds__ReferenceType **const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTods__ReferenceType))
		soap_serialize_PointerTods__ReferenceType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTods__ReferenceType(struct soap *soap, const char *tag, int id, struct ds__ReferenceType **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTods__ReferenceType);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTods__ReferenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__ReferenceType *** SOAP_FMAC4 soap_in_PointerToPointerTods__ReferenceType(struct soap *soap, const char *tag, struct ds__ReferenceType ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__ReferenceType ***)soap_malloc(soap, sizeof(struct ds__ReferenceType **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTods__ReferenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__ReferenceType ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTods__ReferenceType, sizeof(struct ds__ReferenceType *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTods__ReferenceType(struct soap *soap, struct ds__ReferenceType **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTods__ReferenceType);
	if (soap_out_PointerToPointerTods__ReferenceType(soap, tag?tag:"ds:ReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__ReferenceType *** SOAP_FMAC4 soap_get_PointerToPointerTods__ReferenceType(struct soap *soap, struct ds__ReferenceType ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTods__ReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__ReferenceType(struct soap *soap, struct ds__ReferenceType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__ReferenceType))
		soap_serialize_ds__ReferenceType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__ReferenceType(struct soap *soap, const char *tag, int id, struct ds__ReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__ReferenceType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__ReferenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__ReferenceType ** SOAP_FMAC4 soap_in_PointerTods__ReferenceType(struct soap *soap, const char *tag, struct ds__ReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__ReferenceType **)soap_malloc(soap, sizeof(struct ds__ReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__ReferenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__ReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__ReferenceType, sizeof(struct ds__ReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__ReferenceType(struct soap *soap, struct ds__ReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__ReferenceType);
	if (soap_out_PointerTods__ReferenceType(soap, tag?tag:"ds:ReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__ReferenceType ** SOAP_FMAC4 soap_get_PointerTods__ReferenceType(struct soap *soap, struct ds__ReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__ReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__SignatureMethodType(struct soap *soap, struct ds__SignatureMethodType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__SignatureMethodType))
		soap_serialize_ds__SignatureMethodType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__SignatureMethodType(struct soap *soap, const char *tag, int id, struct ds__SignatureMethodType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__SignatureMethodType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__SignatureMethodType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__SignatureMethodType ** SOAP_FMAC4 soap_in_PointerTods__SignatureMethodType(struct soap *soap, const char *tag, struct ds__SignatureMethodType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__SignatureMethodType **)soap_malloc(soap, sizeof(struct ds__SignatureMethodType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__SignatureMethodType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__SignatureMethodType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__SignatureMethodType, sizeof(struct ds__SignatureMethodType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__SignatureMethodType(struct soap *soap, struct ds__SignatureMethodType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__SignatureMethodType);
	if (soap_out_PointerTods__SignatureMethodType(soap, tag?tag:"ds:SignatureMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__SignatureMethodType ** SOAP_FMAC4 soap_get_PointerTods__SignatureMethodType(struct soap *soap, struct ds__SignatureMethodType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__SignatureMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__CanonicalizationMethodType(struct soap *soap, struct ds__CanonicalizationMethodType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__CanonicalizationMethodType))
		soap_serialize_ds__CanonicalizationMethodType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__CanonicalizationMethodType(struct soap *soap, const char *tag, int id, struct ds__CanonicalizationMethodType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__CanonicalizationMethodType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__CanonicalizationMethodType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__CanonicalizationMethodType ** SOAP_FMAC4 soap_in_PointerTods__CanonicalizationMethodType(struct soap *soap, const char *tag, struct ds__CanonicalizationMethodType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__CanonicalizationMethodType **)soap_malloc(soap, sizeof(struct ds__CanonicalizationMethodType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__CanonicalizationMethodType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__CanonicalizationMethodType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__CanonicalizationMethodType, sizeof(struct ds__CanonicalizationMethodType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__CanonicalizationMethodType(struct soap *soap, struct ds__CanonicalizationMethodType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__CanonicalizationMethodType);
	if (soap_out_PointerTods__CanonicalizationMethodType(soap, tag?tag:"ds:CanonicalizationMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__CanonicalizationMethodType ** SOAP_FMAC4 soap_get_PointerTods__CanonicalizationMethodType(struct soap *soap, struct ds__CanonicalizationMethodType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__CanonicalizationMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__SecurityTokenReference(struct soap *soap, struct _wsse__SecurityTokenReference *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__SecurityTokenReference))
		soap_serialize__wsse__SecurityTokenReference(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__SecurityTokenReference(struct soap *soap, const char *tag, int id, struct _wsse__SecurityTokenReference *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__SecurityTokenReference);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__SecurityTokenReference(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__SecurityTokenReference ** SOAP_FMAC4 soap_in_PointerTo_wsse__SecurityTokenReference(struct soap *soap, const char *tag, struct _wsse__SecurityTokenReference **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__SecurityTokenReference **)soap_malloc(soap, sizeof(struct _wsse__SecurityTokenReference *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__SecurityTokenReference(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__SecurityTokenReference **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__SecurityTokenReference, sizeof(struct _wsse__SecurityTokenReference), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__SecurityTokenReference(struct soap *soap, struct _wsse__SecurityTokenReference *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__SecurityTokenReference);
	if (soap_out_PointerTo_wsse__SecurityTokenReference(soap, tag?tag:"wsse:SecurityTokenReference", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__SecurityTokenReference ** SOAP_FMAC4 soap_get_PointerTo_wsse__SecurityTokenReference(struct soap *soap, struct _wsse__SecurityTokenReference **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__SecurityTokenReference(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__RetrievalMethodType(struct soap *soap, struct ds__RetrievalMethodType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__RetrievalMethodType))
		soap_serialize_ds__RetrievalMethodType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__RetrievalMethodType(struct soap *soap, const char *tag, int id, struct ds__RetrievalMethodType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__RetrievalMethodType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__RetrievalMethodType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__RetrievalMethodType ** SOAP_FMAC4 soap_in_PointerTods__RetrievalMethodType(struct soap *soap, const char *tag, struct ds__RetrievalMethodType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__RetrievalMethodType **)soap_malloc(soap, sizeof(struct ds__RetrievalMethodType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__RetrievalMethodType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__RetrievalMethodType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__RetrievalMethodType, sizeof(struct ds__RetrievalMethodType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__RetrievalMethodType(struct soap *soap, struct ds__RetrievalMethodType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__RetrievalMethodType);
	if (soap_out_PointerTods__RetrievalMethodType(soap, tag?tag:"ds:RetrievalMethodType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__RetrievalMethodType ** SOAP_FMAC4 soap_get_PointerTods__RetrievalMethodType(struct soap *soap, struct ds__RetrievalMethodType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__RetrievalMethodType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__KeyValueType(struct soap *soap, struct ds__KeyValueType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__KeyValueType))
		soap_serialize_ds__KeyValueType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__KeyValueType(struct soap *soap, const char *tag, int id, struct ds__KeyValueType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__KeyValueType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__KeyValueType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__KeyValueType ** SOAP_FMAC4 soap_in_PointerTods__KeyValueType(struct soap *soap, const char *tag, struct ds__KeyValueType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__KeyValueType **)soap_malloc(soap, sizeof(struct ds__KeyValueType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__KeyValueType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__KeyValueType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__KeyValueType, sizeof(struct ds__KeyValueType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__KeyValueType(struct soap *soap, struct ds__KeyValueType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__KeyValueType);
	if (soap_out_PointerTods__KeyValueType(soap, tag?tag:"ds:KeyValueType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__KeyValueType ** SOAP_FMAC4 soap_get_PointerTods__KeyValueType(struct soap *soap, struct ds__KeyValueType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__KeyValueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_c14n__InclusiveNamespaces(struct soap *soap, struct _c14n__InclusiveNamespaces *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__c14n__InclusiveNamespaces))
		soap_serialize__c14n__InclusiveNamespaces(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_c14n__InclusiveNamespaces(struct soap *soap, const char *tag, int id, struct _c14n__InclusiveNamespaces *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__c14n__InclusiveNamespaces);
	if (id < 0)
		return soap->error;
	return soap_out__c14n__InclusiveNamespaces(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _c14n__InclusiveNamespaces ** SOAP_FMAC4 soap_in_PointerTo_c14n__InclusiveNamespaces(struct soap *soap, const char *tag, struct _c14n__InclusiveNamespaces **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _c14n__InclusiveNamespaces **)soap_malloc(soap, sizeof(struct _c14n__InclusiveNamespaces *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__c14n__InclusiveNamespaces(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _c14n__InclusiveNamespaces **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__c14n__InclusiveNamespaces, sizeof(struct _c14n__InclusiveNamespaces), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_c14n__InclusiveNamespaces(struct soap *soap, struct _c14n__InclusiveNamespaces *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_c14n__InclusiveNamespaces);
	if (soap_out_PointerTo_c14n__InclusiveNamespaces(soap, tag?tag:"c14n:InclusiveNamespaces", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _c14n__InclusiveNamespaces ** SOAP_FMAC4 soap_get_PointerTo_c14n__InclusiveNamespaces(struct soap *soap, struct _c14n__InclusiveNamespaces **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_c14n__InclusiveNamespaces(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__KeyInfoType(struct soap *soap, struct ds__KeyInfoType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__KeyInfoType))
		soap_serialize_ds__KeyInfoType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__KeyInfoType(struct soap *soap, const char *tag, int id, struct ds__KeyInfoType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__KeyInfoType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__KeyInfoType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__KeyInfoType ** SOAP_FMAC4 soap_in_PointerTods__KeyInfoType(struct soap *soap, const char *tag, struct ds__KeyInfoType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__KeyInfoType **)soap_malloc(soap, sizeof(struct ds__KeyInfoType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__KeyInfoType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__KeyInfoType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__KeyInfoType, sizeof(struct ds__KeyInfoType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__KeyInfoType(struct soap *soap, struct ds__KeyInfoType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__KeyInfoType);
	if (soap_out_PointerTods__KeyInfoType(soap, tag?tag:"ds:KeyInfoType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__KeyInfoType ** SOAP_FMAC4 soap_get_PointerTods__KeyInfoType(struct soap *soap, struct ds__KeyInfoType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__KeyInfoType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__SignedInfoType(struct soap *soap, struct ds__SignedInfoType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__SignedInfoType))
		soap_serialize_ds__SignedInfoType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__SignedInfoType(struct soap *soap, const char *tag, int id, struct ds__SignedInfoType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__SignedInfoType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__SignedInfoType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__SignedInfoType ** SOAP_FMAC4 soap_in_PointerTods__SignedInfoType(struct soap *soap, const char *tag, struct ds__SignedInfoType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__SignedInfoType **)soap_malloc(soap, sizeof(struct ds__SignedInfoType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__SignedInfoType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__SignedInfoType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__SignedInfoType, sizeof(struct ds__SignedInfoType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__SignedInfoType(struct soap *soap, struct ds__SignedInfoType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__SignedInfoType);
	if (soap_out_PointerTods__SignedInfoType(soap, tag?tag:"ds:SignedInfoType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__SignedInfoType ** SOAP_FMAC4 soap_get_PointerTods__SignedInfoType(struct soap *soap, struct ds__SignedInfoType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__SignedInfoType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTods__X509DataType(struct soap *soap, struct ds__X509DataType *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_ds__X509DataType))
		soap_serialize_ds__X509DataType(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTods__X509DataType(struct soap *soap, const char *tag, int id, struct ds__X509DataType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ds__X509DataType);
	if (id < 0)
		return soap->error;
	return soap_out_ds__X509DataType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ds__X509DataType ** SOAP_FMAC4 soap_in_PointerTods__X509DataType(struct soap *soap, const char *tag, struct ds__X509DataType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ds__X509DataType **)soap_malloc(soap, sizeof(struct ds__X509DataType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ds__X509DataType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ds__X509DataType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ds__X509DataType, sizeof(struct ds__X509DataType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTods__X509DataType(struct soap *soap, struct ds__X509DataType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTods__X509DataType);
	if (soap_out_PointerTods__X509DataType(soap, tag?tag:"ds:X509DataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ds__X509DataType ** SOAP_FMAC4 soap_get_PointerTods__X509DataType(struct soap *soap, struct ds__X509DataType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTods__X509DataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__Embedded(struct soap *soap, struct _wsse__Embedded *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__Embedded))
		soap_serialize__wsse__Embedded(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__Embedded(struct soap *soap, const char *tag, int id, struct _wsse__Embedded *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__Embedded);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__Embedded(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__Embedded ** SOAP_FMAC4 soap_in_PointerTo_wsse__Embedded(struct soap *soap, const char *tag, struct _wsse__Embedded **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__Embedded **)soap_malloc(soap, sizeof(struct _wsse__Embedded *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__Embedded(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__Embedded **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__Embedded, sizeof(struct _wsse__Embedded), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__Embedded(struct soap *soap, struct _wsse__Embedded *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__Embedded);
	if (soap_out_PointerTo_wsse__Embedded(soap, tag?tag:"wsse:Embedded", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Embedded ** SOAP_FMAC4 soap_get_PointerTo_wsse__Embedded(struct soap *soap, struct _wsse__Embedded **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__Embedded(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__KeyIdentifier(struct soap *soap, struct _wsse__KeyIdentifier *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__KeyIdentifier))
		soap_serialize__wsse__KeyIdentifier(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__KeyIdentifier(struct soap *soap, const char *tag, int id, struct _wsse__KeyIdentifier *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__KeyIdentifier);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__KeyIdentifier(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__KeyIdentifier ** SOAP_FMAC4 soap_in_PointerTo_wsse__KeyIdentifier(struct soap *soap, const char *tag, struct _wsse__KeyIdentifier **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__KeyIdentifier **)soap_malloc(soap, sizeof(struct _wsse__KeyIdentifier *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__KeyIdentifier(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__KeyIdentifier **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__KeyIdentifier, sizeof(struct _wsse__KeyIdentifier), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__KeyIdentifier(struct soap *soap, struct _wsse__KeyIdentifier *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__KeyIdentifier);
	if (soap_out_PointerTo_wsse__KeyIdentifier(soap, tag?tag:"wsse:KeyIdentifier", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__KeyIdentifier ** SOAP_FMAC4 soap_get_PointerTo_wsse__KeyIdentifier(struct soap *soap, struct _wsse__KeyIdentifier **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__KeyIdentifier(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__Reference(struct soap *soap, struct _wsse__Reference *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__Reference))
		soap_serialize__wsse__Reference(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__Reference(struct soap *soap, const char *tag, int id, struct _wsse__Reference *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__Reference);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__Reference(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__Reference ** SOAP_FMAC4 soap_in_PointerTo_wsse__Reference(struct soap *soap, const char *tag, struct _wsse__Reference **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__Reference **)soap_malloc(soap, sizeof(struct _wsse__Reference *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__Reference(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__Reference **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__Reference, sizeof(struct _wsse__Reference), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__Reference(struct soap *soap, struct _wsse__Reference *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__Reference);
	if (soap_out_PointerTo_wsse__Reference(soap, tag?tag:"wsse:Reference", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Reference ** SOAP_FMAC4 soap_get_PointerTo_wsse__Reference(struct soap *soap, struct _wsse__Reference **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__Reference(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__Password(struct soap *soap, struct _wsse__Password *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__Password))
		soap_serialize__wsse__Password(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__Password(struct soap *soap, const char *tag, int id, struct _wsse__Password *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__Password);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__Password(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__Password ** SOAP_FMAC4 soap_in_PointerTo_wsse__Password(struct soap *soap, const char *tag, struct _wsse__Password **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__Password **)soap_malloc(soap, sizeof(struct _wsse__Password *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__Password(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__Password **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__Password, sizeof(struct _wsse__Password), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__Password(struct soap *soap, struct _wsse__Password *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__Password);
	if (soap_out_PointerTo_wsse__Password(soap, tag?tag:"wsse:Password", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Password ** SOAP_FMAC4 soap_get_PointerTo_wsse__Password(struct soap *soap, struct _wsse__Password **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__Password(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__DivideResponse(struct soap *soap, _mssamm__DivideResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__DivideResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__DivideResponse(struct soap *soap, const char *tag, int id, _mssamm__DivideResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__DivideResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__DivideResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamm__DivideResponse(struct soap *soap, const char *tag, _mssamm__DivideResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__DivideResponse **)soap_malloc(soap, sizeof(_mssamm__DivideResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__DivideResponse *)soap_instantiate__mssamm__DivideResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__DivideResponse ** p = (_mssamm__DivideResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__DivideResponse, sizeof(_mssamm__DivideResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__DivideResponse(struct soap *soap, _mssamm__DivideResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__DivideResponse);
	if (soap_out_PointerTo_mssamm__DivideResponse(soap, tag?tag:"mssamm:DivideResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__DivideResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamm__DivideResponse(struct soap *soap, _mssamm__DivideResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__DivideResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__Divide(struct soap *soap, _mssamm__Divide *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__Divide))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__Divide(struct soap *soap, const char *tag, int id, _mssamm__Divide *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__Divide);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__Divide ** SOAP_FMAC4 soap_in_PointerTo_mssamm__Divide(struct soap *soap, const char *tag, _mssamm__Divide **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__Divide **)soap_malloc(soap, sizeof(_mssamm__Divide *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__Divide *)soap_instantiate__mssamm__Divide(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__Divide ** p = (_mssamm__Divide **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__Divide, sizeof(_mssamm__Divide), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__Divide(struct soap *soap, _mssamm__Divide *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__Divide);
	if (soap_out_PointerTo_mssamm__Divide(soap, tag?tag:"mssamm:Divide", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__Divide ** SOAP_FMAC4 soap_get_PointerTo_mssamm__Divide(struct soap *soap, _mssamm__Divide **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__MultiplyResponse(struct soap *soap, _mssamm__MultiplyResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__MultiplyResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__MultiplyResponse(struct soap *soap, const char *tag, int id, _mssamm__MultiplyResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__MultiplyResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__MultiplyResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamm__MultiplyResponse(struct soap *soap, const char *tag, _mssamm__MultiplyResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__MultiplyResponse **)soap_malloc(soap, sizeof(_mssamm__MultiplyResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__MultiplyResponse *)soap_instantiate__mssamm__MultiplyResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__MultiplyResponse ** p = (_mssamm__MultiplyResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__MultiplyResponse, sizeof(_mssamm__MultiplyResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__MultiplyResponse(struct soap *soap, _mssamm__MultiplyResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__MultiplyResponse);
	if (soap_out_PointerTo_mssamm__MultiplyResponse(soap, tag?tag:"mssamm:MultiplyResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__MultiplyResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamm__MultiplyResponse(struct soap *soap, _mssamm__MultiplyResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__MultiplyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__Multiply(struct soap *soap, _mssamm__Multiply *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__Multiply))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__Multiply(struct soap *soap, const char *tag, int id, _mssamm__Multiply *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__Multiply);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__Multiply ** SOAP_FMAC4 soap_in_PointerTo_mssamm__Multiply(struct soap *soap, const char *tag, _mssamm__Multiply **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__Multiply **)soap_malloc(soap, sizeof(_mssamm__Multiply *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__Multiply *)soap_instantiate__mssamm__Multiply(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__Multiply ** p = (_mssamm__Multiply **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__Multiply, sizeof(_mssamm__Multiply), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__Multiply(struct soap *soap, _mssamm__Multiply *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__Multiply);
	if (soap_out_PointerTo_mssamm__Multiply(soap, tag?tag:"mssamm:Multiply", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__Multiply ** SOAP_FMAC4 soap_get_PointerTo_mssamm__Multiply(struct soap *soap, _mssamm__Multiply **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__SubtractResponse(struct soap *soap, _mssamm__SubtractResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__SubtractResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__SubtractResponse(struct soap *soap, const char *tag, int id, _mssamm__SubtractResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__SubtractResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__SubtractResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamm__SubtractResponse(struct soap *soap, const char *tag, _mssamm__SubtractResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__SubtractResponse **)soap_malloc(soap, sizeof(_mssamm__SubtractResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__SubtractResponse *)soap_instantiate__mssamm__SubtractResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__SubtractResponse ** p = (_mssamm__SubtractResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__SubtractResponse, sizeof(_mssamm__SubtractResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__SubtractResponse(struct soap *soap, _mssamm__SubtractResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__SubtractResponse);
	if (soap_out_PointerTo_mssamm__SubtractResponse(soap, tag?tag:"mssamm:SubtractResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__SubtractResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamm__SubtractResponse(struct soap *soap, _mssamm__SubtractResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__SubtractResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__Subtract(struct soap *soap, _mssamm__Subtract *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__Subtract))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__Subtract(struct soap *soap, const char *tag, int id, _mssamm__Subtract *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__Subtract);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__Subtract ** SOAP_FMAC4 soap_in_PointerTo_mssamm__Subtract(struct soap *soap, const char *tag, _mssamm__Subtract **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__Subtract **)soap_malloc(soap, sizeof(_mssamm__Subtract *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__Subtract *)soap_instantiate__mssamm__Subtract(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__Subtract ** p = (_mssamm__Subtract **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__Subtract, sizeof(_mssamm__Subtract), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__Subtract(struct soap *soap, _mssamm__Subtract *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__Subtract);
	if (soap_out_PointerTo_mssamm__Subtract(soap, tag?tag:"mssamm:Subtract", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__Subtract ** SOAP_FMAC4 soap_get_PointerTo_mssamm__Subtract(struct soap *soap, _mssamm__Subtract **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__AddResponse(struct soap *soap, _mssamm__AddResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__AddResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__AddResponse(struct soap *soap, const char *tag, int id, _mssamm__AddResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__AddResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__AddResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamm__AddResponse(struct soap *soap, const char *tag, _mssamm__AddResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__AddResponse **)soap_malloc(soap, sizeof(_mssamm__AddResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__AddResponse *)soap_instantiate__mssamm__AddResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__AddResponse ** p = (_mssamm__AddResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__AddResponse, sizeof(_mssamm__AddResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__AddResponse(struct soap *soap, _mssamm__AddResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__AddResponse);
	if (soap_out_PointerTo_mssamm__AddResponse(soap, tag?tag:"mssamm:AddResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__AddResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamm__AddResponse(struct soap *soap, _mssamm__AddResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__AddResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamm__Add(struct soap *soap, _mssamm__Add *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamm__Add))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamm__Add(struct soap *soap, const char *tag, int id, _mssamm__Add *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamm__Add);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamm__Add ** SOAP_FMAC4 soap_in_PointerTo_mssamm__Add(struct soap *soap, const char *tag, _mssamm__Add **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamm__Add **)soap_malloc(soap, sizeof(_mssamm__Add *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamm__Add *)soap_instantiate__mssamm__Add(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamm__Add ** p = (_mssamm__Add **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamm__Add, sizeof(_mssamm__Add), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamm__Add(struct soap *soap, _mssamm__Add *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamm__Add);
	if (soap_out_PointerTo_mssamm__Add(soap, tag?tag:"mssamm:Add", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamm__Add ** SOAP_FMAC4 soap_get_PointerTo_mssamm__Add(struct soap *soap, _mssamm__Add **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamm__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap *soap, double *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap *soap, const char *tag, int id, double *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_double);
	if (id < 0)
		return soap->error;
	return soap_out_double(soap, tag, id, *a, type);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap *soap, const char *tag, double **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (double **)soap_malloc(soap, sizeof(double *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_double(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (double **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_double, sizeof(double), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap *soap, double *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTodouble);
	if (soap_out_PointerTodouble(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap *soap, double **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodouble(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE__QName);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_string);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
