/* soapC.cpp
   Generated by gSOAP 2.8.17r from calculator.h

Copyright(C) 2000-2014, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
GPL or Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.17r 2014-05-19 00:11:43 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->version && soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->version && soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (soap->header == NULL)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (soap->fault == NULL)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (soap->fault == NULL)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode == NULL)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Detail == NULL)
		{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
			soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
		}
		return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
	}
	if (soap->fault->detail == NULL)
	{	soap->fault->detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
	}
	return (const char**)&soap->fault->detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
#ifndef WITH_NOIDREF
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_PointerTo_mssamh__DivideResponse:
		return soap_in_PointerTo_mssamh__DivideResponse(soap, NULL, NULL, "mssamh:DivideResponse");
	case SOAP_TYPE_PointerTo_mssamh__Divide:
		return soap_in_PointerTo_mssamh__Divide(soap, NULL, NULL, "mssamh:Divide");
	case SOAP_TYPE_PointerTo_mssamh__MultiplyResponse:
		return soap_in_PointerTo_mssamh__MultiplyResponse(soap, NULL, NULL, "mssamh:MultiplyResponse");
	case SOAP_TYPE_PointerTo_mssamh__Multiply:
		return soap_in_PointerTo_mssamh__Multiply(soap, NULL, NULL, "mssamh:Multiply");
	case SOAP_TYPE_PointerTo_mssamh__SubtractResponse:
		return soap_in_PointerTo_mssamh__SubtractResponse(soap, NULL, NULL, "mssamh:SubtractResponse");
	case SOAP_TYPE_PointerTo_mssamh__Subtract:
		return soap_in_PointerTo_mssamh__Subtract(soap, NULL, NULL, "mssamh:Subtract");
	case SOAP_TYPE_PointerTo_mssamh__AddResponse:
		return soap_in_PointerTo_mssamh__AddResponse(soap, NULL, NULL, "mssamh:AddResponse");
	case SOAP_TYPE_PointerTo_mssamh__Add:
		return soap_in_PointerTo_mssamh__Add(soap, NULL, NULL, "mssamh:Add");
	case SOAP_TYPE_PointerTodouble:
		return soap_in_PointerTodouble(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
#else
	*type = 0;
#endif
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "mssamh:DivideResponse"))
		{	*type = SOAP_TYPE__mssamh__DivideResponse;
			return soap_in__mssamh__DivideResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:Divide"))
		{	*type = SOAP_TYPE__mssamh__Divide;
			return soap_in__mssamh__Divide(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:MultiplyResponse"))
		{	*type = SOAP_TYPE__mssamh__MultiplyResponse;
			return soap_in__mssamh__MultiplyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:Multiply"))
		{	*type = SOAP_TYPE__mssamh__Multiply;
			return soap_in__mssamh__Multiply(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:SubtractResponse"))
		{	*type = SOAP_TYPE__mssamh__SubtractResponse;
			return soap_in__mssamh__SubtractResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:Subtract"))
		{	*type = SOAP_TYPE__mssamh__Subtract;
			return soap_in__mssamh__Subtract(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:AddResponse"))
		{	*type = SOAP_TYPE__mssamh__AddResponse;
			return soap_in__mssamh__AddResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamh:Add"))
		{	*type = SOAP_TYPE__mssamh__Add;
			return soap_in__mssamh__Add(soap, NULL, NULL, NULL);
		}
#ifndef WITH_NOIDREF
	}
#endif
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE__mssamh__DivideResponse:
		return ((_mssamh__DivideResponse *)ptr)->soap_out(soap, "mssamh:DivideResponse", id, NULL);
	case SOAP_TYPE__mssamh__Divide:
		return ((_mssamh__Divide *)ptr)->soap_out(soap, "mssamh:Divide", id, NULL);
	case SOAP_TYPE__mssamh__MultiplyResponse:
		return ((_mssamh__MultiplyResponse *)ptr)->soap_out(soap, "mssamh:MultiplyResponse", id, NULL);
	case SOAP_TYPE__mssamh__Multiply:
		return ((_mssamh__Multiply *)ptr)->soap_out(soap, "mssamh:Multiply", id, NULL);
	case SOAP_TYPE__mssamh__SubtractResponse:
		return ((_mssamh__SubtractResponse *)ptr)->soap_out(soap, "mssamh:SubtractResponse", id, NULL);
	case SOAP_TYPE__mssamh__Subtract:
		return ((_mssamh__Subtract *)ptr)->soap_out(soap, "mssamh:Subtract", id, NULL);
	case SOAP_TYPE__mssamh__AddResponse:
		return ((_mssamh__AddResponse *)ptr)->soap_out(soap, "mssamh:AddResponse", id, NULL);
	case SOAP_TYPE__mssamh__Add:
		return ((_mssamh__Add *)ptr)->soap_out(soap, "mssamh:Add", id, NULL);
	case SOAP_TYPE_PointerTo_mssamh__DivideResponse:
		return soap_out_PointerTo_mssamh__DivideResponse(soap, tag, id, (_mssamh__DivideResponse *const*)ptr, "mssamh:DivideResponse");
	case SOAP_TYPE_PointerTo_mssamh__Divide:
		return soap_out_PointerTo_mssamh__Divide(soap, tag, id, (_mssamh__Divide *const*)ptr, "mssamh:Divide");
	case SOAP_TYPE_PointerTo_mssamh__MultiplyResponse:
		return soap_out_PointerTo_mssamh__MultiplyResponse(soap, tag, id, (_mssamh__MultiplyResponse *const*)ptr, "mssamh:MultiplyResponse");
	case SOAP_TYPE_PointerTo_mssamh__Multiply:
		return soap_out_PointerTo_mssamh__Multiply(soap, tag, id, (_mssamh__Multiply *const*)ptr, "mssamh:Multiply");
	case SOAP_TYPE_PointerTo_mssamh__SubtractResponse:
		return soap_out_PointerTo_mssamh__SubtractResponse(soap, tag, id, (_mssamh__SubtractResponse *const*)ptr, "mssamh:SubtractResponse");
	case SOAP_TYPE_PointerTo_mssamh__Subtract:
		return soap_out_PointerTo_mssamh__Subtract(soap, tag, id, (_mssamh__Subtract *const*)ptr, "mssamh:Subtract");
	case SOAP_TYPE_PointerTo_mssamh__AddResponse:
		return soap_out_PointerTo_mssamh__AddResponse(soap, tag, id, (_mssamh__AddResponse *const*)ptr, "mssamh:AddResponse");
	case SOAP_TYPE_PointerTo_mssamh__Add:
		return soap_out_PointerTo_mssamh__Add(soap, tag, id, (_mssamh__Add *const*)ptr, "mssamh:Add");
	case SOAP_TYPE_PointerTodouble:
		return soap_out_PointerTodouble(soap, tag, id, (double *const*)ptr, "xsd:double");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE__mssamh__DivideResponse:
		((_mssamh__DivideResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__Divide:
		((_mssamh__Divide *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__MultiplyResponse:
		((_mssamh__MultiplyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__Multiply:
		((_mssamh__Multiply *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__SubtractResponse:
		((_mssamh__SubtractResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__Subtract:
		((_mssamh__Subtract *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__AddResponse:
		((_mssamh__AddResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamh__Add:
		((_mssamh__Add *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___tempuri__Divide:
		soap_serialize___tempuri__Divide(soap, (const struct __tempuri__Divide *)ptr);
		break;
	case SOAP_TYPE___tempuri__Multiply:
		soap_serialize___tempuri__Multiply(soap, (const struct __tempuri__Multiply *)ptr);
		break;
	case SOAP_TYPE___tempuri__Subtract:
		soap_serialize___tempuri__Subtract(soap, (const struct __tempuri__Subtract *)ptr);
		break;
	case SOAP_TYPE___tempuri__Add:
		soap_serialize___tempuri__Add(soap, (const struct __tempuri__Add *)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__DivideResponse:
		soap_serialize_PointerTo_mssamh__DivideResponse(soap, (_mssamh__DivideResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__Divide:
		soap_serialize_PointerTo_mssamh__Divide(soap, (_mssamh__Divide *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__MultiplyResponse:
		soap_serialize_PointerTo_mssamh__MultiplyResponse(soap, (_mssamh__MultiplyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__Multiply:
		soap_serialize_PointerTo_mssamh__Multiply(soap, (_mssamh__Multiply *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__SubtractResponse:
		soap_serialize_PointerTo_mssamh__SubtractResponse(soap, (_mssamh__SubtractResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__Subtract:
		soap_serialize_PointerTo_mssamh__Subtract(soap, (_mssamh__Subtract *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__AddResponse:
		soap_serialize_PointerTo_mssamh__AddResponse(soap, (_mssamh__AddResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamh__Add:
		soap_serialize_PointerTo_mssamh__Add(soap, (_mssamh__Add *const*)ptr);
		break;
	case SOAP_TYPE_PointerTodouble:
		soap_serialize_PointerTodouble(soap, (double *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE__mssamh__Add:
		return (void*)soap_instantiate__mssamh__Add(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__AddResponse:
		return (void*)soap_instantiate__mssamh__AddResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__Subtract:
		return (void*)soap_instantiate__mssamh__Subtract(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__SubtractResponse:
		return (void*)soap_instantiate__mssamh__SubtractResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__Multiply:
		return (void*)soap_instantiate__mssamh__Multiply(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__MultiplyResponse:
		return (void*)soap_instantiate__mssamh__MultiplyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__Divide:
		return (void*)soap_instantiate__mssamh__Divide(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamh__DivideResponse:
		return (void*)soap_instantiate__mssamh__DivideResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Add:
		return (void*)soap_instantiate___tempuri__Add(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Subtract:
		return (void*)soap_instantiate___tempuri__Subtract(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Multiply:
		return (void*)soap_instantiate___tempuri__Multiply(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Divide:
		return (void*)soap_instantiate___tempuri__Divide(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE__mssamh__Add:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__Add*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__Add*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__AddResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__AddResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__AddResponse*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__Subtract:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__Subtract*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__Subtract*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__SubtractResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__SubtractResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__SubtractResponse*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__Multiply:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__Multiply*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__Multiply*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__MultiplyResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__MultiplyResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__MultiplyResponse*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__Divide:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__Divide*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__Divide*)p->ptr);
		break;
	case SOAP_TYPE__mssamh__DivideResponse:
		if (p->size < 0)
			SOAP_DELETE((_mssamh__DivideResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_mssamh__DivideResponse*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Add:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Add*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Add*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Subtract:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Subtract*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Subtract*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Multiply:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Multiply*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Multiply*)p->ptr);
		break;
	case SOAP_TYPE___tempuri__Divide:
		if (p->size < 0)
			SOAP_DELETE((struct __tempuri__Divide*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __tempuri__Divide*)p->ptr);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
		break;
#endif
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
	(void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
	switch (tt)
	{
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{	double *p;
	p = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamh__DivideResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__DivideResponse::DivideResult = NULL;
	/* transient soap skipped */
}

void _mssamh__DivideResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__DivideResponse::DivideResult);
	/* transient soap skipped */
#endif
}

int _mssamh__DivideResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__DivideResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__DivideResponse(struct soap *soap, const char *tag, int id, const _mssamh__DivideResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__DivideResponse), type))
		return soap->error;
	if (a->DivideResult)
		soap_element_result(soap, "mssamh:DivideResult");
	if (soap_out_PointerTodouble(soap, "mssamh:DivideResult", -1, &(a->_mssamh__DivideResponse::DivideResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__DivideResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__DivideResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__DivideResponse * SOAP_FMAC4 soap_in__mssamh__DivideResponse(struct soap *soap, const char *tag, _mssamh__DivideResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__DivideResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__DivideResponse, sizeof(_mssamh__DivideResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__DivideResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__DivideResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_DivideResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_DivideResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:DivideResult", &(a->_mssamh__DivideResponse::DivideResult), "xsd:double"))
				{	soap_flag_DivideResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamh:DivideResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__DivideResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__DivideResponse, 0, sizeof(_mssamh__DivideResponse), 0, soap_copy__mssamh__DivideResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__DivideResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__DivideResponse);
	if (this->soap_out(soap, tag?tag:"mssamh:DivideResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__DivideResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__DivideResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__DivideResponse * SOAP_FMAC4 soap_get__mssamh__DivideResponse(struct soap *soap, _mssamh__DivideResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__DivideResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__DivideResponse * SOAP_FMAC2 soap_instantiate__mssamh__DivideResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__DivideResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__DivideResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__DivideResponse);
		if (size)
			*size = sizeof(_mssamh__DivideResponse);
		((_mssamh__DivideResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__DivideResponse, n);
		if (size)
			*size = n * sizeof(_mssamh__DivideResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__DivideResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__DivideResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__DivideResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__DivideResponse %p -> %p\n", q, p));
	*(_mssamh__DivideResponse*)p = *(_mssamh__DivideResponse*)q;
}

void _mssamh__Divide::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__Divide::n1 = NULL;
	this->_mssamh__Divide::n2 = NULL;
	/* transient soap skipped */
}

void _mssamh__Divide::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Divide::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Divide::n2);
	/* transient soap skipped */
#endif
}

int _mssamh__Divide::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__Divide(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__Divide(struct soap *soap, const char *tag, int id, const _mssamh__Divide *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__Divide), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n1", -1, &(a->_mssamh__Divide::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n2", -1, &(a->_mssamh__Divide::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__Divide::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__Divide(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__Divide * SOAP_FMAC4 soap_in__mssamh__Divide(struct soap *soap, const char *tag, _mssamh__Divide *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__Divide *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__Divide, sizeof(_mssamh__Divide), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__Divide)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__Divide *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n1", &(a->_mssamh__Divide::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n2", &(a->_mssamh__Divide::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__Divide *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__Divide, 0, sizeof(_mssamh__Divide), 0, soap_copy__mssamh__Divide);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__Divide::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__Divide);
	if (this->soap_out(soap, tag?tag:"mssamh:Divide", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__Divide::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__Divide(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__Divide * SOAP_FMAC4 soap_get__mssamh__Divide(struct soap *soap, _mssamh__Divide *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__Divide * SOAP_FMAC2 soap_instantiate__mssamh__Divide(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__Divide(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__Divide, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__Divide);
		if (size)
			*size = sizeof(_mssamh__Divide);
		((_mssamh__Divide*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__Divide, n);
		if (size)
			*size = n * sizeof(_mssamh__Divide);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__Divide*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__Divide*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__Divide(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__Divide %p -> %p\n", q, p));
	*(_mssamh__Divide*)p = *(_mssamh__Divide*)q;
}

void _mssamh__MultiplyResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__MultiplyResponse::MultiplyResult = NULL;
	/* transient soap skipped */
}

void _mssamh__MultiplyResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__MultiplyResponse::MultiplyResult);
	/* transient soap skipped */
#endif
}

int _mssamh__MultiplyResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__MultiplyResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__MultiplyResponse(struct soap *soap, const char *tag, int id, const _mssamh__MultiplyResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__MultiplyResponse), type))
		return soap->error;
	if (a->MultiplyResult)
		soap_element_result(soap, "mssamh:MultiplyResult");
	if (soap_out_PointerTodouble(soap, "mssamh:MultiplyResult", -1, &(a->_mssamh__MultiplyResponse::MultiplyResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__MultiplyResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__MultiplyResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__MultiplyResponse * SOAP_FMAC4 soap_in__mssamh__MultiplyResponse(struct soap *soap, const char *tag, _mssamh__MultiplyResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__MultiplyResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__MultiplyResponse, sizeof(_mssamh__MultiplyResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__MultiplyResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__MultiplyResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_MultiplyResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MultiplyResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:MultiplyResult", &(a->_mssamh__MultiplyResponse::MultiplyResult), "xsd:double"))
				{	soap_flag_MultiplyResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamh:MultiplyResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__MultiplyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__MultiplyResponse, 0, sizeof(_mssamh__MultiplyResponse), 0, soap_copy__mssamh__MultiplyResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__MultiplyResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__MultiplyResponse);
	if (this->soap_out(soap, tag?tag:"mssamh:MultiplyResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__MultiplyResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__MultiplyResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__MultiplyResponse * SOAP_FMAC4 soap_get__mssamh__MultiplyResponse(struct soap *soap, _mssamh__MultiplyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__MultiplyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__MultiplyResponse * SOAP_FMAC2 soap_instantiate__mssamh__MultiplyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__MultiplyResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__MultiplyResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__MultiplyResponse);
		if (size)
			*size = sizeof(_mssamh__MultiplyResponse);
		((_mssamh__MultiplyResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__MultiplyResponse, n);
		if (size)
			*size = n * sizeof(_mssamh__MultiplyResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__MultiplyResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__MultiplyResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__MultiplyResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__MultiplyResponse %p -> %p\n", q, p));
	*(_mssamh__MultiplyResponse*)p = *(_mssamh__MultiplyResponse*)q;
}

void _mssamh__Multiply::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__Multiply::n1 = NULL;
	this->_mssamh__Multiply::n2 = NULL;
	/* transient soap skipped */
}

void _mssamh__Multiply::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Multiply::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Multiply::n2);
	/* transient soap skipped */
#endif
}

int _mssamh__Multiply::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__Multiply(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__Multiply(struct soap *soap, const char *tag, int id, const _mssamh__Multiply *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__Multiply), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n1", -1, &(a->_mssamh__Multiply::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n2", -1, &(a->_mssamh__Multiply::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__Multiply::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__Multiply(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__Multiply * SOAP_FMAC4 soap_in__mssamh__Multiply(struct soap *soap, const char *tag, _mssamh__Multiply *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__Multiply *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__Multiply, sizeof(_mssamh__Multiply), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__Multiply)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__Multiply *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n1", &(a->_mssamh__Multiply::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n2", &(a->_mssamh__Multiply::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__Multiply *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__Multiply, 0, sizeof(_mssamh__Multiply), 0, soap_copy__mssamh__Multiply);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__Multiply::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__Multiply);
	if (this->soap_out(soap, tag?tag:"mssamh:Multiply", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__Multiply::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__Multiply(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__Multiply * SOAP_FMAC4 soap_get__mssamh__Multiply(struct soap *soap, _mssamh__Multiply *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__Multiply * SOAP_FMAC2 soap_instantiate__mssamh__Multiply(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__Multiply(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__Multiply, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__Multiply);
		if (size)
			*size = sizeof(_mssamh__Multiply);
		((_mssamh__Multiply*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__Multiply, n);
		if (size)
			*size = n * sizeof(_mssamh__Multiply);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__Multiply*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__Multiply*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__Multiply(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__Multiply %p -> %p\n", q, p));
	*(_mssamh__Multiply*)p = *(_mssamh__Multiply*)q;
}

void _mssamh__SubtractResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__SubtractResponse::SubtractResult = NULL;
	/* transient soap skipped */
}

void _mssamh__SubtractResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__SubtractResponse::SubtractResult);
	/* transient soap skipped */
#endif
}

int _mssamh__SubtractResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__SubtractResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__SubtractResponse(struct soap *soap, const char *tag, int id, const _mssamh__SubtractResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__SubtractResponse), type))
		return soap->error;
	if (a->SubtractResult)
		soap_element_result(soap, "mssamh:SubtractResult");
	if (soap_out_PointerTodouble(soap, "mssamh:SubtractResult", -1, &(a->_mssamh__SubtractResponse::SubtractResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__SubtractResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__SubtractResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__SubtractResponse * SOAP_FMAC4 soap_in__mssamh__SubtractResponse(struct soap *soap, const char *tag, _mssamh__SubtractResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__SubtractResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__SubtractResponse, sizeof(_mssamh__SubtractResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__SubtractResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__SubtractResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_SubtractResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SubtractResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:SubtractResult", &(a->_mssamh__SubtractResponse::SubtractResult), "xsd:double"))
				{	soap_flag_SubtractResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamh:SubtractResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__SubtractResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__SubtractResponse, 0, sizeof(_mssamh__SubtractResponse), 0, soap_copy__mssamh__SubtractResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__SubtractResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__SubtractResponse);
	if (this->soap_out(soap, tag?tag:"mssamh:SubtractResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__SubtractResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__SubtractResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__SubtractResponse * SOAP_FMAC4 soap_get__mssamh__SubtractResponse(struct soap *soap, _mssamh__SubtractResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__SubtractResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__SubtractResponse * SOAP_FMAC2 soap_instantiate__mssamh__SubtractResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__SubtractResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__SubtractResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__SubtractResponse);
		if (size)
			*size = sizeof(_mssamh__SubtractResponse);
		((_mssamh__SubtractResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__SubtractResponse, n);
		if (size)
			*size = n * sizeof(_mssamh__SubtractResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__SubtractResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__SubtractResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__SubtractResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__SubtractResponse %p -> %p\n", q, p));
	*(_mssamh__SubtractResponse*)p = *(_mssamh__SubtractResponse*)q;
}

void _mssamh__Subtract::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__Subtract::n1 = NULL;
	this->_mssamh__Subtract::n2 = NULL;
	/* transient soap skipped */
}

void _mssamh__Subtract::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Subtract::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Subtract::n2);
	/* transient soap skipped */
#endif
}

int _mssamh__Subtract::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__Subtract(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__Subtract(struct soap *soap, const char *tag, int id, const _mssamh__Subtract *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__Subtract), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n1", -1, &(a->_mssamh__Subtract::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n2", -1, &(a->_mssamh__Subtract::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__Subtract::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__Subtract(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__Subtract * SOAP_FMAC4 soap_in__mssamh__Subtract(struct soap *soap, const char *tag, _mssamh__Subtract *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__Subtract *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__Subtract, sizeof(_mssamh__Subtract), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__Subtract)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__Subtract *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n1", &(a->_mssamh__Subtract::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n2", &(a->_mssamh__Subtract::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__Subtract *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__Subtract, 0, sizeof(_mssamh__Subtract), 0, soap_copy__mssamh__Subtract);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__Subtract::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__Subtract);
	if (this->soap_out(soap, tag?tag:"mssamh:Subtract", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__Subtract::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__Subtract(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__Subtract * SOAP_FMAC4 soap_get__mssamh__Subtract(struct soap *soap, _mssamh__Subtract *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__Subtract * SOAP_FMAC2 soap_instantiate__mssamh__Subtract(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__Subtract(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__Subtract, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__Subtract);
		if (size)
			*size = sizeof(_mssamh__Subtract);
		((_mssamh__Subtract*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__Subtract, n);
		if (size)
			*size = n * sizeof(_mssamh__Subtract);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__Subtract*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__Subtract*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__Subtract(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__Subtract %p -> %p\n", q, p));
	*(_mssamh__Subtract*)p = *(_mssamh__Subtract*)q;
}

void _mssamh__AddResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__AddResponse::AddResult = NULL;
	/* transient soap skipped */
}

void _mssamh__AddResponse::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__AddResponse::AddResult);
	/* transient soap skipped */
#endif
}

int _mssamh__AddResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__AddResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__AddResponse(struct soap *soap, const char *tag, int id, const _mssamh__AddResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__AddResponse), type))
		return soap->error;
	if (a->AddResult)
		soap_element_result(soap, "mssamh:AddResult");
	if (soap_out_PointerTodouble(soap, "mssamh:AddResult", -1, &(a->_mssamh__AddResponse::AddResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__AddResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__AddResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__AddResponse * SOAP_FMAC4 soap_in__mssamh__AddResponse(struct soap *soap, const char *tag, _mssamh__AddResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__AddResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__AddResponse, sizeof(_mssamh__AddResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__AddResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__AddResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_AddResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AddResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:AddResult", &(a->_mssamh__AddResponse::AddResult), "xsd:double"))
				{	soap_flag_AddResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "mssamh:AddResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__AddResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__AddResponse, 0, sizeof(_mssamh__AddResponse), 0, soap_copy__mssamh__AddResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__AddResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__AddResponse);
	if (this->soap_out(soap, tag?tag:"mssamh:AddResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__AddResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__AddResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__AddResponse * SOAP_FMAC4 soap_get__mssamh__AddResponse(struct soap *soap, _mssamh__AddResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__AddResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__AddResponse * SOAP_FMAC2 soap_instantiate__mssamh__AddResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__AddResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__AddResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__AddResponse);
		if (size)
			*size = sizeof(_mssamh__AddResponse);
		((_mssamh__AddResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__AddResponse, n);
		if (size)
			*size = n * sizeof(_mssamh__AddResponse);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__AddResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__AddResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__AddResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__AddResponse %p -> %p\n", q, p));
	*(_mssamh__AddResponse*)p = *(_mssamh__AddResponse*)q;
}

void _mssamh__Add::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamh__Add::n1 = NULL;
	this->_mssamh__Add::n2 = NULL;
	/* transient soap skipped */
}

void _mssamh__Add::soap_serialize(struct soap *soap) const
{
#ifndef WITH_NOIDREF
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Add::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamh__Add::n2);
	/* transient soap skipped */
#endif
}

int _mssamh__Add::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamh__Add(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamh__Add(struct soap *soap, const char *tag, int id, const _mssamh__Add *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamh__Add), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n1", -1, &(a->_mssamh__Add::n1), ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamh:n2", -1, &(a->_mssamh__Add::n2), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_mssamh__Add::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamh__Add(soap, tag, this, type);
}

SOAP_FMAC3 _mssamh__Add * SOAP_FMAC4 soap_in__mssamh__Add(struct soap *soap, const char *tag, _mssamh__Add *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamh__Add *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__mssamh__Add, sizeof(_mssamh__Add), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__mssamh__Add)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_mssamh__Add *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n1", &(a->_mssamh__Add::n1), "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTodouble(soap, "mssamh:n2", &(a->_mssamh__Add::n2), "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamh__Add *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamh__Add, 0, sizeof(_mssamh__Add), 0, soap_copy__mssamh__Add);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _mssamh__Add::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__mssamh__Add);
	if (this->soap_out(soap, tag?tag:"mssamh:Add", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamh__Add::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamh__Add(soap, this, tag, type);
}

SOAP_FMAC3 _mssamh__Add * SOAP_FMAC4 soap_get__mssamh__Add(struct soap *soap, _mssamh__Add *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamh__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _mssamh__Add * SOAP_FMAC2 soap_instantiate__mssamh__Add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamh__Add(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__mssamh__Add, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_mssamh__Add);
		if (size)
			*size = sizeof(_mssamh__Add);
		((_mssamh__Add*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(_mssamh__Add, n);
		if (size)
			*size = n * sizeof(_mssamh__Add);
		if (cp->ptr)
			for (int i = 0; i < n; i++)
				((_mssamh__Add*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (_mssamh__Add*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__mssamh__Add(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _mssamh__Add %p -> %p\n", q, p));
	*(_mssamh__Add*)p = *(_mssamh__Add*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Fault, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Reason, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Detail, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Code, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct SOAP_ENV__Header, n);
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Divide(struct soap *soap, struct __tempuri__Divide *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamh__Divide = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Divide(struct soap *soap, const struct __tempuri__Divide *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamh__Divide(soap, &a->mssamh__Divide);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Divide(struct soap *soap, const char *tag, int id, const struct __tempuri__Divide *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamh__Divide(soap, "mssamh:Divide", -1, &a->mssamh__Divide, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Divide * SOAP_FMAC4 soap_in___tempuri__Divide(struct soap *soap, const char *tag, struct __tempuri__Divide *a, const char *type)
{
	size_t soap_flag_mssamh__Divide = 1;
	short soap_flag;
	a = (struct __tempuri__Divide *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Divide, sizeof(struct __tempuri__Divide), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Divide(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamh__Divide && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamh__Divide(soap, "mssamh:Divide", &a->mssamh__Divide, ""))
				{	soap_flag_mssamh__Divide--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Divide(struct soap *soap, const struct __tempuri__Divide *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Divide(soap, tag?tag:"-tempuri:Divide", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Divide * SOAP_FMAC4 soap_get___tempuri__Divide(struct soap *soap, struct __tempuri__Divide *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Divide * SOAP_FMAC2 soap_instantiate___tempuri__Divide(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Divide(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Divide, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Divide);
		if (size)
			*size = sizeof(struct __tempuri__Divide);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Divide, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Divide);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Divide*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Divide(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Divide %p -> %p\n", q, p));
	*(struct __tempuri__Divide*)p = *(struct __tempuri__Divide*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Multiply(struct soap *soap, struct __tempuri__Multiply *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamh__Multiply = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Multiply(struct soap *soap, const struct __tempuri__Multiply *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamh__Multiply(soap, &a->mssamh__Multiply);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Multiply(struct soap *soap, const char *tag, int id, const struct __tempuri__Multiply *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamh__Multiply(soap, "mssamh:Multiply", -1, &a->mssamh__Multiply, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Multiply * SOAP_FMAC4 soap_in___tempuri__Multiply(struct soap *soap, const char *tag, struct __tempuri__Multiply *a, const char *type)
{
	size_t soap_flag_mssamh__Multiply = 1;
	short soap_flag;
	a = (struct __tempuri__Multiply *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Multiply, sizeof(struct __tempuri__Multiply), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Multiply(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamh__Multiply && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamh__Multiply(soap, "mssamh:Multiply", &a->mssamh__Multiply, ""))
				{	soap_flag_mssamh__Multiply--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Multiply(struct soap *soap, const struct __tempuri__Multiply *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Multiply(soap, tag?tag:"-tempuri:Multiply", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Multiply * SOAP_FMAC4 soap_get___tempuri__Multiply(struct soap *soap, struct __tempuri__Multiply *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Multiply * SOAP_FMAC2 soap_instantiate___tempuri__Multiply(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Multiply(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Multiply, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Multiply);
		if (size)
			*size = sizeof(struct __tempuri__Multiply);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Multiply, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Multiply);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Multiply*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Multiply(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Multiply %p -> %p\n", q, p));
	*(struct __tempuri__Multiply*)p = *(struct __tempuri__Multiply*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Subtract(struct soap *soap, struct __tempuri__Subtract *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamh__Subtract = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Subtract(struct soap *soap, const struct __tempuri__Subtract *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamh__Subtract(soap, &a->mssamh__Subtract);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Subtract(struct soap *soap, const char *tag, int id, const struct __tempuri__Subtract *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamh__Subtract(soap, "mssamh:Subtract", -1, &a->mssamh__Subtract, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Subtract * SOAP_FMAC4 soap_in___tempuri__Subtract(struct soap *soap, const char *tag, struct __tempuri__Subtract *a, const char *type)
{
	size_t soap_flag_mssamh__Subtract = 1;
	short soap_flag;
	a = (struct __tempuri__Subtract *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Subtract, sizeof(struct __tempuri__Subtract), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Subtract(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamh__Subtract && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamh__Subtract(soap, "mssamh:Subtract", &a->mssamh__Subtract, ""))
				{	soap_flag_mssamh__Subtract--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Subtract(struct soap *soap, const struct __tempuri__Subtract *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Subtract(soap, tag?tag:"-tempuri:Subtract", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Subtract * SOAP_FMAC4 soap_get___tempuri__Subtract(struct soap *soap, struct __tempuri__Subtract *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Subtract * SOAP_FMAC2 soap_instantiate___tempuri__Subtract(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Subtract(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Subtract, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Subtract);
		if (size)
			*size = sizeof(struct __tempuri__Subtract);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Subtract, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Subtract);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Subtract*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Subtract(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Subtract %p -> %p\n", q, p));
	*(struct __tempuri__Subtract*)p = *(struct __tempuri__Subtract*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Add(struct soap *soap, struct __tempuri__Add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamh__Add = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Add(struct soap *soap, const struct __tempuri__Add *a)
{
#ifndef WITH_NOIDREF
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_mssamh__Add(soap, &a->mssamh__Add);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Add(struct soap *soap, const char *tag, int id, const struct __tempuri__Add *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_mssamh__Add(soap, "mssamh:Add", -1, &a->mssamh__Add, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Add * SOAP_FMAC4 soap_in___tempuri__Add(struct soap *soap, const char *tag, struct __tempuri__Add *a, const char *type)
{
	size_t soap_flag_mssamh__Add = 1;
	short soap_flag;
	a = (struct __tempuri__Add *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Add, sizeof(struct __tempuri__Add), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Add(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamh__Add && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_mssamh__Add(soap, "mssamh:Add", &a->mssamh__Add, ""))
				{	soap_flag_mssamh__Add--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Add(struct soap *soap, const struct __tempuri__Add *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___tempuri__Add(soap, tag?tag:"-tempuri:Add", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Add * SOAP_FMAC4 soap_get___tempuri__Add(struct soap *soap, struct __tempuri__Add *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __tempuri__Add * SOAP_FMAC2 soap_instantiate___tempuri__Add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Add(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___tempuri__Add, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __tempuri__Add);
		if (size)
			*size = sizeof(struct __tempuri__Add);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW_ARRAY(struct __tempuri__Add, n);
		if (size)
			*size = n * sizeof(struct __tempuri__Add);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	if (!cp->ptr)
		soap->error = SOAP_EOM;
	return (struct __tempuri__Add*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___tempuri__Add(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __tempuri__Add %p -> %p\n", q, p));
	*(struct __tempuri__Add*)p = *(struct __tempuri__Add*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__DivideResponse(struct soap *soap, _mssamh__DivideResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__DivideResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__DivideResponse(struct soap *soap, const char *tag, int id, _mssamh__DivideResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__DivideResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__DivideResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamh__DivideResponse(struct soap *soap, const char *tag, _mssamh__DivideResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__DivideResponse **)soap_malloc(soap, sizeof(_mssamh__DivideResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__DivideResponse *)soap_instantiate__mssamh__DivideResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__DivideResponse ** p = (_mssamh__DivideResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__DivideResponse, sizeof(_mssamh__DivideResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__DivideResponse(struct soap *soap, _mssamh__DivideResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__DivideResponse);
	if (soap_out_PointerTo_mssamh__DivideResponse(soap, tag?tag:"mssamh:DivideResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__DivideResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamh__DivideResponse(struct soap *soap, _mssamh__DivideResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__DivideResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__Divide(struct soap *soap, _mssamh__Divide *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__Divide))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__Divide(struct soap *soap, const char *tag, int id, _mssamh__Divide *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__Divide);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__Divide ** SOAP_FMAC4 soap_in_PointerTo_mssamh__Divide(struct soap *soap, const char *tag, _mssamh__Divide **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__Divide **)soap_malloc(soap, sizeof(_mssamh__Divide *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__Divide *)soap_instantiate__mssamh__Divide(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__Divide ** p = (_mssamh__Divide **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__Divide, sizeof(_mssamh__Divide), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__Divide(struct soap *soap, _mssamh__Divide *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__Divide);
	if (soap_out_PointerTo_mssamh__Divide(soap, tag?tag:"mssamh:Divide", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__Divide ** SOAP_FMAC4 soap_get_PointerTo_mssamh__Divide(struct soap *soap, _mssamh__Divide **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__MultiplyResponse(struct soap *soap, _mssamh__MultiplyResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__MultiplyResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__MultiplyResponse(struct soap *soap, const char *tag, int id, _mssamh__MultiplyResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__MultiplyResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__MultiplyResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamh__MultiplyResponse(struct soap *soap, const char *tag, _mssamh__MultiplyResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__MultiplyResponse **)soap_malloc(soap, sizeof(_mssamh__MultiplyResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__MultiplyResponse *)soap_instantiate__mssamh__MultiplyResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__MultiplyResponse ** p = (_mssamh__MultiplyResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__MultiplyResponse, sizeof(_mssamh__MultiplyResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__MultiplyResponse(struct soap *soap, _mssamh__MultiplyResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__MultiplyResponse);
	if (soap_out_PointerTo_mssamh__MultiplyResponse(soap, tag?tag:"mssamh:MultiplyResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__MultiplyResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamh__MultiplyResponse(struct soap *soap, _mssamh__MultiplyResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__MultiplyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__Multiply(struct soap *soap, _mssamh__Multiply *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__Multiply))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__Multiply(struct soap *soap, const char *tag, int id, _mssamh__Multiply *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__Multiply);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__Multiply ** SOAP_FMAC4 soap_in_PointerTo_mssamh__Multiply(struct soap *soap, const char *tag, _mssamh__Multiply **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__Multiply **)soap_malloc(soap, sizeof(_mssamh__Multiply *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__Multiply *)soap_instantiate__mssamh__Multiply(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__Multiply ** p = (_mssamh__Multiply **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__Multiply, sizeof(_mssamh__Multiply), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__Multiply(struct soap *soap, _mssamh__Multiply *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__Multiply);
	if (soap_out_PointerTo_mssamh__Multiply(soap, tag?tag:"mssamh:Multiply", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__Multiply ** SOAP_FMAC4 soap_get_PointerTo_mssamh__Multiply(struct soap *soap, _mssamh__Multiply **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__SubtractResponse(struct soap *soap, _mssamh__SubtractResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__SubtractResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__SubtractResponse(struct soap *soap, const char *tag, int id, _mssamh__SubtractResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__SubtractResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__SubtractResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamh__SubtractResponse(struct soap *soap, const char *tag, _mssamh__SubtractResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__SubtractResponse **)soap_malloc(soap, sizeof(_mssamh__SubtractResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__SubtractResponse *)soap_instantiate__mssamh__SubtractResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__SubtractResponse ** p = (_mssamh__SubtractResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__SubtractResponse, sizeof(_mssamh__SubtractResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__SubtractResponse(struct soap *soap, _mssamh__SubtractResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__SubtractResponse);
	if (soap_out_PointerTo_mssamh__SubtractResponse(soap, tag?tag:"mssamh:SubtractResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__SubtractResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamh__SubtractResponse(struct soap *soap, _mssamh__SubtractResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__SubtractResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__Subtract(struct soap *soap, _mssamh__Subtract *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__Subtract))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__Subtract(struct soap *soap, const char *tag, int id, _mssamh__Subtract *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__Subtract);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__Subtract ** SOAP_FMAC4 soap_in_PointerTo_mssamh__Subtract(struct soap *soap, const char *tag, _mssamh__Subtract **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__Subtract **)soap_malloc(soap, sizeof(_mssamh__Subtract *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__Subtract *)soap_instantiate__mssamh__Subtract(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__Subtract ** p = (_mssamh__Subtract **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__Subtract, sizeof(_mssamh__Subtract), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__Subtract(struct soap *soap, _mssamh__Subtract *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__Subtract);
	if (soap_out_PointerTo_mssamh__Subtract(soap, tag?tag:"mssamh:Subtract", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__Subtract ** SOAP_FMAC4 soap_get_PointerTo_mssamh__Subtract(struct soap *soap, _mssamh__Subtract **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__AddResponse(struct soap *soap, _mssamh__AddResponse *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__AddResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__AddResponse(struct soap *soap, const char *tag, int id, _mssamh__AddResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__AddResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__AddResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamh__AddResponse(struct soap *soap, const char *tag, _mssamh__AddResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__AddResponse **)soap_malloc(soap, sizeof(_mssamh__AddResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__AddResponse *)soap_instantiate__mssamh__AddResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__AddResponse ** p = (_mssamh__AddResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__AddResponse, sizeof(_mssamh__AddResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__AddResponse(struct soap *soap, _mssamh__AddResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__AddResponse);
	if (soap_out_PointerTo_mssamh__AddResponse(soap, tag?tag:"mssamh:AddResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__AddResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamh__AddResponse(struct soap *soap, _mssamh__AddResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__AddResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamh__Add(struct soap *soap, _mssamh__Add *const*a)
{
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamh__Add))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamh__Add(struct soap *soap, const char *tag, int id, _mssamh__Add *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamh__Add);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _mssamh__Add ** SOAP_FMAC4 soap_in_PointerTo_mssamh__Add(struct soap *soap, const char *tag, _mssamh__Add **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamh__Add **)soap_malloc(soap, sizeof(_mssamh__Add *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamh__Add *)soap_instantiate__mssamh__Add(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_mssamh__Add ** p = (_mssamh__Add **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamh__Add, sizeof(_mssamh__Add), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamh__Add(struct soap *soap, _mssamh__Add *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_mssamh__Add);
	if (soap_out_PointerTo_mssamh__Add(soap, tag?tag:"mssamh:Add", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamh__Add ** SOAP_FMAC4 soap_get_PointerTo_mssamh__Add(struct soap *soap, _mssamh__Add **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamh__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap *soap, double *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap *soap, const char *tag, int id, double *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_double);
	if (id < 0)
		return soap->error;
	return soap_out_double(soap, tag, id, *a, type);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap *soap, const char *tag, double **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (double **)soap_malloc(soap, sizeof(double *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_double(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (double **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_double, sizeof(double), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap *soap, double *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTodouble);
	if (soap_out_PointerTodouble(soap, tag?tag:"double", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap *soap, double **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodouble(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE__QName);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
#ifndef WITH_NOIDREF
	soap_reference(soap, *a, SOAP_TYPE_string);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
