<?php
/**
 * EGroupware - Home - A simple portlet for displaying legacy home content
 *
 * @link www.egroupware.org
 * @author Nathan Gray
 * @copyright (c) 2013 by Nathan Gray
 * @package home
 * @subpackage portlet
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @version $Id$
 */

use EGroupware\Api;
use EGroupware\Api\Etemplate;

class home_legacy_portlet extends home_portlet
{

	/**
	 * Context for this portlet
	 */
	protected $context = array();

	/**
	 * Custom title from hook
	 */
	protected $title = 'Legacy';

	/**
	 * @var String Content generated by hook
	 */
	protected $content = '';

	public function __construct(array &$context = array(), &$need_reload = false)
	{
		unset($need_reload);	// not used, but required by function signature
		if (false) parent::__construct();

		$this->context = $context;

		// Try to load content here, so all needed info is available
		$appname = $this->context['app'];
		if(!$appname || !Api\Hooks::exists('home', $appname))
		{
			return;
		}
		// Set a fallback title for if we can't extract it
		$this->title = lang($this->context['app']);

		// Execute hook to get content
		ob_start();
		$_content = Api\Hooks::single('home',$appname);
		if (!$_content || $_content == 1)   // content has been echoed and not returned
		{
			$_content = ob_get_contents();
			ob_end_clean();
		}
		if($_content)
		{
			// Now we have to extract the actual content
			$dom = new DOMDocument();
			libxml_use_internal_errors(true);
			$dom->loadHTML($_content,LIBXML_NOWARNING + LIBXML_NOERROR);
			$finder = new DOMXPath($dom);

			// Find header for title
			$title = $finder->query("//div[contains(@class,'divSideboxHeader')]/descendant::strong");
			if($title->length)
			{
				$this->title = $title->item(0)->textContent;
			}

			// Remove header
			$content = $finder->query("//div[contains(@class,'divSideboxHeader')]/descendant::strong/ancestor::tr");
			for($i = 0; $i < $content->length; $i++)
			{
				$content->item($i)->parentNode->removeChild($content->item($i));
			}

			// Content remains
			$this->content = $dom->saveHTML();
		}
	}

	public function get_actions()
	{

	}

	/**
	 * Get a fragment of HTML for display
	 *
	 * @param id String unique ID, provided to the portlet so it can make sure content is
	 * 	unique, if needed.
	 * @return string HTML fragment for display
	 */
	public function exec($id = null, Etemplate &$etemplate = null)
	{
		$etemplate->read('home.legacy');

		$etemplate->set_dom_id($id);

		$etemplate->exec('home.home_link_portlet.exec',array('legacy' => $this->content), array(),array(),array(),2);
	}

	/**
	 * Some descriptive information about the portlet, so that users can decide if
	 * they want it or not, and for inclusion in lists, hover text, etc.
	 *
	 * These should be already translated, no further translation will be done.
	 *
	 * @return Array with keys
	 * - displayName: Used in lists
	 * - title: Put in the portlet header
	 * - description: A short description of what this portlet does or displays
	 */
	public function get_description()
	{
		return array(
			'displayName'=> 'Legacy portlet',
			'title'=>	$this->title,
			'description'=>	'Egroupware <= v1.9'
		);
	}
}
