/**
 * EGroupware - Notifications Java Desktop App
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package notifications
 * @subpackage jdesk
 * @link http://www.egroupware.org
 * @author Stefan Werfling <stefan.werfling@hw-softwareentwicklung.de>
 * @author Maik Hüttner <maik.huettner@hw-softwareentwicklung.de>
 */

/*
 * jegwPasswordDialog.java
 *
 * Created on 20.05.2009, 16:40:31
 */

package egroupwaretray;

import javax.swing.BorderFactory;

/**
 * jegwPasswordDialog
 * 
 * @author Stefan Werfling <stefan.werfling@hw-softwareentwicklung.de>
 */
public class jegwPasswordDialog extends javax.swing.JDialog {

    private String password		= "";
    private boolean savepass	= false;

    /** Creates new form jegwPasswordDialog */
    public jegwPasswordDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
		
		this.jLpassword.setText(jegwConst.getConstTag("egw_txt_title_password"));
		this.jBLogin.setText(jegwConst.getConstTag("egw_txt_title_login"));
		this.jPanelpassword.setBorder(
			BorderFactory.createTitledBorder(
				jegwConst.getConstTag("egw_msg_password_enter")));
		
		this.jBcancel.setText(jegwConst.getConstTag("egw_txt_cancel"));
		this.jCBpassword.setText(jegwConst.getConstTag("egw_txt_save_password"));
		this.setTitle(jegwConst.getConstTag("egw_txt_title_dialog_password"));
    }

    public String getPassword()
    {
        return this.password;
    }

    public boolean isSavePassword()
    {
        return this.savepass;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelpassword = new javax.swing.JPanel();
        jLaccount = new javax.swing.JLabel();
        jLhost = new javax.swing.JLabel();
        jLpassword = new javax.swing.JLabel();
        jPFpassword = new javax.swing.JPasswordField();
        jCBpassword = new javax.swing.JCheckBox();
        jBLogin = new javax.swing.JButton();
        jBcancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(egroupwaretray.EgroupwareTrayApp.class).getContext().getResourceMap(jegwPasswordDialog.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setName("Form"); // NOI18N

        jPanelpassword.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("jPanelpassword.border.border.title")))); // NOI18N
        jPanelpassword.setName("jPanelpassword"); // NOI18N

        jLaccount.setText(resourceMap.getString("jLaccount.text")); // NOI18N
        jLaccount.setName("jLaccount"); // NOI18N

        jLhost.setText(resourceMap.getString("jLhost.text")); // NOI18N
        jLhost.setName("jLhost"); // NOI18N

        jLpassword.setText(resourceMap.getString("jLpassword.text")); // NOI18N
        jLpassword.setName("jLpassword"); // NOI18N

        jPFpassword.setText(resourceMap.getString("jPFpassword.text")); // NOI18N
        jPFpassword.setName("jPFpassword"); // NOI18N

        jCBpassword.setText(resourceMap.getString("jCBpassword.text")); // NOI18N
        jCBpassword.setName("jCBpassword"); // NOI18N

        jBLogin.setText(resourceMap.getString("jBLogin.text")); // NOI18N
        jBLogin.setName("jBLogin"); // NOI18N
        jBLogin.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBLoginMouseClicked(evt);
            }
        });

        jBcancel.setText(resourceMap.getString("jBcancel.text")); // NOI18N
        jBcancel.setName("jBcancel"); // NOI18N
        jBcancel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBcancelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout jPanelpasswordLayout = new javax.swing.GroupLayout(jPanelpassword);
        jPanelpassword.setLayout(jPanelpasswordLayout);
        jPanelpasswordLayout.setHorizontalGroup(
            jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelpasswordLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLaccount, javax.swing.GroupLayout.PREFERRED_SIZE, 291, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLhost, javax.swing.GroupLayout.PREFERRED_SIZE, 281, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanelpasswordLayout.createSequentialGroup()
                        .addGroup(jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLpassword, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jCBpassword, javax.swing.GroupLayout.PREFERRED_SIZE, 129, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanelpasswordLayout.createSequentialGroup()
                                .addComponent(jBLogin, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jBcancel, javax.swing.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE))
                            .addComponent(jPFpassword, javax.swing.GroupLayout.DEFAULT_SIZE, 188, Short.MAX_VALUE))))
                .addGap(38, 38, 38))
        );
        jPanelpasswordLayout.setVerticalGroup(
            jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelpasswordLayout.createSequentialGroup()
                .addComponent(jLaccount)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLhost)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLpassword)
                    .addComponent(jPFpassword, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanelpasswordLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCBpassword)
                    .addComponent(jBLogin)
                    .addComponent(jBcancel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelpassword, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelpassword, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBcancelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jBcancelMouseClicked
        this.password = "";
        this.setVisible(false);
    }//GEN-LAST:event_jBcancelMouseClicked

    private void jBLoginMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jBLoginMouseClicked
        this.savepass = jCBpassword.getModel().isSelected();
        this.password = this.jPFpassword.getText();
        this.setVisible(false);
    }//GEN-LAST:event_jBLoginMouseClicked

    public void setUH(String User, String Host)
    {
        this.jLhost.setText(jegwConst.getConstTag("egw_txt_host") + " " + Host);
        this.jLaccount.setText(jegwConst.getConstTag("egw_txt_user") + " " + User);
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                jegwPasswordDialog dialog = new jegwPasswordDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBLogin;
    private javax.swing.JButton jBcancel;
    private javax.swing.JCheckBox jCBpassword;
    private javax.swing.JLabel jLaccount;
    private javax.swing.JLabel jLhost;
    private javax.swing.JLabel jLpassword;
    private javax.swing.JPasswordField jPFpassword;
    private javax.swing.JPanel jPanelpassword;
    // End of variables declaration//GEN-END:variables

}