/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.PreviewFrame;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.HTMLEscaper;
import com.gallery.GalleryRemote.util.ImageLoaderUtil;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SlideshowFrame
extends PreviewFrame
implements Runnable,
PreferenceNames,
CancellableTransferListener,
MouseMotionListener {
    public static final String MODULE = "SlideFrame";
    List pictures = null;
    List wantDownloaded = Collections.synchronizedList(new ArrayList());
    Picture userPicture = null;
    SlideshowPane slideshowPane;
    int wantIndex = -1;
    int sleepTime = 3000;
    int skipTime = 500;
    boolean running = false;
    boolean shutdown = false;
    long pictureShownTime = 0L;
    String caption = null;
    String progress = null;
    String extra = null;
    String url = null;
    String album = null;
    String skipping = null;
    public static final int STATE_NO_CHANGE = 0;
    public static final int STATE_PREPARING = 0;
    public static final int STATE_DOWNLOADING = 1;
    public static final int STATE_PROCESSING = 2;
    public static final int STATE_NEXTREADY = 3;
    public static final int STATE_SKIPPING = 4;
    public static final int STATE_SHOWING = 5;
    public static final int STATE_ERROR = 6;
    public static final int FEEDBACK_NONE = 0;
    public static final int FEEDBACK_HELP = 1;
    public static final int FEEDBACK_PREV = 2;
    public static final int FEEDBACK_NEXT = 4;
    public static final int FEEDBACK_PAUSE_PLAY = 8;
    public int dataTransferred = 0;
    public int dataOverall = 0;
    public int feedback = 0;
    public int state = 0;
    long feedbackUntil = 0L;
    long dontShowUntil = 0L;
    Thread feedbackThread = null;
    public static Cursor transparentCursor = null;
    int transitionDuration = -1;
    boolean enableTransitions;

    public SlideshowFrame() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.initComponents();
    }

    public void showSlideshow() {
        DialogUtil.maxSize(this);
        this.setVisible(true);
        Log.log(3, MODULE, "Showing slideshow frame");
        Frame mainFrame = GalleryRemote._().getMainFrame();
        if (mainFrame != null) {
            mainFrame.setVisible(false);
        }
    }

    public void hide() {
        Frame mainFrame;
        Log.log(3, MODULE, "Stopping slideshow");
        this.running = false;
        this.shutdown = true;
        if (!this.isShowing()) {
            return;
        }
        this.showCursor();
        super.hide();
        if (GalleryRemote._() != null && (mainFrame = GalleryRemote._().getMainFrame()) != null) {
            mainFrame.setVisible(true);
        }
        ImageUtils.deferredTasks();
    }

    public void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Log.log(3, SlideshowFrame.MODULE, "Got click");
                SlideshowFrame.this.nextAsync();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                Log.log(3, SlideshowFrame.MODULE, "Got wheel: " + e);
                if (e.getWheelRotation() > 0) {
                    SlideshowFrame.this.nextAsync();
                } else {
                    SlideshowFrame.this.previousAsync();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int vKey = e.getKeyCode();
                Log.log(3, SlideshowFrame.MODULE, "Got key: " + e);
                switch (vKey) {
                    case 27: {
                        SlideshowFrame.this.hide();
                        break;
                    }
                    case 37: 
                    case 38: {
                        SlideshowFrame.this.previousAsync();
                        break;
                    }
                    case 39: 
                    case 40: {
                        SlideshowFrame.this.nextAsync();
                        break;
                    }
                    case 72: {
                        SlideshowFrame.this.updateFeedback(1);
                        break;
                    }
                    case 32: {
                        if (SlideshowFrame.this.running) {
                            SlideshowFrame.this.running = false;
                        } else {
                            new Thread(SlideshowFrame.this).start();
                        }
                        SlideshowFrame.this.updateFeedback(8);
                        SlideshowFrame.this.updateProgress(SlideshowFrame.this.loader.pictureShowNow, 5, false);
                    }
                }
            }
        });
        this.addMouseMotionListener(this);
        this.slideshowPane = new SlideshowPane();
        this.setContentPane(this.slideshowPane);
        this.sleepTime = GalleryRemote._().properties.getIntProperty("slideshowDelay") * 1000;
        this.loader = new ImageLoaderUtil(5, this);
        this.loader.setTransferListener(this);
    }

    public void start(ArrayList pictures) {
        if (GalleryRemote._().properties.getBooleanProperty("slideshowRandom")) {
            this.pictures = new ArrayList(pictures);
            Collections.shuffle(this.pictures);
        } else {
            this.pictures = pictures;
        }
        if (this.sleepTime > 0) {
            new Thread(this).start();
        } else {
            this.next(false);
        }
        if (GalleryRemote._().properties.getBooleanProperty("slideshowPreloadAll")) {
            Thread t = new Thread(){

                public void run() {
                    Log.log(3, SlideshowFrame.MODULE, "Preload thread starting");
                    Iterator it = SlideshowFrame.this.pictures.iterator();
                    while (it.hasNext() && !SlideshowFrame.this.shutdown) {
                        Picture picture = (Picture)it.next();
                        Log.log(3, SlideshowFrame.MODULE, "Preloading " + picture);
                        ImageUtils.download(picture, SlideshowFrame.this.getRootPane().getSize(), GalleryRemote._().getCore().getMainStatusUpdate(), null);
                    }
                    Log.log(3, SlideshowFrame.MODULE, "Preload thread done");
                }
            };
            t.setPriority(1);
            t.start();
        }
    }

    public void run() {
        this.running = true;
        while (this.sleepTime > 0 && this.running && !this.shutdown) {
            if (!this.next(false)) {
                this.hide();
                break;
            }
            try {
                long sleep;
                while ((sleep = (long)this.sleepTime - (System.currentTimeMillis() - this.pictureShownTime)) > 0L) {
                    Thread.sleep(sleep);
                }
            }
            catch (InterruptedException e) {
                Log.logException(1, MODULE, e);
            }
        }
    }

    private void previousAsync() {
        new Thread(){

            public void run() {
                SlideshowFrame.this.updateFeedback(2);
                SlideshowFrame.this.previous(true);
            }
        }.start();
    }

    private void nextAsync() {
        new Thread(){

            public void run() {
                SlideshowFrame.this.updateFeedback(4);
                SlideshowFrame.this.next(true);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next(boolean user) {
        Picture picture;
        if (this.loader.pictureShowWant != null && this.wantDownloaded.contains(this.loader.pictureShowWant) && (this.loader.pictureShowWant != this.userPicture || user)) {
            this.wantDownloaded.remove(this.loader.pictureShowWant);
        }
        if (this.userPicture != null && !user) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return true;
        }
        SlideshowFrame e = this;
        synchronized (e) {
            if (this.userPicture != null && !user) {
                return true;
            }
            ++this.wantIndex;
            if (this.wantIndex >= this.pictures.size()) {
                if (GalleryRemote._().properties.getBooleanProperty("slideshowLoop")) {
                    this.wantIndex = 0;
                } else {
                    this.wantIndex = this.pictures.size() - 1;
                    return false;
                }
            }
            picture = (Picture)this.pictures.get(this.wantIndex);
            Log.log(3, MODULE, "Next picture: " + picture);
        }
        if (user) {
            this.userPicture = picture;
            this.updateProgress(picture, 4, false);
            Log.log(3, MODULE, "Skipping sleep");
            try {
                Thread.sleep(this.skipTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Log.log(3, MODULE, "Skipping wake");
            if (this.userPicture != picture) {
                Log.log(3, MODULE, "User skipped again, not even loading " + picture);
                return true;
            }
        }
        this.wantDownloaded.add(picture);
        this.updateProgress(picture, 0, false);
        this.loader.preparePicture(picture, false, true);
        if (this.wantIndex + 1 < this.pictures.size() && this.loader.images.get(picture = (Picture)this.pictures.get(this.wantIndex + 1)) == null) {
            this.wantDownloaded.add(picture);
            this.loader.imageLoader.loadPicture(picture, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous(boolean user) {
        Picture picture;
        if (this.loader.pictureShowWant != null && this.wantDownloaded.contains(this.loader.pictureShowWant) && (this.loader.pictureShowWant != this.userPicture || user)) {
            this.wantDownloaded.remove(this.loader.pictureShowWant);
        }
        SlideshowFrame slideshowFrame = this;
        synchronized (slideshowFrame) {
            --this.wantIndex;
            if (this.wantIndex < 0) {
                if (GalleryRemote._().properties.getBooleanProperty("slideshowLoop")) {
                    this.wantIndex = this.pictures.size() - 1;
                } else {
                    this.wantIndex = 0;
                    return false;
                }
            }
            picture = (Picture)this.pictures.get(this.wantIndex);
        }
        Log.log(3, MODULE, "Previous picture: " + picture);
        if (user) {
            this.userPicture = picture;
            this.updateProgress(picture, 4, false);
            try {
                Thread.sleep(this.skipTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.userPicture != picture) {
                Log.log(3, MODULE, "User skipped again, not even loading " + picture);
                return true;
            }
        } else if (this.userPicture != null && this.userPicture != picture) {
            return true;
        }
        this.wantDownloaded.add(picture);
        this.updateProgress(picture, 0, false);
        this.loader.preparePicture(picture, false, true);
        if (this.wantIndex - 1 > 0 && this.loader.images.get(picture = (Picture)this.pictures.get(this.wantIndex - 1)) == null) {
            this.wantDownloaded.add(picture);
            this.loader.imageLoader.loadPicture(picture, false);
        }
        return true;
    }

    public boolean blockPictureReady(Image image, Picture picture) {
        Log.log(3, MODULE, "blockPictureReady: " + picture + " - pictureShowWant: " + this.loader.pictureShowWant);
        if (picture == this.userPicture) {
            this.userPicture = null;
        }
        if (picture != this.loader.pictureShowWant) {
            Log.log(3, MODULE, "We wanted " + this.loader.pictureShowWant + ": ignoring");
            this.updateProgress(this.loader.pictureShowWant, 3, false);
            return true;
        }
        if (picture != null) {
            this.caption = picture.getCaption() != null ? ImageLoaderUtil.stripTags(HTMLEscaper.unescape(picture.getCaption())).trim() : null;
            this.extra = picture.getExtraFieldsString().trim();
            if (picture.isOnline()) {
                this.url = picture.safeGetUrlFull().toString();
                picture.getParentAlbum().getGallery().incrementViewCount(picture, GalleryRemote._().getCore().getMainStatusUpdate());
            } else {
                this.url = picture.getSource().toString();
            }
            this.album = picture.getParentAlbum().getCaption() != null ? ImageLoaderUtil.stripTags(HTMLEscaper.unescape(picture.getParentAlbum().getCaption())).trim() : null;
            this.updateProgress(picture, 5, true);
        }
        this.pictureShownTime = System.currentTimeMillis();
        return false;
    }

    public void pictureStartDownloading(Picture picture) {
        if (picture == this.loader.pictureShowWant || picture == this.userPicture) {
            this.updateProgress(picture, 1, false);
        }
    }

    public void pictureStartProcessing(Picture picture) {
        if (picture == this.loader.pictureShowWant || picture == this.userPicture) {
            this.updateProgress(picture, 2, false);
        }
    }

    public void pictureLoadError(Picture picture) {
        if (picture == this.loader.pictureShowWant || picture == this.userPicture) {
            this.updateProgress(picture, 6, false);
        }
        this.loader.reduceMemory();
    }

    private void updateProgress(Picture picture, int state, boolean repaintLater) {
        if (picture == null) {
            return;
        }
        Object[] params = new Object[]{picture.getName(), new Integer(this.pictures.indexOf(picture) + 1), new Integer(this.pictures.size())};
        switch (state) {
            case 5: {
                if (!this.running) {
                    this.progress = GRI18n.getString(MODULE, "paused", params);
                    break;
                }
                this.progress = GRI18n.getString(MODULE, "showing", params);
                break;
            }
            case 0: {
                this.progress = GRI18n.getString(MODULE, "preparing", params);
                break;
            }
            case 1: {
                this.progress = GRI18n.getString(MODULE, "downloading", params);
                break;
            }
            case 2: {
                this.progress = GRI18n.getString(MODULE, "processing", params);
                break;
            }
            case 3: {
                this.progress = GRI18n.getString(MODULE, "nextReady", params);
                break;
            }
            case 6: {
                this.progress = GRI18n.getString(MODULE, "error", params);
                break;
            }
            case 4: {
                this.progress = GRI18n.getString(MODULE, "skipping", params);
                this.skipping = GRI18n.getString(MODULE, "skippingController", params);
            }
        }
        Log.log(3, MODULE, "updateProgress: " + this.progress);
        if (!repaintLater) {
            this.repaint();
        }
        this.hideCursor();
    }

    public boolean dataTransferred(int transferred, int overall, double kbPerSecond, Picture p) {
        if (!this.wantDownloaded.contains(p) || this.shutdown) {
            return false;
        }
        this.dataTransferred = transferred;
        this.dataOverall = overall;
        if (transferred == overall) {
            this.repaint();
        } else {
            this.slideshowPane.paintProgress((Graphics2D)this.slideshowPane.getGraphics());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFeedback(int feedback) {
        if (feedback != 0) {
            this.feedbackUntil = System.currentTimeMillis() + (long)(feedback == 1 ? 6000 : 1500);
            SlideshowFrame slideshowFrame = this;
            synchronized (slideshowFrame) {
                if (this.feedbackThread == null) {
                    this.feedbackThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            boolean running = true;
                            while (running) {
                                try {
                                    Thread.sleep(SlideshowFrame.this.feedbackUntil - System.currentTimeMillis());
                                    7 var2_2 = this;
                                    synchronized (var2_2) {
                                        if (System.currentTimeMillis() >= SlideshowFrame.this.feedbackUntil) {
                                            running = false;
                                            SlideshowFrame.this.feedbackThread = null;
                                            SlideshowFrame.this.feedback = 0;
                                            SlideshowFrame.this.repaint();
                                        }
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                }
                            }
                        }
                    };
                    this.feedbackThread.start();
                }
            }
        }
        this.feedback = (this.feedback & 1) == 1 ? feedback | 1 : (feedback == 1 ? (this.feedback |= 1) : feedback);
        this.repaint();
    }

    public void hideCursor() {
        if (transparentCursor == null) {
            int[] pixels = new int[256];
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
            transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisiblecursor");
        }
        this.setCursor(transparentCursor);
    }

    public void showCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.showCursor();
    }

    public void initTransitionDuration() {
        boolean accelerated = ((Graphics2D)this.getGraphics()).getDeviceConfiguration().getImageCapabilities().isAccelerated();
        Log.log(3, MODULE, "Is graphics accelerated: " + accelerated);
        this.enableTransitions = accelerated || GalleryRemote._().properties.getBooleanProperty("unacceleratedTransition", false);
        int n = this.transitionDuration = this.enableTransitions ? GalleryRemote._().properties.getIntProperty("slideshowTransitionDuration", 3000) : 0;
        if (this.transitionDuration == 0) {
            this.enableTransitions = false;
        }
    }

    class SlideshowPane
    extends JPanel
    implements ActionListener {
        Color background = new Color(100, 100, 100, 150);
        Color normal = new Color(180, 180, 180, 180);
        Color hilight = new Color(255, 255, 255, 180);
        boolean firstPaint = true;
        BufferedImage feedbackCache = null;
        int cachedFeedback = 0;
        Point feedbackLocation = new Point();
        int feedbackWidth = 535;
        int feedbackHeight = 220;
        BufferedImage[] infoImage = new BufferedImage[5];
        String[] infoString = new String[5];
        Point[] infoLocation = new Point[5];
        BufferedImage[] previousInfoImage = new BufferedImage[5];
        Point[] previousInfoLocation = new Point[5];
        Image currentImage = null;
        Image currentImageSrc = null;
        Image previousImage = null;
        Rectangle previousRect = null;
        Timer timer = new Timer(16, this);
        long transitionStart = System.currentTimeMillis() - 5000L;
        float imageAlpha = 0.0f;
        int thickness = 1;

        SlideshowPane() {
        }

        public void actionPerformed(ActionEvent e) {
            long now = System.currentTimeMillis();
            if (now - this.transitionStart > (long)SlideshowFrame.this.transitionDuration) {
                this.timer.stop();
                this.imageAlpha = 1.0f;
                this.previousImage = null;
                for (int id = 0; id < this.previousInfoImage.length; ++id) {
                    if (this.previousInfoImage[id] != null) {
                        this.previousInfoImage[id].flush();
                    }
                    this.previousInfoImage[id] = null;
                }
            } else {
                this.imageAlpha = (float)(now - this.transitionStart) / (float)SlideshowFrame.this.transitionDuration;
            }
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.firstPaint) {
                this.firstPaint = false;
                ImageLoaderUtil.setSlideshowFont(this);
                SlideshowFrame.this.initTransitionDuration();
                int defaultThickness = this.getFont().getSize() / 7;
                this.thickness = GalleryRemote._().properties.getIntProperty("slideshowFontThickness", defaultThickness);
            }
            if (SlideshowFrame.this.feedback == 0 && SlideshowFrame.this.feedbackUntil <= System.currentTimeMillis()) {
                SlideshowFrame.this.skipping = null;
            }
            this.paintPicture(g2);
            this.paintInfo(g2);
            this.paintFeedback(g2);
            this.paintSkipping(g2);
            this.paintProgress(g2);
        }

        public void paintPicture(Graphics2D g) {
            Color c = GalleryRemote._().properties.getColorProperty("slideshowColor");
            if (c != null) {
                g.setColor(c);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (SlideshowFrame.this.loader.imageShowNow != null && SlideshowFrame.this.loader.pictureShowWant != null) {
                if (SlideshowFrame.this.loader.imageShowNow != this.currentImageSrc) {
                    Log.log(3, SlideshowFrame.MODULE, "New image: " + SlideshowFrame.this.loader.imageShowNow + " - " + this.currentImageSrc);
                    this.previousImage = this.currentImage;
                    this.previousRect = SlideshowFrame.this.currentRect;
                    this.currentImage = ImageUtils.rotateImage(SlideshowFrame.this.loader.imageShowNow, SlideshowFrame.this.loader.pictureShowWant.getAngle(), SlideshowFrame.this.loader.pictureShowWant.isFlipped(), this);
                    SlideshowFrame.this.currentRect = new Rectangle(this.getLocation().x + (this.getWidth() - this.currentImage.getWidth(this)) / 2, this.getLocation().y + (this.getHeight() - this.currentImage.getHeight(this)) / 2, this.currentImage.getWidth(this), this.currentImage.getHeight(this));
                    this.currentImageSrc = SlideshowFrame.this.loader.imageShowNow;
                    if (SlideshowFrame.this.enableTransitions) {
                        this.imageAlpha = 0.0f;
                        this.transitionStart = System.currentTimeMillis();
                        if (!this.timer.isRunning()) {
                            this.timer.start();
                        }
                    }
                }
                Composite composite = g.getComposite();
                if (this.imageAlpha != 1.0f && this.previousImage != null) {
                    g.setComposite(AlphaComposite.getInstance(3, 1.0f - this.imageAlpha));
                    g.drawImage(this.previousImage, this.previousRect.x, this.previousRect.y, SlideshowFrame.this.getContentPane());
                }
                if (this.imageAlpha != 0.0f) {
                    g.setComposite(AlphaComposite.getInstance(3, this.imageAlpha));
                    g.drawImage(this.currentImage, SlideshowFrame.this.currentRect.x, SlideshowFrame.this.currentRect.y, SlideshowFrame.this.getContentPane());
                }
                g.setComposite(composite);
            }
        }

        public void paintInfo(Graphics2D g) {
            PropertiesFile pf = GalleryRemote._().properties;
            this.paintInfo(g, 0, SlideshowFrame.this.caption, pf.getIntProperty("slideshowCaptionLocation"), true);
            this.paintInfo(g, 1, SlideshowFrame.this.progress, pf.getIntProperty("slideshowProgressLocation"), false);
            this.paintInfo(g, 2, SlideshowFrame.this.extra, pf.getIntProperty("slideshowExtraLocation"), true);
            this.paintInfo(g, 3, SlideshowFrame.this.url, pf.getIntProperty("slideshowUrlLocation"), true);
            this.paintInfo(g, 4, SlideshowFrame.this.album, pf.getIntProperty("slideshowAlbumLocation"), true);
        }

        public void paintFeedback(Graphics2D g) {
            if (SlideshowFrame.this.feedback == 0) {
                return;
            }
            if (this.feedbackCache == null || this.cachedFeedback != SlideshowFrame.this.feedback) {
                this.cachedFeedback = SlideshowFrame.this.feedback;
                Dimension d = this.getSize();
                this.feedbackLocation.x = d.width / 2 - this.feedbackWidth / 2;
                this.feedbackLocation.y = d.height / 3 * 2 - this.feedbackHeight / 2;
                int x = 30;
                int y = 20;
                if (this.feedbackCache != null) {
                    this.feedbackCache.flush();
                }
                this.feedbackCache = new BufferedImage(this.feedbackWidth + 60, this.feedbackHeight + 70, 2);
                Graphics2D gc = (Graphics2D)this.feedbackCache.getGraphics();
                gc.setFont(g.getFont().deriveFont(18.0f));
                FontMetrics fm = gc.getFontMetrics();
                gc.setColor(this.background);
                gc.fillRoundRect(0, 0, this.feedbackWidth, this.feedbackHeight + ((SlideshowFrame.this.feedback & 1) == 1 ? 0 : -30), 30, 30);
                gc.setColor(this.normal);
                gc.drawRoundRect(0, 0, this.feedbackWidth, this.feedbackHeight + ((SlideshowFrame.this.feedback & 1) == 1 ? 0 : -30), 30, 30);
                gc.setColor((SlideshowFrame.this.feedback & 2) == 2 ? this.hilight : this.normal);
                gc.fillPolygon(new int[]{x + 100, x + 100, x + 50, x + 50, x, x + 50, x + 50}, new int[]{y + 60, y + 90, y + 90, y + 125, y + 75, y + 25, y + 60}, 7);
                this.drawHelp(gc, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.left"));
                this.drawHelp(gc, this.hilight, fm, x + 107, y + 180, GRI18n.getString(SlideshowFrame.MODULE, "controller.mousewheel"));
                gc.setColor((SlideshowFrame.this.feedback & 4) == 4 ? this.hilight : this.normal);
                gc.fillPolygon(new int[]{x += 115, x, x + 50, x + 50, x + 100, x + 50, x + 50}, new int[]{y + 60, y + 90, y + 90, y + 125, y + 75, y + 25, y + 60}, 7);
                this.drawHelp(gc, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.right"));
                x += 130;
                gc.setColor((SlideshowFrame.this.feedback & 8) == 8 ? this.hilight : this.normal);
                if (SlideshowFrame.this.running) {
                    gc.fillPolygon(new int[]{x, x, x + 100}, new int[]{y + 10, y + 140, y + 75}, 3);
                } else {
                    gc.fillPolygon(new int[]{x, x, x + 30, x + 30}, new int[]{y + 10, y + 140, y + 140, y + 10}, 4);
                    gc.fillPolygon(new int[]{x + 70, x + 70, x + 100, x + 100}, new int[]{y + 10, y + 140, y + 140, y + 10}, 4);
                }
                this.drawHelp(gc, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.space"));
                gc.setColor(this.normal);
                gc.fillPolygon(new int[]{x += 130, x, x + 30, x + 70, x + 100, x + 100, x + 70, x + 30}, new int[]{y + 55, y + 95, y + 125, y + 125, y + 95, y + 55, y + 25, y + 25}, 8);
                this.drawHelp(gc, this.hilight, fm, x + 50, y + 160, GRI18n.getString(SlideshowFrame.MODULE, "controller.escape"));
            }
            g.drawImage((Image)this.feedbackCache, this.feedbackLocation.x, this.feedbackLocation.y, this);
        }

        public void paintSkipping(Graphics2D g) {
            if (SlideshowFrame.this.skipping != null) {
                Dimension d = this.getSize();
                int x = d.width / 2;
                int y = d.height / 3 * 2 - this.feedbackHeight / 2;
                g.setFont(this.getFont().deriveFont(48.0f));
                FontMetrics fm = g.getFontMetrics();
                g.setColor(this.hilight);
                Rectangle2D bounds = fm.getStringBounds(SlideshowFrame.this.skipping, g);
                g.drawString(SlideshowFrame.this.skipping, (int)((double)x - bounds.getWidth() / 2.0), y + ((SlideshowFrame.this.feedback & 1) == 1 ? 270 : 240));
            }
        }

        public void paintProgress(Graphics2D g) {
            if (SlideshowFrame.this.dataTransferred < SlideshowFrame.this.dataOverall) {
                g.setColor(Color.yellow);
                float r = (float)SlideshowFrame.this.dataTransferred / (float)SlideshowFrame.this.dataOverall;
                g.drawLine(0, 0, (int)((float)this.getWidth() * r), 0);
            }
        }

        public void paintInfo(Graphics2D g, int id, String text, int position, boolean transition) {
            if (position == 0) {
                return;
            }
            if (text == null) {
                text = "";
            }
            if (!text.equals(this.infoString[id])) {
                int y;
                int x;
                this.previousInfoImage[id] = this.infoImage[id];
                this.previousInfoLocation[id] = this.infoLocation[id];
                this.infoString[id] = text;
                Dimension d = this.getSize();
                g.setFont(this.getFont());
                int inset = 5;
                switch (position % 10) {
                    default: {
                        x = inset;
                        break;
                    }
                    case 0: {
                        x = d.width / 2;
                        break;
                    }
                    case 4: {
                        x = d.width - inset;
                    }
                }
                switch (position / 10) {
                    default: {
                        y = inset;
                        break;
                    }
                    case 2: {
                        y = d.height / 2;
                        break;
                    }
                    case 3: {
                        y = d.height - inset;
                    }
                }
                ImageLoaderUtil.WrapInfo wrapInfo = ImageLoaderUtil.wrap(g, text, d.width);
                this.infoImage[id] = new BufferedImage(wrapInfo.width + this.thickness * 2, wrapInfo.height + this.thickness * 2, 2);
                Graphics2D g2 = (Graphics2D)this.infoImage[id].getGraphics();
                g2.setFont(g.getFont());
                this.infoLocation[id] = ImageLoaderUtil.paintAlignedOutline((Graphics)g2, x, y, this.thickness, position, wrapInfo, true);
                Log.log(3, SlideshowFrame.MODULE, "Cached info " + id + " - " + text);
            }
            Composite composite = g.getComposite();
            if (transition && this.imageAlpha != 1.0f && this.previousInfoImage[id] != null) {
                g.setComposite(AlphaComposite.getInstance(3, 1.0f - this.imageAlpha));
                g.drawImage((Image)this.previousInfoImage[id], this.previousInfoLocation[id].x, this.previousInfoLocation[id].y, this);
            }
            g.setComposite(AlphaComposite.getInstance(3, transition ? this.imageAlpha : 1.0f));
            g.drawImage((Image)this.infoImage[id], this.infoLocation[id].x, this.infoLocation[id].y, this);
            g.setComposite(composite);
            if (this.imageAlpha >= 1.0f) {
                this.previousInfoImage[id] = this.infoImage[id];
                this.previousInfoLocation[id] = this.infoLocation[id];
            }
        }

        private void drawHelp(Graphics g, Color hilight, FontMetrics fm, int x, int y, String text) {
            if ((SlideshowFrame.this.feedback & 1) != 1) {
                return;
            }
            g.setColor(hilight);
            Rectangle2D bounds = fm.getStringBounds(text, g);
            g.drawString(text, (int)((double)x - bounds.getWidth() / 2.0), y);
        }
    }
}

