/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class Scroller
extends Canvas {
    private Image background;
    private Image buffer;
    private Image thumb;
    private Panorama panorama;
    private Dimension thumbSize;
    private int thumbPos;
    private int thumbMinPos;
    private int thumbMaxPos;

    public Scroller(Panorama panorama, Image image) {
        this.panorama = panorama;
        this.thumb = image;
    }

    public void init() {
        if (this.thumbSize != null) {
            this.thumbMinPos = this.thumbSize.width / 2 + 1;
            this.thumbMaxPos = this.size().width - this.thumbSize.width / 2 - 1;
            this.thumbPos = this.size().width / 2;
        }
    }

    public void reset() {
        this.thumbPos = this.size().width / 2;
        this.repaint();
    }

    public void set(int n) {
        this.thumbPos = Math.max(this.thumbMinPos, Math.min(this.thumbMaxPos, n));
        if (Math.abs(this.thumbPos - this.size().width / 2) <= 3) {
            this.thumbPos = this.size().width / 2;
        }
        this.repaint();
        if (this.panorama != null) {
            this.panorama.setAnimationOffset((this.thumbPos - this.size().width / 2) / 3);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.buffer == null) {
            this.buffer = this.createImage(n, n2);
        }
        if (this.background == null) {
            this.background = this.createImage(n, n2);
            graphics2 = this.background.getGraphics();
            if (((Metamorphose)this.getParent()).getBackgroundImage() != null) {
                graphics2.drawImage(((Metamorphose)this.getParent()).getBackgroundImage(), -this.location().x, -this.location().y, this);
                while ((this.checkImage(this.background, this) & 0x20) != 32) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                graphics2.setColor(this.getParent().getBackground());
                graphics2.fillRect(0, 0, n, n2);
            }
        }
        graphics2 = this.buffer.getGraphics();
        graphics2.drawImage(this.background, 0, 0, this);
        if (this.thumb != null) {
            if (this.thumbSize == null) {
                this.thumbSize = new Dimension(this.thumb.getWidth(this), this.thumb.getHeight(this));
                this.init();
            }
            graphics2.drawImage(this.thumb, this.thumbPos - this.thumbSize.width / 2, (n2 - this.thumbSize.height) / 2, this);
        }
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.set(n);
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (Math.abs(this.thumbPos - n) > 3) {
            this.set(n);
        }
        return true;
    }
}

