/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  4 13:50:38 EST 2014 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2c.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 32 -dif -name hc2cb_32 -include hc2cb.h */

/*
 * This function contains 434 FP additions, 260 FP multiplications,
 * (or, 236 additions, 62 multiplications, 198 fused multiply/add),
 * 137 stack variables, 7 constants, and 128 memory accesses
 */
#include "hc2cb.h"

static void hc2cb_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T5o, T5r, T5q, T5n, T5s, T5p;
	       {
		    E T5K, Tf, T8k, T7k, T8x, T7N, T3i, T1i, T3v, T2L, T5f, T4v, T6T, T6m, T52;
		    E T42, TZ, T6X, T3p, T1X, T8B, T8p, T3o, T26, T58, T4n, T7T, T7z, T59, T4k;
		    E T6p, T6a, TK, T6W, T8s, T8A, T2o, T3m, T3l, T2x, T55, T4g, T7S, T7G, T56;
		    E T4d, T6o, T61, T5Q, T5N, T6f, Tu, T8y, T7r, T8l, T7Q, T3w, T1F, T45, T48;
		    E T3j, T2O, T53, T4y, T62, T69;
		    {
			 E T6l, T6i, T40, T41;
			 {
			      E T12, T3, T6g, T2G, T2D, T6, T6h, T15, Td, T6k, T1g, T2J, Ta, T17, T1a;
			      E T6j;
			      {
				   E T4, T5, T13, T14;
				   {
					E T1, T2, T2E, T2F;
					T1 = Rp[0];
					T2 = Rm[WS(rs, 15)];
					T2E = Ip[0];
					T2F = Im[WS(rs, 15)];
					T4 = Rp[WS(rs, 8)];
					T12 = T1 - T2;
					T3 = T1 + T2;
					T6g = T2E - T2F;
					T2G = T2E + T2F;
					T5 = Rm[WS(rs, 7)];
				   }
				   T13 = Ip[WS(rs, 8)];
				   T14 = Im[WS(rs, 7)];
				   {
					E Tb, Tc, T1d, T1e;
					Tb = Rm[WS(rs, 3)];
					T2D = T4 - T5;
					T6 = T4 + T5;
					T6h = T13 - T14;
					T15 = T13 + T14;
					Tc = Rp[WS(rs, 12)];
					T1d = Ip[WS(rs, 12)];
					T1e = Im[WS(rs, 3)];
					{
					     E T8, T1c, T1f, T9, T18, T19;
					     T8 = Rp[WS(rs, 4)];
					     Td = Tb + Tc;
					     T1c = Tb - Tc;
					     T6k = T1d - T1e;
					     T1f = T1d + T1e;
					     T9 = Rm[WS(rs, 11)];
					     T18 = Ip[WS(rs, 4)];
					     T19 = Im[WS(rs, 11)];
					     T1g = T1c - T1f;
					     T2J = T1c + T1f;
					     Ta = T8 + T9;
					     T17 = T8 - T9;
					     T1a = T18 + T19;
					     T6j = T18 - T19;
					}
				   }
			      }
			      {
				   E T2I, T7M, T7L, T16, T1h, T4u, T4t, T2H, T2K;
				   {
					E T7i, T7, T1b, Te, T7j;
					T7i = T3 - T6;
					T7 = T3 + T6;
					T2I = T17 + T1a;
					T1b = T17 - T1a;
					Te = Ta + Td;
					T7M = Ta - Td;
					T7j = T6k - T6j;
					T6l = T6j + T6k;
					T6i = T6g + T6h;
					T7L = T6g - T6h;
					T5K = T7 - Te;
					Tf = T7 + Te;
					T8k = T7i + T7j;
					T7k = T7i - T7j;
					T40 = T12 + T15;
					T16 = T12 - T15;
					T1h = T1b + T1g;
					T4u = T1b - T1g;
				   }
				   T4t = T2G - T2D;
				   T2H = T2D + T2G;
				   T8x = T7M + T7L;
				   T7N = T7L - T7M;
				   T3i = FMA(KP707106781, T1h, T16);
				   T1i = FNMS(KP707106781, T1h, T16);
				   T2K = T2I - T2J;
				   T41 = T2I + T2J;
				   T3v = FMA(KP707106781, T2K, T2H);
				   T2L = FNMS(KP707106781, T2K, T2H);
				   T5f = FNMS(KP707106781, T4u, T4t);
				   T4v = FMA(KP707106781, T4u, T4t);
			      }
			 }
			 {
			      E T1Y, T1H, TR, T7w, T1K, T21, T65, T7t, TU, T66, T23, T1Q, T1R, TX, T67;
			      E T1U, TY, T7u;
			      {
				   E TL, TM, TO, TP, T63, T64;
				   TL = Rm[0];
				   T6T = T6i + T6l;
				   T6m = T6i - T6l;
				   T52 = FMA(KP707106781, T41, T40);
				   T42 = FNMS(KP707106781, T41, T40);
				   TM = Rp[WS(rs, 15)];
				   TO = Rp[WS(rs, 7)];
				   TP = Rm[WS(rs, 8)];
				   {
					E T1I, TN, TQ, T1J, T1Z, T20;
					T1I = Ip[WS(rs, 15)];
					T1Y = TL - TM;
					TN = TL + TM;
					T1H = TO - TP;
					TQ = TO + TP;
					T1J = Im[0];
					T1Z = Ip[WS(rs, 7)];
					T20 = Im[WS(rs, 8)];
					TR = TN + TQ;
					T7w = TN - TQ;
					T1K = T1I + T1J;
					T63 = T1I - T1J;
					T64 = T1Z - T20;
					T21 = T1Z + T20;
				   }
				   {
					E TV, T1M, T1P, TW, T1S, T1T;
					{
					     E TS, TT, T1N, T1O;
					     TS = Rp[WS(rs, 3)];
					     T65 = T63 + T64;
					     T7t = T63 - T64;
					     TT = Rm[WS(rs, 12)];
					     T1N = Ip[WS(rs, 3)];
					     T1O = Im[WS(rs, 12)];
					     TV = Rm[WS(rs, 4)];
					     T1M = TS - TT;
					     TU = TS + TT;
					     T66 = T1N - T1O;
					     T1P = T1N + T1O;
					     TW = Rp[WS(rs, 11)];
					     T1S = Ip[WS(rs, 11)];
					     T1T = Im[WS(rs, 4)];
					}
					T23 = T1M - T1P;
					T1Q = T1M + T1P;
					T1R = TV - TW;
					TX = TV + TW;
					T67 = T1S - T1T;
					T1U = T1S + T1T;
				   }
			      }
			      TY = TU + TX;
			      T7u = TU - TX;
			      {
				   E T7x, T68, T1V, T24;
				   T7x = T67 - T66;
				   T68 = T66 + T67;
				   T1V = T1R + T1U;
				   T24 = T1R - T1U;
				   {
					E T4l, T1L, T1W, T4j, T7v, T8n, T8o, T7y;
					T62 = TR - TY;
					TZ = TR + TY;
					T6X = T65 + T68;
					T69 = T65 - T68;
					T4l = T1H + T1K;
					T1L = T1H - T1K;
					T1W = T1Q - T1V;
					T4j = T1Q + T1V;
					T7v = T7t - T7u;
					T8n = T7u + T7t;
					T8o = T7w + T7x;
					T7y = T7w - T7x;
					{
					     E T4i, T22, T25, T4m;
					     T4i = T1Y + T21;
					     T22 = T1Y - T21;
					     T3p = FMA(KP707106781, T1W, T1L);
					     T1X = FNMS(KP707106781, T1W, T1L);
					     T8B = FMA(KP414213562, T8n, T8o);
					     T8p = FNMS(KP414213562, T8o, T8n);
					     T25 = T23 + T24;
					     T4m = T23 - T24;
					     T3o = FMA(KP707106781, T25, T22);
					     T26 = FNMS(KP707106781, T25, T22);
					     T58 = FMA(KP707106781, T4m, T4l);
					     T4n = FNMS(KP707106781, T4m, T4l);
					     T7T = FNMS(KP414213562, T7v, T7y);
					     T7z = FMA(KP414213562, T7y, T7v);
					     T59 = FMA(KP707106781, T4j, T4i);
					     T4k = FNMS(KP707106781, T4j, T4i);
					}
				   }
			      }
			 }
		    }
		    {
			 E T5T, T60, T4c, T4b;
			 {
			      E T2p, T28, T2b, T7D, TC, T2s, T7A, T5W, TF, T2j, T5X, T2i, TI, T2k, T2u;
			      E T2h;
			      {
				   E Tz, Ty, TA, Tw, Tx;
				   Tw = Rp[WS(rs, 1)];
				   Tx = Rm[WS(rs, 14)];
				   Tz = Rp[WS(rs, 9)];
				   T6p = T69 - T62;
				   T6a = T62 + T69;
				   Ty = Tw + Tx;
				   T2p = Tw - Tx;
				   TA = Rm[WS(rs, 6)];
				   {
					E T5U, T5V, T2d, T2g;
					{
					     E T2q, T2r, T29, T2a, TB;
					     T29 = Ip[WS(rs, 1)];
					     T2a = Im[WS(rs, 14)];
					     TB = Tz + TA;
					     T28 = Tz - TA;
					     T2q = Ip[WS(rs, 9)];
					     T5U = T29 - T2a;
					     T2b = T29 + T2a;
					     T2r = Im[WS(rs, 6)];
					     T7D = Ty - TB;
					     TC = Ty + TB;
					     T2s = T2q + T2r;
					     T5V = T2q - T2r;
					}
					{
					     E T2e, T2f, TD, TE, TG, TH;
					     TD = Rp[WS(rs, 5)];
					     TE = Rm[WS(rs, 10)];
					     T7A = T5U - T5V;
					     T5W = T5U + T5V;
					     T2e = Ip[WS(rs, 5)];
					     T2d = TD - TE;
					     TF = TD + TE;
					     T2f = Im[WS(rs, 10)];
					     TG = Rm[WS(rs, 2)];
					     TH = Rp[WS(rs, 13)];
					     T2j = Ip[WS(rs, 13)];
					     T5X = T2e - T2f;
					     T2g = T2e + T2f;
					     T2i = TG - TH;
					     TI = TG + TH;
					     T2k = Im[WS(rs, 2)];
					}
					T2u = T2d - T2g;
					T2h = T2d + T2g;
				   }
			      }
			      {
				   E TJ, T7B, T2l, T5Y;
				   TJ = TF + TI;
				   T7B = TF - TI;
				   T2l = T2j + T2k;
				   T5Y = T2j - T2k;
				   {
					E T4e, T2c, T2v, T8q, T7C, T7F, T8r, T2n, T7E, T2m, T5Z, T4f, T2t, T2w;
					T4e = T2b - T28;
					T2c = T28 + T2b;
					TK = TC + TJ;
					T5T = TC - TJ;
					T7E = T5Y - T5X;
					T5Z = T5X + T5Y;
					T2m = T2i + T2l;
					T2v = T2i - T2l;
					T60 = T5W - T5Z;
					T6W = T5W + T5Z;
					T8q = T7B + T7A;
					T7C = T7A - T7B;
					T7F = T7D - T7E;
					T8r = T7D + T7E;
					T2n = T2h - T2m;
					T4c = T2h + T2m;
					T4b = T2p + T2s;
					T2t = T2p - T2s;
					T2w = T2u + T2v;
					T4f = T2v - T2u;
					T8s = FMA(KP414213562, T8r, T8q);
					T8A = FNMS(KP414213562, T8q, T8r);
					T2o = FNMS(KP707106781, T2n, T2c);
					T3m = FMA(KP707106781, T2n, T2c);
					T3l = FMA(KP707106781, T2w, T2t);
					T2x = FNMS(KP707106781, T2w, T2t);
					T55 = FMA(KP707106781, T4f, T4e);
					T4g = FNMS(KP707106781, T4f, T4e);
					T7S = FMA(KP414213562, T7C, T7F);
					T7G = FNMS(KP414213562, T7F, T7C);
				   }
			      }
			 }
			 {
			      E T43, T1y, T7o, Tm, T7p, T44, T1D, Tq, T1o, Tp, T5L, T1m, Tr, T1p, T1q;
			      {
				   E Tj, T1z, Ti, T5O, T1x, Tk, T1A, T1B;
				   {
					E Tg, Th, T1v, T1w;
					Tg = Rp[WS(rs, 2)];
					T56 = FMA(KP707106781, T4c, T4b);
					T4d = FNMS(KP707106781, T4c, T4b);
					T6o = T5T + T60;
					T61 = T5T - T60;
					Th = Rm[WS(rs, 13)];
					T1v = Ip[WS(rs, 2)];
					T1w = Im[WS(rs, 13)];
					Tj = Rp[WS(rs, 10)];
					T1z = Tg - Th;
					Ti = Tg + Th;
					T5O = T1v - T1w;
					T1x = T1v + T1w;
					Tk = Rm[WS(rs, 5)];
					T1A = Ip[WS(rs, 10)];
					T1B = Im[WS(rs, 5)];
				   }
				   {
					E Tn, To, T1k, T1l;
					Tn = Rm[WS(rs, 1)];
					{
					     E T1u, Tl, T5P, T1C;
					     T1u = Tj - Tk;
					     Tl = Tj + Tk;
					     T5P = T1A - T1B;
					     T1C = T1A + T1B;
					     T43 = T1x - T1u;
					     T1y = T1u + T1x;
					     T7o = Ti - Tl;
					     Tm = Ti + Tl;
					     T5Q = T5O + T5P;
					     T7p = T5O - T5P;
					     T44 = T1z + T1C;
					     T1D = T1z - T1C;
					     To = Rp[WS(rs, 14)];
					}
					T1k = Ip[WS(rs, 14)];
					T1l = Im[WS(rs, 1)];
					Tq = Rp[WS(rs, 6)];
					T1o = Tn - To;
					Tp = Tn + To;
					T5L = T1k - T1l;
					T1m = T1k + T1l;
					Tr = Rm[WS(rs, 9)];
					T1p = Ip[WS(rs, 6)];
					T1q = Im[WS(rs, 9)];
				   }
			      }
			      {
				   E T46, T47, T7P, T7O, T2N, T1t, T1E, T2M, T4w, T4x;
				   {
					E T1n, Tt, T1s, T7n, T7q, T7m, T7l;
					{
					     E T1j, Ts, T5M, T1r;
					     T1j = Tq - Tr;
					     Ts = Tq + Tr;
					     T5M = T1p - T1q;
					     T1r = T1p + T1q;
					     T46 = T1j + T1m;
					     T1n = T1j - T1m;
					     T7m = Tp - Ts;
					     Tt = Tp + Ts;
					     T5N = T5L + T5M;
					     T7l = T5L - T5M;
					     T47 = T1o + T1r;
					     T1s = T1o - T1r;
					}
					T7P = T7m + T7l;
					T7n = T7l - T7m;
					T7q = T7o + T7p;
					T7O = T7o - T7p;
					T6f = Tm - Tt;
					Tu = Tm + Tt;
					T8y = T7q + T7n;
					T7r = T7n - T7q;
					T2N = FMA(KP414213562, T1n, T1s);
					T1t = FNMS(KP414213562, T1s, T1n);
					T1E = FMA(KP414213562, T1D, T1y);
					T2M = FNMS(KP414213562, T1y, T1D);
				   }
				   T8l = T7O + T7P;
				   T7Q = T7O - T7P;
				   T3w = T1E + T1t;
				   T1F = T1t - T1E;
				   T45 = FNMS(KP414213562, T44, T43);
				   T4w = FMA(KP414213562, T43, T44);
				   T4x = FMA(KP414213562, T46, T47);
				   T48 = FNMS(KP414213562, T47, T46);
				   T3j = T2M + T2N;
				   T2O = T2M - T2N;
				   T53 = T4w + T4x;
				   T4y = T4w - T4x;
			      }
			 }
		    }
		    {
			 E T72, T5g, T49, T78, T77, T73, T7s, T7U, T7R, T7H, T3f, T3e, T3d;
			 {
			      E T5R, T8m, T8C, T8z, T8t, T8e, T86, T88, T8h, T8f, T8i, T8c, T8g;
			      {
				   E T6P, T6Q, T6Z, T6S, T6R;
				   {
					E Tv, T10, T6V, T6Y, T6U;
					T72 = Tf - Tu;
					Tv = Tf + Tu;
					T6U = T5Q + T5N;
					T5R = T5N - T5Q;
					T5g = T48 - T45;
					T49 = T45 + T48;
					T10 = TK + TZ;
					T78 = TK - TZ;
					T77 = T6T - T6U;
					T6V = T6T + T6U;
					T6Y = T6W + T6X;
					T73 = T6X - T6W;
					T6P = W[30];
					Rp[0] = Tv + T10;
					T6Q = Tv - T10;
					Rm[0] = T6V + T6Y;
					T6Z = T6V - T6Y;
					T6S = W[31];
					T6R = T6P * T6Q;
				   }
				   {
					E T8O, T8W, T8Q, T8Z, T8X, T90, T8U, T8Y;
					{
					     E T8R, T8S, T8M, T8N, T70;
					     T8M = FMA(KP707106781, T8l, T8k);
					     T8m = FNMS(KP707106781, T8l, T8k);
					     T8C = T8A - T8B;
					     T8N = T8A + T8B;
					     T70 = T6S * T6Q;
					     Rp[WS(rs, 8)] = FNMS(T6S, T6Z, T6R);
					     T8R = FMA(KP707106781, T8y, T8x);
					     T8z = FNMS(KP707106781, T8y, T8x);
					     T8O = FNMS(KP923879532, T8N, T8M);
					     T8W = FMA(KP923879532, T8N, T8M);
					     Rm[WS(rs, 8)] = FMA(T6P, T6Z, T70);
					     T8S = T8s + T8p;
					     T8t = T8p - T8s;
					     {
						  E T8L, T8T, T8P, T8V;
						  T8L = W[34];
						  T8Q = W[35];
						  T8V = W[2];
						  T8Z = FMA(KP923879532, T8S, T8R);
						  T8T = FNMS(KP923879532, T8S, T8R);
						  T8P = T8L * T8O;
						  T8X = T8V * T8W;
						  T90 = T8V * T8Z;
						  T8U = T8L * T8T;
						  Rp[WS(rs, 9)] = FNMS(T8Q, T8T, T8P);
						  T8Y = W[3];
					     }
					}
					{
					     E T89, T8a, T84, T85;
					     T84 = FNMS(KP707106781, T7r, T7k);
					     T7s = FMA(KP707106781, T7r, T7k);
					     Rm[WS(rs, 9)] = FMA(T8Q, T8O, T8U);
					     T85 = T7S + T7T;
					     T7U = T7S - T7T;
					     Rm[WS(rs, 1)] = FMA(T8Y, T8W, T90);
					     Rp[WS(rs, 1)] = FNMS(T8Y, T8Z, T8X);
					     T7R = FMA(KP707106781, T7Q, T7N);
					     T89 = FNMS(KP707106781, T7Q, T7N);
					     T8e = FMA(KP923879532, T85, T84);
					     T86 = FNMS(KP923879532, T85, T84);
					     T8a = T7G + T7z;
					     T7H = T7z - T7G;
					     {
						  E T83, T8b, T87, T8d;
						  T83 = W[26];
						  T88 = W[27];
						  T8d = W[58];
						  T8h = FMA(KP923879532, T8a, T89);
						  T8b = FNMS(KP923879532, T8a, T89);
						  T87 = T83 * T86;
						  T8f = T8d * T8e;
						  T8i = T8d * T8h;
						  T8c = T83 * T8b;
						  Rp[WS(rs, 7)] = FNMS(T88, T8b, T87);
						  T8g = W[59];
					     }
					}
				   }
			      }
			      {
				   E T5S, T6q, T6n, T6K, T6C, T6b, T6E, T6N, T6L, T6O, T6I, T6M;
				   {
					E T6F, T6G, T6A, T6B;
					T6A = T5K - T5R;
					T5S = T5K + T5R;
					Rm[WS(rs, 7)] = FMA(T88, T86, T8c);
					T6B = T6p - T6o;
					T6q = T6o + T6p;
					Rm[WS(rs, 15)] = FMA(T8g, T8e, T8i);
					Rp[WS(rs, 15)] = FNMS(T8g, T8h, T8f);
					T6n = T6f + T6m;
					T6F = T6m - T6f;
					T6K = FMA(KP707106781, T6B, T6A);
					T6C = FNMS(KP707106781, T6B, T6A);
					T6G = T61 - T6a;
					T6b = T61 + T6a;
					{
					     E T6z, T6H, T6D, T6J;
					     T6z = W[54];
					     T6E = W[55];
					     T6J = W[22];
					     T6N = FMA(KP707106781, T6G, T6F);
					     T6H = FNMS(KP707106781, T6G, T6F);
					     T6D = T6z * T6C;
					     T6L = T6J * T6K;
					     T6O = T6J * T6N;
					     T6I = T6z * T6H;
					     Rp[WS(rs, 14)] = FNMS(T6E, T6H, T6D);
					     T6M = W[23];
					}
				   }
				   {
					E T8G, T8F, T8J, T8H, T8I, T8u;
					Rm[WS(rs, 14)] = FMA(T6E, T6C, T6I);
					Rm[WS(rs, 6)] = FMA(T6M, T6K, T6O);
					Rp[WS(rs, 6)] = FNMS(T6M, T6N, T6L);
					T8G = FMA(KP923879532, T8t, T8m);
					T8u = FNMS(KP923879532, T8t, T8m);
					{
					     E T8j, T8w, T8D, T8v, T8E;
					     T8j = W[50];
					     T8w = W[51];
					     T8F = W[18];
					     T8J = FMA(KP923879532, T8C, T8z);
					     T8D = FNMS(KP923879532, T8C, T8z);
					     T8v = T8j * T8u;
					     T8E = T8w * T8u;
					     T8H = T8F * T8G;
					     T8I = W[19];
					     Rp[WS(rs, 13)] = FNMS(T8w, T8D, T8v);
					     Rm[WS(rs, 13)] = FMA(T8j, T8D, T8E);
					}
					{
					     E T6c, T6u, T6x, T6r, T8K, T5J, T6e;
					     Rp[WS(rs, 5)] = FNMS(T8I, T8J, T8H);
					     T8K = T8I * T8G;
					     Rm[WS(rs, 5)] = FMA(T8F, T8J, T8K);
					     T6c = FNMS(KP707106781, T6b, T5S);
					     T6u = FMA(KP707106781, T6b, T5S);
					     T6x = FMA(KP707106781, T6q, T6n);
					     T6r = FNMS(KP707106781, T6q, T6n);
					     T5J = W[38];
					     T6e = W[39];
					     {
						  E T6t, T6w, T6d, T6s, T6v, T6y;
						  T6t = W[6];
						  T6w = W[7];
						  T6d = T5J * T6c;
						  T6s = T6e * T6c;
						  T6v = T6t * T6u;
						  T6y = T6w * T6u;
						  Rp[WS(rs, 10)] = FNMS(T6e, T6r, T6d);
						  Rm[WS(rs, 10)] = FMA(T5J, T6r, T6s);
						  Rp[WS(rs, 2)] = FNMS(T6w, T6x, T6v);
						  Rm[WS(rs, 2)] = FMA(T6t, T6x, T6y);
					     }
					}
				   }
			      }
			 }
			 {
			      E T7c, T7f, T7e, T7g, T7d;
			      {
				   E T71, T74, T79, T76, T75, T7b, T7a;
				   T71 = W[46];
				   T7c = T72 + T73;
				   T74 = T72 - T73;
				   T7f = T78 + T77;
				   T79 = T77 - T78;
				   T76 = W[47];
				   T75 = T71 * T74;
				   T7b = W[14];
				   T7a = T71 * T79;
				   T7e = W[15];
				   Rp[WS(rs, 12)] = FNMS(T76, T79, T75);
				   T7g = T7b * T7f;
				   T7d = T7b * T7c;
				   Rm[WS(rs, 12)] = FMA(T76, T74, T7a);
			      }
			      {
				   E T81, T7X, T80, T7Z, T82;
				   Rm[WS(rs, 4)] = FMA(T7e, T7c, T7g);
				   Rp[WS(rs, 4)] = FNMS(T7e, T7f, T7d);
				   {
					E T7h, T7Y, T7I, T7V, T7K, T7J, T7W;
					T7h = W[42];
					T7Y = FMA(KP923879532, T7H, T7s);
					T7I = FNMS(KP923879532, T7H, T7s);
					T81 = FMA(KP923879532, T7U, T7R);
					T7V = FNMS(KP923879532, T7U, T7R);
					T7K = W[43];
					T7J = T7h * T7I;
					T7X = W[10];
					T80 = W[11];
					T7W = T7K * T7I;
					Rp[WS(rs, 11)] = FNMS(T7K, T7V, T7J);
					T7Z = T7X * T7Y;
					T82 = T80 * T7Y;
					Rm[WS(rs, 11)] = FMA(T7h, T7V, T7W);
				   }
				   {
					E T2P, T37, T1G, T32, T2R, T2Q, T38, T2z, T27, T2y;
					T2P = FMA(KP923879532, T2O, T2L);
					T37 = FNMS(KP923879532, T2O, T2L);
					Rp[WS(rs, 3)] = FNMS(T80, T81, T7Z);
					Rm[WS(rs, 3)] = FMA(T7X, T81, T82);
					T1G = FMA(KP923879532, T1F, T1i);
					T32 = FNMS(KP923879532, T1F, T1i);
					T2R = FNMS(KP668178637, T1X, T26);
					T27 = FMA(KP668178637, T26, T1X);
					T2y = FNMS(KP668178637, T2x, T2o);
					T2Q = FMA(KP668178637, T2o, T2x);
					T38 = T2y + T27;
					T2z = T27 - T2y;
					{
					     E T2C, T2A, T3c, T34, T2U, T39, T36, T31;
					     {
						  E T11, T2W, T2S, T33;
						  T11 = W[40];
						  T2C = W[41];
						  T2A = FNMS(KP831469612, T2z, T1G);
						  T2W = FMA(KP831469612, T2z, T1G);
						  T2S = T2Q - T2R;
						  T33 = T2Q + T2R;
						  {
						       E T2V, T2B, T2T, T2Z, T2X, T2Y, T30;
						       T2V = W[8];
						       T2B = T11 * T2A;
						       T3c = FMA(KP831469612, T33, T32);
						       T34 = FNMS(KP831469612, T33, T32);
						       T2T = FNMS(KP831469612, T2S, T2P);
						       T2Z = FMA(KP831469612, T2S, T2P);
						       T2X = T2V * T2W;
						       T2Y = W[9];
						       T30 = T2V * T2Z;
						       Ip[WS(rs, 10)] = FNMS(T2C, T2T, T2B);
						       T2U = T11 * T2T;
						       Ip[WS(rs, 2)] = FNMS(T2Y, T2Z, T2X);
						       Im[WS(rs, 2)] = FMA(T2Y, T2W, T30);
						  }
					     }
					     T39 = FNMS(KP831469612, T38, T37);
					     T3f = FMA(KP831469612, T38, T37);
					     Im[WS(rs, 10)] = FMA(T2C, T2A, T2U);
					     T36 = W[25];
					     T31 = W[24];
					     {
						  E T3b, T3g, T3a, T35;
						  T3e = W[57];
						  T3a = T36 * T34;
						  T35 = T31 * T34;
						  T3b = W[56];
						  T3g = T3e * T3c;
						  Im[WS(rs, 6)] = FMA(T31, T39, T3a);
						  Ip[WS(rs, 6)] = FNMS(T36, T39, T35);
						  T3d = T3b * T3c;
						  Im[WS(rs, 14)] = FMA(T3b, T3f, T3g);
					     }
					}
				   }
			      }
			 }
			 {
			      E T4G, T4J, T4I, T4F, T4K;
			      {
				   E T4z, T4R, T4a, T4M, T4h, T4o, T4C, T4N, T4A, T4B;
				   T4z = FMA(KP923879532, T4y, T4v);
				   T4R = FNMS(KP923879532, T4y, T4v);
				   T4a = FNMS(KP923879532, T49, T42);
				   T4M = FMA(KP923879532, T49, T42);
				   Ip[WS(rs, 14)] = FNMS(T3e, T3f, T3d);
				   T4h = FNMS(KP668178637, T4g, T4d);
				   T4A = FMA(KP668178637, T4d, T4g);
				   T4B = FMA(KP668178637, T4k, T4n);
				   T4o = FNMS(KP668178637, T4n, T4k);
				   T4C = T4A - T4B;
				   T4N = T4A + T4B;
				   {
					E T4W, T4Z, T4q, T4X, T50, T4Y;
					{
					     E T4L, T4Q, T4O, T4p, T4S, T4P, T4U, T4V, T4T;
					     T4L = W[20];
					     T4Q = W[21];
					     T4W = FMA(KP831469612, T4N, T4M);
					     T4O = FNMS(KP831469612, T4N, T4M);
					     T4p = T4h + T4o;
					     T4S = T4h - T4o;
					     T4P = T4L * T4O;
					     T4V = W[52];
					     T4Z = FNMS(KP831469612, T4S, T4R);
					     T4T = FMA(KP831469612, T4S, T4R);
					     T4q = FNMS(KP831469612, T4p, T4a);
					     T4G = FMA(KP831469612, T4p, T4a);
					     Ip[WS(rs, 5)] = FNMS(T4Q, T4T, T4P);
					     T4U = T4L * T4T;
					     T4X = T4V * T4W;
					     T50 = T4V * T4Z;
					     T4Y = W[53];
					     Im[WS(rs, 5)] = FMA(T4Q, T4O, T4U);
					}
					{
					     E T4D, T4s, T3Z, T4E, T4r;
					     T4J = FMA(KP831469612, T4C, T4z);
					     T4D = FNMS(KP831469612, T4C, T4z);
					     T4s = W[37];
					     Im[WS(rs, 13)] = FMA(T4Y, T4W, T50);
					     Ip[WS(rs, 13)] = FNMS(T4Y, T4Z, T4X);
					     T3Z = W[36];
					     T4E = T4s * T4q;
					     T4I = W[5];
					     T4r = T3Z * T4q;
					     Im[WS(rs, 9)] = FMA(T3Z, T4D, T4E);
					     T4F = W[4];
					     T4K = T4I * T4G;
					     Ip[WS(rs, 9)] = FNMS(T4s, T4D, T4r);
					}
				   }
			      }
			      {
				   E T3E, T3H, T3G, T3D, T3I;
				   {
					E T3x, T3P, T3k, T3K, T3n, T3q, T3A, T3L, T4H, T3y, T3z;
					T3x = FMA(KP923879532, T3w, T3v);
					T3P = FNMS(KP923879532, T3w, T3v);
					T4H = T4F * T4G;
					Im[WS(rs, 1)] = FMA(T4F, T4J, T4K);
					T3k = FMA(KP923879532, T3j, T3i);
					T3K = FNMS(KP923879532, T3j, T3i);
					T3y = FMA(KP198912367, T3l, T3m);
					T3n = FNMS(KP198912367, T3m, T3l);
					Ip[WS(rs, 1)] = FNMS(T4I, T4J, T4H);
					T3z = FNMS(KP198912367, T3o, T3p);
					T3q = FMA(KP198912367, T3p, T3o);
					T3A = T3y + T3z;
					T3L = T3z - T3y;
					{
					     E T3U, T3X, T3s, T3V, T3Y, T3W;
					     {
						  E T3J, T3O, T3M, T3r, T3Q, T3N, T3S, T3T, T3R;
						  T3J = W[48];
						  T3O = W[49];
						  T3U = FMA(KP980785280, T3L, T3K);
						  T3M = FNMS(KP980785280, T3L, T3K);
						  T3r = T3n + T3q;
						  T3Q = T3n - T3q;
						  T3N = T3J * T3M;
						  T3T = W[16];
						  T3X = FMA(KP980785280, T3Q, T3P);
						  T3R = FNMS(KP980785280, T3Q, T3P);
						  T3s = FNMS(KP980785280, T3r, T3k);
						  T3E = FMA(KP980785280, T3r, T3k);
						  Ip[WS(rs, 12)] = FNMS(T3O, T3R, T3N);
						  T3S = T3J * T3R;
						  T3V = T3T * T3U;
						  T3Y = T3T * T3X;
						  T3W = W[17];
						  Im[WS(rs, 12)] = FMA(T3O, T3M, T3S);
					     }
					     {
						  E T3B, T3u, T3h, T3C, T3t;
						  T3H = FMA(KP980785280, T3A, T3x);
						  T3B = FNMS(KP980785280, T3A, T3x);
						  T3u = W[33];
						  Im[WS(rs, 4)] = FMA(T3W, T3U, T3Y);
						  Ip[WS(rs, 4)] = FNMS(T3W, T3X, T3V);
						  T3h = W[32];
						  T3C = T3u * T3s;
						  T3G = W[1];
						  T3t = T3h * T3s;
						  Im[WS(rs, 8)] = FMA(T3h, T3B, T3C);
						  T3D = W[0];
						  T3I = T3G * T3E;
						  Ip[WS(rs, 8)] = FNMS(T3u, T3B, T3t);
					     }
					}
				   }
				   {
					E T5h, T5z, T54, T5u, T57, T5a, T5k, T5v, T3F, T5i, T5j;
					T5h = FMA(KP923879532, T5g, T5f);
					T5z = FNMS(KP923879532, T5g, T5f);
					T3F = T3D * T3E;
					Im[0] = FMA(T3D, T3H, T3I);
					T54 = FNMS(KP923879532, T53, T52);
					T5u = FMA(KP923879532, T53, T52);
					T5i = FMA(KP198912367, T55, T56);
					T57 = FNMS(KP198912367, T56, T55);
					Ip[0] = FNMS(T3G, T3H, T3F);
					T5j = FMA(KP198912367, T58, T59);
					T5a = FNMS(KP198912367, T59, T58);
					T5k = T5i - T5j;
					T5v = T5i + T5j;
					{
					     E T5E, T5H, T5c, T5F, T5I, T5G;
					     {
						  E T5t, T5y, T5w, T5b, T5A, T5x, T5C, T5D, T5B;
						  T5t = W[28];
						  T5y = W[29];
						  T5E = FMA(KP980785280, T5v, T5u);
						  T5w = FNMS(KP980785280, T5v, T5u);
						  T5b = T57 + T5a;
						  T5A = T5a - T57;
						  T5x = T5t * T5w;
						  T5D = W[60];
						  T5H = FNMS(KP980785280, T5A, T5z);
						  T5B = FMA(KP980785280, T5A, T5z);
						  T5c = FMA(KP980785280, T5b, T54);
						  T5o = FNMS(KP980785280, T5b, T54);
						  Ip[WS(rs, 7)] = FNMS(T5y, T5B, T5x);
						  T5C = T5t * T5B;
						  T5F = T5D * T5E;
						  T5I = T5D * T5H;
						  T5G = W[61];
						  Im[WS(rs, 7)] = FMA(T5y, T5w, T5C);
					     }
					     {
						  E T5l, T5e, T51, T5m, T5d;
						  T5r = FMA(KP980785280, T5k, T5h);
						  T5l = FNMS(KP980785280, T5k, T5h);
						  T5e = W[45];
						  Im[WS(rs, 15)] = FMA(T5G, T5E, T5I);
						  Ip[WS(rs, 15)] = FNMS(T5G, T5H, T5F);
						  T51 = W[44];
						  T5m = T5e * T5c;
						  T5q = W[13];
						  T5d = T51 * T5c;
						  Im[WS(rs, 11)] = FMA(T51, T5l, T5m);
						  T5n = W[12];
						  T5s = T5q * T5o;
						  Ip[WS(rs, 11)] = FNMS(T5e, T5l, T5d);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       T5p = T5n * T5o;
	       Im[WS(rs, 3)] = FMA(T5n, T5r, T5s);
	       Ip[WS(rs, 3)] = FNMS(T5q, T5r, T5p);
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cb_32", twinstr, &GENUS, {236, 62, 198, 0} };

void X(codelet_hc2cb_32) (planner *p) {
     X(khc2c_register) (p, hc2cb_32, &desc, HC2C_VIA_RDFT);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2c.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 32 -dif -name hc2cb_32 -include hc2cb.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 340 additions, 114 multiplications, 94 fused multiply/add),
 * 98 stack variables, 7 constants, and 128 memory accesses
 */
#include "hc2cb.h"

static void hc2cb_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T4o, T6y, T70, T5u, Tf, T12, T5x, T6z, T3m, T3Y, T29, T2y, T4v, T71, T2U;
	       E T3M, Tu, T1U, T6D, T73, T6G, T74, T1h, T2z, T2X, T3o, T4D, T5A, T4K, T5z;
	       E T30, T3n, TK, T1j, T6S, T7w, T6V, T7v, T1y, T2B, T3c, T3S, T4X, T61, T54;
	       E T62, T3f, T3T, TZ, T1A, T6L, T7z, T6O, T7y, T1P, T2C, T35, T3P, T5g, T64;
	       E T5n, T65, T38, T3Q;
	       {
		    E T3, T4m, T1X, T5t, T6, T5s, T20, T4n, Ta, T4p, T24, T4q, Td, T4s, T27;
		    E T4t;
		    {
			 E T1, T2, T1V, T1W;
			 T1 = Rp[0];
			 T2 = Rm[WS(rs, 15)];
			 T3 = T1 + T2;
			 T4m = T1 - T2;
			 T1V = Ip[0];
			 T1W = Im[WS(rs, 15)];
			 T1X = T1V - T1W;
			 T5t = T1V + T1W;
		    }
		    {
			 E T4, T5, T1Y, T1Z;
			 T4 = Rp[WS(rs, 8)];
			 T5 = Rm[WS(rs, 7)];
			 T6 = T4 + T5;
			 T5s = T4 - T5;
			 T1Y = Ip[WS(rs, 8)];
			 T1Z = Im[WS(rs, 7)];
			 T20 = T1Y - T1Z;
			 T4n = T1Y + T1Z;
		    }
		    {
			 E T8, T9, T22, T23;
			 T8 = Rp[WS(rs, 4)];
			 T9 = Rm[WS(rs, 11)];
			 Ta = T8 + T9;
			 T4p = T8 - T9;
			 T22 = Ip[WS(rs, 4)];
			 T23 = Im[WS(rs, 11)];
			 T24 = T22 - T23;
			 T4q = T22 + T23;
		    }
		    {
			 E Tb, Tc, T25, T26;
			 Tb = Rm[WS(rs, 3)];
			 Tc = Rp[WS(rs, 12)];
			 Td = Tb + Tc;
			 T4s = Tb - Tc;
			 T25 = Ip[WS(rs, 12)];
			 T26 = Im[WS(rs, 3)];
			 T27 = T25 - T26;
			 T4t = T25 + T26;
		    }
		    {
			 E T7, Te, T21, T28;
			 T4o = T4m - T4n;
			 T6y = T4m + T4n;
			 T70 = T5t - T5s;
			 T5u = T5s + T5t;
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 T12 = T7 - Te;
			 {
			      E T5v, T5w, T3k, T3l;
			      T5v = T4p + T4q;
			      T5w = T4s + T4t;
			      T5x = KP707106781 * (T5v - T5w);
			      T6z = KP707106781 * (T5v + T5w);
			      T3k = T1X - T20;
			      T3l = Ta - Td;
			      T3m = T3k - T3l;
			      T3Y = T3l + T3k;
			 }
			 T21 = T1X + T20;
			 T28 = T24 + T27;
			 T29 = T21 - T28;
			 T2y = T21 + T28;
			 {
			      E T4r, T4u, T2S, T2T;
			      T4r = T4p - T4q;
			      T4u = T4s - T4t;
			      T4v = KP707106781 * (T4r + T4u);
			      T71 = KP707106781 * (T4r - T4u);
			      T2S = T3 - T6;
			      T2T = T27 - T24;
			      T2U = T2S - T2T;
			      T3M = T2S + T2T;
			 }
		    }
	       }
	       {
		    E Ti, T4H, T1c, T4F, Tl, T4E, T1f, T4I, Tp, T4A, T15, T4y, Ts, T4x, T18;
		    E T4B;
		    {
			 E Tg, Th, T1a, T1b;
			 Tg = Rp[WS(rs, 2)];
			 Th = Rm[WS(rs, 13)];
			 Ti = Tg + Th;
			 T4H = Tg - Th;
			 T1a = Ip[WS(rs, 2)];
			 T1b = Im[WS(rs, 13)];
			 T1c = T1a - T1b;
			 T4F = T1a + T1b;
		    }
		    {
			 E Tj, Tk, T1d, T1e;
			 Tj = Rp[WS(rs, 10)];
			 Tk = Rm[WS(rs, 5)];
			 Tl = Tj + Tk;
			 T4E = Tj - Tk;
			 T1d = Ip[WS(rs, 10)];
			 T1e = Im[WS(rs, 5)];
			 T1f = T1d - T1e;
			 T4I = T1d + T1e;
		    }
		    {
			 E Tn, To, T13, T14;
			 Tn = Rm[WS(rs, 1)];
			 To = Rp[WS(rs, 14)];
			 Tp = Tn + To;
			 T4A = Tn - To;
			 T13 = Ip[WS(rs, 14)];
			 T14 = Im[WS(rs, 1)];
			 T15 = T13 - T14;
			 T4y = T13 + T14;
		    }
		    {
			 E Tq, Tr, T16, T17;
			 Tq = Rp[WS(rs, 6)];
			 Tr = Rm[WS(rs, 9)];
			 Ts = Tq + Tr;
			 T4x = Tq - Tr;
			 T16 = Ip[WS(rs, 6)];
			 T17 = Im[WS(rs, 9)];
			 T18 = T16 - T17;
			 T4B = T16 + T17;
		    }
		    {
			 E Tm, Tt, T6B, T6C;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 T1U = Tm - Tt;
			 T6B = T4H + T4I;
			 T6C = T4F - T4E;
			 T6D = FNMS(KP923879532, T6C, KP382683432 * T6B);
			 T73 = FMA(KP382683432, T6C, KP923879532 * T6B);
		    }
		    {
			 E T6E, T6F, T19, T1g;
			 T6E = T4A + T4B;
			 T6F = T4x + T4y;
			 T6G = FNMS(KP923879532, T6F, KP382683432 * T6E);
			 T74 = FMA(KP382683432, T6F, KP923879532 * T6E);
			 T19 = T15 + T18;
			 T1g = T1c + T1f;
			 T1h = T19 - T1g;
			 T2z = T1g + T19;
		    }
		    {
			 E T2V, T2W, T4z, T4C;
			 T2V = T15 - T18;
			 T2W = Tp - Ts;
			 T2X = T2V - T2W;
			 T3o = T2W + T2V;
			 T4z = T4x - T4y;
			 T4C = T4A - T4B;
			 T4D = FNMS(KP382683432, T4C, KP923879532 * T4z);
			 T5A = FMA(KP382683432, T4z, KP923879532 * T4C);
		    }
		    {
			 E T4G, T4J, T2Y, T2Z;
			 T4G = T4E + T4F;
			 T4J = T4H - T4I;
			 T4K = FMA(KP923879532, T4G, KP382683432 * T4J);
			 T5z = FNMS(KP382683432, T4G, KP923879532 * T4J);
			 T2Y = Ti - Tl;
			 T2Z = T1c - T1f;
			 T30 = T2Y + T2Z;
			 T3n = T2Y - T2Z;
		    }
	       }
	       {
		    E Ty, T4N, T1m, T4Z, TB, T4Y, T1p, T4O, TI, T52, T1w, T4V, TF, T51, T1t;
		    E T4S;
		    {
			 E Tw, Tx, T1n, T1o;
			 Tw = Rp[WS(rs, 1)];
			 Tx = Rm[WS(rs, 14)];
			 Ty = Tw + Tx;
			 T4N = Tw - Tx;
			 {
			      E T1k, T1l, Tz, TA;
			      T1k = Ip[WS(rs, 1)];
			      T1l = Im[WS(rs, 14)];
			      T1m = T1k - T1l;
			      T4Z = T1k + T1l;
			      Tz = Rp[WS(rs, 9)];
			      TA = Rm[WS(rs, 6)];
			      TB = Tz + TA;
			      T4Y = Tz - TA;
			 }
			 T1n = Ip[WS(rs, 9)];
			 T1o = Im[WS(rs, 6)];
			 T1p = T1n - T1o;
			 T4O = T1n + T1o;
			 {
			      E TG, TH, T4T, T1u, T1v, T4U;
			      TG = Rm[WS(rs, 2)];
			      TH = Rp[WS(rs, 13)];
			      T4T = TG - TH;
			      T1u = Ip[WS(rs, 13)];
			      T1v = Im[WS(rs, 2)];
			      T4U = T1u + T1v;
			      TI = TG + TH;
			      T52 = T4T + T4U;
			      T1w = T1u - T1v;
			      T4V = T4T - T4U;
			 }
			 {
			      E TD, TE, T4Q, T1r, T1s, T4R;
			      TD = Rp[WS(rs, 5)];
			      TE = Rm[WS(rs, 10)];
			      T4Q = TD - TE;
			      T1r = Ip[WS(rs, 5)];
			      T1s = Im[WS(rs, 10)];
			      T4R = T1r + T1s;
			      TF = TD + TE;
			      T51 = T4Q + T4R;
			      T1t = T1r - T1s;
			      T4S = T4Q - T4R;
			 }
		    }
		    {
			 E TC, TJ, T6Q, T6R;
			 TC = Ty + TB;
			 TJ = TF + TI;
			 TK = TC + TJ;
			 T1j = TC - TJ;
			 T6Q = T4Z - T4Y;
			 T6R = KP707106781 * (T4S - T4V);
			 T6S = T6Q + T6R;
			 T7w = T6Q - T6R;
		    }
		    {
			 E T6T, T6U, T1q, T1x;
			 T6T = T4N + T4O;
			 T6U = KP707106781 * (T51 + T52);
			 T6V = T6T - T6U;
			 T7v = T6T + T6U;
			 T1q = T1m + T1p;
			 T1x = T1t + T1w;
			 T1y = T1q - T1x;
			 T2B = T1q + T1x;
		    }
		    {
			 E T3a, T3b, T4P, T4W;
			 T3a = T1m - T1p;
			 T3b = TF - TI;
			 T3c = T3a - T3b;
			 T3S = T3b + T3a;
			 T4P = T4N - T4O;
			 T4W = KP707106781 * (T4S + T4V);
			 T4X = T4P - T4W;
			 T61 = T4P + T4W;
		    }
		    {
			 E T50, T53, T3d, T3e;
			 T50 = T4Y + T4Z;
			 T53 = KP707106781 * (T51 - T52);
			 T54 = T50 - T53;
			 T62 = T50 + T53;
			 T3d = Ty - TB;
			 T3e = T1w - T1t;
			 T3f = T3d - T3e;
			 T3T = T3d + T3e;
		    }
	       }
	       {
		    E TN, T56, T1D, T5i, TQ, T5h, T1G, T57, TX, T5l, T1N, T5e, TU, T5k, T1K;
		    E T5b;
		    {
			 E TL, TM, T1E, T1F;
			 TL = Rm[0];
			 TM = Rp[WS(rs, 15)];
			 TN = TL + TM;
			 T56 = TL - TM;
			 {
			      E T1B, T1C, TO, TP;
			      T1B = Ip[WS(rs, 15)];
			      T1C = Im[0];
			      T1D = T1B - T1C;
			      T5i = T1B + T1C;
			      TO = Rp[WS(rs, 7)];
			      TP = Rm[WS(rs, 8)];
			      TQ = TO + TP;
			      T5h = TO - TP;
			 }
			 T1E = Ip[WS(rs, 7)];
			 T1F = Im[WS(rs, 8)];
			 T1G = T1E - T1F;
			 T57 = T1E + T1F;
			 {
			      E TV, TW, T5c, T1L, T1M, T5d;
			      TV = Rm[WS(rs, 4)];
			      TW = Rp[WS(rs, 11)];
			      T5c = TV - TW;
			      T1L = Ip[WS(rs, 11)];
			      T1M = Im[WS(rs, 4)];
			      T5d = T1L + T1M;
			      TX = TV + TW;
			      T5l = T5c + T5d;
			      T1N = T1L - T1M;
			      T5e = T5c - T5d;
			 }
			 {
			      E TS, TT, T59, T1I, T1J, T5a;
			      TS = Rp[WS(rs, 3)];
			      TT = Rm[WS(rs, 12)];
			      T59 = TS - TT;
			      T1I = Ip[WS(rs, 3)];
			      T1J = Im[WS(rs, 12)];
			      T5a = T1I + T1J;
			      TU = TS + TT;
			      T5k = T59 + T5a;
			      T1K = T1I - T1J;
			      T5b = T59 - T5a;
			 }
		    }
		    {
			 E TR, TY, T6J, T6K;
			 TR = TN + TQ;
			 TY = TU + TX;
			 TZ = TR + TY;
			 T1A = TR - TY;
			 T6J = KP707106781 * (T5b - T5e);
			 T6K = T5h + T5i;
			 T6L = T6J - T6K;
			 T7z = T6K + T6J;
		    }
		    {
			 E T6M, T6N, T1H, T1O;
			 T6M = T56 + T57;
			 T6N = KP707106781 * (T5k + T5l);
			 T6O = T6M - T6N;
			 T7y = T6M + T6N;
			 T1H = T1D + T1G;
			 T1O = T1K + T1N;
			 T1P = T1H - T1O;
			 T2C = T1H + T1O;
		    }
		    {
			 E T33, T34, T58, T5f;
			 T33 = T1D - T1G;
			 T34 = TU - TX;
			 T35 = T33 - T34;
			 T3P = T34 + T33;
			 T58 = T56 - T57;
			 T5f = KP707106781 * (T5b + T5e);
			 T5g = T58 - T5f;
			 T64 = T58 + T5f;
		    }
		    {
			 E T5j, T5m, T36, T37;
			 T5j = T5h - T5i;
			 T5m = KP707106781 * (T5k - T5l);
			 T5n = T5j - T5m;
			 T65 = T5j + T5m;
			 T36 = TN - TQ;
			 T37 = T1N - T1K;
			 T38 = T36 - T37;
			 T3Q = T36 + T37;
		    }
	       }
	       {
		    E Tv, T10, T2w, T2A, T2D, T2E, T2v, T2x;
		    Tv = Tf + Tu;
		    T10 = TK + TZ;
		    T2w = Tv - T10;
		    T2A = T2y + T2z;
		    T2D = T2B + T2C;
		    T2E = T2A - T2D;
		    Rp[0] = Tv + T10;
		    Rm[0] = T2A + T2D;
		    T2v = W[30];
		    T2x = W[31];
		    Rp[WS(rs, 8)] = FNMS(T2x, T2E, T2v * T2w);
		    Rm[WS(rs, 8)] = FMA(T2x, T2w, T2v * T2E);
	       }
	       {
		    E T2I, T2O, T2M, T2Q;
		    {
			 E T2G, T2H, T2K, T2L;
			 T2G = Tf - Tu;
			 T2H = T2C - T2B;
			 T2I = T2G - T2H;
			 T2O = T2G + T2H;
			 T2K = T2y - T2z;
			 T2L = TK - TZ;
			 T2M = T2K - T2L;
			 T2Q = T2L + T2K;
		    }
		    {
			 E T2F, T2J, T2N, T2P;
			 T2F = W[46];
			 T2J = W[47];
			 Rp[WS(rs, 12)] = FNMS(T2J, T2M, T2F * T2I);
			 Rm[WS(rs, 12)] = FMA(T2F, T2M, T2J * T2I);
			 T2N = W[14];
			 T2P = W[15];
			 Rp[WS(rs, 4)] = FNMS(T2P, T2Q, T2N * T2O);
			 Rm[WS(rs, 4)] = FMA(T2N, T2Q, T2P * T2O);
		    }
	       }
	       {
		    E T1i, T2a, T2o, T2k, T2d, T2l, T1R, T2p;
		    T1i = T12 + T1h;
		    T2a = T1U + T29;
		    T2o = T29 - T1U;
		    T2k = T12 - T1h;
		    {
			 E T2b, T2c, T1z, T1Q;
			 T2b = T1j + T1y;
			 T2c = T1P - T1A;
			 T2d = KP707106781 * (T2b + T2c);
			 T2l = KP707106781 * (T2c - T2b);
			 T1z = T1j - T1y;
			 T1Q = T1A + T1P;
			 T1R = KP707106781 * (T1z + T1Q);
			 T2p = KP707106781 * (T1z - T1Q);
		    }
		    {
			 E T1S, T2e, T11, T1T;
			 T1S = T1i - T1R;
			 T2e = T2a - T2d;
			 T11 = W[38];
			 T1T = W[39];
			 Rp[WS(rs, 10)] = FNMS(T1T, T2e, T11 * T1S);
			 Rm[WS(rs, 10)] = FMA(T1T, T1S, T11 * T2e);
		    }
		    {
			 E T2s, T2u, T2r, T2t;
			 T2s = T2k + T2l;
			 T2u = T2o + T2p;
			 T2r = W[22];
			 T2t = W[23];
			 Rp[WS(rs, 6)] = FNMS(T2t, T2u, T2r * T2s);
			 Rm[WS(rs, 6)] = FMA(T2r, T2u, T2t * T2s);
		    }
		    {
			 E T2g, T2i, T2f, T2h;
			 T2g = T1i + T1R;
			 T2i = T2a + T2d;
			 T2f = W[6];
			 T2h = W[7];
			 Rp[WS(rs, 2)] = FNMS(T2h, T2i, T2f * T2g);
			 Rm[WS(rs, 2)] = FMA(T2h, T2g, T2f * T2i);
		    }
		    {
			 E T2m, T2q, T2j, T2n;
			 T2m = T2k - T2l;
			 T2q = T2o - T2p;
			 T2j = W[54];
			 T2n = W[55];
			 Rp[WS(rs, 14)] = FNMS(T2n, T2q, T2j * T2m);
			 Rm[WS(rs, 14)] = FMA(T2j, T2q, T2n * T2m);
		    }
	       }
	       {
		    E T3O, T4a, T40, T4e, T3V, T4f, T43, T4b, T3N, T3Z;
		    T3N = KP707106781 * (T3n + T3o);
		    T3O = T3M - T3N;
		    T4a = T3M + T3N;
		    T3Z = KP707106781 * (T30 + T2X);
		    T40 = T3Y - T3Z;
		    T4e = T3Y + T3Z;
		    {
			 E T3R, T3U, T41, T42;
			 T3R = FNMS(KP382683432, T3Q, KP923879532 * T3P);
			 T3U = FMA(KP923879532, T3S, KP382683432 * T3T);
			 T3V = T3R - T3U;
			 T4f = T3U + T3R;
			 T41 = FNMS(KP382683432, T3S, KP923879532 * T3T);
			 T42 = FMA(KP382683432, T3P, KP923879532 * T3Q);
			 T43 = T41 - T42;
			 T4b = T41 + T42;
		    }
		    {
			 E T3W, T44, T3L, T3X;
			 T3W = T3O - T3V;
			 T44 = T40 - T43;
			 T3L = W[50];
			 T3X = W[51];
			 Rp[WS(rs, 13)] = FNMS(T3X, T44, T3L * T3W);
			 Rm[WS(rs, 13)] = FMA(T3X, T3W, T3L * T44);
		    }
		    {
			 E T4i, T4k, T4h, T4j;
			 T4i = T4a + T4b;
			 T4k = T4e + T4f;
			 T4h = W[2];
			 T4j = W[3];
			 Rp[WS(rs, 1)] = FNMS(T4j, T4k, T4h * T4i);
			 Rm[WS(rs, 1)] = FMA(T4h, T4k, T4j * T4i);
		    }
		    {
			 E T46, T48, T45, T47;
			 T46 = T3O + T3V;
			 T48 = T40 + T43;
			 T45 = W[18];
			 T47 = W[19];
			 Rp[WS(rs, 5)] = FNMS(T47, T48, T45 * T46);
			 Rm[WS(rs, 5)] = FMA(T47, T46, T45 * T48);
		    }
		    {
			 E T4c, T4g, T49, T4d;
			 T4c = T4a - T4b;
			 T4g = T4e - T4f;
			 T49 = W[34];
			 T4d = W[35];
			 Rp[WS(rs, 9)] = FNMS(T4d, T4g, T49 * T4c);
			 Rm[WS(rs, 9)] = FMA(T49, T4g, T4d * T4c);
		    }
	       }
	       {
		    E T32, T3A, T3q, T3E, T3h, T3F, T3t, T3B, T31, T3p;
		    T31 = KP707106781 * (T2X - T30);
		    T32 = T2U - T31;
		    T3A = T2U + T31;
		    T3p = KP707106781 * (T3n - T3o);
		    T3q = T3m - T3p;
		    T3E = T3m + T3p;
		    {
			 E T39, T3g, T3r, T3s;
			 T39 = FNMS(KP923879532, T38, KP382683432 * T35);
			 T3g = FMA(KP382683432, T3c, KP923879532 * T3f);
			 T3h = T39 - T3g;
			 T3F = T3g + T39;
			 T3r = FNMS(KP923879532, T3c, KP382683432 * T3f);
			 T3s = FMA(KP923879532, T35, KP382683432 * T38);
			 T3t = T3r - T3s;
			 T3B = T3r + T3s;
		    }
		    {
			 E T3i, T3u, T2R, T3j;
			 T3i = T32 - T3h;
			 T3u = T3q - T3t;
			 T2R = W[58];
			 T3j = W[59];
			 Rp[WS(rs, 15)] = FNMS(T3j, T3u, T2R * T3i);
			 Rm[WS(rs, 15)] = FMA(T3j, T3i, T2R * T3u);
		    }
		    {
			 E T3I, T3K, T3H, T3J;
			 T3I = T3A + T3B;
			 T3K = T3E + T3F;
			 T3H = W[10];
			 T3J = W[11];
			 Rp[WS(rs, 3)] = FNMS(T3J, T3K, T3H * T3I);
			 Rm[WS(rs, 3)] = FMA(T3H, T3K, T3J * T3I);
		    }
		    {
			 E T3w, T3y, T3v, T3x;
			 T3w = T32 + T3h;
			 T3y = T3q + T3t;
			 T3v = W[26];
			 T3x = W[27];
			 Rp[WS(rs, 7)] = FNMS(T3x, T3y, T3v * T3w);
			 Rm[WS(rs, 7)] = FMA(T3x, T3w, T3v * T3y);
		    }
		    {
			 E T3C, T3G, T3z, T3D;
			 T3C = T3A - T3B;
			 T3G = T3E - T3F;
			 T3z = W[42];
			 T3D = W[43];
			 Rp[WS(rs, 11)] = FNMS(T3D, T3G, T3z * T3C);
			 Rm[WS(rs, 11)] = FMA(T3z, T3G, T3D * T3C);
		    }
	       }
	       {
		    E T60, T6m, T6f, T6n, T67, T6r, T6c, T6q;
		    {
			 E T5Y, T5Z, T6d, T6e;
			 T5Y = T4o + T4v;
			 T5Z = T5z + T5A;
			 T60 = T5Y + T5Z;
			 T6m = T5Y - T5Z;
			 T6d = FMA(KP195090322, T61, KP980785280 * T62);
			 T6e = FNMS(KP195090322, T64, KP980785280 * T65);
			 T6f = T6d + T6e;
			 T6n = T6e - T6d;
		    }
		    {
			 E T63, T66, T6a, T6b;
			 T63 = FNMS(KP195090322, T62, KP980785280 * T61);
			 T66 = FMA(KP980785280, T64, KP195090322 * T65);
			 T67 = T63 + T66;
			 T6r = T63 - T66;
			 T6a = T5u + T5x;
			 T6b = T4K + T4D;
			 T6c = T6a + T6b;
			 T6q = T6a - T6b;
		    }
		    {
			 E T68, T6g, T5X, T69;
			 T68 = T60 - T67;
			 T6g = T6c - T6f;
			 T5X = W[32];
			 T69 = W[33];
			 Ip[WS(rs, 8)] = FNMS(T69, T6g, T5X * T68);
			 Im[WS(rs, 8)] = FMA(T69, T68, T5X * T6g);
		    }
		    {
			 E T6u, T6w, T6t, T6v;
			 T6u = T6m + T6n;
			 T6w = T6q + T6r;
			 T6t = W[16];
			 T6v = W[17];
			 Ip[WS(rs, 4)] = FNMS(T6v, T6w, T6t * T6u);
			 Im[WS(rs, 4)] = FMA(T6t, T6w, T6v * T6u);
		    }
		    {
			 E T6i, T6k, T6h, T6j;
			 T6i = T60 + T67;
			 T6k = T6c + T6f;
			 T6h = W[0];
			 T6j = W[1];
			 Ip[0] = FNMS(T6j, T6k, T6h * T6i);
			 Im[0] = FMA(T6j, T6i, T6h * T6k);
		    }
		    {
			 E T6o, T6s, T6l, T6p;
			 T6o = T6m - T6n;
			 T6s = T6q - T6r;
			 T6l = W[48];
			 T6p = W[49];
			 Ip[WS(rs, 12)] = FNMS(T6p, T6s, T6l * T6o);
			 Im[WS(rs, 12)] = FMA(T6l, T6s, T6p * T6o);
		    }
	       }
	       {
		    E T7u, T7Q, T7J, T7R, T7B, T7V, T7G, T7U;
		    {
			 E T7s, T7t, T7H, T7I;
			 T7s = T6y + T6z;
			 T7t = T73 + T74;
			 T7u = T7s - T7t;
			 T7Q = T7s + T7t;
			 T7H = FMA(KP195090322, T7w, KP980785280 * T7v);
			 T7I = FMA(KP195090322, T7z, KP980785280 * T7y);
			 T7J = T7H - T7I;
			 T7R = T7H + T7I;
		    }
		    {
			 E T7x, T7A, T7E, T7F;
			 T7x = FNMS(KP980785280, T7w, KP195090322 * T7v);
			 T7A = FNMS(KP980785280, T7z, KP195090322 * T7y);
			 T7B = T7x + T7A;
			 T7V = T7x - T7A;
			 T7E = T70 - T71;
			 T7F = T6D - T6G;
			 T7G = T7E + T7F;
			 T7U = T7E - T7F;
		    }
		    {
			 E T7C, T7K, T7r, T7D;
			 T7C = T7u - T7B;
			 T7K = T7G - T7J;
			 T7r = W[44];
			 T7D = W[45];
			 Ip[WS(rs, 11)] = FNMS(T7D, T7K, T7r * T7C);
			 Im[WS(rs, 11)] = FMA(T7D, T7C, T7r * T7K);
		    }
		    {
			 E T7Y, T80, T7X, T7Z;
			 T7Y = T7Q + T7R;
			 T80 = T7U - T7V;
			 T7X = W[60];
			 T7Z = W[61];
			 Ip[WS(rs, 15)] = FNMS(T7Z, T80, T7X * T7Y);
			 Im[WS(rs, 15)] = FMA(T7X, T80, T7Z * T7Y);
		    }
		    {
			 E T7M, T7O, T7L, T7N;
			 T7M = T7u + T7B;
			 T7O = T7G + T7J;
			 T7L = W[12];
			 T7N = W[13];
			 Ip[WS(rs, 3)] = FNMS(T7N, T7O, T7L * T7M);
			 Im[WS(rs, 3)] = FMA(T7N, T7M, T7L * T7O);
		    }
		    {
			 E T7S, T7W, T7P, T7T;
			 T7S = T7Q - T7R;
			 T7W = T7U + T7V;
			 T7P = W[28];
			 T7T = W[29];
			 Ip[WS(rs, 7)] = FNMS(T7T, T7W, T7P * T7S);
			 Im[WS(rs, 7)] = FMA(T7P, T7W, T7T * T7S);
		    }
	       }
	       {
		    E T4M, T5M, T5F, T5N, T5p, T5R, T5C, T5Q;
		    {
			 E T4w, T4L, T5D, T5E;
			 T4w = T4o - T4v;
			 T4L = T4D - T4K;
			 T4M = T4w + T4L;
			 T5M = T4w - T4L;
			 T5D = FMA(KP831469612, T4X, KP555570233 * T54);
			 T5E = FNMS(KP831469612, T5g, KP555570233 * T5n);
			 T5F = T5D + T5E;
			 T5N = T5E - T5D;
		    }
		    {
			 E T55, T5o, T5y, T5B;
			 T55 = FNMS(KP831469612, T54, KP555570233 * T4X);
			 T5o = FMA(KP555570233, T5g, KP831469612 * T5n);
			 T5p = T55 + T5o;
			 T5R = T55 - T5o;
			 T5y = T5u - T5x;
			 T5B = T5z - T5A;
			 T5C = T5y + T5B;
			 T5Q = T5y - T5B;
		    }
		    {
			 E T5q, T5G, T4l, T5r;
			 T5q = T4M - T5p;
			 T5G = T5C - T5F;
			 T4l = W[40];
			 T5r = W[41];
			 Ip[WS(rs, 10)] = FNMS(T5r, T5G, T4l * T5q);
			 Im[WS(rs, 10)] = FMA(T5r, T5q, T4l * T5G);
		    }
		    {
			 E T5U, T5W, T5T, T5V;
			 T5U = T5M + T5N;
			 T5W = T5Q + T5R;
			 T5T = W[24];
			 T5V = W[25];
			 Ip[WS(rs, 6)] = FNMS(T5V, T5W, T5T * T5U);
			 Im[WS(rs, 6)] = FMA(T5T, T5W, T5V * T5U);
		    }
		    {
			 E T5I, T5K, T5H, T5J;
			 T5I = T4M + T5p;
			 T5K = T5C + T5F;
			 T5H = W[8];
			 T5J = W[9];
			 Ip[WS(rs, 2)] = FNMS(T5J, T5K, T5H * T5I);
			 Im[WS(rs, 2)] = FMA(T5J, T5I, T5H * T5K);
		    }
		    {
			 E T5O, T5S, T5L, T5P;
			 T5O = T5M - T5N;
			 T5S = T5Q - T5R;
			 T5L = W[56];
			 T5P = W[57];
			 Ip[WS(rs, 14)] = FNMS(T5P, T5S, T5L * T5O);
			 Im[WS(rs, 14)] = FMA(T5L, T5S, T5P * T5O);
		    }
	       }
	       {
		    E T6I, T7g, T79, T7h, T6X, T7l, T76, T7k;
		    {
			 E T6A, T6H, T77, T78;
			 T6A = T6y - T6z;
			 T6H = T6D + T6G;
			 T6I = T6A - T6H;
			 T7g = T6A + T6H;
			 T77 = FNMS(KP555570233, T6S, KP831469612 * T6V);
			 T78 = FMA(KP555570233, T6L, KP831469612 * T6O);
			 T79 = T77 - T78;
			 T7h = T77 + T78;
		    }
		    {
			 E T6P, T6W, T72, T75;
			 T6P = FNMS(KP555570233, T6O, KP831469612 * T6L);
			 T6W = FMA(KP831469612, T6S, KP555570233 * T6V);
			 T6X = T6P - T6W;
			 T7l = T6W + T6P;
			 T72 = T70 + T71;
			 T75 = T73 - T74;
			 T76 = T72 - T75;
			 T7k = T72 + T75;
		    }
		    {
			 E T6Y, T7a, T6x, T6Z;
			 T6Y = T6I - T6X;
			 T7a = T76 - T79;
			 T6x = W[52];
			 T6Z = W[53];
			 Ip[WS(rs, 13)] = FNMS(T6Z, T7a, T6x * T6Y);
			 Im[WS(rs, 13)] = FMA(T6Z, T6Y, T6x * T7a);
		    }
		    {
			 E T7o, T7q, T7n, T7p;
			 T7o = T7g + T7h;
			 T7q = T7k + T7l;
			 T7n = W[4];
			 T7p = W[5];
			 Ip[WS(rs, 1)] = FNMS(T7p, T7q, T7n * T7o);
			 Im[WS(rs, 1)] = FMA(T7n, T7q, T7p * T7o);
		    }
		    {
			 E T7c, T7e, T7b, T7d;
			 T7c = T6I + T6X;
			 T7e = T76 + T79;
			 T7b = W[20];
			 T7d = W[21];
			 Ip[WS(rs, 5)] = FNMS(T7d, T7e, T7b * T7c);
			 Im[WS(rs, 5)] = FMA(T7d, T7c, T7b * T7e);
		    }
		    {
			 E T7i, T7m, T7f, T7j;
			 T7i = T7g - T7h;
			 T7m = T7k - T7l;
			 T7f = W[36];
			 T7j = W[37];
			 Ip[WS(rs, 9)] = FNMS(T7j, T7m, T7f * T7i);
			 Im[WS(rs, 9)] = FMA(T7f, T7m, T7j * T7i);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cb_32", twinstr, &GENUS, {340, 114, 94, 0} };

void X(codelet_hc2cb_32) (planner *p) {
     X(khc2c_register) (p, hc2cb_32, &desc, HC2C_VIA_RDFT);
}
#endif				/* HAVE_FMA */
