#ifndef GR3_GLX_H_INCLUDED
#define GR3_GLX_H_INCLUDED


#include <GL/gl.h>
#include <GL/glext.h>
#include <GL/glx.h>
#include <unistd.h> /* for getpid() for tempfile names */

#if GL_VERSION_2_1
#define GR3_CAN_USE_VBO
#endif

#if !(GL_ARB_framebuffer_object || GL_EXT_framebuffer_object)
#error "Neither GL_ARB_framebuffer_object nor GL_EXT_framebuffer_object \
are supported!"
#endif

#ifdef GR3_GLX_C
#define GLFUNC
#else
#define GLFUNC extern
#endif

#ifdef GR3_CAN_USE_VBO
GLFUNC PFNGLBUFFERDATAPROC gr3_glBufferData;
GLFUNC PFNGLBINDBUFFERPROC gr3_glBindBuffer;
GLFUNC PFNGLGENBUFFERSPROC gr3_glGenBuffers;
GLFUNC PFNGLGENBUFFERSPROC gr3_glDeleteBuffers;
GLFUNC PFNGLVERTEXATTRIBPOINTERPROC gr3_glVertexAttribPointer;
GLFUNC PFNGLGETATTRIBLOCATIONPROC gr3_glGetAttribLocation;
GLFUNC PFNGLENABLEVERTEXATTRIBARRAYPROC gr3_glEnableVertexAttribArray;
GLFUNC PFNGLUSEPROGRAMPROC gr3_glUseProgram;
GLFUNC PFNGLDELETESHADERPROC gr3_glDeleteShader;
GLFUNC PFNGLLINKPROGRAMPROC gr3_glLinkProgram;
GLFUNC PFNGLATTACHSHADERPROC gr3_glAttachShader;
GLFUNC PFNGLCREATESHADERPROC gr3_glCreateShader;
GLFUNC PFNGLCOMPILESHADERPROC gr3_glCompileShader;
GLFUNC PFNGLCREATEPROGRAMPROC gr3_glCreateProgram;
GLFUNC PFNGLDELETEPROGRAMPROC gr3_glDeleteProgram;
GLFUNC PFNGLUNIFORM3FPROC gr3_glUniform3f;
GLFUNC PFNGLUNIFORMMATRIX4FVPROC gr3_glUniformMatrix4fv;
GLFUNC PFNGLUNIFORM4FPROC gr3_glUniform4f;
GLFUNC PFNGLGETUNIFORMLOCATIONPROC gr3_glGetUniformLocation;
GLFUNC PFNGLSHADERSOURCEPROC gr3_glShaderSource;
#endif
GLFUNC PFNGLDRAWBUFFERSPROC gr3_glDrawBuffers;
#ifdef GL_ARB_framebuffer_object
GLFUNC PFNGLBINDRENDERBUFFERPROC gr3_glBindRenderbuffer;
GLFUNC PFNGLCHECKFRAMEBUFFERSTATUSPROC gr3_glCheckFramebufferStatus;
GLFUNC PFNGLFRAMEBUFFERRENDERBUFFERPROC gr3_glFramebufferRenderbuffer;
GLFUNC PFNGLRENDERBUFFERSTORAGEPROC gr3_glRenderbufferStorage;
GLFUNC PFNGLBINDFRAMEBUFFERPROC gr3_glBindFramebuffer;
GLFUNC PFNGLGENFRAMEBUFFERSPROC gr3_glGenFramebuffers;
GLFUNC PFNGLGENRENDERBUFFERSPROC gr3_glGenRenderbuffers;
GLFUNC PFNGLDELETEFRAMEBUFFERSPROC gr3_glDeleteFramebuffers;
GLFUNC PFNGLDELETERENDERBUFFERSPROC gr3_glDeleteRenderbuffers;
#endif
#ifdef GL_EXT_framebuffer_object
GLFUNC PFNGLBINDRENDERBUFFEREXTPROC gr3_glBindRenderbufferEXT;
GLFUNC PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC gr3_glCheckFramebufferStatusEXT;
GLFUNC PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC gr3_glFramebufferRenderbufferEXT;
GLFUNC PFNGLRENDERBUFFERSTORAGEEXTPROC gr3_glRenderbufferStorageEXT;
GLFUNC PFNGLBINDFRAMEBUFFEREXTPROC gr3_glBindFramebufferEXT;
GLFUNC PFNGLGENFRAMEBUFFERSEXTPROC gr3_glGenFramebuffersEXT;
GLFUNC PFNGLGENRENDERBUFFERSEXTPROC gr3_glGenRenderbuffersEXT;
GLFUNC PFNGLDELETEFRAMEBUFFERSEXTPROC gr3_glDeleteFramebuffersEXT;
GLFUNC PFNGLDELETERENDERBUFFERSEXTPROC gr3_glDeleteRenderbuffersEXT;
#endif

#define glBufferData gr3_glBufferData
#define glBufferData gr3_glBufferData
#define glBindBuffer gr3_glBindBuffer
#define glBindBuffer gr3_glBindBuffer
#define glGenBuffers gr3_glGenBuffers
#define glGenBuffers gr3_glGenBuffers
#define glDeleteBuffers gr3_glDeleteBuffers
#define glDeleteBuffers gr3_glDeleteBuffers
#define glVertexAttribPointer gr3_glVertexAttribPointer
#define glVertexAttribPointer gr3_glVertexAttribPointer
#define glGetAttribLocation gr3_glGetAttribLocation
#define glGetAttribLocation gr3_glGetAttribLocation
#define glEnableVertexAttribArray gr3_glEnableVertexAttribArray
#define glEnableVertexAttribArray gr3_glEnableVertexAttribArray
#define glUseProgram gr3_glUseProgram
#define glUseProgram gr3_glUseProgram
#define glDeleteShader gr3_glDeleteShader
#define glDeleteShader gr3_glDeleteShader
#define glLinkProgram gr3_glLinkProgram
#define glLinkProgram gr3_glLinkProgram
#define glAttachShader gr3_glAttachShader
#define glAttachShader gr3_glAttachShader
#define glCreateShader gr3_glCreateShader
#define glCreateShader gr3_glCreateShader
#define glCompileShader gr3_glCompileShader
#define glCompileShader gr3_glCompileShader
#define glCreateProgram gr3_glCreateProgram
#define glCreateProgram gr3_glCreateProgram
#define glDeleteProgram gr3_glDeleteProgram
#define glDeleteProgram gr3_glDeleteProgram
#define glUniform3f gr3_glUniform3f
#define glUniform3f gr3_glUniform3f
#define glUniformMatrix4fv gr3_glUniformMatrix4fv
#define glUniformMatrix4fv gr3_glUniformMatrix4fv
#define glUniform4f gr3_glUniform4f
#define glUniform4f gr3_glUniform4f
#define glGetUniformLocation gr3_glGetUniformLocation
#define glGetUniformLocation gr3_glGetUniformLocation
#define glShaderSource gr3_glShaderSource
#define glShaderSource gr3_glShaderSource
#define glDrawBuffers gr3_glDrawBuffers
#define glDrawBuffers gr3_glDrawBuffers
#define glBindRenderbuffer gr3_glBindRenderbuffer
#define glBindRenderbuffer gr3_glBindRenderbuffer
#define glCheckFramebufferStatus gr3_glCheckFramebufferStatus
#define glCheckFramebufferStatus gr3_glCheckFramebufferStatus
#define glFramebufferRenderbuffer gr3_glFramebufferRenderbuffer
#define glFramebufferRenderbuffer gr3_glFramebufferRenderbuffer
#define glRenderbufferStorage gr3_glRenderbufferStorage
#define glRenderbufferStorage gr3_glRenderbufferStorage
#define glBindFramebuffer gr3_glBindFramebuffer
#define glBindFramebuffer gr3_glBindFramebuffer
#define glGenFramebuffers gr3_glGenFramebuffers
#define glGenFramebuffers gr3_glGenFramebuffers
#define glGenRenderbuffers gr3_glGenRenderbuffers
#define glGenRenderbuffers gr3_glGenRenderbuffers
#define glDeleteFramebuffers gr3_glDeleteFramebuffers
#define glDeleteFramebuffers gr3_glDeleteFramebuffers
#define glDeleteRenderbuffers gr3_glDeleteRenderbuffers
#define glDeleteRenderbuffers gr3_glDeleteRenderbuffers
#define glBindRenderbufferEXT gr3_glBindRenderbufferEXT
#define glBindRenderbufferEXT gr3_glBindRenderbufferEXT
#define glCheckFramebufferStatusEXT gr3_glCheckFramebufferStatusEXT
#define glCheckFramebufferStatusEXT gr3_glCheckFramebufferStatusEXT
#define glFramebufferRenderbufferEXT gr3_glFramebufferRenderbufferEXT
#define glFramebufferRenderbufferEXT gr3_glFramebufferRenderbufferEXT
#define glRenderbufferStorageEXT gr3_glRenderbufferStorageEXT
#define glRenderbufferStorageEXT gr3_glRenderbufferStorageEXT
#define glBindFramebufferEXT gr3_glBindFramebufferEXT
#define glBindFramebufferEXT gr3_glBindFramebufferEXT
#define glGenFramebuffersEXT gr3_glGenFramebuffersEXT
#define glGenFramebuffersEXT gr3_glGenFramebuffersEXT
#define glGenRenderbuffersEXT gr3_glGenRenderbuffersEXT
#define glGenRenderbuffersEXT gr3_glGenRenderbuffersEXT
#define glDeleteFramebuffersEXT gr3_glDeleteFramebuffersEXT
#define glDeleteFramebuffersEXT gr3_glDeleteFramebuffersEXT
#define glDeleteRenderbuffersEXT gr3_glDeleteRenderbuffersEXT
#define glDeleteRenderbuffersEXT gr3_glDeleteRenderbuffersEXT

int  gr3_initGL_GLX_(void);
void gr3_terminateGL_GLX_Pbuffer_(void);
void gr3_terminateGL_GLX_Pixmap_(void);

#endif
