# tar_scm (OBS source service) [![Build Status](https://travis-ci.org/openSUSE/obs-service-tar_scm.png?branch=master)](https://travis-ci.org/openSUSE/obs-service-tar_scm)

This is an [Open Build Service](http://openbuildservice.org/) source service. It uses an SCM client to checkout or update a package by creating a source tarball from a source code repository.

It supports many options, e.g. it can adjust resulting tarball parameters, include or exclude particular files when creating this tarball or generate an rpm changelog from the SCM commit log. For the full list of options please see tar_scm.service.in.

Apart from various SCM like git, hg, bzr or svn it additionally supports `--url` option that allows you to specify URL of the upstream tarball to be downloaded.

This is the git repository for [openSUSE:Tools/obs-service-tar_scm](https://build.opensuse.org/package/show/openSUSE:Tools/obs-service-tar_scm). The authoritative source is https://github.com/openSUSE/obs-service-tar_scm

The service can be used in combination with other services like [download_files](https://github.com/openSUSE/obs-service-download_files), [extract_file](https://github.com/openSUSE/obs-service-extract_file), [recompress](https://github.com/openSUSE/obs-service-recompress) or [set_version](https://github.com/openSUSE/obs-service-set_version) e.g. within the [GIT integration](https://en.opensuse.org/openSUSE:Build_Service_Concept_SourceService#Example_2:_GIT_integration) workflow.

## Archive Formats

### obscpio
The `obscpio` archive format is the new OBS specific archive format based on `cpio` which can be consumed and generated by the [OBS Delta Store](http://openbuildservice.org/help/manuals/obs-reference-guide/cha.obs.architecture.html#delta_store) to store changes in an incremental way independently from your chosen SCM.
The `obs_scm` service generates archives in this format, which is basically the `cpio` `newc` format.

### tar
The standard `tar` archive format is used as output format by the `tar` and `tar_scm` source services.

## Services

### tar_scm
`tar_scm` is the legacy source service used to create a source tarball from a source code management tool.

### obs_scm
`obs_scm` uses the new `obscpio` archive format to store the sources.
It is recommended to use `obs_scm` in favour to `tar_scm`, because it helps to save a lot of disk space on the server side, especially when used in continuous integration (e.g. nightly builds etc.).
The usual source tarballs can be regenerated from this at build-time using the `tar` and `recompress` source services, so no changes to `.spec` files are required when switching to `obs_scm` and `obscpio`.

`obs_scm` additionally generates a file named `<package>.obsinfo` which includes useful information from your SCM system, so this data can be accessed at build-time.

### tar
The `tar` source service creates a tarball out of `obscpio` archives.

### snapcraft
The `snapcraft` source service can be used to fetch sources before building a [`snappy` app (a.k.a. *snap*)](https://snapcraft.io/).
It parses a `snapcraft.yml` file, for the SCM related parts and executes the corresponding services.

### appimage
The `appimage` source service can be used to fetch sources before building an [AppImage app](http://appimage.org/).
It parses an `appimage.yml` file for the SCM related parts and executes the corresponding services.

## Installation
The files in this top-level directory need to be installed using the following:

    make install

## Test suite

See the [TESTING.md](TESTING.md) file.

## Contributions

See the [CONTRIBUTING.md](CONTRIBUTING.md) file.
