/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int fg_flag;	/**< @brief Run in foreground (default=off).  */
  const char *fg_help; /**< @brief Run in foreground help description.  */
  int debug_flag;	/**< @brief Run in debug mode (default=off).  */
  const char *debug_help; /**< @brief Run in debug mode help description.  */
  char * conf_arg;	/**< @brief Read configuration file (default='/etc/ggsn.conf').  */
  char * conf_orig;	/**< @brief Read configuration file original value given at command line.  */
  const char *conf_help; /**< @brief Read configuration file help description.  */
  char * pidfile_arg;	/**< @brief Filename of process id file (default='/var/run/ggsn.pid').  */
  char * pidfile_orig;	/**< @brief Filename of process id file original value given at command line.  */
  const char *pidfile_help; /**< @brief Filename of process id file help description.  */
  char * statedir_arg;	/**< @brief Directory of nonvolatile data (default='/var/lib/ggsn/').  */
  char * statedir_orig;	/**< @brief Directory of nonvolatile data original value given at command line.  */
  const char *statedir_help; /**< @brief Directory of nonvolatile data help description.  */
  char * listen_arg;	/**< @brief Local interface.  */
  char * listen_orig;	/**< @brief Local interface original value given at command line.  */
  const char *listen_help; /**< @brief Local interface help description.  */
  char * net_arg;	/**< @brief Network (default='192.168.0.0/24').  */
  char * net_orig;	/**< @brief Network original value given at command line.  */
  const char *net_help; /**< @brief Network help description.  */
  char * ipup_arg;	/**< @brief Script to run after link-up.  */
  char * ipup_orig;	/**< @brief Script to run after link-up original value given at command line.  */
  const char *ipup_help; /**< @brief Script to run after link-up help description.  */
  char * ipdown_arg;	/**< @brief Script to run after link-down.  */
  char * ipdown_orig;	/**< @brief Script to run after link-down original value given at command line.  */
  const char *ipdown_help; /**< @brief Script to run after link-down help description.  */
  char * dynip_arg;	/**< @brief Dynamic IP address pool.  */
  char * dynip_orig;	/**< @brief Dynamic IP address pool original value given at command line.  */
  const char *dynip_help; /**< @brief Dynamic IP address pool help description.  */
  char * statip_arg;	/**< @brief Static IP address pool.  */
  char * statip_orig;	/**< @brief Static IP address pool original value given at command line.  */
  const char *statip_help; /**< @brief Static IP address pool help description.  */
  char * pcodns1_arg;	/**< @brief PCO DNS Server 1 (default='0.0.0.0').  */
  char * pcodns1_orig;	/**< @brief PCO DNS Server 1 original value given at command line.  */
  const char *pcodns1_help; /**< @brief PCO DNS Server 1 help description.  */
  char * pcodns2_arg;	/**< @brief PCO DNS Server 2 (default='0.0.0.0').  */
  char * pcodns2_orig;	/**< @brief PCO DNS Server 2 original value given at command line.  */
  const char *pcodns2_help; /**< @brief PCO DNS Server 2 help description.  */
  int timelimit_arg;	/**< @brief Exit after timelimit seconds (default='0').  */
  char * timelimit_orig;	/**< @brief Exit after timelimit seconds original value given at command line.  */
  const char *timelimit_help; /**< @brief Exit after timelimit seconds help description.  */
  char * apn_arg;	/**< @brief Access point name (default='internet').  */
  char * apn_orig;	/**< @brief Access point name original value given at command line.  */
  const char *apn_help; /**< @brief Access point name help description.  */
  int qos_arg;	/**< @brief Requested quality of service (default='0x0b921f').  */
  char * qos_orig;	/**< @brief Requested quality of service original value given at command line.  */
  const char *qos_help; /**< @brief Requested quality of service help description.  */
  char * logfile_arg;	/**< @brief Logfile for errors.  */
  char * logfile_orig;	/**< @brief Logfile for errors original value given at command line.  */
  const char *logfile_help; /**< @brief Logfile for errors help description.  */
  char * loglevel_arg;	/**< @brief Global log ldevel (default='error').  */
  char * loglevel_orig;	/**< @brief Global log ldevel original value given at command line.  */
  const char *loglevel_help; /**< @brief Global log ldevel help description.  */
  int gtp_linux_flag;	/**< @brief GTP linux kernel support (default=off).  */
  const char *gtp_linux_help; /**< @brief GTP linux kernel support help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int fg_given ;	/**< @brief Whether fg was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int conf_given ;	/**< @brief Whether conf was given.  */
  unsigned int pidfile_given ;	/**< @brief Whether pidfile was given.  */
  unsigned int statedir_given ;	/**< @brief Whether statedir was given.  */
  unsigned int listen_given ;	/**< @brief Whether listen was given.  */
  unsigned int net_given ;	/**< @brief Whether net was given.  */
  unsigned int ipup_given ;	/**< @brief Whether ipup was given.  */
  unsigned int ipdown_given ;	/**< @brief Whether ipdown was given.  */
  unsigned int dynip_given ;	/**< @brief Whether dynip was given.  */
  unsigned int statip_given ;	/**< @brief Whether statip was given.  */
  unsigned int pcodns1_given ;	/**< @brief Whether pcodns1 was given.  */
  unsigned int pcodns2_given ;	/**< @brief Whether pcodns2 was given.  */
  unsigned int timelimit_given ;	/**< @brief Whether timelimit was given.  */
  unsigned int apn_given ;	/**< @brief Whether apn was given.  */
  unsigned int qos_given ;	/**< @brief Whether qos was given.  */
  unsigned int logfile_given ;	/**< @brief Whether logfile was given.  */
  unsigned int loglevel_given ;	/**< @brief Whether loglevel was given.  */
  unsigned int gtp_linux_given ;	/**< @brief Whether gtp-linux was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
