#!/usr/bin/env bash
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################

# Cross compile this project and its dependencies
./build.sh

# Get the latest Raspbian image and enlarge it so there is enough space to
# install to it.
sudo ./prepare_img.sh

# Sync with image
sudo rsync -avz --no-p --no-g --chmod=ugo=rwX tmp/ raspbian-root/usr
sudo proot -Q qemu-arm -B -r raspbian-root -b raspbian-boot:/boot sudo ldconfig

# Umount image
sync; sudo umount ./raspbian-boot ./raspbian-root
# Make sure all allocated loop devices are free'd
for i in {0..7};
do
    sudo sudo dmsetup clear loop${i}p1 &&
    sudo sudo dmsetup clear loop${i}p2 &&
    sudo sudo dmsetup remove loop${i}p1 &&
    sudo sudo dmsetup remove loop${i}p2 &&
    sudo sudo losetup -d /dev/loop$i
done
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
