#!/usr/bin/env bash
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
# Parse parameters
while [[ $# -gt 0 ]]; do
    key="$1"
    case $key in
        -i|--incremental)
        INCREMENTAL=0
        ;;
        -u|--update)
        UPDATE=0
        ;;
        *)
                # unknown option
        ;;
    esac
    shift # past argument or value
done

if [ $INCREMENTAL ] && [ $UPDATE ]; then
    echo Error: Incremental and update are exclusiv!
    exit -1
fi

# Download cross compiler and sysroot
if [ ! -d $PWD/tools ]; then
    git clone --depth 1 https://github.com/raspberrypi/tools
fi
if [ $UPDATE ]; then
    ( cd tools && git pull --rebase ) || exit 1
fi

# Cross build for the Raspberry Pi
mkdir -p $PWD/tmp
BUILD_PREFIX=$PWD/tmp
TOOLCHAIN_HOST="arm-linux-gnueabihf"
TOOLCHAIN_PATH="${PWD}/tools/arm-bcm2708/arm-rpi-4.9.3-linux-gnueabihf/bin"
SYSROOT=$PWD/tools/arm-bcm2708/arm-rpi-4.9.3-linux-gnueabihf/arm-linux-gnueabihf/sysroot

CFLAGS="--sysroot=${SYSROOT} -I${BUILD_PREFIX}/include"
CPPFLAGS="--sysroot=${SYSROOT} -I${BUILD_PREFIX}/include"
CXXFLAGS="--sysroot=${SYSROOT} -I${BUILD_PREFIX}/include"
LDFLAGS="-L${BUILD_PREFIX}/lib"

CONFIG_OPTS=()
CONFIG_OPTS+=("CFLAGS=${CFLAGS}")
CONFIG_OPTS+=("CPPFLAGS=${CPPFLAGS}")
CONFIG_OPTS+=("CXXFLAGS=${CXXFLAGS}")
CONFIG_OPTS+=("LDFLAGS=${LDFLAGS}")
CONFIG_OPTS+=("PKG_CONFIG_DIR=")
CONFIG_OPTS+=("PKG_CONFIG_LIBDIR=${SYSROOT}/usr/lib/arm-linux-gnueabihf/pkgconfig:${SYSROOT}/usr/share/pkgconfig")
CONFIG_OPTS+=("PKG_CONFIG_SYSROOT=${SYSROOT}")
CONFIG_OPTS+=("PKG_CONFIG_PATH=${BUILD_PREFIX}/lib/pkgconfig")
CONFIG_OPTS+=("--prefix=${BUILD_PREFIX}")
CONFIG_OPTS+=("--host=${TOOLCHAIN_HOST}")
CONFIG_OPTS+=("--with-docs=no")

CPP="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-cpp"
CC="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-gcc"
CXX="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-g++"
LD="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-ld"
AS="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-as"
AR="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-ar"
RANLIB="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-ranlib"

CONFIG_OPTS+=("CPP=${CPP}")
CONFIG_OPTS+=("CC=${CC}")
CONFIG_OPTS+=("CXX=${CXX}")
CONFIG_OPTS+=("LD=${LD}")
CONFIG_OPTS+=("AS=${AS}")
CONFIG_OPTS+=("AR=${AR}")
CONFIG_OPTS+=("RANLIB=${RANLIB}")

if [ ! $INCREMENTAL ]; then
    # Clone and build dependencies
    if [ ! -e libzmq ]; then
        git clone --quiet --depth 1 https://github.com/zeromq/libzmq.git libzmq
    fi
    pushd libzmq
    (
        if [ $UPDATE ]; then
            git pull --rebase
        fi
        git --no-pager log --oneline -n1
        if [ -e autogen.sh ]; then
            ./autogen.sh 2> /dev/null
        fi
        if [ -e buildconf ]; then
            ./buildconf 2> /dev/null
        fi
        if [ ! -e autogen.sh ] && [ ! -e buildconf ] && [ ! -e ./configure ] && [ -s ./configure.ac ]; then
            libtoolize --copy --force && \
            aclocal -I . && \
            autoheader && \
            automake --add-missing --copy && \
            autoconf || \
            autoreconf -fiv
        fi
        ./configure "${CONFIG_OPTS[@]}"
        make -j4
        make install
    ) || exit 1
    popd

fi

# Cross build this project
pushd ../..
(
    ./autogen.sh 2> /dev/null
    ./configure --enable-drafts=yes "${CONFIG_OPTS[@]}"
    make -j4
    make install
) || exit 1
popd

################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
