/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/

#include "QmlZyreEvent.h"


///
//  Returns event type, as printable uppercase string. Choices are:   
//  "ENTER", "EXIT", "JOIN", "LEAVE", "EVASIVE", "WHISPER" and "SHOUT"
//  and for the local node: "STOP"                                    
const QString QmlZyreEvent::type () {
    return QString (zyre_event_type (self));
};

///
//  Return the sending peer's uuid as a string
const QString QmlZyreEvent::peerUuid () {
    return QString (zyre_event_peer_uuid (self));
};

///
//  Return the sending peer's public name as a string
const QString QmlZyreEvent::peerName () {
    return QString (zyre_event_peer_name (self));
};

///
//  Return the sending peer's ipaddress as a string
const QString QmlZyreEvent::peerAddr () {
    return QString (zyre_event_peer_addr (self));
};

///
//  Returns the event headers, or NULL if there are none
zhash_t *QmlZyreEvent::headers () {
    return zyre_event_headers (self);
};

///
//  Returns value of a header from the message headers   
//  obtained by ENTER. Return NULL if no value was found.
const QString QmlZyreEvent::header (const QString &name) {
    return QString (zyre_event_header (self, name.toUtf8().data()));
};

///
//  Returns the group name that a SHOUT event was sent to
const QString QmlZyreEvent::group () {
    return QString (zyre_event_group (self));
};

///
//  Returns the incoming message payload; the caller can modify the
//  message but does not own it and should not destroy it.         
zmsg_t *QmlZyreEvent::msg () {
    return zyre_event_msg (self);
};

///
//  Returns the incoming message payload, and pass ownership to the   
//  caller. The caller must destroy the message when finished with it.
//  After called on the given event, further calls will return NULL.  
zmsg_t *QmlZyreEvent::getMsg () {
    return zyre_event_get_msg (self);
};

///
//  Print event to zsys log
void QmlZyreEvent::print () {
    zyre_event_print (self);
};


QObject* QmlZyreEvent::qmlAttachedProperties(QObject* object) {
    return new QmlZyreEventAttached(object);
}


///
//  Self test of this class.
void QmlZyreEventAttached::test (bool verbose) {
    zyre_event_test (verbose);
};

///
//  Constructor: receive an event from the zyre node, wraps zyre_recv.
//  The event may be a control message (ENTER, EXIT, JOIN, LEAVE) or  
//  data (WHISPER, SHOUT).                                            
QmlZyreEvent *QmlZyreEventAttached::construct (QmlZyre *node) {
    QmlZyreEvent *qmlSelf = new QmlZyreEvent ();
    qmlSelf->self = zyre_event_new (node->self);
    return qmlSelf;
};

///
//  Destructor; destroys an event instance
void QmlZyreEventAttached::destruct (QmlZyreEvent *qmlSelf) {
    zyre_event_destroy (&qmlSelf->self);
};

/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/
